/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* tissue api                                                                 */
/******************************************************************************/

#include "log.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <err.h>

static FILE *logfp = NULL;  /* logfile */

void open_logfile(void)
{
	if(!(logfp = fopen(TS_LOGFILE, "w")))
		err(1, "couldn't open logfile");
}

/* tissue logfile functions */
void writelog_tissue(char *message, int level)
{
	static struct timeval curtime;

	switch(level) {
		case LOG_ERROR:
			fprintf(logfp, "error: %s\n", message);
			break;

		case LOG_FATAL:
			fprintf(logfp, "fatal: %s\n", message);
			break;

		case LOG_TIME:
			gettimeofday(&curtime, NULL);
			fprintf(logfp, "%d.%06d %s\n", (int) curtime.tv_sec, \
					(int) curtime.tv_usec, message);
			break;

		case LOG_INFO:
		default:
			fprintf(logfp, "%s\n", message);
			break;
	}
}

void logfatal_tissue(char *message)
{
	writelog_tissue(message, LOG_FATAL);
	fprintf(stderr, "fatal error: %s\n", message);
	close_logfile();
	exit(EXIT_FAILURE);
}

void close_logfile(void)
{
	if(logfp)
		fclose(logfp);
}
