#!/usr/bin/perl
use DBI;

# - a script to be called at the end of a session step in order to make a copy of results and  clear all server-side changes, and finally restart the apache server

# arg 0 - session step number
# arg 1 - topic name

if(scalar @ARGV < 2) {die "check usage\n";}

print "Wating for dd to complete processing...\n";
if($ARGV[0] ne "init") {
	sleep 180; # Give time for periodic processes to complete
}


# clear cache directory
@args1 = ("rm /var/www/phpbb3/cache/*");
system(@args1);

# clear all upload files that are stored by their uploadname - distinguished by having an extension
@args1 = ("rm /var/www/phpbb3/files/*.*");
system(@args1);

# clear db records and updated tampered records

$dbh = DBI->connect("dbi:mysql:database=phpbb3;host=localhost;port=3306", "root", "root");
$sql = "select topic_id from phpbb_topics where topic_title = '$ARGV[1]' ";
$select = $dbh->prepare($sql);
$select->execute();
$row = $select->fetchrow_hashref;
$topic_id = $row->{topic_id};


$sql = "delete from phpbb_posts where topic_id = $topic_id ";
$dbh->do($sql);

$sql = "delete from phpbb_topics where topic_id = $topic_id ";
$dbh->do($sql);

$sql = "update phpbb_posts p set p.post_text = SUBSTRING_INDEX(p.post_text,'<script>',1)";
$dbh->do($sql);

# reset dd
print "Shutting off dd client...\n";

open(PS, "ps -e \| grep httpt |");
@ps = <PS>;
foreach $psline (@ps)
{
	$psline =~ /^\s*(\d+)\s*/;
	$pid = $1;
	system("kill $pid");
}
close(PS);

print "Shutting off tshark...\n";

open(PS, "ps -e \| grep tshark |"); # very important to kill probe or will consume HD space
@ps = <PS>;
foreach $psline (@ps)
{
	$psline =~ /^\s*(\d+)\s*/;
	$pid = $1;
	system("kill $pid");
}
close(PS);


open(PS, "ps -e \| grep dumpcap |"); # very important to kill probe or will consume HD space
@ps = <PS>;
foreach $psline (@ps)
{
	$psline =~ /^\s*(\d+)\s*/;
	$pid = $1;
	system("kill $pid");
}
close(PS);

system("rm /tmp/ether*");


# restart apache
print "Restart web server...\n";
system("/etc/init.d/apache2 restart");

print "Shutting off dd server + make copy of results...\n";


open(SSH, "| ssh 192.168.147.129");
print SSH "kill `pidof perl`\n";
print SSH "mkdir /home/mvella/workbench/r10/results/step$ARGV[0]\n";
print SSH "cp -r /home/mvella/workbench/dd/sandbox/httptalertsq /home/mvella/workbench/r10/results/step$ARGV[0]\n";
print SSH "cp -r /home/mvella/workbench/dd/sandbox/httptdangerq /home/mvella/workbench/r10/results/step$ARGV[0]\n";
print SSH "cp -r /home/mvella/workbench/dd/sandbox/httptpampq /home/mvella/workbench/r10/results/step$ARGV[0]\n";
print SSH "cp -r /home/mvella/workbench/dd/sandbox/httptprimeq /home/mvella/workbench/r10/results/step$ARGV[0]\n";
print SSH "cd /home/mvella/workbench/dd/sandbox\n";
print SSH "rm -r httpt*q/*\n";
print SSH "logout\n";
close(SSH);

print "Starting dd...\n";


open(SSH, "| ssh 192.168.147.129");
print SSH "cd /home/mvella/workbench/dd/sandbox\n";
print SSH "./starthttpt.pl 1> /dev/null 2> /dev/null \& \n";
print "logout\n";
close(SSH);

sleep 10; # wait for server start-up
chdir "/home/mvella/workbench/dd/sigprobes";
@args1 = ("./starthttpt.pl 1> /dev/null 2> /dev/null \&");
system(@args1);
sleep 20; #!!!!!  wait for probes to kick-start


