#!/usr/bin/perl

# signprobe - wpt prime-suspect signals
# Requires tshark


# arg0 - sandbox ip
# arg1 - sandbox porte
# arg2 - HTTP port optional default:80

if (scalar @ARGV < 2) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';

# process input arguments
$port = 80;
if ($arg2) {$port = $arg2};

#launch tshark
open(TSHARK, " tshark -V -f \"dst port $port\" -R \"http\" |");

#start reading HTTP requests
$httprequest = ""; 
$first = 1;

while($tsharkline = <TSHARK>)
{

	#send completed packet to output
	if($tsharkline =~ /Frame \d+/i)
	{
		if ($first)
		{
			$first = 0; #avoid sending a first empty HTTP request to sandbox
		} else {
			print STDOUT $httprequest;
		}

		#start next packet
		$httprequest = "$tsharkline";
	} else {
		#get current packet
		$httprequest = $httprequest.$tsharkline;
	}


}
