#!/usr/bin/perl

# signprobe - wrt danger signals client probe
# Requires strace

use IO::Socket::INET;
use Time::HiRes;

# arg0 - sandbox ip
# arg1 - sandbox port
# arg2 - webroot path
# arg3 - interval mode start timestamp

if (scalar @ARGV < 4) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#flush all outout buffers
$|=1;

sub createmodfilelist {


	open(FIND, "find -L $ARGV[2] -type f -mmin 1 |");
	@lines = <FIND>;
	foreach $line (@lines)
	{
		chomp($line);
		push(@modifiedfiles, $line);
	}
	close(FIND);

}


sub createfilelist {

open(LS, "ls -mARL $ARGV[2] |");
@lines = <LS>;

$currdir = "";
$filestring = "";
@filearray = ();

foreach $line (@lines)
{
	if($line !~ /^\s+/)
	{

	if ($line =~ m|^/.*|)
	{
		chomp($line); chop($line);
		$currdir = $line;	
	}

	if ($line !~ m|^/.*|)
	{
		chomp($line); 
		if ( rindex($line, ",") == (length($line)-1) ) { chop($line) };
		@files = split(", ", $line);
	
		foreach $file (@files)
		{
			$filename = $currdir.'/'.$file;	
			push(@filearray, $filename);
		}
	}

	}

}

$filestring = join(" ",@filearray);

}


sub checkcreatedfiles {

	foreach $fileentry (@filearray)
	{
		if($prevfilestring !~ /$fileentry/)
		{
			chomp($fileentry);
			push(@cdfiles, $fileentry);	

		}

	}

}


sub checkdeletedfiles {


	foreach $prevfileentry (@prevfilearray)
	{
		if($filestring !~ /$prevfileentry/)
		{
			chomp($prevfileentry);
			push(@cdfiles, $prevfileentry);	

		}

	}

}


print STDOUT "Starting wrtdangercl";

#create connection with server
$conn = IO::Socket::INET->new(PeerAddr => $ARGV[0],
				PeerPort => $ARGV[1],
				Proto => 'tcp') or die "Cannot connect to server\n"; 

#initialization
$filestring = "";
@filearray = ();
&createfilelist;

#start filesystem probing
while(1)
{

	#instr
        $instrstartts = Time::HiRes::time;

	#d1 - modified files
	@modifiedfiles = ();
	&createmodfilelist;

	#send code/key string to output
	foreach $modfile (@modifiedfiles)
	{
		$dangersignal =  "d1: $modfile\n";
		print $conn $dangersignal;

                #instr
                $interval = (($instrstartts-$ARGV[3])/60)%5;
                if($interval == 0 || $ARGV[3] == 0 || 1==1 )
                {
                	$instrid = $modfile;
                	open(INSTRF, ">>wrtperflogs/wrtdangercl.log");
                	$instrendts = Time::HiRes::time;
                	print INSTRF "\"$instrid\",\"$instrstartts\",\"$instrendts\"\n";
                	close(INSTRF);
                }

	}


        #instr
        $instrstartts = Time::HiRes::time;

	#d2
	@cdfiles = ();
	$prevfilestring = $filestring;
	@prevfilearray = @filearray; 

	#call createfilelist
	&createfilelist;

	#check for added files
	#&checkcreatedfiles; # Commented out since in this particula file-environment (ext file-system) we cannot distinguish between newly created files and a modified file; if not commented out we would end up with 2 symptom alers for evert newly created file

	#check for deleted file
	&checkdeletedfiles;

	#send code/key string to output
	foreach $cdfile (@cdfiles)
	{
		$dangersignal =  "d2: $cdfile\n";
		print $conn $dangersignal;


                #instr
                $interval = (($instrstartts-$ARGV[3])/60)%5;
                if($interval == 0 || $ARGV[3] == 0 || 1==1 )
                {
                        $instrid = $cdfile;
                        open(INSTRF, ">>wrtperflogs/wrtdangercl.log");
                        $instrendts = Time::HiRes::time;
                        print INSTRF "\"$instrid\",\"$instrstartts\",\"$instrendts\"\n";
                        close(INSTRF);
                }

	}

        sleep 30; #had to choose between generating extra symtpom alerts or over-burdening the machine with a busy-wait loop

}




