#!/usr/bin/perl

#arg0 = step number

if(scalar @ARGV < 1){die "check usage\n";}

$astart = 0;
$aend = 0;
$bstart = 0;
$bend = 0;
$cstart = 0;
$cend = 0;
$dstart = 0;
$dend = 0;
$estart = 0;
$eend = 0;
$psid = "";
$did = "";


@acolumn =  ();
@bcolumn =  ();
@ccolumn =  ();
@dcolumn =  ();
@ecolumn =  ();
@pscolumn =  ();
@symcolumn =  ();

$cumtotal = 0;
$ccumtotal = 0;
$avg = 0;
$cavg = 0;
$entries = 0;
$centries = 0;
$cpoint = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/wrtperflogs/wrtpampcl.log");
while($line = <F>)
{
	$start = $end = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$start = $2;
	$end = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		$avg = $cumtotal / $entries;
		push(@acolumn, "$avg");
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

		open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtdangercl.log");
		while($link2line = <FLINK2>) # associated entries are all that fall between cpoint and start, if zero take prev average
		{
			$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
			$timepoint = $2;
			$dur = ($3-$2);	
			if($timepoint >= $start)
			{
				last;
			}
			if($timepoint >= $cpoint && $timepoint < $start)
			{
				$ccumtotal += $dur;
				$centries ++
			}
			
		}
		if($centries >0)
		{
			$cavg = $ccumtotal / $centries;
			push(@ccolumn, "$cavg");
			$ccumtotal = 0;
			$cavg = 0;
			$centries = 0;
		} else {
			$repeat = $ccolumn[-1];
			push(@ccolumn, "$repeat");
		}
		close(FLINK2);
		$cpoint = $start;



	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@acolumn, "0");
		}
	}
	}

	$cumtotal += ($end-$start);
	$prevstart = $start;
	$entries++;
}
close(F);
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	$avg = $cumtotal / $entries;
	push(@acolumn, "$avg");
	open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtdangercl.log");
	while($link2line = <FLINK2>) # associated entries are all that fall between cpoint and start, if zero take prev average
	{
		$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
		$timepoint = $2;
		$dur = ($3-$2);	
		if($timepoint >= $start)
		{
			last;
		}
		if($timepoint >= $cpoint && $timepoint < $start)
		{
			$ccumtotal += $dur;
			$centries ++
		}
		
	}
	if($centries >0)
	{
		$cavg = $ccumtotal / $centries;
		push(@ccolumn, "$cavg");
		$ccumtotal = 0;
		$cavg = 0;
		$centries = 0;
	} else {
		$repeat = $ccolumn[-1];
		push(@ccolumn, "$repeat");
	}
	close(FLINK2);
}

@linkcolumn = ();
$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(FLINK,"<step$ARGV[0]/wrtperflogs/wrtpamps.log");
while($linkline = <FLINK>)
{
	$start = $end = 0;
	$linkline =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$start = $2;
	$end = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		$avg  = $cumtotal /$entries;
		push(@linkcolumn, "$avg");
		$cumtotal = 0;
		$entries = 0;
		$avg = 0;
	}

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@linkcolumn, "0");
		}
	}

	$cumtotal += $end;
	$prevstart = $start;
	$entries++;

}
close(FLINK);
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	$avg  = $cumtotal /$entries;
	push(@linkcolumn, "$avg");
}

$cumtotal = 0;
$dcumtotal = 0;
$ecumtotal = 0;
$avg = 0;
$davg = 0;
$eavg = 0;
$entries = 0;
$dentries = 0;
$eentries = 0;
$firstentry=1;
$dpoint=0;
$epoint=0;
$iter=0;
open(F,"<step$ARGV[0]/wrtperflogs/wrtpampsinit.log");
while($line = <F>)
{
	$id = $start = $end = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$id = $1;
	$start = $2;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		if($linkcolumn[$iter]>0)
		{
			$avg = $linkcolumn[$iter] - ($cumtotal/$entries);
			push(@bcolumn, "$avg");
		} else {
			push(@bcolumn, "0");
		}
		$iter++;
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

		open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtdangers.log");
		while($link2line = <FLINK2>) # associated entries are all that fall between cpoint and start, if zero take prev average
		{
			$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
			$timepoint = $2;
			$dur = ($3-$2);	
			if($timepoint >= $start)
			{
				last;
			}
			if($timepoint >= $dpoint && $timepoint < $start)
			{
				$dcumtotal += $dur;
				$dentries ++
			}
			
		}
		if($dentries >0)
		{
			$davg = $dcumtotal / $dentries;
			push(@dcolumn, "$davg");
			$dcumtotal = 0;
			$davg = 0;
			$dentries = 0;
		} else {
			$repeat = $dcolumn[-1];
			push(@dcolumn, "$repeat");
		}
		close(FLINK2);
		$dpoint = $start;
	

		open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtattackid.log");
		while($link2line = <FLINK2>) # associated entries are all that fall between epoint and start, if zero take prev average
		{
			$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
			$timepoint = $2;
			$dur = ($3-$2);
			if($timepoint >= $start)
			{
				last;
			}
			if($timepoint >= $epoint && $timepoint < $start)
			{
				$ecumtotal += $dur;
				$eentries ++
			}
			
		}
		if($eentries >0)
		{
			$eavg = $ecumtotal / $eentries;
			push(@ecolumn, "$eavg");
			$ecumtotal = 0;
			$eavg = 0;
			$eentries = 0;
		} else {
			$repeat = $ecolumn[-1];
			push(@ecolumn, "$repeat");
		}
		close(FLINK2);
		$epoint = $start;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@bcolumn, "0");
			$iter++;
			$repeat = $dcolumn[-1];
			push(@dcolumn, "$repeat");
			$repeat = $ecolumn[-1];
			push(@ecolumn, "$repeat");
		}
	}
	}

	$cumtotal += $start;
	$prevstart = $start;
	$entries++;
}
close(F);
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	if($linkcolumn[$iter]>0)
	{
		$avg = $linkcolumn[$iter] - ($cumtotal/$entries);
		push(@bcolumn, "$avg");
	} else {
		push(@bcolumn, "0");
	}

	open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtdangers.log");
	while($link2line = <FLINK2>) # associated entries are all that fall between cpoint and start, if zero take prev average
	{
		$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
		$timepoint = $2;
		$dur = ($3-$2);	
		if($timepoint >= $start)
		{
			last;
		}
		if($timepoint >= $dpoint && $timepoint < $start)
		{
			$dcumtotal += $dur;
			$dentries ++
		}
		
	}
	if($dentries >0)
	{
		$davg = $dcumtotal / $dentries;
		push(@dcolumn, "$davg");
		$dcumtotal = 0;
		$davg = 0;
		$dentries = 0;
	} else {
		$repeat = $dcolumn[-1];
		push(@dcolumn, "$repeat");
	}
	close(FLINK2);


	open(FLINK2, "<step$ARGV[0]/wrtperflogs/wrtattackid.log");
	while($link2line = <FLINK2>) # associated entries are all that fall between epoint and start, if zero take prev average
	{
		$link2line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
		$timepoint = $2;
		$dur = ($3-$2);
		if($timepoint >= $start)
		{
			last;
		}
		if($timepoint >= $epoint && $timepoint < $start)
		{
			$ecumtotal += $dur;
			$eentries ++
		}
		
	}
	if($eentries >0)
	{
		$eavg = $ecumtotal / $eentries;
		push(@ecolumn, "$eavg");
		$ecumtotal = 0;
		$eavg = 0;
		$eentries = 0;
	} else {
		$repeat = $ecolumn[-1];
		push(@ecolumn, "$repeat");
	}
	close(FLINK2);
}



$pscumtotal = $symcumtotal =  0;
$psavg =  $symavg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/wrtperflogs/wrtrepsnapshots.log");
while($line = <F>)
{
	$start = $end = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$start = $1;
	$pssize = $2;
	$symsize = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		$psavg = $pscumtotal / $entries;
		push(@pscolumn, "$psavg");
		$symavg = $symcumtotal / $entries;
		push(@symcolumn, "$symavg");
		$pscumtotal = $symcumtotal = 0;
		$psavg = $symavg = 0;
		$entries = 0;

	}

	$pscumtotal += $pssize;
	$symcumtotal += $symsize;
	$prevstart = $start;
	$entries++;
}
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	$psavg = $pscumtotal / $entries;
	push(@pscolumn, "$psavg");
	$symavg = $symcumtotal / $entries;
	push(@symcolumn, "$symavg");
}
close(F);


# display info.
$len = scalar @acolumn;
print STDERR "\nA list is $len in length\n";
print STDERR "====\n";
foreach $entry (@acolumn)
{
	#print STDERR "$entry\n";
}
$len = scalar @bcolumn;
print STDERR "\nB list is $len in length\n";
print STDERR "====\n";
foreach $entry (@bcolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @ccolumn;
print STDERR "\nC list is $len in length\n";
print STDERR "====\n";
foreach $entry (@ccolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @dcolumn;
print STDERR "\nD list is $len in length\n";
print STDERR "====\n";
foreach $entry (@dcolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @ecolumn;
print STDERR "\nE list is $len in length\n";
print STDERR "====\n";
foreach $entry (@ecolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @pscolumn;
print STDERR "\nPS list is $len in length\n";
print STDERR "====\n";
foreach $entry (@pscolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @symcolumn;
print STDERR "\nSym list is $len in length\n";
print STDERR "====\n";
foreach $entry (@symcolumn)
{
	#print STDERR "$entry\n";
}

#create output
$i=0;
print "\"A\",\"B\",\"C\",\"D\",\"E\",\"PS\",\"SYM\"\n";
foreach $acell (@acolumn)
{
	$a = $acolumn[$i];
	$b = $bcolumn[$i];
	$c = $ccolumn[$i];
	$d = $dcolumn[$i];
	$e = $ecolumn[$i];
	$ps = $pscolumn[$i];
	$sym = $symcolumn[$i];
	print "\"$a\",\"$b\",\"$c\",\"$d\",\"$e\",\"$ps\",\"$sym\"\n";
	$i++;
}



