#!/usr/bin/perl

# A scripts that calculates the signal scaling factors for the botnet experiment
# Signal 1 - icmp69; Signal 2 - outbound traffic rate per sec; Signal 3 - rate of change of outbound traffic per sec

if(scalar @ARGV < 4) { die "check usage\n"; }

#arg0 - max_sig_value1 (e.g. 100)
#arg1 - max_sig_value2 (e.g. 100)
#arg2 - max_sig_value3 (e.g. 10)
#arg3 - path of directory storing datasessions


# max values
$max_sig_1 = 0;
$max_sig_2 = 0;
$max_sig_3 = 0;

# signal scaling factors 
$scaling_factor_1 = 1;
$scaling_factor_2 = 1;
$scaling_factor_3 = 1;


$max_sig_value1 = $ARGV[0];
$max_sig_value2 = $ARGV[1];
$max_sig_value3 = $ARGV[2];
print "Calculating signal scaling factors for max_sig_values = $max_sig_value1 $max_sig_value2 $max_sig_value3\n\n";

# Calculating max values
# Looping through normal sessions
print "Processing normal sessions\n";
for($i=1; $i<11; $i++)
{
	open(FP, "<$ARGV[3]/botnet.normal$i\.log") or die "Couldn't open file $ARGV[3]/botnet.normal$i\.log $?";
	while( $inline = <FP> )
	{
		($a, $b) = split(" ", $inline);
		if($b =~ /signal/) 
		{
			($a,$b,$c,$d,$e,$f,$g) = split(" ", $inline);
			if ($e > $max_sig_1) { $max_sig_1 = $e; }
			if ($f > $max_sig_2) { $max_sig_2 = $f; }
			if ($g > $max_sig_3) { $max_sig_3 = $g; }
		}

	}
}


# Looping through attack sessions
print "Processing attack sessions\n";
for($i=1; $i<11; $i++)
{


	open(FP, "<$ARGV[3]/botnet.attack$i\.log") or die "Couldn't open file $ARGV[3]/botnet.attack$i\.log $?";
	while( $inline = <FP> )
	{
		($a, $b) = split(" ", $inline);
		if($b =~ /signal/) 
		{
			($a,$b,$c,$d,$e,$f,$g) = split(" ", $inline);
			if ($e > $max_sig_1) { $max_sig_1 = $e; }
			if ($f > $max_sig_2) { $max_sig_2 = $f; }
			if ($g > $max_sig_3) { $max_sig_3 = $g; }
		}

	}
}


# Looping through control sessions
print "Processing control sessions\n";
for($i=1; $i<11; $i++)
{
	open(FP, "<$ARGV[3]/botnet.control$i\.log") or die "Couldn't open file $ARGV[3]/botnet.control$i\.log $?";
	while( $inline = <FP> )
	{
		($a, $b) = split(" ", $inline);
		if($b =~ /signal/) 
		{
			($a,$b,$c,$d,$e,$f,$g) = split(" ", $inline);
			if ($e > $max_sig_1) { $max_sig_1 = $e; }
			if ($f > $max_sig_2) { $max_sig_2 = $f; }
			if ($g > $max_sig_3) { $max_sig_3 = $g; }
		}

	}
}

# Looping through original sessions
print "Processing original sessions\n";
for($i=1; $i<51; $i++)
{
	open(FP, "<$ARGV[3]/botnet.orig$i\.log") or die "Couldn't open file $ARGV[3]/botnet.orig$i\.log $?";
	while( $inline = <FP> )
	{
		($a, $b) = split(" ", $inline);
		if($b =~ /signal/) 
		{
			($a,$b,$c,$d,$e,$f,$g) = split(" ", $inline);
			if ($e > $max_sig_1) { $max_sig_1 = $e; }
			if ($f > $max_sig_2) { $max_sig_2 = $f; }
			if ($g > $max_sig_3) { $max_sig_3 = $g; }
		}

	}
}

close(FP);


# Calculating scaling factors
$scaling_factor_1 = $max_sig_value1 / $max_sig_1 if ($max_sig_1) > 0;
$scaling_factor_2 = $max_sig_value2 / $max_sig_2 if ($max_sig_2) > 0;
$scaling_factor_3 = $max_sig_value3 / $max_sig_3 if ($max_sig_3) > 0;


# Output scaling factor for the three signals


print "\n";
print "Results:\n";
print "=======\n";
print "\n";
print "Max value for Signal 1: $max_sig_1\n";
print "Max value for Signal 2: $max_sig_2\n";
print "Max value for Signal 3: $max_sig_3\n";
print "\n";
print "Scaling factor for Signal 1: $scaling_factor_1\n";
print "Scaling factor for Signal 2: $scaling_factor_2\n";
print "Scaling factor for Signal 3: $scaling_factor_3\n";
print "\n";
print "=======\n";
print "\n";

