/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* producer api                                                               */
/******************************************************************************/

#include "producer.h"

#include <stdlib.h>
#include <err.h>
#include <string.h>

Cytokine_Producer *init_cytokine_producer(void)
{
	Cytokine_Producer *cytokine_producer;

	if(!(cytokine_producer = malloc(sizeof(Cytokine_Producer))))
		err(1, "couldn't allocate memory for cytokine producer");

	return cytokine_producer;
}

void free_cytokine_producer(Cytokine_Producer *cytokine_producer)
{
	if(!cytokine_producer)
		return;
	free(cytokine_producer);
}

Antigen_Producer *init_antigen_producer(void)
{
	Antigen_Producer *antigen_producer;

	if(!(antigen_producer = malloc(sizeof(Antigen_Producer))))
		err(1, "couldn't allocate memory for antigen producer");
	/* defaults */
	antigen_producer->antigen = NULL;
	antigen_producer->efficiency = 1.0;  /* maximum efficiency */
	antigen_producer->action_time = 1;
	antigen_producer->active = 0;
	antigen_producer->destroy = 1;  /* remove antigen from cell's store */

	return antigen_producer;
}

void free_antigen_producer(Antigen_Producer *antigen_producer)
{
	if(!antigen_producer)
		return;
	if(antigen_producer->antigen)
		free_antigen(antigen_producer->antigen);
	free(antigen_producer);
}

Response_Producer *init_response_producer(void)
{
	Response_Producer *response_producer;

	if(!(response_producer = malloc(sizeof(Response_Producer))))
		err(1, "couldn't allocate memory for response producer");
	/* defaults */
	response_producer->antigen = NULL;
	response_producer->response = NULL;

	return response_producer;
}

void free_response_producer(Response_Producer *response_producer)
{
	if(!response_producer)
		return;
	if(response_producer->antigen)
		free_antigen(response_producer->antigen);
	if(response_producer->response)
		free(response_producer->response);
	free(response_producer);
}

void set_rp_antigen(Response_Producer *rp, Antigen *antigen)
{
	free_antigen(rp->antigen);
	rp->antigen = dup_antigen(antigen);
}

void set_rp_response(Response_Producer *rp, char *response)
{
	if(rp->response)
		free(rp->response);
	if(!(rp->response = calloc(strlen(response) + 1, sizeof(char))))
		err(1, "couldn't allocate memory for response");
	strncpy(rp->response, response, strlen(response) + 1);
}
