/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* receptor api                                                               */
/******************************************************************************/

#include "receptor.h"

#include <stdlib.h>
#include <err.h>

Antigen_Receptor *init_antigen_receptor(void)
{
	Antigen_Receptor *antigen_receptor;

	if(!(antigen_receptor = malloc(sizeof(Antigen_Receptor))))
		err(1, "couldn't allocate memory for antigen receptor");

	return antigen_receptor;
}

void free_antigen_receptor(Antigen_Receptor *antigen_receptor)
{
	if(!antigen_receptor)
		return;
	free(antigen_receptor);
}

Cytokine_Receptor *init_cytokine_receptor(void)
{
	Cytokine_Receptor *cytokine_receptor;

	if(!(cytokine_receptor = malloc(sizeof(Cytokine_Receptor))))
		err(1, "couldn't allocate memory for cytokine receptor");
	/* defaults */
	cytokine_receptor->noise = DEF_CYTOKINE_RECEPTOR_NOISE; /* noise */

	return cytokine_receptor;
}

void free_cytokine_receptor(Cytokine_Receptor *cytokine_receptor)
{
	if(!cytokine_receptor)
		return;
	free(cytokine_receptor);
}

Cell_Receptor *init_cell_receptor(void)
{
	Cell_Receptor *cell_receptor;

	if(!(cell_receptor = malloc(sizeof(Cell_Receptor))))
		err(1, "couldn't allocate memory for cell receptor");
	/* defaults */
	/* respond to cells of any type or state */
	cell_receptor->type = cell_receptor->state = -1;
	cell_receptor->efficiency = DEF_CELL_RECEPTOR_EFFICIENCY;  /* 100% efficient */
	cell_receptor->cell = NULL;  /* not connected */

	return cell_receptor;
}

void free_cell_receptor(Cell_Receptor *cell_receptor)
{
	if(!cell_receptor)
		return;
	free(cell_receptor);
}

VR_Receptor *init_vr_receptor(void)
{
	VR_Receptor *vr_receptor;

	if(!(vr_receptor = malloc(sizeof(VR_Receptor))))
		err(1, "couldn't allocate memory for variable region receptor");
	/* defaults */
	/* respond to cells of any type or state */
	vr_receptor->type = vr_receptor->state = -1;
	vr_receptor->threshold = 1.0;  /* exact match */
	vr_receptor->cell = NULL;  /* not connected */
	vr_receptor->lock = vr_receptor->key = NULL;
	vr_receptor->match = antigen_match_simple;  /* simple matching */
	vr_receptor->activated = 0;  /* not activated */

	return vr_receptor;
}

void free_vr_receptor(VR_Receptor *vr_receptor)
{
	if(!vr_receptor)
		return;
	if(vr_receptor->lock)
		free_antigen(vr_receptor->lock);
	if(vr_receptor->key)
		free_antigen(vr_receptor->key);
	free(vr_receptor);
}
