/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* signal api                                                                 */
/******************************************************************************/

#include "signal.h"

#include <stdlib.h>
#include <err.h>

Signal *init_signal(void)
{
	Signal *signal;

	if(!(signal = malloc(sizeof(Signal))))
		err(1, "couldn't allocate memory for signal");

	return signal;
}

void free_signal(Signal *signal)
{
	if(!signal)
		return;
	free(signal);
}

Signal *read_signal(FILE *fp)
{
	Signal *signal;

	signal = init_signal();
	if(fread((void *) signal, 1, sizeof(Signal), fp) != sizeof(Signal))
		err(1, "couldn't read signal");

	return signal;
}

void write_signal(Signal *signal, FILE *fp)
{
	if(fwrite((void *) signal, 1, sizeof(Signal), fp) != sizeof(Signal))
		err(1, "couldn't write signal");
}
