/*
	A vulnerable apache module

*/

/*
 * Include the core server components.
 */
#include <string.h>
#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"
#include "http_main.h"
#include "http_protocol.h"
#include "http_request.h"
#include <stdlib.h>
#include <stdio.h>



/* reverse:  reverse string s in place */
void reverse(char s[])
{
    int i, j;
    char c;

    for (i = 0, j = strlen(s)-1; i<j; i++, j--) {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}


/* itoa:  convert n to characters in s */
void itoa(int n, char s[])
{
    int i, sign;

    if ((sign = n) < 0)  /* record sign */
        n = -n;          /* make n positive */
    i = 0;
    do {       /* generate digits in reverse order */
        s[i++] = n % 10 + '0';   /* get next digit */
    } while ((n /= 10) > 0);     /* delete it */
    if (sign < 0)
        s[i++] = '-';
    s[i] = '\0';
    reverse(s);
} 


/*
 * This function is registered as a handler for HTTP methods and will
 * therefore be invoked for all GET requests (and others).  Regardless
 * of the request type, this function simply sends a message to
 * STDERR (which httpd redirects to logs/error_log).  A real module
 * would do *alot* more at this point.
 */
static int mod_attack_method_handler (request_rec *r)
{

	if( strcmp(r->content_type, "text/attack") != 0)
	{
		return DECLINED;
	}


	// Send a message to stderr (apache redirects this to the error log)
	char filename[512];
	char request[512];
	strcpy(filename, r->filename);
	strcpy(request, r->the_request);
	fprintf(stderr,"Attack module processing underway for %s. MIME TYPE %s. Request: %s.\n", filename, r->content_type, request );

	// We need to flush the stream so that the message appears right away.
	// Performing an fflush() in a production system is not good for
	// performance - don't do this for real.
	fflush(stderr);


	// detect mode of usage
	char filetoret[512];
	char filetoret_temp[512];
	char *charptr;

	charptr = strchr(request, '?');

	if(charptr != NULL)
	{
		while(*charptr != '=' )
		{
			charptr++;
		}

		charptr++;	

		int i=0;

		while((*charptr != '&') && (*charptr != ' '))
		{
			filetoret_temp[i] = *charptr;
			charptr++;
			i++;
		}
		filetoret_temp[i] = '\0';
		sprintf(filetoret, "/var/www/%s", filetoret_temp);

	} else {
		strcpy(filetoret, filename);
	}

	ap_unescape_url(filetoret);
	ap_unescape_url(filetoret);  // - VULN. double percent decoding
	fprintf(stderr,"File Returned %s\n", filetoret);
	fflush(stderr);

	//open file  - VULN. Does not check whether file is within the webpath + it performs infinite open tries without checking files existence
	apr_file_t *myfile;
	
	while (apr_file_open(&myfile, filetoret, \
                          APR_READ, APR_OS_DEFAULT, \
                          r->pool) != 0 )  {}

	char *mybuf;
	mybuf = malloc(2046);
	apr_size_t mysize = 2044;
	apr_file_read(myfile, mybuf, &mysize);
	fprintf(stderr,"File Contents %s\n", mybuf);
	fflush(stderr);
	free(mybuf);


	//send file 
	/**
	 * Send an entire file to the client, using sendfile if supported by the
	 * current platform
	 * @param fd The file to send.
	 * @param r The current request
	 * @param offset Offset into the file to start sending.
	 * @param length Amount of data to send
	 * @param nbytes Amount of data actually sent
	 */
	char *clength;
	clength = malloc(32);
	itoa(strlen(mybuf), clength);
	apr_table_set(r->headers_out, "Content-Length", clength);
	ap_send_fd(myfile, r, 0, \
                                   2046, &mysize);

	free(clength);
	return OK;
}

/*
 * This function is a callback and it declares what other functions
 * should be called for request processing and configuration requests.
 * This callback function declares the Handlers for other events.
 */
static void mod_attack_register_hooks (apr_pool_t *p)
{
	 //I think this is the call to make to register a handler for method calls (GET PUT et. al.).
	// We will ask to be last so that the comment has a higher tendency to
	// go at the end.
	ap_hook_handler(mod_attack_method_handler, NULL, NULL, APR_HOOK_FIRST);
}



/*
 * Declare and populate the module's data structure.  The
 * name of this structure ('tut1_module') is important - it
 * must match the name of the module.  This structure is the
 * only "glue" between the httpd core and the module.
 */
module AP_MODULE_DECLARE_DATA attack_module =
{
	// Only one callback function is provided.  Real
	// modules will need to declare callback functions for
	// server/directory configuration, configuration merging
	// and other tasks.
	STANDARD20_MODULE_STUFF,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	mod_attack_register_hooks			/* callback for registering hooks */

};



