#!/usr/bin/perl

if(scalar @ARGV < 4) { die "check usage\n"; }

#arg0 - icmpin.rate
#arg1 - ifout.rate
#arg2 - ifoutchgrate.log
#arg3 - tcr.signals.log

open(ICMPRATE, "<$ARGV[0]") or die "Cannot open input file: $!\n";
open(IFOUTRATE, "<$ARGV[1]") or die "Cannot open input file: $!\n";
open(IFOUTCHGRATE, "<$ARGV[2]") or die "Cannot open input file: $!\n";
open(SIGNALTCRLOG, ">$ARGV[3]") or die "Cannot open input file: $!\n";


@icmprate = <ICMPRATE>;
@ifoutrate = <IFOUTRATE>;
@ifoutchgrate = <IFOUTCHGRATE>;



# synchronize start - all signal sources are to start at the same second

($x1,$y1) = split(" ",$icmprate[0]);
($sec1,$msec1) = split('\.',$x1);
($x2,$y2) = split(" ",$ifoutrate[0]);
($sec2,$msec2) = split('\.',$x2);
($x3,$y3) = split(" ",$ifoutchgrate[0]);
($sec3,$msec3) = split('\.',$x3);

if(($sec1 != $sec2) or ($sec2 != $sec3))
{
	@firstseconds = reverse sort {$a <=> $b} ($sec1,$sec2,$sec3); 
	$sec = 0;
	while($sec < $firstseconds[0])	
	{
		($x,$y) = split(" ",$icmprate[0]);
		($sec,$msec) = split('\.',$x);
		shift(@icmprate) if $sec < $firstseconds[0];
	}
	$sec = 0;
	while($sec < $firstseconds[0])	
	{
		($x,$y) = split(" ",$ifoutrate[0]);
		($sec,$msec) = split('\.',$x);
		shift(@ifoutrate) if $sec < $firstseconds[0];
	}
	$sec = 0;
	while($sec < $firstseconds[0])	
	{
		($x,$y) = split(" ",$ifoutchgrate[0]);
		($sec,$msec) = split('\.',$x);
		shift(@ifoutchgrate) if $sec < $firstseconds[0];
	}
}


# write tcr.signals log entry
$i=0;
while($icmprate[$i] and $ifoutrate[$i] and $ifoutchgrate[$i])
{
	($x1,$y1) = split(" ",$icmprate[$i]);
	($sec1,$msec1) = split('\.',$x1);
	($x2,$y2) = split(" ",$ifoutrate[$i]);
	($sec2,$msec2) = split('\.',$x2);
	($x3,$y3) = split(" ",$ifoutchgrate[$i]);
	($sec3,$msec3) = split('\.',$x3);
	print SIGNALTCRLOG  "$sec1.0 signal 0 3 $y1 $y2 $y3\n";
	$i++;

}

close(ICMPRATE);
close(IFOUTRATE);
close(IFOUTCHGRATE);
close(SIGNALTCRLOG);

