#!/usr/bin/perl

if (scalar @ARGV < 2) {die "check usage\n";}

#arg0 - ifout.log file
#arg1 - ifout.rate file


# Calculating first $prevpacket
open(INFILE, "$ARGV[0]") or die "Cannot open input file: $!\n";
$inline = <INFILE>; 
($ts, $prevpacket) = split(" ", $inline);
$prevpacket = 0 if $prevpacket !~ /.+/; # transforming empty entries to 0
close(INFILE);


# Starting conversion to packets/sec proper
open(INFILE, "$ARGV[0]") or die "Cannot open input file: $!\n";
open(OUTFILE, ">$ARGV[1]") or die "Cannot open output file: $!\n";

while($inline = <INFILE>) 
{
	# read next line
	($ts, $packet) = split(" ", $inline);
	$packet = 0 if $packet !~ /.+/; # transforming empty entries to 0

	$packetrate = $packet - $prevpacket;

	print OUTFILE "$ts $packetrate\n";
	$prevpacket = $packet;

}

close(INFILE);
close(OUTFILE);

