/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* producer api                                                               */
/******************************************************************************/

#ifndef PRODUCER_H
#define PRODUCER_H

#include "antigen.h"

typedef struct {
	int type;
	double val;
} Cytokine_Producer;

typedef struct {
	Antigen *antigen;
	double efficiency;
	int action_time;
	int active;
	int destroy;
} Antigen_Producer;

typedef struct {
	int type;
	Antigen *antigen;
	char *response;
} Response_Producer;

/* function prototypes */
Cytokine_Producer *init_cytokine_producer(void);
void free_cytokine_producer(Cytokine_Producer *);
Antigen_Producer *init_antigen_producer(void);
void free_antigen_producer(Antigen_Producer *);
Response_Producer *init_response_producer(void);
void free_response_producer(Response_Producer *);
void set_rp_antigen(Response_Producer *, Antigen *);
void set_rp_response(Response_Producer *, char *);

#endif
