#!/usr/bin/perl

# wrt  - test for finding the web server's saturation point in reference to the wrt testcase7 session
# requires HTTPerf and testcase7req.perf

# arg0 - server ip address 
# arg1 - start connection rate 
# arg2 - rate stepping
# arg3 - max connection rate 
# arg4 - results file name 


if(scalar @ARGV < 5) {die "check usage\n";}

print "\nExecuting saturation point test for ddwrt at a max connection rate of $ARGV[3] conn/s ... \n";

for($rate=$ARGV[1]; $rate<= $ARGV[3]; $rate += $ARGV[2])
{

for($i=1; $i<11; $i++)
{
	print "Step $i for a connection rate of $rate conn/s \n";

	open(RESULTS, ">>$ARGV[4]");
	print RESULTS "\n ---RUN---\n";
	open(HTTPERF, "httperf --server=$ARGV[0] --wsesslog=1000,0,testcase7reqmime.perf --rate=$rate --timeout=10 |");
	while($resline = <HTTPERF>)
	{
		print RESULTS $resline;

	}

	close(HTTPERF);
	print RESULTS "\n ---RUN---\n";
	close(RESULTS);

}

}
