#pragma once
#include "Wheelchair.h"
#include "SharedControl.h"

/* July 2011
Modifications made by Radhika for implementation of Shared Control 
are explicity mentioned with comments labelled "radhika"
*/

class StateControl
{
friend class SharedControl;//radhika
private:
	int right;
	int left;
	time_t last_time;
	int state;
	UINT_PTR timer;
	CWheelchairApp* m_pMainApp;
	static void * pObject;		//!< Required for TimerProc_Wrapper

	/* start Radhika */
	int collisionRisk[5];
	int userRequest;

	bool CheckCollision(int cond); //for collision avoidance
	bool ModifyControl(int cond); //to limit speed of wheelchair
	/* end Radhika */


public:
	StateControl(CWheelchairApp* mainApp);
	void Reset(void);
	void TransFun(int cond);
	static void CALLBACK TimerProc_Wrapper(HWND hwnd, UINT uMsg, UINT_PTR idEvent,DWORD dwTime);
	void CALLBACK ProcessTimeout(HWND hwnd, UINT uMsg, UINT_PTR idEvent,DWORD dwTime);
	~StateControl(void);

	/* start Radhika */
	void SharedTransFun(int cond, int velocityLevel); //modified version of TransFun for shared control
	void SetCollisionRisk(int colRisk[]);
	void ResetCollisionRisk(void);
	int GetState(void);
	void SetUserRequest(int cond);
	int GetUserRequest(void);
	/* end Radhika */
};
