// This class is basically the same as the USARSim RangeSensor class
// For the moment only the Range and output curve parameters are changed
//	author: Erik Winter
//  created: 2005-02-24	Created the class from the USARSim RangeSensor class
//
//  modified:	2005-03-07	Made the IR look straight through transparent materials
//				2005-03-15  If the IR hits a transparent material it now sends out a new trace from the HitLocation recursively
//							until it hits a non-transparent material or reaches MaxRange
//
//	Todo:
//		- Apply the fact that the IR can see through, and though miss glass walls
//			* halfly done, if it hits a transparent material it returns maxRange. On these maps it should be an okay simplification, Fully Done

class IRSensor extends RangeSensor config (USARBot);

function float GetRange()
{
    local vector HitLocation,HitNormal, locTmp;
    local float range;
	local material mtrl;


	range=0;
	locTmp=Location;

	while(range<uuMaxRange){
		if (Trace(HitLocation, HitNormal, locTmp + uuMaxRange*vector(curRot), locTmp, true, vect(0,0,0), mtrl)==NONE){
			range=MaxRange;
			break;
		}
		else {
            range=VSize(HitLocation-Location);
       		if (converter!=None)
			    range=converter.LengthFromUU(range);
        }

		if(InStr(string(mtrl), "Trans")==-1){ // The IR hitted a non-transparent material.

			break;

		}
		else
			locTmp+=FMax(VSize(HitLocation-locTmp), uuMinRange)*vector(curRot);// If locTmp is within a material Trace will return the same location again
																			 // To avoid this infinite loop move the location with MinRange

	}
	if (range>MaxRange) range=MaxRange;
	if (range<MinRange) range=MinRange;
	if (OutputCurve.Points.length>0)
		range=InterpCurveEval(OutputCurve, range);
	range += RandRange(-Noise,Noise)*range;

	if (range>MaxRange) range=MaxRange;
	if (range<MinRange) range=MinRange;

	return range;

}

function String GetData()
{
    local string outstring;
    curRot=Rotation;
    outstring="{Name "$ItemName$" Range "$converter.FloatString(GetRange())$"}";
    return outstring;
}

defaultproperties
{
//Scaled with 4.762 at Mon Sep 25 14:21:51 EDT 2006
	bUseGroup=True
	ItemType="IR"
	HiddenSensor=false
	MaxRange=1.5 // radhika (original value: 0.80 m)
	MinRange=0.05 // radhika (original value: 0.10 m)
	OutputCurve=(Points=((InVal=0.000000,OutVal=0.000000),(InVal=2.000000,OutVal=2.000000)))     // (InVal=0.800000,OutVal=0.800000)))
	drawscale=0.4762
}
