/*! \file WheelchairDlg.h
	\brief CWheelchairDlg class header.
	\todo integrate differences from XPS. Mainly the hook.
*/

/* July 2011
Modifications made by Radhika for implementation of Shared Control 
are explicity mentioned with comments labelled "radhika"
*/

#pragma once

#include "Wheelchair.h"


//! Frame state descriptors 
//@{
#define FRAME_PENDING 0
#define FRAME_OK 1
#define FRAME_ERROR 2
//@}

// CWheelchairDlg dialog
//! The main Graphical User Interface of the application.
/*! This class is derived from CDialog. It implements the main window of the application. 
	The other windows are all children of this one. */
class CWheelchairDlg : public CDialog
{	
	//!Adds the ability to access run-time information about an object's class when deriving a class from CObject. (MSDN)
	DECLARE_DYNAMIC(CWheelchairDlg); 
	

/////////////////////////////////////////////////////////////////////////////////////////////
//METHODS:

// Construction
public:
	CWheelchairDlg(CWheelchairApp* pParent);	// standard constructor
	virtual ~CWheelchairDlg();
	enum { IDD = IDD_WHEELCHAIR_DIALOG };
	void AddToLog(LogMsgType type, CString logmsg);
	void setFPS(float fps);
	void ConnectionLost(void);
	void EnableSettings(DWORD control, bool enable);
	bool RegisterJoystick();
	bool RegisterRawInput();
	bool PopulateStartPose(CString msg = "");

private:
	DECLARE_MESSAGE_MAP()

	//! \name GUI Behaviour
	//@{
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	afx_msg int OnCreate(LPCREATESTRUCT lpRes);
	afx_msg void OnSpawn();
	afx_msg void OnControl();
	afx_msg void OnOk();
	afx_msg void OnShow();
	afx_msg void OnStart();
	afx_msg void OnClear();
	afx_msg void OnSaveLog();
	afx_msg void Saveimg();
	afx_msg void OnOpenSettings();
	afx_msg void OnOpenConfiguration();
	afx_msg void OnChangeStartPose();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnPaint();
	afx_msg void OnRead();
	afx_msg HCURSOR OnQueryDragIcon();
	//@}

	//! \name Movement Implementation
	//@{
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//! Maintains count of RawInput messages. Used for averaging.
	int		msgCounter;		
	//! Mouse velocity average (for relative control).
	float	xVelAvg; 
	//! Mouse velocity average (for relative control).
	float	yVelAvg; 
	//! Mouse cursor position (for absolute control). 
	/** Bounded between -20 and 20 */
	float	xCursor;
	//! Mouse cursor position (for absolute control). 
	/** Bounded between -20 and 20 */
	float	yCursor;
	clock_t	m_lastClock;	//!< Remembers time of last processed message. 
	//@}

//	afx_msg void OnSysCommand(UINT nID, LPARAM lParam); //not-used (AboutDlg)

///////////////////////////////////////////////////////
// MEMBERS:

	//Imaging
	int			m_UTCOffsetX;	//!< x position of the UT2004 window w.r.t. the main GUI
	int			m_UTCOffsetY;	//!< y position of the UT2004 window w.r.t. the main GUI

	// Implementation
	HICON			m_hIcon;			//!< Application icon
	CWheelchairApp	* m_pMainApp;		//!< Pointer to the main application object.
	bool			m_Control;			//!< Determines whether the main window captures mouse and keyboard input for controling the wheelchair 
	bool			m_bHasJoystick;		//!< TRUE if joystick is detected, FALSE otherwise
	SYSTEMTIME		m_systime;			//!< Used to produce time stamps in log messages
	CString*		m_strArTags;		//!< Array of StartPose Tags
	CString*		m_strArPoses;		//!< Array of StartPose Coorindates
	CString*		m_strArRots;		//!< Array of StartPose Rotations

	//! \name GUI Behaviour
	//@{
	CButton m_cShow;		//!< Controls the Show/Hide UT button
	CButton m_cSpawn;		//!< Controls the Spawn button
	int		m_radioControl;	//!< Controls the means of control radio buttons
	int		m_logType;		//!< Controls the mode of logging 0: file 1: display
	CString m_model;		//!< Controls the model drop-down
	CString m_host;			//!< Controls the host text box
	CString m_map;			//!< Controls the map text box
	CString m_tag;			//!< Controls the Position Tag drop-down
	CString m_position;		//!< Controls the Position Coordinates text
	CString m_rotation;		//!< Maintains the Rotation corresponding to selected coordinates
	CButton m_cStart;		//!< Controls the Start button
	CButton m_cSettings;	//!< Controls the Settings button
	float	m_fps;			//!< Controls the FPS textbox
	BOOL	m_startUT;		//!< Controls the Unreal Tournament checkbox
	BOOL	m_startSimWnd;	//!< Controls the Simulation checkbox
	BOOL	m_startSharedCtrl; //!<Control the Shared Control checkbox //radhika
	CString m_logstr;		//!< Controls the content of the log textbox
	//@}
};