      PROGRAM CGP93  
CRA   Modified to accomodate change in permeability :
C     Last Modified 17 March 1995 by Hedy Rahadian
C=======================================================================
C     CRISP GEOMETRY PROGRAM 1990
C=======================================================================
C     [15 MAY 93]
C
C     Replaced FFIN from MP (130 characters). Can now read 130 character
C     input data file (GPD).
C----------------------------------------------------------------------
C     [1 MAY 93]
C
C     Modified CHKSZN routine. More checks on memory and array sizes.
C----------------------------------------------------------------------
C
C     [6 MAR 93]
C
C     Some further tidying up.......
C-----------------------------------------------------------------------
C     [11 FEB 93]
C
C     Call to routine CHKSZQ is added.
C
C=======================================================================
C  29 JAN 91 : Routine RDCOD - format for writing co-ordinates changed.
C                              Decimal places increased from 3 to 5.
C=======================================================================
      CHARACTER*12 CGP90DAT,CGP90PDF,CGP90OUT,CRS90LNK,CRS90SZE,
     +             CGP90GPE
   
CT    COMMON /GVAR/ G(240000),K(1600000)
      COMMON /GVAR/ G(6000000),K(6000000)

      COMMON /NMES/ CGP90DAT,CGP90PDF,CGP90OUT,CRS90LNK,CRS90SZE,
     +              CGP90GPE
C
      IWS=2
      IWT=1
C
CC    OPEN(5,FILE='CGP88DAT')
CC    OPEN(6,FILE='CGP88OUT')
CC    OPEN(4,FILE='CRS88LNK',FORM='UNFORMATTED')
CC    OPEN(8,FILE='CGP88PDF',FORM='UNFORMATTED')
CT    LG=30000
CT    LK=200000
C
      LGMX=6000000
      LKMX=6000000
cd      LGMX=3000000
c      LKMX=3000000
      LG=0
      LK=0
C
      CRS90SZE='CRISP92.SZE'
      CALL CHKEXS(CRS90SZE,'FORMATTED',2,IER)
      IF(IER.EQ.1) STOP
C
      OPEN(18,FILE='CRISP92.SZE')
      CALL GETSZE(LG,LK,'GP')
C
      CALL OPENF(IWT,IWS,LG,LK)
C
      PRINT*,'   '
      PRINT*,'      *******  STARTING GP 93 RUN **********'
      CALL MAIN2(G,LG,K,LK,LGMX,LKMX)
      PRINT*,'   '
      PRINT*,'      *******  GP 93 RUN FINISHED **********'
      PRINT*,'  '
      PRINT*,' The following files have been created'
      WRITE(IWS,750)CGP90OUT,CRS90LNK,CGP90PDF
  750 FORMAT(/1X,' Printed Output (Results)    -  ',A12
     +       /1X,' Link file (binary)          -  ',A12
     +       /1X,' Plot Data file (not used)   -  ',A12/)
      STOP
      END
      SUBROUTINE OPENF(IWT,IWS,LG,LK)
C***********************************************************************
C
      LOGICAL EX,OPND
      CHARACTER*1 SEQ,FMT
      CHARACTER*8 FLN8
      CHARACTER*12 CGP90DAT,CGP90PDF,CGP90OUT,CRS90LNK,CRS90SZE,
     +             CGP90GPE
      INTEGER*2 ERROR_CODE
      COMMON /NMES/ CGP90DAT,CGP90PDF,CGP90OUT,CRS90LNK,CRS90SZE,
     +             CGP90GPE
C
CC    IWT=1
CC    IWS=2
C
      WRITE(IWS,700)LG,LK
  700 FORMAT(/20X,'*************************************'
     +       /20X,'*    CRISP GP 93 PROGRAM VER 93.2   *'
     +       /20X,'*         GEOMETRY PROGRAM          *'
     +       /20X,'*      G(',I8,')  K(',I8,')     *'
     +       /20X,'*     LAST MODIFIED ON  1 MAY 93    *'
     +       /20X,'*************************************'/)
C
   10 CALL FLENME(FLN8,IL,2,1)
      CGP90DAT=FLN8(1:IL)//'.GPD'
C
      CALL CHKEXS(CGP90DAT,'FORMATTED',2,IER)
      IF(IER.EQ.1) GOTO 10
C
      CGP90PDF=FLN8(1:IL)//'.PDF'
      CGP90OUT=FLN8(1:IL)//'.GPO'
      CRS90LNK=FLN8(1:IL)//'.LIK'
      CGP90GPE=FLN8(1:IL)//'.GPE'
CT    CRS90SZE='CRISP92.SZE'
C
      OPEN(5,FILE=CGP90DAT)
      OPEN(6,FILE=CGP90OUT)
      OPEN(4,FILE=CRS90LNK,FORM='UNFORMATTED')
C     OPEN(8,FILE=CGP90PDF,FORM='UNFORMATTED')
      OPEN(8,FILE=CGP90PDF)
      OPEN(15,FILE=CGP90GPE)
C
C--------ADDED 6 MAR 93
      EX=.FALSE.
      OPND=.FALSE.
      INQUIRE(FILE=CGP90GPE,NUMBER=N,FORMATTED=FMT,EXIST=EX,
     +        SEQUENTIAL=SEQ)
      IF(EX.AND..NOT.OPND) THEN
         CALL ERASE@(CGP90GPE,ERROR_CODE)
         CALL DOSERR@(ERROR_CODE)
      ENDIF
C
      RETURN
      END
      SUBROUTINE FLENME(FLN8,IL,IWS,IWT)
C**********************************************************************
      CHARACTER*8 FLN8,FLNMDF
C
      CALL DOSPARAM@('CRSFLN',FLNMDF)
C
      IF(FLNMDF.EQ.'        ') THEN
C
   10    WRITE(IWS,710)
  710    FORMAT(/1X,
     +   'Enter File/Analysis Identifier (up to 8 characters) :'/)
         READ(IWT,'(A)')FLN8
CC       WRITE(IWS,720)FLN8
CC720    FORMAT(1X,A8)
C
         DO 50 IP=1,8
         IB=8-IP+1
         IF(FLN8(IB:IB).NE.' ')GOTO 55
   50    CONTINUE
         GOTO 10
C
   55    CONTINUE
         IL=IB
C
      ELSE
C-----------DEFAULT FILE NAME FROM CRSFLN
   70    WRITE(IWS,750)FLNMDF
  750    FORMAT(/1X,
     +    'Enter File/Analysis Identifier (up to 8 characters) :',2X,A8
     +     //1X,'(Press the RETURN key to accept default name)'/)
         READ(IWT,'(A)')FLN8
CC       WRITE(IWS,720)FLN8
CC720    FORMAT(1X,A8)
C
         DO 80 IP=1,8
         IB=8-IP+1
         IF(FLN8(IB:IB).NE.' ')GOTO 95
   80    CONTINUE
C
         FLN8=FLNMDF
         DO 90 IP=1,8
         IB=8-IP+1
         IF(FLN8(IB:IB).NE.' ')GOTO 95
   90    CONTINUE
C
         WRITE(77,970)
  970    FORMAT(/1X,'POSSIBLE PROGRAM ERROR'/)
         GOTO 70
C
   95    CONTINUE
         IL=IB
CC       WRITE(77,920)FLN8,IL
CC       WRITE(2,920)FLN8,IL
CC920    FORMAT(/1X,'PARAMETER CRSFLN SET'/
CC   +           1X,'FILE ID  (FLN8)  =',A10,2X,'IL =',I5)
      ENDIF
      RETURN
      END
      SUBROUTINE CHKEXS(FLN12,FRMTYP,IWS,IER)
C***********************************************************************
C
      LOGICAL EX
      CHARACTER*12 FLN12,FRMTYP*(*),FRMTYPN*11
C
      IF(FRMTYP(1:9).EQ.'FORMATTED') THEN
         KFLETY=1
      ELSE
         KFLETY=2
      ENDIF
C
      IER=0
CX    INQUIRE(FILE=FLN12,FORM=FRMTYP,EXIST=EX,ERR=50)
      INQUIRE(FILE=FLN12,FORM=FRMTYPN,EXIST=EX,ERR=50)
C
      IF(.NOT.EX) THEN
         WRITE(IWS,700)FLN12
  700    FORMAT(/' *** Error : File -  ',A12,2X,'Does not exist'//
     +           20X,'******  Program Terminated ******'/)
         STOP
      ENDIF
C
      IF(FRMTYPN(1:9).EQ.'FORMATTED') THEN
         JFLETY=1
      ELSE
         JFLETY=2
      ENDIF
C
CX    IF(KFLETY.NE.JFLETY) THEN
CX       WRITE(IWS,710)FLN12,FRMTYP,FRMTYPN
CX710    FORMAT('  File - ',A12,2X,/2A20)
C
CX       IER=1
CX    ENDIF
      RETURN
C
   50 CONTINUE
      WRITE(IWS,720)FLN12
  720 FORMAT(' *** Error : Check File - ',A12,2X,/
     + 'In-consistent file type or Incorrect file')
      IER=1
      RETURN
      END
      SUBROUTINE GETSZE(LG,LK,PN)
C
C***********************************************************************
C
C     ROUTINE TO GET THE SIZES OF ARRAYS G AND K FROM CRISP92.SZE
C     FILE.
C     LAST MODIFIED ON 24 AUGUST 92
C
C***********************************************************************
C
      CHARACTER*4 PN*2,CG,CK,CLAB,CSZE*14,CL*14
C
      IWS=2
      IR18=18
C
      CG='LG'//PN
      CK='LK'//PN
      CSZE='              '
C
      REWIND IR18
   10 READ(IR18,900,END=500)CSZE
  900 FORMAT(A14)
C
      IF(CSZE(1:1).EQ.'C') GOTO 10
C
      CLAB=CSZE(1:4)
      IF(CLAB.NE.CG.AND.CLAB.NE.CK) GOTO 10
C
C--------FIND POSITION OF LAST NON-SPACE CHARACTER
      DO 50 IP=1,14
      IB=14-IP+1
      IF(CSZE(IB:IB).NE.' ') GOTO 55
   50 CONTINUE
      GOTO 10
C
   55 CONTINUE
      IL=IB
      CL=CSZE(6:IB)
C
CT    IERR=0
CT    CALL CTOI(CL,NA,IERR)
C
      READ(CL,910)NA
  910 FORMAT(I8)
C
      IF(CLAB.EQ.CG) THEN
         LG=NA
      ELSE IF(CLAB.EQ.CK) THEN
         LK=NA
      ENDIF
C
      GOTO 10
C
  500 CONTINUE
C
      IF(LG.EQ.0.OR.LK.EQ.0) THEN
         WRITE(IWS,920)PN
  920    FORMAT(/1X,'*** Error :  file - CRISP92.SZE does not have',
     +          /1X,'             array size entries for the ',A2,2X,
     +              'Program. Program Stopped.'/)
         STOP
      ENDIF
C
      RETURN
      END
      SUBROUTINE MAIN2(G,LG,K,LK,LGMX,LKMX)
C***********************************************************************
C     ROUTINE TO SET-UP ARRAY SIZES FOR GEOMETRY
C     PROGRAM.  REAL ARRAYS ARE ALLOCATED TO THE LEFT
C     OF ARRAY G AND INTEGER ARRAYS TO THE RIGHT
C     ROUTINE LAST UPDATED ON 02/3/93
C***********************************************************************
      CHARACTER*1 JDO,TITLE
      DIMENSION G(LG),K(LK)
      DIMENSION NAD(15),KLT(15)
      COMMON /LABEL / TITLE(80)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
      COMMON /FFL   / JDO(130)
      COMMON /DEVSUP/ IW15,IWS
      DATA NAD(1),NAD(2),NAD(3),NAD(4),NAD(5),NAD(6),NAD(7),
     1 NAD(8),NAD(9),NAD(10),NAD(11),NAD(12),NAD(13),NAD(14),NAD(15)/
     2 1,3,3,4,4,12,19,12,12,6,6,1,4,1,1/
C
C *** DEVICE NUMBERS R - READ ; W - WRITE ; P - PLOT
      IR1=1
      IR4=4
      IR5=5
      IW2=2
      IW4=4
      IW6=6
      IW7=7
      IWP=8
      IW9=9
      IW15=15
      IWS=2
      LUN=IR5
C
C *** SET SOME CONSTANTS
      PYI=4.*ATAN(1.)
      ALAR=1.E+17
      ASMVL=1.E-20
      ZERO=0.
C
      WRITE(IW6,900)
      READ(LUN,901)TITLE
      NCARD=1
      WRITE(IW6,903)TITLE
      CALL FFIN(1,1)
      LINK1=IFIX(AR(1))
      WRITE(IW6,906)LINK1
C
      CALL FFIN(6,63)
      NVTX=IFIX(AR(1))
      NEL=IFIX(AR(2))
      MXNDV=IFIX(AR(3))
      MXTYP=IFIX(AR(4))
      NDIM=IFIX(AR(5))
      IPLOT=IFIX(AR(6))
      WRITE(IW6,904)NVTX,NEL,MXNDV,MXTYP,NDIM,IPLOT
      CALL FFIN(2,3)
      NUMAX=IFIX(AR(1))
      MUMAX=IFIX(AR(2))
      WRITE(IW6,907)NUMAX,MUMAX
      IF(NUMAX.EQ.0)NUMAX=NVTX
      IF(MUMAX.EQ.0)MUMAX=NEL
C-----------------------------------------------------------------------
C     NDZ   - INDEX FOR MID-SIDE (EDGE) NODE NUMBERS
C     NPL   - LENGTH OF (INDEX TO VERTEX NODES) ARRAYS NP1,NP2
C     NMATZ - MAXIMUM ADMISSIBLE MATERIAL PROPERTY NUMBER
C     LTZ   - LARGEST ADMISSIBLE ELEMENT TYPE NUMBER
C     INXL  - INDEX TO NO. D.O.F. OF FIRST NODE OF ELEMENT
C     IFRZ  - LIST OF NODES IN FRONT (SEE ROUTINES SFWZ,FRONTZ)
C     MXDF  - MAXIMUM NUMBER OF POSSIBLE VARIABLES AT A NODE
C-----------------------------------------------------------------------
      NDZ=750
      NPL=21

crh      NMATZ=10
crh replaced by    
      NMATZ=250 
crh end of replacement

      LTZ=15
CC    IFRZ=2000
      IFRZ=NEL*(MXNDV+NAD(MXTYP))*NDIM
C----------FOLLOWING STATEMENT ADDED 13 MARCH 91
      IF(IFRZ.LT.2000)IFRZ=2000
      INXL=20
      MXDF=6
C-----------------------------------------------------------------------
C     NAD - ESTIMATE OF ADDITIONAL NODES PER ELEMENT FOR
C     DIFFERENT ELEMENT TYPES
C     NDEAD - TOTAL NUMBER OF ADDITIONAL NODES (AN ESTIMATE)
C     NPE   - NO. OF DISPLACEMENT NODES ALONG EDGE (EXCLUDE END NODES)
C     NED   - NUMBER OF ELEMENT EDGES + 1
C     NTPE  - MAXIMUM NUMBER OF NODES IN ANY ELEMENT
C-----------------------------------------------------------------------
      NPE=LINFO(7,MXTYP)
      NED=LINFO(3,MXTYP)+1
      NDEAD=NAD(MXTYP)*NEL
      NTPE=LINFO(1,MXTYP)
C-----------------------------------------------------------------------
C     ESTIMATE THE TOTAL NUMBER OF NODES
C-----------------------------------------------------------------------
      NNE=NVTX+NDEAD
      IF(NVTX.GT.NDZ)NDZ=NVTX
      IF(NUMAX.GT.NDZ)NDZ=NUMAX
C-----------------------------------------------------------------------
C     NDZ+1 IS THE STARTING POINT FOR NODE NUMBERING FOR ADDITIONAL NODES
C-----------------------------------------------------------------------
      NNU=NDZ+NDEAD
C-----------------------------------------------------------------------
C     SIZE OF ARRAY ITAB (SEE ROUTINES MIDSID, MIDPOR)
C-----------------------------------------------------------------------
      LDIM=NPE+3
      LTAB=NED*NEL
C-----------------------------------------------------------------------
C     THE FOLLOWING ARRAYS ARE DYNAMICALLY ALLOCATED STORE
C     IN ARRAY G FOR THE GEOMETRY PROGRAM. REAL ARRAYS ARE
C     ALLOCATED AT THE BEGINNING OF ARRAY G WITH ARRAY INDEX
C     INCREASING. INTEGER ARRAYS ARE ALLOCATED TO THE END OF
C     ARRAY G WITH ARRAY INDEX DECREASING.
C
C     G(1) -  G(L1-1) = NODAL COORDINATES .................XYZ(NDIM,NNE)
C
C    K(1)  -  K(M1-1) = ELEMENT-NODAL CONNECTIVITY.......NCORR(NTPE,NEL)
C    K(M1) -  K(M2-1) = MATERIAL PROPERTY NUMBER................MAT(NEL)
C    K(M2) -  K(M3-1) = ELEMENT TYPE NUMBER....................LTYP(NEL)
C    K(M3) -  K(M4-1) = USER ELEMENT NUMBERS.................MRELVV(NEL)
C    K(M4) -  K(M5-1) = PROGRAM ELEMENT NUMBERS..............MREL(MUMAX)
C    K(M5) -  K(M6-1) = USER NODE NUMBERS....................NRELVV(NNE)
C    K(M6) -  K(M7-1) = PROGRAM NODE NUMBERS...................NREL(NNU)
C    K(M7) -  K(M8-1) = GLOBAL VARIABLE NUMBERS...........KGVN(MXDF,NNE)
C    K(M8) -  K(M9-1) = NO. OF D.O.F. OF EACH NODE...............NQ(NNE)
C    K(M9) - K(M10-1) = TABLE OF ELEMENT EDGES...........ITAB(LDIM,LTAB)
C   K(M10) - K(M11-1) = USER ELEMENT NOS. IN FRONTAL ORDER.....MFRU(NEL)
C   K(M11) - K(M12-1) = ELEMENT NO. IN FRONTAL ORDER.........MFRN(MUMAX)
C   K(M12) - K(M13-1) = FRONTAL DESTINATION OF NODES..........NDEST(NNE)
C   K(M13) - K(M14-1) = NODE NOS. OF ELEMENT..................NLST(NTPE)
C   K(M14) - K(M15-1) = LIST OF NODES (AND D.O.F.) IN FRONT....IFR(IFRZ)
C   K(M15) - K(M16-1) = INDEX OF ONE END OF ELEMENT EDGE........NP1(NPL)
C   K(M16) - K(M17-1) = INDEX OF OTHER END OF ELEMENT EDGE......NP2(NPL)
C   K(M17) - K(M18-1) = FLAG TO INDICATE PRESENCE OF D.O.F.KDF(MXDF,NNE)
C
C     IN THE ABOVE
C
C     LDIM   - MAX NUMBER OF NODES ALONG EDGE + 3
C     LTAB   - TOTAL NUMBER OF ELEMENT EDGES (ESTIMATE)
C     MUMAX  - MAXIMUM VALUE OF USER ELEMENT NUMBER
C              (THIS NEED NOT BE EQUAL TO THE TOTAL NO. OF ELEMENTS)
C     NTPE   - MAX NO. OF NODES IN ANY ELEMENT IN MESH
C     NDIM   - NO. OF DIMENSIONS IN PROBLEM (2 OR 3)
C     NEL    - TOTAL NUMBER OF ELEMENTS IN MESH
C     NNE    - TOTAL NUMBER OF NODES IN MESH (ESTIMATE)
C     NNU    - ESTIMATE OF MAXIMUM VALUE OF USER NODE NUMBER
C     NPL    - SUM TOTAL OF EDGES FOR ALL ELEMENT TYPES
C***********************************************************************
C *** INDEXES FOR ARRAYS FOR USE IN GEOMETRY PROGRAM
      L1=1+NNE*NDIM
      LZ=L1
C
      M1=NTPE*NEL+1
      M2=M1+NEL
      M3=M2+NEL
      M4=M3+NEL
      M5=M4+MUMAX
      M6=M5+NNE
      M7=M6+NNU
      M8=M7+MXDF*NNE
      M9=M8+NNE
      M10=M9+LTAB*LDIM
      M11=M10+NEL
      M12=M11+MUMAX
      M13=M12+NNE
      M14=M13+NTPE
      M15=M14+IFRZ
      M16=M15+NPL
      M17=M16+NPL
      M18=M17+MXDF*NNE
      MZ=M18
CC    IF(MZ.LE.LK)GO TO 40
CC    MORE=MZ-LK+1
CC    WRITE(IW6,908)MORE
CC    STOP
C
CC 40 KSTO=LK-MZ
CC    WRITE(IW6,910)KSTO,LG
      IERR=0
C==========ADDED 11 FEB 93
      ICODE=11
      CALL CHKSZN(IW6,IW2,LG,LK,LZ,MZ,LGMX,LKMX,'GP',IERR,ICODE)
C
C============REAL ARRAY G
CF    IF(LZ.LE.LG) THEN
CF       WRITE(IW6,720)LG,LZ
CF720    FORMAT(/1X,' REAL ARRAY G - ALLOCATED',I9,4X,'USED ',I8)
CF    ELSE
CF       WRITE(IW6,725)LG,LZ
CF725    FORMAT(/1X,' REAL ARRAY G - ALLOCATED',I9,4X,'NOT SUFFICIENT'/
CF   +           1X,' INCREASE  SIZE OF  G  TO AT LEAST',I9)
CF       IERR=IERR+1
CF    ENDIF
C============INTEGER ARRAY K
CF    IF(MZ.LE.LK) THEN
CF       WRITE(IW6,730)LK,MZ
CF730    FORMAT(/1X,' INTEGER ARRAY K - ALLOCATED',I9,4X,'USED ',I8)
CF    ELSE
CF       WRITE(IW6,735)LK,MZ
CF735 FORMAT(/1X,' INTEGER ARRAY K - ALLOCATED',I9,4X,
CF   +           'NOT SUFFICIENT'/
CF   +           1X,' INCREASE  SIZE OF  K  TO AT LEAST',I9)
CF       IERR=IERR+1
CF    ENDIF
C
CF    IF(IERR.GT.0) STOP
C
      CALL GPSUB(NVTX,NEL,NUMAX,MUMAX,NTPE,MXNDV,NNE,MXDF,NN,NNU,NNZ,
     1 LTAB,LDIM,NDIM,NDF,NDZ,IFRZ,MCORE,MAXNFZ,
     2 NPL,LTZ,KLT,NMATZ,INXL,IPLOT,
     3 G(1),K(1),K(M1),K(M2),K(M3),K(M4),K(M5),K(M6),K(M7),K(M8),
     4 K(M9),K(M10),K(M11),K(M12),K(M13),K(M14),K(M15),K(M16),
     5 K(M17),ND,NCORET,MDZ)
      IF(ID8.EQ.0)GOTO 45
      WRITE(IW6,925)NNE,NNU,LDIM,LTAB,NTPE,IFRZ,NPL
  925 FORMAT(/1X,6HNNE = ,I5,3X,6HNNU = ,I5,3X,7HLDIM = ,3X,
     1 7HLTAB = ,I5,3X,7HNTPE = ,I5,3X,7HIFRZ = ,I5,3X,6HNPL = ,I5)
      WRITE(IW6,920)(G(JK),JK=1,L1)
      WRITE(IW6,930)(G(JK),JK=M17,LG)
  920 FORMAT(//1X,4HREAL/(1X,10F10.2/))
  930 FORMAT(//1X,7HINTEGER/(1X,20I6/))
   45 CONTINUE
C-----------------------------------------------------------------------
C     CREATE LINK FILE
C-----------------------------------------------------------------------
      NN1=NN+1
CC    WRITE(IW6,950)KLT
CC950 FORMAT(/1X,3HKLT/(12I10))
      CALL MCRLNK(IW4,IW6,LINK1,NN,NVTX,ND,MXDF,NNZ,NDZ,NEL,
     1 MUMAX,NDF,NDIM,NTPE,NPL,LTZ,INXL,IFRZ,MAXNFZ,
CC   2 MCORE,NCORET,MDZ,MXNDV,KLT,G(1),K(M1),K(M2),K(M7),K(M5),
CC   3 K(M6),K(M4),K(M3),K(M8))
     2 MCORE,NCORET,MDZ,MXNDV,KLT,G(1),K(1),K(M1),K(M6),K(M4),K(M5),
     3 K(M3),K(M2),K(M7))
C
      WRITE(IW6,970)
  970 FORMAT(/1X,30(1H=),1X,'End of GP output',1X,30(1H=))
      RETURN
  900 FORMAT(1H1,120(1H*)//
     1 17H CRISP 1993 (GP1)//
     2 34H PROGRAM LAST MODIFIED ON 11/02/93
     3 )
  901 FORMAT(80A1)
  903 FORMAT(/1X,80A1)
  904 FORMAT(//
     1 10X,46HTOTAL NUMBER OF VERTEX NODES.................=,I8/
     2 10X,46HTOTAL NUMBER OF ELEMENTS.....................=,I8/
     5 10X,46HMAXIMUM NUMBER OF VERTEX NODES IN AN ELEMENT.=,I8/
     6 10X,46HELEMENT TYPE WITH MAXIMUM NUMBER OF NODES....=,I8/
     8 10X,46HNUMBER OF DIMENSIONS IN PROBLEM..............=,I8/
     9 10X,46HPLOTTING CODE................................=,I8//)
  906 FORMAT(/1X,14HLINK NUMBER = ,I6)
  907 FORMAT(
     1 10X,46HMAXIMUM VALUE OF VERTEX NODE NUMBER..........=,I8/
     2 10X,46HMAXIMUM VALUE OF ELEMENT NUMBER..............=,I8//)
CC908 FORMAT(/1X,28HINCREASE SIZE OF ARRAY G BY ,I8,
CC   1 37H IN ROUTINE MAIN FOR GEOMETRY PROGRAM/)
CC910 FORMAT(39H ARRAY STORE - USED IN GEOMETRY PROGRAM,
CC   1 I7,1H/,I7//120(1H*))
      END
      BLOCK DATA
C*******************************************************************************
C      DATA PRESENTED BY LIN (FIRST INDEX)
C
C      1 - TOTAL NUMBER OF NODES (DISPLACEMENT + POREPRESSURE)..............NDPT
C      2 - TOTAL NUMBER OF VERTEX NODES......................................NVN
C      3 - TOTAL NUMBER OF ELEMENT EDGES....................................NEDG
C      4 - TOTAL NUMER OF ELEMENT FACES (3D)................................NFAC
C      5 - TOTAL NUMBER OF DISPLACEMENT NODES................................NDN
C      6 - TOTAL NUMBER OF POREPRESSURE NODES................................NPN
C      7 - NUMBER OF DISPLACEMENT NODES PER EDGE (EXCLUDING END NODES)......NSDN
C      8 - NUMBER OF POREPRESSURE NODES PER EDGE (EXCLUDING END NODES)......NSDP
C      9 - NUMBER OF INNER DISPLACEMENT NODES...............................NIND
C     10 - NUMBER OF INNER POREPRESSURE NODES...............................NINP
C     11 - NUMBER OF INTEGRATION POINTS......................................NGP
C     12 - INDEX TO WEIGHTS AND INTEGRATION POINT COORDINATES...............INDX
C     13 - INDEX TO VERTEX NODES OF ELEMENTS (ARRAY NFC).....................INX
C     14 - INDEX TO NODES ALONG EDGE (ARRAYS NP1, NP2).....................INDED
C     15 - NUMBER OF AREA COORDINATES.........................................NL
C     16 - TOTAL NUMBER OF DEGREES OF FREEDOM (D.O.F.) IN ELEMENT...........MDFE
C     17 - CENTROID INTEGRATION POINT NUMBER................................NCGP
C     21 - ONWARDS THE NUMBER OF D.O.F. OF EACH NODE OF ELEMENT.............NDFN
C
C      ELEMENT TYPES (SECOND INDEX)
C       1 - 3-NODED BAR ....................(2-D PLANE STRAIN ONLY)
C       2 - 6-NODED LST TRIANGLE............(2-D)
C       3 - 6-NODED LST TRIANGLE............(2-D CONSOLIDATION)
C       4 - 8-NODED QUADRILATERAL...........(2-D)
C       5 - 8-NODED QUADRILATERAL...........(2-D CONSOLIDATION)
C       6 - 15-NODED CUST TRIANGLE..........(2-D)
C       7 - 22-NODED CUST TRIANGLE..........(2-D CONSOLIDATION)
C       8 - 20-NODED BRICK..................(3-D)
C       9 - 20-NODED BRICK..................(3-D CONSOLIDATION)
C      10 - 10-NODED TETRA-HEDRA............(3-D)
C      11 - 10-NODED TETRA-HEDRA............(3-D CONSOLIDATION)
C      12 -  3-NODED BEAM ..................(2-D PLANE STRAIN ONLY)
C      13 -  8-NODED SLIP ELEMENT...........(2-D PLANE STRAIN ONLY)
C
C=======================================================================
C
C      ARRAY MIN (HAS THE NAME MINFO IN THE REST OF THE PROGRAM) IS
C      TO SUPPLEMENT THE ARRAY LIN (LINFO IN THE REST OF THE PROGRAM).
C      ARRAY MIN GIVES THE UNIQUE VARIABLE NUMBER (UVN) FOR EACH OF
C      THE VARIABLE OF A NODE.
C
C        UVN
C          1  -   DISPLACEMENT IN X DIRECTION .................. U
C          2  -   DISPLACEMENT IN Y DIRECTION................... V
C          3  -   DISPLACEMENT IN Z DIRECTION .................. W
C          4  -   EXCESS PORE PRESSURE ......................... P
C          5  -   ROTATION IN XY PLANE .........................
C          6  -   NOT USED
C
C      THE FIRST INDEX REPRESENTS EACH OF THE VARIABLES AT A NODE.
C      THE SECOND INDEX TO ARRAY MIN REPRESENTS EACH OF THE NODES OF
C      AN ELEMENT TYPE.
C      THE THIRD  INDEX IDENTIFIES THE ELEMENT TYPE.
C*******************************************************************************
      REAL L
      COMMON /ELINF/ MIN(6,30,15),LIN(50,15)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /SAMP / POSSP(5),WEIGP(5)
C---------- ELEMENT TYPE 1 - 3 NODED BAR
      DATA LIN(1,1),LIN(2,1),LIN(3,1),LIN(4,1),LIN(5,1),LIN(6,1),
     1 LIN(7,1),LIN(8,1),LIN(9,1),LIN(10,1),LIN(11,1),LIN(12,1),
     2 LIN(13,1),LIN(14,1),LIN(15,1),LIN(16,1),LIN(17,1),
     3 LIN(21,1),LIN(22,1),LIN(23,1)/
     3 3,2,1,1,3,0,1,0,0,0,5,0,0,0,1,6,3,2,2,2/
C---------- ELEMENT TYPE 2 - 6 NODED LST
      DATA LIN(1,2),LIN(2,2),LIN(3,2),LIN(4,2),LIN(5,2),LIN(6,2),
     1 LIN(7,2),LIN(8,2),LIN(9,2),LIN(10,2),LIN(11,2),LIN(12,2),
     2 LIN(13,2),LIN(14,2),LIN(15,2),LIN(16,2),LIN(17,2),
     3 LIN(21,2),LIN(22,2),LIN(23,2),LIN(24,2),LIN(25,2),LIN(26,2)/
     4 6,3,3,1,6,0,1,0,0,0,7,5,0,0,3,12,7,2,2,2,2,2,2/
C---------- ELEMENT TYPE 3 - 6 NODED LST (CONSOLIDATION ELEMENT)
      DATA LIN(1,3),LIN(2,3),LIN(3,3),LIN(4,3),LIN(5,3),LIN(6,3),
     1 LIN(7,3),LIN(8,3),LIN(9,3),LIN(10,3),LIN(11,3),LIN(12,3),
     2 LIN(13,3),LIN(14,3),LIN(15,3),LIN(16,3),LIN(17,3),LIN(21,3),
     3 LIN(22,3),LIN(23,3),LIN(24,3),LIN(25,3),LIN(26,3)/
     4 6,3,3,1,6,3,1,0,0,0,7,5,0,0,3,15,7,3,3,3,2,2,2/
C---------- ELEMENT TYPE 4 - 8 NODED LSQ
      DATA LIN(1,4),LIN(2,4),LIN(3,4),LIN(4,4),LIN(5,4),LIN(6,4),
     1 LIN(7,4),LIN(8,4),LIN(9,4),LIN(10,4),LIN(11,4),LIN(12,4),
     2 LIN(13,4),LIN(14,4),LIN(15,4),LIN(16,4),LIN(17,4),
     3 LIN(21,4),LIN(22,4),LIN(23,4),LIN(24,4),LIN(25,4),
     4 LIN(26,4),LIN(27,4),LIN(28,4)/
     4 8,4,4,1,8,0,1,0,0,0,9,12,4,3,2,16,9,2,2,2,2,2,2,2,2/
C---------- ELEMENT TYPE 5 - 8 NODED LSQ (CONSOLIDATION ELEMENT)
      DATA LIN(1,5),LIN(2,5),LIN(3,5),LIN(4,5),LIN(5,5),LIN(6,5),
     1 LIN(7,5),LIN(8,5),LIN(9,5),LIN(10,5),LIN(11,5),LIN(12,5),
     2 LIN(13,5),LIN(14,5),LIN(15,5),LIN(16,5),LIN(17,5),
     3 LIN(21,5),LIN(22,5),LIN(23,5),LIN(24,5),LIN(25,5),
     4 LIN(26,5),LIN(27,5),LIN(28,5)/
     4 8,4,4,1,8,4,1,0,0,0,9,12,4,3,2,20,9,3,3,3,3,2,2,2,2/
C---------- ELEMENT TYPE 6 - 15 NODED CUST
      DATA LIN(1,6),LIN(2,6),LIN(3,6),LIN(4,6),LIN(5,6),LIN(6,6),
     1 LIN(7,6),LIN(8,6),LIN(9,6),LIN(10,6),LIN(11,6),LIN(12,6),
     2 LIN(13,6),LIN(14,6),LIN(15,6),LIN(16,6),LIN(17,6),
     3 LIN(21,6),LIN(22,6),LIN(23,6),
     4 LIN(24,6),LIN(25,6),LIN(26,6),LIN(27,6),LIN(28,6),LIN(29,6),
     5 LIN(30,6),LIN(31,6),LIN(32,6),LIN(33,6),LIN(34,6),LIN(35,6)/
     5 15,3,3,1,15,0,3,0,3,0,16,21,0,0,3,30,16,
     6 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2/
C---------- ELEMENT TYPE 7 - 22 NODED CUST (CONSOLIDATION ELEMENT)
      DATA LIN(1,7),LIN(2,7),LIN(3,7),LIN(4,7),LIN(5,7),
     1 LIN(6,7),LIN(7,7),LIN(8,7),LIN(9,7),LIN(10,7),LIN(11,7),
     2 LIN(12,7),LIN(13,7),LIN(14,7),LIN(15,7),LIN(16,7),LIN(17,7),
     3 LIN(21,7),LIN(22,7),LIN(23,7),LIN(24,7),LIN(25,7),
     4 LIN(26,7),LIN(27,7),LIN(28,7),LIN(29,7),LIN(30,7),
     5 LIN(31,7),LIN(32,7),LIN(33,7),LIN(34,7),LIN(35,7),LIN(36,7),
     6 LIN(37,7),LIN(38,7),LIN(39,7),LIN(40,7),LIN(41,7),LIN(42,7)/
     7 22,3,3,1,15,10,3,2,3,1,16,21,0,0,3,40,16,3,3,3,2,2,2,2,2,2,2,2,2,
     8 2,2,2,1,1,1,1,1,1,1/
C---------- ELEMENT TYPE 8 - 20 NODED BRICK
      DATA LIN(1,8),LIN(2,8),LIN(3,8),LIN(4,8),LIN(5,8),LIN(6,8),
     1 LIN(7,8),LIN(8,8),LIN(9,8),LIN(10,8),LIN(11,8),LIN(12,8),
     2 LIN(13,8),LIN(14,8),LIN(15,8),LIN(16,8),LIN(17,8),
     3 LIN(21,8),LIN(22,8),LIN(23,8),LIN(24,8),LIN(25,8),
     4 LIN(26,8),LIN(27,8),LIN(28,8),
     4 LIN(29,8),LIN(30,8),LIN(31,8),LIN(32,8),LIN(33,8),LIN(34,8),
     5 LIN(35,8),LIN(36,8),LIN(37,8),LIN(38,8),LIN(39,8),LIN(40,8)/
     6 20,8,12,6,20,0,1,0,0,0,27,37,4,3,3,60,14,3,3,3,3,3,3,3,3,3,3,3,
     7 3,3,3,3,3,3,3,3,3/
C---------- ELEMENT TYPE 9 - 20 NODED BRICK (CONSOLIDATION ELEMENT)
      DATA LIN(1,9),LIN(2,9),LIN(3,9),LIN(4,9),LIN(5,9),
     1 LIN(6,9),LIN(7,9),LIN(8,9),LIN(9,9),LIN(10,9),
     2 LIN(11,9),LIN(12,9),LIN(13,9),LIN(14,9),LIN(15,9),LIN(16,9),
     3 LIN(17,9),LIN(21,9),LIN(22,9),LIN(23,9),LIN(24,9),LIN(25,9),
     4 LIN(26,9),LIN(27,9),LIN(28,9),LIN(29,9),LIN(30,9),LIN(31,9),
     5 LIN(32,9),LIN(33,9),LIN(34,9),LIN(35,9),LIN(36,9),LIN(37,9),
     6 LIN(38,9),LIN(39,9),LIN(40,9)/
     7 20,8,12,6,20,8,1,0,0,0,27,37,4,3,3,68,14,4,4,4,4,4,4,4,4,
     8 3,3,3,3,3,3,3,3,3,3,3,3/
C---------- ELEMENT TYPE 10 - 10 NODED TETRA HEDRA
      DATA LIN(1,10),LIN(2,10),LIN(3,10),LIN(4,10),LIN(5,10),
     1 LIN(6,10),LIN(7,10),LIN(8,10),LIN(9,10),LIN(10,10),
     2 LIN(11,10),LIN(12,10),LIN(13,10),LIN(14,10),LIN(15,10),
     3 LIN(16,10),LIN(17,10),LIN(21,10),LIN(22,10),LIN(23,10),
     4 LIN(24,10),LIN(25,10),LIN(26,10),LIN(27,10),LIN(28,10),
     5 LIN(29,10),LIN(30,10)/
     5 10,4,6,4,10,0,1,0,0,0,4,64,28,15,4,30,0,3,3,3,3,3,3,3,3,3,3/
C---------- ELEMENT TYPE 11 - 10 NODED TETRA HEDRA (CONSOLIDATION)
      DATA LIN(1,11),LIN(2,11),LIN(3,11),LIN(4,11),LIN(5,11),
     1 LIN(6,11),LIN(7,11),LIN(8,11),LIN(9,11),LIN(10,11),
     2 LIN(11,11),LIN(12,11),LIN(13,11),LIN(14,11),LIN(15,11),
     3 LIN(16,11),LIN(17,11),LIN(21,11),LIN(22,11),LIN(23,11),
     4 LIN(24,11),LIN(25,11),LIN(26,11),LIN(27,11),LIN(28,11),
     5 LIN(29,11),LIN(30,11)/
     5 10,4,6,4,10,4,1,0,0,0,4,64,28,15,4,34,0,4,4,4,4,3,3,3,3,3,3/
C---------- ELEMENT TYPE 12 - 3 NODED BEAM
      DATA LIN(1,12),LIN(2,12),LIN(3,12),LIN(4,12),LIN(5,12),
     +     LIN(6,12),LIN(7,12),LIN(8,12),LIN(9,12),LIN(10,12),
     +     LIN(11,12),LIN(12,12),LIN(13,12),LIN(14,12),LIN(15,12),
     +     LIN(16,12),LIN(17,12),LIN(21,12),LIN(22,12),LIN(23,12)/
     +     3,2,1,1,3,0,1,0,0,0,5,0,0,0,1,9,3,3,3,3/
C---------- ELEMENT TYPE 13 - JOINT ELEMENT
      DATA LIN(1,13),LIN(2,13),LIN(3,13),LIN(4,13),LIN(5,13),
     +     LIN(6,13),LIN(7,13),LIN(8,13),LIN(9,13),LIN(10,13),
     +     LIN(11,13),LIN(12,13),LIN(13,13),LIN(14,13),LIN(15,13),
     +     LIN(16,13),LIN(17,13),LIN(21,13),LIN(22,13),LIN(23,13),
     +     LIN(24,13),LIN(25,13),LIN(26,13),LIN(27,13),LIN(28,13)/
     +     8,4,4,1,8,0,1,0,0,0,5,0,0,3,1,12,3,2,2,2,2,2,0,2,0/
C---------- ELEMENT TYPE 14 - 2 NODED BAR
      DATA LIN(1,14),LIN(2,14),LIN(3,14),LIN(4,14),LIN(5,14),
     +     LIN(6,14),LIN(7,14),LIN(8,14),LIN(9,14),LIN(10,14),
     +     LIN(11,14),LIN(12,14),LIN(13,14),LIN(14,14),LIN(15,14),
     +     LIN(16,14),LIN(17,14),LIN(21,14),LIN(22,14)/
     +     2,2,0,1,2,0,0,0,0,0,5,0,0,0,1,4,3,2,2/
C---------- ELEMENT TYPE 15 - 2 NODED BEAM
      DATA LIN(1,15),LIN(2,15),LIN(3,15),LIN(4,15),LIN(5,15),
     +     LIN(6,15),LIN(7,15),LIN(8,15),LIN(9,15),LIN(10,15),
     +     LIN(11,15),LIN(12,15),LIN(13,15),LIN(14,15),LIN(15,15),
     +     LIN(16,15),LIN(17,15),LIN(21,15),LIN(22,15)/
     +     2,2,0,1,2,0,0,0,0,0,5,0,0,0,1,6,3,3,3/
C======================================================================
C                           MIN
C======================================================================
C---------- ELEMENT TYPE 1
      DATA MIN(1,1,1),MIN(2,1,1),MIN(1,2,1),MIN(2,2,1),MIN(1,3,1),
     +     MIN(2,3,1)/
     +     1,2,1,2,1,2/
C--------- ELEMENT TYPE 2
      DATA MIN(1,1,2),MIN(2,1,2),MIN(1,2,2),MIN(2,2,2),MIN(1,3,2),
     +     MIN(2,3,2),MIN(1,4,2),MIN(2,4,2),MIN(1,5,2),MIN(2,5,2),
     +     MIN(1,6,2),MIN(2,6,2)/
     +     1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 3
      DATA MIN(1,1,3),MIN(2,1,3),MIN(3,1,3),MIN(1,2,3),MIN(2,2,3),
     +     MIN(3,2,3),MIN(1,3,3),MIN(2,3,3),MIN(3,3,3),MIN(1,4,3),
     +     MIN(2,4,3),MIN(1,5,3),MIN(2,5,3),MIN(1,6,3),MIN(2,6,3)/
     +     1,2,4,1,2,4,1,2,4,1,2,1,2,1,2/
C--------- ELEMENT TYPE 4
      DATA MIN(1,1,4),MIN(2,1,4),MIN(1,2,4),MIN(2,2,4),MIN(1,3,4),
     +     MIN(2,3,4),MIN(1,4,4),MIN(2,4,4),MIN(1,5,4),MIN(2,5,4),
     +     MIN(1,6,4),MIN(2,6,4),MIN(1,7,4),MIN(2,7,4),MIN(1,8,4),
     +     MIN(2,8,4)/
     +     1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 5
      DATA MIN(1,1,5),MIN(2,1,5),MIN(3,1,5),MIN(1,2,5),MIN(2,2,5),
     +     MIN(3,2,5),MIN(1,3,5),MIN(2,3,5),MIN(3,3,5),MIN(1,4,5),
     +     MIN(2,4,5),MIN(3,4,5),MIN(1,5,5),MIN(2,5,5),MIN(1,6,5),
     +     MIN(2,6,5),MIN(1,7,5),MIN(2,7,5),MIN(1,8,5),MIN(2,8,5)/
     +     1,2,4,1,2,4,1,2,4,1,2,4,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 6
      DATA MIN(1,1,6),MIN(2,1,6),MIN(1,2,6),MIN(2,2,6),MIN(1,3,6),
     +     MIN(2,3,6),MIN(1,4,6),MIN(2,4,6),MIN(1,5,6),MIN(2,5,6),
     +     MIN(1,6,6),MIN(2,6,6),MIN(1,7,6),MIN(2,7,6),MIN(1,8,6),
     +     MIN(2,8,6),MIN(1,9,6),MIN(2,9,6),MIN(1,10,6),MIN(2,10,6),
     +     MIN(1,11,6),MIN(2,11,6),MIN(1,12,6),MIN(2,12,6),MIN(1,13,6),
     +     MIN(2,13,6),MIN(1,14,6),MIN(2,14,6),MIN(1,15,6),MIN(2,15,6)/
     +     1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 7
      DATA MIN(1,1,7),MIN(2,1,7),MIN(3,1,7),MIN(1,2,7),MIN(2,2,7),
     +     MIN(3,2,7),MIN(1,3,7),MIN(2,3,7),MIN(3,3,7),MIN(1,4,7),
     +     MIN(2,4,7),MIN(1,5,7),MIN(2,5,7),MIN(1,6,7),MIN(2,6,7),
     +     MIN(1,7,7),MIN(2,7,7),MIN(1,8,7),MIN(2,8,7),MIN(1,9,7),
     +     MIN(2,9,7),MIN(1,10,7),MIN(2,10,7),MIN(1,11,7),MIN(2,11,7),
     +     MIN(1,12,7),MIN(2,12,7),MIN(1,13,7),MIN(2,13,7),MIN(1,14,7),
     +     MIN(2,14,7),MIN(1,15,7),MIN(2,15,7),MIN(1,16,7),MIN(1,17,7),
     +     MIN(1,18,7),MIN(1,19,7),MIN(1,20,7),MIN(1,21,7),MIN(1,22,7)/
     +     1,2,4,1,2,4,1,2,4,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
     +     1,2,1,2,1,2,4,4,4,4,4,4,4/
C--------- ELEMENT TYPE 8
      DATA MIN(1,1,8),MIN(2,1,8),MIN(3,1,8),MIN(1,2,8),MIN(2,2,8),
     +     MIN(3,2,8),MIN(1,3,8),MIN(2,3,8),MIN(3,3,8),MIN(1,4,8),
     +     MIN(2,4,8),MIN(3,4,8),MIN(1,5,8),MIN(2,5,8),MIN(3,5,8),
     +     MIN(1,6,8),MIN(2,6,8),MIN(3,6,8),MIN(1,7,8),MIN(2,7,8),
     +     MIN(3,7,8),MIN(1,8,8),MIN(2,8,8),MIN(3,8,8),MIN(1,9,8),
     +     MIN(2,9,8),MIN(3,9,8),MIN(1,10,8),MIN(2,10,8),MIN(3,10,8),
     +     MIN(1,11,8),MIN(2,11,8),MIN(3,11,8),MIN(1,12,8),MIN(2,12,8),
     +     MIN(3,12,8),MIN(1,13,8),MIN(2,13,8),MIN(3,13,8),MIN(1,14,8),
     +     MIN(2,14,8),MIN(3,14,8),MIN(1,15,8),MIN(2,15,8),MIN(3,15,8),
     +     MIN(1,16,8),MIN(2,16,8),MIN(3,16,8),MIN(1,17,8),MIN(2,17,8),
     +     MIN(3,17,8),MIN(1,18,8),MIN(2,18,8),MIN(3,18,8),MIN(1,19,8),
     +     MIN(2,19,8),MIN(3,19,8),MIN(1,20,8),MIN(2,20,8),MIN(3,20,8)/
     +     1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 9
      DATA MIN(1,1,9),MIN(2,1,9),MIN(3,1,9),MIN(4,1,9),MIN(1,2,9),
     +     MIN(2,2,9),MIN(3,2,9),MIN(4,2,9),MIN(1,3,9),MIN(2,3,9),
     +     MIN(3,3,9),MIN(4,3,9),MIN(1,4,9),MIN(2,4,9),MIN(3,4,9),
     +     MIN(4,4,9),MIN(1,5,9),MIN(2,5,9),MIN(3,5,9),MIN(4,5,9),
     +     MIN(1,6,9),MIN(2,6,9),MIN(3,6,9),MIN(4,6,9),MIN(1,7,9),
     +     MIN(2,7,9),MIN(3,7,9),MIN(4,7,9),MIN(1,8,9),MIN(2,8,9),
     +     MIN(3,8,9),MIN(4,8,9),MIN(1,9,9),MIN(2,9,9),MIN(3,9,9),
     +     MIN(1,10,9),MIN(2,10,9),MIN(3,10,9),MIN(1,11,9),MIN(2,11,9),
     +     MIN(3,11,9),MIN(1,12,9),MIN(2,12,9),MIN(3,12,9),MIN(1,13,9),
     +     MIN(2,13,9),MIN(3,13,9),MIN(1,14,9),MIN(2,14,9),MIN(3,14,9),
     +     MIN(1,15,9),MIN(2,15,9),MIN(3,15,9),MIN(1,16,9),MIN(2,16,9),
     +     MIN(3,16,9),MIN(1,17,9),MIN(2,17,9),MIN(3,17,9),MIN(1,18,9),
     +     MIN(2,18,9),MIN(3,18,9),MIN(1,19,9),MIN(2,19,9),MIN(3,19,9),
     +     MIN(1,20,9),MIN(2,20,9),MIN(3,20,9)/
     +     1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,
     +     1,2,3,4,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 10
      DATA MIN(1,1,10),MIN(2,1,10),MIN(3,1,10),MIN(1,2,10),MIN(2,2,10),
     +   MIN(3,2,10),MIN(1,3,10),MIN(2,3,10),MIN(3,3,10),MIN(1,4,10),
     +   MIN(2,4,10),MIN(3,4,10),MIN(1,5,10),MIN(2,5,10),MIN(3,5,10),
     +   MIN(1,6,10),MIN(2,6,10),MIN(3,6,10),MIN(1,7,10),MIN(2,7,10),
     +   MIN(3,7,10),MIN(1,8,10),MIN(2,8,10),MIN(3,8,10),MIN(1,9,10),
     +   MIN(2,9,10),MIN(3,9,10),MIN(1,10,10),MIN(2,10,10),MIN(3,10,10)/
     +   1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 11
      DATA MIN(1,1,11),MIN(2,1,11),MIN(3,1,11),MIN(4,1,11),MIN(1,2,11),
     +     MIN(2,2,11),MIN(3,2,11),MIN(4,2,11),MIN(1,3,11),MIN(2,3,11),
     +     MIN(3,3,11),MIN(4,3,11),MIN(1,4,11),MIN(2,4,11),MIN(3,4,11),
     +     MIN(4,4,11),MIN(1,5,11),MIN(2,5,11),MIN(3,5,11),MIN(1,6,11),
     +     MIN(2,6,11),MIN(3,6,11),MIN(1,7,11),MIN(2,7,11),MIN(3,7,11),
     +     MIN(1,8,11),MIN(2,8,11),MIN(3,8,11),MIN(1,9,11),MIN(2,9,11),
     +     MIN(3,9,11),MIN(1,10,11),MIN(2,10,11),MIN(3,10,11)/
     +     1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3/
C--------- ELEMENT TYPE 12
      DATA MIN(1,1,12),MIN(2,1,12),MIN(3,1,12),MIN(1,2,12),MIN(2,2,12),
     +     MIN(3,2,12),MIN(1,3,12),MIN(2,3,12),MIN(3,3,12)/
     +     1,2,5,1,2,5,1,2,5/
C--------- ELEMENT TYPE 13
      DATA MIN(1,1,13),MIN(2,1,13),MIN(1,2,13),MIN(2,2,13),MIN(1,3,13),
     +     MIN(2,3,13),MIN(1,4,13),MIN(2,4,13),MIN(1,5,13),MIN(2,5,13),
     +     MIN(1,7,13),MIN(2,7,13)/
     +     1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 14
      DATA MIN(1,1,14),MIN(2,1,14),MIN(1,2,14),MIN(2,2,14)/
     +     1,2,1,2/
C--------- ELEMENT TYPE 15
      DATA MIN(1,1,15),MIN(2,1,15),MIN(3,1,15),MIN(1,2,15),MIN(2,2,15),
     +     MIN(3,2,15)/
     +     1,2,5,1,2,5/
C-----------------------------------------------------------------------
C     ONE-DIMENSIONAL INTEGRATION - FOR ELEMENT TYPES 1, 12 AND 13
C-----------------------------------------------------------------------
      DATA L(1,1),L(1,2),L(1,3),L(1,4),L(1,5)/
     + -0.906179845938664,-0.538469310105683,0.0,
     + 0.538469310105683,0.906179845938664/
      DATA W(1),W(2),W(3),W(4),W(5)/
     + 0.236926885056189,0.478628670499366,0.568888888888889,
     + 0.478628670499366,0.236926885056189/
C-----------------------------------------------------------------------
C     AREA COORDINATES - LINEAR STRAIN TRIANGLE - ELEMENT TYPE 2,3
C-----------------------------------------------------------------------
      DATA L(1,6),L(2,6),L(3,6),L(1,7),L(2,7),L(3,7),L(1,8),L(2,8),
     1 L(3,8),L(1,9),L(2,9),L(3,9),L(1,10),L(2,10),L(3,10),L(1,11),
     1 L(2,11),L(3,11),L(1,12),L(2,12),L(3,12)/
     1 .797426985353087245,.101286507323456343,.101286507323456343
     1,.101286507323456343,.797426985353087245,.101286507323456343
     1,.101286507323456343,.101286507323456343,.797426985353087245
     1,.597158717897698279E-01,.470142064105115082,.470142064105115082
     1,.470142064105115082,.597158717897698279E-01,.470142064105115082
     1,.470142064105115082,.470142064105115082,.597158717897698279E-01
     1,.333333333333333329,.333333333333333329,.333333333333333329/
C-----------------------------------------------------------------------
C     LOCAL COORDINATES - LINEAR STRAIN QUADRILATERAL - ELEMENT TYPE 4,5
C-----------------------------------------------------------------------
      DATA L(1,13),L(2,13),L(1,14),L(2,14),L(1,15),L(2,15),
     1 L(1,16),L(2,16),L(1,17),L(2,17),L(1,18),L(2,18),
     1 L(1,19),L(2,19),L(1,20),L(2,20),L(1,21),L(2,21)/
     1 -0.774596669241483,-0.774596669241483,
     1  0.774596669241483,-0.774596669241483,
     1  0.774596669241483, 0.774596669241483,
     1 -0.774596669241483, 0.774596669241483,
     1  0.,-0.774596669241483,
     1  0.774596669241483,0.,
     1  0., 0.774596669241483,
     1 -0.774596669241483,0.,
     1  0.,0./
C-----------------------------------------------------------------------
C     AREA COORDINATES - CUBIC STRAIN TRIANGLE - ELEMENT TYPE 6,7
C-----------------------------------------------------------------------
      DATA L(1,22),L(2,22),L(3,22),L(1,23),L(2,23),L(3,23),L(1,24),
     1 L(2,24),L(3,24),L(1,25),L(2,25),L(3,25),L(1,26),L(2,26),L(3,26),
     1 L(1,27),L(2,27),L(3,27),L(1,28),L(2,28),L(3,28),L(1,29),
     1 L(2,29),L(3,29)/
     1 0.898905543365938,0.050547228317031,0.050547228317031,
     1 0.050547228317031,0.898905543365938,0.050547228317031,
     1 0.050547228317031,0.050547228317031,0.898905543365938,
     1 0.658861384496478,0.170569307751761,0.170569307751761,
     1 0.170569307751761,0.658861384496478,0.170569307751761,
     1 0.170569307751761,0.170569307751761,0.658861384496478,
     1 0.081414823414554,0.459292588292723,0.459292588292723,
     1 0.459292588292723,0.081414823414554,0.459292588292723/
      DATA L(1,30),L(2,30),L(3,30),L(1,31),L(2,31),L(3,31),
     1 L(1,32),L(2,32),L(3,32),L(1,33),L(2,33),L(3,33),L(1,34),L(2,34),
     1 L(3,34),L(1,35),L(2,35),L(3,35),L(1,36),L(2,36),L(3,36),
     1 L(1,37),L(2,37),L(3,37)/
     1 0.459292588292723,0.459292588292723,0.081414823414554,
     1 0.008394777409958,0.728492392955404,0.263112829634638,
     1 0.008394777409958,0.263112829634638,0.728492392955404,
     1 0.263112829634638,0.008394777409958,0.728492392955404,
     1 0.728492392955404,0.008394777409958,0.263112829634638,
     1 0.728492392955404,0.263112829634638,0.008394777409958,
     1 0.263112829634638,0.728492392955404,0.008394777409958,
     1 0.333333333333333,0.333333333333333,0.333333333333333/
C-----------------------------------------------------------------------
C     WEIGHTS - LINEAR STRAIN TRIANGLE - ELEMENT TYPE 2,3
C-----------------------------------------------------------------------
      DATA W(6),W(7),W(8),W(9),W(10),W(11),W(12)/
     1 .125939180544827140,.125939180544827140,.125939180544827140
     1,.132394152788506178,.132394152788506178,.132394152788506178
     1,.224999999999999992/
C-----------------------------------------------------------------------
C     WEIGHTS - LINEAR STRAIN QUADRILATERAL - ELEMENT TYPE 4,5
C-----------------------------------------------------------------------
      DATA W(13),W(14),W(15),W(16),W(17),W(18),W(19),W(20),W(21)/
     1 0.30864197530864,0.30864197530864,
     1 0.30864197530864,0.30864197530864,
     1 0.49382716049383,0.49382716049383,
     1 0.49382716049383,0.49382716049383,0.79012345679012/
C-----------------------------------------------------------------------
C     WEIGHTS - CUBIC STRAIN TRIANGLE - ELEMENT TYPE 6,7
C-----------------------------------------------------------------------
      DATA W(22),W(23),W(24),W(25),W(26),W(27),W(28),W(29),
     1 W(30),W(31),W(32),W(33),W(34),W(35),W(36),W(37)/
     1 0.032458497623198,0.032458497623198,0.032458497623198,
     1 0.103217370534718,0.103217370534718,0.103217370534718,
     1 0.095091634267284,0.095091634267284,0.095091634267284,
     1 0.027230314174435,0.027230314174435,0.027230314174435,
     1 0.027230314174435,0.027230314174435,0.027230314174435,
     1 0.144315607677787/
C-----------------------------------------------------------------------
C     ONE-DIMENSIONAL INTEGRATION
C-----------------------------------------------------------------------
      DATA POSSP(1),POSSP(2),POSSP(3),POSSP(4),POSSP(5)/
     1 -0.906179845938664,-0.538469310105683,0.0,
     1 0.538469310105683,0.906179845938664/
      DATA WEIGP(1),WEIGP(2),WEIGP(3),WEIGP(4),WEIGP(5)/
     1 0.236926885056189,0.478628670499366,0.568888888888889,
     1 0.478628670499366,0.236926885056189/
      END
      SUBROUTINE CALDOF(IW6,NN,MXDF,NDF,NQ,KGVN,KDF)
C***********************************************************************
C     ROUTINE TO CALCULATE GLOBAL NUMBER FOR D.O.F.
C***********************************************************************
      DIMENSION NQ(NN),KGVN(MXDF,NN),KDF(MXDF,NN)
C
      NC=0
C
      DO 10 J=1,NN
      DO 10 I=1,MXDF
   10 KGVN(I,J)=0
C
      DO 30 J=1,NN
      DO 20 I=1,MXDF
      IF(KDF(I,J).EQ.0)GOTO 20
      NC=NC+1
      KGVN(I,J)=NC
   20 CONTINUE
   30 CONTINUE
      NDF=NC
      RETURN
      END
      SUBROUTINE CHKOPT(IW6,MREL,MRELVV,MFRU,NEL,MUMAX)
C
C***********************************************************************
C
C     ROUTINE TO CHECK OPTIMUM ELEMENT NUMBERING FOR ASSEMBLY
C     LAST MODIFIED ON 19 FEB 92
C***********************************************************************
C
      DIMENSION MREL(MUMAX),MRELVV(NEL),MFRU(NEL)
      DIMENSION LISTO(10),IPSNO(10),LISTB(10),IPSNB(10)
      COMMON /DEVSUP/ IW15,IWS
C
      IOC=0
      IOB=0
      IERRC=0
C
      DO 100 IL=1,NEL
      JU=MFRU(IL)
      IF(JU.LE.0.OR.JU.GT.MUMAX) THEN
         IOC=IOC+1
         IERRC=IERRC+1
         IF(IOC.GE.10) THEN
            WRITE(IWS,900)(LISTO(IK),IK=1,10)
            WRITE(IW15,900)(LISTO(IK),IK=1,10)
            WRITE(IW6,900)(LISTO(IK),IK=1,10)
C
            WRITE(IWS,910)(IPSNO(IP),IP=1,10)
            WRITE(IW15,910)(IPSNO(IP),IP=1,10)
            WRITE(IW6,910)(IPSNO(IP),IP=1,10)
C
  900       FORMAT(/1X,'*** Error : Inadmissible element numbers',
     +              1X,'in optimum element numbering list'/
     +              1X,'Element no. :',10I6)
  910       FORMAT(/1X,'Position    :',10I6)
            IOC=1
            LISTO(IOC)=JU
            IPSNO(IOC)=IL
         ELSE
            LISTO(IOC)=JU
            IPSNO(IOC)=IL
         ENDIF
C
C--------NON-EXISTANT ELEMENT NUMBER
      ELSE IF(MREL(JU).EQ.0) THEN
         IOC=IOC+1
         IERRC=IERRC+1
         IF(IOC.GE.10) THEN
            WRITE(IWS,900)(LISTO(IK),IK=1,10)
            WRITE(IW15,900)(LISTO(IK),IK=1,10)
            WRITE(IW6,900)(LISTO(IK),IK=1,10)
C
            WRITE(IWS,910)(IPSNO(IP),IP=1,10)
            WRITE(IW15,910)(IPSNO(IP),IP=1,10)
            WRITE(IW6,910)(IPSNO(IP),IP=1,10)
            IOC=1
            LISTO(IOC)=JU
            IPSNO(IOC)=IL
         ELSE
            LISTO(IOC)=JU
            IPSNO(IOC)=IL
         ENDIF
C
C-------PERMITTED ELEMENT NO. BUT HAS APPEARED BEFORE
      ELSE IF(MREL(JU).LT.0) THEN
         IOB=IOB+1
         IERRC=IERRC+1
         IF(IOB.GE.10) THEN
            WRITE(IWS,950)(LISTB(IK),IK=1,10)
            WRITE(IW15,950)(LISTB(IK),IK=1,10)
            WRITE(IW6,950)(LISTB(IK),IK=1,10)
C
            WRITE(IWS,960)(IPSNB(IP),IP=1,10)
            WRITE(IW15,960)(IPSNB(IP),IP=1,10)
            WRITE(IW6,960)(IPSNB(IP),IP=1,10)
  950       FORMAT(/1X,'*** Error : following element numbers',
     +              1X,'have appeared before',
     +              1X,'in optimum element numbering list'/
     +              1X,'Element no. :',10I6)
  960       FORMAT(/1X,'Position    :',10I6)
            IOB=1
            LISTB(IOB)=JU
            IPSNB(IOB)=IL
         ELSE
            LISTB(IOB)=JU
            IPSNB(IOB)=IL
         ENDIF
C
C--------present element appearing for the first time
C--------make number negative
      ELSE
         MREL(JU)=-MREL(JU)
      ENDIF
  100 CONTINUE
C
      IF(IOC.GT.0) THEN
         WRITE(IWS,900)(LISTO(IK),IK=1,IOC)
         WRITE(IW15,900)(LISTO(IK),IK=1,IOC)
         WRITE(IW6,900)(LISTO(IK),IK=1,IOC)
C
         WRITE(IWS,910)(IPSNO(IP),IP=1,IOC)
         WRITE(IW15,910)(IPSNO(IP),IP=1,IOC)
         WRITE(IW6,910)(IPSNO(IP),IP=1,IOC)
         IOC=0
      ENDIF
C
      IF(IOB.GT.0) THEN
         WRITE(IWS,950)(LISTB(IK),IK=1,IOB)
         WRITE(IW15,950)(LISTB(IK),IK=1,IOB)
         WRITE(IW6,950)(LISTB(IK),IK=1,IOB)
C
         WRITE(IWS,960)(IPSNB(IP),IP=1,IOB)
         WRITE(IW15,960)(IPSNB(IP),IP=1,IOB)
         WRITE(IW6,960)(IPSNB(IP),IP=1,IOB)
         IOB=0
      ENDIF
C
C--------make sure all the elements are present
      IOC=0
      DO 200 IU=1,MUMAX
      IP=MREL(IU)
      IF(IP.EQ.0) GOTO 200
C
      IF(IP.GT.0) THEN
         IOC=IOC+1
         IERRC=IERRC+1
         IF(IOC.GE.10) THEN
            WRITE(IWS,980)(LISTO(IK),IK=1,10)
            WRITE(IW15,980)(LISTO(IK),IK=1,10)
            WRITE(IW6,980)(LISTO(IK),IK=1,10)
  980       FORMAT(/1X,'*** Error : The following element numbers',
     +              1X,'have not appeared',
     +              1X,'in optimum element numbering list'/
     +              1X,'Element no. :',10I6)
            IOC=1
            LISTO(IOC)=IU
         ELSE
            LISTO(IOC)=IU
         ENDIF
      ENDIF
  200 CONTINUE
C
C-------make nos positive again
      DO 300 IL=1,NEL
      JU=MRELVV(IL)
      IP=MREL(JU)
      MREL(JU)=IABS(IP)
  300 CONTINUE
C
      IF(IERRC.GT.0) THEN
         WRITE(IWS,1000)
         WRITE(IW15,1000)
         WRITE(IW6,1000)
 1000    FORMAT(/1X,50(1H*)/
     +           1X,'PROGRAM STOPPED DUE TO ERRORS IN THE',
     +           1X,'OPTIMUM ELEMENT NUMBERING LIST'/
     +           1X,'(ROUTINE CHKOPT)'/)
         STOP
      ENDIF
      RETURN
      END
      SUBROUTINE CHKNOD(IW6,NLST,NREL,NNU,MXNDV,NV,KEL,NUMAX,IERK)
C
C***********************************************************************
C
C     ROUTINE TO CHECK NODES ASSOCIATED WITH ELEMENTS ARE ADMISSIBLE
C     AND NODES ARE NOT REPEATED.
C     LAST MODIFIED ON 19 FEB 92
C***********************************************************************
C
      DIMENSION NLST(MXNDV),NREL(NNU)
      COMMON /DEVSUP/ IW15,IWS
C
      IER=0
      DO 40 IL=1,NV
      NU=NLST(IL)
      IF(NU.LE.0.OR.NU.GT.NUMAX) THEN
         IERK=IERK+1
         IER=IER+1
         WRITE(IWS,900)NU,KEL
         WRITE(IW15,900)NU,KEL
         WRITE(IW6,900)NU,KEL
  900    FORMAT(1X,'**** Error : Inadmissible node no.',I10,2X
     +         /1X,'             associated with element',I10)
      ENDIF
   40 CONTINUE
C
      IF(IER.NE.0) RETURN
C
C--------CHECK FOR THE PRESENCE OF REPEATED NODE NO.
      NVM1=NV-1
      DO 100 IL=1,NVM1
      NUC=NLST(IL)
      INXT=IL+1
      DO 80 IN=INXT,NV
      NUR=NLST(IN)
      IF(NUC.EQ.NUR) THEN
         IERK=IERK+1
         WRITE(IWS,920)NUC,KEL
         WRITE(IW15,920)NUC,KEL
         WRITE(IW6,920)NUC,KEL
  920    FORMAT(/1X,'**** Error : Node ',I8,2X,'appears more than'/
     +           1X,'             once in connectivity list for'/
     +           1X,'             element',I8)
      ENDIF
   80 CONTINUE
  100 CONTINUE
      RETURN
      END
      SUBROUTINE CHKSZQ(IW6,IW2,LG,LK,LZ,MZ,PG,IMERR,ICODE)
C
C***********************************************************************
C     NON-GRAPHICS VERSION OF CHKSZM.
C
C     Program calculates that the array size required for G and K
C     do not exceed the values set in CRISP92.SZE.
C
C     IW6 - output to file.
C     IW2 - output to screen.
C
C     LG - size of array G set in CRISP92.SZE
C     LK - size of array K set in CRISP92.SZE
C     LZ - size of array G required for the analysis
C     LK - size of array K required for the analysis
C
C     PG - Progran identifier  (2 character name)
C
C     ICODE - code to indicate which of the arrays (G & K) have
C             to be checked.
C
C           KG
C            1  - check size of array G only
C           10  - check size of array K only
C           11  - check size of arrays G and K
C
C     ROUTINE LAST MODIFIED ON 6 FEB 93
C     WRITTEN BY ARUL M BRITTO
C***********************************************************************
C
CC    INCLUDE 'GAT.PRV'
CC    INCLUDE 'MW.PBL'
CC    INTEGER EVENT(6)
      CHARACTER*2 PG
      COMMON /DEVSUP/ IW15,IWS
C
      IK=ICODE/10
      IG=MOD(ICODE,10)
C
      IF(IK.EQ.1) THEN
      IMERR=0
      IF(MZ.LE.LK) THEN
         WRITE(IW6,902)MZ,LK
  902    FORMAT(/1X,'ARRAY STORE K  - USED',I7,'  OUT OF ALLOCATED',I7)
      ELSE
         INCS=MZ-LK
C        WRITE(IWS,901)INCS,LK,PG,PG,MZ
         WRITE(IW15,901)INCS,LK,PG,PG,MZ
         WRITE(IW6,901)INCS,LK,PG,PG,MZ
C--------SWITCH TO TEXTMODE
C        CALL BACKCOLOR(0)
C        CALL ERASERECT(SCREEN)
CC       CALL SETDISPLAY(TEXTPG0)
CC       CALL CLEARTEXT
CC       CALL FLUSHREALMODEBUFFER
         WRITE(IW2,901)INCS,LK,PG,PG,MZ
C 901    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY K IN /GVAR/** BY',I8,
C    +    2X,15H(ROUTINE CHKSZQ)
  901    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY  K  BY',I10,'.',
     +    2X,'(Message from routine CHKSZQ)'/
     +    6X,'CURRENT SIZE OF ARRAY  K  IS ',I10,2X,'IS INSUFFICIENT.'/
     + /6X,'This is done by increasing the size of the parameter LK',
     +  A2/6X,'in the file CRISP92.SZE.'/
     +  6X,'Set  LK',A2,' to at least ',I10,2X,'in File CRISP92.SZE'/)
         IMERR=IMERR+1
      ENDIF
      ENDIF
C
      IF(IG.EQ.1) THEN
      IF(LZ.LE.LG) THEN
         WRITE(IW6,912)LZ,LG
  912    FORMAT(/1X,'ARRAY STORE G  - USED',I7,'  OUT OF ALLOCATED',I7)
      ELSE
         INCS=LZ-LG
C        WRITE(IWS,911)INCS,LG,PG,PG,LZ
         WRITE(IW15,911)INCS,LG,PG,PG,LZ
         WRITE(IW6,911)INCS,LG,PG,PG,LZ
C--------SWITCH TO TEXTMODE
         IF(IMERR.EQ.0) THEN
C           CALL BACKCOLOR(0)
C           CALL ERASERECT(SCREEN)
CC          CALL SETDISPLAY(TEXTPG0)
CC          CALL CLEARTEXT
CC          CALL FLUSHREALMODEBUFFER
         ENDIF
C
         WRITE(IW2,911)INCS,LG,PG,PG,LZ
C 911    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY G IN /GVAR/** BY',I8,
C    +    2X,15H(ROUTINE CHKSZQ)
  911    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY  G  BY',I10,'.',
     +    2X,'(Message from routine CHKSZQ)'/
     +    6X,'CURRENT SIZE OF ARRAY  G  IS ',I10,2X,'IS INSUFFICIENT.'/
     + /6X,'This is done by increasing the size of the parameter LG',
     +  A2/6X,'in the file CRISP92.SZE.'/
     +  6X,'Set  LG',A2,' to at least ',I10,2X,'in File CRISP92.SZE'/)
         IMERR=IMERR+1
      ENDIF
      ENDIF
C
      IF(IMERR.GT.0) THEN
         WRITE(IW2,935)
  935    FORMAT(/1X,'*****',1X,
     +    'Make sure that your system has sufficient MEMORY to meet'/
     +  6X,'this requirement. If in doubt consult the notes given in'/
     +  6X,'the CRISP92.SZE file.'/)
CC   +  1X,' ***** PRESS THE RETURN KEY *****')
CC       CALL GETEVENT(EVENT,0)
CC       CALL GSTOP
         STOP
      ENDIF
C
      RETURN
      END
      SUBROUTINE CHKSZN(IW6,IW2,LG,LK,LZ,MZ,LGMX,LKMX,PG,IMERR,ICODE)
C
C***********************************************************************
C     [1 MAY 93]
C
C     Modified version of CHKSZM to check the memory available
C     in the computer. Also checks that the requested array sizes
C     do not exceed the array sizes set in the program.
C
C     NON-GRAPHICS VERSION OF CHKSZM.
C
C     Program calculates that the array size required for G and K
C     do not exceed the values set in CRISP92.SZE.
C
C     IW6 - output to file.
C     IW2 - output to screen.
C
C     LG   - size of array G set in CRISP92.SZE  file
C     LK   - size of array K set in CRISP92.SZE  file
C     LGMX - size of array G set in program.
C     LKMX - size of array K set in program.
C     LZ   - size of array G required for the analysis
C     LK   - size of array K required for the analysis
C
C     PG - Progran identifier  (2 character name)
C
C     ICODE - code to indicate which of the arrays (G & K) have
C             to be checked.
C
C           KG
C            1  - check size of array G only
C           10  - check size of array K only
C           11  - check size of arrays G and K
C
C     ROUTINE LAST MODIFIED ON 6 FEB 93
C     WRITTEN BY ARUL M BRITTO
C***********************************************************************
C
CC    INCLUDE 'GAT.PRV'
CC    INCLUDE 'MW.PBL'
CC    INTEGER EVENT(6)
      CHARACTER*2 PG
      EXTERNAL MY_ERROR_HANDLER
C
      INCSK=0
      INCSG=0
C
      CALL GET_MEMORY_INFO@(NP1,NP2,NP3,NP4,NP5,NP6,NP7)
C--------KTOT - available no. of locations
      KTOT=(NP3+NP4)*1024
C--------estimate of locations required for other arrays
      KREST=50000
      KREQ=LZ+MZ+KREST
      IF(KREQ.LE.KTOT) THEN
         WRITE(IW2,912)KTOT,KREQ
         WRITE(IW6,912)KTOT,KREQ
  912    FORMAT(/
     +      1X,'Total number of locations available       =',I15/
     +      1X,'Total number of locations required        =',I15/)
C
      ELSE IF(KREQ.GT.KTOT) THEN
         KMORE=KREQ-KTOT
         KMOREB=KMORE*4/1000
         WRITE(IW2,914)KTOT,KREQ,KMORE,KMOREB
         WRITE(IW6,914)KTOT,KREQ,KMORE,KMOREB
  914    FORMAT(/
     +      1X,'Total number of locations available       =',I15/
     +      1X,'Total number of locations required        =',I15/
     +      1X,'Additional number of locations required   =',I15/
     +      1X,'Additional memory (RAM) required (KBytes) =',I15/)
C
         WRITE(IW2,918)
  918    FORMAT(1X,'Press the  RETURN  key to continue.'/)
         READ(1,*,END=25)
   25    CONTINUE
         STOP
      ENDIF
C
C--------CHECK THAT  THE ARRAYS SIZES (FOR G AND K) REQUESTED
C        IN FILE CRISP92.SZE DO NOT EXCEED THE PROGRAM LIMITS
      KERR=0
      KINCG=0
      KINCK=0
C
      IF(LG.GT.LGMX) THEN
         KINCG=LG-LGMX
         KERR=KERR+1
         WRITE(IW6,932)LG,LGMX
         WRITE(IW2,932)LG,LGMX
  932    FORMAT(/1X,'Requested size for array  G =',I15/
     +           1X,'exceeds size set in program =',I15)
      ENDIF
C
      IF(LK.GT.LKMX) THEN
         KINCK=LK-LKMX
         KERR=KERR+1
         WRITE(IW6,934)LK,LKMX
         WRITE(IW2,934)LK,LKMX
  934    FORMAT(/1X,'Requested size for array  K =',I15/
     +           1X,'exceeds size set in program =',I15)
      ENDIF
C
      IF(KERR.GT.0) THEN
         IREST=50000
         IREQ=LG+LK+IREST
         ICAL=LZ+MZ+IREST
         ISETP=LGMX+LKMX+IREST
C        IF(IREQ.GT.ISETP) THEN
            WRITE(IW2,944)LGMX,LKMX
  944       FORMAT(/
     +       1X,'The values set in the program for arrays'/
     +       1X,'  G  =',I15/
     +       1X,'  K  =',I15/
     +       1X,'are exceeded by the sizes requested in CRISP92.SZE',
     +       1X,'File.'/
     +       1X,'You require a version with increased array sizes.'/
     +       1X,'Contact the authors of the program specifying'/
     +       1X,'the required sizes of array G and K and the total'/
     +       1X,'memory available in your computer.'//
     +       1X,'Press the  RETURN to terminate the run.'/)
            READ(1,*,END=55)
   55       CONTINUE
            STOP
C        ENDIF
      ENDIF
C
      IK=ICODE/10
      IG=MOD(ICODE,10)
C
      IF(IK.EQ.1) THEN
      IMERR=0
      IF(MZ.LE.LK) THEN
         WRITE(IW6,902)MZ,LK
  902    FORMAT(/1X,'ARRAY STORE K  - USED',I7,'  OUT OF ALLOCATED',I7)
      ELSE
         INCS=MZ-LK
         WRITE(IW6,901)INCS,LK,PG,PG,MZ
C--------SWITCH TO TEXTMODE
C        CALL BACKCOLOR(0)
C        CALL ERASERECT(SCREEN)
CC       CALL SETDISPLAY(TEXTPG0)
CC       CALL CLEARTEXT
CC       CALL FLUSHREALMODEBUFFER
         WRITE(IW2,901)INCS,LK,PG,PG,MZ
C 901    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY K IN /GVAR/** BY',I8,
C    +    2X,15H(ROUTINE CHKSZQ)
  901    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY  K  BY',I10,'.',
     +    2X,'(Message from routine CHKSZQ)'/
     +    6X,'CURRENT SIZE OF ARRAY  K  IS ',I10,2X,'IS INSUFFICIENT.'/
     + /6X,'This is done by increasing the size of the parameter LK',
     +  A2/6X,'in the file CRISP92.SZE.'/
     +  6X,'Set  LK',A2,' to at least ',I10,2X,'in File CRISP92.SZE'/)
         IMERR=IMERR+1
      ENDIF
      ENDIF
C
      IF(IG.EQ.1) THEN
      IF(LZ.LE.LG) THEN
         WRITE(IW6,917)LZ,LG
  917    FORMAT(/1X,'ARRAY STORE G  - USED',I7,'  OUT OF ALLOCATED',I7)
      ELSE
         INCS=LZ-LG
         WRITE(IW6,911)INCS,LG,PG,PG,LZ
C--------SWITCH TO TEXTMODE
         IF(IMERR.EQ.0) THEN
C           CALL BACKCOLOR(0)
C           CALL ERASERECT(SCREEN)
CC          CALL SETDISPLAY(TEXTPG0)
CC          CALL CLEARTEXT
CC          CALL FLUSHREALMODEBUFFER
         ENDIF
C
         WRITE(IW2,911)INCS,LG,PG,PG,LZ
C 911    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY G IN /GVAR/** BY',I8,
C    +    2X,15H(ROUTINE CHKSZQ)
  911    FORMAT(/1X,'*****INCREASE SIZE OF ARRAY  G  BY',I10,'.',
     +    2X,'(Message from routine CHKSZQ)'/
     +    6X,'CURRENT SIZE OF ARRAY  G  IS ',I10,2X,'IS INSUFFICIENT.'/
     + /6X,'This is done by increasing the size of the parameter LG',
     +  A2/6X,'in the file CRISP92.SZE.'/
     +  6X,'Set  LG',A2,' to at least ',I10,2X,'in File CRISP92.SZE'/)
         IMERR=IMERR+1
      ENDIF
      ENDIF
C
      IF(IMERR.GT.0) THEN
CC       WRITE(IW2,935)
CC935    FORMAT(/1X,'*****',1X,
CC   +    'Make sure that your system has sufficient MEMORY to meet'/
CC   +  6X,'this requirement. If in doubt consult the notes given in'/
CC   +  6X,'the CRISP92.SZE file.'/)
CC   +  1X,' ***** PRESS THE RETURN KEY *****')
CC       CALL GETEVENT(EVENT,0)
CC       CALL GSTOP
         STOP
      ENDIF
C
CC    CALL SET_TRAP_ON_PAGE_TURN@
C
      CALL SET_PAGES_RESERVE@(0)
      CALL SET_TRAP@(MY_ERROR_HANDLER,JUNK,5)
      RETURN
      END
      INTERRUPT SUBROUTINE MY_ERROR_HANDLER
C
C***********************************************************************
C     ROUTINE TO PRINT ERROR MESSAGES
C***********************************************************************
C
      WRITE(2,900)
      WRITE(6,900)
  900 FORMAT(/1X,'Insufficient memory to run this program.'/)
      WRITE(2,910)
      READ(1,*,END=50)
   50 CONTINUE
  910 FORMAT(/1X,' Press the  RETURN key to stop program.'/)
      STOP
      END
      SUBROUTINE CONECT(IW6,MXND,NEL,MUMAX,NNE,NNU,MXNDV,NCORR,NLST,
     1 MREL,MRELVV,NRELVV,NREL,MAT,LTYP,MFRU,MFRN,
     2 LTZ,KLT,NMATZ,NVTX,NUMAX,IRNFR)
C***********************************************************************
C     SUBROUTINE TO READ ELEMENT-NODAL CONNECTIVITY
C     LAST MODIFIED ON 6 MAR 93
C***********************************************************************
CS    CHARACTER*1 JDO
      DIMENSION NCORR(MXND,NEL),NLST(MXNDV),MREL(MUMAX),MRELVV(NEL),
     1 NRELVV(NNE),NREL(NNU),MFRU(NEL),MFRN(MUMAX),LTYP(NEL),MAT(NEL)
      DIMENSION KLT(LTZ)
      DIMENSION LISTO(10),IPSNO(10)
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CS    COMMON /FFL   / JDO(130)
      COMMON /DEVSUP/ IW15,IWS
C
      CALL FFIN(1,1)
      IRNFR=IFIX(AR(1))
      WRITE(IW6,901)IRNFR
      IF(IRNFR.NE.1)GO TO 30
C-----------------------------------------------------------------------
C     READ OPTIMUM FRONTAL ORDER OF ELEMENTS
C-----------------------------------------------------------------------
      WRITE(IW6,902)
      CALL RDINT(MFRU,NEL)
      WRITE(IW6,904)(MFRU(IL),IL=1,NEL)
C
      CALL ZEROI1(MFRN,MUMAX)
C
      IOC=0
      IERRC=0
      IERK=0
C
      DO 20 IP=1,NEL
      LU=MFRU(IP)
      IF(LU.LE.0.OR.LU.GT.MUMAX) THEN
         IOC=IOC+1
         IERRC=IERRC+1
         IF(IOC.GE.10) THEN
            WRITE(IWS,900)(LISTO(IK),IK=1,10)
            WRITE(IW15,900)(LISTO(IK),IK=1,10)
            WRITE(IW6,900)(LISTO(IK),IK=1,10)
C
            WRITE(IWS,910)(IPSNO(IP),IK=1,10)
            WRITE(IW15,910)(IPSNO(IP),IK=1,10)
            WRITE(IW6,910)(IPSNO(IP),IK=1,10)
C
  900       FORMAT(/1X,'*** Error : Inadmissible element numbers',
     +              1X,'in optimum element numbering list'/
     +              1X,'Element no. :',10I6)
  910       FORMAT(/1X,'Position    :',10I6)
            IOC=1
            LISTO(IOC)=LU
            IPSNO(IOC)=IL
         ELSE
            LISTO(IOC)=LU
            IPSNO(IOC)=IL
         ENDIF
      ELSE
         MFRN(LU)=IP
      ENDIF
   20 CONTINUE
C
      IF(ID6.EQ.1)WRITE(IW6,930)MFRN
C
   30 CALL ZEROI2(NCORR,MXND,NEL)
      CALL ZEROI1(LTYP,NEL)
      CALL ZEROI1(MAT,NEL)
      CALL ZEROI1(MREL,MUMAX)
C
      WRITE(IW6,906)
C
      NTM=MXNDV+3
      DO 100 IL=1,NEL
C-----------------------------------------------------------------------
C     READ ELEMENT NUMBER, TYPE, MATERIAL PROPERTY NUMBER AND
C     VERTEX NODE NUMBERS
C-----------------------------------------------------------------------
      CALL FFIN(NTM,2047)
      KEL=IFIX(AR(1))
      ITYP=IFIX(AR(2))
      IMAT=IFIX(AR(3))
C
      DO 40 IN=1,MXNDV
   40 NLST(IN)=IFIX(AR(IN+3))
      WRITE(IW6,909)KEL,ITYP,IMAT,NLST
C
      IF(ITYP.LE.0.OR.ITYP.GT.LTZ) THEN
         IERK=IERK+1
         WRITE(IWS,800)ITYP
         WRITE(IW15,800)ITYP
         WRITE(IW6,800)ITYP
  800    FORMAT(/1X,'**** Error : Inadmissible element type no.',I8)
         GOTO 100
      ENDIF
C
C--------Check element No. is admissible
      IF(KEL.LE.0.OR.KEL.GT.MUMAX) THEN
         IERK=IERK+1
         WRITE(IWS,820)KEL,IL
         WRITE(IW15,820)KEL,IL
         WRITE(IW6,820)KEL,IL
  820    FORMAT(/1X,'**** Error : Inadmissible element no.',I8,'.'/
     +           1X,'             Position in element list',I8)
         GOTO 100
      ENDIF
C
      NV=LINFO(2,ITYP)
C
C--------CHECK NODE NUMBERS FOR ADMISSIBILITY, NOT REPEATED
      CALL CHKNOD(IW6,NLST,NREL,NNU,MXNDV,NV,KEL,NUMAX,IERK)
C
      MNW=IL
      IF(IRNFR.EQ.1)MNW=MFRN(KEL)
C
C-------SKIP IF ZERO, MEANS INADMISSIBLE ELEMENT NO. IN
C       OPT NUM LIST
      IF(MNW.EQ.0) GOTO 100
C
      MRELVV(MNW)=KEL
      LTYP(MNW)=ITYP
      MAT(MNW)=IMAT
      MREL(KEL)=MNW
      DO 95 IK=1,NV
      NUS=NLST(IK)
      NPR=NREL(NUS)
   95 NCORR(IK,MNW)=NPR
C
  100 CONTINUE
      IF(ID5.EQ.0)GOTO 105
      WRITE(IW6,991)NCORR
  991 FORMAT(/1X,5HNCORR/(1X,20I5))
      WRITE(IW6,992)MREL
  992 FORMAT(/1X,4HMREL/(1X,20I5))
      WRITE(IW6,993)MRELVV
  993 FORMAT(/1X,6HMRELVV/(1X,20I5))
  105 CONTINUE
C
      CALL ZEROI1(KLT,LTZ)
C
      DO 150 IL=1,NEL
      LT=LTYP(IL)
  150 KLT(LT)=KLT(LT)+1
CC    WRITE(IW6,950)KLT
CC950 FORMAT(/1X,3HKLT/(12I10))
      RETURN
CC900 FORMAT(I5)
  901 FORMAT(/1X,7HIRNFR =,I5)
  902 FORMAT(/1X,36HOPTIMISED SOLUTION ORDER OF ELEMENTS/)
  904 FORMAT(1X,20I5)
  906 FORMAT(/1X,46HELEMENT TYPE  MAT    1     2     3     4     5,
     1 18H     6     7     8/)
  909 FORMAT(I5,2X,2I5,15I6)
  930 FORMAT(/1X,4HMFRN/(1X,20I5))
      END
      SUBROUTINE CUREDG(IW6,MXND,NEL,NDIM,NNE,LTAB,LDIM,MUMAX,NNU,NPD,
     1 NCORR,XYZ,LTYP,MREL,NREL,ITAB,NP1,NP2,NCRED,NDTY,NMX)
C***********************************************************************
C     ROUTINE TO READ NODAL COORDINATES ALONG CURVED EDGES
C***********************************************************************
CS     CHARACTER*1 JDO
      DIMENSION XYZ(NDIM,NNE),LTYP(NEL),NCORR(MXND,NEL),MREL(MUMAX),
     1 NREL(NNU),ITAB(LTAB,LDIM),NP1(NPD),NP2(NPD),CD(3,3),CDT(3,3)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CS    COMMON /FFL   / JDO(130)
      COMMON /DEVSUP/ IW15,IWS
C
      IERS=0
C
      WRITE(IW6,900)
      NTM=NMX*NDIM+3
      DO 200 JSD=1,NCRED
      CALL FFIN(NTM,7)
      MU=IFIX(AR(1))
      ND1=IFIX(AR(2))
      ND2=IFIX(AR(3))
      INX=3
C
      DO 4 JU=1,NMX
      DO 4 IU=1,NDIM
      INX=INX+1
    4 CD(IU,JU)=AR(INX)
      WRITE(IW6,902)MU,ND1,ND2,((CD(IU,JU),IU=1,NDIM),JU=1,NMX)
C
      MPR=MREL(MU)
      LT=LTYP(MPR)
      NDT=LINFO(5,LT)
      NV=LINFO(2,LT)
      NEDG=LINFO(3,LT)
      NSD=LINFO(7,LT)
      IF(NDTY.EQ.2)NSD=LINFO(8,LT)
      IND=LINFO(14,LT)
C
      K1=NREL(ND1)
      K2=NREL(ND2)
C
      CALL SORT2(K1,K2,I1,I2)
      IHASH=10000*I1+I2
      IT=5*I1
      GOTO 8
C
    6 IT=IT+1
    8 IF(IT.GT.LTAB)IT=1
      IF(ITAB(IT,1).EQ.IHASH)GOTO 10
      IF(ITAB(IT,1).NE.0)GOTO 6
C
C *** EDGE NOT FOUND
      IERS=IERS+1
      WRITE(IWS,904)ND1,ND2
      WRITE(IW15,904)ND1,ND2
      WRITE(IW6,904)ND1,ND2
      GO TO 200
C
C *** NOTE EDGE IS CURVED - FOR PLOTTING PURPOSES
   10 IF(NDTY.EQ.2)GOTO 11
      ITAB(IT,LDIM)=2
C
   11 DO 20 IEDG=1,NEDG
      INDS=IND+IEDG
      IN1=NP1(INDS)
      IN2=NP2(INDS)
      N1=NCORR(IN1,MPR)
      N2=NCORR(IN2,MPR)
C
      IF(K1.EQ.N1.AND.K2.EQ.N2)GOTO 26
      IF(K2.EQ.N1.AND.K1.EQ.N2)GOTO 22
   20 CONTINUE
C
      WRITE(IWS,908)MU,ND1,ND2
      WRITE(IW15,908)MU,ND1,ND2
      WRITE(IW6,908)MU,ND1,ND2
      GOTO 200
C-----------------------------------------------------------------------
C     CHANGE AROUND COORDINATES IF THERE ARE MORE THAN
C     ONE NODE AND THE NODES ARE IN THE REVERSE ORDER
C-----------------------------------------------------------------------
   22 IF(NSD.LE.1)GOTO 26
C
      DO 24 ISD=1,NSD
      JBK=NSD+1-ISD
      DO 24 ID=1,NDIM
   24 CDT(ID,ISD)=CD(ID,JBK)
C
      DO 25 ISD=1,NSD
      DO 25 ID=1,NDIM
   25 CD(ID,ISD)=CDT(ID,ISD)
C
   26 CONTINUE
      NS=NV
      IF(NDTY.EQ.2)NS=NDT
      NL=NS+(IEDG-1)*NSD
C-----------------------------------------------------------------------
C     CHANGE COORDINATES ALONG CURVED EDGE
C-----------------------------------------------------------------------
      DO 40 KSD=1,NSD
      NLN=NL+KSD
      K=NCORR(NLN,MPR)
C
      DO 38 ID=1,NDIM
   38 XYZ(ID,K)=CD(ID,KSD)
   40 CONTINUE
C
  200 CONTINUE
C
      IF(IERS.EQ.0)RETURN
      WRITE(IWS,910)
      WRITE(IW15,910)
      WRITE(IW6,910)
      STOP
  900 FORMAT(/1X,32HLIST OF NODES ALONG CURVED EDGES/)
  902 FORMAT(1X,3I5,6F10.0)
  904 FORMAT(/1X,32H***ERROR** EDGE CONTAINING NODES,2I5,2X,
     1 9HNOT FOUND)
  908 FORMAT(/1X,7HELEMENT,I5,23H DOES NOT CONTAIN NODES,2I5)
  910 FORMAT(/1X,36HPROGRAM TERMINATED IN ROUTINE CUREDG)
      END
      SUBROUTINE ERR(NA,NB,NC,ND,NE)
C***********************************************************************
C     DUMMY ROUTINE
C***********************************************************************
      RETURN
      END
      SUBROUTINE FFIN(NUMEX,ICODE)
C***********************************************************************
C     FREE FORMAT INPUT ROUTINE                                        *
C     READS NUMBERS IN FORTRAN STANDARD (1966) SYNTAX                  *
C     ROUTINE LAST MODIFIED ON 30/4/81                                 *
C     ROUTINE ADDED TO GP 15 MAY 93
C***********************************************************************
      CHARACTER*1 JD,ID,JDO,IM,IS,IQ,IC,IE,IP,IDOT
      LOGICAL LINT(41),LEXP
      DIMENSION JD(130),ID(10)
      COMMON /FF/ A(40),NCARD,NERR,JERR,LUN
      COMMON /FFL/ JDO(130)
      COMMON /DEVSUP/ IW15,IWS
      DATA ID(1),ID(2),ID(3),ID(4),ID(5),ID(6),ID(7),ID(8),ID(9),ID(10)/
     +     '0','1','2','3','4','5','6','7','8','9'/
      DATA IM,IS,IQ,IC,IE,IP,IDOT/'-',' ','?','C','E','+','.'/
C
C     READ IN LINE OF DATA IN A1 FORMAT
C
C-----------LENGTH OF ARRAY JD
      LJD=130
      LJD1=LJD+1
C
   10 READ(LUN,1000) JD
 1000 FORMAT(130A1)
      DO 11 IL=1,40
   11 A(IL)=0.0
C
      DO 12 IK=1,LJD
   12 JDO(IK)=JD(IK)
      NCARD=NCARD+1
C
C     SKIP LINE IF IT IS A COMMENT
C
      IF(JD(1).EQ.IC) GOTO 10
C***********************************************************************
C     KD IS POINTER TO CHARACTER POSITION IN LINE READ                 *
C     FOR THE NUMBER CURRENTLY BEING INTERPRETTED ...                  *
C     THE NUMI'TH NUMBER ON THE RECORD ...                             *
C     NUMW IS THE VALUE OF THE WHOLE (OR INTEGER) PART                 *
C     IF IT'S POSITIVE ISIGN=1                                         *
C     IF IT'S NEGATIVE ISIGN=-1                                        *
C     NUMF/DIV IS THE VALUE OF THE FRACTIONAL PART                     *
C     NUMX IS THE VALUE OF THE EXPONENT (IF THERE IS ONE)              *
C     IF THE EXPONENT IS POSITIVE JSIGN=1                              *
C     IF THE EXPONENT IS NEGATIVE JSIGN=-1                             *
C     LINT(NUMI) IS .TRUE. IF NO DECIMAL POINT OR EXPONENT IS FOUND    *
C     LEXP IS .TRUE. IF AN EXPONENT IS ENCOUNTERED                     *
C***********************************************************************
      JERR=0
      KD=0
      NUMW=0
      NUMF=0
      NUMI=0
      NUMX=0
      LINT(1)=.TRUE.
      LEXP=.FALSE.
      DIV=1.
      ISIGN=1
      JSIGN=1
C
C      LOOK FOR THE FIRST NUMBER ON THE LINE
C
   14 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 18
      IF(JD(KD).EQ.IS) GOTO 14
      GOTO 30
C
C     EMPTY LINE
C
   18 NERR=NERR+1
      JERR=1
      WRITE(6,1001) NCARD
      WRITE(IW15,1001) NCARD
      WRITE(IWS,1001) NCARD
 1001 FORMAT(25H ***ERROR*** DATA RECORD ,I5,11H   IS EMPTY/1X,80(1H-))
      RETURN
C***********************************************************************
C     LOOK FOR NEXT NUMBER                                             *
C***********************************************************************
   22 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 200
      IF(JD(KD).EQ.IS) GOTO 22
C
C      CHECK FOR LEGAL STARTING CHARACTER FOR NUMBER
C      I.E. +,-,. OR DIGIT
C
   30 IF(JD(KD).EQ.IM) GOTO 38
C
      DO 32 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   32 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 46
C
      IF(JD(KD).EQ.IP) GOTO 42
C
      GOTO 400
C
   38 ISIGN=-1
C
   42 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
C
      DO 44 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   44 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 46
C
      GOTO 400
C
C     AFTER '.' NEXT CHARACTER MUST BE A DIGIT
C     IN THIS CONTEXT (START OF A NUMBER)
C
   46 KD=KD+1
      LINT(NUMI+1)=.FALSE.
      IF(KD.EQ.LJD1) GOTO 410
C
      DO 48 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 70
   48 CONTINUE
C
      GOTO 400
C***********************************************************************
C     INTERPRET THE INTEGER PART OF A NUMBER                           *
C***********************************************************************
   50 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 54 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   54 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 62
C
      IF(JD(KD).EQ.IE) GOTO 80
C
      GOTO 400
C
   58 NUMW=10*NUMW+J-1
      GOTO 50
C***********************************************************************
C     READ FRACTIONAL PART OF NUMBER (I.E. THAT PART WHICH FOLLOWS     *
C     THE DECIMAL POINT)                                               *
C***********************************************************************
   62 KD=KD+1
      LINT(NUMI+1)=.FALSE.
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 66 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 70
   66 CONTINUE
C
      IF(JD(KD).EQ.IE) GOTO 80
      GOTO 400
C
   70 NUMF=10*NUMF+J-1
      DIV=10.*DIV
      GOTO 62
C***********************************************************************
C     DEAL WITH EXPONENT                                               *
C***********************************************************************
   80 LEXP=.TRUE.
      LINT(NUMI+1)=.FALSE.
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
      IF(JD(KD).EQ.IM) GOTO 82
      IF(JD(KD).EQ.IP) GOTO 84
      GOTO 86
C
   82 JSIGN=-1
C
   84 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
C
   86 DO 88 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 90
   88 CONTINUE
      GOTO 400
C
   90 NUMX=J-1
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 92 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 94
   92 CONTINUE
      GOTO 400
C
   94 NUMX=10*NUMX+J-1
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
      GOTO 400
C
C***********************************************************************
C     END OF NUMBER                                                    *
C***********************************************************************
  100 NUMI=NUMI+1
      A(NUMI)=FLOAT(NUMW)+FLOAT(NUMF)/DIV
      IF(ISIGN.EQ.(-1)) A(NUMI)=-A(NUMI)
      IF(.NOT.LEXP) GOTO 104
      IF(JSIGN.EQ.(-1)) NUMX=-NUMX
      FAC=10.0**NUMX
      A(NUMI)=A(NUMI)*FAC
C
  104 IF(KD.EQ.LJD1) GOTO 200
C
C     RE-INITIALISE
C
      NUMW=0
      NUMF=0
      NUMX=0
      LEXP=.FALSE.
      LINT(NUMI+1)=.TRUE.
      DIV=1.
      ISIGN=1
      JSIGN=1
      GOTO 22
C***********************************************************************
C     END OF LINE                                                      *
C***********************************************************************
  200 KERR=0
      L=0
      JCODE=ICODE
      IF(NUMEX.EQ.NUMI) GOTO 204
      WRITE(6,1002) NCARD
      WRITE(6,1004) JD
      WRITE(6,1006)NUMEX,NUMI
      WRITE(IW15,1002) NCARD
      WRITE(IW15,1004) JD
      WRITE(IW15,1006)NUMEX,NUMI
      WRITE(IWS,1002) NCARD
      WRITE(IWS,1004) JD
      WRITE(IWS,1006)NUMEX,NUMI
 1006 FORMAT(1X,I5,21H NUMBERS EXPECTED BUT,I3,12H ENCOUNTERED/
     + 1X,80(1H-))
      KERR=1
      JERR=1
      NERR=NERR+1
C
  204 IF(JCODE.EQ.0) GOTO 220
      L=L+1
      IF(L.GT.NUMI) GOTO 220
      IF(L.GT.NUMEX) GOTO 420
      J=JCODE/2
      INT=JCODE-2*J
      JCODE=J
      IF(INT.EQ.0) GOTO 204
C
C     NUMBER MUST BE AN INTEGER
C
      IF(LINT(L)) GOTO 204
      IF(KERR.EQ.1) GOTO 208
      KERR=1
      JERR=1
      NERR=NERR+1
      WRITE(6,1002)NCARD
      WRITE(6,1004)JD
      WRITE(IW15,1002) NCARD
      WRITE(IW15,1004) JD
      WRITE(IWS,1002) NCARD
      WRITE(IWS,1004) JD
C
  208 WRITE(6,1007)L
 1007 FORMAT(19H NUMBER IN POSITION,I3,18H IS NOT AN INTEGER/1X,80(1H-))
      WRITE(IW15,1007)L
      WRITE(IWS,1007)L
      GOTO 204
C
  220 CONTINUE
C     WRITE(6,2000) NCARD
C2000 FORMAT(12H DATA RECORD,I5)
C     WRITE(6,2001)(A(I),I=1,NUMI)
C     WRITE(6,2002)(A(I),I=1,NUMI)
C2001 FORMAT(1X,10F12.3)
C2002 FORMAT(1X,10E12.4)
      RETURN
C***********************************************************************
C     ERRORS                                                           *
C***********************************************************************
  400 NERR=NERR+1
      JERR=1
      WRITE(6,1002)NCARD
 1002 FORMAT(27H ***ERROR*** IN DATA RECORD,I5)
      WRITE(6,1004)JD
 1004 FORMAT(1X,130A1)
      WRITE(IW15,1002)NCARD
      WRITE(IW15,1004)JD
      WRITE(IWS,1002)NCARD
      WRITE(IWS,1004)JD
C
      DO 402 J=1,LJD
  402 JD(J)=IS
      JD(KD)=IQ
      WRITE(6,1004)JD
      WRITE(6,1003)
 1003 FORMAT(28H ILLEGAL SYNTAX FOR A NUMBER)
      WRITE(IW15,1004)JD
      WRITE(IW15,1003)
      WRITE(IWS,1004)JD
      WRITE(IWS,1003)
      IF(NERR.GT.9)GO TO 500
      RETURN
C
  410 NERR=NERR+1
      JERR=1
      WRITE(6,1002)NCARD
      WRITE(6,1004)JD
      WRITE(IW15,1002)NCARD
      WRITE(IW15,1004)JD
      WRITE(IWS,1002)NCARD
      WRITE(IWS,1004)JD
C
      KD=LJD
      DO 412 J=1,LJD
  412 JD(J)=IS
      JD(KD)=IQ
      WRITE(6,1004)JD
      WRITE(6,1005)
 1005 FORMAT(35H INCOMPLETE NUMBER NEAR END OF LINE)
      WRITE(IW15,1004)JD
      WRITE(IW15,1005)
      WRITE(IWS,1004)JD
      WRITE(IWS,1005)
      IF(NERR.GT.9)GO TO 500
      RETURN
C
  420 WRITE(6,1008) NCARD
 1008 FORMAT(61H ***PROGRAM ERROR*** IN ROUTINE FFIN WHEN READING DATA R
     +ECORD,I5)
      WRITE(6,1004)JD
      WRITE(6,1009) NUMEX,ICODE
 1009 FORMAT(9H NUMEX = ,I5,11H   ICODE = ,I5/1X,80(1H-))
      WRITE(IW15,1008) NCARD
      WRITE(IW15,1004)JD
      WRITE(IW15,1009) NUMEX,ICODE
      WRITE(IWS,1008) NCARD
      WRITE(IWS,1004)JD
      WRITE(IWS,1009) NUMEX,ICODE
  500 CONTINUE
C *** ECHO REST OF THE DATA AND TERMINATE WITH ERROR
  501 READ(LUN,1000)JD
      WRITE(6,1011)JD
 1011 FORMAT(1X,130A1)
      GO TO 501
C
      END
      SUBROUTINE GPOUT(IW6,MXND,NEL,MUMAX,NN,MXDF,NDF,NCORR,
     1 LTYP,MAT,MREL,MRELVV,NRELVV,NQ,KGVN,NLST)
C***********************************************************************
C     ROUTINE TO PRINTOUT ARRAYS SET-UP IN GEOMETRY PART OF PROGRAM
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),LTYP(NEL),MAT(NEL),MREL(MUMAX),
     1 MRELVV(NEL),NRELVV(NN),NQ(NN),KGVN(MXDF,NN),NLST(MXND)
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
C
      WRITE(IW6,902)
C
      DO 20 JU=1,MUMAX
      IF(MREL(JU).EQ.0)GOTO 20
      MPR=MREL(JU)
      LT=LTYP(MPR)
      NDPT=LINFO(1,LT)
C
      DO 10 IN=1,NDPT
      NP=NCORR(IN,MPR)
   10 NLST(IN)=NRELVV(NP)
C
      WRITE(IW6,906)JU,LT,MAT(MPR),(NLST(IN),IN=1,NDPT)
   20 CONTINUE
C
      IF(ID10.EQ.1)WRITE(IW6,908)(NQ(IN),IN=1,NN)
C
      IF(ID10.EQ.1)WRITE(IW6,910)((KGVN(JJ,IN),JJ=1,MXDF),IN=1,NN)
C
      WRITE(IW6,911)NN
      WRITE(IW6,912)NDF
C
      RETURN
  902 FORMAT(//10X,30H  ELEMENT  MATERIAL  TYPE  AND,
     1 15H  NODE  NUMBERS//1X,7HELEMENT,1X,4HTYPE,2X,3HMAT,
     2 19H   1    2    3    4,
     3 55H    5    6    7    8    9   10   11   12   13   14   15,
     4 35H   16   17   18   19   20   21   22/)
  906 FORMAT(I5,2I6,22I5)
  908 FORMAT(/1X,2HNQ/(1X,20I5))
  910 FORMAT(/1X,4HKGVN/(1X,20I5))
  911 FORMAT(//24H TOTAL NUMBER OF NODES =,I8)
  912 FORMAT(/40H TOTAL DEGREES OF FREEDOM IN SOLUTION = ,I8)
      END
      SUBROUTINE GPSUB(NVTX,NEL,NUMAX,MUMAX,MXND,MXNDV,NNE,MXDF,
     1 NN,NNU,NNZ,LTAB,LDIM,NDIM,NDF,NDZ,IFRZ,MCORE,MNFZ,
     2 NPL,LTZ,KLT,NMATZ,INXL,IPLOT,
     3 XYZ,NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     4 ITAB,MFRU,MFRN,NDEST,NLST,IFR,NP1,NP2,KDF,ND,NCORET,MDZ)
C***********************************************************************
C     MASTER CONTROL ROUTINE FOR GEOMETRY PART OF THE PROGRAM
C     READS INPUT DATA (COORDINATES AND ELEMENT-NODAL
C     CONNECTIVITY ) AND SETS UP ADDITIONAL ARRAYS
C***********************************************************************
CS     CHARACTER*1 JDO,TITLE
       CHARACTER*1 TITLE
      DIMENSION XYZ(NDIM,NNE),NCORR(MXND,NEL),MAT(NEL),
     1 LTYP(NEL),MRELVV(NEL),MREL(MUMAX),NRELVV(NNE),
     2 NREL(NNU),KGVN(MXDF,NNE),NQ(NNE),ITAB(LTAB,LDIM),MFRU(NEL),
     3 MFRN(MUMAX),NDEST(NNE),NLST(MXND),IFR(IFRZ),NP1(NPL),
     4 NP2(NPL),KDF(MXDF,NNE),KLT(LTZ)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEBUGS/ IDB(10)
      COMMON /LABEL / TITLE(80)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CX    COMMON /FFL   / JDO(130)
C-----------------------------------------------------------------------
C     NSDZ - MAXIMUM NUMBER OF DISPLACEMENT NODES ALONG EDGE
C     NSPZ - MAXUMUM NUMBER OF PORE-PRESSURE NODES ALONG EDGE
C            (EXCLUDING END NODES)
C-----------------------------------------------------------------------
      CALL FFIN(10,1023)
      DO 5 IN=1,10
    5 IDB(IN)=IFIX(AR(IN))
C
      CALL FFIN(4,15)
      NSDZ=IFIX(AR(1))
      NSPZ=IFIX(AR(2))
      NDCUR=IFIX(AR(3))
      NPCUR=IFIX(AR(4))
      WRITE(IW6,902)NSDZ,NSPZ,NDCUR,NPCUR
C-----------------------------------------------------------------------
C     READ VERTEX NODE COORDINATES
C-----------------------------------------------------------------------
      CALL RDCOD(IW6,NNE,NDIM,NNU,NVTX,NUMAX,XYZ,NRELVV,NREL)
C-----------------------------------------------------------------------
C     READ ELEMENT-NODAL CONNECTIVITY
C-----------------------------------------------------------------------
      CALL CONECT(IW6,MXND,NEL,MUMAX,NNE,NNU,MXNDV,NCORR,NLST,MREL,
     + MRELVV,NRELVV,NREL,MAT,LTYP,MFRU,MFRN,LTZ,KLT,NMATZ,NVTX,NUMAX,
     + IRNFR)
C
C-------CHECK OPTIMUM ELEMENT NUMBERING
      IF(IRNFR.EQ.1) CALL CHKOPT(IW6,MREL,MRELVV,MFRU,NEL,MUMAX)
C
      IF(IDB(1).EQ.1)WRITE(IW6,801)NCORR
C-----------------------------------------------------------------------
C     CALCULATE COORDINATES OF ADDITIONAL NODES
C-----------------------------------------------------------------------
      CALL MIDSID(IW6,MXND,NEL,LTAB,LDIM,NNU,NDIM,NNE,NPL,NCORR,
     1 ITAB,NRELVV,NREL,XYZ,LTYP,NP1,NP2,ND,NN,KRD,NVTX,NDZ,MDZ,
     + MREL,MUMAX)
C-----------------------------------------------------------------------
C     READ COORDINATES OF DISPLACEMENT NODES ALONG
C     CURVED EDGES(SIDES)
C     NDCUR - NUMBER OF ELEMENT EDGES THAT ARE CURVED
C-----------------------------------------------------------------------
      IF(NDCUR.EQ.0)GOTO 10
      CALL CUREDG(IW6,MXND,NEL,NDIM,NNE,LTAB,LDIM,MUMAX,NNU,NPL,NCORR,
     1 XYZ,LTYP,MREL,NREL,ITAB,NP1,NP2,NDCUR,1,NSDZ)
   10 CONTINUE
C-----------------------------------------------------------------------
C     WRITE TITLE AND DIMENSIONS OF MESH TO A PLOT FILE
C-----------------------------------------------------------------------
      IF(IPLOT.NE.0)WRITE(IWP,800)TITLE
  800 FORMAT(1X,80A1)
      IF(IPLOT.NE.0)CALL INTPLT(IW6,IWP,NDIM,NNE,XYZ,ND)
C-----------------------------------------------------------------------
C     PLOT ELEMENT SIDES
C-----------------------------------------------------------------------
      IF(IPLOT.NE.0)CALL SIDES(IW6,IWP,LTAB,LDIM,NDIM,NNE,MXND,NEL,ITAB,
     1 XYZ,NCORR)
C-----------------------------------------------------------------------
C     CALCULATE COORDINATES OF ADDITIONAL PORE-PRESSURE NODES
C-----------------------------------------------------------------------
      CALL MIDPOR(IW6,MXND,NEL,LTAB,LDIM,NNU,NDIM,NNE,NPL,
     1 NCORR,ITAB,NRELVV,NREL,LTYP,XYZ,NP1,NP2,NN,KRD,NNZ,
     + MREL,MUMAX)
C-----------------------------------------------------------------------
C     READ COORDINATES OF PORE-PRESSURE NODES ALONG
C     CURVED EDGES(SIDES)
C-----------------------------------------------------------------------
      IF(NPCUR.EQ.0)GO TO 20
      CALL CUREDG(IW6,MXND,NEL,NDIM,NNE,LTAB,LDIM,MUMAX,NNU,NPL,
     1 NCORR,XYZ,LTYP,MREL,NREL,ITAB,NP1,NP2,NPCUR,2,NSPZ)
   20 CONTINUE
      NN1=NN+1
CC    WRITE(IW6,810)NN1,NNZ
CC810 FORMAT(/1X,6HNN1 = ,I6,3X,6HNNZ = ,I6)
      IF(IDB(7).EQ.0)GOTO 22
      WRITE(IW6,801)NCORR
  801 FORMAT(/1X,5HNCORR/(1X,20I5))
      WRITE(IW6,802)MREL
  802 FORMAT(/1X,4HMREL/(1X,20I5))
      WRITE(IW6,803)MRELVV
  803 FORMAT(/1X,6HMRELVV/(1X,20I5))
      WRITE(IW6,804)NREL
  804 FORMAT(/1X,4HNREL/(1X,20I5))
      WRITE(IW6,805)NRELVV
  805 FORMAT(/1X,6HNRELVV/(1X,20I5))
      WRITE(IW6,806)LTYP
  806 FORMAT(/1X,4HLTYP/(1X,20I5))
      WRITE(IW6,807)MAT
  807 FORMAT(/1X,3HMAT/(1X,20I5))
   22 CONTINUE
C-----------------------------------------------------------------------
C     NUMBER THE MESH
C-----------------------------------------------------------------------
       IF(IPLOT.NE.1)CALL NUMSH(IW6,IWP,NDIM,NNE,MXND,NEL,MUMAX,NNU,
     1 XYZ,NCORR,LTYP,MREL,NREL,NDZ,IPLOT)
C-----------------------------------------------------------------------
C     CALCULATE NUMBER OF DEGREES OF FREEDOM FOR EACH NODE
C-----------------------------------------------------------------------
      CALL MAKENZ(MXND,NEL,NN,MXDF,NCORR,LTYP,NQ,INXL,KDF)
      IF(IDB(7).EQ.1)WRITE(IW6,809)NQ
  809 FORMAT(/1X,2HNQ/(1X,20I5/))
C-----------------------------------------------------------------------
C     GENERATE GLOBAL NUMBERS FOR ALL D.O.F.
C-----------------------------------------------------------------------
      CALL CALDOF(IW6,NN,MXDF,NDF,NQ,KGVN,KDF)
C-----------------------------------------------------------------------
C     MARK LAST APPEARANCE OF ALL NODES
C-----------------------------------------------------------------------
      CALL MLAPZ(MXND,NEL,NN,NCORR,LTYP,NQ)
C-----------------------------------------------------------------------
C     CALCULATE MAXIMUM FRONTWIDTH AND MINIMUM STORE FOR SOLUTION
C-----------------------------------------------------------------------
      CALL SFWZ(MNFZ,MXND,NEL,NN,MUMAX,NNU,IFRZ,NCORR,
     1 LTYP,NQ,NDEST,MREL,NREL,IFR,-1,MCORE,NCORET)
C-----------------------------------------------------------------------
C     PRINT OUT ARRAYS
C-----------------------------------------------------------------------
      CALL GPOUT(IW6,MXND,NEL,MUMAX,NN,MXDF,NDF,
     1 NCORR,LTYP,MAT,MREL,MRELVV,NRELVV,NQ,KGVN,NLST)
C
      RETURN
  902 FORMAT(/
     1 10X,46HMAX NUMBER OF DISPLACEMENT NODES ALONG SIDE..=,I8/
     2 10X,46HMAX NUMBER OF PORE-PRESSURE NODES ALONG SIDE.=,I8/
     3 10X,46HNUMBER OF CURVED SIDES (DISPLACEMENT)........=,I8/
     4 10X,46HNUMBER OF CURVED SIDES (PORE-PRESSURE).......=,I8/
     5 /120(1H*)/)
CC905 FORMAT(80A1)
      END
      SUBROUTINE INTPLT(IW6,IWP,NDIM,NNE,XYZ,ND)
C***********************************************************************
C     ROUTINE TO CALCULATE DIMENSIONS OF THE PLOT
C***********************************************************************
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      DIMENSION XYZ(NDIM,NNE),CODMIN(3),CODMAX(3)
C
      DO 10 ID=1,NDIM
      CODMIN(ID)= ALAR
   10 CODMAX(ID)=-ALAR
C
      DO 30 J=1,ND
      DO 20 ID=1,NDIM
      IF(XYZ(ID,J).GT.CODMAX(ID))CODMAX(ID)=XYZ(ID,J)
      IF(XYZ(ID,J).LT.CODMIN(ID))CODMIN(ID)=XYZ(ID,J)
   20 CONTINUE
   30 CONTINUE
C
      WRITE(IWP,900)NDIM
      WRITE(IWP,920)(CODMAX(ID),ID=1,NDIM),(CODMIN(ID),ID=1,NDIM)
  900 FORMAT(1X,I5)
  920 FORMAT(1X,6E15.5)
      RETURN
      END
      SUBROUTINE MAKENZ(NTPE,NEL,NN,MXDF,NCORR,LTYP,NQ,INXL,KDF)
C***********************************************************************
C     SETS UP THE NQ ARRAY WHICH CONTAINS THE NUMBER
C     OF DEGREES OF FREEDOM ASSOCIATED WITH EACH NODE
C     FOR ELEMENTS IN THIS ASSEMBLY.
C     ARRAY KDF THEN GIVES THE NODAL VARIABLE NUMBER FOR THE UNIVERSAL
C     VARIABLE NUMBER.
C***********************************************************************
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),NQ(NN),KDF(MXDF,NN)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
C
C *** INXL - INDEX TO NO. OF DEGREES OF FREEDOM OF FIRST NODE OF ELEMENT
C *** (SEE BLOCK DATA ROUTINES BDATA1, MAIN2)
C
      DO 10 J=1,NN
      NQ(J)=0
      DO 10 I=1,MXDF
   10 KDF(I,J)=0
C
      DO 30 J=1,NEL
      IF(LTYP(J).LT.0) GOTO 30
      LT=LTYP(J)
      NDPT=LINFO(1,LT)
C
      DO 20 I=1,NDPT
      NDFN=LINFO(I+INXL,LT)
      IF(NDFN.EQ.0)GOTO 20
      NOD=NCORR(I,J)
C
      DO 15 IV=1,NDFN
      INX=MINFO(IV,I,LT)
      IF(KDF(INX,NOD).NE.0)GOTO 15
      NQ(NOD)=NQ(NOD)+1
      KDF(INX,NOD)=1
   15 CONTINUE
C
   20 CONTINUE
   30 CONTINUE
C
CC    WRITE(6,910)KDF
CC910 FORMAT(/1X,'KDF-1'/1X,(6I6/))
C
      DO 50 I=1,NN
      IVN=0
      DO 40 J=1,MXDF
      IF(KDF(J,I).EQ.0)GOTO 40
      IVN=IVN+1
      KDF(J,I)=IVN
   40 CONTINUE
      IF(IVN.EQ.NQ(I))GOTO 50
      WRITE(6,900)I,IVN,NQ(I),(KDF(JJ,I),JJ=1,MXDF)
  900 FORMAT(/1X,'****ERROR : PROGRAM NODE',I5,2X,'HAS INCONSISTENT',
     +       1X,'SET OF D.O.F',2I5/1X,'D.O.F LIST :',6I5/)
   50 CONTINUE
CC    WRITE(6,920)KDF
CC920 FORMAT(/1X,'KDF-2'/1X,(6I6/))
      RETURN
      END
      SUBROUTINE MCRLNK(IW4,IW6,LINK1,NN,NVTX,ND,MXDF,NNZ,NDZ,NEL,
     1 MUMAX,NDF,NDIM,NTPE,NPL,LTZ,INXL,IFRZ,MAXNFZ,
     2 MCORE,NCORET,MDZ,MXNDV,KLT,XYZ,NCORR,MAT,NREL,MREL,NRELVV,
     3 MRELVV,LTYP,KGVN)
C*************************************************************************
C     WRITE ARRAYS REQUIRED IN MAIN PROGRAM TO LINK FILE
C   (USED WITH SINGLE PRECISION VERSION OF CRISP MAIN PROGRAM)
C*************************************************************************
      DIMENSION KLT(LTZ),XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),
     1 NREL(NNZ),MREL(MUMAX),NRELVV(NN),MRELVV(NEL),LTYP(NEL),
     2 KGVN(MXDF,NN)
C
CC    WRITE(IW6,950)KLT
CC950 FORMAT(/1X,3HKLT/(12I10))
      REWIND IW4
      WRITE(IW4)LINK1
      WRITE(IW4)NN,NVTX,ND,MXDF,NNZ,NDZ,MDZ,MXNDV
      WRITE(IW4)NEL,MUMAX
      WRITE(IW4)NDF,NDIM,NTPE,NPL,LTZ,INXL
      WRITE(IW4)IFRZ,MAXNFZ,MCORE,NCORET
      WRITE(IW4)(KLT(IK),IK=1,LTZ)
      WRITE(IW4)((XYZ(ID,IN),ID=1,NDIM),IN=1,NN)
      WRITE(IW4)((NCORR(I,J),I=1,NTPE),J=1,NEL)
      WRITE(IW4)(MAT(I),I=1,NEL)
      WRITE(IW4)(NREL(I),I=1,NNZ)
      WRITE(IW4)(MREL(I),I=1,MUMAX)
      WRITE(IW4)(NRELVV(I),I=1,NN)
      WRITE(IW4)(MRELVV(I),I=1,NEL)
      WRITE(IW4)(LTYP(I),I=1,NEL)
      WRITE(IW4)((KGVN(I,J),I=1,MXDF),J=1,NN)
      END FILE IW4
C
      RETURN
      END
      SUBROUTINE MIDPOR(IW6,MXND,NEL,LTAB,LDIM,NNU,NDIM,NNE,NPD,
     1 NCORR,ITAB,NRELVV,NREL,LTYP,XYZ,NP1,NP2,NN,KRD,NNZ,MREL,MUMAX)
C***********************************************************************
C     ROUTINE TO CALCULATE ADDITIONAL PORE-PRESSURE NODES FOR
C     CONSOLIDATION ELEMENTS ( NODES WITH ONLY
C     EXCESS PORE PRESSURES AS VARIABLES)
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),ITAB(LTAB,LDIM),NRELVV(NNE),NREL(NNU),
     1 LTYP(NEL),XYZ(NDIM,NNE),NP1(NPD),NP2(NPD),SUM(3),MREL(MUMAX)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW15,IWS
C
      KR=KRD
      K=NN
      LDIM1=LDIM-1
C
      LT=LTYP(1)
      IF(LINFO(8,LT).NE.0)WRITE(IW6,900)
      DO 10 J=1,LDIM
      DO 10 I=1,LTAB
   10 ITAB(I,J)=0
C
CC    DO 100 NE=1,NEL
      DO 100 NU=1,MUMAX
      NE=MREL(NU)
      IF(NE.EQ.0) GOTO 100
C
      LT=LTYP(NE)
      GOTO(100,100,100,100,100,100,12,100,100,100,100,100,100,100,
     +     100),LT
   12 NDT=LINFO(5,LT)
      NV=LINFO(2,LT)
      NEDG=LINFO(3,LT)
      NDPT=LINFO(1,LT)
      INDED=LINFO(14,LT)
      NSDP=LINFO(8,LT)
C
      DO 26 IS=1,NEDG
      NLP=NDT+(IS-1)*NSDP
      INDS=INDED+IS
      IN1=NP1(INDS)
      IN2=NP2(INDS)
      N1=NCORR(IN1,NE)
      N2=NCORR(IN2,NE)
      CALL SORT2(N1,N2,I1,I2)
      IHASH=10000*I1+I2
      IT=5*I1
      GOTO 18
C
   16 IT=IT+1
   18 IF(IT.GT.LTAB) IT=1
      IF(ITAB(IT,1).EQ.IHASH) GOTO 24
      IF(ITAB(IT,1).NE.0) GOTO 16
C
      DO 22 ISDP=1,NSDP
C *** CALCULATE CO-ORDINATES OF NODES ALONG THE EDGE
      K=K+1
      KR=KR+1
      IF(KR.LE.NNU)GOTO 19
      WRITE(IWS,901)
      WRITE(IW15,901)
      WRITE(IW6,901)
      STOP
C
   19 NREL(KR)=K
      NRELVV(K)=KR
      IF(K.LE.NNE) GOTO 20
      WRITE(IWS,902)NNE
      WRITE(IW15,902)NNE
      WRITE(IW6,902)NNE
      STOP
C
   20 NLNP=NLP+ISDP
      NCORR(NLNP,NE)=K
      IPOS=ISDP+1
      ITAB(IT,IPOS)=K
      F1=FLOAT(NSDP+1-ISDP)/FLOAT(NSDP+1)
      F2=1.-F1
C
      DO 21 ID=1,NDIM
   21 XYZ(ID,K)=XYZ(ID,N1)*F1+XYZ(ID,N2)*F2
      WRITE(IW6,904)KR,(XYZ(ID,K),ID=1,NDIM)
   22 CONTINUE
C
      ITAB(IT,1)=IHASH
      ITAB(IT,LDIM1)=1
      GOTO 26
C
   24 DO 25 ISDP=1,NSDP
      JSDP=NSDP+1-ISDP
      NLPJ=NLP+JSDP
   25 NCORR(NLPJ,NE)=ITAB(IT,ISDP+1)
C
      ITAB(IT,LDIM1)=ITAB(IT,LDIM1)+1
C
   26 CONTINUE
C
      GO TO(90,90,90,90,90,90,27,90,90,90,90,90,90,90,90),LT
C *** CALCULATE CO-ORDINATES OF INNER NODES
   27 NNP=LINFO(10,LT)
      JP=NDPT-NNP
C
      DO 80 INP=1,NNP
      K=K+1
      KR=KR+1
      IF(KR.GT.NNU)WRITE(IWS,901)
      IF(KR.GT.NNU)WRITE(IW15,901)
      IF(KR.GT.NNU)WRITE(IW6,901)
C
      IF(K.GT.NNE)WRITE(IWS,902)NNE
      IF(K.GT.NNE)WRITE(IW15,902)NNE
      IF(K.GT.NNE)WRITE(IW6,902)NNE
      NREL(KR)=K
      NRELVV(K)=KR
      JP=JP+1
      NCORR(JP,NE)=K
C
      DO 40 ID=1,NDIM
   40 SUM(ID)=ZERO
C
      DO 50 IN=1,NV
      NDE=NCORR(IN,NE)
      DO 50 ID=1,NDIM
   50 SUM(ID)=SUM(ID)+XYZ(ID,NDE)
C
      DO 60 ID=1,NDIM
   60 XYZ(ID,K)=SUM(ID)/FLOAT(NV)
      WRITE(IW6,904)KR,(XYZ(ID,K),ID=1,NDIM)
C
   80 CONTINUE
C
   90 CONTINUE
C
  100 CONTINUE
C
      NN=K
      NNZ=KR
      RETURN
  900 FORMAT(/10X,46HCOORDINATES OF PORE PRESSURE NODES ALONG EDGES//
     1 39H NODE          X           Y          Z/)
  901 FORMAT(/1X,49HINCREASE NO. OF ADDITIONAL NODES (ROUTINE MIDPOR))
  902 FORMAT(/1X,21H***ERROR*** MORE THAN,I5,
     1 30HNODES IN MESH (ROUTINE MIDPOR))
  904 FORMAT(I5,3F12.3)
      END
      SUBROUTINE MIDSID(IW6,MXND,NEL,LTAB,LDIM,NNU,NDIM,NNE,NPL,
     1 NCORR,ITAB,NRELVV,NREL,XYZ,LTYP,NP1,NP2,ND,NN,KRD,NVTX,NDZ,MDZ,
     + MREL,MUMAX)
C***********************************************************************
C     GENERATES  MID-SIDE  NODES ALONG EDGE
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),ITAB(LTAB,LDIM),NRELVV(NNE),NREL(NNU),
     1 XYZ(NDIM,NNE),LTYP(NEL),NP1(NPL),NP2(NPL),INDX(3),MREL(MUMAX)
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DEVSUP/ IW15,IWS
      DATA INDX(1),INDX(2),INDX(3)/8,11,5/
C
      MDZ=0
      KR=NDZ
      K=NVTX
      LDIM1=LDIM-1
C
      CALL SETNP(NP1,NP2,NPL)
C
      WRITE(IW6,900)
      DO 10 J=1,LDIM
      DO 10 I=1,LTAB
   10 ITAB(I,J)=0
C
CC    DO 100 NE=1,NEL
      DO 100 NU=1,MUMAX
      NE=MREL(NU)
      IF(NE.EQ.0) GOTO 100
C
      LT=LTYP(NE)
      NV=LINFO(2,LT)
      NEDG=LINFO(3,LT)
      NSD=LINFO(7,LT)
      INDED=LINFO(14,LT)
C--------ADDED 6 MAR 93
      IF(NSD.EQ.0) GOTO 100
C
      DO 26 IS=1,NEDG
CC    WRITE(IW6,950)NE,IS
CC950 FORMAT(1X,9HELEMENT =,I5,2X,6HSIDE =,I5)
      NL=(IS-1)*NSD+NV
      INDS=INDED+IS
      IN1=NP1(INDS)
      IN2=NP2(INDS)
      N1=NCORR(IN1,NE)
      N2=NCORR(IN2,NE)
      CALL SORT2(N1,N2,I1,I2)
      IHASH=10000*I1+I2
      IT=5*I1
      GOTO 18
C
   16 IT=IT+1
   18 IF(IT.GT.LTAB) IT=1
      IF(ITAB(IT,1).EQ.IHASH) GOTO 24
      IF(ITAB(IT,1).NE.0) GOTO 16
C
      MDZ=MDZ+1
      DO 22 ISD=1,NSD
C *** CALCULATE CO-ORDINATES OF NODES ALONG THE EDGE
      K=K+1
      KR=KR+1
      IF(KR.LE.NNU)GOTO 19
      WRITE(IWS,901)
      WRITE(IW15,901)
      WRITE(IW6,901)
      STOP
C
   19 NREL(KR)=K
      NRELVV(K)=KR
      IF(K.LE.NNE) GOTO 20
      WRITE(IWS,902)NNE
      WRITE(IW15,902)NNE
      WRITE(IW6,902)NNE
      STOP
C
   20 NLN=NL+ISD
      NCORR(NLN,NE)=K
      IPOS=ISD+1
      ITAB(IT,IPOS)=K
      F1=FLOAT(NSD+1-ISD)/FLOAT(NSD+1)
      F2=1.-F1
C
      DO 21 ID=1,NDIM
   21 XYZ(ID,K)=XYZ(ID,N1)*F1+XYZ(ID,N2)*F2
      WRITE(IW6,904)KR,(XYZ(ID,K),ID=1,NDIM)
   22 CONTINUE
      ITAB(IT,1)=IHASH
C
C *** FIRST ELEMENT ALONG EDGE HAS BEEN FOUND
      ITAB(IT,LDIM1)=1
C *** COORDINATES OF NODES ALONG EDGE CALCULATED
C *** ASSUMING EDGE IS STRAIGHT
      ITAB(IT,LDIM)=1
      GOTO 26
C
   24 CONTINUE
C
      DO 25 ISD=1,NSD
      JSD=NSD+1-ISD
      NLJ=NL+JSD
   25 NCORR(NLJ,NE)=ITAB(IT,ISD+1)
C
C *** COUNT THE NUMBER OF ELEMENTS SHARING THIS EDGE
      ITAB(IT,LDIM1)=ITAB(IT,LDIM1)+1
C
   26 CONTINUE
C
      GO TO(90,90,90,90,90,27,27,90,90,90,90,90,90),LT
C *** CALCULATE CO-ORDINATES OF INNER NODES
   27 NIN=LINFO(9,LT)
      JLC=LINFO(5,LT)-NIN
C
      DO 30 INN=1,NIN
      K=K+1
      KR=KR+1
      IF(K.GT.NNE)WRITE(IWS,902)NNE
      IF(K.GT.NNE)WRITE(IW15,902)NNE
      IF(K.GT.NNE)WRITE(IW6,902)NNE
C
      IF(KR.GT.NNU)WRITE(IWS,901)
      IF(KR.GT.NNU)WRITE(IW15,901)
      IF(KR.GT.NNU)WRITE(IW6,901)
      NREL(KR)=K
      NRELVV(K)=KR
      JLC=JLC+1
      NCORR(JLC,NE)=K
      INX1=INN
      INX2=INDX(INN)
      NC=NCORR(INX1,NE)
      NM=NCORR(INX2,NE)
C
      DO 28 ID=1,NDIM
   28 XYZ(ID,K)=0.5*(XYZ(ID,NC)+XYZ(ID,NM))
      WRITE(IW6,904)KR,(XYZ(ID,K),ID=1,NDIM)
C
   30 CONTINUE
   90 CONTINUE
  100 CONTINUE
      IF(ID2.EQ.1)WRITE(IW6,910)ITAB
C
C *** TOTAL NUMBER OF DISPLACEMENT NODES - ND
C *** MAXIMUM USER NO. OF DISPLACEMENT NODE - KRD
      NN=K
      ND=K
      KRD=KR
      RETURN
  900 FORMAT(/10X,27HCOORDINATES OF DISPLACEMENT,
     1 1X,25HNODES ALONG ELEMENT SIDES//
     1 39H NODE         X           Y           Z/)
  901 FORMAT(/1X,49HINCREASE NO. OF ADDITIONAL NODES (ROUTINE MIDSID))
  902 FORMAT(/1X,21H***ERROR*** MORE THAN,I5,
     1 30HNODES IN MESH (ROUTINE MIDSID))
  904 FORMAT(I5,3F12.3)
  910 FORMAT(//1X,4HITAB/(1X,10I10))
      END
      SUBROUTINE MLAPZ(MXND,NEL,NN,NCORR,LTYP,NQ)
C***********************************************************************
C     MARKS LAST APPEARANCES OF NODES BY MAKING THEM NEGATIVE
C     IN NCORR ARRAY
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),LTYP(NEL),NQ(NN)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
C
      NEL1=NEL+1
C
      DO 30 M=1,NN
      IF(NQ(M).EQ.0) GOTO 30
      DO 20 J=1,NEL
      JB=NEL1-J
      IF(LTYP(JB).LT.0) GOTO 20
      LT=LTYP(JB)
      NDPT=LINFO(1,LT)
      DO 10 I=1,NDPT
      IF(NCORR(I,JB).NE.M) GOTO 10
      NCORR(I,JB)=-NCORR(I,JB)
      GOTO 30
   10 CONTINUE
   20 CONTINUE
   30 CONTINUE
C
      RETURN
      END
      SUBROUTINE NUMSH(IW6,IWP,NDIM,NNE,MXND,NEL,MUMAX,NNU,XYZ,
     1 NCORR,LTYP,MREL,NREL,NDZ,IPLOT)
C***********************************************************************
C     ROUTINE TO NUMBER MESH
C     LAST MODIFIED ON 15 MAY 93
C***********************************************************************
      DIMENSION XYZ(NDIM,NNE),NCORR(MXND,NEL),LTYP(NEL),
     1 MREL(MUMAX),NREL(NNU),XYZD(3),XYZC(3)
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
C
      IF(IPLOT.EQ.0)RETURN
C *** NDZ1 - STARTING VALUE OF USER NUMBER OF EDGE NODES
      NDZ1=NDZ+1
C *** CODE TO INDICATE THAT A NUMBER IS TO BE PLOTTED
      ICODE=11
C *** DUMMY COORDINATES
      DO 4 ID=1,NDIM
    4 XYZD(ID)=0.
      IDUM=0
      IZERO=0
C
      NC=0
      IPL=IPLOT
      IF(IPL.EQ.1)GOTO 100
    5 IF(IPL-3)10,20,30
C
C *** PEN COLOUR IS BLACK FOR VERTEX NODES
   10 IPEN=-1
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
  910    FORMAT(1X,I10,2E15.5,I10)
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
  920    FORMAT(1X,I10,3E15.5,I10)
      ENDIF
C
CC    WRITE(IW6,900)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
  900 FORMAT(1X,I5,2F10.2,I5)
      NN1=1
      NN2=NDZ
C
   12 DO 15 JR=NN1,NN2
      IF(NREL(JR).EQ.0)GO TO 15
      J=NREL(JR)
      JJ=JR
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)ICODE,(XYZ(ID,J),ID=1,NDIM),JJ
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)ICODE,(XYZ(ID,J),ID=1,NDIM),JJ
      ENDIF
C
CC    WRITE(IW6,900)ICODE,(XYZ(ID,J),ID=1,NDIM),JJ
   15 CONTINUE
C
      IF(NC.EQ.0)GOTO 100
      NC=0
C *** PEN COLOUR IS RED FOR EDGE NODES
   20 IPEN=-2
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
      ENDIF
C
CC    WRITE(IW6,900)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
      NN1=NDZ1
      NN2=NNU
      GOTO 12
C
   30 IF(IPL.GT.4)GOTO 40
      NC=1
      GOTO 10
C *** PEN COLOUR IS GREEN FOR ELEMENTS
   40 IPEN=-3
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
      ENDIF
C
CC    WRITE(IW6,900)IPEN,(XYZD(ID),ID=1,NDIM),IDUM
C
      DO 50 JR=1,MUMAX
      IF(MREL(JR).EQ.0)GOTO 50
      J=MREL(JR)
C
      DO 35 ID=1,NDIM
   35 XYZC(ID)=0.
C
      LT=LTYP(J)
      NV=LINFO(2,LT)
C
      DO 46 I=1,NV
      L=NCORR(I,J)
      DO 46 ID=1,NDIM
   46 XYZC(ID)=XYZC(ID)+XYZ(ID,L)/FLOAT(NV)
C
      JJ=JR
C     WRITE(IWP)ICODE,(XYZC(ID),ID=1,NDIM),JJ
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)ICODE,(XYZC(ID),ID=1,NDIM),JJ
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)ICODE,(XYZC(ID),ID=1,NDIM),JJ
      ENDIF
C
CC    WRITE(IW6,900)ICODE,(XYZC(ID),ID=1,NDIM),JJ
   50 CONTINUE
C
      IPL=IPL-4
      IF(IPL.GT.1)GOTO 5
C
C *** CLOSE FILE
  100 CONTINUE
C 100 WRITE(IWP)IZERO,(XYZD(ID),ID=1,NDIM),IDUM
C
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IZERO,(XYZD(ID),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IZERO,(XYZD(ID),ID=1,NDIM),IDUM
      ENDIF
C
CC    WRITE(IW6,900)IZERO,(XYZD(ID),ID=1,NDIM),IDUM
      RETURN
      END
      SUBROUTINE RDCOD(IW6,NNE,NDIM,NNU,NVTX,NUMAX,XYZ,NRELVV,NREL)
C***********************************************************************
C     ROUTINE TO READ THE COORDINATES OF VERTEX NODES
C***********************************************************************
CS    CHARACTER*1 JDO
      DIMENSION XYZ(NDIM,NNE),NRELVV(NNE),NREL(NNU)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CS    COMMON /FFL   / JDO(130)
C
      WRITE(IW6,900)
      WRITE(IW6,901)
C
C *** INITIALISE NREL, NRELVV
      CALL ZEROI1(NRELVV,NNE)
      CALL ZEROI1(NREL,NNU)
C
C *** READ ALL VERTEX NODE COORDINATES
C
      NTM=NDIM+1
      DO 10 J=1,NVTX
      CALL FFIN(NTM,1)
      K=IFIX(AR(1))
C
      DO 5 ID=1,NDIM
    5 XYZ(ID,J)=AR(ID+1)
      WRITE(IW6,906)K,(XYZ(ID,J),ID=1,NDIM)
      NRELVV(J)=K
   10 NREL(K)=J
      RETURN
  900 FORMAT(//10X,28HCO-ORDINATES OF VERTEX NODES)
  901 FORMAT(/3X,4HNODE,7X,1HX,11X,1HY,11X,1HZ/)
  906 FORMAT(1X,I10,3F20.5)
      END
      SUBROUTINE RDINT(NPAR,N)
C***********************************************************************
C     ROUTINE TO READ A SET OF N INTEGER NUMBERS
C***********************************************************************
      DIMENSION NPAR(N)
      COMMON /FF/ AR(40),NCARD,NERR,JERR,LUN
C
      NT=N
      MNPC=10
      IC=0
   10 IF(NT.LT.MNPC)MNPC=NT
      CALL FFIN(MNPC,1023)
C
      DO 20 IK=1,MNPC
      IC=IC+1
   20 NPAR(IC)=IFIX(AR(IK))
      NT=NT-MNPC
      IF(NT.NE.0)GO TO 10
      NT=IC
      RETURN
      END
      SUBROUTINE RDREL(PAR,N)
C***********************************************************************
C     ROUTINE TO READ A SET OF N REAL NUMBERS
C***********************************************************************
      DIMENSION PAR(N)
      COMMON /FF/ AR(40),NCARD,NERR,JERR,LUN
C
      NT=N
      MNPC=10
      IC=0
   10 IF(NT.LT.MNPC)MNPC=NT
      CALL FFIN(MNPC,0)
C
      DO 20 IK=1,MNPC
      IC=IC+1
   20 PAR(IC)=AR(IK)
      NT=NT-MNPC
      IF(NT.NE.0)GO TO 10
      NT=IC
      RETURN
      END
      SUBROUTINE SETNP(NP1,NP2,NPL)
C***********************************************************************
C     SET UP ARRAYS NP1 AND NP2 WHICH GIVE THE INDEX TO ARRAY
C     NCORR FOR NODES AT EITHER END OF EACH ELEMENT EDGE
C***********************************************************************
      DIMENSION NPL1(21),NPL2(21),NP1(NPL),NP2(NPL)
C-----------------------------------------------------------------------
C              INDEXES OF ARRAYS NPL1,NPL2,NP1,NP2
C           INDEX            ELEMENT TYPE
C           1 -  3            1, 2, 3, 6, 7, 12
C           4 -  7            4, 5, 13
C           4 - 15            8, 9
C          16 - 21           10, 11
C-----------------------------------------------------------------------
      DATA NPL1(1),NPL1(2),NPL1(3),NPL1(4),NPL1(5),NPL1(6),NPL1(7),
     1 NPL1(8),NPL1(9),NPL1(10),NPL1(11),NPL1(12),NPL1(13),NPL1(14),
     2 NPL1(15),NPL1(16),NPL1(17),NPL1(18),NPL1(19),NPL1(20),NPL1(21)/
     3 1,2,3,1,2,3,4,5,6,7,8,1,2,3,4,1,2,3,1,2,3/
      DATA NPL2(1),NPL2(2),NPL2(3),NPL2(4),NPL2(5),NPL2(6),NPL2(7),
     1 NPL2(8),NPL2(9),NPL2(10),NPL2(11),NPL2(12),NPL2(13),NPL2(14),
     2 NPL2(15),NPL2(16),NPL2(17),NPL2(18),NPL2(19),NPL2(20),NPL2(21)/
     3 2,3,1,2,3,4,1,6,7,8,5,5,6,7,8,2,3,1,4,4,4/
C
      DO 10 I=1,NPL
      NP1(I)=NPL1(I)
   10 NP2(I)=NPL2(I)
C
      RETURN
      END
      SUBROUTINE SFWZ(MNFZ,MXND,NEL,NN,MUMAX,NNZ,IFRZ,
     1 NCORR,LTYP,NQ,NDEST,MREL,NREL,IFR,MULT,MCORE,NCORET)
C***********************************************************************
C     WORKS OUT FRONT WIDTH (IN NODES) FOR SYMMETRIC SOLUTION
C     USING LAST APPEARANCES MARKED BY SUBROUTINE MLAPZ.
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),LTYP(NEL),MREL(MUMAX),NREL(NNZ)
      DIMENSION NDEST(NN),NQ(NN),IFR(IFRZ)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DEVSUP/ IW15,IWS
C
      INCORE=0
      DO 6 J=1,NEL
      IF(LTYP(J).LT.0) GOTO 6
      N=NCORR(1,J)
      NA=IABS(N)
      NDFN=NQ(NA)
      IF(NDFN.EQ.0)GOTO 6
      DO 4 I=1,NDFN
    4 IFR(I)=NA
      NFZ=NDFN
      MNFZ=NDFN
      NDEST(NA)=1
      GOTO 8
    6 CONTINUE
C
      WRITE(IWS,900)
      WRITE(IW15,900)
      WRITE(IW6,900)
      STOP
C
    8 CONTINUE
C-----------------------------------------------------------------------
C     CONSIDER EACH ELEMENT IN TURN
C-----------------------------------------------------------------------
      DO 40 J=1,NEL
C-----------------------------------------------------------------------
C     IGNORE OMITTED ELEMENTS
C-----------------------------------------------------------------------
      IF(LTYP(J).LT.0) GOTO 40
C-----------------------------------------------------------------------
C     CONSIDER EACH NODE OF THIS ELEMENT - DOES IT ALREADY HAVE
C     A ROW/COLUMN ALLOCATED TO IT IN THE GLOBAL STIFFNESS MATRIX ?
C-----------------------------------------------------------------------
      LT=LTYP(J)
      NNE=LINFO(1,LT)
      DO 20 I=1,NNE
      N=NCORR(I,J)
      NA=IABS(N)
      IF(NQ(NA).EQ.0)GOTO 20
C
      DO 10 K=1,NFZ
      IF(IFR(K).EQ.NA) GOTO 20
   10 CONTINUE
C-----------------------------------------------------------------------
C     FIND A (LARGE ENOUGH) GAP OR PUT ON END
C-----------------------------------------------------------------------
      K1=1
   11 DO 12 K=K1,NFZ
      IF(IFR(K).EQ.0) GOTO 15
   12 CONTINUE
C-----------------------------------------------------------------------
C     PUT ON END
C-----------------------------------------------------------------------
      K=NFZ+1
      NFZ=NFZ+NQ(NA)
      IF(NFZ.LE.IFRZ) GOTO 14
      WRITE(IWS,904)
      WRITE(IW15,904)
      WRITE(IW6,904)
      STOP
C
   14 K2=NFZ
      IF(NFZ.GT.MNFZ)MNFZ=NFZ
      GOTO 18
C
   15 DO 16 KK=K,NFZ
      IF(IFR(KK).NE.0) GOTO 17
   16 CONTINUE
C
      WRITE(IWS,905)
      WRITE(IW15,905)
      WRITE(IW6,905)
C
      WRITE(IWS,997)J,I
      WRITE(IW15,997)J,I
      WRITE(IW6,997)J,I
C
      WRITE(IWS,998)NFZ
      WRITE(IW15,998)NFZ
      WRITE(IW6,998)NFZ
C
      WRITE(IWS,999)(IFR(LL),LL=1,NFZ)
      WRITE(IW15,999)(IFR(LL),LL=1,NFZ)
      WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
      STOP
C
   17 K1=KK
      IF(NQ(NA).GT.KK-K) GOTO 11
      K2=K+NQ(NA)-1
   18 NDEST(NA)=K
C
      DO 19 KK=K,K2
   19 IFR(KK)=NA
   20 CONTINUE
CC    WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
C-----------------------------------------------------------------------
C     ELIMINATE NODES FROM FRONT THAT ARE MAKING THEIR LAST APPEARANCES.
C-----------------------------------------------------------------------
      DO 30 I=1,NNE
      IF(NCORR(I,J).GT.0) GOTO 30
C
      NOD=NCORR(I,J)
      NOD=IABS(NOD)
      IF(NQ(NOD).EQ.0)GOTO 30
      DO 22 K=1,NFZ
      N=NCORR(I,J)
      NA=IABS(N)
      IF(NA.EQ.IFR(K)) GOTO 23
   22 CONTINUE
      WRITE(IWS,908)
      WRITE(IW15,908)
      WRITE(IW6,908)
      STOP
C
   23 K2=K+NQ(NA)-1
      NCORR(I,J)=NCORR(I,J)*MULT
      DO 24 KK=K,K2
      INCORE=INCORE+NFZ+4
   24 IFR(KK)=0
      IF(K2.LT.NFZ) GOTO 30
C
   26 NFZ=NFZ-1
      IF(NFZ.EQ.0) GOTO 30
      IF(IFR(NFZ).EQ.0) GOTO 26
C
   30 CONTINUE
C
      IF(ID3.NE.1)GOTO 40
      IF(NFZ.GT.0) WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
   40 CONTINUE
C
      WRITE(IW6,910) MNFZ
C
      IF(ID4.EQ.1)WRITE(IW6,950)NDEST
      MCORE=MNFZ*(MNFZ+1)/2+2*MNFZ+502
      NCORET=MCORE+INCORE
      WRITE(IW6,915)MCORE
      WRITE(IW6,920)INCORE
      RETURN
  900 FORMAT(1X,40HNO ELEMENTS IN SOLUTION ] (ROUTINE SFWZ))
  904 FORMAT(1X,47H***ERROR** TOO MANY DEGREES OF FREEDOM IN FRONT,
     1 1X,14H(ROUTINE SFWZ))
  905 FORMAT(40H0PROGRAM ERROR - NO NODE ON END OF FRONT/
     1 15H0(ROUTINE SFWZ))
  908 FORMAT(1X,52HPROGRAM ERROR - LAST APPEARANCE NODE IS NOT IN FRONT,
     1 1X,14H(ROUTINE SFWZ))
  910 FORMAT(/1X,35HMAXIMUM FRONT WIDTH FOR SOLUTION = ,I4,
     1 19H DEGREES OF FREEDOM)
  915 FORMAT(/1X,43HMINIMUM CORE REQUIRED TO SOLVE EQUATIONS = ,I10)
  920 FORMAT(/1X,47HADDITIONAL CORE REQUIRED FOR INCORE SOLUTION = ,I10)
  950 FORMAT(//1X,5HNDEST/(1X,20I5))
  997 FORMAT(5H J = ,I5,7H   I = ,I5)
  998 FORMAT(7H NFZ = ,I12)
  999 FORMAT(4H0IFR/(1X,25I5))
      END
      SUBROUTINE SIDES(IW6,IWP,LTAB,LDIM,NDIM,NNE,MXND,NEL,
     1 ITAB,XYZ,NCORR)
C***********************************************************************
C     PLOTS MESH
C***********************************************************************
      DIMENSION ITAB(LTAB,LDIM),XYZ(NDIM,NNE),
     1 NCORR(MXND,NEL),XYZD(3)
C
C *** LOOP ON ALL EDGES
C
      NSD=LDIM-3
C *** PEN MOVEMENT : 3 - MOVETO ; 1 - DRAWTO
      IONE=1
      ITHR=3
      IDUM=0
C
C *** DUMMY COORDINATES
      DO 5 ID=1,NDIM
    5 XYZD(ID)=0.
C *** PEN COLOUR IS BLACK FOR DRAWING MESH
      ICODE=-1
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)ICODE,(XYZD(ID),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)ICODE,(XYZD(ID),ID=1,NDIM),IDUM
      ENDIF
C
      DO 20 L=1,LTAB
      IF(ITAB(L,1).EQ.0)GOTO 20
      N1=ITAB(L,1)/10000
      N2=ITAB(L,1)-N1*10000
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)ITHR,(XYZ(ID,N1),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)ITHR,(XYZ(ID,N1),ID=1,NDIM),IDUM
      ENDIF
      IF(ITAB(L,LDIM).NE.2)GO TO 15
C
C *** DRAW CURVED SIDE - USING STRAIGHT LINES PASSING
C *** THROUGH ALL DISPLACEMENT NODES
      DO 10 ISD=1,NSD
      ND=ITAB(L,ISD+1)
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IONE,(XYZ(ID,ND),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IONE,(XYZ(ID,ND),ID=1,NDIM),IDUM
      ENDIF
   10 CONTINUE
   15 CONTINUE
      IF(NDIM.EQ.2) THEN
         WRITE(IWP,910)IONE,(XYZ(ID,N2),ID=1,NDIM),IDUM
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IWP,920)IONE,(XYZ(ID,N2),ID=1,NDIM),IDUM
      ENDIF
   20 CONTINUE
  910 FORMAT(1X,I10,2E15.5,I10)
  920 FORMAT(1X,I10,3E15.5,I10)
      RETURN
      END
      SUBROUTINE SORTN2(Y1,Y2,N1,N2,NMIN,NMAX)
C***********************************************************************
C     ROUTINE TO SORT TWO INTEGERS
C***********************************************************************
      NMIN=N1
      NMAX=N2
      IF(Y1.LT.Y2)RETURN
      NMAX=N1
      NMIN=N2
      RETURN
      END
      SUBROUTINE SORT2(N1,N2,I1,I2)
C***********************************************************************
C     ROUTINE TO SORT TWO INTEGERS. I1 IS LESS THAN I2
C***********************************************************************
      I1=N1
      I2=N2
      IF(I1.LT.I2)RETURN
      I1=N2
      I2=N1
      RETURN
      END
      SUBROUTINE ZEROI1(N,LN)
C***********************************************************************
C     ROUTINE TO INITIALISE A 1-DIMENSIONAL INTEGER ARRAY
C***********************************************************************
      DIMENSION N(LN)
C
      DO 10 I=1,LN
   10 N(I)=0
      RETURN
      END
      SUBROUTINE ZEROI2(N,L1,L2)
C***********************************************************************
C     ROUTINE TO INITIALISE A 2-DIMENSIONAL INTEGER ARRAY
C***********************************************************************
      DIMENSION N(L1,L2)
C
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 N(I,J)=0
      RETURN
      END
      SUBROUTINE ZEROR1(V,LV)
C***********************************************************************
C     ROUTINE TO INITIALISE A 1-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(LV)
C
      DO 10 I=1,LV
   10 V(I)=0.
      RETURN
      END
      SUBROUTINE ZEROR2(V,L1,L2)
C***********************************************************************
C     ROUTINE TO INITIALISE A 2-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(L1,L2)
C
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 V(I,J)=0.
      RETURN
      END
      SUBROUTINE ZEROR3(V,L1,L2,L3)
C***********************************************************************
C     ROUTINE TO INITIALISE A 3-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(L1,L2,L3)
C
      DO 10 K=1,L3
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 V(I,J,K)=0.
      RETURN
      END 
