C======================================================================
C     CRISP 90 VERSION :  [29 JUNE 90]
C     ----------------
C             
C     [07 MAY 94]
C                                                                       
C     1) IWRU2 passed to EQLOD and EQLBM to write equilibrium check
C        for every NFREQ-th increment.
C
C-----------------------------------------------------------------------
C
C     [17 MAR 94]
C
C     1) No. of sides that can be subjected to stress increased from
C        100 to 400.
C
C-----------------------------------------------------------------------
C     [7 APR 93]
C
C     1) No. of fixities increased from 200 to 2000.
C
C-----------------------------------------------------------------------
C     [6 MAR 93]
C
C     1) 2 noded beam and bar elements implemented from
C        MP89GDN.FOR
C
C-----------------------------------------------------------------------
C     [9 SEP 92]
C
C     1) Array LTYP(NEL) written as part of header block to
C        NRS file. This means LTYP is available for post
C        processing programs even before reading the results
C        from any of the increments.
C
C-----------------------------------------------------------------------
C
C     [1 SEP 92]
C
C     1) Separate arrays G and K for storing REAL and INTEGER
C        arrays separately.
C
C     2) Combined selected increment version with single/interactive
C        and multiple/batch. GETSZE - new routine added to allow
C        array sizes for G and K to specified from file CRISP92.SZE.
C
C     3) Pore pressure fixity code 3 implemented. Array PORINS now
C        contains in situ pore pressures at nodes.
C
C     4) PR(NPR,NMT)  NTY(NMT)  MAT(NEL)   NPLAX  NPR NMT
C        now written to NRS file.
C        Note that if PR is altered by the user during stop-restart
C        runs NRS file still contains the PR set at the beginning of
C        the analysis. It is insensitive to subsequent changes to PR.
C
C-----------------------------------------------------------------------
C
C     [1 OCT 91]
C
C     1) Routine FFIN. No. of characters read increased from 80 to 130.
C        Common block /FFL/ commented out from all routines except
C        for FFIN and MAST2.
C
C     2) Bug in stress stress codes not being printed fixed in UPOUT2.
C        Zero values were printed before even in the presence of Cam
C        clay models.
C
C     3) Bug in missing In situ eqlbm entries for re-started analysis
C        (unit 14) -  *.MAS file  now fixed by writing dummy record
C        in routine MSUB2.
C
C     4) Routine FLENME updated to detect DOS parameter CRSFLN being
C        set as default analysis identifier.
C
C     5) Routine CHKEXS - bug in INQUIRE statement fixed.
C
C     6) Cam-clay summary is written to unit 16. New routines
C        HEDSM called by SETUP and PRNTSM called by INSIT, UPOUT added.
C        New common block /EQBM/ RMAX(6),TER(3),IW16 added to
C        routines MAST2, EQLBM, PRNTSM, HEDSM.
C
C-----------------------------------------------------------------------
C
C     [1 NOV 90]
C
C     1) In routine MSUB2, INCS1 is set equal to INCS - 1. Previously
C        it was unset for the option ISR = 1.
C
C     2) In routine UPOUT, Array VARC is zeroed. Previously retained
C        values left during solution.
C
C     3) In routine UPOUT, VARC(7,..) is written to MAS file instead
C        of VARC(9,..). Previously voids ratio was written instead of
C        yield ratios.
C
C-----------------------------------------------------------------------
C
C     [6 JULY 90]  LINK NUMBER CHECK SUPPRESSED FOR COURSE.
C
C
C     1) File naming conventions changed. All files relevant to a
C        particular analysis identified by a single name. File type
C        identified by the extension.
C
C     2) Some minor bugs fixed in routines UPOUT in calls to OUTBR,
C        OUTBM (LT was missing from sub arg list).
C
C     3) FIXX3 routine modified to allow specifying the nodes in
C        clockwise direction as well.            [29 June 90]
C
C     4) Bug in reactions fixed. REAC is now written to unit 2
C
C
C     5) AX-STRESS changed to AXI FORCE in routines OUTBR, OUTBM UPOUT.
C                                                [29 June 90]
C
C     6) Routines DELP, DEPT and YIELD modified to implement C(y)
C        for elastic-perfectly plastic models.   [12 JUne 90]
C
C
C***********************************************************************
C
C     COMMON /ELASP/ NDLM,NULP  included in routines UPOUT and YIELD
C                               to retain their values. [26 May 89]
C
C     In routine UPOUT2 IF(MCS(ILM).EQ.0)GOTO 82 statement moved
C     to after the NGP=LINFO(11,LT) statement           [26 May 89]
C
CSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
CMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
CPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
C
C
C                  C R I S P     M A I N    P R O G R A M   1 9 9 0
C
C           S I N G L E      P R E C I S I O N    V E R S I O N
C
C
C
C                V E R S I O N    N U M B E R   -   M P 0
C
C              P R O G R A M     L A S T   M O D I F I E D
C
C             O N      2 3    A P R I L          1 9 9 0
C
C
C
CSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
CMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
CPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
C
C=======================================================================
C=======================================================================
C      CRISP 1990
C=======================================================================
      CHARACTER*12 CMP90DAT,CRS90SOL,CMP90OUT,CRS90LNK,CRS90DSK,
     +             CMP90OLD,CMP90NEW,CMP90MPE,CMP90MAS,CMP90SMY
      CHARACTER*12 CRS90SZE
      CHARACTER*8 EDATE,TIME
      COMMON /GVAR/ G(7000000),K(7000000)
      COMMON /NMES/CMP90DAT,CRS90SOL,CMP90OUT,CRS90LNK,CRS90DSK,
     +             CMP90OLD,CMP90NEW,CMP90MPE,CMP90MAS,CMP90SMY
C--------SIZES OF ARRAYS G AND K SET IN THE PROGRAM
      LGMX=7000000
      LKMX=7000000
C
      LG=0
      LK=0
C
      CRS90SZE='CRISP92.SZE'
      CALL CHKEXS(CRS90SZE,'FORMATTED',2,IER)
      IF(IER.EQ.1) STOP
C
      OPEN(18,FILE='CRISP92.SZE')
      CALL GETSZE(LG,LK,'MP')
C
      IWS=2
      IWT=1
      IW6=6
      CALL OPENF(IWT,IWS,LG,LK)
C
      PRINT*,'   '
      PRINT*,'      *******  STARTING MP 92 RUN **********'
C
      WRITE(IW6,800)EDATE(),TIME()
  800 FORMAT(/1X,'Analysis Date  : ',A8,5X,'Start time  : ',A8/)
C
      CALL CLOCK(ST)
      CALL MAST2(G,LG,K,LK,LGMX,LKMX)
      CALL CLOCK(FI)
C
      PRINT*,' '
      PRINT*,'      *******  MP 92 RUN FINISHED **********'
      PRINT*,'  '
      PRINT*,' The following files have been created'
CC    WRITE(IWS,750)CMP90OUT,CRS90SOL,CMP90NEW,CMP90MPE,
CC   +              CMP90MAS,CRS90DSK
      WRITE(IWS,750)CMP90OUT,CMP90NEW,CMP90MPE,
     +              CMP90MAS,CRS90DSK,CMP90SMY
  750 FORMAT(/5X,'Printed Output (Results)          - ',A12
CC   +       /5X,'Scratch file (not needed anymore) - ',A12
     +       /5X,'New stop/restart file             - ',A12
     +       /5X,'Error messages file               - ',A12
     +       /5X,'Analysis assessment file          - ',A12
     +       /5X,'Selected results file             - ',A12
     +       /5X,'Cam clay summary file             - ',A12/)
C
      CALL CPUTME(ST,FI,IW6,IWS)
C
      STOP
      END
      SUBROUTINE CPUTME(ST,FI,IW6,IWS)
C***********************************************************************
C
C     CALCULATES CPU TIME USED BY THE ANALYSIS
C
C***********************************************************************
C
      CPU=FI-ST
      ID=0
      IH=0
      IM=0
      SEC=0
C
      SEC=CPU
      IF(CPU.GT.60) THEN
         IM=CPU/60.
         SEC=CPU-INT(CPU/60.)*60
      ENDIF
C
      IF(IM.GE.60) THEN
         IH=IM/60
         IM=MOD(IM,60)
      ENDIF
C
      IF(IH.GE.24) THEN
         ID=IH/24
         IH=MOD(IH,24)
      ENDIF
C
      WRITE(IW6,820)ID,IH,IM,SEC
  820 FORMAT(/1X,72(1H=)/1X,' CPU time = ',I3,' d ',I2,' h ',I2,' m ',
     +        F5.1,' sec'/1X,72(1H=)/)
      WRITE(IWS,820)ID,IH,IM,SEC
C
      RETURN
      END
      SUBROUTINE OPENF(IWT,IWS,LG,LK)
C***********************************************************************
C
      LOGICAL EX,OPND
      CHARACTER*8 FLN8,FNMEMP,FNMELK,CMULT
      CHARACTER*1 SEQ,FMT
      INTEGER*2 ERROR_CODE
      CHARACTER*12 CMP90DAT,CRS90SOL,CMP90OUT,CRS90LNK,CRS90DSK,
     +             CMP90OLD,CMP90NEW,CMP90MPE,CMP90MAS,CMP90SMY
      COMMON /NMES/CMP90DAT,CRS90SOL,CMP90OUT,CRS90LNK,CRS90DSK,
     +             CMP90OLD,CMP90NEW,CMP90MPE,CMP90MAS,CMP90SMY
      COMMON /COMBIN/ IMULT
C
CC    IWT=1
CC    IWS=2
C
      WRITE(IWS,700)LG,LK
  700 FORMAT(/20X,'*********************************'
     +       /20X,'*     CRISP MP 92 PROGRAM       *'
     +       /20X,'*    G(',I8,')  K(',I8,')   *'
     +       /20X,'*  [SELECTED INCREMENT VERSION] *'
     +       /20X,'*   LAST MODIFIED ON 24 AUG 92  *'
     +       /20X,'*********************************'/)
C
      CALL DOSPARAM@('MPMULT',CMULT)
C
      IF(CMULT.EQ.'        '.OR.CMULT(1:2).EQ.'NO') THEN
         IMULT=0
      ELSE IF(CMULT(1:3).EQ.'YES') THEN
         IMULT=1
      ELSE
         WRITE(IWS,750)CMULT
  750    FORMAT(/1X,'**** Error : Unable to interpret DOS parameter',
     +           1X,'(MPMULT) which is set to ',A8
     +          /1X,'             Set it to either  YES  or  NO and ',
     +           1X,'re run  MP.'/)
          STOP
      ENDIF
C
   10 CALL FLENME(FLN8,FNMEMP,ILM,FNMELK,ILK,2,1)
      IL=ILM
      CMP90DAT=FLN8(1:IL)//'.MPD'
C
      CALL CHKEXS(CMP90DAT,'FORMATTED',2,IER)
C
      IF(IMULT.EQ.0) THEN
         IF(IER.EQ.1) GOTO 10
      ELSE IF(IMULT.EQ.1) THEN
         IF(IER.EQ.1) THEN
            WRITE(IWS,800)CMP90DAT
  800       FORMAT(/1X,'*** Error : file ',A20,4X,'does not exist.'/
     +              1X,'            MP run terminated.'/)
            STOP
         ENDIF
      ENDIF
C
      CRS90LNK=FNMELK(1:ILK)//'.LIK'
C
      CALL CHKEXS(CRS90LNK,'UNFORMATTED',2,IER)
C
      IF(IMULT.EQ.0) THEN
         IF(IER.EQ.1) GOTO 10
      ELSE IF(IMULT.EQ.1) THEN
         IF(IER.EQ.1) THEN
            WRITE(IWS,800)CRS90LNK
            STOP
         ENDIF
      ENDIF
CC    IF(IER.EQ.1) GOTO 10
C
CC    CRS90SOL=FLN8(1:IL)//'.SOL'
      CRS90SOL='CRS90SOL'
      CMP90OUT=FLN8(1:IL)//'.MPO'
      CMP90OLD=FLN8(1:IL)//'.ORS'
      CMP90NEW=FLN8(1:IL)//'.NRS'
CC    CRS90DSK=FLN8(1:IL)//'.DSK'
      CRS90DSK='CRS90DSK'
      CMP90MPE=FLN8(1:IL)//'.MPE'
      CMP90MAS=FLN8(1:IL)//'.MAS'
      CMP90SMY=FLN8(1:IL)//'.SMY'
C
      OPEN(11,FILE=CMP90OLD,FORM='UNFORMATTED')
CC    PRINT*,' OLD'
      OPEN(12,FILE=CMP90NEW,FORM='UNFORMATTED')
CC    PRINT*,' NEW'
      OPEN(4,FILE=CRS90LNK,FORM='UNFORMATTED')
CC    PRINT*,' LNK'
      OPEN(5,FILE=CMP90DAT)
CC    PRINT*,' DAT'
      OPEN(6,FILE=CMP90OUT)
CC    PRINT*,' OUT'
      OPEN(7,FILE=CRS90SOL,FORM='UNFORMATTED')
CC    PRINT*,' SOL'
      OPEN(9,FILE=CRS90DSK,FORM='UNFORMATTED')
CC    PRINT*,' DSK'
      OPEN(14,FILE=CMP90MAS)
CC    PRINT*,' MAS'
C
      EX=.FALSE.
      OPND=.FALSE.
      INQUIRE(FILE=CMP90MPE,NUMBER=N,FORMATTED=FMT,EXIST=EX,
     +          SEQUENTIAL=SEQ)
      IF(EX.AND..NOT.OPND) THEN
C------------FILE EXISTS AND HAS NOT BEEN OPENED
         CALL ERASE@(CMP90MPE,ERROR_CODE)
         CALL DOSERR@(ERROR_CODE)
      ENDIF
C
      OPEN(15,FILE=CMP90MPE)
CC    PRINT*,' MPE'
      OPEN(16,FILE=CMP90SMY)
CC    PRINT*,' SMY'
C
      RETURN
      END
      SUBROUTINE FLENME(FLN8,FNMEMP,ILM,FNMELK,ILK,IWS,IWT)
C**********************************************************************
C     COMBINED VERSION - 27 AUGUST 92
C
C**********************************************************************
C
      CHARACTER*8 FLN8,FLNMDF,FNMEMP,FNMELK
      COMMON /COMBIN/ IMULT
C
      IF(IMULT.EQ.0) THEN
C
C--------SINGLE RUN/INTERACTIVE
         CALL DOSPARAM@('CRSFLN',FLNMDF)
C
         IF(FLNMDF.EQ.'        ') THEN
C
   10       WRITE(IWS,710)
  710       FORMAT(/1X,
     +      'Enter File/Analysis Identifier (up to 8 characters) :'/)
            READ(IWT,'(A)')FLN8
CC          WRITE(IWS,720)FLN8
CC720       FORMAT(1X,A8)
C
            DO 50 IP=1,8
            IB=8-IP+1
            IF(FLN8(IB:IB).NE.' ')GOTO 55
   50       CONTINUE
            GOTO 10
C
   55       CONTINUE
            IL=IB
C
         ELSE
C-----------DEFAULT FILE NAME FROM CRSFLN
   70       WRITE(IWS,750)FLNMDF
  750       FORMAT(/1X,
     +    'Enter File/Analysis Identifier (up to 8 characters) :',2X,A8
     +     //1X,'(Press the RETURN key to accept default name)'/)
            READ(IWT,'(A)')FLN8
CC          WRITE(IWS,720)FLN8
CC720       FORMAT(1X,A8)
C
            DO 80 IP=1,8
            IB=8-IP+1
            IF(FLN8(IB:IB).NE.' ')GOTO 95
   80       CONTINUE
C
            FLN8=FLNMDF
            DO 90 IP=1,8
            IB=8-IP+1
            IF(FLN8(IB:IB).NE.' ')GOTO 95
   90       CONTINUE
C
            WRITE(77,970)
  970       FORMAT(/1X,'POSSIBLE PROGRAM ERROR'/)
            GOTO 70
C
   95       CONTINUE
            IL=IB
CC          WRITE(77,920)FLN8,IL
CC          WRITE(2,920)FLN8,IL
CC920       FORMAT(/1X,'PARAMETER CRSFLN SET'/
CC   +              1X,'FILE ID  (FLN8)  =',A10,2X,'IL =',I5)
         ENDIF
C
         ILM=IL
         ILK=IL
         FNMEMP=FLN8
         FNMELK=FLN8
C
      ELSE IF(IMULT.EQ.1) THEN
C
C---------MULTIPLE RUN/BATCH MODE
C
         FNMEMP='        '
         FNMELK='        '
C
         CALL DOSPARAM@('MPDFN',FNMEMP)
         CALL DOSPARAM@('LINKFN',FNMELK)

         DO 150 IP=1,8
         IB=8-IP+1
         IF(FNMEMP(IB:IB).NE.' ')GOTO 155
  150    CONTINUE
         WRITE(IWS,810)
  810    FORMAT(/1X,'**** Error : DOS Parameter  MPDFN  is unset.'/
     +           1X,'             MP data file name is blank.'/
     +           1X,'             Run terminated.'/)
         STOP
C
  155    CONTINUE
         ILM=IB
C
         DO 160 IP=1,8
         IB=8-IP+1
         IF(FNMELK(IB:IB).NE.' ')GOTO 165
  160    CONTINUE
         WRITE(IWS,820)
  820    FORMAT(/1X,'**** Error : DOS Parameter  LINKFN  is unset.'/
     +           1X,'             LINK file name is blank.'/
     +           1X,'             Run terminated.'/)
         STOP
C
  165    CONTINUE
         ILK=IB
C
         FLN8=FNMEMP
C
      ENDIF
C
      RETURN
      END
      SUBROUTINE CHKEXS(FLN12,FRMTYP,IWS,IER)
C***********************************************************************
C
      LOGICAL EX
      CHARACTER*12 FLN12,FRMTYP*(*),FRMTYPN*11
C
      IF(FRMTYP(1:9).EQ.'FORMATTED') THEN
         KFLETY=1
      ELSE
         KFLETY=2
      ENDIF
C
      IER=0
CX    INQUIRE(FILE=FLN12,FORM=FRMTYP,EXIST=EX,ERR=50)
      INQUIRE(FILE=FLN12,FORM=FRMTYPN,EXIST=EX,ERR=50)
C
      IF(.NOT.EX) THEN
         WRITE(IWS,700)FLN12
  700    FORMAT(/' *** Error : File -  ',A12,2X,'Does not exist'//
     +           20X,'******  Program Terminated ******'/)
         STOP
      ENDIF
C
      IF(FRMTYPN(1:9).EQ.'FORMATTED') THEN
         JFLETY=1
      ELSE
         JFLETY=2
      ENDIF
C
CX    IF(KFLETY.NE.JFLETY) THEN
CX       WRITE(IWS,710)FLN12,FRMTYP,FRMTYPN
CX710    FORMAT('  File - ',A12,2X,/2A20)
C
CX       IER=1
CX    ENDIF
      RETURN
C
   50 CONTINUE
      WRITE(IWS,720)FLN12
  720 FORMAT(' *** Error : Check File - ',A12,2X,/
     + 'In-consistent file type or Incorrect file')
      IER=1
      RETURN
      END
      SUBROUTINE GETFREQ(IW6,INCF)
C***********************************************************************
C     ROUTINE TO GET NFREQ - INCREMENT FREQUENCY NUMBER FOR WRITING TO
C     UNIT 2 (NRS FILE)
C     7 AUGUST 91
C***********************************************************************
C
      CHARACTER*8 CNFRQ
      COMMON /NUNIT2/ NFREQ,IWRU2
      COMMON /COMBIN/ IMULT
C
      IWT=1
      IWS=2
C
      IF(IMULT.EQ.0) THEN
C
C--------SINGLE RUN/INTERACTIVE
   10    WRITE(IWS,900)
  900    FORMAT(/1X,'Enter the Increment frequency number (NFREQ) '
     +          /1X,'for writing  results to the  NRS  file :'/)
         READ(IWT,*,END=10,ERR=10)NFREQ
C
         IF(NFREQ.LT.1.OR.NFREQ.GT.INCF) THEN
            WRITE(IWS,905)NFREQ
  905    FORMAT(/1X,'Inadmissible value for NFREQ :',I8,'. Re-enter.'/)
            GOTO 10
         ENDIF
C
   20    WRITE(IWS,910)
  910    FORMAT(/1X,'Enter the Increment frequency number again'
     +          /1X,'for confirmation :'/)
         READ(IWT,*,END=20,ERR=20)NFREQC
C
         IF(NFREQ.NE.NFREQC) THEN
            WRITE(IWS,930)NFREQ,NFREQC
  930       FORMAT(/1X,' Mis-match of values typed for NFREQ :',2I8
     +             /1X,' Re-enter values again.'/)
            GOTO 10
         ENDIF
C
C--------MULTIPLE RUN/BATCH MODE
C
      ELSE IF(IMULT.EQ.1) THEN
         CALL DOSPARAM@('NFREQ',CNFRQ)
C
         IERR=0
         CALL CTOI(CNFRQ,NFREQ,IERR)
C
         IF(IERR.NE.0) THEN
            WRITE(IWS,985)
  985       FORMAT(/1X,'Increment frequency number (NFREQ) has not',
     +              1X,'been set.'/)
            NFREQ=0
         ENDIF
C
         IF(NFREQ.LT.1.OR.NFREQ.GT.INCF) THEN
            NFREQE=NFREQ
            NFREQ=INCF/10
            IF(NFREQ.EQ.0) NFREQ=1
            WRITE(IWS,990)NFREQE,NFREQ
  990       FORMAT(/1X,'Inadmissible value for NFRQ :',I8,'.'/
     +              1X,'It has been re-set to ',I8,'.'/)
         ELSE
            WRITE(IWS,995)NFREQ
  995       FORMAT(/1X,'Increment Frequency number (NFREQ) =',I8/)
         ENDIF
C
      ENDIF
      RETURN
      END
      SUBROUTINE GETSZE(LG,LK,PN)
C
C***********************************************************************
C
C     ROUTINE TO GET THE SIZES OF ARRAYS G AND K FROM CRISP92.SZE
C     FILE.
C     LAST MODIFIED ON 24 AUGUST 92
C
C***********************************************************************
C
      CHARACTER*4 PN*2,CG,CK,CLAB,CSZE*14,CL*14
C
      IWS=2
      IR18=18
C
      CG='LG'//PN
      CK='LK'//PN
      CSZE='              '
C
      REWIND IR18
   10 READ(IR18,900,END=500)CSZE
  900 FORMAT(A14)
C
      IF(CSZE(1:1).EQ.'C') GOTO 10
C
      CLAB=CSZE(1:4)
      IF(CLAB.NE.CG.AND.CLAB.NE.CK) GOTO 10
C
C--------FIND POSITION OF LAST NON-SPACE CHARACTER
      DO 50 IP=1,14
      IB=14-IP+1
      IF(CSZE(IB:IB).NE.' ') GOTO 55
   50 CONTINUE
      GOTO 10
C
   55 CONTINUE
      IL=IB
      CL=CSZE(6:IB)
C
CT    IERR=0
CT    CALL CTOI(CL,NA,IERR)
C
      READ(CL,910)NA
  910 FORMAT(I8)
C
      IF(CLAB.EQ.CG) THEN
         LG=NA
      ELSE IF(CLAB.EQ.CK) THEN
         LK=NA
      ENDIF
C
      GOTO 10
C
  500 CONTINUE
C
      IF(LG.EQ.0.OR.LK.EQ.0) THEN
         WRITE(IWS,920)PN
  920    FORMAT(/1X,'*** Error :  file - CRISP92.SZE does not have',
     +          /1X,'             array size entries for the ',A2,2X,
     +              'Program. Program Stopped.'/)
         STOP
      ENDIF
C
      RETURN
      END
      SUBROUTINE ANGTH(VARINT,NEL,NIP,NVRS,IP,J,THETA)
C***********************************************************************
C     ROUTINE TO CALCULATE ANGLE IN PI PLANE
C***********************************************************************
      DIMENSION VARINT(NVRS,NIP,NEL)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C
      SX=VARINT(1,IP,J)
      SY=VARINT(2,IP,J)
      SZ=VARINT(3,IP,J)
      TXY=VARINT(4,IP,J)
C
      PIBY4=0.25*PYI
      SD=0.5*(SX-SY)
      SM=0.5*(SX+SY)
      RAD=SQRT(SD*SD+TXY*TXY)
      SIG1=SM+RAD
      SIG3=SM-RAD
      DY=SY-SM
      IF(ABS(TXY).LT.ASMVL.AND.ABS(DY).LT.ASMVL)GOTO 8
      THXY2=ATAN2(TXY,DY)
      GOTO 9
    8 THXY2=0.5*PYI
    9 THXY=0.5*THXY2
      THXYD=THXY*180./PYI
      IF(ABS(THXY).LT.PIBY4)GOTO 10
      PSIGX=SIG1
      PSIGY=SIG3
      GOTO 15
   10 PSIGX=SIG3
      PSIGY=SIG1
   15 PSIGZ=SZ
C
      SIGX=(PSIGZ-PSIGY)/SQRT(2.)
      SIGY=(2.*PSIGX-PSIGY-PSIGZ)/SQRT(6.)
CC    RADO=SQRT(SIGX*SIGX+SIGY*SIGY)
      IF(ABS(SIGX).LT.ASMVL.AND.ABS(SIGY).LT.ASMVL)GOTO 20
C
      THETA=ATAN2(SIGY,SIGX)
      IF(THETA.LT.ZERO)THETA=2.*PYI+THETA
      THETA=THETA*180./PYI
      GOTO 25
C
   20 THETA=ALAR
   25 CONTINUE
C
      RETURN
      END
      SUBROUTINE ATRANS(A,SBAR,SIGM,TH,COH,PHI,KT,ESN,NDIM,NS)
C***********************************************************************
C     ROUTINE TO CALCULATE TRANSPOSE VECTOR OF A
C     FOR ELASTO PLASTIC MODELS
C***********************************************************************
      DIMENSION A(NS),ESN(NS)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      GO TO(10,5,30,5,50),KT
      WRITE(IW6,900)KT
  900 FORMAT(/1X,'**** ERROR - INADMISSIBLE YIELD CRITERION NUMBER',
     +        I5,5X,'(ROUTINE ATRANS)')
      WRITE(IW15,900)KT
      WRITE(IWS,900)KT
      STOP
C-----------------------------------------------------------------------
C     CHECK TRESCA AND MOHR-COULOMB MATERIALS
C     FOR SINGULARITY  (ABS(THETA) > 29 DEGREES)
C-----------------------------------------------------------------------
    5 R30=PYI/6.
      TOLER=R30-.02
      IF(ABS(TH).GT.TOLER) GO TO 7
      GO TO(99,20,99,40,99),KT
      STOP
    7 TH=SIGN(R30,TH)
      GO TO (99,10,99,45,99),KT
      STOP
C-----------------------------------------------------------------------
C     VON MISES
C-----------------------------------------------------------------------
   10 C1=0.
      C2=SQRT(3.0)
      C3=ZERO
      GO TO 60
C----------------------------------------------------------------------
C     TRESCA
C-----------------------------------------------------------------------
   20 C1=0.
      C2=2.*COS(TH)*(1.+TAN(TH)*TAN(3.*TH))
      C3=SQRT(3.)*SIN(TH)/(SBAR*SBAR*COS(3.*TH))
      GO TO 60
C-----------------------------------------------------------------------
C     DRUCKER PRAGER (OUTSCRIBING CIRCLE)
C-----------------------------------------------------------------------
   30 C=COS(PHI)
      S=SIN(PHI)
      ALPHA=2.*S/(SQRT(3.)*(3.-S))
      C1=-3.*ALPHA
      C2=1.
      C3=ZERO
      GO TO 60
C-----------------------------------------------------------------------
C     MOHR COULOMB
C-----------------------------------------------------------------------
   40 S=SIN(PHI)
      SRT3=SQRT(3.)
      C1=-S
      C2=COS(TH)*(1.+TAN(TH)*TAN(3.*TH)-(S/SRT3)*(TAN(3.*TH)-TAN(TH)))
      C3=(SRT3*SIN(TH)-COS(TH)*S)/(2.*SBAR*SBAR*COS(3.*TH))
      GO TO 60
C-----------------------------------------------------------------------
C     MOHR COULOMB (NEAR A SINGULARITY)
C-----------------------------------------------------------------------
   45 S=SIN(PHI)
      SRT3=SQRT(3.)
      C1=-S
      TERM=0.5*(3.+S)/SRT3
      IF(TH.LT.ZERO)TERM=0.5*(3.-S)/SRT3
      C2=TERM
      C3=ZERO
      GO TO 60
C-----------------------------------------------------------------------
C     DRUCKER PRAGER (INSCRIBING CIRCLE)
C-----------------------------------------------------------------------
   50 C=COS(PHI)
      S=SIN(PHI)
      ALPHA=S/(SQRT(9.+3.*S*S))
      C1=-3.*ALPHA
      C2=1.
      C3=ZERO
C
   60 CONS1=C1/3.
      CONS2=C2/(2.*SBAR)
      CONS3=C3*SBAR*SBAR/3.
C
      A(1)=CONS1+ESN(1)*CONS2+CONS3+C3*ESN(2)*ESN(3)
      A(2)=CONS1+ESN(2)*CONS2+CONS3+C3*ESN(1)*ESN(3)
      A(3)=CONS1+ESN(3)*CONS2+CONS3+C3*(ESN(1)*ESN(2)-ESN(4)*ESN(4))
      A(4)=2.*ESN(4)*CONS2+C3*(-2.*ESN(3)*ESN(4))
      IF(NDIM.EQ.2)RETURN
      A(1)=A(1)-C3*ESN(5)*ESN(5)
      A(2)=A(2)-C3*ESN(6)*ESN(6)
      A(4)=A(4)+C3*(2.0*ESN(5)*ESN(6))
      A(5)=2.0*ESN(5)*CONS2+2.0*C3*(ESN(4)*ESN(6)-ESN(1)*ESN(5))
      A(6)=2.*ESN(6)*CONS2+2.0*C3*(ESN(4)*ESN(5)-ESN(2)*ESN(6))
C
      RETURN
   99 STOP
      END
      BLOCK DATA
C***********************************************************************
C      DATA PRESENTED BY LIN (FIRST SUBSCRIPT)
C  1 - TOTAL NUMBER OF NODES (DISPLACEMENT + POREPRESSURE)..........NDPT
C  2 - TOTAL NUMBER OF VERTEX NODES..................................NVN
C  3 - TOTAL NUMBER OF ELEMENT EDGES................................NEDG
C  4 - TOTAL NUMER OF ELEMENT FACES (3D)............................NFAC
C  5 - TOTAL NUMBER OF DISPLACEMENT NODES............................NDN
C  6 - TOTAL NUMBER OF POREPRESSURE NODES............................NPN
C  7 - NUMBER OF DISPLACEMENT NODES PER EDGE (EXCLUDING END NODES)..NSDN
C  8 - NUMBER OF POREPRESSURE NODES PER EDGE (EXCLUDING END NODES)..NSDP
C  9 - NUMBER OF INNER DISPLACEMENT NODES...........................NIND
C 10 - NUMBER OF INNER POREPRESSURE NODES...........................NINP
C 11 - NUMBER OF INTEGRATION POINTS..................................NGP
C 12 - INDEX TO WEIGHTS AND INTEGRATION POINT COORDINATES...........INDX
C 13 - NOT USED IN THIS VERSION.........................................
C 14 - INDEX TO NODES ALONG EDGE (ARRAYS NP1, NP2).................INDED
C 15 - NUMBER OF AREA COORDINATES.....................................NL
C 16 - TOTAL NUMBER OF DEGREES OF FREEDOM (D.O.F.) IN ELEMENT.......MDFE
C 17 - CENTROID INTEGRATION POINT NUMBER............................NCGP
C 18 - 20 NOT USED.
C 21 - 50 ARE THE NUMBER OF D.O.F. OF EACH NODE OF ELEMENT..........NDFN
C
C            (ASSUMING THAT NO ELEMENT TYPE HAS MORE THAN 30 NODES.
C             OTHERWISE INCREASE SIZE OF FIRST SUBSCRIPT OF ARRAY LIN).
C
C      ELEMENT TYPES (SECOND SUBSCRIPT) - TO CATER FOR 15 ELEMENT TYPES.
C       1 - 3-NODED BAR ....................(2-D PLANE STRAIN ONLY)
C       2 - 6-NODED LST TRIANGLE............(2-D)
C       3 - 6-NODED LST TRIANGLE............(2-D CONSOLIDATION)
C       4 - 8-NODED QUADRILATERAL...........(2-D)
C       5 - 8-NODED QUADRILATERAL...........(2-D CONSOLIDATION)
C       6 - 15-NODED CUST TRIANGLE..........(2-D)
C       7 - 22-NODED CUST TRIANGLE..........(2-D CONSOLIDATION)
C       8 - 20-NODED BRICK..................(3-D)
C       9 - 20-NODED BRICK..................(3-D CONSOLIDATION)
C      10 - 10-NODED TETRA-HEDRA............(3-D)
C      11 - 10-NODED TETRA-HEDRA............(3-D CONSOLIDATION)
C      12 -  3-NODED BEAM ..................(2-D PLANE STRAIN ONLY)
C      13 -  8-NODED SLIP ELEMENT...........(2-D PLANE STRAIN ONLY)
C
C=======================================================================
C
C      ARRAY MIN (HAS THE NAME MINFO IN THE REST OF THE PROGRAM) IS
C      TO SUPPLEMENT THE ARRAY LIN (LINFO IN THE REST OF THE PROGRAM).
C      ARRAY MIN GIVES THE UNIQUE PROGRAM VARIABLE NUMBER (UPVN) FOR
C      EACH OF THE VARIABLE OF A NODE.
C
C        UPVN
C          1  -   DISPLACEMENT IN X DIRECTION .................. U
C          2  -   DISPLACEMENT IN Y DIRECTION................... V
C          3  -   DISPLACEMENT IN Z DIRECTION .................. W
C          4  -   EXCESS PORE PRESSURE ......................... P
C          5  -   ROTATION IN XY PLANE .........................
C          6  -   NOT USED
C
C      THE FIRST SUBSCRIPT REPRESENTS EACH OF THE VARIABLES AT A NODE.
C      THE SECOND SUBSCRIPT TO ARRAY MIN REPRESENTS EACH OF THE NODES OF
C      AN ELEMENT TYPE.
C      THE THIRD  SUBSCRIPT IDENTIFIES THE ELEMENT TYPE.
C*******************************************************************************
      REAL L
      COMMON /ELINF/ MIN(6,30,15),LIN(50,15)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /SAMP / POSSP(5),WEIGP(5)
      DATA (LIN(I1,1),I1=1,23)/
     +     3,2,1,1,3,0,1,0,0,0,5,0,0,0,1,6,3,0,0,0,2,2,2/
      DATA (LIN(I2,2),I2=1,26)/
     +     6,3,3,1,6,0,1,0,0,0,7,5,0,0,3,12,7,0,0,0,2,2,2,2,2,2/
      DATA (LIN(I3,3),I3=1,26)/
     +     6,3,3,1,6,3,1,0,0,0,7,5,0,0,3,15,7,0,0,0,3,3,3,2,2,2/
      DATA (LIN(I4,4),I4=1,28)/
CC    FULL 3 X 3 INTEGRATION SCHEME FOR ELEMENT TYPE 4
     +     8,4,4,1,8,0,1,0,0,0,9,12,4,3,2,16,9,0,0,0,2,2,2,2,2,2,2,2/
CC    REDUCED 2 X 2 INTEGRATION SCHEME FOR ELEMENT TYPE 4
CC   +     8,4,4,1,8,0,1,0,0,0,4,64,4,3,2,16,4,0,0,0,2,2,2,2,2,2,2,2/
      DATA (LIN(I5,5),I5=1,28)/
     +     8,4,4,1,8,4,1,0,0,0,9,12,4,3,2,20,9,0,0,0,3,3,3,3,2,2,2,2/
      DATA (LIN(I6,6),I6=1,35)/
     +     15,3,3,1,15,0,3,0,3,0,16,21,0,0,3,30,16,0,0,0,
     +     2,2,2,2,2,2,2,2,2,2,2,2,2,2,2/
      DATA (LIN(I7,7),I7=1,42)/
     +     22,3,3,1,15,10,3,2,3,1,16,21,0,0,3,40,16,0,0,0,
     +     3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1/
      DATA (LIN(I8,8),I8=1,40)/
     +     20,8,12,6,20,0,1,0,0,0,27,37,4,3,3,60,27,0,0,0,
     +     3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3/
      DATA (LIN(I9,9),I9=1,40)/
     +     20,8,12,6,20,8,1,0,0,0,27,37,4,3,3,68,27,0,0,0,
     +     4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3/
      DATA (LIN(I10,10),I10=1,30)/
     +     10,4,6,4,10,0,1,0,0,0,4,64,28,15,4,30,0,0,0,0,
     +     3,3,3,3,3,3,3,3,3,3/
      DATA (LIN(I11,11),I11=1,30)/
     +     10,4,6,4,10,4,1,0,0,0,4,64,28,15,4,34,0,0,0,0,
     +     4,4,4,4,3,3,3,3,3,3/
C---------- ELEMENT TYPE 12 - 3 NODED BEAM
      DATA (LIN(I12,12),I12=1,23)/
     +     3,2,1,1,3,0,1,0,0,0,5,0,0,0,1,9,3,0,0,0,3,3,3/
C---------- ELEMENT TYPE 13 - JOINT ELEMENT
      DATA (LIN(I13,13),I13=1,28)/
     +     8,4,4,1,8,0,1,0,0,0,5,0,0,3,1,12,3,0,0,0,2,2,2,2,2,0,2,0/
C---------- ELEMENT TYPE 14 - 2 NODED BAR
      DATA (LIN(I14,14),I14=1,22)/
     +     2,2,0,1,2,0,0,0,0,0,5,0,0,0,1,4,3,0,0,0,2,2/
C---------- ELEMENT TYPE 15 - 2 NODED BEAM
      DATA (LIN(I15,15),I15=1,22)/
     +     2,2,0,1,2,0,0,0,0,0,5,0,0,0,1,6,3,0,0,0,3,3/
C======================================================================
C               MIN GIVES THE UPVN OF VARIABLES AT EACH NODE
C======================================================================
C---------- ELEMENT TYPE 1
      DATA MIN(1,1,1),MIN(2,1,1),MIN(1,2,1),MIN(2,2,1),MIN(1,3,1),
     +     MIN(2,3,1)/
     +     1,2,1,2,1,2/
C--------- ELEMENT TYPE 2
      DATA MIN(1,1,2),MIN(2,1,2),MIN(1,2,2),MIN(2,2,2),MIN(1,3,2),
     +     MIN(2,3,2),MIN(1,4,2),MIN(2,4,2),MIN(1,5,2),MIN(2,5,2),
     +     MIN(1,6,2),MIN(2,6,2)/
     +     1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 3
      DATA MIN(1,1,3),MIN(2,1,3),MIN(3,1,3),MIN(1,2,3),MIN(2,2,3),
     +     MIN(3,2,3),MIN(1,3,3),MIN(2,3,3),MIN(3,3,3),MIN(1,4,3),
     +     MIN(2,4,3),MIN(1,5,3),MIN(2,5,3),MIN(1,6,3),MIN(2,6,3)/
     +     1,2,4,1,2,4,1,2,4,1,2,1,2,1,2/
C--------- ELEMENT TYPE 4
      DATA MIN(1,1,4),MIN(2,1,4),MIN(1,2,4),MIN(2,2,4),MIN(1,3,4),
     +     MIN(2,3,4),MIN(1,4,4),MIN(2,4,4),MIN(1,5,4),MIN(2,5,4),
     +     MIN(1,6,4),MIN(2,6,4),MIN(1,7,4),MIN(2,7,4),MIN(1,8,4),
     +     MIN(2,8,4)/
     +     1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 5
      DATA MIN(1,1,5),MIN(2,1,5),MIN(3,1,5),MIN(1,2,5),MIN(2,2,5),
     +     MIN(3,2,5),MIN(1,3,5),MIN(2,3,5),MIN(3,3,5),MIN(1,4,5),
     +     MIN(2,4,5),MIN(3,4,5),MIN(1,5,5),MIN(2,5,5),MIN(1,6,5),
     +     MIN(2,6,5),MIN(1,7,5),MIN(2,7,5),MIN(1,8,5),MIN(2,8,5)/
     +     1,2,4,1,2,4,1,2,4,1,2,4,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 6
      DATA MIN(1,1,6),MIN(2,1,6),MIN(1,2,6),MIN(2,2,6),MIN(1,3,6),
     +     MIN(2,3,6),MIN(1,4,6),MIN(2,4,6),MIN(1,5,6),MIN(2,5,6),
     +     MIN(1,6,6),MIN(2,6,6),MIN(1,7,6),MIN(2,7,6),MIN(1,8,6),
     +     MIN(2,8,6),MIN(1,9,6),MIN(2,9,6),MIN(1,10,6),MIN(2,10,6),
     +     MIN(1,11,6),MIN(2,11,6),MIN(1,12,6),MIN(2,12,6),MIN(1,13,6),
     +     MIN(2,13,6),MIN(1,14,6),MIN(2,14,6),MIN(1,15,6),MIN(2,15,6)/
     +     1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 7
      DATA MIN(1,1,7),MIN(2,1,7),MIN(3,1,7),MIN(1,2,7),MIN(2,2,7),
     +     MIN(3,2,7),MIN(1,3,7),MIN(2,3,7),MIN(3,3,7),MIN(1,4,7),
     +     MIN(2,4,7),MIN(1,5,7),MIN(2,5,7),MIN(1,6,7),MIN(2,6,7),
     +     MIN(1,7,7),MIN(2,7,7),MIN(1,8,7),MIN(2,8,7),MIN(1,9,7),
     +     MIN(2,9,7),MIN(1,10,7),MIN(2,10,7),MIN(1,11,7),MIN(2,11,7),
     +     MIN(1,12,7),MIN(2,12,7),MIN(1,13,7),MIN(2,13,7),MIN(1,14,7),
     +     MIN(2,14,7),MIN(1,15,7),MIN(2,15,7),MIN(1,16,7),MIN(1,17,7),
     +     MIN(1,18,7),MIN(1,19,7),MIN(1,20,7),MIN(1,21,7),MIN(1,22,7)/
     +     1,2,4,1,2,4,1,2,4,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
     +     1,2,1,2,1,2,4,4,4,4,4,4,4/
C--------- ELEMENT TYPE 8
      DATA MIN(1,1,8),MIN(2,1,8),MIN(3,1,8),MIN(1,2,8),MIN(2,2,8),
     +     MIN(3,2,8),MIN(1,3,8),MIN(2,3,8),MIN(3,3,8),MIN(1,4,8),
     +     MIN(2,4,8),MIN(3,4,8),MIN(1,5,8),MIN(2,5,8),MIN(3,5,8),
     +     MIN(1,6,8),MIN(2,6,8),MIN(3,6,8),MIN(1,7,8),MIN(2,7,8),
     +     MIN(3,7,8),MIN(1,8,8),MIN(2,8,8),MIN(3,8,8),MIN(1,9,8),
     +     MIN(2,9,8),MIN(3,9,8),MIN(1,10,8),MIN(2,10,8),MIN(3,10,8),
     +     MIN(1,11,8),MIN(2,11,8),MIN(3,11,8),MIN(1,12,8),MIN(2,12,8),
     +     MIN(3,12,8),MIN(1,13,8),MIN(2,13,8),MIN(3,13,8),MIN(1,14,8),
     +     MIN(2,14,8),MIN(3,14,8),MIN(1,15,8),MIN(2,15,8),MIN(3,15,8),
     +     MIN(1,16,8),MIN(2,16,8),MIN(3,16,8),MIN(1,17,8),MIN(2,17,8),
     +     MIN(3,17,8),MIN(1,18,8),MIN(2,18,8),MIN(3,18,8),MIN(1,19,8),
     +     MIN(2,19,8),MIN(3,19,8),MIN(1,20,8),MIN(2,20,8),MIN(3,20,8)/
     +     1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 9
      DATA MIN(1,1,9),MIN(2,1,9),MIN(3,1,9),MIN(4,1,9),MIN(1,2,9),
     +     MIN(2,2,9),MIN(3,2,9),MIN(4,2,9),MIN(1,3,9),MIN(2,3,9),
     +     MIN(3,3,9),MIN(4,3,9),MIN(1,4,9),MIN(2,4,9),MIN(3,4,9),
     +     MIN(4,4,9),MIN(1,5,9),MIN(2,5,9),MIN(3,5,9),MIN(4,5,9),
     +     MIN(1,6,9),MIN(2,6,9),MIN(3,6,9),MIN(4,6,9),MIN(1,7,9),
     +     MIN(2,7,9),MIN(3,7,9),MIN(4,7,9),MIN(1,8,9),MIN(2,8,9),
     +     MIN(3,8,9),MIN(4,8,9),MIN(1,9,9),MIN(2,9,9),MIN(3,9,9),
     +     MIN(1,10,9),MIN(2,10,9),MIN(3,10,9),MIN(1,11,9),MIN(2,11,9),
     +     MIN(3,11,9),MIN(1,12,9),MIN(2,12,9),MIN(3,12,9),MIN(1,13,9),
     +     MIN(2,13,9),MIN(3,13,9),MIN(1,14,9),MIN(2,14,9),MIN(3,14,9),
     +     MIN(1,15,9),MIN(2,15,9),MIN(3,15,9),MIN(1,16,9),MIN(2,16,9),
     +     MIN(3,16,9),MIN(1,17,9),MIN(2,17,9),MIN(3,17,9),MIN(1,18,9),
     +     MIN(2,18,9),MIN(3,18,9),MIN(1,19,9),MIN(2,19,9),MIN(3,19,9),
     +     MIN(1,20,9),MIN(2,20,9),MIN(3,20,9)/
     +     1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,
     +     1,2,3,4,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 10
      DATA MIN(1,1,10),MIN(2,1,10),MIN(3,1,10),MIN(1,2,10),MIN(2,2,10),
     +   MIN(3,2,10),MIN(1,3,10),MIN(2,3,10),MIN(3,3,10),MIN(1,4,10),
     +   MIN(2,4,10),MIN(3,4,10),MIN(1,5,10),MIN(2,5,10),MIN(3,5,10),
     +   MIN(1,6,10),MIN(2,6,10),MIN(3,6,10),MIN(1,7,10),MIN(2,7,10),
     +   MIN(3,7,10),MIN(1,8,10),MIN(2,8,10),MIN(3,8,10),MIN(1,9,10),
     +   MIN(2,9,10),MIN(3,9,10),MIN(1,10,10),MIN(2,10,10),MIN(3,10,10)/
     +   1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3/
C--------- ELEMENT TYPE 11
      DATA MIN(1,1,11),MIN(2,1,11),MIN(3,1,11),MIN(4,1,11),MIN(1,2,11),
     +     MIN(2,2,11),MIN(3,2,11),MIN(4,2,11),MIN(1,3,11),MIN(2,3,11),
     +     MIN(3,3,11),MIN(4,3,11),MIN(1,4,11),MIN(2,4,11),MIN(3,4,11),
     +     MIN(4,4,11),MIN(1,5,11),MIN(2,5,11),MIN(3,5,11),MIN(1,6,11),
     +     MIN(2,6,11),MIN(3,6,11),MIN(1,7,11),MIN(2,7,11),MIN(3,7,11),
     +     MIN(1,8,11),MIN(2,8,11),MIN(3,8,11),MIN(1,9,11),MIN(2,9,11),
     +     MIN(3,9,11),MIN(1,10,11),MIN(2,10,11),MIN(3,10,11)/
     +     1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,1,2,3,1,2,3,1,2,3,
     +     1,2,3,1,2,3/
C--------- ELEMENT TYPE 12
      DATA MIN(1,1,12),MIN(2,1,12),MIN(3,1,12),MIN(1,2,12),MIN(2,2,12),
     +     MIN(3,2,12),MIN(1,3,12),MIN(2,3,12),MIN(3,3,12)/
     +     1,2,5,1,2,5,1,2,5/
C--------- ELEMENT TYPE 13
      DATA MIN(1,1,13),MIN(2,1,13),MIN(1,2,13),MIN(2,2,13),MIN(1,3,13),
     +     MIN(2,3,13),MIN(1,4,13),MIN(2,4,13),MIN(1,5,13),MIN(2,5,13),
     +     MIN(1,7,13),MIN(2,7,13)/
     +     1,2,1,2,1,2,1,2,1,2,1,2/
C--------- ELEMENT TYPE 14
      DATA MIN(1,1,14),MIN(2,1,14),MIN(1,2,14),MIN(2,2,14)/
     +     1,2,1,2/
C--------- ELEMENT TYPE 15
      DATA MIN(1,1,15),MIN(2,1,15),MIN(3,1,15),MIN(1,2,15),MIN(2,2,15),
     +     MIN(3,2,15)/
     +     1,2,5,1,2,5/
C-----------------------------------------------------------------------
C     ONE-DIMENSIONAL INTEGRATION - FOR ELEMENT TYPES 1, 12 AND 13
C-----------------------------------------------------------------------
      DATA L(1,1),L(1,2),L(1,3),L(1,4),L(1,5)/
     + -0.906179845938664,-0.538469310105683,0.0,
     + 0.538469310105683,0.906179845938664/
      DATA W(1),W(2),W(3),W(4),W(5)/
     + 0.236926885056189,0.478628670499366,0.568888888888889,
     + 0.478628670499366,0.236926885056189/
C-----------------------------------------------------------------------
C     AREA COORDINATES - LINEAR STRAIN TRIANGLE - ELEMENT TYPE 2,3
C-----------------------------------------------------------------------
      DATA L(1,6),L(2,6),L(3,6),L(1,7),L(2,7),L(3,7),L(1,8),L(2,8),
     + L(3,8),L(1,9),L(2,9),L(3,9),L(1,10),L(2,10),L(3,10),L(1,11),
     + L(2,11),L(3,11),L(1,12),L(2,12),L(3,12)/
     + .797426985353087245,.101286507323456343,.101286507323456343
     +,.101286507323456343,.797426985353087245,.101286507323456343
     +,.101286507323456343,.101286507323456343,.797426985353087245
     +,.597158717897698279E-01,.470142064105115082,.470142064105115082
     +,.470142064105115082,.597158717897698279E-01,.470142064105115082
     +,.470142064105115082,.470142064105115082,.597158717897698279E-01
     +,.333333333333333329,.333333333333333329,.333333333333333329/
C-----------------------------------------------------------------------
C     LOCAL COORDINATES - LINEAR STRAIN QUADRILATERAL - ELEMENT TYPE 4,5
C-----------------------------------------------------------------------
      DATA L(1,13),L(2,13),L(1,14),L(2,14),L(1,15),L(2,15),
     + L(1,16),L(2,16),L(1,17),L(2,17),L(1,18),L(2,18),
     + L(1,19),L(2,19),L(1,20),L(2,20),L(1,21),L(2,21)/
     + -0.774596669241483,-0.774596669241483,
     +  0.774596669241483,-0.774596669241483,
     +  0.774596669241483, 0.774596669241483,
     + -0.774596669241483, 0.774596669241483,
     +  0.,-0.774596669241483,
     +  0.774596669241483,0.,
     +  0., 0.774596669241483,
     + -0.774596669241483,0.,
     +  0.,0./
C-----------------------------------------------------------------------
C     AREA COORDINATES - CUBIC STRAIN TRIANGLE - ELEMENT TYPE 6,7
C-----------------------------------------------------------------------
      DATA L(1,22),L(2,22),L(3,22),L(1,23),L(2,23),L(3,23),L(1,24),
     + L(2,24),L(3,24),L(1,25),L(2,25),L(3,25),L(1,26),L(2,26),L(3,26),
     + L(1,27),L(2,27),L(3,27),L(1,28),L(2,28),L(3,28),L(1,29),
     + L(2,29),L(3,29)/
     + 0.898905543365938,0.050547228317031,0.050547228317031,
     + 0.050547228317031,0.898905543365938,0.050547228317031,
     + 0.050547228317031,0.050547228317031,0.898905543365938,
     + 0.658861384496478,0.170569307751761,0.170569307751761,
     + 0.170569307751761,0.658861384496478,0.170569307751761,
     + 0.170569307751761,0.170569307751761,0.658861384496478,
     + 0.081414823414554,0.459292588292723,0.459292588292723,
     + 0.459292588292723,0.081414823414554,0.459292588292723/
      DATA L(1,30),L(2,30),L(3,30),L(1,31),L(2,31),L(3,31),
     + L(1,32),L(2,32),L(3,32),L(1,33),L(2,33),L(3,33),L(1,34),L(2,34),
     + L(3,34),L(1,35),L(2,35),L(3,35),L(1,36),L(2,36),L(3,36),
     + L(1,37),L(2,37),L(3,37)/
     + 0.459292588292723,0.459292588292723,0.081414823414554,
     + 0.008394777409958,0.728492392955404,0.263112829634638,
     + 0.008394777409958,0.263112829634638,0.728492392955404,
     + 0.263112829634638,0.008394777409958,0.728492392955404,
     + 0.728492392955404,0.008394777409958,0.263112829634638,
     + 0.728492392955404,0.263112829634638,0.008394777409958,
     + 0.263112829634638,0.728492392955404,0.008394777409958,
     + 0.333333333333333,0.333333333333333,0.333333333333333/
C-----------------------------------------------------------------------
C     LOCAL COORDINATES - LINEAR STRAIN BRICK - ELEMENT TYPE 8,9
C-----------------------------------------------------------------------
      DATA L(1,38),L(2,38),L(3,38),L(1,39),L(2,39),L(3,39),L(1,40),
     + L(2,40),L(3,40),L(1,41),L(2,41),L(3,41),L(1,42),L(2,42),L(3,42),
     + L(1,43),L(2,43),L(3,43),L(1,44),L(2,44),L(3,44),L(1,45),L(2,45),
     + L(3,45)/
     + -0.774596669241483,-0.774596669241483, 0.774596669241483,
     +  0.774596669241483,-0.774596669241483, 0.774596669241483,
     +  0.774596669241483, 0.774596669241483, 0.774596669241483,
     + -0.774596669241483, 0.774596669241483, 0.774596669241483,
     + -0.774596669241483,-0.774596669241483,-0.774596669241483,
     +  0.774596669241483,-0.774596669241483,-0.774596669241483,
     +  0.774596669241483, 0.774596669241483,-0.774596669241483,
     + -0.774596669241483, 0.774596669241483,-0.774596669241483/
      DATA L(1,46),L(2,46),L(3,46),L(1,47),L(2,47),L(3,47),L(1,48),
     + L(2,48),L(3,48),L(1,49),L(2,49),L(3,49),L(1,50),L(2,50),L(3,50),
     + L(1,51),L(2,51),L(3,51),L(1,52),L(2,52),L(3,52),L(1,53),L(2,53),
     + L(3,53)/
     +  0.,-0.774596669241483, 0.774596669241483,
     +  0.774596669241483, 0., 0.774596669241483,
     +  0., 0.774596669241483, 0.774596669241483,
     + -0.774596669241483, 0., 0.774596669241483,
     +  0.,-0.774596669241483,-0.774596669241483,
     +  0.774596669241483, 0.,-0.774596669241483,
     +  0., 0.774596669241483,-0.774596669241483,
     + -0.774596669241483, 0.,-0.774596669241483/
      DATA L(1,54),L(2,54),L(3,54),L(1,55),L(2,55),L(3,55),L(1,56),
     + L(2,56),L(3,56),L(1,57),L(2,57),L(3,57),L(1,58),L(2,58),L(3,58),
     + L(1,59),L(2,59),L(3,59),L(1,60),L(2,60),L(3,60),L(1,61),L(2,61),
     + L(3,61),L(1,62),L(2,62),L(3,62),L(1,63),L(2,63),L(3,63),L(1,64),
     + L(2,64),L(3,64)/
     + -0.774596669241483,-0.774596669241483, 0.,
     +  0.774596669241483,-0.774596669241483, 0.,
     +  0.774596669241483, 0.774596669241483, 0.,
     + -0.774596669241483, 0.774596669241483, 0.,
     +  0., 0., 0.774596669241483, 0., 0.,-0.774596669241483,
     +  0.,-0.774596669241483, 0., 0.774596669241483, 0., 0.,
     +  0., 0.774596669241483, 0.,-0.774596669241483, 0., 0.,
     +  0., 0., 0./
C-----------------------------------------------------------------------
C     LOCAL COORDS - 2 X 2 (REDUCED INTEGRATION) FOR ELEMENT TYPES 4, 5
C-----------------------------------------------------------------------
      DATA L(1,65),L(2,65),L(1,66),L(2,66),L(1,67),L(2,67),L(1,68),
     + L(2,68)/
     + -0.5773502691896260,-0.5773502691896260,
     +  0.5773502691896260,-0.5773502691896260,
     +  0.5773502691896260, 0.5773502691896260,
     + -0.5773502691896260, 0.5773502691896260/
C-----------------------------------------------------------------------
C     WEIGHTS - LINEAR STRAIN TRIANGLE - ELEMENT TYPE 2,3
C-----------------------------------------------------------------------
      DATA W(6),W(7),W(8),W(9),W(10),W(11),W(12)/
     + .062969590272413570,.062969590272413570,.062969590272413570,
     + .066197076394253089,.066197076394253089,.066197076394253089,
     + .112499999999999996/
C-----------------------------------------------------------------------
C     WEIGHTS - LINEAR STRAIN QUADRILATERAL - ELEMENT TYPE 4,5
C-----------------------------------------------------------------------
      DATA W(13),W(14),W(15),W(16),W(17),W(18),W(19),W(20),W(21)/
     + 0.30864197530864,0.30864197530864,
     + 0.30864197530864,0.30864197530864,
     + 0.49382716049383,0.49382716049383,
     + 0.49382716049383,0.49382716049383,0.79012345679012/
C-----------------------------------------------------------------------
C     WEIGHTS - CUBIC STRAIN TRIANGLE - ELEMENT TYPE 6,7
C-----------------------------------------------------------------------
      DATA W(22),W(23),W(24),W(25),W(26),W(27),W(28),W(29),
     + W(30),W(31),W(32),W(33),W(34),W(35),W(36),W(37)/
     + .016229248811599,.016229248811599,.016229248811599,
     + .051608685267359,.051608685267359,.051608685267359,
     + .047545817133642,.047545817133642,.047545817133642,
     + .013615157087217,.013615157087217,.013615157087217,
     + .013615157087217,.013615157087217,.013615157087217,
     + .072157803838893/
C-----------------------------------------------------------------------
C     WEIGHTS - LINEAR STRAIN BRICK - ELEMENT TYPE 8,9
C-----------------------------------------------------------------------
      DATA W(38),W(39),W(40),W(41),W(42),W(43),W(44),W(45),W(46),
     + W(47),W(48),W(49),W(50),W(51),W(52),W(53),W(54),W(55),
     + W(56),W(57),W(58),W(59),W(60),W(61),W(62),W(63),W(64)/
     + 0.1714677885890182,0.1714677885890182,0.1714677885890182,
     + 0.1714677885890182,0.1714677885890182,0.1714677885890182,
     + 0.1714677885890182,0.1714677885890182,
     + 0.2743484507045309,0.2743484507045309,0.2743484507045309,
     + 0.2743484507045309,0.2743484507045309,0.2743484507045309,
     + 0.2743484507045309,0.2743484507045309,0.2743484507045309,
     + 0.2743484507045309,0.2743484507045309,0.2743484507045309,
     + 0.4389575034666130,0.4389575034666130,0.4389575034666130,
     + 0.4389575034666130,0.4389575034666130,0.4389575034666130,
     + 0.7023319772895636/
C-----------------------------------------------------------------------
C     2 X 2 (REDUCED INTEGRATION) FOR ELEMENT TYPES 4, 5
C-----------------------------------------------------------------------
      DATA W(65),W(66),W(67),W(68)/
     + 1.0,1.0,1.0,1.0/
C-----------------------------------------------------------------------
C     ONE-DIMENSIONAL INTEGRATION
C-----------------------------------------------------------------------
      DATA POSSP(1),POSSP(2),POSSP(3),POSSP(4),POSSP(5)/
     + -0.906179845938664,-0.538469310105683,0.0,
     + 0.538469310105683,0.906179845938664/
      DATA WEIGP(1),WEIGP(2),WEIGP(3),WEIGP(4),WEIGP(5)/
     + 0.236926885056189,0.478628670499366,0.568888888888889,
     + 0.478628670499366,0.236926885056189/
      END
      SUBROUTINE CAMCDE(IW6)
C***********************************************************************
C     OUTPUT CODE TO IDENTIFY STRESS STATE FOR CAM CLAYS
C***********************************************************************
C
      WRITE(IW6,901)
      WRITE(IW6,902)
      WRITE(IW6,903)
      WRITE(IW6,904)
  901 FORMAT(1X//120(1H=)/
     + /30X,40HCODE FOR STRESS STATE FOR CAM-CLAYS ONLY/30X,
     + 40(1H-)//30X,34HCODE GIVES THE STRESS STATE OF THE/
     + 30X,39HINTEGRATION POINT WITH REFERENCE TO THE/
     + 30X,20HCURRENT YIELD LOCUS.
     + //30X,47H        STRESS   STATE                     CODE)
  902 FORMAT(30X,46HSOIL IS ELASTIC   WITH P>PCS AND Q<M*P    -  0/
     + 30X,46HSOIL IS ELASTIC   WITH P<PCS AND Q<M*P    -  1/
     + 30X,46HSOIL IS ELASTIC   WITH P<PCS AND Q>M*P    -  2/
     + 30X,46HSOIL IS HARDENING WITH P>PCS AND Q<M*P    -  3)
  903 FORMAT(30X,46HSOIL IS SOFTENING WITH P<PCS AND Q>M*P    -  4/
     + 30X,46HSOIL IS SOFTENING WITH P<PCS AND Q>M*P    -  5/
     + 30X,46HSOIL IS YIELDING  WITH P<PCS AND Q>M*P    -  6/
     + 30X,46HSOIL IS HARDENING WITH P>PCS AND Q>M*P    -  7)
  904 FORMAT(30X,46HSOIL IS HARDENING WITH P<PCS AND Q>M*P    -  8/
     + 30X,46HSOIL HAS NEGATIVE P                       -  9/
     + /30X,40HWHERE   P - EFFECTIVE MEAN NORMAL STRESS
     + /30X,29H        Q - DEVIATORIC STRESS
     + /30X,37H      PCS - CRITICAL STATE VALUE OF P
     + /30X,35H            FOR CURRENT YIELD LOCUS
     + /30X,50H      CODES 5 AND 6 ARE ONLY APPLICABLE TO MODEL 6
     + /30X,46HTYPES 7 AND 8 ARE IMPERMISSIBLE AND ARISE FROM/
     + 30X,18HNUMERICAL PROBLEMS/)
      RETURN
      END
      SUBROUTINE CCSTRS(IST,PY,PCO,ICS,KGO,ICCSM)
C
C***********************************************************************
C
C      COUNT THE NUMBER OF INTEGRATION POINTS WITH DIFFERENT CODES
C      FOR CAM CLAYS ONLY
C
C***********************************************************************
C
      DIMENSION ICCSM(20)
C
C--------CALCULATE YIELD RATIO
      YR=PY/PCO
C--------APPROACHING CRITICAL STATE
      IF(ICS.EQ.1) THEN
         ICCSM(1)=ICCSM(1)+1
      ENDIF
C--------ELASTIC
      IF(IST.EQ.0.OR.IST.EQ.1.OR.IST.EQ.2) THEN
         ICCSM(2)=ICCSM(2)+1
C--------HARDENING
      ELSE IF(IST.EQ.3) THEN
         IF(YR.GE.1.5) THEN
            ICCSM(7)=ICCSM(7)+1
         ELSE IF(YR.GT.1.2.AND.YR.LT.1.5) THEN
            ICCSM(6)=ICCSM(6)+1
         ELSE IF(YR.GT.1.1.AND.YR.LT.1.2) THEN
            ICCSM(5)=ICCSM(5)+1
         ELSE IF(YR.GT.1.05.AND.YR.LT.1.1) THEN
            ICCSM(4)=ICCSM(4)+1
         ELSE
            ICCSM(3)=ICCSM(3)+1
         ENDIF
C--------SOFTENING
      ELSE IF(IST.EQ.4.OR.IST.EQ.5) THEN
         IF(YR.LE.0.90) THEN
            ICCSM(10)=ICCSM(10)+1
         ELSE IF(YR.GT.0.90.AND.YR.LT.0.95) THEN
            ICCSM(9)=ICCSM(9)+1
         ELSE IF(YR.GT.0.95) THEN
            ICCSM(8)=ICCSM(8)+1
         ENDIF
C--------YIELDING ON TENSION CUT-OFF
      ELSE IF(IST.EQ.6) THEN
         ICCSM(11)=ICCSM(11)+1
C--------HARDENING ABOVE CRITICAL STATE LINE
      ELSE IF(IST.EQ.7) THEN
         IF(YR.GT.1.1) THEN
            ICCSM(14)=ICCSM(14)+1
         ELSE IF(YR.GT.1.05.AND.YR.LT.1.1) THEN
            ICCSM(13)=ICCSM(13)+1
         ELSE
            ICCSM(12)=ICCSM(12)+1
         ENDIF
C--------HARDENING ON THE DRY SIDE
      ELSE IF(IST.EQ.8) THEN
         IF(YR.GE.1.5) THEN
            ICCSM(19)=ICCSM(19)+1
         ELSE IF(YR.GT.1.2.AND.YR.LT.1.5) THEN
            ICCSM(18)=ICCSM(18)+1
         ELSE IF(YR.GT.1.1.AND.YR.LT.1.2) THEN
            ICCSM(17)=ICCSM(17)+1
         ELSE IF(YR.GT.1.05.AND.YR.LT.1.1) THEN
            ICCSM(16)=ICCSM(16)+1
         ELSE
            ICCSM(15)=ICCSM(15)+1
         ENDIF
C--------NEGATIVE EFFECTIVE P
      ELSE IF(IST.EQ.9) THEN
         ICCSM(20)=ICCSM(20)+1
      ENDIF
      RETURN
      END
      SUBROUTINE CHANGE(IW6,IN,NCH,NN,MXDF,NTPE,NIP,NEL,MUMAX,
     + NDF,NDIM,NVRS,NDMX,NL,NB,NS,NPR,NMT,NPT,NPL,NNZ,XYZ,PI,
     + PEXIB,VARINT,MREL,NREL,B,ELCOD,DS,SHFN,F,CARTD,LL,PR,PRES,
     + NCORR,KGVN,NQ,JEL,LTYP,MAT,NP1,NP2,NSP,TGRAV)
C***********************************************************************
C     REMOVES/ADDS  ELEMENTS  FROM/TO  GEOMETRY  MESH  AND  CALCULATES
C     IMPLIED  LOADS
C***********************************************************************
      REAL LL
      DIMENSION XYZ(NDIM,NN),PI(NDF),VARINT(NVRS,NIP,NEL),PR(NPR,NMT),
     + PEXIB(NDF),PRES(NDIM,NPT),NREL(NNZ),NP1(NPL),NP2(NPL)
      DIMENSION NCORR(NTPE,NEL),KGVN(MXDF,NN),NQ(NN),JEL(NEL),LTYP(NEL),
     + MAT(NEL)
      DIMENSION MREL(MUMAX),SHFN(NDMX),DS(NDIM,NDMX),F(NDIM,NDMX),
     + CARTD(NDIM,NDMX),ELCOD(NDIM,NDMX),B(NS,NB),LL(NL)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /LOADS / FB(2,15)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
C-----------------------------------------------------------------------
C     ISTGE, KSTGE - CODES TO INDICATE STAGE OF THE ANALYSIS
C-----------------------------------------------------------------------
      ISTGE=2
      KSTGE=2
C-----------------------------------------------------------------------
C     LOOP  ON  ALL  ELEMENTS  WHICH  APPEAR IN THE LIST OF CHANGES
C-----------------------------------------------------------------------
      DO 150 J=1,NCH
      JK=JEL(J)
      JJ=MREL(JK)
C-----------------------------------------------------------------------
C     EXCLUDED (REMOVED)  ELEMENTS  HAVE  ELEMENT  TYPE  NEGATED
C-----------------------------------------------------------------------
      LTYP(JJ)=-LTYP(JJ)
      LT=LTYP(JJ)
      IJ=ISIGN(1,LT)
C-----------------------------------------------------------------------
C     BY-PASS  FOR  PRIMARY  MESH  CHANGE  ONLY
C-----------------------------------------------------------------------
      IF(IN.EQ.0) GOTO 150
      LT=IABS(LT)
      INDX=LINFO(12,LT)
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      NAC=LINFO(15,LT)
      KM=MAT(JJ)
      DENS=PR(8,KM)*TGRAV
      IF(IJ.GT.0) GOTO 125
C-----------------------------------------------------------------------
C     CALCULATE  BOUNDARY  FORCES (IN ROUTINE EQLIB) AND SELF-WEIGHT
C     FORCES (IN ROUTINE SELF) FOR  REMOVED  ELEMENTS
C-----------------------------------------------------------------------
      CALL EQLIB(IW6,JJ,JK,KM,LT,NGP,NIP,INDX,NTPE,NEL,NDIM,NN,NDMX,NDN,
     +           NS,NB,NAC,NVRS,NPR,NMT,VARINT,NCORR,XYZ,B,ELCOD,CARTD,
     +           SHFN,DS,F,LL,PR,ISTGE)
      DO 10 I=1,NDN
      NCOR=NCORR(I,JJ)
      II=IABS(NCOR)
      IF(KGVN(1,II).EQ.0)GOTO 10
      N1=KGVN(1,II)-1
      DO 7 ID=1,NDIM
      PEXIB(N1+ID)=PI(N1+ID)+F(ID,I)
    7 PI(N1+ID)=PI(N1+ID)+F(ID,I)
   10 CONTINUE
      DENS=PR(8,KM)*TGRAV
      IF(LT.EQ.13) THEN
         CALL SELF2(IW6,JJ,NN,NEL,NTPE,NDN,NDIM,NPR,NMT,XYZ,PR,
     +              ELCOD,SHFN,F,NCORR,MAT,LT,INDX,DENS,JK,KSTGE)
      ELSE
         CALL SELF(IW6,JJ,NN,NEL,NTPE,NDN,NDIM,NL,NPR,NMT,XYZ,PR,
     +             ELCOD,SHFN,DS,F,NCORR,MAT,LL,LT,INDX,DENS,JK,KSTGE)
      ENDIF
C
      DO 20 KK=1,NDN
      NCOR=NCORR(KK,JJ)
      NCOR=IABS(NCOR)
      IF(KGVN(1,NCOR).EQ.0)GOTO 20
      KKK=KGVN(1,NCOR)-1
      DO 15 ID=1,NDIM
      PEXIB(KKK+ID)=PEXIB(KKK+ID)-F(ID,KK)
   15 PI(KKK+ID)=PI(KKK+ID)-F(ID,KK)
   20 CONTINUE
C-----------------------------------------------------------------------
C     CALCULATE FORCES EQUAL TO BOUNDARY STRESSES FOR REMOVED ELEMENTS
C-----------------------------------------------------------------------
      DO 80 KE=1,NLED
      LNE=LEDG(KE)
      IF(LNE.NE.JK)GOTO 80
      ND1=NDE1(KE)
      ND2=NDE2(KE)
C
      IC=0
      DO 60 KV=1,NPT
      DO 60 ID=1,NDIM
      IC=IC+1
   60 PRES(ID,KV)=PRESLD(IC,KE)
      CALL ZEROR2(FB,2,15)
C
      CALL DISTLD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,NPL,
     +   PI,XYZ,NP1,NP2,KGVN,NCORR,LTYP,MREL,NREL,LNE,ND1,ND2,PRES,NPT,
     +   NSP,0,0,-1.)
C
C--------ZERO ENTRIES FOR PRESSURE APPLIED TO
C--------REMOVED ELEMENTS
      LEDG(KE)=0
      NDE1(KE)=0
      NDE2(KE)=0
C
      DO 75 KK=1,NDN
      NCOR=NCORR(KK,JJ)
      NCOR=IABS(NCOR)
      IF(KGVN(1,NCOR).EQ.0)GOTO 75
      KKK=KGVN(1,NCOR)-1
      DO 70 ID=1,NDIM
   70 PEXIB(KKK+ID)=PEXIB(KKK+ID)-FB(ID,KK)
   75 CONTINUE
   80 CONTINUE
      GOTO 150
C-----------------------------------------------------------------------
C     CALCULATE  SELF-WEIGHT  FORCES  FOR  ADDED  ELEMENTS
C-----------------------------------------------------------------------
  125 CONTINUE
      IF(LT.EQ.13) THEN
         CALL SELF2(IW6,JJ,NN,NEL,NTPE,NDN,NDIM,NPR,NMT,XYZ,PR,
     +              ELCOD,SHFN,F,NCORR,MAT,LT,INDX,DENS,JK,KSTGE)
      ELSE
         CALL SELF(IW6,JJ,NN,NEL,NTPE,NDN,NDIM,NL,NPR,NMT,XYZ,PR,
     +             ELCOD,SHFN,DS,F,NCORR,MAT,LL,LT,INDX,DENS,JK,KSTGE)
      ENDIF
C
      DO 145 KK=1,NDN
      NCOR=NCORR(KK,JJ)
      IF(KGVN(1,NCOR).EQ.0)GOTO 145
      KKK=KGVN(1,NCOR)-1
      DO 140 ID=1,NDIM
  140 PI(KKK+ID)=PI(KKK+ID)+F(ID,KK)
  145 CONTINUE
  150 CONTINUE
      RETURN
      END
      SUBROUTINE CUVFIT(BMF,DM,BFAC,BL)
C
C***********************************************************************
C     CALCULATE BENDING MOMENT IN BEAM ELEMENT USING CURVE FITTING.
C***********************************************************************
C
      DIMENSION EE(5),BMF(5),DM(9),EX(11),AX3(11,6)
C
C *** INITIALIZE MATRICE
      DO 5 I=1,5
      BMF(I)=0.
    5 CONTINUE
      EE(1)=-.5
      EE(2)=-.25
      EE(3)=0.
      EE(4)=.25
      EE(5)=.5
C
C *** LEAST SQUARE FIT FOR BEND. MOMENT
C
      DO 10 I=1,11
   10 EX(I)=0.
C
      DO 20 J=1,6
      DO 20 I=1,11
   20 AX3(I,J)=0.
C
      P1=0.
      P2=0.
      P3=0.
      P4=0.
      P5=0.
      P6=0.
C
      EX(1)=-.5
      DX=.1
C
      DO 25 I=1,10
   25 EX(I+1)=EX(I)+DX
C
      DO 26 I=1,11
      XR=EX(I)
      AX3(I,1)=8.-60.*XR-96.*XR*XR+480.*XR*XR*XR
      AX3(I,2)=8.+60.*XR-96.*XR*XR-480.*XR*XR*XR
      AX3(I,3)=-16.+192.*XR*XR
      AX3(I,4)=1.-6.*XR-24.*XR*XR+80.*XR*XR*XR
      AX3(I,5)=-1.-6.*XR+24.*XR*XR+80.*XR*XR*XR
      AX3(I,6)=-48.*XR+320.*XR*XR*XR
C
      BM1=DM(2)*AX3(I,1)+DM(5)*AX3(I,2)+DM(8)*AX3(I,3)
      BM2=DM(3)*AX3(I,4)+DM(6)*AX3(I,5)+DM(9)*AX3(I,6)
      BM=-BFAC*(BM1+BM2*BL)
      YR=BM
      P1=P1+1.
      P2=P2+XR
      P4=P4+XR*XR
      P5=P5+YR
      P6=P6+XR*YR
   26 CONTINUE
C
      P3=P2
      AJAC=P1*P4-P2*P3
      C0=(P5*P4-P2*P6)/AJAC
      C1=(P1*P6-P3*P5)/AJAC
C
      DO 80 I=1,5
      BM=C0+C1*EE(I)
C
      BMF(I)=BM
   80 CONTINUE
C
      RETURN
      END
      SUBROUTINE DCAM(IP,I,MUS,IET,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     + VARINT,MAT,D,PR,ITP,IPLSTK)
C***********************************************************************
C     CALCULATES  STRESS-STRAIN  MATRIX  FOR  CAM-CLAY
C***********************************************************************
      DIMENSION VARINT(NVRS,NIP,NEL),D(NS,NS),MAT(NEL)
      DIMENSION S(6),A(6),B(6),PR(NPR,NMT)
      COMMON /DIN/ DEL(3),DEP(21)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      KM=MAT(I)
      SX=VARINT(1,IP,I)
      SY=VARINT(2,IP,I)
      SZ=VARINT(3,IP,I)
      TXY=VARINT(4,IP,I)
      E=VARINT(NS+2,IP,I)
      PC=ABS(VARINT(NS+3,IP,I))
      P=(SX+SY+SZ)/3.
      Q2=SX*(SX-SY)+SY*(SY-SZ)+SZ*(SZ-SX)+3.*TXY*TXY
      IF(NDIM.EQ.2)GOTO 10
C
      TYZ=VARINT(5,IP,I)
      TZX=VARINT(6,IP,I)
      Q2=Q2+3.*TYZ*TYZ+3.*TZX*TZX
   10 Q=SQRT(Q2)
      IF(P.LT.0.) THEN
         WRITE(IW6,900)MUS,IP,P,KM
  900    FORMAT(1X,' *** ELEMENT ',I5,4X,'INT. PT',I5,4X,
     +             'PE IS NEGATIVE',E16.5,4X,'MAT ZONE NUMBER',I5/
     +             1X,'(ROUTINE DCAM)')
         WRITE(IW15,900)MUS,IP,P,KM
         WRITE(IWS,900)MUS,IP,P,KM
         P=1.
         IF(P.GT.0.1*PC)P=0.1*PC
      ENDIF
      PY=P*EXP(Q/(PR(4,KM)*P))
      BK=(1.+E)*P/PR(1,KM)
C-----------------------------------------------------------------------
C     CALCULATE  ELASTIC  STRESS-STRAIN  MATRIX
C-----------------------------------------------------------------------
      G=PR(5,KM)
      IF(G.LT.1.) G=BK*1.5*(1.-2.*PR(5,KM))/(1.+PR(5,KM))
      AL=(3.*BK+4.*G)/3.
      DL=(3.*BK-2.*G)/3.
C
      CALL ZEROR2(D,NS,NS)
      D(1,1)=AL
      D(2,1)=DL
      D(3,1)=DL
      D(1,2)=DL
      D(2,2)=AL
      D(3,2)=DL
      D(1,3)=DL
      D(2,3)=DL
      D(3,3)=AL
      D(4,4)=G
      IF(NDIM.EQ.2)GOTO 11
      D(5,5)=G
      D(6,6)=G
C
   11 CONTINUE
      IPLSTK=0
      IF(PY.LT.0.99*PC) GO TO 50
C-----------------------------------------------------------------------
C     CALCULATE  PLASTIC  STRESS-STRAIN  MATRIX  IF  CURRENT
C     POINT  ON  YIELD  LOCUS  AND  SET  PC  NEGATIVE
C-----------------------------------------------------------------------
      IPLSTK=1
      VARINT(NS+3,IP,I)=-ABS(VARINT(NS+3,IP,I))
      S(1)=SX-P
      S(2)=SY-P
      S(3)=SZ-P
      S(4)=2.*TXY
      IF(NDIM.EQ.2)GOTO 12
      S(5)=2.*TYZ
      S(6)=2.*TZX
   12 BB=(1.-Q/(PR(4,KM)*P))/(3.*P)
      ITP=0
      IF(Q.LT.1.0E-5) GOTO 15
      QMP=Q/(PR(4,KM)*P)
      IF(QMP.LT.0.01) GOTO 14
      C=1.5/(Q*PR(4,KM)*P)
      GOTO 16
C-----------------------------------------------------------------------
C     Q/MP IS SMALL.USE FITTED CURVE TO CALCULATE C VALUE
C-----------------------------------------------------------------------
   14 CA=153.0302/(PR(4,KM)**2*PC**2)
      C=(-2.98*(100.*QMP)**3+3.98*(100.*QMP)**2)*CA
      ITP=1
      GOTO 16
C-----------------------------------------------------------------------
C     Q/MP IS TOO SMALL.USE C VALUE FOR ZERO Q/MP
C-----------------------------------------------------------------------
   15 C=0.
      ITP=1
   16 A(1)=BB+C*S(1)
      A(2)=BB+C*S(2)
      A(3)=BB+C*S(3)
      A(4)=C*S(4)
      IF(NDIM.EQ.2)GOTO 18
      A(5)=C*S(5)
      A(6)=C*S(6)
C
   18 DO 20 J=1,3
      B(J)=0.
      DO 20 JJ=1,3
   20 B(J)=B(J)+D(J,JJ)*A(JJ)
      B(4)=D(4,4)*A(4)
      IF(NDIM.EQ.2)GOTO 25
      B(5)=D(5,5)*A(5)
      B(6)=D(6,6)*A(6)
C
   25 XI=(PR(2,KM)-PR(1,KM))/(1.+E)
      AA=3.*BB/XI
      AB=0.
C
      DO 30 J=1,NS
   30 AB=AB+A(J)*B(J)
      BETA=AA+AB
      DO 40 J=1,NS
      DO 40 JJ=1,NS
   40 D(JJ,J)=D(JJ,J)-B(JJ)*B(J)/BETA
   50 IF(IET.EQ.0) GOTO 80
C
      DO 60 J=1,3
      DO 60 JJ=1,3
   60 D(JJ,J)=D(JJ,J)+PR(7,KM)
   80 CONTINUE
C
      DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
C
      IS=0
      DO 90 J1=1,NS
      DO 90 I1=1,J1
      IS=IS+1
   90 DEP(IS)=D(I1,J1)
      RETURN
      END
      SUBROUTINE DCON(I,MUS,IET,NEL,NDIM,NS,NPR,NMT,MAT,PR,D,IPLSTK)
C***********************************************************************
C     CALCULATES STRESS-STRAIN MATRIX FOR ANISOTROPIC ELASTICITY
C***********************************************************************
      DIMENSION MAT(NEL),D(NS,NS),PR(NPR,NMT)
      COMMON /DIN/ DEL(3),DEP(21)
C
      KM=MAT(I)
      AN=PR(1,KM)/PR(2,KM)
      A=PR(2,KM)/((1.0+PR(3,KM))*(1.0-PR(3,KM)-2.0*AN*PR(4,KM)*
     + PR(4,KM)))
C
      CALL ZEROR2(D,NS,NS)
      D(1,1)=A*AN*(1.0-AN*PR(4,KM)*PR(4,KM))
      D(1,2)=A*AN*PR(4,KM)*(1.0+PR(3,KM))
      D(1,3)=A*AN*(PR(3,KM)+AN*PR(4,KM)*PR(4,KM))
      D(2,1)=D(1,2)
      D(2,2)=A*(1.0-PR(3,KM)*PR(3,KM))
      D(2,3)=D(1,2)
      D(3,1)=D(1,3)
      D(3,2)=D(2,3)
      D(3,3)=D(1,1)
      D(4,4)=PR(5,KM)
      IF(NDIM.EQ.2)GOTO 5
      D(5,5)=PR(5,KM)
      D(6,6)=PR(5,KM)
    5 IF(IET.EQ.0) GO TO 20
      DO 10 J=1,3
      DO 10 JJ=1,3
   10 D(JJ,J)=D(JJ,J)+PR(7,KM)
C
   20 CONTINUE
      IPLSTK=INT(PR(6,KM))
C
      DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
C
      IS=0
      DO 40 J1=1,NS
      DO 40 I1=1,J1
      IS=IS+1
   40 DEP(IS)=D(I1,J1)
      RETURN
      END
      SUBROUTINE DELP(IP,I,MUS,IET,NEL,NIP,NVRS,NDIM,NDN,NS,NPR,NMT,
     + ELCOD,SHFN,VARINT,MAT,D,PR,NMOD,IELST,IPLSTK)
C***********************************************************************
C     CALCULATE STRESS - STRAIN MATRIX FOR ELASTIC
C     PERFECTLY PLASTIC MODEL - 5
C     WITH ELASTIC MODULUS VARYING LINERALY WITH DEPTH.
C***********************************************************************
      DIMENSION MAT(NEL),NMOD(NIP,NEL),VARINT(NVRS,NIP,NEL)
      DIMENSION A(6),B(6),ESN(6)
      DIMENSION D(NS,NS),PR(NPR,NMT),ELCOD(NDIM,NDN),SHFN(NDN)
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C-----------------------------------------------------------------------
C     CALCULATE ELASTIC D MATRIX
C-----------------------------------------------------------------------
      CALL ZEROR2(D,NS,NS)
C
      JMODE=NMOD(IP,I)
      KM=MAT(I)
      KT=IFIX(PR(6,KM))
      YY=ZERO
      DO 5 IN=1,NDN
    5 YY=YY+SHFN(IN)*ELCOD(2,IN)
C
      E=PR(1,KM)+PR(11,KM)*(PR(5,KM)-YY)
      IF(E.LT.ZERO) THEN
         WRITE(IW6,900)E,MUS,IP,KM
  900    FORMAT(/1X,' *** ERROR - YOUNGS MODULUS IS NEGATIVE',E16.4,
     +           4X,'IN ELEMENT',I5,4X,'AT INT. POINT',I5/
     +           1X,'FOR MAT ZONE NUMBER',I5,4X,'(ROUTINE DELP)')
         WRITE(IW15,900)E,MUS,IP,KM
         WRITE(IWS,900)E,MUS,IP,KM
         STOP
      ENDIF
C
      POIS=PR(2,KM)
      COH=PR(3,KM)+PR(12,KM)*(PR(5,KM)-YY)
      PHI=PR(4,KM)
      AMULT=E*(1.-POIS)/((1.+POIS)*(1.-2.*POIS))
C
      D(1,1)=AMULT
      D(1,2)=AMULT*POIS/(1.-POIS)
      D(2,2)=AMULT
      D(1,3)=D(1,2)
      D(2,3)=D(1,2)
      D(3,3)=AMULT
      G=E/(2.*(1.+POIS))
      D(4,4)=G
      IF(NDIM.EQ.2)GOTO 12
      D(5,5)=G
      D(6,6)=G
C
   12 DO 20 IK=2,4
      IK1=IK-1
      DO 20 JK=1,IK1
   20 D(IK,JK)=D(JK,IK)
C
      IPLSTK=0
      IF(IELST.EQ.1.OR.JMODE.EQ.0) GO TO 80
      IPLSTK=1
C-----------------------------------------------------------------------
C     CALCULATE PLASTIC D MATRIX
C-----------------------------------------------------------------------
      SIGM=VARINT(1,IP,I)+VARINT(2,IP,I)+VARINT(3,IP,I)
      SIGP=SIGM/3.
      ESN(1)=VARINT(1,IP,I)-SIGP
      ESN(2)=VARINT(2,IP,I)-SIGP
      ESN(3)=VARINT(3,IP,I)-SIGP
      ESN(4)=VARINT(4,IP,I)
      IF(NDIM.EQ.2)GOTO 25
      ESN(5)=VARINT(5,IP,I)
      ESN(6)=VARINT(6,IP,I)
C
   25 SBAR2=(ESN(1)*ESN(1)+ESN(2)*ESN(2)+ESN(3)*ESN(3))/2.
      SBAR2=SBAR2+ESN(4)*ESN(4)
      IF(NDIM.EQ.3)SBAR2=SBAR2+ESN(5)*ESN(5)+ESN(6)*ESN(6)
      IF(SBAR2.LT.ASMVL)SBAR2=ASMVL
      SBAR=SQRT(SBAR2)
      SIGJ3=ESN(1)*ESN(2)*ESN(3)-ESN(3)*ESN(4)*ESN(4)
      IF(NDIM.EQ.3)SIGJ3=SIGJ3-ESN(1)*ESN(5)*ESN(5)-
     + ESN(2)*ESN(6)*ESN(6)+2.0*ESN(4)*ESN(5)*ESN(6)
      SRT3=SQRT(3.)
      STH3=(-1.5*SRT3*SIGJ3/(SBAR2*SBAR))
      IF(STH3.GT.1.)STH3=1.
      IF(STH3.LT.(-1.))STH3=-1.
      TH=ASIN(STH3)/3.
C
      CALL ATRANS(A,SBAR,SIGM,TH,COH,PHI,KT,ESN,NDIM,NS)
C
      DO 40 J=1,NS
      B(J)=ZERO
      DO 40 JJ=1,NS
   40 B(J)=B(J)+D(J,JJ)*A(JJ)
      AB=ZERO
C
      DO 50 J=1,NS
   50 AB=AB+A(J)*B(J)
C
      DO 60 J=1,NS
      DO 60 JJ=1,NS
   60 D(JJ,J)=D(JJ,J)-B(JJ)*B(J)/AB
   80 IF(IET.EQ.0)GOTO 100
C
      DO 90 J=1,3
      DO 90 JJ=1,3
   90 D(JJ,J)=D(JJ,J)+PR(7,KM)
  100 CONTINUE
C
      DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
C
      IS=0
      DO 110 J1=1,NS
      DO 110 I1=1,J1
      IS=IS+1
  110 DEP(IS)=D(I1,J1)
      RETURN
      END
      SUBROUTINE DEPT(IP,I,NEL,MAT,A,DBAR,BBAR,VARI,NDIM,NDN,NS,
     +                PR,NPR,NMT,ELCOD,SHFN)
C
C***********************************************************************
C     CALCULATES STRESS - STRAIN MATRIX FOR ELASTIC
C     PERFECTLY PLASTIC MODEL - 5
C     WITH ELASTIC MODULUS VARYING LINERALY WITH DEPTH.
C***********************************************************************
C
      DIMENSION MAT(NEL),DBAR(NS),A(NS),PR(NPR,NMT),VARI(NS),
     +          ELCOD(NDIM,NDN),SHFN(NDN)
      DIMENSION DELC(3),ESN(6)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C
      KM=MAT(I)
      KT=IFIX(PR(6,KM))
      YY=ZERO
      DO 5 IN=1,NDN
    5 YY=YY+SHFN(IN)*ELCOD(2,IN)
C
      E=PR(1,KM)+PR(11,KM)*(PR(5,KM)-YY)
      PNU=PR(2,KM)
      COH=PR(3,KM)+PR(12,KM)*(PR(5,KM)-YY)
      PHI=PR(4,KM)
      G=E/(2.*(1.+PNU))
C-----------------------------------------------------------------------
C     CALCULATE THE TERMS WHICH MAKE UP ELASTIC D MATRIX
C-----------------------------------------------------------------------
      DENOM=(1.+PNU)*(1.-2.*PNU)
      DELC(1)=E*(1.-PNU)/DENOM
      DELC(2)=E*PNU/DENOM
      DELC(3)=G
C-----------------------------------------------------------------------
C     CALCULATE STRESS INVARIANTS
C-----------------------------------------------------------------------
      SIGM=VARI(1)+VARI(2)+VARI(3)
      SIGP=SIGM/3.
      ESN(1)=VARI(1)-SIGP
      ESN(2)=VARI(2)-SIGP
      ESN(3)=VARI(3)-SIGP
      ESN(4)=VARI(4)
      IF(NDIM.EQ.2)GOTO 10
      ESN(5)=VARI(5)
      ESN(6)=VARI(6)
C
   10 SBAR2=(ESN(1)*ESN(1)+ESN(2)*ESN(2)+ESN(3)*ESN(3))/2.
      SBAR2=SBAR2+ESN(4)*ESN(4)
      IF(NDIM.EQ.3)SBAR2=SBAR2+ESN(5)+ESN(5)+ESN(6)*ESN(6)
      IF(SBAR2.LT.ASMVL)SBAR2=ASMVL
      SBAR=SQRT(SBAR2)
      SIGJ3=ESN(1)*ESN(2)*ESN(3)-ESN(3)*ESN(4)*ESN(4)
      IF(NDIM.EQ.3)SIGJ3=SIGJ3-ESN(1)*ESN(5)*ESN(5)-
     + ESN(2)*ESN(6)*ESN(6)+2.0*ESN(4)*ESN(5)*ESN(6)
      SRT3=SQRT(3.)
      STH3=(-1.5*SRT3*SIGJ3/(SBAR2*SBAR))
      IF(STH3.GT.1.)STH3=1.
      IF(STH3.LT.(-1.))STH3=-1.
      TH=ASIN(STH3)/3.
C-----------------------------------------------------------------------
C     CALCULATE A
C-----------------------------------------------------------------------
      CALL ATRANS(A,SBAR,SIGM,TH,COH,PHI,KT,ESN,NDIM,NS)
C-----------------------------------------------------------------------
C     CALCULATE DBAR = D * A
C-----------------------------------------------------------------------
      DBAR(1)=DELC(1)*A(1)+DELC(2)*(A(2)+A(3))
      DBAR(2)=DELC(1)*A(2)+DELC(2)*(A(1)+A(3))
      DBAR(3)=DELC(1)*A(3)+DELC(2)*(A(1)+A(2))
      DBAR(4)=DELC(3)*A(4)
      IF(NDIM.EQ.2)GOTO 15
      DBAR(5)=DELC(3)*A(5)
      DBAR(6)=DELC(3)*A(6)
C-----------------------------------------------------------------------
C     CALCULATE BBAR = AT * DBAR  = AT * D * A
C-----------------------------------------------------------------------
   15 BBAR=A(1)*DBAR(1)+A(2)*DBAR(2)+A(3)*DBAR(3)+A(4)*DBAR(4)
      IF(NDIM.EQ.3)BBAR=BBAR+A(5)*DBAR(5)+A(6)*DBAR(6)
      RETURN
      END
      SUBROUTINE DETJCB(IW6,DJACB,NDN,NDIM,ELCOD,DS,LT,IP,MUS,KSTGE)
C***********************************************************************
C     CALCULATES DETERMINANT OF JACOBIAN MATRIX                        *
C***********************************************************************
      DIMENSION ELCOD(NDIM,NDN),DS(NDIM,NDN),XJAC(3,3),T(3,3)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      IF(LT.NE.1.AND.LT.NE.12.AND.LT.NE.13)GOTO 8
      MDN=NDN
      IF(LT.EQ.13)MDN=3
C
      CALL ROTAT(ELCOD,NDIM,MDN,DL,T)
      DJACB=ZERO
C
      DO 5 IN=1,MDN
    5 DJACB=DJACB+DS(1,IN)*ELCOD(1,IN)
      GOTO 50
C *** NXJ - SIZE OF ARRAY XJAC
    8 NXJ=3
      CALL ZEROR2(XJAC,NXJ,NXJ)
C
      DO 10 ID=1,NDIM
      DO 10 JD=1,NDIM
      DO 10 IN=1,NDN
   10 XJAC(ID,JD)=XJAC(ID,JD)+DS(ID,IN)*ELCOD(JD,IN)
C
      IF(NDIM.NE.2)GOTO 20
      DJACB=XJAC(1,1)*XJAC(2,2)-XJAC(1,2)*XJAC(2,1)
      GOTO 50
C
   20 DJACB=XJAC(1,1)*(XJAC(2,2)*XJAC(3,3)-XJAC(2,3)*XJAC(3,2))
      DJACB=DJACB-XJAC(1,2)*(XJAC(2,1)*XJAC(3,3)-XJAC(2,3)*XJAC(3,1))
      DJACB=DJACB+XJAC(1,3)*(XJAC(2,1)*XJAC(3,2)-XJAC(2,2)*XJAC(3,1))
C
   50 IF(DJACB.GT.ZERO)GO TO 60
      WRITE(IW6,900)DJACB,MUS,IP
  900 FORMAT(1H0,22H JACOBIAN IS NEGATIVE ,E16.5,3X,10HIN ELEMENT,I5,2X,
     + 13HAT INT. POINT,I5,2X,16H(ROUTINE DETJCB))
      WRITE(IW6,910)KSTGE
  910 FORMAT(/1X,36HCODE TO INDICATE STAGE OF ANALYSIS =,I5/
     + 4X,4HCODE,20X,21HSTAGE OF THE ANALYSIS//
     + 6X,45H1 - CALLED BY MSUB3/EQLOD/SELF CALCULATION OF,
     + 1X,25HIN SITU SELF WEIGHT LOADS/6X,13H2 - CALLED BY,
     + 1X,44HMSG/CHANGE/SELF LOADS DUE TO ELEMENT CHANGES/
     + 6X,44H3 - CALLED BY MSG/SEL1/SELF INCREMENTAL SELF,
     + 1X,12HWEIGHT LOADS/6X,25H4 - CALLED BY UPOUT/EQLOD,
     + 45H/SELF SELF WEIGHT LOADS FOR EQUILIBRIUM CHECK)
      WRITE(IW15,900)DJACB,MUS,IP
      WRITE(IW15,910)KSTGE
      WRITE(IWS,900)DJACB,MUS,IP
      WRITE(IWS,910)KSTGE
      STOP
CC60  WRITE(IW6,902)DJACB
CC902 FORMAT(9H JACOBIAN,2X,E16.5)
   60 RETURN
      END
      SUBROUTINE DETMIN(IW6,XJACM,XJACI,NDIM,DJACB,JL,IP,ISTGE)
C***********************************************************************
C     CALCULATES DETERMINANT AND INVERSE OF A SQUARE MATRIX
C     ROUTINE LAST MODIFIED ON 15/11/86
C***********************************************************************
      DIMENSION XJACM(3,3),XJACI(3,3)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      IF(NDIM.NE.2)GOTO 20
      DJACB=XJACM(1,1)*XJACM(2,2)-XJACM(1,2)*XJACM(2,1)
      IF(DJACB.GT.ZERO)GOTO 15
      GOTO 60
C
   15 XJACI(1,1)= XJACM(2,2)/DJACB
      XJACI(2,2)= XJACM(1,1)/DJACB
      XJACI(1,2)=-XJACM(1,2)/DJACB
      XJACI(2,1)=-XJACM(2,1)/DJACB
      RETURN
C
   20 DO 30 IR=1,NDIM
      KR1=IR+1
      KR2=IR+2
      IF(KR1.GT.NDIM)KR1=KR1-NDIM
      IF(KR2.GT.NDIM)KR2=KR2-NDIM
      DO 30 IC=1,NDIM
      KC1=IC+1
      KC2=IC+2
      IF(KC1.GT.NDIM)KC1=KC1-NDIM
      IF(KC2.GT.NDIM)KC2=KC2-NDIM
      VAL=AMULT(XJACM,NDIM,KR1,KR2,KC1,KC2)
   30 XJACI(IR,IC)=VAL
C
      DJACB=XJACM(1,1)*XJACI(1,1)+XJACM(1,2)*XJACI(1,2)+
     +      XJACM(1,3)*XJACI(1,3)
      IF(DJACB.GT.ZERO)GOTO 32
      GOTO 60
C
   32 DJACBI=1.0/DJACB
C
      DO 35 ID=1,NDIM
      DO 35 JD=1,NDIM
   35 XJACI(ID,JD)=XJACI(ID,JD)*DJACBI
      CALL TRNSPS(XJACI,NDIM)
      RETURN
   60 WRITE(IW6,900)DJACB,JL,IP
  900 FORMAT(/1X,21HJACOBIAN IS NEGATIVE ,E16.5,3X,10HOF ELEMENT,I6,3X,
     + 2HIP,I5,3X,16H(ROUTINE DETMIN))
      WRITE(IW6,910)ISTGE
  910 FORMAT(/1X,36HCODE TO INDICATE STAGE OF ANALYSIS =,I5//
     + 6X,48H1 - CALLED BY INSIT/EQLIB/FORMB2 LOAD EQUIVALENT,
     + 19H TO INSITU STRESSES/6X,33H2 - CALLED BY CHANGE/EQLIB/FORMB2,
     + 32H CALCULATION OF IMPLIED LOADINGS/6X,
     + 34H3 - CALLED BY FRONTZ/LSTIFF/FORMB2,
     + 32H CALCULATION OF STIFFNESS MATRIX/
     + 6X,38H4 - CALLED BY UPOUT/FORMB2 CALCULATION,1X,
     + 23HOF STRAINS OUTPUT STAGE)
      WRITE(IW15,900)DJACB,JL,IP
      WRITE(IWS,900)DJACB,JL,IP
      STOP
      END
      SUBROUTINE TRNSPS(XJACI,NDIM)
C***********************************************************************
C     ROUTINE TO TRANSPOSE A SQUARE MATRIX
C***********************************************************************
      DIMENSION XJACI(3,3),A(3,3)
C
      DO 10 ID=1,NDIM
      DO 10 JD=1,NDIM
   10 A(ID,JD)=XJACI(ID,JD)
C
      DO 20 ID=1,NDIM
      DO 20 JD=1,NDIM
      IF(ID.NE.JD)XJACI(ID,JD)=A(JD,ID)
   20 CONTINUE
      RETURN
      END
      SUBROUTINE DISTLD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,
     + NPL,RHS,XYZ,NP1,NP2,KGVN,NCORR,LTYP,MREL,NREL,LNE,ND1,ND2,
     + PRES,NPT,NSP,IPRINT,IST,FC)
C***********************************************************************
C     ROUTINE TO CALCULATE EQUIVALENT NODAL LOADS FOR SPECIFIED        *
C     PRESSURE LOADING ALONG ELEMENT EDGES USING 5 POINT (NSP)         *
C     INTEGRATION RULE. INTEGRATES POLYNOMIAL OF ORDER NINE OR LESS    *
C     EXACTLY. ARRAYS ILOC,PRES,PEQLD,ELCOD,SHF,DERIV ARE              *
C     TO CATER FOR A MAXIMUM OF FIVE NODES (NPT) ALONG AN ELEMENT EDGE *
C     (ALL TRIANGULAR ELEMENTS UPTO CUBIC STRAIN TRIANGLE)             *
C***********************************************************************
      DIMENSION KGVN(MXDF,NN),NCORR(NTPE,NEL),MREL(MUMAX),NP1(NPL),
     + NP2(NPL)
      DIMENSION RHS(NDF),XYZ(NDIM,NN),NREL(NNZ),LTYP(NEL)
      DIMENSION ILOC(5),PGASH(2),DGASH(2)
      DIMENSION PRES(NDIM,NPT),PEQLD(2,5),ELCD(2,5),PCOM(3)
      DIMENSION SHF(5),DERIV(5)
      COMMON /FLOW  / NPLAX
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /SAMP  / POSSP(5),WEIGP(5)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /LOADS / FB(2,15)
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      NP=5
      TPI=2.*PYI
      NE=MREL(LNE)
      LI1=NREL(ND1)
CC    LI2=NREL(ND2)
      LT=LTYP(NE)
      IF(IST.EQ.1)GOTO 5
      LT=IABS(LT)
    5 IF(LT.GT.0)GOTO 10
      WRITE(IW6,900)LNE
  900 FORMAT(/1X,'**** ERROR - YOU HAVE PUT A PRESSURE LOAD ON ELEMENT',
     +  I5/2X,'WHICH IS NOT PRESENT IN CURRENT MESH (ROUTINE DISTLD)')
      WRITE(IW15,900)LNE
      WRITE(IWS,900)LNE
      RETURN
   10 NV=LINFO(2,LT)
      NEDG=LINFO(3,LT)
      NMID=LINFO(7,LT)
      NSD=NMID+2
      INDED=LINFO(14,LT)
C
      DO 20 K1=1,NEDG
      J1=NP1(K1+INDED)
      J2=NP2(K1+INDED)
      I1=NCORR(J1,NE)
      IF(LI1.EQ.I1)GOTO 25
   20 CONTINUE
      WRITE(IW6,903)LNE,ND1,ND2
  903  FORMAT(/13H **** ERROR -,I5,
     + 2X,33H ELEMENT DOES NOT CONTAIN NODES -,2I5,
     + 3X,16H(ROUTINE DISTLD))
      WRITE(IW15,903)LNE,ND1,ND2
      WRITE(IWS,903)LNE,ND1,ND2
      RETURN
C-----------------------------------------------------------------------
C     STORE LOCATIONS OF NODE (IN NCORR) IN ARRAY ILOC
C-----------------------------------------------------------------------
   25 LC1=NV+(J1-1)*NMID
      ILOC(1)=J1
      ILOC(NSD)=J2
      IF(NMID.EQ.0)GOTO 31
      DO 30 JP=1,NMID
   30 ILOC(JP+1)=LC1+JP
C-----------------------------------------------------------------------
C     SET UP LOCAL ARRAY FOR CO-ORDINATES IN ELCD
C-----------------------------------------------------------------------
   31 DO 32 KC=1,NSD
      ILC=ILOC(KC)
      NDE=NCORR(ILC,NE)
      DO 32 ID=1,NDIM
   32 ELCD(ID,KC)=XYZ(ID,NDE)
CC    WRITE(IW6,904)ELCD
CC904 FORMAT(5H ELCD/1X,10E12.4)
C     INITIALISE PEQLD
      CALL ZEROR2(PEQLD,NDIM,NP)
C     LOOP FOR NUMERICAL INTEGRATION
      DO 60 ISP=1,NSP
      XI=POSSP(ISP)
C-----------------------------------------------------------------------
C     EVALUATE SHAPE FUNCTION AT SAMPLING POINT
C-----------------------------------------------------------------------
      CALL SFR1(XI,SHF,DERIV,NSD)
C     CALCULATE COMPONENTS OF THE EQUIVALENT NODAL LOADS - PEQLD
      DO 40 IDOF=1,NDIM
      PGASH(IDOF)=ZERO
      DGASH(IDOF)=ZERO
      DO 40 IEDG=1,NSD
      PGASH(IDOF)=PGASH(IDOF)+PRES(IDOF,IEDG)*SHF(IEDG)
   40 DGASH(IDOF)=DGASH(IDOF)+ELCD(IDOF,IEDG)*DERIV(IEDG)
CC    WRITE(14,810)PRES
CC810 FORMAT(/1X,4HPRES/(1X,6E14.4))
CC    WRITE(14,811)SHF
CC811 FORMAT(/1X,3HSHF/(1X,6E14.4))
CC    WRITE(IW6,801)ISP,PGASH,DGASH
CC801 FORMAT(/1X,6HISP = ,I5,3X,10F8.2)
C
      DV=WEIGP(ISP)
      IF(NPLAX.EQ.0)GOTO 48
      RAD=0.0
      DO 45 IEDG=1,NSD
   45 RAD=RAD+ELCD(1,IEDG)*SHF(IEDG)
      DV=DV*TPI*RAD
   48 PCOM(1)=DGASH(1)*PGASH(2)-DGASH(2)*PGASH(1)
      PCOM(2)=DGASH(1)*PGASH(1)+DGASH(2)*PGASH(2)
C
      DO 50 IEDG=1,NSD
      DO 50 ID=1,NDIM
   50 PEQLD(ID,IEDG)=PEQLD(ID,IEDG)+PCOM(ID)*SHF(IEDG)*DV
C
   60 CONTINUE
      IF(IPRINT.EQ.1)WRITE(IW6,905)LNE,ND1,ND2,
     + ((PEQLD(ID,IP),ID=1,2),IP=1,NSD)
  905 FORMAT(1X,3I4,10E12.4/)
C-----------------------------------------------------------------------
C     SLOT LOADS INTO ARRAY RHS
C-----------------------------------------------------------------------
      DO 90 IJ=1,NSD
      JL=ILOC(IJ)
      NDE=NCORR(JL,NE)
      IF(KGVN(1,NDE).EQ.0)GOTO 90
      N1=KGVN(1,NDE)-1
      DO 80 ID=1,NDIM
      FB(ID,JL)=FB(ID,JL)+PEQLD(ID,IJ)
   80 RHS(N1+ID)=RHS(N1+ID)+PEQLD(ID,IJ)*FC
   90 CONTINUE
CC    WRITE(IW6,906)RHS
CC906 FORMAT(4H0RHS/(1X,10E12.4))
      RETURN
      END
      SUBROUTINE DLIN(IP,I,MUS,IET,NEL,NDIM,NDN,NS,NPR,NMT,
     + ELCOD,SHFN,MAT,D,PR,INDX)
C***********************************************************************
C     CALCULATES STRESS-STRAIN MATRIX FOR LINEAR ELASTIC
C     BEHAVIOUR WHEN ELASTIC PROPERTIES VARY LINEARLY WITH DEPTH
C***********************************************************************
      DIMENSION ELCOD(NDIM,NDN),SHFN(NDN),D(NS,NS)
      DIMENSION MAT(NEL),PR(NPR,NMT)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      KM=MAT(I)
CC    IPA=IP+INDX
      YY=ZERO
      DO 5 IN=1,NDN
    5 YY=YY+SHFN(IN)*ELCOD(2,IN)
      E=PR(1,KM)+PR(3,KM)*(PR(2,KM)-YY)
      IF(E.LT.ZERO) THEN
         WRITE(IW6,900)E,MUS,IP,KM
  900    FORMAT(/1X,' *** ERROR - YOUNGS MODULUS IS NEGATIVE',E16.4,
     +           4X,'IN ELEMENT',I5,4X,'AT INT. POINT',I5/
     +           1X,'FOR MAT ZONE NUMBER',I5,4X,'(ROUTINE DLIN)')
         WRITE(IW15,900)E,MUS,IP,KM
         WRITE(IWS,900)E,MUS,IP,KM
         STOP
      ENDIF
      G=E/(2.*(1.+PR(4,KM)))
      A=E/((1.+PR(4,KM))*(1.-2.*PR(4,KM)))
C
      CALL ZEROR2(D,NS,NS)
      D(1,1)=A*(1.-PR(4,KM))
      D(1,2)=A*PR(4,KM)
      D(1,3)=D(1,2)
      D(2,1)=D(1,2)
      D(2,2)=D(1,1)
      D(2,3)=D(1,3)
      D(3,1)=D(1,3)
      D(3,2)=D(2,3)
      D(3,3)=D(1,1)
      D(4,4)=G
      IF(NDIM.EQ.2)GOTO 8
      D(5,5)=G
      D(6,6)=G
C
    8 CONTINUE
      IF(IET.EQ.0)GOTO 20
C
      DO 10 J=1,3
      DO 10 JJ=1,3
   10 D(JJ,J)=D(JJ,J)+PR(7,KM)
   20 CONTINUE
C
      DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
      RETURN
      END
      SUBROUTINE DMCAM(IP,I,MUS,IET,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +                 VARINT,MAT,D,PR,IPLSTK)
C***********************************************************************
C     CALCULATES  STRESS-STRAIN  MATRIX  FOR  MODIFIED CAM-CLAY
C***********************************************************************
      DIMENSION VARINT(NVRS,NIP,NEL),D(NS,NS),MAT(NEL)
      DIMENSION S(6),A(6),B(6),PR(NPR,NMT)
      COMMON /DIN/ DEL(3),DEP(21)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      KM=MAT(I)
      SX=VARINT(1,IP,I)
      SY=VARINT(2,IP,I)
      SZ=VARINT(3,IP,I)
      TXY=VARINT(4,IP,I)
      E=VARINT(NS+2,IP,I)
      PC=ABS(VARINT(NS+3,IP,I))
      P=(SX+SY+SZ)/3.
      Q2=SX*(SX-SY)+SY*(SY-SZ)+SZ*(SZ-SX)+3.*TXY*TXY
      IF(NDIM.EQ.2)GOTO 10
C
      TYZ=VARINT(5,IP,I)
      TZX=VARINT(6,IP,I)
      Q2=Q2+3.*TYZ*TYZ+3.*TZX*TZX
   10 Q=SQRT(Q2)
      IF(P.LT.0.) THEN
         WRITE(IW6,900)MUS,IP,P,KM
  900    FORMAT(1X,' *** ELEMENT ',I5,4X,'INT. PT',I5,4X,
     +             'PE IS NEGATIVE',E16.5,4X,'MAT ZONE NUMBER',I5/
     +             1X,'(ROUTINE DMCAM)')
         P=1.
         IF(P.GT.0.1*PC)P=0.1*PC
      ENDIF
      PY=P+Q*Q/(P*PR(4,KM)*PR(4,KM))
      BK=(1.+E)*P/PR(1,KM)

C-----------------------------------------------------------------------
C     CALCULATE  ELASTIC  STRESS-STRAIN  MATRIX
C-----------------------------------------------------------------------
      G=PR(5,KM)
      IF(G.LT.1.) G=BK*1.5*(1.-2.*PR(5,KM))/(1.+PR(5,KM))
      AL=(3.*BK+4.*G)/3.
      DL=(3.*BK-2.*G)/3.
C
      CALL ZEROR2(D,NS,NS)
      D(1,1)=AL
      D(2,1)=DL
      D(3,1)=DL
      D(1,2)=DL
      D(2,2)=AL
      D(3,2)=DL
      D(1,3)=DL
      D(2,3)=DL
      D(3,3)=AL
      D(4,4)=G
      IF(NDIM.EQ.2)GOTO 12
      D(5,5)=G
      D(6,6)=G
C
   12 CONTINUE
      IPLSTK=0
      IF(PY.LT.0.99*PC) GO TO 50
      IPLSTK=1
C-----------------------------------------------------------------------
C     CALCULATE  PLASTIC  STRESS-STRAIN  MATRIX  IF  CURRENT
C     POINT  ON  YIELD  LOCUS  AND  SET  PC  NEGATIVE
C-----------------------------------------------------------------------
      VARINT(NS+3,IP,I)=-ABS(VARINT(NS+3,IP,I))
      PCS=.5*PC
      PB=P/PCS
      S(1)=SX-P
      S(2)=SY-P
      S(3)=SZ-P
      S(4)=2.*TXY
      IF(NDIM.EQ.2)GOTO 16
      S(5)=2.*TYZ
      S(6)=2.*TZX
   16 BB=-2.*(1.-PB)/(3.*PCS)
      C=3./(PCS*PCS*PR(4,KM)*PR(4,KM))
      A(1)=BB+C*S(1)
      A(2)=BB+C*S(2)
      A(3)=BB+C*S(3)
      A(4)=C*S(4)
      IF(NDIM.EQ.2)GOTO 18
      A(5)=C*S(5)
      A(6)=C*S(6)
C
   18 DO 20 J=1,3
      B(J)=0.
      DO 20 JJ=1,3
   20 B(J)=B(J)+D(J,JJ)*A(JJ)
      B(4)=D(4,4)*A(4)
      IF(NDIM.EQ.2)GOTO 25
      B(5)=D(5,5)*A(5)
      B(6)=D(6,6)*A(6)
C
   25 XI=(PR(2,KM)-PR(1,KM))/(1.+E)
      AA=-4.*PB*(1.-PB)/(PCS*XI)
      AB=0.
C
      DO 30 J=1,NS
   30 AB=AB+A(J)*B(J)
      BETA=AA+AB
      DO 40 J=1,NS
      DO 40 JJ=1,NS
   40 D(JJ,J)=D(JJ,J)-B(JJ)*B(J)/BETA
   50 IF(IET.EQ.0) GOTO 80
C
      DO 60 J=1,3
      DO 60 JJ=1,3
   60 D(JJ,J)=D(JJ,J)+PR(7,KM)
   80 CONTINUE
C
      DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
C
      IS=0
      DO 90 J1=1,NS
      DO 90 I1=1,J1
      IS=IS+1
   90 DEP(IS)=D(I1,J1)
      RETURN
      END
      SUBROUTINE DSCHO(IP,I,MUS,IET,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +                 VARINT,MAT,D,PR,ITP,IPLSTK,IPROP)
C
C***********************************************************************
C     THIS ROUTINE CALCULATES THE D MATRIX FOR SCHOFIELD SOIL.
C     ROUTINE INCORPORATED INTO MP86 ON 2/1/87
C     ROUTINE LAST MODIFIED ON 30/4/81
C***********************************************************************
C
      DIMENSION VARINT(NVRS,NIP,NEL),PR(NPR,NMT),D(NS,NS)
      DIMENSION MAT(NEL)
      DIMENSION S(6),A(6),B(6)
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      KM=MAT(I)
      SX=VARINT(1,IP,I)
      SY=VARINT(2,IP,I)
      SZ=VARINT(3,IP,I)
      TXY=VARINT(4,IP,I)
      E=VARINT(NS+2,IP,I)
      PC=ABS(VARINT(NS+3,IP,I))
      PU=PC/2.7182818
      P=(SX+SY+SZ)/3.
      Q2=SX*(SX-SY)+SY*(SY-SZ)+SZ*(SZ-SX)+3.*TXY**2
      IF(NDIM.EQ.2)GOTO 8
      TYZ=VARINT(5,IP,I)
      TZX=VARINT(6,IP,I)
      Q2=Q2+3.*TYZ*TYZ+3.*TZX*TZX
    8 Q=SQRT(Q2)
      IF(P.LT.0.) THEN
         WRITE(IW6,900)MUS,IP,P,KM
  900    FORMAT(1X,' *** ELEMENT ',I5,4X,'INT. PT',I5,4X,
     +             'PE IS NEGATIVE',E16.5,4X,'MAT ZONE NUMBER',I5/
     +             1X,'(ROUTINE DSCHO)')
         P=1.
         IF(P.GT.0.1*PC)P=0.1*PC
      ENDIF
C
      H=PR(11,KM)
      PA=PU*PR(14,KM)
      RAT=PR(1,KM)/PR(2,KM)
      BA=PR(12,KM)
      BB=0.
C *** DETERMINE THE MATERIAL REGION
      IF(P.GE.PU) GO TO 21
      BC=Q-P*BA
      IF(BC.GT.0.999*BB) GO TO 10
      QA=(PR(4,KM)-H)*PU*(P/PU)**RAT+H*P
      IF(Q.GT.0.999*QA) GO TO 11
C *** MATERIAL IS ELASTIC OR YIELDING IN CAM-CLAY REGION
   21 IPROP=1
      GO TO 50
   10 IF(P.GT.PA) GO TO 11
C *** MATERIAL IS IN TENSILE CRACK REGION
      IPROP=3
      GO TO 50
   11 ETA=Q/(PR(4,KM)*P)
      IF(ABS(ETA-1.).LT.0.01) GO TO 21
C *** MATERIAL IS IN HVORSLEV REGION
      IPROP=2
   50 BK=(1.+E)*P/PR(1,KM)
C
C *** CALCULATE ELASTIC D MATRIX
C
      G=PR(5,KM)
      IF(G.LT.1.) G=BK*1.5*(1.-2.*PR(5,KM))/(1.+PR(5,KM))
      AL=(3.*BK+4.*G)/3.
      DL=(3.*BK-2.*G)/3.
C
      CALL ZEROR2(D,NS,NS)
      D(1,1)=AL
      D(2,1)=DL
      D(3,1)=DL
      D(1,2)=DL
      D(2,2)=AL
      D(3,2)=DL
      D(1,3)=DL
      D(2,3)=DL
      D(3,3)=AL
      D(4,4)=G
      IF(NDIM.EQ.2)GOTO 12
      D(5,5)=G
      D(6,6)=G
C
C *** CALCULATE PLASTIC D MATRIX
C
   12 CONTINUE
      XI=(PR(2,KM)-PR(1,KM))/(1.+E)
      GO TO (14,13,19) ,IPROP
C *** PARAMETERS FOR CAM-CLAY
   14 ITP=0
      PY=P*EXP(Q/(PR(4,KM)*P))
      IPLSTK=0
      IF(PY.LT.0.999*PC) GO TO 22
      VARINT(NS+3,IP,I)=-PC
      BB=(1.-Q/(PR(4,KM)*P))/(3.*P)
      IF(Q.LT.1.0E-5) GO TO 15
      QMP=Q/(PR(4,KM)*P)
      IF(QMP.LT.0.01) GO TO 16
      C=1.5/(Q*PR(4,KM)*P)
      GO TO 17
C
C *** Q/MP IS SMALL. USE FITTED CURVE TO CALCULATE C VALUE.
C
   16 CA=153.0302/(PR(4,KM)**2*PC**2)
      C=(-2.98*(100.*QMP)**3+3.98*(100.*QMP)**2)*CA
      ITP=1
      GO TO 17
C
C *** Q/MP IS TOO SMALL.USE C VALUE FOR ZERO Q/MP.I.E. ,C=0.
C
   15 C=0.
      ITP=1
   17 ALPHA=-1./XI
      GO TO 18
C *** PARAMETERS FOR HVORSLEV SURFACE
   13 C=1.5/Q
      BB=-(H+(PR(4,KM)-H)*RAT*(PU/P)**(1.-RAT))/3.
      ALPHA=-(PR(4,KM)-H)*(1.-RAT)*(P/PU)**RAT/XI*PU
      VARINT(NS+3,IP,I)=-PC
      GO TO 18
C *** PARAMETERS FOR TENSILE CRACK REGION
   19 C=1.5/Q
      BB=-BA/3.
      ALPHA=0.
      VARINT(NS+3,IP,I)=-PC
   18 AA=-3.*BB*ALPHA
      S(1)=SX-P
      S(2)=SY-P
      S(3)=SZ-P
      S(4)=2.*TXY
      IF(NDIM.EQ.2)GOTO 25
      S(5)=2.*TYZ
      S(6)=2.*TZX
   25 A(1)=BB+C*S(1)
      A(2)=BB+C*S(2)
      A(3)=BB+S(3)*C
      A(4)=C*S(4)
      IF(NDIM.EQ.2)GOTO 28
      A(5)=C*S(5)
      A(6)=C*S(6)
   28 CONTINUE
C
      DO 20 J=1,3
      B(J)=0.
      DO 20 JJ=1,3
   20 B(J)=B(J)+D(J,JJ)*A(JJ)
      B(4)=D(4,4)*A(4)
      IF(NDIM.EQ.2)GOTO 29
      B(5)=D(5,5)*A(5)
      B(6)=D(6,6)*A(6)
   29 AB=0.
      DO 30 J=1,NS
   30 AB=AB+A(J)*B(J)
      BETA=AA+AB
      DO 40 J=1,NS
      DO 40 JJ=1,NS
   40 D(JJ,J)=D(JJ,J)-B(JJ)*B(J)/BETA
      IPLSTK=1
   22 IF(IET.EQ.0) GO TO 70
      DO 60 J=1,3
      DO 60 JJ=1,3
   60 D(JJ,J)=D(JJ,J)+PR(7,KM)
   70 DEL(1)=D(1,1)
      DEL(2)=D(1,2)
      DEL(3)=D(4,4)
      IS=0
      DO 80 J1=1,NS
      DO 80 I1=1,J1
      IS=IS+1
   80 DEP(IS)=D(I1,J1)
      RETURN
      END
      SUBROUTINE DSLIP(NVRS,NIP,NEL,VARINT,D,IP,JJ)
C
C***********************************************************************
C     ROUTINE TO CALCULATE D MATRIX FOR SLIP ELEMENT
C***********************************************************************
C
      DIMENSION VARINT(NVRS,NIP,NEL),D(3,3)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /PROP  / COH,PHI,AKN,AKS,AKSRES
C
      CALL ZEROR2(D,3,3)
C
      SIGNR=VARINT(6,IP,JJ)
      SIGSH=VARINT(7,IP,JJ)
C
C---------SET D MATRIX TO VERY LOW VALUE, IF NORMAL STRESS IS TENSILE
      IF(SIGNR.GT.-ASMVL)GOTO 15
      D(1,1)=AKN/1.E2
      D(2,2)=AKS/1.E2
      D(3,3)=AKN/1.E2
      RETURN
C
C--------CHECK FOR LIMIT STATE OF SLIP
   15 D(1,1)=AKN
      D(2,2)=AKS
C
      SHRL=COH+TAN(PHI)*SIGNR
      IF(ABS(SIGSH).LT.0.99*SHRL)RETURN
C
C----------REDUCE SHEAR MODULUS
      D(2,2)=AKSRES
C
      RETURN
      END
      SUBROUTINE EDGLD(IW6,NEL,NDIM,NTPE,NNZ,MUMAX,NPL,NCORR,LTYP,MREL,
     + NREL,LNE,ND1,ND2,NP1,NP2,PDISLD,PRES,KLOD,NPT,KINS,MXLD)
C***********************************************************************
C     ROUTINE TO ALIGN NODES ALONG LOADED EDGE IN THE ANTI-CLOCKWISE   *
C     ORDER AND TO STORE THE INFORMATION                               *
C     THE PRESSURES AT THE BEGINNING OF AN INCREMENT BLOCK ARE STORED  *
C     IN A TEMPORARY ARRAY COMMON BLOCK PRLDI                          *
C     THE RATIOS OF THESE LOADING ARE ADDED TO THE CUMULATIVE LIST     *
C     (COMMON BLOCK PRSLD)                                             *
C     OF PRESSURE LOADS AT THE BEGINNING OF EACH INCREMENT             *
C***********************************************************************
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),NP1(NPL),NP2(NPL)
      DIMENSION NREL(NNZ),MREL(MUMAX)
      DIMENSION PDISLD(NDIM,NPT),PRES(NDIM,NPT)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PRLDI / PRSLDI(10,400),LEDI(400),NDI1(400),NDI2(400),ILOD
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      CALL ZEROR2(PRES,NDIM,NPT)
      NE=MREL(LNE)
      LI1=NREL(ND1)
      LI2=NREL(ND2)
      LT=LTYP(NE)
      IF(LT.LT.0) THEN
         WRITE(IW6,900)LNE
  900    FORMAT(/1X,'*** ERROR - YOU ARE PUTTING A PRESSURE LOAD',
     +           1X,'ON ELEMENT',I5,4X,'WHICH IS NOT PRESENT IN',
     +           1X,' CURRENT MESH (ROUTINE EDGLD)')
         WRITE(IW15,900)LNE
         WRITE(IWS,900)LNE
         STOP
      ENDIF
      NEDG=LINFO(3,LT)
      NMID=LINFO(7,LT)
      NSDN=NMID+2
      INDED=LINFO(14,LT)
C
      DO 20 K1=1,NEDG
      J1=NP1(K1+INDED)
      J2=NP2(K1+INDED)
      I1=NCORR(J1,NE)
      I2=NCORR(J2,NE)
      IF(LI1.EQ.I1.AND.LI2.EQ.I2)GO TO 25
      IF(LI1.EQ.I2.AND.LI2.EQ.I1)GO TO 21
   20 CONTINUE
      WRITE(IW6,903)KLOD,LNE,ND1,ND2
  903 FORMAT(/'   **** ERROR -',I5,' TH LOAD. ELEMENT',I5,
     + 2X,  ' DOES NOT CONTAIN NODES -',2I5,
     + 2X,  '(ROUTINE EDGLD)')
      WRITE(IW15,903)KLOD,LNE,ND1,ND2
      WRITE(IWS,903)KLOD,LNE,ND1,ND2
      STOP
C-----------------------------------------------------------------------
C     ALIGN NODES IN SEQUENCE
C-----------------------------------------------------------------------
   21 LIT=LI1
      LI1=LI2
      LI2=LIT
      NT=ND1
      ND1=ND2
      ND2=NT
C-----------------------------------------------------------------------
C     PRES - CONTAINS THE PRESSURE COMPONENTS ALIGNED IN SEQUENCE
C-----------------------------------------------------------------------
      DO 24 J=1,NSDN
      JBACK=NSDN+1-J
      DO 24 I=1,2
   24 PRES(I,J)=PDISLD(I,JBACK)
      GO TO 35
C
   25 DO 30 J=1,NSDN
      DO 30 I=1,2
   30 PRES(I,J)=PDISLD(I,J)
C-----------------------------------------------------------------------
C     UPDATE OR READ IN A NEW LIST
C-----------------------------------------------------------------------
   35 IF(KINS.EQ.0)GO TO 40
C-----------------------------------------------------------------------
C     PRESSURE LOADS IN EQUILIBRIUM WITH IN-SITU STRESSES
C     NEW LIST - READ DIRECTLY INTO COMMON PRSLD
C-----------------------------------------------------------------------
      CALL LODLST(IW6,LNE,ND1,ND2,PRES,NDIM,NPT,1,MXLD)
      GO TO 55
C-----------------------------------------------------------------------
C     PRESSURE LOADS FOR NEW INCREMENT BLOCK READ INTO COMMON PRSLDI
C-----------------------------------------------------------------------
   40 ILOD=KLOD
      LEDI(ILOD)=LNE
      NDI1(ILOD)=ND1
      NDI2(ILOD)=ND2
      IC=0
      DO 50 IV=1,NPT
      DO 50 IJ=1,2
      IC=IC+1
   50 PRSLDI(IC,ILOD)=PRES(IJ,IV)
   55 CONTINUE
      RETURN
      END
      SUBROUTINE EQLBM(IW6,NN,MXDF,NDF,NDIM,NNZ,NDZ,NQ,KGVN,
     + P,PT,PEQT,PCOR,REAC,NREL,IEQOP,IDFX,ICOR,IRAC,JINS,IWRU)
C***********************************************************************
C     CARRIES OUT AN EQUILIBRIUM CHECK
C     CALCULATE AND PRINTOUT UNBALANCED NODAL LOADS
C     LAST MODIFIED ON 2/10/91
C***********************************************************************
      DIMENSION NQ(NN),KGVN(MXDF,NN),IDFX(NDF),NREL(NNZ)
      DIMENSION P(NDF),PT(NDF),PEQT(NDF),PCOR(NDF),REAC(NDF)
CX    DIMENSION PAR(6),RMAX(6),TER(3)
      DIMENSION PAR(6)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /EQBM  / RMAX(6),TER(3),IW16
C-----------------------------------------------------------------------
C     MP - ARRAY SIZE OF PAR, RMAX
C-----------------------------------------------------------------------
      MP=6
      NDIM1=NDIM+1
      NDIM2=2*NDIM
      IF(IRAC.EQ.1)CALL REACT(IW6,NN,MXDF,NDF,NDIM,NNZ,
     + NQ,KGVN,NREL,PEQT,REAC,PT,IDFX)
C-----------------------------------------------------------------------
C     INCLUDE ALL PORE-PRESSURE TERMS IN THE LIST OF FIXED D.O.F.
C     ALL EXCESS PORE PRESSURE D.O.F. ARE CONSIDERED TO BE FIXED
C     ALL ROTATIONAL D.O.F ARE ALSO CONSIDERED TO BE FIXED.
C     IN ARRAY KGVN, LOCATION 4 - PORE-PRESSURE, 5 - ROTATION.
C-----------------------------------------------------------------------
      DO 12 NI=1,NN
      NQL=NQ(NI)
      IF(NQL.EQ.0)GO TO 12
      DO 10 IV=4,5
      ILC=KGVN(IV,NI)
      IF(ILC.EQ.0)GOTO 10
      IDFX(ILC)=1
   10 CONTINUE
   12 CONTINUE
C-----------------------------------------------------------------------
C     CALCULATE OUT-OF-BALANCE LOADS FOR ALL FREE D.O.F.
C-----------------------------------------------------------------------
      DO 15 IK=1,NDF
      IF(IDFX(IK).EQ.1) GO TO 13
      PCOR(IK)=PT(IK)-PEQT(IK)
      GO TO 15
   13 PCOR(IK)=ZERO
   15 CONTINUE
C-----------------------------------------------------------------------
C     OUTPUT EQUILIBRIUM, OUT-OF-BALANCE AND APPLIED NODAL LOADS
C-----------------------------------------------------------------------
      IF(IEQOP.EQ.0)GOTO 25
      IF(NDIM.EQ.2) THEN
         IF(JINS.EQ.1)WRITE(IW6,900)
         IF(JINS.EQ.0)WRITE(IW6,940)
         WRITE(IW6,904)
      ELSE IF(NDIM.EQ.3) THEN
         IF(JINS.EQ.1)WRITE(IW6,960)
         IF(JINS.EQ.0)WRITE(IW6,920)
         WRITE(IW6,924)
      ENDIF
C
      DO 20 JR=1,NNZ
      IF(NREL(JR).EQ.0)GOTO 20
      J=NREL(JR)
      NQL=NQ(J)
      IF(NQL.LE.1)GOTO 20
      IF(IEQOP.EQ.1.AND.JR.GT.NDZ)GOTO 20
      N1=KGVN(1,J)
      N2=N1+NDIM-1
      IF(NDIM.EQ.2)WRITE(IW6,901)JR,(P(JJ),JJ=N1,N2),
     + (PCOR(JJ),JJ=N1,N2),(PEQT(JJ),JJ=N1,N2),(PT(JJ),JJ=N1,N2)
      IF(NDIM.EQ.3.AND.JINS.EQ.0)WRITE(IW6,921)JR,(P(JJ),JJ=N1,N2),
     + (PCOR(JJ),JJ=N1,N2),(PEQT(JJ),JJ=N1,N2),(PT(JJ),JJ=N1,N2)
      IF(NDIM.EQ.3.AND.JINS.EQ.1)WRITE(IW6,922)JR,(PT(JJ),JJ=N1,N2),
     + (PCOR(JJ),JJ=N1,N2),(PEQT(JJ),JJ=N1,N2)
   20 CONTINUE
   25 CALL ZEROR1(RMAX,MP)
C-----------------------------------------------------------------------
C     CALCULATE MAXIMUM OF APPLIED AND OUT-OF-BALANCE
C     LOADS IN ALL DIRECTIONS
C-----------------------------------------------------------------------
      DO 50 IK=1,NN
      NQL=NQ(IK)
      IF(NQL.LE.1)GOTO 50
      N1=KGVN(1,IK)
      N2=N1+NDIM-1
      IC=0
      DO 35 KN=N1,N2
      IC=IC+1
      PAR(IC)=PT(KN)
   35 PAR(IC+NDIM)=PCOR(KN)
C
      DO 40 IC=1,NDIM2
      RV=PAR(IC)
      IF(ABS(RV).LT.ASMVL)GOTO 40
      IF(ABS(RV).GT.RMAX(IC))RMAX(IC)=ABS(RV)
   40 CONTINUE
   50 CONTINUE
C-----------------------------------------------------------------------
C     OUTPUT MAXIMUM OF (1) APPLIED LOADS (2) OUT-OF-BALANCE LOADS
C     IN ALL DIRECTIONS
C-----------------------------------------------------------------------
      WRITE(IW6,902)
CC    WRITE(IWS,902)
C
      IWARN=0
      PMAXT=RMAX(1)
      DO 55 ID=2,NDIM
   55 IF(RMAX(ID).GT.PMAXT)PMAXT=RMAX(ID)
      IF(PMAXT.LT.ASMVL) GOTO 132
      DO 130 ID=1,NDIM
  130 TER(ID)=100.*RMAX(ID+NDIM)/PMAXT
      GOTO 125
  132 IWARN=1
      DO 135 ID=1,NDIM
  135 TER(ID)=ZERO
C
  125 CONTINUE
      IF(NDIM.EQ.2) THEN
         WRITE(IW6,903)
         WRITE(IW6,905)
CC       WRITE(IWS,903)
CC       WRITE(IWS,905)
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IW6,923)
         WRITE(IW6,925)
CC       WRITE(IWS,923)
CC       WRITE(IWS,925)
      ENDIF
C--------WRITE TO SCREEN
      WRITE(IWS,700)
  700 FORMAT(1X,'******EQUILIBRIUM CHECK  : PERCENTAGE ERRORS')
      IF(NDIM.EQ.2)THEN
         WRITE(IW6,907)(RMAX(JQ),JQ=1,NDIM2),
     +   (TER(ID),ID=1,NDIM)
CC       WRITE(IWS,907)(RMAX(JQ),JQ=1,NDIM2),
CC   +   (TER(ID),ID=1,NDIM)
CC       WRITE(IW15,907)(RMAX(JQ),JQ=1,NDIM2),
CC   +   (TER(ID),ID=1,NDIM)
         WRITE(IWS,710)(TER(ID),ID=1,NDIM)
  710    FORMAT(5X,'X DIR =',F12.3,4X,'Y DIR =',F12.3)
         IF(IWRU.EQ.1)WRITE(IW14,907)(RMAX(JQ),JQ=1,NDIM2),
     +   (TER(ID),ID=1,NDIM)
      ELSE IF (NDIM.EQ.3) THEN
         WRITE(IW6,927)(RMAX(JQ),JQ=1,NDIM2),(TER(ID),ID=1,NDIM)
CC       WRITE(IW15,927)(RMAX(JQ),JQ=1,NDIM2),(TER(ID),ID=1,NDIM)
CC       WRITE(IWS,927)(RMAX(JQ),JQ=1,NDIM2),(TER(ID),ID=1,NDIM)
         WRITE(IWS,715)(TER(ID),ID=1,NDIM)
  715    FORMAT(5X,'X DIR =',F12.3,4X,'Y DIR =',F12.3,4X,'Z DIR =',
     +                       F12.3)
         IF(IWRU.EQ.1)WRITE(IW14,928)(RMAX(JQ),JQ=1,NDIM2),
     +                (TER(ID),ID=1,NDIM)
      ENDIF
      IF(IWARN.EQ.1)WRITE(IW6,910)
C-----------------------------------------------------------------------
C     ZERO PCOR IF NO CORRECTING LOADS ARE TO BE APPLIED IN NEXT INCR
C-----------------------------------------------------------------------
      IF(ICOR.NE.0)RETURN
      DO 140 IK=1,NDF
  140 PCOR(IK)=ZERO
      RETURN
  901 FORMAT(1X,I5,2X,8E14.4)
  902 FORMAT(//1X,17HEQUILIBRIUM CHECK/1X,17(1H-))
  904 FORMAT(/1X,5H NODE,8X,1HX,13X,1HY,13X,1HX,13X,1HY,13X,1HX,
     + 13X,1HY,13X,1HX,13X,1HY//)
  905 FORMAT(11X,1HX,15X,1HY,16X,1HX,15X,1HY,17X,1HX,15X,1HY/)
  907 FORMAT(1X,4E16.5,2F16.5)
  910 FORMAT(/40H WARNING **** NO APPLIED LOADING - CHECK,
     + 1X,49HWHETHER ALL BOUNDARY CONDITIONS ARE DISPLACEMENTS,
     + 2X,15H(ROUTINE EQLBM))
  921 FORMAT(1X,I5,2X,9E13.4/8X,3E13.4)
  922 FORMAT(1X,I5,2X,9E13.4)
  924 FORMAT(/1X,5H NODE,7X,1HX,12X,1HY,12X,1HZ,
     + 2(12X,1HX,12X,1HY,12X,1HZ)/)
  925 FORMAT(10X,1HX,13X,1HY,13X,1HZ,13X,1HX,13X,1HY,13X,1HZ,
     + 15X,1HX,13X,1HY,13X,1HZ/)
  927 FORMAT(1X,6E14.5,3F14.4)
  928 FORMAT(1X,4E14.5/1X,2E14.5,3F14.4)
  900 FORMAT(//47X,7HIN SITU,14X,22HNODAL LOADS EQUIVALENT/
     + 42X,19HOUT-OF-BALANCE LOAD,8X,19HTO ELEMENT STRESSES,
     + 9X,22HIN SITU EXTERNAL LOADS/42X,19(1H-),
     + 8X,19(1H-),9X,22(1H-))
  903 FORMAT(/7X,21HMAXIMUM EXTERNAL LOAD,10X,22HMAXIMUM OUT-OF-BALANCE,
     + 1X,4HLOAD,9X,31HPERCENTAGE ERROR IN EQUILIBRIUM/
     + 7X,21(1H-),10X,27(1H-),9X,31(1H-)/)
  920 FORMAT(//95X,22HNODAL LOADS EQUIVALENT/
     + 15X,25HINCREMENTAL EXTERNAL LOAD,17X,14HOUT-OF-BALANCE,
     + 1X,4HLOAD,20X,19HTO ELEMENT STRESSES/15X,25(1H-),17X,19(1H-),20X,
     + 19(1H-)/17X,21H(TOTAL EXTERNAL LOAD)/17X,21(1H-))
  960 FORMAT(//95X,22HNODAL LOADS EQUIVALENT/
     + 19X,21HIN SITU EXTERNAL LOAD,13X,22HIN SITU OUT-OF-BALANCE,
     + 1X,4HLOAD,16X,19HTO ELEMENT STRESSES/19X,21(1H-),13X,27(1H-),16X,
     + 19(1H-))
  923 FORMAT(/13X,21HMAXIMUM EXTERNAL LOAD,16X,
     + 27HMAXIMUM OUT-OF-BALANCE LOAD,
     + 16X,31HPERCENTAGE ERROR IN EQUILIBRIUM/
     + 13X,21(1H-),16X,27(1H-),16X,31(1H-)/)
  940 FORMAT(//67X,22HNODAL LOADS EQUIVALENT/8X,
     + 25HINCREMENTAL EXTERNAL LOAD,9X,14HOUT-OF-BALANCE,
     + 1X,4HLOAD,7X,19HTO ELEMENT STRESSES,13X,19HTOTAL EXTERNAL LOAD/
     + 8X,25(1H-),9X,19(1H-),7X,19(1H-),13X,19(1H-))
      END
      SUBROUTINE EQLIB(IW6,JJ,MUS,KM,LT,NGP,NIP,INDX,NTPE,NEL,NDIM,NN,
     + NDMX,NDN,NS,NB,NAC,NVRS,NPR,NMT,VARINT,NCORR,XYZ,B,ELCOD,
     + CARTD,SHFN,DS,F,LL,PR,ISTGE)
C***********************************************************************
C     ROUTINE TO CALCULATE FORCES EQUILIBRATING
C     ELEMENT STRESSES
C***********************************************************************
      REAL L,LL
      DIMENSION NCORR(NTPE,NEL),VARINT(NVRS,NIP,NEL),XYZ(NDIM,NN),
     +          F(NDIM,NDMX),LL(NAC),PR(NPR,NMT)
      DIMENSION CARTD(NDIM,NDMX),SHFN(NDMX),DS(NDIM,NDMX),
     +          ELCOD(NDIM,NDMX),B(NS,NB)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DATW  / W(100)
      COMMON /DATL  / L(4,100)
      COMMON /FLOW  / NPLAX
      COMMON /JACB  / XJACI(3,3),DJACB
C
      CR=1.
      IF(NPLAX.EQ.1)CR=2.*PYI
C
      CALL ZEROR2(F,NDIM,NDMX)
C
      DO 20 KN=1,NDN
      NDE=NCORR(KN,JJ)
      DO 20 ID=1,NDIM
   20 ELCOD(ID,KN)=XYZ(ID,NDE)
C
      IF(LT.EQ.1)THEN
         CALL FOMFBR(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +               NDN,NVRS,VARINT,ELCOD,F)
         RETURN
      ELSE IF(LT.EQ.12) THEN
         CALL FOMFBM(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +               NDN,NVRS,VARINT,ELCOD,F)
         RETURN
      ELSE IF(LT.EQ.13) THEN
         THICK=PR(6,KM)
         CALL FOMFSL(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +               NDN,NVRS,VARINT,ELCOD,F,THICK)
         RETURN
      ELSE IF(LT.EQ.14)THEN
         CALL FMFBR2(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +               NDN,NVRS,VARINT,ELCOD,F)
         RETURN
      ELSE IF(LT.EQ.15) THEN
         CALL FMFBM2(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +               NDN,NVRS,VARINT,ELCOD,F)
         RETURN
      ENDIF
C
      DO 60 IP=1,NGP
      IPA=IP+INDX
      DO 30 IL=1,NAC
   30 LL(IL)=L(IL,IPA)
      CALL FORMB2(JJ,MUS,R,RI,NDIM,NDMX,NDN,NS,
     +            NB,NAC,B,ELCOD,CARTD,SHFN,DS,LL,LT,IP,ISTGE)
      F9=CR*DJACB*W(IPA)
      IF(NPLAX.EQ.1)F9=F9*R
CC    WRITE(IW6,880)MUS,IP,CR,DJACB,W(IPA),R,F9
CC880 FORMAT(1X,'ELEM = ',I4,2X,'IP=',I4,2X,'CR=',E20.5,2X,'DJACB =',
CCCC + E20.5/19X,'W =',E20.6,5X,'R =',E20.5,5X,'F9 =',E20.5)
C
      U=VARINT(NS+1,IP,JJ)
      SIGXT=VARINT(1,IP,JJ)+U
      SIGYT=VARINT(2,IP,JJ)+U
      SIGZT=VARINT(3,IP,JJ)+U
      TXY=VARINT(4,IP,JJ)
      IF(NDIM.EQ.2)GOTO 35
C
      TYZ=VARINT(5,IP,JJ)
      TZX=VARINT(6,IP,JJ)
C
      DO 50 IN=1,NDN
      F(1,IN)=F(1,IN)+(CARTD(1,IN)*SIGXT+CARTD(2,IN)*TXY
     +               +CARTD(3,IN)*TZX)*F9
      F(2,IN)=F(2,IN)+(CARTD(2,IN)*SIGYT+CARTD(1,IN)*TXY
     +               +CARTD(3,IN)*TYZ)*F9
      F(3,IN)=F(3,IN)+(CARTD(3,IN)*SIGZT+CARTD(2,IN)*TYZ
     +               +CARTD(1,IN)*TZX)*F9
   50 CONTINUE
      GOTO 60
C
   35 DO 40 IN=1,NDN
      F(1,IN)=F(1,IN)+(CARTD(1,IN)*SIGXT+SHFN(IN)*SIGZT*RI
     +               +CARTD(2,IN)*TXY)*F9
   40 F(2,IN)=F(2,IN)+(CARTD(2,IN)*SIGYT+CARTD(1,IN)*TXY)*F9
   60 CONTINUE
CC    WRITE(IW6,888)JJ,F
CC888 FORMAT(/1X,'******* ELEMENT ',I5,2X,'*********   F '/1X,
CC   + (6E20.5))
      RETURN
      END
      SUBROUTINE FMFBM2(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +                  NDN,NVRS,VARINT,ELCOD,F)
C
C***********************************************************************
C     CALCULATES F MATRIX (LOAD VECTOR) EQUIVALENT TO ELEMENT STRESSES
C     FOR 2-NODED BEAM ELEMENT (LT = 15)
C***********************************************************************
C
      REAL L
      DIMENSION VARINT(NVRS,NIP,NEL),ELCOD(NDIM,NDN),F(NDIM,NDN)
      DIMENSION SHF(6),DER(6),B(2,6),BN(2,6),T(3,3)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
      CALL ROTAT(ELCOD,NDIM,NDN,DL,T)
C----------NUMBER OF D.O.F IN ELEMENT
      NDOF=6
C
      DO 100 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBM(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 30 IN=1,2
   30 DJACB=DJACB+DER(3*IN-2)*ELCOD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,900)MUS,IP,DJACB
  900    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
C
      DO 40 J=1,6
      DO 40 I=1,2
      B(I,J)=ZERO
   40 BN(I,J)=ZERO
C----------CALCULATE B MATRIX
      B(1,1)=-DER(1)/DJACB
      B(1,4)=-DER(4)/DJACB
C
      B(2,2)=-DER(2)/(DJACB**2)
      B(2,3)=-DER(3)/(DJACB**2)
      B(2,5)=-DER(5)/(DJACB**2)
      B(2,6)=-DER(6)/(DJACB**2)
C----------TRANSFORM CO-ORDINATE SYSTEM
      DO 60 IN=1,2
      DO 50 I=1,2
      DO 50 J=1,3
      NJ=3*(IN-1)+J
      DO 50 K=1,2
      NK=3*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   50 CONTINUE
   60 CONTINUE
C
      DO 80 IN=1,2
      DO 70 ID=1,2
      DO 70 J=1,2
      IND=3*(IN-1)+ID
      F(ID,IN)=F(ID,IN)+B(J,IND)*VARINT(J,IP,JJ)*FAC
   70 CONTINUE
   80 CONTINUE
  100 CONTINUE
C
CC    WRITE(IW6,920)MUS,((F(I,J),J=1,2),I=1,2)
CC920 FORMAT(/1X,'ELEMENT',I5,4X,'F'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE FMFBR2(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +                  NDN,NVRS,VARINT,ELCOD,F)
C
C***********************************************************************
C     CALCULATES F MATRIX (LOAD VECTOR) EQUIVALENT TO ELEMENT STRESSES
C     FOR 2-NODED BAR ELEMENT (LT = 14)
C***********************************************************************
C
      REAL L
      DIMENSION VARINT(NVRS,NIP,NEL),ELCOD(NDIM,NDN),F(NDIM,NDN)
      DIMENSION SHF(2),DER(2),B(2),BN(4),T(3,3)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
      CALL ROTAT(ELCOD,NDIM,NDN,DL,T)
C----------NUMBER OF D.O.F IN ELEMENT
      NDOF=2
C
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBR(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 30 IN=1,2
   30 DJACB=DJACB+DER(IN)*ELCOD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,900)MUS,IP,DJACB
  900    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
C
      DO 40 J=1,2
      B(J)=ZERO
      BN(2*J-1)=ZERO
   40 BN(2*J)=ZERO
C----------CALCULATE B MATRIX
      DO 50 I=1,2
   50 B(I)=-DER(I)/DJACB
C
      DO 60 I=1,2
      BN(2*I-1)=B(I)*T(1,1)
      BN(2*I)=B(I)*T(2,1)
   60 CONTINUE
C
      DO 80 IN=1,2
      DO 70 ID=1,2
      F(ID,IN)=F(ID,IN)+B(IN)*VARINT(ID,IP,JJ)*FAC
   70 CONTINUE
   80 CONTINUE
  200 CONTINUE
CC    WRITE(IW6,920)MUS,((F(I,J),J=1,2),I=1,2)
CC920 FORMAT(/1X,'ELEMENT',I5,4X,'F'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE EQLOD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,NDZ,NPR,
     + NMT,NDMX,NL,NPL,NCORR,NQ,KGVN,IDFX,LTYP,MAT,JEL,MREL,NREL,NP1,
     + NP2,XYZ,P,PT,PEQT,PCOR,XYFT,PCONI,REAC,PR,F,ELCOD,SHFN,DS,
     + LL,NPT,NSP,MXEN,IEQOP,ICOR,TGRAV,IRAC,FRACT,JINS,KSTGE,IWRU)
C***********************************************************************
C     ROUTINE TO CALCULATE EQUIVALENT NODAL LOADS FOR
C     APPLIED LOADING TO CARRY OUT AN EQUILIBRIUM CHECK
C***********************************************************************
      REAL LL
      DIMENSION NCORR(NTPE,NEL),NQ(NN),KGVN(MXDF,NN),IDFX(NDF)
      DIMENSION P(NDF),PT(NDF),PEQT(NDF),PCOR(NDF),XYFT(NDF),PCONI(NDF)
      DIMENSION LTYP(NEL),NREL(NNZ),MAT(NEL),JEL(NEL),XYZ(NDIM,NN)
      DIMENSION MREL(MUMAX),PRES(10),PR(NPR,NMT),F(NDIM,NDMX),REAC(NDF)
      DIMENSION NP1(NPL),NP2(NPL)
      DIMENSION ELCOD(NDIM,NDMX),SHFN(NDMX),DS(NDIM,NDMX),LL(NL)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      CALL ZEROR1(PT,NDF)
C-----------------------------------------------------------------------
C     (1) PRESSURE LOADING ALONG ELEMENT EDGE
C-----------------------------------------------------------------------
      IF(NLED.EQ.0.AND.TGRAV.LT.ASMVL)GO TO 62
      IF(NLED.EQ.0)GO TO 32
CC    WRITE(IW6,801)NLED
CC801 FORMAT(/1X,4HNLED,I5)
CC    WRITE(IW6,802)LEDG
CC802 FORMAT(/1X,4HLEDG/(1X,20I5))
CC    WRITE(IW6,803)NDE1
CC803 FORMAT(/1X,4HNDE1/(1X,20I5))
CC    WRITE(IW6,804)NDE2
CC804 FORMAT(/1X,4HNDE2/(1X,20I5))
CC    WRITE(IW6,805)PRESLD
CC805 FORMAT(/1X,6HPRESLD/(1X,20F6.1))
C
      DO 30 KE=1,NLED
      LNE=LEDG(KE)
      IF(LNE.EQ.0)GOTO 30
      NE=MREL(LNE)
      LT=LTYP(NE)
      IF(LT.GT.0)GOTO 10
      IF(KSTGE.EQ.4)GOTO 30
      WRITE(IW6,900)LNE
  900 FORMAT(/1X,45H *** ERROR : IN SITU PRESSURE LOAD APPLIED TO,1X,
     +  7HELEMENT,I5,2X,28HWHICH IS NOT PRESENT IN MESH,1X,
     +  15H(ROUTINE EQLOD)/)
      WRITE(IW15,900)LNE
      WRITE(IWS,900)LNE
      GOTO 30
   10 ND1=NDE1(KE)
      ND2=NDE2(KE)
      DO 20 KV=1,MXEN
   20 PRES(KV)=PRESLD(KV,KE)
C
      CALL DISTLD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,NPL,PT,XYZ,
     + NP1,NP2,KGVN,NCORR,LTYP,MREL,NREL,LNE,ND1,ND2,PRES,NPT,NSP,0,
     + 1,1.0)
   30 CONTINUE
C-----------------------------------------------------------------------
C     (2) SELF WEIGHT LOADING
C-----------------------------------------------------------------------
   32 IF(TGRAV.LT.ASMVL) GO TO 62
      DO 60 KL=1,NEL
      LT=LTYP(KL)
      IF(LT.LT.0)GO TO 60
      GOTO(60,35,35,35,35,35,35,35,35,60,60,60,35,60,60),LT
   35 NDN=LINFO(5,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
      KM=MAT(KL)
C-----------------------------------------------------------------------
C     FIND IF ELEMENT HAS BEEN ADDED IN THIS INCREMENT BLOCK
C     THEN USE LOAD RATIO FRACT ON GRAVITY LOADING
C-----------------------------------------------------------------------
      DO 40 IM=1,NEL
      MUS=JEL(IM)
      IF(MUS.EQ.0)GO TO 42
      MPR=MREL(MUS)
      IF(KL.EQ.MPR)GO TO 44
   40 CONTINUE
   42 FA=1.
      GO TO 45
   44 FA=FRACT
   45 DENS=PR(8,KM)*TGRAV*FA
C
      IF(LT.EQ.13) THEN
         CALL SELF2(IW6,KL,NN,NEL,NTPE,NDN,NDIM,NPR,NMT,XYZ,PR,
     +              ELCOD,SHFN,F,NCORR,MAT,LT,INDX,DENS,MUS,KSTGE)
      ELSE
         CALL SELF(IW6,KL,NN,NEL,NTPE,NDN,NDIM,NAC,NPR,NMT,XYZ,PR,
     +             ELCOD,SHFN,DS,F,NCORR,MAT,LL,LT,INDX,DENS,MUS,KSTGE)
      ENDIF
C
CC    WRITE(IW6,810)KL,F
CC810 FORMAT(/1X,'ELEMENT =',I5/(1X,6E16.5))
      DO 58 KK=1,NDN
      NCOR=NCORR(KK,KL)
      IF(NQ(NCOR).EQ.0)GOTO 58
      KKK=KGVN(1,NCOR)-1
      DO 55 ID=1,NDIM
   55 PT(KKK+ID)=PT(KKK+ID)+F(ID,KK)
   58 CONTINUE
   60 CONTINUE
   62 CONTINUE
C-----------------------------------------------------------------------
C     ADD CONTRIBUTIONS FROM POINT LOADS
C-----------------------------------------------------------------------
      DO 70 J=1,NDF
   70 PT(J)=PT(J)+XYFT(J)+PCONI(J)
C-----------------------------------------------------------------------
C     FIND DOF WHICH ARE RESTRAINED
C-----------------------------------------------------------------------
      CALL RESTRN(NDF,MXDF,NDIM,KGVN,IDFX,NQ,NN)
C-----------------------------------------------------------------------
C     EQUILIBRIUM CHECK
C-----------------------------------------------------------------------
      CALL EQLBM(IW6,NN,MXDF,NDF,NDIM,NNZ,NDZ,NQ,KGVN,P,PT,PEQT,
     +           PCOR,REAC,NREL,IEQOP,IDFX,ICOR,IRAC,JINS,IWRU)
      RETURN
      END
      SUBROUTINE EVCAM(VARINT,NEL,NVRS,NDIM,NIP,IP,J,MR,KM,IEL,
     +           NS,NPR,NMT,PR,NTY,NCAM,V,NCODE,LCS,LNGP,MCS,MNGP,NELCM,
     +           VARC,NGP,ED,LED,NCV,ICCSM)
C***********************************************************************
C     CALCULATE EXTRA STRESS PARAMETERS FOR CAM-CLAYS
C     ROUTINE LAST UPDATED ON 2/1/87
C***********************************************************************
      DIMENSION VARINT(NVRS,NIP,NEL),NELCM(NEL),PR(NPR,NMT),NTY(NMT)
      DIMENSION VARC(NCV,NIP,NEL),MCS(NEL),MNGP(NEL),ICCSM(20)
      DIMENSION LCS(NIP,NEL),LNGP(NIP,NEL),NCODE(NIP,NEL),ED(LED)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /COUNT / NCS,NNGP
C
      KGO=NTY(KM)
      U=VARINT(NS+1,IP,J)
      IF(IP.NE.1)GO TO 11
      NCS=0
      NNGP=0
   11 ICS=0
      INGP=0
      SGNQ=1.
      IF(VARINT(1,IP,J).GT.VARINT(2,IP,J))SGNQ=-1.
      QT=Q(VARINT(1,IP,J),NS,NDIM)
      PE=(VARINT(1,IP,J)+VARINT(2,IP,J)+VARINT(3,IP,J))/3.
      EV=-V*(1.+VARINT(NS+2,IP,J))+VARINT(NS+2,IP,J)
      EE=VARINT(NS+2,IP,J)
      PYE=VARINT(NS+3,IP,J)
      PCO=ABS(PYE)
      IF(KGO.NE.6)GOTO 27
      CALL SCOCAM(IP,MR,KM,ICS,INGP,IEL,NIP,NEL,NCODE,VARC,NCV,PR,NTY,
     + PE,QT,PCO,PYE,U,EV,EE,PC,ED,LED,NPR,NMT,SGNQ,ICCSM)
      GOTO 30
   27 CALL VARCAM(IP,MR,KM,ICS,INGP,IEL,NIP,NEL,NCODE,VARC,NCV,PR,NTY,
     + PE,QT,PCO,PYE,U,EV,EE,PC,ED,LED,NPR,NMT,SGNQ,ICCSM)
   30 CONTINUE
      VARINT(NS+3,IP,J)=PC
      VARINT(NS+2,IP,J)=EE
C
      NCS=NCS+ICS
      IF(ICS.EQ.1)LCS(IP,IEL)=IP
      NNGP=NNGP+INGP
      IF(INGP.EQ.1)LNGP(IP,IEL)=IP
      CALL ANGTH(VARINT,NEL,NIP,NVRS,IP,J,THETA)
      VARC(10,IP,IEL)=THETA
      IF(NDIM.EQ.3)VARC(10,IP,IEL)=ZERO
C
      IF(IP.NE.NGP)RETURN
      NCAM=NCAM+1
      NELCM(IEL)=1
      IF(NCS.NE.0)MCS(IEL)=1
      IF(NNGP.NE.0)MNGP(IEL)=1
      RETURN
      END
      SUBROUTINE FACTOR(IW6,NOINC,ILDF,IOCD,ITMF,IOUTS,
     +                  RINCC,DTM,IOPT,DTIME)
C***********************************************************************
C     INCREMENT RATIOS, TIME RATIOS (CONSOLIDATION ANALYSIS) AND OUTPUT
C     OPTIONS FOR ALL INCREMENTS IN THE BLOCK
C***********************************************************************
      DIMENSION RINCC(NOINC),DTM(NOINC),IOPT(NOINC)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C-----------------------------------------------------------------------
C     READ INCREMENT RATIOS FOR INCREMENTS
C-----------------------------------------------------------------------
      FSTD=1.0/FLOAT(NOINC)
      IF(ILDF.EQ.0)GO TO 98
      WRITE(IW6,948)
      CALL RDREL(RINCC,NOINC)
      WRITE(IW6,954)(RINCC(IN),IN=1,NOINC)
      GO TO 122
   98 DO 100 IK=1,NOINC
  100 RINCC(IK)=FSTD
C-----------------------------------------------------------------------
C     READ OUTPUT OPTIONS
C-----------------------------------------------------------------------
  122 IF(IOCD.EQ.0)GO TO 127
      WRITE(IW6,960)
      CALL RDINT(IOPT,NOINC)
      WRITE(IW6,964)(IOPT(IN),IN=1,NOINC)
      GO TO 131
C
  127 DO 130 IK=1,NOINC
  130 IOPT(IK)=IOUTS
C-----------------------------------------------------------------------
C     READ TIME RATIOS FOR INCREMENTS
C-----------------------------------------------------------------------
  131 IF(DTIME.LT.ASMVL.OR.ITMF.EQ.0)GO TO 132
      WRITE(IW6,965)
      CALL RDREL(DTM,NOINC)
      WRITE(IW6,968)(DTM(IN),IN=1,NOINC)
      GO TO 136
C
  132 DO 135 IK=1,NOINC
  135 DTM(IK)=FSTD*DTIME
  136 CONTINUE
      RETURN
  948 FORMAT(/1X,39HLIST OF INCREMENT RATIOS FOR INCREMENTS/1X,39(1H-)/)
  954 FORMAT(1X,10F8.1)
  960 FORMAT(/1X,35HLIST OF OUTPUT CODES FOR INCREMENTS/1X,35(1H-)/)
  964 FORMAT(1X,10I6)
  965 FORMAT(/1X,33HLIST OF TIME STEPS FOR INCREMENTS/1X,33(1H-)/)
  968 FORMAT(1X,8F10.0)
      END
      SUBROUTINE FFIN(NUMEX,ICODE)
C***********************************************************************
C     FREE FORMAT INPUT ROUTINE                                        *
C     READS NUMBERS IN FORTRAN STANDARD (1966) SYNTAX                  *
C     ROUTINE LAST MODIFIED ON 30/4/81                                 *
C***********************************************************************
      CHARACTER*1 JD,ID,JDO,IM,IS,IQ,IC,IE,IP,IDOT
      LOGICAL LINT(41),LEXP
      DIMENSION JD(130),ID(10)
      COMMON /FF/ A(40),NCARD,NERR,JERR,LUN
      COMMON /FFL/ JDO(130)
      COMMON /DEVSUP/ IW14,IW15,IWS
      DATA ID(1),ID(2),ID(3),ID(4),ID(5),ID(6),ID(7),ID(8),ID(9),ID(10)/
     +     '0','1','2','3','4','5','6','7','8','9'/
      DATA IM,IS,IQ,IC,IE,IP,IDOT/'-',' ','?','C','E','+','.'/
C
C     READ IN LINE OF DATA IN A1 FORMAT
C
C-----------LENGTH OF ARRAY JD
      LJD=130
      LJD1=LJD+1
C
   10 READ(LUN,1000) JD
 1000 FORMAT(130A1)
      DO 11 IL=1,40
   11 A(IL)=0.0
C
      DO 12 IK=1,LJD
   12 JDO(IK)=JD(IK)
      NCARD=NCARD+1
C
C     SKIP LINE IF IT IS A COMMENT
C
      IF(JD(1).EQ.IC) GOTO 10
C***********************************************************************
C     KD IS POINTER TO CHARACTER POSITION IN LINE READ                 *
C     FOR THE NUMBER CURRENTLY BEING INTERPRETTED ...                  *
C     THE NUMI'TH NUMBER ON THE RECORD ...                             *
C     NUMW IS THE VALUE OF THE WHOLE (OR INTEGER) PART                 *
C     IF IT'S POSITIVE ISIGN=1                                         *
C     IF IT'S NEGATIVE ISIGN=-1                                        *
C     NUMF/DIV IS THE VALUE OF THE FRACTIONAL PART                     *
C     NUMX IS THE VALUE OF THE EXPONENT (IF THERE IS ONE)              *
C     IF THE EXPONENT IS POSITIVE JSIGN=1                              *
C     IF THE EXPONENT IS NEGATIVE JSIGN=-1                             *
C     LINT(NUMI) IS .TRUE. IF NO DECIMAL POINT OR EXPONENT IS FOUND    *
C     LEXP IS .TRUE. IF AN EXPONENT IS ENCOUNTERED                     *
C***********************************************************************
      JERR=0
      KD=0
      NUMW=0
      NUMF=0
      NUMI=0
      NUMX=0
      LINT(1)=.TRUE.
      LEXP=.FALSE.
      DIV=1.
      ISIGN=1
      JSIGN=1
C
C      LOOK FOR THE FIRST NUMBER ON THE LINE
C
   14 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 18
      IF(JD(KD).EQ.IS) GOTO 14
      GOTO 30
C
C     EMPTY LINE
C
   18 NERR=NERR+1
      JERR=1
      WRITE(6,1001) NCARD
      WRITE(IW15,1001) NCARD
      WRITE(IWS,1001) NCARD
 1001 FORMAT(25H ***ERROR*** DATA RECORD ,I5,11H   IS EMPTY/1X,80(1H-))
      RETURN
C***********************************************************************
C     LOOK FOR NEXT NUMBER                                             *
C***********************************************************************
   22 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 200
      IF(JD(KD).EQ.IS) GOTO 22
C
C      CHECK FOR LEGAL STARTING CHARACTER FOR NUMBER
C      I.E. +,-,. OR DIGIT
C
   30 IF(JD(KD).EQ.IM) GOTO 38
C
      DO 32 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   32 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 46
C
      IF(JD(KD).EQ.IP) GOTO 42
C
      GOTO 400
C
   38 ISIGN=-1
C
   42 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
C
      DO 44 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   44 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 46
C
      GOTO 400
C
C     AFTER '.' NEXT CHARACTER MUST BE A DIGIT
C     IN THIS CONTEXT (START OF A NUMBER)
C
   46 KD=KD+1
      LINT(NUMI+1)=.FALSE.
      IF(KD.EQ.LJD1) GOTO 410
C
      DO 48 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 70
   48 CONTINUE
C
      GOTO 400
C***********************************************************************
C     INTERPRET THE INTEGER PART OF A NUMBER                           *
C***********************************************************************
   50 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 54 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 58
   54 CONTINUE
C
      IF(JD(KD).EQ.IDOT) GOTO 62
C
      IF(JD(KD).EQ.IE) GOTO 80
C
      GOTO 400
C
   58 NUMW=10*NUMW+J-1
      GOTO 50
C***********************************************************************
C     READ FRACTIONAL PART OF NUMBER (I.E. THAT PART WHICH FOLLOWS     *
C     THE DECIMAL POINT)                                               *
C***********************************************************************
   62 KD=KD+1
      LINT(NUMI+1)=.FALSE.
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 66 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 70
   66 CONTINUE
C
      IF(JD(KD).EQ.IE) GOTO 80
      GOTO 400
C
   70 NUMF=10*NUMF+J-1
      DIV=10.*DIV
      GOTO 62
C***********************************************************************
C     DEAL WITH EXPONENT                                               *
C***********************************************************************
   80 LEXP=.TRUE.
      LINT(NUMI+1)=.FALSE.
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
      IF(JD(KD).EQ.IM) GOTO 82
      IF(JD(KD).EQ.IP) GOTO 84
      GOTO 86
C
   82 JSIGN=-1
C
   84 KD=KD+1
      IF(KD.EQ.LJD1) GOTO 410
C
   86 DO 88 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 90
   88 CONTINUE
      GOTO 400
C
   90 NUMX=J-1
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
C
      DO 92 J=1,10
      IF(JD(KD).EQ.ID(J)) GOTO 94
   92 CONTINUE
      GOTO 400
C
   94 NUMX=10*NUMX+J-1
      KD=KD+1
      IF(KD.EQ.LJD1) GOTO 100
      IF(JD(KD).EQ.IS) GOTO 100
      GOTO 400
C
C***********************************************************************
C     END OF NUMBER                                                    *
C***********************************************************************
  100 NUMI=NUMI+1
      A(NUMI)=FLOAT(NUMW)+FLOAT(NUMF)/DIV
      IF(ISIGN.EQ.(-1)) A(NUMI)=-A(NUMI)
      IF(.NOT.LEXP) GOTO 104
      IF(JSIGN.EQ.(-1)) NUMX=-NUMX
      FAC=10.0**NUMX
      A(NUMI)=A(NUMI)*FAC
C
  104 IF(KD.EQ.LJD1) GOTO 200
C
C     RE-INITIALISE
C
      NUMW=0
      NUMF=0
      NUMX=0
      LEXP=.FALSE.
      LINT(NUMI+1)=.TRUE.
      DIV=1.
      ISIGN=1
      JSIGN=1
      GOTO 22
C***********************************************************************
C     END OF LINE                                                      *
C***********************************************************************
  200 KERR=0
      L=0
      JCODE=ICODE
      IF(NUMEX.EQ.NUMI) GOTO 204
      WRITE(6,1002) NCARD
      WRITE(6,1004) JD
      WRITE(6,1006)NUMEX,NUMI
      WRITE(IW15,1002) NCARD
      WRITE(IW15,1004) JD
      WRITE(IW15,1006)NUMEX,NUMI
      WRITE(IWS,1002) NCARD
      WRITE(IWS,1004) JD
      WRITE(IWS,1006)NUMEX,NUMI
 1006 FORMAT(1X,I5,21H NUMBERS EXPECTED BUT,I3,12H ENCOUNTERED/
     + 1X,80(1H-))
      KERR=1
      JERR=1
      NERR=NERR+1
C
  204 IF(JCODE.EQ.0) GOTO 220
      L=L+1
      IF(L.GT.NUMI) GOTO 220
      IF(L.GT.NUMEX) GOTO 420
      J=JCODE/2
      INT=JCODE-2*J
      JCODE=J
      IF(INT.EQ.0) GOTO 204
C
C     NUMBER MUST BE AN INTEGER
C
      IF(LINT(L)) GOTO 204
      IF(KERR.EQ.1) GOTO 208
      KERR=1
      JERR=1
      NERR=NERR+1
      WRITE(6,1002)NCARD
      WRITE(6,1004)JD
      WRITE(IW15,1002) NCARD
      WRITE(IW15,1004) JD
      WRITE(IWS,1002) NCARD
      WRITE(IWS,1004) JD
C
  208 WRITE(6,1007)L
 1007 FORMAT(19H NUMBER IN POSITION,I3,18H IS NOT AN INTEGER/1X,80(1H-))
      WRITE(IW15,1007)L
      WRITE(IWS,1007)L
      GOTO 204
C
  220 CONTINUE
C     WRITE(6,2000) NCARD
C2000 FORMAT(12H DATA RECORD,I5)
C     WRITE(6,2001)(A(I),I=1,NUMI)
C     WRITE(6,2002)(A(I),I=1,NUMI)
C2001 FORMAT(1X,10F12.3)
C2002 FORMAT(1X,10E12.4)
      RETURN
C***********************************************************************
C     ERRORS                                                           *
C***********************************************************************
  400 NERR=NERR+1
      JERR=1
      WRITE(6,1002)NCARD
 1002 FORMAT(27H ***ERROR*** IN DATA RECORD,I5)
      WRITE(6,1004)JD
 1004 FORMAT(1X,130A1)
      WRITE(IW15,1002)NCARD
      WRITE(IW15,1004)JD
      WRITE(IWS,1002)NCARD
      WRITE(IWS,1004)JD
C
      DO 402 J=1,LJD
  402 JD(J)=IS
      JD(KD)=IQ
      WRITE(6,1004)JD
      WRITE(6,1003)
 1003 FORMAT(28H ILLEGAL SYNTAX FOR A NUMBER)
      WRITE(IW15,1004)JD
      WRITE(IW15,1003)
      WRITE(IWS,1004)JD
      WRITE(IWS,1003)
      IF(NERR.GT.9)GO TO 500
      RETURN
C
  410 NERR=NERR+1
      JERR=1
      WRITE(6,1002)NCARD
      WRITE(6,1004)JD
      WRITE(IW15,1002)NCARD
      WRITE(IW15,1004)JD
      WRITE(IWS,1002)NCARD
      WRITE(IWS,1004)JD
C
      KD=LJD
      DO 412 J=1,LJD
  412 JD(J)=IS
      JD(KD)=IQ
      WRITE(6,1004)JD
      WRITE(6,1005)
 1005 FORMAT(35H INCOMPLETE NUMBER NEAR END OF LINE)
      WRITE(IW15,1004)JD
      WRITE(IW15,1005)
      WRITE(IWS,1004)JD
      WRITE(IWS,1005)
      IF(NERR.GT.9)GO TO 500
      RETURN
C
  420 WRITE(6,1008) NCARD
 1008 FORMAT(61H ***PROGRAM ERROR*** IN ROUTINE FFIN WHEN READING DATA R
     +ECORD,I5)
      WRITE(6,1004)JD
      WRITE(6,1009) NUMEX,ICODE
 1009 FORMAT(9H NUMEX = ,I5,11H   ICODE = ,I5/1X,80(1H-))
      WRITE(IW15,1008) NCARD
      WRITE(IW15,1004)JD
      WRITE(IW15,1009) NUMEX,ICODE
      WRITE(IWS,1008) NCARD
      WRITE(IWS,1004)JD
      WRITE(IWS,1009) NUMEX,ICODE
  500 CONTINUE
C *** ECHO REST OF THE DATA AND TERMINATE WITH ERROR
  501 READ(LUN,1000)JD
      WRITE(6,1011)JD
 1011 FORMAT(1X,130A1)
      GO TO 501
C
      END
      SUBROUTINE FIXX2(IW6,NEL,NTPE,NDIM,NPL,LV,NCORR,LTYP,MUMAX,NNZ,
     +                 NP1,NP2,MREL,NREL,V,NFX,NFZ)
C***********************************************************************
C     ROUTINE TO MAINTAIN A LIST OF NODAL FIXITIES. INTERPRETS
C     FIXITIES ALONG ELEMENT EDGES INTO NODAL FIXITIES
C***********************************************************************
CF    CHARACTER*1 JDO
      INTEGER TF
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),MREL(MUMAX),NREL(NNZ)
      DIMENSION IND(5),FV(5),V(LV),NP1(NPL),NP2(NPL)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /POINT / IPT(6),KPT(6)
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      NDIM1=NDIM+1
      IF(NFX.EQ.0)RETURN
      WRITE(IW6,900)
C-----------------------------------------------------------------------
C     LOOP ON ALL FIXED EDGES I.E. EDGES WITH PRESCRIBED
C     DISPLACEMENT/EXCESS PORE PRESSURES
C-----------------------------------------------------------------------
      NTM=LV+5
      DO 200 JX=1,NFX
      CALL FFIN(NTM,31)
      ML=IFIX(AR(1))
      ND1=IFIX(AR(2))
      ND2=IFIX(AR(3))
      IVAR=IFIX(AR(4))
      IFX=IFIX(AR(5))
C----------STORAGE LOCATION FOR VARIABLE
      LVAR=KPT(IVAR)
C
      DO 10 IV=1,LV
   10 V(IV)=AR(IV+5)
      WRITE(6,902)JX,ML,ND1,ND2,IVAR,IFX,V
      NE=MREL(ML)
      LI1=NREL(ND1)
      LI2=NREL(ND2)
      LT=LTYP(NE)
      LT=IABS(LT)
      NVN=LINFO(2,LT)
      NEDG=LINFO(3,LT)
      NMID=LINFO(7,LT)
      IF(IVAR.EQ.NDIM1)NMID=LINFO(8,LT)
      NSDN=NMID+2
      INDED=LINFO(14,LT)
C
      DO 20 K1=1,NEDG
      J1=NP1(K1+INDED)
      J2=NP2(K1+INDED)
      I1=NCORR(J1,NE)
      I2=NCORR(J2,NE)
      IF(LI1.EQ.I1.AND.LI2.EQ.I2)GO TO 25
      IF(LI1.EQ.I2.AND.LI2.EQ.I1)GO TO 21
   20 CONTINUE
      WRITE(IW6,903)JX,ML,ND1,ND2
      WRITE(IW15,903)JX,ML,ND1,ND2
      WRITE(IWS,903)JX,ML,ND1,ND2
      GOTO 200
C-----------------------------------------------------------------------
C     ALIGN END NODES OF EDGE IN CORRECT SEQUENCE. (ANTICLOCKWSIE
C     OREDER ABOUT ELEMENT CENTRE)
C-----------------------------------------------------------------------
   21 LIT=LI1
      LI1=LI2
      LI2=LIT
      NT=ND1
      ND1=ND2
      ND2=NT
C
      DO 24 J=1,NSDN
      JBACK=NSDN+1-J
   24 FV(J)=V(JBACK)
      GO TO 35
C
   25 DO 30 J=1,NSDN
   30 FV(J)=V(J)
C-----------------------------------------------------------------------
C     IND - LIST OF NODES ALONG EDGE. START WITH END NODES
C-----------------------------------------------------------------------
   35 IND(1)=LI1
      IND(NSDN)=LI2
      IF(NSDN.EQ.2)GO TO 42
      LC1=NVN+(K1-1)*NMID
      IF(IVAR.EQ.NDIM1)LC1=LINFO(5,LT)+(K1-1)*NMID
C-----------------------------------------------------------------------
C     INTERMEDIATE NODES (IF NSDN=2 NO INTERMEDIATE NODES)
C-----------------------------------------------------------------------
      DO 40 JP=1,NMID
      ILC=LC1+JP
   40 IND(JP+1)=NCORR(ILC,NE)
C-----------------------------------------------------------------------
C     LOOP ON ALL NODES ALONG EDGE
C-----------------------------------------------------------------------
   42 DO 100 KND=1,NSDN
      I=IND(KND)
      IF(NF.EQ.0)GO TO 58
      IF(NF.GT.NFZ) GO TO 100
C
      DO 50 J=1,NF
      IF(I.EQ.MF(J))GO TO 55
   50 CONTINUE
C
      GO TO 58
C-----------------------------------------------------------------------
C     UPDATE EXISTING VALUES
C-----------------------------------------------------------------------
   55 JF=J
      GO TO 60
C
   58 NF=NF+1
      IF(NF.LE.NFZ)GO TO 59
      GO TO 100
   59 JF=NF
   60 MF(JF)=I
      TF(LVAR,JF)=IFX
      DXYT(LVAR,JF)=FV(KND)
  100 CONTINUE
  200 CONTINUE
      IF(NF.GT.NFZ) THEN
         WRITE(IW6,904)NF
         WRITE(IW15,904)NF
         WRITE(IWS,904)NF
         STOP
      ENDIF
      RETURN
  900 FORMAT(/1X,4HSIDE,4X,7HELEMENT,3X,5HNODE1,3X,5HNODE2,
     + 3X,3HDOF,3X,11HFIXITY CODE,6X,4HVAL1,6X,4HVAL2,6X,4HVAL3,
     + 6X,4HVAL4,6X,4HVAL5/)
  902 FORMAT(1X,I3,4X,I5,5X,I4,4X,I4,5X,I2,12X,I3,3X,5F10.3)
  903 FORMAT(/13H **** ERROR -,I5,16H TH FIX. ELEMENT,
     + I5,25H DOES NOT CONTAIN NODES -,2I5,2X,15H(ROUTINE FIXX2))
  904 FORMAT(/1X,'INCREASE SIZE OF ARRAYS  MF,  TF  AND  DXYT  TO',I8,
     + 4X,'IN COMMON BLOCK  FIX'/5X,
     + 'ALSO RESET  MXFXT  IN ROUTINE  MAXVAL  (ROUTINE FIXX2)')
      END
      SUBROUTINE FIXX2B(IW6,NNZ,NREL,NFXB,NFZ)
C***********************************************************************
C     ROUTINE TO READ DIRECTLY A LIST OF NODAL FIXITIES.
C***********************************************************************
CF    CHARACTER*1 JDO
      INTEGER TF
      DIMENSION NREL(NNZ)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /POINT / IPT(6),KPT(6)
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      IF(NFXB.EQ.0)RETURN
      WRITE(IW6,900)
  900 FORMAT(/1X,4HNODE,3X,3HDOF,3X,11HFIXITY CODE,6X,5HVALUE/)
C-----------------------------------------------------------------------
      DO 200 JX=1,NFXB
      CALL FFIN(4,7)
      ND=IFIX(AR(1))
      IVAR=IFIX(AR(2))
      IFX=IFIX(AR(3))
      V=AR(4)
C----------STORAGE LOCATION FOR VARIABLE
      LVAR=KPT(IVAR)
C
      IF(NREL(ND).GT.0)GOTO 40
      WRITE(IW6,903)JX,ND
      WRITE(IW15,903)JX,ND
      WRITE(IWS,903)JX,ND
      STOP
C
   40 NDP=NREL(ND)
      WRITE(IW6,902)ND,IVAR,IFX,V
  902 FORMAT(1X,I3,4X,I5,5X,I4,5X,F10.3)
C
      DO 50 J=1,NF
      IF(NDP.EQ.MF(J))GO TO 55
   50 CONTINUE
C
      GO TO 58
C-----------------------------------------------------------------------
C     UPDATE EXISTING VALUES
C-----------------------------------------------------------------------
   55 JF=J
      GO TO 60
C
   58 NF=NF+1
      IF(NF.LE.NFZ)GO TO 59
      GO TO 100
   59 JF=NF
   60 MF(JF)=NDP
      TF(LVAR,JF)=IFX
      DXYT(LVAR,JF)=V
  100 CONTINUE
  200 CONTINUE
      IF(NF.GT.NFZ) THEN
         WRITE(IW6,904)NF
         WRITE(IW15,904)NF
         WRITE(IWS,904)NF
         STOP
      ENDIF
      RETURN
  903 FORMAT(/13H **** ERROR -,I5,13H TH FIX. NODE,
     + I5,20H NOT PRESENT IN MESH,I5,2X,15H(ROUTINE FIXX2))
  904 FORMAT(/43H INCREASE SIZE OF ARRAYS MF, TF AND DXYT TO,I8,
     + 4X,19HIN COMMON BLOCK FIX/5X,
     + 51HALSO RESET MXFXT IN ROUTINE MAXVAL (ROUTINE FIXX2B))
      END
      SUBROUTINE FIXX3(IW6,NEL,NTPE,NDIM,NPL,LV,NCORR,LTYP,MUMAX,NNZ,
     +                 NP1,NP2,MREL,NREL,V,NFX,NFZ)
C***********************************************************************
C     ROUTINE TO MAINTAIN A LIST OF NODAL FIXITIES. INTERPRETS
C     FIXITIES ALONG (3-D) ELEMENT FACE INTO NODAL FIXITIES
C     AT PRESENT TO CATER FOR THE 3-D BRICK ELEMENTS ONLY
C***********************************************************************
CF    CHARACTER*1 JDO
      INTEGER TF
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),MREL(MUMAX),NREL(NNZ)
      DIMENSION IND(8),FV(8),V(LV),NP1(NPL),NP2(NPL)
      DIMENSION KX(96),NDU(8),NDP(8),NXC(4),NXM(4),KNL(8)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /POINT / IPT(6),KPT(6)
      COMMON /DEVSUP/ IW14,IW15,IWS
      DATA KX(1),KX(2),KX(3),KX(4),KX(5),KX(6),KX(7),KX(8),KX(9),
     + KX(10),KX(11),KX(12),KX(13),KX(14),KX(15),KX(16),KX(17),
     + KX(18),KX(19),KX(20),KX(21),KX(22),KX(23),KX(24),KX(25),
     + KX(26),KX(27),KX(28),KX(29),KX(30),KX(31),KX(32),KX(33),
     + KX(34),KX(35),KX(36),KX(37),KX(38),KX(39),KX(40),KX(41),
     + KX(42),KX(43),KX(44),KX(45),KX(46),KX(47),KX(48)/
     + 1,2,3,4,9,10,11,12,6,5,8,7,13,16,15,14,1,5,6,2,17,13,18,9,
     + 2,6,7,3,18,14,19,10,4,3,7,8,11,19,15,20,5,1,4,8,17,12,20,16/
C
      DATA KX(49),KX(50),KX(51),KX(52),KX(53),KX(54),KX(55),KX(56),
     + KX(57),KX(58),KX(59),KX(60),KX(61),KX(62),KX(63),KX(64),KX(65),
     + KX(66),KX(67),KX(68),KX(69),KX(70),KX(71),KX(72),KX(73),
     + KX(74),KX(75),KX(76),KX(77),KX(78),KX(79),KX(80),KX(81),
     + KX(82),KX(83),KX(84),KX(85),KX(86),KX(87),KX(88),KX(89),
     + KX(90),KX(91),KX(92),KX(93),KX(94),KX(95),KX(96)/
     + 1,4,3,2,12,11,10,9,5,6,7,8,13,14,15,16,2,6,5,1,18,13,17,9,
     + 3,7,6,2,19,14,18,10,4,8,7,3,20,15,19,11,8,4,1,5,20,12,17,16/
C
      DO 5 IU=1,8
      KNL(IU)=0
      NDU(IU)=0
      NDP(IU)=0
    5 CONTINUE
C
      NDIM1=NDIM+1
      IF(NFX.EQ.0)RETURN
      WRITE(IW6,900)
C-----------------------------------------------------------------------
C     IF NEW 3-D ELEMENT TYPES ARE ADDED THEN NC, NFCD
C     AND LVL (= NFCD) SHOULD BE OBTAINED FROM ARRAY LINFO
C     IN ORDER TO MAKE THE ROUTINE GENERAL.
C---------- NC - NUMBER OF VERTEX NODES IN A FACE
C---------- NFCD - TOTAL NUMBER OF DISPLACEMENT NODES IN A FACE
      NC=4
      NFCD=8
C-----------------------------------------------------------------------
C     LOOP ON ALL FIXED FACES I.E. FACES WITH PRESCRIBED
C     DISPLACEMENT/EXCESS PORE PRESSURES
C-----------------------------------------------------------------------
      LVL=NFCD
      NTM=LVL+7
      DO 200 JX=1,NFX
CC    WRITE(IW6,880)
CC880 FORMAT(/120(1H-))
      CALL FFIN(NTM,127)
      ML=IFIX(AR(1))
C
      DO 10 IN=1,NC
   10 NDU(IN)=IFIX(AR(IN+1))
      IVAR=IFIX(AR(6))
      IFX=IFIX(AR(7))
C----------STORAGE LOCATION FOR VARIABLE
      LVAR=KPT(IVAR)
C
      DO 20 IV=1,LVL
   20 FV(IV)=AR(IV+7)
      WRITE(6,902)JX,ML,(NDU(J),J=1,NC),IVAR,IFX,(FV(K),K=1,LVL)
      NE=MREL(ML)
C
      DO 30 IN=1,NC
      ND=NDU(IN)
   30 NDP(IN)=NREL(ND)
CC    WRITE(IW6,801)NDU
CC801 FORMAT(/1X,3HNDU,2X,8I5)
CC    WRITE(IW6,802)NDP
CC802 FORMAT(/1X,3HNDP,2X,8I5)
CC    WRITE(IW6,803)ML,NE
CC803 FORMAT(/1X,7HELEMENT,2I5)
C
      LT=LTYP(NE)
      LT=IABS(LT)
      NFAC=LINFO(4,LT)
      NFAC2=2*NFAC
CC    WRITE(IW6,810)LT,NFAC
CC810 FORMAT(/1X,4HLT =,I5,2X,6HNFAC =,I5)
C----------- LOOP ON ALL FACES OF ELEMENT
      DO 90 IFAC=1,NFAC2
      ISX=NFCD*(IFAC-1)
C----------- GET INDEXES OF NODES TO NCORR
      DO 40 IN=1,NC
      NXC(IN)=KX(ISX+IN)
C----------- IF NOT PORE-PRESSURE D.O.F., ADDITIONAL NODES ALONG EDGE
C----------- ARE PRESENT
      IF(IVAR.NE.NDIM1)NXM(IN)=KX(ISX+NC+IN)
   40 CONTINUE
CC    WRITE(IW6,820)NXC,NXM
CC820 FORMAT(/1X,3HNXC,4I5,2X,3HNXM,4I5)
C---------- GET VERTEX NODES OF FACE FROM NCORR
      DO 50 IN=1,NC
      IP=NXC(IN)
   50 KNL(IN)=NCORR(IP,NE)
CC    WRITE(IW6,830)KNL
CC830 FORMAT(/1X,3HKNL,8I5)
C---------- LOOP ON ALL STARTING NODES
      DO 80 IS=1,NC
      ISV=IS
C---------- TRY MATCHING THE NODES
      DO 60 IN=1,NC
      IF(NDP(IN).NE.KNL(IN))GOTO 65
   60 CONTINUE
      GOTO 95
C----------START WITH THE NEXT NODE.  THE SEQUENCE OF
C----------THE NODES ARE STILL THE SAME
   65 CALL ALTER(IW6,KNL,NC)
CC    WRITE(IW6,860)KNL
CC860 FORMAT(1X,8HSORT KNL,8I5)
   80 CONTINUE
   90 CONTINUE
C---------- FACE NOT FOUND
      WRITE(IW6,930)JX,ML,(NDU(J),J=1,NC)
      WRITE(IW15,930)JX,ML,(NDU(J),J=1,NC)
      WRITE(IWS,930)JX,ML,(NDU(J),J=1,NC)
C
      GOTO 200
C
   95 IF(ISV.EQ.1)GOTO 105
      IS1=ISV-1
C---------- SORT THE INDEXES TO MATCH WITH NODE SEQUENCE KNL
      DO 100 IM=1,IS1
      CALL ALTER(IW6,NXC,NC)
      IF(IVAR.NE.NDIM1)CALL ALTER(IW6,NXM,NC)
  100 CONTINUE
C---------- IF PORE PRESSURE FIXITY
  105 CONTINUE
      IF(IVAR.NE.NDIM1)GOTO 125
C
      DO 120 IL=1,NC
      IP=NXC(IL)
  120 IND(IL)=NCORR(IP,NE)
CC    WRITE(IW6,850)IND
CC850 FORMAT(/1X,3HIND,8I5)
      NSDN=NC
      GOTO 132
C----------- IF DISPLACEMENT FIXITY
  125 DO 130 IL=1,NC
      IM=NXC(IL)
      IN=NXM(IL)
      IND(2*IL-1)=NCORR(IM,NE)
  130 IND(2*IL)=NCORR(IN,NE)
CC    WRITE(IW6,870)IND
CC870 FORMAT(/1X,5HFOUND,2X,8I5)
      NSDN=NFCD
  132 CONTINUE
C-----------------------------------------------------------------------
C     LOOP ON ALL NODES ALONG FACE
C-----------------------------------------------------------------------
      DO 180 KND=1,NSDN
      I=IND(KND)
      IF(NF.EQ.0)GO TO 158
      IF(NF.GT.NFZ) GO TO 180
C
      DO 150 J=1,NF
      IF(I.EQ.MF(J))GO TO 155
  150 CONTINUE
C
      GO TO 158
C-----------------------------------------------------------------------
C     UPDATE EXISTING VALUES
C-----------------------------------------------------------------------
  155 JF=J
      GO TO 160
C
  158 NF=NF+1
      IF(NF.LE.NFZ)GO TO 159
      GO TO 180
  159 JF=NF
  160 MF(JF)=I
      TF(LVAR,JF)=IFX
      DXYT(LVAR,JF)=FV(KND)
  180 CONTINUE
CC    WRITE(IW6,700)NF
CC700 FORMAT(/1X,28HNO. OF NODES WITH FIXITIES =,I5)
CC    WRITE(IW6,710)(MF(IK),IK=1,NF)
CC710 FORMAT(/1X,2HMF/(1X,20I5))
CC    WRITE(IW6,720)((TF(IR,IK),IR=1,4),IK=1,NF)
CC720 FORMAT(/1X,2HTF/(1X,20I5))
CC    WRITE(IW6,730)((DXYT(IR,IK),IR=1,4),IK=1,NF)
CC730 FORMAT(/1X,4HDXYT/(1X,16F8.3))
  200 CONTINUE
      IF(NF.GT.NFZ) THEN
         WRITE(IW6,904)NF
         WRITE(IW15,904)NF
         WRITE(IWS,904)NF
         STOP
      ENDIF
      RETURN
  900 FORMAT(/19X,16H......NODES.....,8X,6HFIXITY/
     + 1X,4HFACE,4X,7HELEMENT,3X,16H1    2    3    4,
     + 3X,3HDOF,3X,4HCODE,5X,4HVAL1,5X,4HVAL2,5X,4HVAL3,
     + 5X,4HVAL4,5X,4HVAL5,5X,4HVAL6,5X,4HVAL7,5X,4HVAL8/)
  902 FORMAT(1X,I3,4X,I5,3X,I4,1X,I4,1X,I4,1X,I4,4X,I2,3X,I3,3X,8F9.3)
  930 FORMAT(/1X,20H***** ERROR - FIXITY,I4,2X,8HIN LIST.,3X,
     + 7HELEMENT,I5,2X,29HDOES NOT HAVE FACE WITH NODES,4I5)
  904 FORMAT(/43H INCREASE SIZE OF ARRAYS MF, TF AND DXYT TO,I8,
     + 4X,19HIN COMMON BLOCK FIX/5X,
     + 50HALSO RESET MXFXT IN ROUTINE MAXVAL (ROUTINE FIXX3))
CC905 FORMAT(/1X,15HERROR - ELEMENT,I5,2X,19HNOT PRESENT IN MESH)
      END
      SUBROUTINE ALTER(IW6,IM,N)
C---------- ROUTINE TO SHIFT ARRAY FORWARD BY ONE PLACE
      DIMENSION IM(N)
C
      IF(N.LE.1)GOTO 100
      NM1=N-1
      IMT=IM(1)
C
      DO 10 K=1,NM1
   10 IM(K)=IM(K+1)
      IM(N)=IMT
      RETURN
  100 WRITE(IW6,900)N
  900 FORMAT(/1X,26HERROR * ARRAY CONTAINS LE ,I5,2X,
     1 40HMEMBERS  (ROUTINE ALTER) CALLED BY FIXX3)
      RETURN
      END
      SUBROUTINE FLOWST(J,NDIM,NPN,NS,NB,NAC,
     +                  B,E,RN,AA,CARTD,DS,LL,LT,IP,ISTGE)
C***********************************************************************
C     CALCULATES SHAPE FUNCTIONS AND DERIVATIVES
C     FOR EXCESS PORE PRESSURE VARIATION
C     ROUTINE LAST UPDATED ON 5/11/88
C***********************************************************************
      REAL LL
      DIMENSION CARTD(NDIM,NPN),
     + DS(NDIM,NPN),B(NS,NB),AA(NPN),RN(NB),E(NDIM,NPN),LL(NAC)
      COMMON /FLOW  / NPLAX
C
      CALL FORMP(J,NDIM,NPN,NAC,CARTD,
     +           AA,DS,LL,LT,IP,ISTGE)
C
C *** FORM RN
      NCOM=NDIM
      IF(NPLAX.EQ.1.AND.NCOM.EQ.2)NCOM=NDIM+1
      DO 30 IB=1,NB
      SUM=0.
      DO 20 ID=1,NCOM
   20 SUM=SUM+B(ID,IB)
   30 RN(IB)=SUM
C
C *** FORM E
      DO 50 IN=1,NPN
      DO 50 ID=1,NDIM
   50 E(ID,IN)=CARTD(ID,IN)
      RETURN
      END
      SUBROUTINE FOMFBM(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +                  NDN,NVRS,VARINT,ELCOD,F)
C
C***********************************************************************
C     CALCULATES F MATRIX (LOAD VECTOR) EQUIVALENT TO ELEMENT STRESSES
C     FOR 3-NODED BEAM ELEMENT (LT = 12)
C***********************************************************************
C
      REAL L
      DIMENSION VARINT(NVRS,NIP,NEL),ELCOD(NDIM,NDN),F(NDIM,NDN)
      DIMENSION SHF(9),DER(9),B(2,9),BN(2,9),T(3,3)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/IW14,IW15,IWS
C
      CALL ROTAT(ELCOD,NDIM,NDN,DL,T)
C----------NUMBER OF D.O.F IN ELEMENT
      NDOF=9
C
      DO 100 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBM(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 30 IN=1,3
   30 DJACB=DJACB+DER(3*IN-2)*ELCOD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,900)MUS,IP,DJACB
  900    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         WRITE(IW15,900)MUS,IP,DJACB
         WRITE(IWS,900)MUS,IP,DJACB
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
C
      DO 40 J=1,9
      DO 40 I=1,2
      B(I,J)=ZERO
   40 BN(I,J)=ZERO
C----------CALCULATE B MATRIX
      B(1,1)=-DER(1)/DJACB
      B(1,4)=-DER(4)/DJACB
      B(1,7)=-DER(7)/DJACB
C
      B(2,2)=-DER(2)/(DJACB**2)
      B(2,3)=-DER(3)/(DJACB**2)
      B(2,5)=-DER(5)/(DJACB**2)
      B(2,6)=-DER(6)/(DJACB**2)
      B(2,8)=-DER(8)/(DJACB**2)
      B(2,9)=-DER(9)/(DJACB**2)
C----------TRANSFORM CO-ORDINATE SYSTEM
      DO 60 IN=1,3
      DO 50 I=1,2
      DO 50 J=1,3
      NJ=3*(IN-1)+J
      DO 50 K=1,2
      NK=3*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   50 CONTINUE
   60 CONTINUE
C
      DO 80 IN=1,3
      DO 70 ID=1,2
      DO 70 J=1,2
      IND=3*(IN-1)+ID
      F(ID,IN)=F(ID,IN)+B(J,IND)*VARINT(J,IP,JJ)*FAC
   70 CONTINUE
   80 CONTINUE
  100 CONTINUE
C
CC    WRITE(IW6,920)MUS,((F(I,J),J=1,3),I=1,2)
CC920 FORMAT(/1X,'ELEMENT',I5,4X,'F'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE FOMFBR(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +                  NDN,NVRS,VARINT,ELCOD,F)
C
C***********************************************************************
C     CALCULATES F MATRIX (LOAD VECTOR) EQUIVALENT TO ELEMENT STRESSES
C     FOR BAR ELEMENT (LT = 1)
C***********************************************************************
C
      REAL L
      DIMENSION VARINT(NVRS,NIP,NEL),ELCOD(NDIM,NDN),F(NDIM,NDN)
      DIMENSION SHF(3),DER(3),B(3),BN(6),T(3,3)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/IW14,IW15,IWS
C
      CALL ROTAT(ELCOD,NDIM,NDN,DL,T)
C----------NUMBER OF D.O.F IN ELEMENT
      NDOF=3
C
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBR(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 30 IN=1,3
   30 DJACB=DJACB+DER(IN)*ELCOD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,900)MUS,IP,DJACB
  900    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         WRITE(IW15,900)MUS,IP,DJACB
         WRITE(IWS,900)MUS,IP,DJACB
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
C
      DO 40 J=1,3
      B(J)=ZERO
      BN(2*J-1)=ZERO
   40 BN(2*J)=ZERO
C----------CALCULATE B MATRIX
      DO 50 I=1,3
   50 B(I)=-DER(I)/DJACB
C
      DO 60 I=1,3
      BN(2*I-1)=B(I)*T(1,1)
      BN(2*I)=B(I)*T(2,1)
   60 CONTINUE
C
      DO 80 IN=1,3
      DO 70 ID=1,2
      F(ID,IN)=F(ID,IN)+B(IN)*VARINT(ID,IP,JJ)*FAC
   70 CONTINUE
   80 CONTINUE
  200 CONTINUE
CC    WRITE(IW6,920)MUS,((F(I,J),J=1,3),I=1,2)
CC920 FORMAT(/1X,'ELEMENT',I5,4X,'F'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE FOMFSL(IW6,JJ,MUS,NGP,NIP,INDX,NEL,NDIM,NDMX,
     +                  NDN,NVRS,VARINT,ELCOD,F,THICK)
C
C************************************************************************
C     CALCULATES F MATRIX (LOAD VECTOR) EQUIVALENT TO ELEMENT STRESSES
C     FOR SLIP ELEMENT (LT = 13)
C     LAST MODIFIED ON 1/6/88
C************************************************************************
C
      REAL L
      DIMENSION VARINT(NVRS,NIP,NEL),ELCOD(NDIM,NDN),F(NDIM,NDN)
      DIMENSION SHF(3),DER(3),B(3,12),BN(3,12),COD(2,6),T(3,3)
      COMMON CODS(2,6)
      COMMON /FLOW / NPLAX
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/IW14,IW15,IWS
C
      CR=1.
      IF(NPLAX.EQ.1) CR=2.*PYI
C
      COD(1,1)=ELCOD(1,1)
      COD(2,1)=ELCOD(2,1)
      COD(1,2)=ELCOD(1,2)
      COD(2,2)=ELCOD(2,2)
      COD(1,3)=ELCOD(1,5)
      COD(2,3)=ELCOD(2,5)
C
      COD(1,4)=ELCOD(1,4)
      COD(1,5)=ELCOD(1,3)
      COD(1,6)=ELCOD(1,7)
C
      DO 20 I=1,2
      DO 20 J=1,6
   20 CODS(I,J)=COD(I,J)
C
      CALL ROTAT(COD,NDIM,3,DL,T)
C
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      SHF(1)=XI*(XI-1.)/2.
      SHF(2)=XI*(XI+1.)/2.
      SHF(3)=(1.+XI)*(1.-XI)
C
C--------CALCULATE X (OR R)
      R=0.
      DO 50 I=1,3
      R=R+0.5*SHF(I)*CODS(1,I)+0.5*SHF(I)*CODS(1,I+3)
   50 CONTINUE
C
      DER(1)=(2.*XI-1.)/2.
      DER(2)=(2.*XI+1.)/2.
      DER(3)=-2.*XI
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,3
   60 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)MUS,IP,DJACB
  910    FORMAT(/1X,'****ERROR : JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         WRITE(IW15,910)MUS,IP,DJACB
         WRITE(IWS,910)MUS,IP,DJACB
         STOP
      ENDIF
C
      FAC=CR*DJACB*W(IPA)*THICK
      IF(NPLAX.EQ.1) FAC=FAC*R
CC    WRITE(6,710)SHF,DER
CC710 FORMAT(/1X,'SHF AND DER'/(1X,9E14.5))
C
      DO 70 IS=1,3
      DO 70 IN=1,12
      B(IS,IN)=ZERO
   70 BN(IS,IN)=ZERO
C----------CALCULATE B MATRIX
      B(1,2)= SHF(1)/THICK
      B(1,4)= SHF(2)/THICK
      B(1,6)=-SHF(2)/THICK
      B(1,8)=-SHF(1)/THICK
      B(1,10)= SHF(3)/THICK
      B(1,12)=-SHF(3)/THICK
C
      B(2,1)= SHF(1)/THICK
      B(2,3)= SHF(2)/THICK
      B(2,5)=-SHF(2)/THICK
      B(2,7)=-SHF(1)/THICK
      B(2,9)= SHF(3)/THICK
      B(2,11)=-SHF(3)/THICK
C
      IF(NPLAX.EQ.1) THEN
         BN(3,1)=-SHF(1)/(R)
         BN(3,3)=-SHF(2)/(R)
         BN(3,5)=-SHF(2)/(R)
         BN(3,7)=-SHF(1)/(R)
         BN(3,9)=-SHF(3)/(R)
         BN(3,11)=-SHF(3)/(R)
      ENDIF
C
      DO 90 IN=1,6
C
      DO 80 I=1,2
      DO 80 J=1,2
      NJ=2*(IN-1)+J
      DO 80 K=1,2
      NK=2*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   80 CONTINUE
   90 CONTINUE
C
C----------CALCULATE COMPONENTS OF F
C
      DO 140 IN=1,6
      DO 120 ID=1,2
      DO 120 J=1,2
      IND=2*(IN-1)+ID
      KN=IN
      IF(IN.EQ.6)KN=7
      IF(J.EQ.1)F(ID,KN)=F(ID,KN)+BN(J,IND)*(VARINT(J+5,IP,JJ)
     +        +VARINT(5,IP,JJ))*FAC
      IF(J.EQ.2)F(ID,KN)=F(ID,KN)+BN(J,IND)*VARINT(J+5,IP,JJ)*FAC
  120 CONTINUE
  140 CONTINUE
  200 CONTINUE
C
CC    WRITE(IW6,920)MUS,((F(I,J),J=1,8),I=1,2)
CC920 FORMAT(/1X,'ELEMENT',I5,4X,'F'/(1X,4E20.5))
      RETURN
      END
      SUBROUTINE FORMB2(J,MUS,R,RI,NDIM,NDMX,NDN,NS,NB,NAC,
     +                  B,ELCOD,CARTD,SHFN,DS,LL,LT,IP,ISTGE)
C***********************************************************************
C     FORMS  B  MATRIX  FOR  AREA/LOCAL  COORDS  LL(NAC)
C     IN  ELEMENT  J FOR INTEGRATION POINT IP
C     ROUTINE LAST MODIFIED ON 15/11/86
C***********************************************************************
      REAL LL
      DIMENSION ELCOD(NDIM,NDMX),DS(NDIM,NDMX),CARTD(NDIM,NDMX),
     +          SHFN(NDMX),XJACM(3,3),B(NS,NB),LL(NAC)
CC   +          SHFN(NDMX),B(NS,NB),LL(NAC)
      COMMON /FLOW  / NPLAX
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /JACB  / XJACI(3,3),DJACB
C-----------------------------------------------------------------------
C     INITIALISE SHAPE FUNCTION AND DERIVATIVES (LOCAL COORDS)
C-----------------------------------------------------------------------
      CALL ZEROR2(DS,NDIM,NDMX)
      CALL ZEROR1(SHFN,NDMX)
      CALL ZEROR2(B,NS,NB)
C
      CALL SHAPE(IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,2)
      CALL ZEROR2(XJACM,NDIM,NDIM)
C
CC    WRITE(IW6,801)ELCOD
CC801 FORMAT(/1X,5HELCOD/(1X,6F10.3))
CC    WRITE(IW6,802)LL
CC802 FORMAT(/1X,2HLL/(1X,4F12.4))
CC    WRITE(IW6,803)DS
CC803 FORMAT(/1X,2HDS/(1X,6F10.3))
      NDN2=2*NDN
      DO 15 IDIM=1,NDIM
      DO 15 JDIM=1,NDIM
      SUM=ZERO
      DO 12 IN=1,NDN
   12 SUM=SUM+DS(IDIM,IN)*ELCOD(JDIM,IN)
   15 XJACM(IDIM,JDIM)=SUM
CC    WRITE(IW6,804)XJACM
CC804 FORMAT(/1X,5HXJACM/(1X,4F15.5))
C
      CALL DETMIN(IW6,XJACM,XJACI,NDIM,DJACB,MUS,IP,ISTGE)
CC    WRITE(IW6,902)DJACB
CC902 FORMAT(9H JACOBIAN,2X,E16.5)
C-----------------------------------------------------------------------
C     CALCULATE  RADIUS  FOR  AXI-SYM  B  MATRIX
C-----------------------------------------------------------------------
      R=ZERO
      RI=ZERO
      IF(NPLAX.EQ.0)GOTO 28
      DO 25 IN=1,NDN
   25 R=R+ELCOD(1,IN)*SHFN(IN)
      RI=-1.0/R
C
   28 DO 35 IN=1,NDN
      DO 35 ID=1,NDIM
      SUM=ZERO
      DO 30 JD=1,NDIM
   30 SUM=SUM-DS(JD,IN)*XJACI(ID,JD)
   35 CARTD(ID,IN)=SUM
C
      IF(NDIM.NE.2)GOTO 52
C-----------------------------------------------------------------------
C     2 - D ELEMENT
C-----------------------------------------------------------------------
      DO 50 IN=1,NDN
      B(1,IN)=CARTD(1,IN)
      B(2,NDN+IN)=CARTD(2,IN)
      IF(NPLAX.EQ.0)GOTO 45
      B(3,IN)=SHFN(IN)*RI
   45 B(4,NDN+IN)=B(1,IN)
   50 B(4,IN)=B(2,NDN+IN)
C
   52 IF(NDIM.NE.3)GOTO 62
C-----------------------------------------------------------------------
C     3 - D ELEMENT
C-----------------------------------------------------------------------
      DO 60 IN=1,NDN
      B(1,IN)=CARTD(1,IN)
      B(2,NDN+IN)=CARTD(2,IN)
      B(3,NDN2+IN)=CARTD(3,IN)
      B(4,IN)=CARTD(2,IN)
      B(4,NDN+IN)=CARTD(1,IN)
      B(5,NDN+IN)=CARTD(3,IN)
      B(5,NDN2+IN)=CARTD(2,IN)
      B(6,IN)=CARTD(3,IN)
      B(6,NDN2+IN)=CARTD(1,IN)
   60 CONTINUE
C
   62 CONTINUE
      RETURN
      END
      SUBROUTINE FORMP(J,NDIM,NPN,NAC,CARTD,
     +                 SHFP,DS,LL,LT,IP,ISTGE)
C***********************************************************************
C     FORMS  CARTD  MATRIX  FOR  AREA/LOCAL  COORDS  LL(NAC)
C     IN  ELEMENT  J FOR INTEGRATION POINT IP
C     ROUTINE LAST UPDATED ON 15/11/86
C     (5/11/88)
C***********************************************************************
      REAL LL
      DIMENSION LL(NAC)
      DIMENSION DS(NDIM,NPN),CARTD(NDIM,NPN),SHFP(NPN)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /JACB  / XJACI(3,3),DJACB
C-----------------------------------------------------------------------
C     CALCULATE SHAPE FUNCTION AND DERIVATIVES (LOCAL COORDS)
C-----------------------------------------------------------------------
      CALL SHFNPP(IW6,LL,NAC,DS,SHFP,NDIM,NPN,LT,1)
CC    WRITE(IW6,920)IP,(SHFP(JU),JU=1,NPN)
CC920 FORMAT(/1X,16HSHFP FOR PP IP =,I5/(1X,8E12.4))
C
      DO 35 IN=1,NPN
      DO 35 ID=1,NDIM
      SUM=0.
      DO 30 JD=1,NDIM
   30 SUM=SUM-DS(JD,IN)*XJACI(ID,JD)
   35 CARTD(ID,IN)=SUM
CC    WRITE(IW6,910)IP,((CARTD(IU,JU),JU=1,NPN),IU=1,NDIM)
CC910 FORMAT(/1X,17HCARTD FOR PP IP =,I5/(1X,8E12.4))
      RETURN
      END
      SUBROUTINE FRONTZ(MAXPA,DTIME,NN,MXDF,NEL,NDF,NTPE,NIP,
     + NPR,NMT,KES,NS,NB,NDIM,NDMX,NVRS,NPMX,INXL,MDFE,IFRZ,KSS,
     + XYZ,DI,DA,P,PCOR,REAC,VARINT,NCORR,
     + NQ,KGVN,NMOD,KDF,ES,NL,IFR,NDL,
     + ELCOD,CARTD,SHFN,DS,D,B,DB,SS,E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NRELVV,LTYP,MRELVV,NDEST,MAT,IDFX,NWL,LL,
     + PR,NTY,ELPA,MFZ,FRACLD,IOPBC)
C***********************************************************************
C     FRONTAL SOLUTION FOR SYMMETRIC MATRICES WITH
C     NDFN DEGREES OF FREEDOM PER NODE
C     PORE PRESSURE FIXITY CODE 3 IMPLEMENTED 28 AUGUST 92
C***********************************************************************
      REAL LL
      CHARACTER*4 IWR,MBUF
      INTEGER TF
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),
     + P(NDF),VARINT(NVRS,NIP,NEL),PCOR(NDF),REAC(NDF)
      DIMENSION NCORR(NTPE,NEL),NQ(NN),KGVN(MXDF,NN),NMOD(NIP,NEL),
     + NRELVV(NN),LTYP(NEL),MRELVV(NEL),NDEST(NN),
     + MAT(NEL),IDFX(NDF),NWL(NPMX)
      DIMENSION ES(KES),NDL(MDFE),NTT(6),ELPA(MFZ),KDF(MXDF,NN)
      DIMENSION PR(NPR,NMT),LL(NL),IFR(IFRZ),E(NDIM,NPMX),
     + PE(NDIM,NPMX),RN(NB),AA(NPMX),ETE(NPMX,NPMX),RLT(NB,NPMX),
     + B(NS,NB),DS(NDIM,NDMX),ELCOD(NDIM,NDMX),CARTD(NDIM,NDMX),
     + SHFN(NDMX),NTY(NMT),D(NS,NS),DB(NS,NB),SS(KSS)
      DIMENSION CARTP(NDIM,NPMX),PORINS(NN)
      DIMENSION IBUF(6),MBUF(6),RBUF(3),IWR(4)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /POINT / IPT(6),KPT(6)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
      DATA IWR(1),IWR(2),IWR(3),IWR(4)/' FIX','ED =','  LO','AD ='/
C
      KURPA=0
      NPAR=MAXPA*(MAXPA+1)/2
      NBAX0=NPAR+2*MAXPA+1
      IBA=NBAX0
      NVABZ=0
      NBAXZ=MFZ
      INITL=1
      NDIM1=NDIM+1
      IC=0
C
CC    WRITE(IW6,801)(MF(IQ),IQ=1,NF)
CC801 FORMAT(/1X,2HMF/(1X,20I5))
CC    WRITE(IW6,802)((TF(IU,JU),IU=1,4),JU=1,NF)
CC802 FORMAT(/1X,2HTF/(1X,20I5))
CC    WRITE(IW6,803)((DXYT(IU,JU),IU=1,4),JU=1,NF)
CC803 FORMAT(/1X,4HDXYT/(1X,15F8.2))
C-----------------------------------------------------------------------
C     ZERO LIST OF FIXED D.O.F.
C-----------------------------------------------------------------------
      CALL ZEROI1(IDFX,NDF)
C-----------------------------------------------------------------------
C     LOOP ON ELEMENTS
C-----------------------------------------------------------------------
      DO 62 NE=1,NEL
      LT=LTYP(NE)
      IF(LT.LT.0.AND.NE.EQ.NEL)GO TO 61
      IF(LT.LT.0) GOTO 62
      MUS=MRELVV(NE)
C
      IF(LT.EQ.1)THEN
         CALL LSTFBR(IW6,NE,MUS,INXL,ES,KES,NN,NEL,NTPE,NPR,
     +               NMT,NDIM,XYZ,NCORR,MAT,LT,PR,NTY)
      ELSE IF(LT.EQ.12)THEN
         CALL LSTFBM(IW6,NE,MUS,INXL,ES,KES,NN,NEL,NTPE,NPR,
     +               NMT,NDIM,XYZ,NCORR,MAT,LT,PR,NTY)
      ELSE IF(LT.EQ.13)THEN
         CALL LSTSLP(IW6,NE,MUS,INXL,ES,KES,NN,NEL,NTPE,NIP,NPR,
     +               NMT,NDIM,NVRS,XYZ,VARINT,NCORR,MAT,LT,PR,NTY)
      ELSE IF(LT.EQ.14)THEN
         CALL LSFBR2(IW6,NE,MUS,INXL,ES,KES,NN,NEL,NTPE,NPR,
     +               NMT,NDIM,XYZ,NCORR,MAT,LT,PR,NTY)
      ELSE IF(LT.EQ.15)THEN
         CALL LSFBM2(IW6,NE,MUS,INXL,ES,KES,NN,NEL,NTPE,NPR,
     +               NMT,NDIM,XYZ,NCORR,MAT,LT,PR,NTY)
      ELSE
         CALL LSTIFF(NE,MUS,INXL,ES,KES,DTIME,NN,MXDF,NEL,NDF,NTPE,NIP,
     +               NPR,NMT,NS,NB,NL,NDIM,NDMX,NVRS,NPMX,KSS,XYZ,DA,P,
     +               VARINT,NCORR,KGVN,NMOD,MAT,LT,ELCOD,CARTD,
     +               SHFN,DS,D,B,DB,SS,E,PE,RN,AA,ETE,RLT,CARTP,
     +               NWL,LL,PR,NTY)
      ENDIF
C
CC    WRITE(IW6,904)NE,(ES(KL),KL=1,KES)
CC904 FORMAT(26H ELEMENT STIFFNESS MATRIX ,I5/(1X,9E14.6))
C-----------------------------------------------------------------------
C     FIND CURRENT SIZE OF GRANDPA (KURPA)
C-----------------------------------------------------------------------
      NNE=LINFO(1,LT)
      DO 10 J=1,NNE
      N=NCORR(J,NE)
      NA=IABS(N)
      NDFN=NQ(NA)
      IF(NDFN.EQ.0)GOTO 10
      ND=NDEST(NA)-1
      DO 6 I=1,NDFN
      ND=ND+1
    6 IFR(ND)=NA
      IF(ND.LT.KURPA) GOTO 10
      KURPA=ND
   10 CONTINUE
C-----------------------------------------------------------------------
C     ASSEMBLE ELEMENT STIFFNESS INTO GRANDPA
C-----------------------------------------------------------------------
CC    WRITE(IW6,901)((NCORR(I,J),I=1,NNE),J=1,NEL)
CC901 FORMAT(6H0NCORR/(1X,22I5))
CC    WRITE(IW6,902)(NDEST(I),I=1,NN)
CC902 FORMAT(6H0NDEST/(1X,20I5))
CC    WRITE(IW6,903)(IFR(I),I=1,IFRZ)
CC903 FORMAT(4H0IFR/(1X,20I5))
      IT=0
      DO 17 J=1,NNE
      N=NCORR(J,NE)
      NA=IABS(N)
      ND=NDEST(NA)-1
C *** INXL - INDEX TO NODAL D.O.F. (SEE ROUTINES BDATA1 AND MAIN2)
      NDFN=LINFO(J+INXL,LT)
      IF(NDFN.EQ.0)GOTO 17
      DO 16 JJ=1,NDFN
      KVT=MINFO(JJ,J,LT)
      IT=IT+1
   16 NDL(IT)=ND+KDF(KVT,NA)
   17 CONTINUE
      IS=0
      DO 20 J=1,IT
      NDJ=NDL(J)
      KS=NDJ*(NDJ-1)/2
      DO 20 I=1,J
      IS=IS+1
      NDI=NDL(I)
      IF(NDI.GT.NDJ)GO TO 18
      KX1=KS+NDI
      GO TO 20
18    KX1=NDI*(NDI-1)/2+NDJ
20    ELPA(KX1)=ELPA(KX1)+ES(IS)
CC    CALL PRINTF(IW6,ELPA(1),MFZ,KURPA,ELPA(NPAR+1))
C-----------------------------------------------------------------------
C     ASSEMBLE RIGHT HAND SIDE / FIX DEGREES OF FREEDOM
C-----------------------------------------------------------------------
      DO 30 I=1,NNE
      IF(NCORR(I,NE).GT.0) GOTO 30
      MA=-NCORR(I,NE)
      NUNDE=NRELVV(MA)
C-----------------------------------------------------------------------
C     FIND IF FIXED
C-----------------------------------------------------------------------
      DO 21 J=1,NF
      IF(MA.EQ.MF(J)) GOTO 22
   21 CONTINUE
      GOTO 26
C
   22 DO 19 ID=1,MXDF
   19 NTT(ID)=TF(ID,J)
      NDFN=NQ(MA)
      IF(NDFN.EQ.0)GOTO 30
C
      FAC=FRACLD
      MDI=NDEST(MA)-1
      DO 25 IDOF=1,MXDF
      IF(KDF(IDOF,MA).EQ.0)GOTO 25
      ISF=IPT(IDOF)
      NTTI=NTT(IDOF)
      MDI=MDI+1
      LC=KGVN(IDOF,MA)
      INDX=IDOF
CC    IF(NTTI.EQ.0)GO TO 25
C==============CHNAGES MADE 27 APRIL 90 TO FIX REACTION BUG
      IF(NTTI.EQ.0) THEN
         MDEST=NPAR+NDEST(MA)-1+IDOF
         MSO=KGVN(IDOF,MA)
         ELPA(MDEST)=ELPA(MDEST)+REAC(MSO)
         GOTO 25
      ENDIF
C==========================================================
      MDF=MDI
      NPA=MDF*(MDF+1)/2
      ELPA(NPA)=ELPA(NPA)+ALAR
      NPRF=NPAR+MDF
C-----------------------------------------------------------------------
C     REPLACE NODAL PORE PRESSURE FIXITY CODES 2 & 3  BY 1 AND SET THE
C     MAGNITUDE TO ZERO
C-----------------------------------------------------------------------
      IF(IDOF.NE.4.OR.NTTI.NE.2.AND.NTTI.NE.3)GOTO 24
      FAC=1.
      TF(IDOF,J)=1
      IF(NTTI.EQ.2) THEN
         DXYT(IDOF,J)=DXYT(IDOF,J)-DA(LC)
      ELSE IF(NTTI.EQ.3) THEN
         DXYT(IDOF,J)=DXYT(IDOF,J)-DA(LC)-PORINS(MA)
      ENDIF
C
   24 ELPA(NPRF)=ELPA(NPRF)+DXYT(IDOF,J)*ALAR*FAC
CC    WRITE(IW6,806)I,IDOF
CC806 FORMAT(/1X,4HI = ,I5,3X,7HIDOF = ,I5)
      IC=IC+1
      IDFX(LC)=1
      IBUF(2*IC-1)=NUNDE
      IBUF(2*IC)=ISF
      MBUF(2*IC-1)=IWR(1)
      MBUF(2*IC)=IWR(2)
      RBUF(IC)=DXYT(IDOF,J)*FAC
      IF(IC.EQ.3.AND.IOPBC.EQ.1)WRITE(IW6,910)(IBUF(2*IM-1),IBUF(2*IM),
     1 MBUF(2*IM-1),MBUF(2*IM),RBUF(IM),IM=1,3)
  910   FORMAT(2(5H NODE,I5,7H D.O.F.,I3,2A4,E13.4,4X),
     1 5H NODE,I5,7H D.O.F.,I3,2A4,E13.4)
      IF(IC.EQ.3)IC=0
      IF(IDOF.EQ.4.AND.NTTI.EQ.2)DXYT(IDOF,J)=0.
      IF(IDOF.EQ.4.AND.NTTI.EQ.3)DXYT(IDOF,J)=0.
   25 CONTINUE
C
   26 NDFN=NQ(MA)
      IF(NDFN.EQ.0)GOTO 30
      MDEST=NPAR+NDEST(MA)-1
      DO 27 JJ=1,MXDF
      MSO=KGVN(JJ,MA)
      IF(MSO.EQ.0)GOTO 27
      MDEST=MDEST+1
      ELPA(MDEST)=ELPA(MDEST)+P(MSO)+PCOR(MSO)
      IF(ABS(P(MSO)).LT.ASMVL.AND.ABS(PCOR(MSO)).LT.ASMVL) GOTO 27
      ISF=IPT(JJ)
      IC=IC+1
      IBUF(2*IC-1)=NUNDE
      IBUF(2*IC)=ISF
      MBUF(2*IC-1)=IWR(3)
      MBUF(2*IC)=IWR(4)
      RBUF(IC)=P(MSO)+PCOR(MSO)
      IF(IC.EQ.3.AND.IOPBC.EQ.1)WRITE(IW6,910)(IBUF(2*IM-1),IBUF(2*IM),
     1 MBUF(2*IM-1),MBUF(2*IM),RBUF(IM),IM=1,3)
      IF(IC.EQ.3)IC=0
   27 CONTINUE
C
   30 CONTINUE
CC    CALL PRINTF(IW6,ELPA(1),MFZ,KURPA,ELPA(NPAR+1))
C-----------------------------------------------------------------------
C     ELIMINATE
C-----------------------------------------------------------------------
      DO 60 J=1,NNE
      IF(NCORR(J,NE).GT.0) GOTO 60
      NA=-NCORR(J,NE)
      NDFN=NQ(NA)
      IF(NDFN.EQ.0)GOTO 60
      ND=NDEST(NA)+NDFN
C-----------------------------------------------------------------------
C     LOOP ON ALL D.O.F. OF NODE BEING ELIMINATED
C-----------------------------------------------------------------------
      DO 58 JJ=1,MXDF
      JJB=MXDF+1-JJ
      IF(KDF(JJB,NA).EQ.0)GOTO 58
      NVABZ=NVABZ+1
      NDEQN=IBA+KURPA+4
      IF(NDEQN.GT.NBAXZ)CALL STOREQ(ELPA,MFZ,NBAX0,IBA,NDEQN,KURPA,IW7)
      ND=ND-1
      NPA=ND
      KVAR=KGVN(JJB,NA)
      IBDIAG=IBA+NPA
      NDIAG=IBDIAG
      IF(INITL.NE.0) NDIAG=NPA*(NPA+1)/2
      PIVOT=ELPA(NDIAG)
      ELPA(NDIAG)=0.
      IF(ABS(PIVOT).GT.ASMVL) GOTO 34
      WRITE(IW6,911)
      WRITE(IW15,911)
      WRITE(IWS,911)
  911 FORMAT(19H ERROR - ZERO PIVOT,1X,'(ROUTINE FRONTZ)')
      WRITE(IW6,711)MUS,NA,JJB
      WRITE(IW15,711)MUS,NA,JJB
      WRITE(IWS,711)MUS,NA,JJB
  711 FORMAT(/1X,12HIN ELEMENT =,I5,5X,6HNODE =,I5,5X,8HVAR NO.=,I5/)
      WRITE(IW15,712)NPA,NDIAG
      WRITE(IWS,712)NPA,NDIAG
      WRITE(IW6,712)NPA,NDIAG
  712 FORMAT(1X,5HNPA =,I5,5X,7HNDIAG =,I5/)
      CALL PRINTF(IW6,ELPA(1),MFZ,KURPA,ELPA(NPAR+1))
      CALL PRINTF(IW15,ELPA(1),MFZ,KURPA,ELPA(NPAR+1))
      STOP
C
   34 MGZ=0
      JGZ=KURPA
      IB0=IBA
      IF(INITL.EQ.0) IBA=IBA+KURPA
      L12=2-INITL
C
      DO 50 LHSRHS=L12,2
      IF(LHSRHS.EQ.2) JGZ=1
C
      DO 48 JG=1,JGZ
      IBA=IBA+1
      GOTO(36,40),LHSRHS
C
   36 MG0=MGZ
      MGZ=MG0+JG
      IF(NPA.GT.JG)GOTO 38
      MG=MG0+NPA
      GOTO 42
C
   38 MG=JG+NPA*(NPA-1)/2
      GOTO 42
C
   40 MG0=NPAR
      MG=MG0+NPA
      MGZ=MG0+KURPA
C
   42 NDELT=IB0-MG0
      CONST=ELPA(MG)
      ELPA(IBA)=CONST
CC    IF(CONST.EQ.0.) GOTO 48
      IF(ABS(CONST).LT.ASMVL) GOTO 48
      CONST=CONST/PIVOT
      ELPA(MG)=0.
      IF(INITL.NE.LHSRHS) GOTO 44
      MG=NPAR+MAXPA+JG
      ELPA(MG)=ELPA(MG)+ELPA(MGZ)*ELPA(MGZ)
C
   44 MG1=MG0+1
      DO 46 I=MG1,MGZ
      K=I+NDELT
      ELPA(I)=ELPA(I)-CONST*ELPA(K)
   46 CONTINUE
   48 CONTINUE
   50 CONTINUE
C
      ELPA(IBDIAG)=PIVOT
      IBA=NDEQN
      ELPA(IBA)=FLOAT(KURPA)
      ELPA(IBA-1)=FLOAT(NPA)
      ELPA(IBA-2)=FLOAT(KVAR)
      IF(INITL.EQ.0) GOTO 56
C-----------------------------------------------------------------------
C      SKIP MORE ON RESOLUTION
C-----------------------------------------------------------------------
      MG=NPAR+MAXPA+NPA
      CRIT=SQRT(ELPA(MG))/ABS(PIVOT)
      ELPA(MG)=0.
      IF(CRIT.LT.1.0E8) GOTO 52
      WRITE(IW6,912)
      WRITE(IW15,912)
      WRITE(IWS,912)
  912 FORMAT(51H PROBABLE SERIOUS ILL-CONDITIONING (ROUTINE FRONTZ))
      WRITE(IW6,700)JJB,NRELVV(NA),MUS,CRIT,PIVOT
      WRITE(IW15,700)JJB,NRELVV(NA),MUS,CRIT,PIVOT
      WRITE(IWS,700)JJB,NRELVV(NA),MUS,CRIT,PIVOT
  700 FORMAT(1X,'VAR NUMBER',I5,5X,'NODE ',I5,5X,'ELEMENT',I5,
     + 5X,'CRIT =',E16.5,5X,'PIVOT =',E16.5)
      WRITE(IW6,710)(NCORR(IM,NE),IM=1,NNE)
      WRITE(IW15,710)(NCORR(IM,NE),IM=1,NNE)
  710 FORMAT(/1X,'ELEMENT (PROG) NODES =', 20I5)
      WRITE(IW6,720)(NDEST(IM),IM=1,NN)
      WRITE(IW15,720)(NDEST(IM),IM=1,NN)
  720 FORMAT(/1X,'NDEST'/(1X,25I5/))
      CALL PRINTF(IW6,ELPA(1),MFZ,KURPA,ELPA(NPAR+MAXPA+1))
      CALL PRINTF(IW15,ELPA(1),MFZ,KURPA,ELPA(NPAR+MAXPA+1))
      STOP
C
   52 IF(CRIT.LT.1.E4.AND.PIVOT.GT.0.) GOTO 54
CC    WRITE(IW6,912)
CC912 FORMAT(26H POSSIBLE ILL CONDITIONING)
C
   54 CONTINUE
C
   56 IF(NPA.EQ.KURPA) KURPA=KURPA-1
      IFR(NPA)=0
C
   58 CONTINUE
C
      NCORR(J,NE)=-NCORR(J,NE)
      IF(KURPA.GT.ND) GOTO 60
   59 IF(KURPA.EQ.0)GOTO 60
      IF(IFR(KURPA).GT.0) GOTO 60
      KURPA=KURPA-1
      GOTO 59
C
   60 CONTINUE
C
CC    CALL PRINTF(IW6,ELPA(1),MFZ,KURPA,ELPA(NPAR+1))
C-----------------------------------------------------------------------
C     OUTPUT BUFFER
C-----------------------------------------------------------------------
   61 IF(NE.NE.NEL) GOTO 62
      IF(IC.EQ.0) GOTO 62
      IF(IC.EQ.1.AND.IOPBC.EQ.1)WRITE(IW6,921)IBUF(1),IBUF(2),
     + MBUF(1),MBUF(2),RBUF(1)
  921 FORMAT(5H NODE,I5,7H D.O.F.,I3,2A4,E13.4)
      IF(IC.EQ.2.AND.IOPBC.EQ.1)WRITE(IW6,922)(IBUF(2*IM-1),IBUF(2*IM),
     + MBUF(2*IM-1),MBUF(2*IM),RBUF(IM),IM=1,2)
  922 FORMAT(2(5H NODE,I5,7H D.O.F.,I3,2A4,E13.4,4X))
   62 CONTINUE
C-----------------------------------------------------------------------
C     BACK SUBSTITUTE
C-----------------------------------------------------------------------
   70 IF(NVABZ.EQ.0) GOTO 80
      IF(IBA.EQ.NBAX0) CALL GETEQN(ELPA,MFZ,NBAX0,IBA,IW7)
      NVABZ=NVABZ-1
      KURPA=IFIX(ELPA(IBA))
      NPA=IFIX(ELPA(IBA-1))
      NIC=IFIX(ELPA(IBA-2))
      IBAR=IBA-4
      IBA=IBAR-KURPA
      IBDIAG=IBA+NPA
      PIVOT=ELPA(IBDIAG)
C
      ELPA(IBDIAG)=0.
      CONST=ELPA(IBAR+1)
C
      DO 72 I=1,KURPA
      K=I+IBA
      CONST=CONST-ELPA(I)*ELPA(K)
   72 CONTINUE
C
      ELPA(NPA)=CONST/PIVOT
      DI(NIC)=ELPA(NPA)
C
      ELPA(IBDIAG)=PIVOT
      GOTO 70
C
   80 CONTINUE
CC    WRITE(IW6,955)(ATM(IK),IK=1,NEL)
CC955 FORMAT(/1X,33HCPU TIME - STIFFNESS CALCULATIONS/1X,
CC   + 33(1H-)//(15F8.2))
      RETURN
      END
      SUBROUTINE GETEQN(ELPA,MFZ,NBAX0,IBA,IW7)
C***********************************************************************
C     READS BUFFERFUL WHEN BACK-SUBSTITUTING
C***********************************************************************
      DIMENSION ELPA(MFZ)
C
      BACKSPACE IW7
      READ (IW7) LREC
      BACKSPACE IW7
      BACKSPACE IW7
      CALL RDN(IW7,ELPA(NBAX0+1),LREC)
      BACKSPACE IW7
      IBA=NBAX0+LREC
      RETURN
      END
      SUBROUTINE HEDSM(NDIM)
C
C***********************************************************************
C
C     PRINT OUT HEADER AND CODES TO INTERPRET SUMMARY TABLE OF
C     CAM CLAY BEHAVIOUR
C
C***********************************************************************
C
      CHARACTER*50 CCTI
      DIMENSION CCTI(20)
      COMMON /EQBM/ RMAX(6),TER(3),IW16
      DATA (CCTI(I1),I1=1,10)/
     +     'APPROACHING CRITICAL STATE.........        -      ',
     +     'ELASTIC  (CODES 0,1,2) ............        < 1.0  ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.00 - 1.05 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.05 - 1.10 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.10 - 1.20 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.20 - 1.50 ',
     +     'HARDENING ON WET SIDE (CODE 3).....        > 1.50 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)   0.95 - 1.00 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)   0.90 - 0.95 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)        < 0.90 '/
      DATA (CCTI(I2),I2=11,20)/
     +     'YIELDING ON TENSION CUTOFF (CODE 6)            -  ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....   1.00 - 1.05 ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....   1.05 - 1.10 ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....        > 1.10 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.00 - 1.05 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.05 - 1.10 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.10 - 1.20 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.20 - 1.50 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....        > 1.50 ',
     +     'NEGATIVE EFFECTIVE P  (CODE 9).....        -      '/
C
      WRITE(IW16,900)
  900 FORMAT(//1X,'SUMMARY OF CAM-CLAY BEHAVIOUR'/1X,29(1H-)/
     + 38X,'YIELD RATIOS',3X,'COLUMN',46X,'YIELD RATIOS',5X,
     + 'COLUMN'/
     + 14X,'STRESS STATE',16X,'RANGE',6X,'NUMBER',27X,'STRESS STATE',
     + 11X,'RANGE',8X,'NUMBER'/14X,12(1H-),16X,5(1H-),6X,6(1H-),
     + 27X,12(1H-),11X,5(1H-),8X,6(1H-)/)
C
      DO 50 IL=1,10
      I1=IL
      I2=IL+10
      IF(IL.LE.10) THEN
         WRITE(IW16,910)CCTI(I1),I1,CCTI(I2),I2
      ELSE
         WRITE(IW16,910)CCTI(I1),I1
      ENDIF
  910 FORMAT(1X,A50,2X,I5,10X,A50,2X,I5)
   50 CONTINUE
      WRITE(IW16,920)
  920 FORMAT(/)
C
      IF(NDIM.EQ.2) WRITE(IW16,940)
  940 FORMAT(1X,'INCR',4X,'EQUILIBRIUM CHECK',40X,
     +   'TOTAL NUMBER OF INTEGRATION POINTS'/2X,'NO.',3X,'X-DIR',3X,
     +   'Y-DIR',5X,'1    2    3    4    5    6    7    8',
     +   4X,'9   10   11   12   13   14   15   16   17   18   19   20'/
     +   130(1H-))
      IF(NDIM.EQ.3) WRITE(IW16,950)
  950 FORMAT(1X,'INCR',6X,'EQUILIBRIUM CHECK',40X,
     +   'TOTAL NUMBER OF INTEGRATION POINTS'/2X,'NO.',3X,'X-DIR',4X,
     +   'Y-DIR',4X,'Z-DIR',4X,'1    2    3    4    5    6    7    8',
     +   4X,'9   10   11   12   13   14   15   16   17   18   19   20'/
     +   130(1H-))
      RETURN
      END
      SUBROUTINE INSIT(NN,NEL,NDF,MXDF,MUMAX,NTPE,NIP,NVRS,NL,NB,NS,
     + NPR,NMT,PR,XYZ,VARINT,NCORR,KGVN,LTYP,MAT,MRELVV,MREL,
     + NMOD,PEQT,KT,ELCOD,LL,NDIM,NDMX,CARTD,SHFN,B,DS,CIP,PORINS,NTY,
     + FI,YI,VAR,NLI,NHI,NI,KLT,LTZ)
C***********************************************************************
C     SET  UP  IN-SITU  STRESSES
C     ROUTINE LAST MODIFIED ON 28/8/92
C     (2/1/87)
C***********************************************************************
CF    CHARACTER*1 JDO     
C@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
CRH   MODIFIED TO ACCOMODATE CHANGE IN PERMEABILITY  
CRH NOT SUITABLE FOR INSITU STRESSES SET TO ZERO AND 
CRH INSITU STRESSES STE AT INTEGRATION POINTS
CRH SUITABLE ONLY FOR REFERENCE POINTS METHOD
CRH   17 March 1995  By Hedy Rahadian

      REAL L,LL
      DIMENSION XYZ(NDIM,NN),VARINT(NVRS,NIP,NEL),PEQT(NDF)
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),MAT(NEL),KGVN(MXDF,NN)
      DIMENSION MREL(MUMAX),NMOD(NIP,NEL),YI(NI),VAR(NVRS,NI)
      DIMENSION MRELVV(NEL),FI(NDIM,NDMX),LL(NL)
      DIMENSION ELCOD(NDIM,NDMX),NLI(NI),NHI(NI)
      DIMENSION DS(NDIM,NDMX),CIP(NDIM),CARTD(NDIM,NDMX),SHFN(NDMX)
      DIMENSION B(NS,NB),NTY(NMT),PR(NPR,NMT),KLT(LTZ),ICCSM(20)
      DIMENSION PORINS(NN)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /FLOW  / NPLAX
      COMMON /DATL  / L(4,100)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /DEVSUP/ IW14,IW15,IWS
C-----------------------------------------------------------------------
C     ISTGE - CODE TO INDICATE STAGE OF THE ANALYSIS
C-----------------------------------------------------------------------
      ISTGE=1
C-----------------------------------------------------------------------
C     INITIALISE VARINT - INTEGRATION  POINT  VARIABLES
C-----------------------------------------------------------------------
      CALL ZEROR3(VARINT,NVRS,NIP,NEL)
      CALL ZEROR1(PORINS,NN)
      CALL ZEROI1(ICCSM,20)
C-----------------------------------------------------------------------
C     INITIALISE PEQT - CONTRIBUTION OF FORCES DUE TO ELEMENT IN-SITU
C     STRESSES
C-----------------------------------------------------------------------
      CALL ZEROR1(PEQT,NDF)
      IF(KT.EQ.0) WRITE(IW6,904)
      IF(KT-1) 300,8,182
C-----------------------------------------------------------------------
C     READ NUMBER OF IN-SITU NODAL POINTS
C-----------------------------------------------------------------------
    8 CONTINUE
      IF(NDIM.EQ.2)WRITE(IW6,906)
      IF(NDIM.EQ.3)WRITE(IW6,936)
      DO 10 J=1,NI
C-----------------------------------------------------------------------
C     READ  NODE  COORDINATES  AND  VARIABLES
C-----------------------------------------------------------------------
crh   replaced
crh      NTM=NVRS+2 
crh   by 
      NTM=NVRS
crh   because NVRS has been NVRS+2

      CALL FFIN(NTM,1)
      IL=IFIX(AR(1))
      YI(IL)=AR(2)
      IF(IL.NE.J) THEN
         WRITE(IW6,970)IL,J
         WRITE(IW15,970)IL,J
         WRITE(IWS,970)IL,J
  970    FORMAT(1X,' *** ERROR - REFERENCE POINT NO. READ IS',I5,5X,
     +             'EXPECTED IS',I5,3X,'(ROUTINE INSIT)')
         STOP
      ENDIF
C
      DO 15 JJ=1,NVRS
   15 VAR(JJ,IL)=AR(JJ+2)
   10 WRITE(IW6,910)IL,YI(IL),(VAR(JJ,IL),JJ=1,NVRS)
C
      MI=NI-1
      DO 20 IN=1,MI
      N1=IN
      N2=IN+1
      Y1=YI(N1)
      Y2=YI(N2)
      CALL SORTN2(Y1,Y2,N1,N2,NMIN,NMAX)
      NLI(IN)=NMIN
      NHI(IN)=NMAX
   20 CONTINUE
C-----------------------------------------------------------------------
C     LOOP  ON  ALL  GEOMETRY  MESH  ELEMENTS
C-----------------------------------------------------------------------
      IERC=0
      DO 80 J=1,NEL
      LT=LTYP(J)
      IF(LT.LT.0)GOTO 80
CC    LT=IABS(LT)
      GO TO(80,22,22,22,22,22,22,22,22,22,22,80,22,80,80),LT
   22 KM=MAT(J)
      NGP=LINFO(11,LT)
      NDN=LINFO(5,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
C
      DO 30 KN=1,NDN
      NDE=NCORR(KN,J)
      DO 30 ID=1,NDIM
   30 ELCOD(ID,KN)=XYZ(ID,NDE)
C-----------------------------------------------------------------------
C     ITERATE  FOR  ALL  INTEGRATION  POINTS
C-----------------------------------------------------------------------
      DO 60 IP=1,NGP
C-----------------------------------------------------------------------
C     CALCULATE  INTEGRATION  POINT  COORDINATES
C-----------------------------------------------------------------------
      IPA=IP+INDX
      DO 35 IL=1,NAC
   35 LL(IL)=L(IL,IPA)
      CALL SHAPE(IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,1)
C
      DO 40 ID=1,NDIM
      SUM=0.
      DO 38 I=1,NDN
   38 SUM=SUM+SHFN(I)*ELCOD(ID,I)
   40 CIP(ID)=SUM
      YY=CIP(2)
CC    IF(LT.EQ.13)WRITE(6,800)IP,CIP
CC800 FORMAT(1X,'IP =',I5,2X,'COORDS = ',2F12.4)
C-----------------------------------------------------------------------
C     SEARCH  FOR  RELEVANT  IN-SITU  LAYER
C-----------------------------------------------------------------------
      DO 45 JJJ=1,MI
      NSM=NLI(JJJ)
      NLA=NHI(JJJ)
      YMIN=YI(NSM)
      YMAX=YI(NLA)
C
      IF(YY.LT.YMIN.OR.YY.GT.YMAX)GO TO 45
      GO TO 48
C
   45 CONTINUE
      IERC=IERC+1
      IF(IERC.GT.10) THEN
         WRITE(IW6,975)
         WRITE(IW15,975)
         WRITE(IWS,975)
  975    FORMAT(/1X,'*** ERROR - CHECK IN SITU REFERENCE POINT',1X,
     +           'NUMBERS AND COORDINATES'/1X,'(ROUTINE INSIT)')
         STOP
      ENDIF
      WRITE(IW6,950)J,IP
      GO TO 60
C-----------------------------------------------------------------------
C     DIRECT  INTERPOLATION  FROM  IN-SITU  MESH  NODES
C-----------------------------------------------------------------------
   48 DY=YI(JJJ)-YI(JJJ+1)
      YR=(YY-YMIN)/DY
C
      DO 50 I=1,NVRS
   50 VARINT(I,IP,J)=VAR(I,NSM)+(VAR(I,JJJ)-VAR(I,JJJ+1))*YR
CC    WRITE(IW6,951)J,IP,(VARINT(IU,IP,J),IU=1,NVRS)
      KGO=NTY(KM)
cRA      GO TO(60,60,52,52,60,52,60,60),KGO
cra   replaced to calculate void ratio Ei INI elastic models
      GO TO(58,58,52,52,60,52,60,60),KGO      
CRA   END OF REPLACEMENT      
   52 P=(VARINT(1,IP,J)+VARINT(2,IP,J)+VARINT(3,IP,J))*0.333333
      PC=VARINT(NS+3,IP,J)
      IF(KGO.NE.3)GO TO 54
      PU=0.5*PC
      GO TO 55
   54 PU=PC/2.7182818
   55 VARINT(NS+2,IP,J)=PR(3,KM)-PR(1,KM)*ALOG(P)-
     +(PR(2,KM)-PR(1,KM))*ALOG(PU)
CRA   PUT INITIAL VOID RATIO IN PR(17,KM): FOR CAMCLAY ONLY
      PR(17,KM)=VARINT(NS+2,IP,J) 
      GOTO 60     
CRA   END OF ADDITIONAL: 23 MARCH 1994
CRA   60 CONTINUE    
CRA   REPLACED TO CALCULATE VOID RATIO Ei IN ELASTIC MODELS  
   58 VARINT(NS+2,IP,J)=PR(17,KM) 
c      WRITE(6,100)VARINT(NS+2,IP,J)
c  100 FORMAT(1X,10H  ei  =   ,F10.3)
   60 CONTINUE
CRA   END OF REPLACEMENT
   80 CONTINUE
C-----------------------------------------------------------------------
C     SEARCH  FOR  RELEVANT  IN-SITU  LAYER
C-----------------------------------------------------------------------
C--------CALCULATE IN SITU PORE PRESSURE AT NODES
      IERC=0
      DO 160 IN=1,NN
      YY=XYZ(2,IN)
C
      DO 145 JJJ=1,MI
      NSM=NLI(JJJ)
      NLA=NHI(JJJ)
      YMIN=YI(NSM)
      YMAX=YI(NLA)
C
      IF(YY.LT.YMIN.OR.YY.GT.YMAX)GO TO 145
      GO TO 148
C
  145 CONTINUE
C---------NODE IS OUTSIDE PRIMARY MESH
CC    IERC=IERC+1
CC    IF(IERC.GT.10) THEN
CC       WRITE(IW6,975)
CC       WRITE(IW15,975)
CC       WRITE(IWS,975)
CC975    FORMAT(/1X,'*** ERROR - CHECK IN SITU REFERENCE POINT',1X,
CC   +           'NUMBERS AND COORDINATES'/1X,'(ROUTINE INSIT)')
CC       STOP
CC    ENDIF
CC    WRITE(IW6,995)IN
C-----------------SET PORE PRESSURE TO ZERO. - 22 APRIL 93
      PORINS(IN)=0.
      GO TO 160
C-----------------------------------------------------------------------
C     DIRECT  INTERPOLATION  FROM  IN-SITU  MESH  NODES
C-----------------------------------------------------------------------
  148 DY=YI(JJJ)-YI(JJJ+1)
      YR=(YY-YMIN)/DY
C
      PORINS(IN)=VAR(NVRS-2,NSM)+(VAR(NVRS-2,JJJ)-VAR(NVRS-2,JJJ+1))*YR
  160 CONTINUE
      GOTO 192
C-----------------------------------------------------------------------
C     DIRECT SPECIFICATION OF IN-SITU STRESSESS
C-----------------------------------------------------------------------
  182 IF(KT.NE.2)GO TO 192
      WRITE(IW6,955)
C *** READ FOR ALL INTEGRATION POINTS
      DO 190 IM=1,NEL
      CALL FFIN(1,1)
      MUS=IFIX(AR(1))
      WRITE(IW6,953)MUS
      IL=MREL(MUS)
      LT=LTYP(IL)
      NGP=LINFO(11,LT)
      DO 185 IP=1,NGP
      CALL FFIN(NVRS-2,0)
C      DO 184 JJJ=1,NVRS
C     MODIFIED FOR TAKING ONLY 7 PARAMETERS IN 2 D analysis
      DO 184 JJJ=1,NVRS
C     END OF MODI
  184 VARINT(JJJ,IP,IL)=AR(JJJ)    
C     ALSO MODIFIED
C  185 WRITE(IW6,960)(VARINT(JJJ,IP,IL),JJJ=1,NVRS)
  185 WRITE(IW6,960)(VARINT(JJJ,IP,IL),JJJ=1,NVRS-2)    
  190 CONTINUE
C-----------------------------------------------------------------------
C     FOR ELASTO-PLASTIC MATERIAL SET-UP STRESS STATE INDICATOR
C     0 - ELASTIC.  1 - PLASTIC
C-----------------------------------------------------------------------
  192 DO 220 J=1,NEL
      LT=LTYP(J)
      IF(LT.LT.0)GOTO 220
      KM=MAT(J)
      MUS=MRELVV(J)
      KGO=NTY(KM)
      IF(KGO.NE.5)GOTO 220
      KT=IFIX(PR(6,KM))
      COH=PR(3,KM)
      PHI=PR(4,KM)
      NGP=LINFO(11,LT)
C
      DO 210 IP=1,NGP
      CALL INVAR(VARINT(1,IP,J),NS,SBAR,SIGM,THETA,NDIM)
      CALL VALFUN(SIGM,SBAR,THETA,FNF,COH,PHI,KT,MUS,IP)
      IF(FNF.GE.0)NMOD(IP,J)=1
  210 CONTINUE
  220 CONTINUE
C-----------------------------------------------------------------------
C     SET UP LOCAL STRESSES FOR BAR BEAM AND SLIP ELEMENTS
C-----------------------------------------------------------------------
      CALL LCLSTR(NN,NEL,NTPE,NIP,NVRS,XYZ,VARINT,NCORR,LTYP,
     +            NDIM,MRELVV)
C-----------------------------------------------------------------------
C     CALCULATE EQUILIBRIUM LOADS FOR INSITU STRESSES
C     ASSEMBLE ELEMENT CONTRIBUTION (FI) INTO PEQT
C-----------------------------------------------------------------------
      CR=1.
      IF(NPLAX.EQ.1)CR=2.*PYI
C
      DO 250 J=1,NEL
      LT=LTYP(J)
      IF(LT.LE.0)GO TO 250
      MUS=MRELVV(J)
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
      KM=MAT(J)
C
      CALL EQLIB(IW6,J,MUS,KM,LT,NGP,NIP,INDX,NTPE,NEL,NDIM,NN,NDMX,NDN,
     +           NS,NB,NAC,NVRS,NPR,NMT,VARINT,NCORR,XYZ,B,ELCOD,
     +           CARTD,SHFN,DS,FI,LL,PR,ISTGE)
CC    WRITE(6,850)MUS,FI
CC850 FORMAT(/1X,'ELEMENT ',I5,4X,'FI'/(1X,6E16.5))
C-----------------------------------------------------------------------
C     SLOT EQLBM LOADS INTO PEQT
C-----------------------------------------------------------------------
      DO 248 IK=1,NDN
      NCOR=NCORR(IK,J)
C----------SKIP IF DUMMY NODES
      IF(KGVN(1,NCOR).EQ.0)GOTO 248
      N1=KGVN(1,NCOR)-1
      DO 245 ID=1,NDIM
  245 PEQT(N1+ID)=PEQT(N1+ID)+FI(ID,IK)
  248 CONTINUE
  250 CONTINUE
C-----------------------------------------------------------------------
C     OUTPUT EQLBM LOADS
C-----------------------------------------------------------------------
CC    WRITE(IW6,985)(PEQT(J2),J2=1,NDF)
C
      CALL INSTRS(IW6,NN,NEL,NTPE,NIP,NVRS,NDIM,NDMX,NMT,MUMAX,NS,NL,
     + XYZ,VARINT,NCORR,LTYP,MAT,MREL,NTY,ELCOD,DS,SHFN,CIP,LL,
     + KLT,LTZ)
C
      CALL PRNTSM(NDIM,0,ICCSM)
  300 CONTINUE
      RETURN
  950 FORMAT(1X,46HWARNING --- POINT OUTSIDE IN SITU STRESS SPACE,2I5)
  995 FORMAT(1X,46HWARNING --- NODE  OUTSIDE IN SITU STRESS SPACE,I5)
CC951 FORMAT(2I4,7E14.4)
  953 FORMAT(1X,7HELEMENT,I6)
  955 FORMAT(//1X,40HDIRECT SPECIFICATION OF IN SITU STRESSES
     + /1X,39(1H-))
  960 FORMAT(1X,10E12.5)
CC985 FORMAT(/1X,38HEQUILIBRIUM LOADS FOR IN SITU STRESSES/
CC   + 1X,37(1H-)//(10E12.4))
  904 FORMAT(//1X,36HIN SITU STRESSES  ALL  SET  TO  ZERO/1X,36(1H-))
  906 FORMAT(//1X,19HIN SITU  MESH  DATA/1X,19(1H-)/
     + /3X,5HPOINT,7X,1HY,8X,6HSIG-X',6X,6HSIG-Y',6X,6HSIG-Z',
     + 7X,3HTXY,10X,1HU,22X,2HPC/)
  936 FORMAT(//1X,19HIN SITU  MESH  DATA/1X,19(1H-)/
     + /3X,5HPOINT,7X,1HY,8X,6HSIG-X',6X,6HSIG-Y',6X,6HSIG-Z',
     + 7X,3HTXY,9X,3HTYZ,9X,3HTZX,10X,1HU,22X,2HPC/)
  910 FORMAT(1X,I5,10F12.3)
CC505 FORMAT(//1X,17HIN SITU MESH DATA/1X,17(1H-)//2X,5HPOINT,7X,1HX,
CC   + 11X,1HY,11X,3HOCR,9X,2HSV,10X,1HU/)
CC560 FORMAT(1X,I5,2X,I5,5X,I5,5X,I5,5X,I5)
      END
      SUBROUTINE INSTRS(IW6,NN,NEL,NTPE,NIP,NVRS,NDIM,NDMX,NMT,MUMAX,
     + NS,NL,XYZ,VARINT,NCORR,LTYP,MAT,MREL,NTY,ELCOD,DS,SHFN,CIP,LL,
     + KLT,LTZ)
C***********************************************************************
C     ROUTINE TO PRINT OUT IN SITU STRESSES                            *
C     BEFORE THE FIRST INCREMENT                                       *
C     ROUTINE LAST MODIFIED ON 2/1/87                                  *
C***********************************************************************
      REAL L,LL
      DIMENSION XYZ(NDIM,NN),VARINT(NVRS,NIP,NEL),LL(NL)
      DIMENSION NCORR(NTPE,NEL),MAT(NEL),LTYP(NEL),SHFN(NDMX)
      DIMENSION MREL(MUMAX),NTY(NMT),CIP(NDIM),ELCOD(NDIM,NDMX),
     +          DS(NDIM,NDMX),KLT(LTZ)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DATL  / L(4,100)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
C***********************************************************************
C     OPTION TO PRINT OUT IN IN SITU STRESSES EITHER AT ALL
C     INTEGRATION POINTS OR ONLY AT CENTROIDS
C     INSOP = 2.   AT ALL INTEGRATION POINTS
C     INSOP = 1.   CENTROIDS ONLY
C     INSOP = 0.   NO OUTPUT OF IN SITU STRESSES
C***********************************************************************
      IF(INSOP.EQ.0)RETURN
C
      NS1=NS+1
      IF(INSOP.EQ.2)WRITE(IW6,900)
  900 FORMAT(/1X,37HIN SITU STRESSES AT INTEGRATION POINT/
     + 1X,34(1H-)/)
      IF(INSOP.EQ.1)WRITE(IW6,920)
  920 FORMAT(/1X,29HIN SITU STRESSES AT CENTROIDS/
     + 1X,30(1H-)/)
      IF(NDIM.EQ.2)WRITE(IW6,901)
      IF(NDIM.EQ.3)WRITE(IW6,910)
      IF(KLT(1).NE.0)WRITE(IW6,961)
      IF(KLT(12).NE.0)WRITE(IW6,962)
      IF(KLT(13).NE.0)WRITE(IW6,963)
  961 FORMAT(1X,'BAR',94X,'AX-STRESS')
  962 FORMAT(1X,'BEAM',79X,'AX-STRESS',7X,'BM',7X,'LSFBM')
  963 FORMAT(1X,'SLIP',96X,'SIG-N',8X,'SIG-S')

C
      DO 60 MR=1,MUMAX
      IF(MREL(MR).EQ.0)GO TO 60
      J=MREL(MR)
      LT=LTYP(J)
      IF(LTYP(J).LT.0)GO TO 60
      GOTO(10,10,10,10,10,10,10,10,10,10,10,10,10,60,60),LT
   10 NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
      KM=MAT(J)
      KGO=NTY(KM)
      GO TO(11,11,12,12,11,12,12,11),KGO
   11 ICAM=0
      GO TO 14
   12 ICAM=1
   14 CONTINUE
      IF(INSOP.EQ.2)WRITE(6,902)MR
C
      DO 18 KN=1,NDN
      NDE=NCORR(KN,J)
      DO 18 ID=1,NDIM
   18 ELCOD(ID,KN)=XYZ(ID,NDE)
C
      IPS=1
      IF(INSOP.EQ.1)IPS=NGP
C
      DO 40 IP=IPS,NGP
      IPA=IP+INDX
C
      DO 25 IL=1,NAC
   25 LL(IL)=L(IL,IPA)
      CALL SHAPE (IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,1)
C
      DO 35 ID=1,NDIM
      SUM=ZERO
      DO 30 I=1,NDN
   30 SUM=SUM+SHFN(I)*ELCOD(ID,I)
   35 CIP(ID)=SUM
C---------- MRIP = ELEMENT NUMBER IF INSOP = 1
C---------- MRIP = INTEGRATION POINT NUMBER IF INSOP = 2
C
      MRIP=IP
      IF(INSOP.EQ.1)MRIP=MR
C         
crh   Ommitted : calcualte void ratio even if the material is elastic
crh      IF(ICAM.NE.1)GO TO 38 
crh   end of ommission
      EI=VARINT(NS+2,IP,J)
      PCI=VARINT(NS+3,IP,J)
      PE=(VARINT(1,IP,J)+VARINT(2,IP,J)+VARINT(3,IP,J))*0.333333333
      QE=Q(VARINT(1,IP,J),NS,NDIM)
      IF(NDIM.EQ.2)WRITE(IW6,903)MRIP,(CIP(ID),ID=1,NDIM),
     + (VARINT(IK,IP,J),IK=1,NS1),PE,QE,PCI,EI
      IF(NDIM.EQ.3)WRITE(IW6,904)MRIP,(CIP(ID),ID=1,NDIM),
     + (VARINT(IK,IP,J),IK=1,NS1),PE,QE,PCI,EI
      GO TO 40        
ch    This line is unnecessary
crh   38 WRITE(IW6,903)MRIP,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,J),IK=1,7) 
ch    end of the unnecessary line
   40 CONTINUE
   60 CONTINUE
      RETURN
  901 FORMAT(7H  POINT,6X,1HX,11X,1HY,9X,6HSIG-X',6X,
     + 6HSIG-Y',6X,6HSIG-Z',8X,3HTXY,9X,1HU,10X,2HPE,
     + 11X,1HQ,10X,2HPC,7X,4HVOID)
  902 FORMAT(I4)
  903 FORMAT(1X,I5,10E12.4,F7.4)
  904 FORMAT(1X,I5,10E12.4/90X,3E12.4,F7.4)
  910 FORMAT(6H POINT,7X,1HX,11X,1HY,11X,1HZ,8X,6HSIG-X',8X,6HSIG-Y',
     + 6X,6HSIG-Z',5X,3HTXY,9X,3HTYZ,9X,3HTZX,11X,1HU/95X,
     + 4H(PE),8X,3H(Q),9X,4H(PC),4X,6H(VOID))
      END
      SUBROUTINE INVAR(V,NS,SBAR,SIGM,TH,NDIM)
C***********************************************************************
C     CALCULATE STRESS INVARIANTS FOR MODEL 5
C***********************************************************************
      DIMENSION V(NS),ESN(6)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      DATA SQRT3/1.7320508076/
C
      SIGM=(V(1)+V(2)+V(3))
      SIGP=SIGM/3.
      DO 10 IS=1,3
   10 ESN(IS)=V(IS)-SIGP
C
      DO 20 IS=4,NS
   20 ESN(IS)=V(IS)
C
      SBAR2=0.5*(ESN(1)*ESN(1)+ESN(2)*ESN(2)+ESN(3)*ESN(3))+
     + ESN(4)*ESN(4)
      IF(NDIM.EQ.3)SBAR2=SBAR2+ESN(5)*ESN(5)+ESN(6)*ESN(6)
      IF(SBAR2.LT.ASMVL)SBAR2=ASMVL
      SBAR=SQRT(SBAR2)
      SIGJ3=ESN(3)*(ESN(2)*ESN(1)-ESN(4)*ESN(4))
      IF(NDIM.EQ.3)SIGJ3=SIGJ3-ESN(1)*ESN(5)*ESN(5)-ESN(2)*ESN(6)*ESN(6)
     1 +2.0*ESN(4)*ESN(5)*ESN(6)
C
      STH3=(-1.5)*SQRT3*SIGJ3/(SBAR2*SBAR)
      IF(STH3.GT.1.)STH3=1.
      IF(STH3.LT.(-1.))STH3=-1.
      TH=ASIN(STH3)/3.
      RETURN
      END
      SUBROUTINE LCLSTR(NN,NEL,NTPE,NIP,NVRS,XYZ,VARINT,NCORR,
     +                  LTYP,NDIM,MRELVV)
C
C***********************************************************************
C     SUBROUTINE TO SET UP LOCAL STRESSES FOR BAR BEAM AND SLIP
C     ELEMENTS FOR IN SITU STRESSES
C***********************************************************************
C
      DIMENSION XYZ(NDIM,NN),VARINT(NVRS,NIP,NEL),NCORR(NTPE,NEL),
     +          LTYP(NEL),MRELVV(NEL)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      DO 200 J=1,NEL
      LT=LTYP(J)
      IF(LT.LT.0)GOTO 200
      IF(LT.NE.1.AND.LT.NE.12.AND.LT.NE.13.AND.LT.NE.14.AND.LT.NE.15)
     +        GOTO 200
      MUS=MRELVV(J)
      NGP=LINFO(11,LT)
C
      N1=NCORR(1,J)
      N2=NCORR(2,J)
      C=XYZ(1,N1)-XYZ(1,N2)
      S=XYZ(2,N1)-XYZ(2,N2)
      AL=SQRT(C*C+S*S)
      IF(AL.LT.ASMVL)THEN
         IF(LT.EQ.13) THEN
            WRITE(IW6,700)MUS
            WRITE(IW15,700)MUS
            WRITE(IWS,700)MUS
  700       FORMAT(/1X,'*** ERROR - CHECK NODE SEQUENCE FOR SLIP',
     +              1X,'ELEMENT',I5)
            STOP
         ELSE
            WRITE(IW6,710)MUS
            WRITE(IW15,710)MUS
            WRITE(IWS,710)MUS
  710       FORMAT(/1X,'*** ERROR - CHECK NODE SEQUENCE AND NODE',
     +              1X,'CO-ORDINATES OF ELEMENT ',I5)
            STOP
         ENDIF
      ENDIF
C
      C=C/AL
      S=S/AL
C     TH=ACOS(C)
C---------BUG FIXED - 7 SEPT 93
      TH=ATAN2(S,C)
C
      DO 100 IP=1,NGP
C
      IF(LT.EQ.1.OR.LT.EQ.12) THEN
         VARINT(6,IP,J)=VARINT(1,IP,J)*C+VARINT(2,IP,J)*S
      ELSE IF(LT.EQ.13) THEN
CC       VARINT(6,IP,J)=-VARINT(1,IP,J)*S+VARINT(2,IP,J)*C
CC       VARINT(7,IP,J)= VARINT(1,IP,J)*C+VARINT(2,IP,J)*S
         RAD=0.5*(VARINT(2,IP,J)-VARINT(1,IP,J))
         SIGM=0.5*(VARINT(2,IP,J)+VARINT(1,IP,J))
         VARINT(6,IP,J)=SIGM+RAD*COS(2.*TH)
         VARINT(7,IP,J)=RAD*SIN(2.*TH)
C        VARINT(7,IP,J)=0.
         VARINT(4,IP,J)=VARINT(3,IP,J)
      ENDIF
  100 CONTINUE
  200 CONTINUE
      RETURN
      END
      SUBROUTINE LODINC(
CX    SUBROUTINE LODINC(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,
CX   +                  NVRN,NDIM,MUMAX,NDZ,IFRZ,NNZ,NDMX,NPMX,
CX   +                  NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
     +                  INXL,MXEN,MXLD,LV,NVTX,ND,KSS,
     +                  XYZ,DI,DA,VARINT,P,PT,PIB,REAC,PCOR,PEQT,XYFT,
     +                  XYFIB,STR,PEXIB,PEXI,PCONI,D,ELCOD,DS,SHFN,
     +                  CARTD,B,DB,FT,SS,ES,E,PE,RN,AA,ETE,RLT,CARTP,
     +                  PORINS,
     +                  NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     +                  JEL,IDFX,NDEST,NP1,NP2,IFR,NDL,NWL,NMOD,KDF,
     +                  CIP,LL,V,FXYZ,PR,PDISLD,PRES,NTY,A,MFZ,
     +                  DTIMEI,TTIME,DGRAVI,TGRAV,IOUT,JS,J,FRACLD,
     +                  FRACT,ICOR,IUPD,IBC,NLOD,NLDS,IWRDK,KK,LKK,
     +                  KLT,LTZ)
C***********************************************************************
C     LOAD INCREMENT ROUTINE
C***********************************************************************
      REAL LL
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),VARINT(NVRS,NIP,NEL),
     + P(NDF),PT(NDF),PIB(NDF),REAC(NDF),PCOR(NDF),PEQT(NDF),XYFT(NDF),
     + XYFIB(NDF),STR(NVRN,NIP,NEL),PEXIB(NDF),PEXI(NDF),PCONI(NDF)
      DIMENSION D(NS,NS),ELCOD(NDIM,NDMX),DS(NDIM,NDMX),SHFN(NDMX),
     + CARTD(NDIM,NDMX),B(NS,NB),DB(NS,NB),FT(NDIM,NDMX),
     + SS(KSS),ES(KES),KLT(LTZ)
      DIMENSION E(NDIM,NPMX),PE(NDIM,NPMX),PORINS(NN),
     + RN(NB),AA(NPMX),ETE(NPMX,NPMX),RLT(NB,NPMX),CARTP(NDIM,NPMX)
      DIMENSION NCORR(NTPE,NEL),MAT(NEL),LTYP(NEL),MRELVV(NEL),
     + MREL(MUMAX),NRELVV(NN),NREL(NNZ),KGVN(MXDF,NN),NQ(NN),JEL(NEL),
     + IDFX(NDF),NDEST(NN),NP1(NPL),NP2(NPL),KDF(MXDF,NN)
      DIMENSION IFR(IFRZ),NDL(MDFE),NWL(NPMX),NMOD(NIP,NEL)
      DIMENSION CIP(NDIM),LL(NL),V(LV),FXYZ(NDIM),PR(NPR,NMT),
     + PDISLD(NDIM,NPT),PRES(NDIM,NPT),NTY(NMT),A(MFZ),KK(LKK)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /PRLDI / PRSLDI(10,400),LEDI(400),NDI1(400),NDI2(400),ILOD
      COMMON /MP92/NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
     + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN
C
      WRITE(IW6,915)JS,J,FRACLD
      WRITE(IW6,917)DGRAVI,TGRAV,DTIMEI,TTIME
C-----------------------------------------------------------------------
C     BOUNDARY CONDITIONS (LOADS AND DISPLACEMENTS) ARE PRINTED
C     EVERY IBC INCREMENTS
C     IBC =  0 NOT PRINTED IN ANY INCREMENT
C     IBC =  1 PRINTED IN EACH INCREMENT
C     IBC = 10 PRINTED IN EVERY 10TH INCREMENT
C-----------------------------------------------------------------------
      IOPBC=0
      IF(IBC.EQ.0)GOTO 130
      NJS=IBC*(JS/IBC)
      IF(NJS.EQ.JS)IOPBC=1
C
  130 DO 140 IM=1,NDF
      XYFT(IM)=XYFT(IM)+XYFIB(IM)*FRACLD
  140 P(IM)=FRACLD*PIB(IM)+FRACLD*XYFIB(IM)
C
      DO 145 IM=1,NDF
  145 PEXI(IM)=(1.0-FRACT)*PEXIB(IM)
C-----------------------------------------------------------------------
C     UPDATE LIST OF PRESSURE LOADING ALONG ELEMENT EDGES
C-----------------------------------------------------------------------
      IF(NLOD.GE.0)GO TO 162
C
      DO 160 ISD=1,NLDS
      LNE=LEDI(ISD)
      ND1=NDI1(ISD)
      ND2=NDI2(ISD)
      ICT=0
C *** N2D = 2 FOR TWO DIMENSIONAL PROBLEMS
      N2D=2
      DO 150 IK=1,NPT
      DO 150 IJ=1,N2D
      ICT=ICT+1
  150 PRES(IJ,IK)=FRACLD*PRSLDI(ICT,ISD)
      CALL LODLST(IW6,LNE,ND1,ND2,PRES,NDIM,NPT,0,MXLD)
  160 CONTINUE
  162 CONTINUE
C-----------------------------------------------------------------------
C     INITIALISE INCREMENTAL DISPLACEMENTS AND WORKING ARRAY A
C-----------------------------------------------------------------------
      CALL ZEROR1(DI,NDF)
      CALL ZEROR1(A,MFZ)
C-----------------------------------------------------------------------
C       PREFRONT
C-----------------------------------------------------------------------
      CALL MAKENZ(NTPE,NEL,NN,MXDF,NCORR,LTYP,NQ,INXL,KDF)
      CALL MLAPZ(NTPE,NEL,NN,NCORR,LTYP,NQ)
      CALL SFWZ(MNFZ,NTPE,NEL,NN,MUMAX,NNZ,IFRZ,NCORR,LTYP,
     +          NQ,NDEST,MREL,NREL,IFR,1,MCORE,NCORET)
C-----------------------------------------------------------------------
C     SOLVE  EQUATIONS USING  FRONTAL  SOLUTION
C-----------------------------------------------------------------------
      IF(IOPBC.EQ.1)WRITE(IW6,921)
      CALL FRONTZ(MNFZ,DTIMEI,NN,MXDF,NEL,NDF,NTPE,NIP,NPR,NMT,
     + KES,NS,NB,NDIM,NDMX,NVRS,NPMX,INXL,MDFE,IFRZ,KSS,
     + XYZ,DI,DA,P,PCOR,REAC,VARINT,NCORR,
     + NQ,KGVN,NMOD,KDF,ES,NL,IFR,NDL,
     + ELCOD,CARTD,SHFN,DS,D,B,DB,SS,E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NRELVV,LTYP,MRELVV,NDEST,MAT,IDFX,NWL,LL,PR,
     + NTY,A,MFZ,FRACLD,IOPBC)
C-----------------------------------------------------------------------
C     UPDATE  AND  OUTPUT  CALCULATIONS
C-----------------------------------------------------------------------
      CALL UPARAL(TTIME,TGRAV,IOUT,NN,ND,MXDF,NEL,NDF,NTPE,NIP,NPT,
     + NSP,NPL,NDZ,NVRS,NVRN,NDIM,MUMAX,NNZ,NDMX,NPMX,NS,NB,NL,INXL,
     + NPR,NMT,MXEN,XYZ,DI,DA,P,PT,XYFT,PEQT,
     + VARINT,STR,PEXI,PCONI,REAC,PR,CIP,FT,LL,B,DS,D,ELCOD,
     + CARTD,SHFN,AA,NCORR,NQ,KGVN,LTYP,MAT,JEL,IDFX,
     + MREL,NREL,NWL,NMOD,NTY,NP1,NP2,A,MFZ,
     + PCOR,ICOR,IUPD,FRACT,IWRDK,JS,KK,LKK,KLT,LTZ)
C-----------------------------------------------------------------------
      RETURN
  915 FORMAT(//120(1H=)//
     + 1X,32HSTART OF LOAD INCREMENT NUMBER  ,I5,
     + 4X,22HINCREMENT BLOCK NUMBER,I5,4X,18HINCREMENT RATIO = ,F5.2/
     + 1X,95(1H-))
  917 FORMAT(/22H INCR GRAVITY LEVEL = ,E11.4,
     + 24H  TOTAL GRAVITY LEVEL = ,E11.4,2X,
     + 18H TIME INCREMENT = ,E11.4,4X,15H  TOTAL TIME = ,E11.4)
  921 FORMAT(//31H PRESCRIBED BOUNDARY CONDITIONS/1X,30(1H-)/)
      END
      SUBROUTINE LODLST(IW6,LNE,ND1,ND2,PRES,NDIM,NPT,ILST,MXLD)
C***********************************************************************
C     ROUTINE TO STORE CUMULATIVE LIST OF APPLIED
C     PRESSURE LOADING ALONG ELEMENT EDGES
C***********************************************************************
      DIMENSION PRES(NDIM,NPT)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /DEVSUP/ IW14,IW15,IWS
C-----------------------------------------------------------------------
C     MXLD - SIZE OF ARRAYS LEDG,NDE1,NDE2,PRESLD (ROUTINE MAXVAL)
C-----------------------------------------------------------------------
C *** SKIP IF NEW LIST
      IF(NLED.EQ.0.OR.ILST.EQ.1)GO TO 22
C-----------------------------------------------------------------------
C     SEARCH FOR LNE IN EXISTING LIST
C-----------------------------------------------------------------------
      DO 20 J=1,NLED
      IF(LNE.NE.LEDG(J))GO TO 20
      N1=NDE1(J)
      N2=NDE2(J)
      IF(N1.EQ.ND1.AND.N2.EQ.ND2)GO TO 25
   20 CONTINUE
C-----------------------------------------------------------------------
C     ADD NEW EDGE TO THE LIST
C-----------------------------------------------------------------------
   22 NLED=NLED+1
      IF(NLED.LE.MXLD)GO TO 23
      WRITE(IW6,900)
      WRITE(IW15,900)
      WRITE(IWS,900)
  900 FORMAT(/27H INCREASE SIZE OF ARRAYS IN,
     + 51H COMMON BLOCK PRSLD ALSO SET MXLD IN ROUTINE MAXVAL/
     + 25X,16H(ROUTINE LODLST))
      STOP
   23 JE=NLED
      GO TO 30
C-----------------------------------------------------------------------
C     UPDATE EXISTING LIST
C-----------------------------------------------------------------------
   25 JE=J
      GO TO 35
C
   30 LEDG(JE)=LNE
      NDE1(JE)=ND1
      NDE2(JE)=ND2
C
   35 IC=0
      DO 40 IPT=1,NPT
      DO 40 IK=1,NDIM
      IC=IC+1
   40 PRESLD(IC,JE)=PRESLD(IC,JE)+PRES(IK,IPT)
      RETURN
      END
      SUBROUTINE LSTFBM(IW6,NE,MUS,INXL,SG,KSG,NN,NEL,NTPE,NPR,NMT,NDIM,
     +                  XYZ,NCORR,MAT,LT,PR,NTY)
C
C***********************************************************************
C     CALCULATION  OF STIFFNESS MATRIX FOR 3-NODED BEAM ELEMENT (LT=12)
C***********************************************************************
C
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),NTY(NMT),
     +          PR(NPR,NMT),SG(KSG)
      DIMENSION T(3,3),ES(9,9),ET(3,3),EK(9,9)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
C *** INITIALIZE MATRICES
C
      DO 2 J=1,3
      DO 2 I=1,3
    2 T(I,J)=ZERO
      T(3,3)=1.
      DO 4 I=1,KSG
    4 SG(I)=ZERO
C
      KM=MAT(NE)
      IF(NTY(KM).NE.8) THEN
         WRITE(IW6,900)MUS,KM,NTY(KM)
         WRITE(IW15,900)MUS,KM,NTY(KM)
         WRITE(IWS,900)MUS,KM,NTY(KM)
  900    FORMAT(1X,'*** ERROR - ELEMENT',I5,4X,'WITH MAT ZONE NUMBER',
     +          I5,4X,'HAS INADMISSIBLE MAT TYPE NUMBER',I5/
     +          5X,'(ROUTINE LSTFBM)')
         STOP
      ENDIF
C
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      AI=PR(4,KM)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
C
C *** CALCULATE BEAM STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
      N3=NCORR(3,NE)
      N1=IABS(N1)
      N2=IABS(N2)
      N3=IABS(N3)
      C=XYZ(1,N2)-XYZ(1,N1)
      S=XYZ(2,N2)-XYZ(2,N1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 8 J=1,9
      DO 8 I=1,9
    8 ES(I,J)=ZERO
C
      ES(1,4)=(1./3.)*(E*A/BL)
      ES(1,1)=7.*ES(1,4)
      ES(1,7)=-8.*ES(1,4)
      ES(4,4)=ES(1,1)
      ES(4,7)=ES(1,7)
      ES(7,7)=16.*ES(1,4)
      ES(2,5)=-(1508./35.)*(E*AI/(BL*BL*BL))
      ES(2,3)=(1138./35.)*(E*AI/(BL*BL))
      ES(2,2)=(5092./35.)*(E*AI/(BL*BL*BL))
      ES(2,6)=(242./35.)*(E*AI/(BL*BL))
      ES(3,9)=(64./7.)*(E*AI/BL)
      ES(3,8)=-(128./5.)*(E*AI/(BL*BL))
      ES(3,3)=(332./35.)*(E*AI/BL)
      ES(3,6)=(38./35.)*(E*AI/BL)
      ES(2,8)=4.*ES(3,8)/BL
      ES(2,9)=6.*ES(3,9)/BL
      ES(3,5)=-ES(2,6)
      ES(5,5)=ES(2,2)
      ES(5,6)=-ES(2,3)
      ES(5,8)=ES(2,8)
      ES(5,9)=-ES(2,9)
      ES(6,6)=ES(3,3)
      ES(6,8)=-ES(3,8)
      ES(6,9)=ES(3,9)
      ES(8,8)=-8.*ES(3,8)/BL
      ES(9,9)=4.*ES(3,9)
C
      DO 10 J=2,9
      M=J-1
      DO 10 L=1,M
   10 ES(J,L)=ES(L,J)
C
CC    WRITE(IW6,101)((ES(I,J),J=1,9),I=1,9)
CC101 FORMAT('   ELEMENT STIFFNESS IN LOCAL COORDS'/(1X,9E12.4))
C
      T(1,1)=C
      T(2,2)=C
      T(1,2)=-S
      T(2,1)=S
C
      DO 22 JJJ=1,3
      DO 22 III=1,3
C
      DO 14 J=1,3
      JJ=3*(JJJ-1)+J
      DO 14 I=1,3
      ET(I,J)=0.
      DO 14 K=1,3
      II=3*(III-1)+K
   14 ET(I,J)=ET(I,J)+T(I,K)*ES(II,JJ)
C
      DO 15 J=1,3
      JJ=3*(JJJ-1)+J
      DO 15 I=1,3
      II=3*(III-1)+I
      EK(II,JJ)=ZERO
      DO 15 K=1,3
   15 EK(II,JJ)=EK(II,JJ)+ET(I,K)*T(J,K)
   22 CONTINUE
C----------SLOT EK INTO SG
      IC=0
      DO 40 KC=1,9
      DO 40 KR=1,KC
      IC=IC+1
   40 SG(IC)=EK(KR,KC)
C
CC    WRITE(IW6,102)((EK(I,J),J=1,9),I=1,9)
CC102 FORMAT('  ELEMENT STIFFNESS IN SYSTEM COORDS'/(1X,9E12.4))
      RETURN
      END
      SUBROUTINE LSTFBR(IW6,NE,MUS,INXL,SG,KSG,NN,NEL,NTPE,NPR,NMT,NDIM,
     +                  XYZ,NCORR,MAT,LT,PR,NTY)
C
C***********************************************************************
C     CALCULATION  OF STIFFNESS MATRIX FOR 3-NODED BAR ELEMENT (LT=1)
C***********************************************************************
C
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),NTY(NMT),
     +          PR(NPR,NMT),SG(KSG)
      DIMENSION T(3,3),ES(6,6),ET(2,2),EK(6,6)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
C *** INITIALIZE MATRICES
C
      DO 2 J=1,3
      DO 2 I=1,3
    2 T(I,J)=ZERO
      T(3,3)=1.
      DO 4 I=1,KSG
    4 SG(I)=ZERO
C
      KM=MAT(NE)
      IF(NTY(KM).NE.8) THEN
         WRITE(IW6,900)MUS,KM,NTY(KM)
         WRITE(IW15,900)MUS,KM,NTY(KM)
         WRITE(IWS,900)MUS,KM,NTY(KM)
  900    FORMAT(1X,'*** ERROR - ELEMENT',I5,4X,'WITH MAT ZONE NUMBER',
     +          I5,4X,'HAS INADMISSIBLE MAT TYPE NUMBER',I5/
     +          5X,'(ROUTINE LSTFBR)')
         STOP
      ENDIF
C
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
C
C *** CALCULATE BAR STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
      N3=NCORR(3,NE)
      N1=IABS(N1)
      N2=IABS(N2)
      N3=IABS(N3)
      C=XYZ(1,N2)-XYZ(1,N1)
      S=XYZ(2,N2)-XYZ(2,N1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 8 J=1,6
      DO 8 I=1,6
    8 ES(I,J)=ZERO
C
      ES(1,3)=(1./3.)*(E*A/BL)
      ES(1,1)=7.*ES(1,3)
      ES(1,5)=-8.*ES(1,3)
      ES(3,3)=ES(1,1)
      ES(3,5)=ES(1,5)
      ES(5,5)=16.*ES(1,3)
C
      DO 10 J=2,6
      M=J-1
      DO 10 L=1,M
   10 ES(J,L)=ES(L,J)
C
CC    WRITE(IW6,101)((ES(I,J),J=1,6),I=1,6)
CC101 FORMAT('   ELEMENT STIFFNESS IN LOCAL COORDS'/(1X,6E16.4))
C
      T(1,1)=C
      T(2,2)=C
      T(1,2)=-S
      T(2,1)=S
C
      DO 22 JJJ=1,3
      DO 22 III=1,3
C
      DO 14 J=1,2
      JJ=2*(JJJ-1)+J
      DO 14 I=1,2
      ET(I,J)=ZERO
      DO 14 K=1,2
      II=2*(III-1)+K
   14 ET(I,J)=ET(I,J)+T(I,K)*ES(II,JJ)
C
      DO 15 J=1,2
      JJ=2*(JJJ-1)+J
      DO 15 I=1,2
      II=2*(III-1)+I
      EK(II,JJ)=ZERO
      DO 15 K=1,2
   15 EK(II,JJ)=EK(II,JJ)+ET(I,K)*T(J,K)
   22 CONTINUE
C----------SLOT EK INTO SG
      IC=0
      DO 40 KC=1,6
      DO 40 KR=1,KC
      IC=IC+1
   40 SG(IC)=EK(KR,KC)
C
C
CC    WRITE(IW6,102)((EK(I,J),J=1,6),I=1,6)
CC102 FORMAT('  ELEMENT STIFFNESS IN SYSTEM COORDS'/(1X,6E16.4))
      RETURN
      END
      SUBROUTINE LSFBM2(IW6,NE,MUS,INXL,SG,KSG,NN,NEL,NTPE,NPR,NMT,NDIM,
     +                  XYZ,NCORR,MAT,LT,PR,NTY)
C
C***********************************************************************
C     CALCULATION  OF STIFFNESS MATRIX FOR 2-NODED BEAM ELEMENT (LT=15)
C***********************************************************************
C
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),NTY(NMT),
     +          PR(NPR,NMT),SG(KSG)
      DIMENSION T(3,3),ES(6,6),ET(3,3),EK(6,6)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
C *** INITIALIZE MATRICES
C
      DO 2 J=1,3
      DO 2 I=1,3
    2 T(I,J)=ZERO
      T(3,3)=1.
      DO 4 I=1,KSG
    4 SG(I)=ZERO
C
      KM=MAT(NE)
      IF(NTY(KM).NE.8) THEN
         WRITE(IW6,900)MUS,KM,NTY(KM)
  900    FORMAT(1X,'*** ERROR - ELEMENT',I5,4X,'WITH MAT ZONE NUMBER',
     +          I5,4X,'HAS INADMISSIBLE MAT TYPE NUMBER',I5/
     +          5X,'(ROUTINE LSTFBM)')
         STOP
      ENDIF
C
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      AI=PR(4,KM)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
C
C *** CALCULATE BEAM STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
CC    N3=NCORR(3,NE)
      N1=IABS(N1)
      N2=IABS(N2)
CC    N3=IABS(N3)
      C=XYZ(1,N2)-XYZ(1,N1)
      S=XYZ(2,N2)-XYZ(2,N1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 8 J=1,6
      DO 8 I=1,6
    8 ES(I,J)=ZERO
C
      ES(1,1)=E*A/BL
      ES(2,2)=12.*E*AI/(BL**3)
      ES(1,4)=-ES(1,1)
      ES(4,4)= ES(1,1)
      ES(2,5)=-ES(2,2)
      ES(2,3)=6.*E*AI/BL**2
      ES(2,6)= ES(2,3)
      ES(3,5)=-ES(2,3)
      ES(3,3)=4.*(E*AI/BL)
      ES(3,6)=2.*(E*AI/BL)
      ES(3,5)=-ES(2,6)
      ES(5,5)= ES(2,2)
      ES(5,6)=-ES(2,3)
      ES(6,6)= ES(3,3)
C
      DO 10 J=2,6
      M=J-1
      DO 10 L=1,M
   10 ES(J,L)=ES(L,J)
C
      WRITE(IW6,101)((ES(I,J),J=1,6),I=1,6)
  101 FORMAT('   ELEMENT STIFFNESS IN LOCAL COORDS'/(1X,9E12.4))
C
      T(1,1)=C
      T(2,2)=C
      T(1,2)=-S
      T(2,1)=S
C
      DO 22 JJJ=1,2
      DO 22 III=1,2
C
      DO 14 J=1,3
      JJ=3*(JJJ-1)+J
      DO 14 I=1,3
      ET(I,J)=0.
      DO 14 K=1,3
      II=3*(III-1)+K
   14 ET(I,J)=ET(I,J)+T(I,K)*ES(II,JJ)
C
      DO 15 J=1,3
      JJ=3*(JJJ-1)+J
      DO 15 I=1,3
      II=3*(III-1)+I
      EK(II,JJ)=ZERO
      DO 15 K=1,3
   15 EK(II,JJ)=EK(II,JJ)+ET(I,K)*T(J,K)
   22 CONTINUE
C----------SLOT EK INTO SG
      IC=0
      DO 40 KC=1,6
      DO 40 KR=1,KC
      IC=IC+1
   40 SG(IC)=EK(KR,KC)
C
C
      WRITE(IW6,102)((EK(I,J),J=1,6),I=1,6)
  102 FORMAT('  ELEMENT STIFFNESS IN SYSTEM COORDS'/(1X,9E12.4))
      RETURN
      END
      SUBROUTINE LSFBR2(IW6,NE,MUS,INXL,SG,KSG,NN,NEL,NTPE,NPR,NMT,NDIM,
     +                  XYZ,NCORR,MAT,LT,PR,NTY)
C
C***********************************************************************
C     CALCULATION  OF STIFFNESS MATRIX FOR 2-NODED BAR ELEMENT (LT=14)
C***********************************************************************
C
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),NTY(NMT),
     +          PR(NPR,NMT),SG(KSG)
      DIMENSION T(3,3),ES(4,4),ET(2,2),EK(4,4)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
C *** INITIALIZE MATRICES
C
      DO 2 J=1,3
      DO 2 I=1,3
    2 T(I,J)=ZERO
      T(3,3)=1.
      DO 4 I=1,KSG
    4 SG(I)=ZERO
C
      KM=MAT(NE)
      IF(NTY(KM).NE.8) THEN
         WRITE(IW6,900)MUS,KM,NTY(KM)
  900    FORMAT(1X,'*** ERROR - ELEMENT',I5,4X,'WITH MAT ZONE NUMBER',
     +          I5,4X,'HAS INADMISSIBLE MAT TYPE NUMBER',I5/
     +          5X,'(ROUTINE LSTFBR)')
         STOP
      ENDIF
C
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
C
C *** CALCULATE BAR STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
CC    N3=NCORR(3,NE)
      N1=IABS(N1)
      N2=IABS(N2)
CC    N3=IABS(N3)
      C=XYZ(1,N2)-XYZ(1,N1)
      S=XYZ(2,N2)-XYZ(2,N1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 8 J=1,4
      DO 8 I=1,4
    8 ES(I,J)=ZERO
C
      ES(1,1)=(E*A/BL)
      ES(1,3)=-ES(1,1)
      ES(3,3)=ES(1,1)
C
      DO 10 J=2,4
      M=J-1
      DO 10 L=1,M
   10 ES(J,L)=ES(L,J)
C
CC    WRITE(IW6,101)((ES(I,J),J=1,6),I=1,6)
CC101 FORMAT('   ELEMENT STIFFNESS IN LOCAL COORDS'/(1X,6E16.4))
C
      T(1,1)=C
      T(2,2)=C
      T(1,2)=-S
      T(2,1)=S
C
      DO 22 JJJ=1,2
      DO 22 III=1,2
C
      DO 14 J=1,2
      JJ=2*(JJJ-1)+J
      DO 14 I=1,2
      ET(I,J)=ZERO
      DO 14 K=1,2
      II=2*(III-1)+K
   14 ET(I,J)=ET(I,J)+T(I,K)*ES(II,JJ)
C
      DO 15 J=1,2
      JJ=2*(JJJ-1)+J
      DO 15 I=1,2
      II=2*(III-1)+I
      EK(II,JJ)=ZERO
      DO 15 K=1,2
   15 EK(II,JJ)=EK(II,JJ)+ET(I,K)*T(J,K)
   22 CONTINUE
C----------SLOT EK INTO SG
      IC=0
      DO 40 KC=1,4
      DO 40 KR=1,KC
      IC=IC+1
   40 SG(IC)=EK(KR,KC)
C
C
CC    WRITE(IW6,102)((EK(I,J),J=1,4),I=1,4)
CC102 FORMAT('  ELEMENT STIFFNESS IN SYSTEM COORDS'/(1X,6E16.4))
      RETURN
      END
      SUBROUTINE LSTIFA(SS,KSS,B,NS,NB,CARTD,NDN,NDIM,F,IPLSTK)
C***********************************************************************
C     FORM BT * D * B
C     ROUTINE LAST MODIFIED ON 21/11/83
C     (21/5/81,30/4/81)
C***********************************************************************
      DIMENSION SS(KSS),B(NS,NB),CARTD(NDIM,NDN)
      COMMON /FLOW/ NPLAX
      COMMON /DIN / DEL(3),DEP(21)
C
C-----------------------------------------------------------------------
C     SKIP IF 3-D
C-----------------------------------------------------------------------
      IF(NDIM.EQ.3)GOTO 60
      IF(IPLSTK.EQ.1)GO TO 46
C
      D11=DEL(1)*F
      D12=DEL(2)*F
      D44=DEL(3)*F
      IF(NPLAX.EQ.1)GO TO 38
C-----------------------------------------------------------------------
C     PLANE STRAIN - ELASTIC
C-----------------------------------------------------------------------
      KDX1=1
      KDX2=2
C
      DO 35 J=1,NDN
      DB11=D11*CARTD(1,J)
      DB21=D12*CARTD(1,J)
      DB41=D44*CARTD(2,J)
      DB12=D12*CARTD(2,J)
      DB22=D11*CARTD(2,J)
      DB42=D44*CARTD(1,J)
C
      DO 32 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB41*CARTD(2,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)+DB41*CARTD(1,I)
      SS(KDX2)=SS(KDX2)+DB12*CARTD(1,I)+DB42*CARTD(2,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
C
      KDX1=KDX1+2
   32 KDX2=KDX2+2
C
      KDX1=KDX2
   35 KDX2=KDX1+2*J+1
      GO TO 90
C-----------------------------------------------------------------------
C     AXI-SYMMETRIC  - ELASTIC
C-----------------------------------------------------------------------
   38 KDX1=1
      KDX2=2
C
      DO 44 J=1,NDN
      DB11=D11*CARTD(1,J)+D12*B(3,J)
      DB21=D12*CARTD(1,J)+D12*B(3,J)
      DB31=D12*CARTD(1,J)+D11*B(3,J)
      DB41=D44*CARTD(2,J)
      DB12=D12*CARTD(2,J)
      DB22=D11*CARTD(2,J)
      DB42=D44*CARTD(1,J)
C
      DO 42 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB31*B(3,I)+DB41*CARTD(2,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)+DB41*CARTD(1,I)
      SS(KDX2)=SS(KDX2)+DB12*(CARTD(1,I)+B(3,I))+DB42*CARTD(2,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
C
      KDX1=KDX1+2
   42 KDX2=KDX2+2
C
      KDX1=KDX2
   44 KDX2=KDX1+2*J+1
      GO TO 90
C-----------------------------------------------------------------------
C     PLANE STRAIN  -  PLASTIC
C-----------------------------------------------------------------------
   46 IF(NPLAX.EQ.1)GO TO 52
      D11=DEP(1)*F
      D12=DEP(2)*F
      D22=DEP(3)*F
      D14=DEP(7)*F
      D24=DEP(8)*F
      D44=DEP(10)*F
C
      KDX1=1
      KDX2=2
C
      DO 50 J=1,NDN
      DB11=D11*CARTD(1,J)+D14*CARTD(2,J)
      DB21=D12*CARTD(1,J)+D24*CARTD(2,J)
      DB41=D14*CARTD(1,J)+D44*CARTD(2,J)
      DB12=D12*CARTD(2,J)+D14*CARTD(1,J)
      DB22=D22*CARTD(2,J)+D24*CARTD(1,J)
      DB42=D24*CARTD(2,J)+D44*CARTD(1,J)
C
      DO 48 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB41*CARTD(2,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)+DB41*CARTD(1,I)
      SS(KDX2)=SS(KDX2)+DB12*CARTD(1,I)+DB42*CARTD(2,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
C
      KDX1=KDX1+2
   48 KDX2=KDX2+2
C
      KDX1=KDX2
   50 KDX2=KDX1+2*J+1
      GO TO 90
C-----------------------------------------------------------------------
C     AXI-SYMMETRIC  - PLASTIC
C-----------------------------------------------------------------------
   52 D11=DEP(1)*F
      D12=DEP(2)*F
      D22=DEP(3)*F
      D13=DEP(4)*F
      D23=DEP(5)*F
      D33=DEP(6)*F
      D14=DEP(7)*F
      D24=DEP(8)*F
      D34=DEP(9)*F
      D44=DEP(10)*F
C
      KDX1=1
      KDX2=2
C
      DO 58 J=1,NDN
      DB11=D11*CARTD(1,J)+D13*B(3,J)+D14*CARTD(2,J)
      DB21=D12*CARTD(1,J)+D23*B(3,J)+D24*CARTD(2,J)
      DB31=D13*CARTD(1,J)+D33*B(3,J)+D34*CARTD(2,J)
      DB41=D14*CARTD(1,J)+D34*B(3,J)+D44*CARTD(2,J)
      DB12=D12*CARTD(2,J)+D14*CARTD(1,J)
      DB22=D22*CARTD(2,J)+D24*CARTD(1,J)
      DB32=D23*CARTD(2,J)+D34*CARTD(1,J)
      DB42=D24*CARTD(2,J)+D44*CARTD(1,J)
C
      DO 56 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB31*B(3,I)+DB41*CARTD(2,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)+DB41*CARTD(1,I)
      SS(KDX2)=SS(KDX2)+DB12*CARTD(1,I)+DB32*B(3,I)+DB42*CARTD(2,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
C
      KDX1=KDX1+2
   56 KDX2=KDX2+2
C
      KDX1=KDX2
   58 KDX2=KDX1+2*J+1
      GOTO 90
C-----------------------------------------------------------------------
C     3-D
C-----------------------------------------------------------------------
   60 CONTINUE
      IF(IPLSTK.EQ.1)GOTO 70
C---------------------------------------------------------------------
C---------- ELASTIC 3-D
C---------------------------------------------------------------------
      D11=DEL(1)*F
      D12=DEL(2)*F
      D44=DEL(3)*F
C
      KDX1=1
      KDX2=2
      KDX3=4
C
      DO 64 J=1,NDN
      CADE1=CARTD(1,J)
      CADE2=CARTD(2,J)
      CADE3=CARTD(3,J)
C
      DB11=D11*CADE1
      DB21=D12*CADE1
      DB31=DB21
      DB41=D44*CADE2
      DB61=D44*CADE3
C
      DB12=D12*CADE2
      DB22=D11*CADE2
      DB32=DB12
      DB42=D44*CADE1
      DB52=DB61
C
      DB13=D12*CADE3
      DB23=DB13
      DB33=D11*CADE3
      DB53=DB41
      DB63=DB42
C
      DO 62 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB41*CARTD(2,I)+DB61*CARTD(3,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)+DB41*CARTD(1,I)
      IF(I.NE.J)SS(KDX1+2)=SS(KDX1+2)+DB31*CARTD(3,I)+DB61*CARTD(1,I)
C
      SS(KDX2)=SS(KDX2)+DB12*CARTD(1,I)+DB42*CARTD(2,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
     1                     +DB52*CARTD(3,I)
      IF(I.NE.J)SS(KDX2+2)=SS(KDX2+2)+DB32*CARTD(3,I)+DB52*CARTD(2,I)
C
      SS(KDX3)=SS(KDX3)+DB13*CARTD(1,I)+DB63*CARTD(3,I)
      SS(KDX3+1)=SS(KDX3+1)+DB23*CARTD(2,I)+DB53*CARTD(3,I)
      SS(KDX3+2)=SS(KDX3+2)+DB33*CARTD(3,I)+DB53*CARTD(2,I)
     1                     +DB63*CARTD(1,I)
C
      KDX1=KDX1+3
      KDX2=KDX2+3
   62 KDX3=KDX3+3
      KDX1=KDX3
      KDX2=KDX1+3*J+1
   64 KDX3=KDX2+3*J+2
      GOTO 90
C-----------------------------------------------------------------------
C---------- PLASTIC 3-D
C-----------------------------------------------------------------------
   70 D11=DEP(1)*F
      D12=DEP(2)*F
      D22=DEP(3)*F
      D13=DEP(4)*F
      D23=DEP(5)*F
      D33=DEP(6)*F
      D14=DEP(7)*F
      D24=DEP(8)*F
      D34=DEP(9)*F
      D44=DEP(10)*F
      D15=DEP(11)*F
      D25=DEP(12)*F
      D35=DEP(13)*F
      D45=DEP(14)*F
      D55=DEP(15)*F
      D16=DEP(16)*F
      D26=DEP(17)*F
      D36=DEP(18)*F
      D46=DEP(19)*F
      D56=DEP(20)*F
      D66=DEP(21)*F
C
      KDX1=1
      KDX2=2
      KDX3=4
C
      DO 74 J=1,NDN
      CADE1=CARTD(1,J)
      CADE2=CARTD(2,J)
      CADE3=CARTD(3,J)
C
      DB11=D11*CADE1+D14*CADE2+D16*CADE3
      DB21=D12*CADE1+D24*CADE2+D26*CADE3
      DB31=D13*CADE1+D34*CADE2+D36*CADE3
      DB41=D14*CADE1+D44*CADE2+D46*CADE3
      DB51=D15*CADE1+D45*CADE2+D56*CADE3
      DB61=D16*CADE1+D46*CADE2+D66*CADE3
C
      DB12=D12*CADE2+D14*CADE1+D15*CADE3
      DB22=D22*CADE2+D24*CADE1+D25*CADE3
      DB32=D23*CADE2+D34*CADE1+D35*CADE3
      DB42=D24*CADE2+D44*CADE1+D45*CADE3
      DB52=D25*CADE2+D45*CADE1+D55*CADE3
      DB62=D26*CADE2+D46*CADE1+D56*CADE3
C
      DB13=D13*CADE3+D15*CADE2+D16*CADE1
      DB23=D23*CADE3+D25*CADE2+D26*CADE1
      DB33=D33*CADE3+D35*CADE2+D36*CADE1
      DB43=D34*CADE3+D45*CADE2+D46*CADE1
      DB53=D35*CADE3+D55*CADE2+D56*CADE1
      DB63=D36*CADE3+D56*CADE2+D66*CADE1
C
      DO 72 I=1,J
      SS(KDX1)=SS(KDX1)+DB11*CARTD(1,I)+DB41*CARTD(2,I)
     1                 +DB61*CARTD(3,I)
      IF(I.NE.J)SS(KDX1+1)=SS(KDX1+1)+DB21*CARTD(2,I)
     1                               +DB41*CARTD(1,I)+DB51*CARTD(3,I)
      IF(I.NE.J)SS(KDX1+2)=SS(KDX1+2)+DB31*CARTD(3,I)
     1                               +DB51*CARTD(2,I)+DB61*CARTD(1,I)
C
      SS(KDX2)=SS(KDX2)+DB12*CARTD(1,I)+DB42*CARTD(2,I)+DB62*CARTD(3,I)
      SS(KDX2+1)=SS(KDX2+1)+DB22*CARTD(2,I)+DB42*CARTD(1,I)
     1                                     +DB52*CARTD(3,I)
      IF(I.NE.J)SS(KDX2+2)=SS(KDX2+2)+DB32*CARTD(3,I)
     1                               +DB52*CARTD(2,I)+DB62*CARTD(1,I)
C
      SS(KDX3)=SS(KDX3)+DB13*CARTD(1,I)+DB43*CARTD(2,I)+DB63*CARTD(3,I)
      SS(KDX3+1)=SS(KDX3+1)+DB23*CARTD(2,I)+DB43*CARTD(1,I)
     1                     +DB53*CARTD(3,I)
      SS(KDX3+2)=SS(KDX3+2)+DB33*CARTD(3,I)+DB53*CARTD(2,I)
     1                     +DB63*CARTD(1,I)
C
      KDX1=KDX1+3
      KDX2=KDX2+3
   72 KDX3=KDX3+3
      KDX1=KDX3
      KDX2=KDX1+3*J+1
   74 KDX3=KDX2+3*J+2
C
   90 CONTINUE
      RETURN
      END
      SUBROUTINE LSTIFF(K,MUS,INXL,SG,KSG,DTIME,NN,MXDF,NEL,NDF,NTPE,
     + NIP,NPR,NMT,NS,NB,NL,NDIM,NDMX,NVRS,NPMX,KSS,XYZ,
     + DA,P,VARINT,NCORR,KGVN,NMOD,MAT,LT,ELCOD,CARTD,SHFN,DS,
     + D,B,DB,SS,E,PE,RN,AA,ETE,RLT,CARTP,NWL,LL,PR,NTY)
C***********************************************************************
C     CALCULATION  AND  ASSEMBLY  OF  STIFFNESS  MATRIX
C     ROUTINE LAST MODIFIED ON 19/1/87
C     (2/1/87)
C***********************************************************************
      REAL L,LL               
crh   addition to include variability in permeability
      DIMENSION PERMO(3)
crh   END of addition 
crh   NOTE:
crh   The assumption is:
crh   The void ratio is changing linearly with the log of permeability
crh   This change is independent of the state of the stress (under and over
crh   the limit state/preconsolidation pressure are the same  
crh   Last modified  17 march 1995
      DIMENSION KP(29),KD(94),NWL(NPMX),NXP(15),NXD(15),LL(NL),PERM(3)
      DIMENSION PE(NDIM,NPMX),SG(KSG),SS(KSS)
      DIMENSION XYZ(NDIM,NN),DA(NDF),P(NDF),VARINT(NVRS,NIP,NEL)
      DIMENSION NCORR(NTPE,NEL),KGVN(MXDF,NN),MAT(NEL),D(NS,NS),NTY(NMT)
      DIMENSION E(NDIM,NPMX),RN(NB),AA(NPMX),ETE(NPMX,NPMX),RLT(NB,NPMX)
      DIMENSION ELCOD(NDIM,NDMX),SHFN(NDMX),
     + CARTD(NDIM,NDMX),B(NS,NB),DB(NS,NB),
     + DS(NDIM,NDMX),PR(NPR,NMT),CARTP(NDIM,NPMX)
      DIMENSION NMOD(NIP,NEL)
      COMMON /FLOW  / NPLAX
      COMMON /DATW  / W(100)
      COMMON /DATL  / L(4,100)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /JACB  / XJACI(3,3),DJACB
C-----------------------------------------------------------------------
C     INDEX TO ROWS/COLUMNS OF SG FOR ROWS/COLUMNS OF ETE
C     INDEX TO COLUMNS OF SG FOR COLUMNS OF RLT (FOR CONSOLIDATION)
C-----------------------------------------------------------------------
C---------- ELEMENT TYPE 3 - LST
      DATA KP(1),KP(2),KP(3)/
     + 3,6,9/
C---------- ELEMENT TYPE 5 - QUADRILATERAL
      DATA KP(4),KP(5),KP(6),KP(7)/
     + 3,6,9,12/
C---------- ELEMENT TYPE 7 - CUST
      DATA KP(8),KP(9),KP(10),KP(11),KP(12),KP(13),KP(14),KP(15),
     + KP(16),KP(17)/
     + 3,6,9,34,35,36,37,38,39,40/
C---------- ELEMENT TYPE 9 - BRICK
      DATA KP(18),KP(19),KP(20),KP(21),KP(22),KP(23),KP(24),KP(25)/
     + 4,8,12,16,20,24,28,32/
C---------- ELEMENT TYPE 11 - TETRA-HEDRA
      DATA KP(26),KP(27),KP(28),KP(29)/
     + 4,8,12,16/
C-----------------------------------------------------------------------
C     INDEX TO FIRST DISPLACEMENT VARIABLE OF EACH NODE IN SG
C     INDEX TO ROWS/COLUMNS OF SG FROM ROWS/COLUMNS OF SS
C     INDEX TO ROWS OF SG FOR ROWS OF RLT (FOR CONSOLIDATION ELEMENTS)
C-----------------------------------------------------------------------
C---------- ELEMENT TYPE 1(2), 2(6), 4(8), 6(15)
      DATA KD(1),KD(2),KD(3),KD(4),KD(5),KD(6),KD(7),KD(8),KD(9),KD(10),
     + KD(11),KD(12),KD(13),KD(14),KD(15)/
     + 1,3,5,7,9,11,13,15,17,19,21,23,25,27,29/
C---------- ELEMENT TYPE 8(20), 10(10)
      DATA KD(16),KD(17),KD(18),KD(19),KD(20),KD(21),KD(22),KD(23),
     + KD(24),KD(25),KD(26),KD(27),KD(28),KD(29),KD(30),KD(31),
     + KD(32),KD(33),KD(34),KD(35)/
     + 1,4,7,10,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58/
C---------- ELEMENT TYPE 3(6)
      DATA KD(36),KD(37),KD(38),KD(39),KD(40),KD(41)/
     + 1,4,7,10,12,14/
C---------- ELEMENT TYPE 5(8)
      DATA KD(42),KD(43),KD(44),KD(45),KD(46),KD(47),KD(48),KD(49)/
     + 1,4,7,10,13,15,17,19/
C---------- ELEMENT TYPE 7(15)
      DATA KD(50),KD(51),KD(52),KD(53),KD(54),KD(55),KD(56),KD(57),
     + KD(58),KD(59),KD(60),KD(61),KD(62),KD(63),KD(64)/
     + 1,4,7,10,12,14,16,18,20,22,24,26,28,30,32/
C---------- ELEMENT TYPE 9(20)
      DATA KD(65),KD(66),KD(67),KD(68),KD(69),KD(70),KD(71),KD(72),
     + KD(73),KD(74),KD(75),KD(76),KD(77),KD(78),KD(79),KD(80),
     + KD(81),KD(82),KD(83),KD(84)/
     + 1,5,9,13,17,21,25,29,33,36,39,42,45,48,51,54,57,60,63,66/
C---------- ELEMENT TYPE 11(10)
      DATA KD(85),KD(86),KD(87),KD(88),KD(89),
     + KD(90),KD(91),KD(92),KD(93),KD(94)/
     + 1,5,9,13,17,20,23,26,29,32/
C-----------------------------------------------------------------------
C     NXP AND NXD GIVE INDEX TO ARRAYS KP AND KD RESPECTIVELY
C     FOR DIFFERENT ELEMENT TYPES
C-----------------------------------------------------------------------
      DATA NXP(1),NXP(2),NXP(3),NXP(4),NXP(5),NXP(6),NXP(7),
     + NXP(8),NXP(9),NXP(10),NXP(11)/
     + 0,0,0,0,3,0,7,0,17,0,25/
      DATA NXD(1),NXD(2),NXD(3),NXD(4),NXD(5),NXD(6),NXD(7),
     + NXD(8),NXD(9),NXD(10),NXD(11)/
     + 0,0,35,0,41,0,49,15,64,15,84/
C-----------------------------------------------------------------------
      CR=1.0
      IF(NPLAX.EQ.1)CR=2.0*PYI
C---------- INITIALISE SS AND SG
      CALL ZEROR1(SS,KSS)
      CALL ZEROR1(SG,KSG)
C
      NDIM1=NDIM+1
      NDN=LINFO(5,LT)
      NPN=LINFO(6,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
      NDV=NDIM*NDN
      NDPT=LINFO(1,LT)
      GOTO(1,1,2,1,2,1,2,1,2,1,2),LT
    1 ICPL=0
      IBLK=1
      NPN=0
      GOTO 14
    2 ICPL=1
      IBLK=0
C---------- INITIALISE RLT AND ETE
      CALL ZEROR2(RLT,NB,NPMX)
      CALL ZEROR2(ETE,NPMX,NPMX)
C-----------------------------------------------------------------------
C     SET UP LOCAL ARRAY OF KGVN AS NWL GIVING THE INDEX TO
C     PORE-PRESSURE VARIABLES
C-----------------------------------------------------------------------
      IPP=0
C---------- INXL - INDEX TO NODAL D.O.F. (SEE ROUTINES BDATA1, MAXVAL)
      DO 12 IV=1,NDPT
      IQ=LINFO(IV+INXL,LT)
      IF(IQ.EQ.NDIM)GO TO 12
      IPP=IPP+1
      NDE=NCORR(IV,K)
      NDE=IABS(NDE)
C-----------------------------------------------------------------------
C     NWL - POINTER TO PORE PRESSURE VARIABLE
C-----------------------------------------------------------------------
      NWL(IPP)=KGVN(4,NDE)
   12 CONTINUE
C
   14 KM=MAT(K)
C-----------------------------------------------------------------------
C     LOCAL ARRAY OF COORDINATES OF DISPLACEMENT NODES OF ELEMENT
C-----------------------------------------------------------------------
      DO 20 KN=1,NDN
      NDE=NCORR(KN,K)
      NDE=IABS(NDE)
      DO 20 ID=1,NDIM
   20 ELCOD(ID,KN)=XYZ(ID,NDE)
CC    WRITE(IW6,666)NDN,NPN,NGP,INDX,NAC,NDV,NDPT
CC666 FORMAT(/5HNDN =,I5,2X,5HNPN =,I5,2X,5HNGP =,I5,6HINDX =,I5,
CC   + 5HNAC =,I5,2X,5HNDV =,I5,2X,6HNDPT =,I5)
CC    WRITE(IW6,667)ICPL,IBLK,KM
CC667 FORMAT(/1X,6HICPL =,I5,2X,6HIBLK =,I5,2X,4HKM =,I5)
CC    WRITE(IW6,801)ELCOD
CC801 FORMAT(/1X,5HELCOD/(1X,10F6.1))
C
      IF(NTY(KM)-2)26,28,28
C-----------------------------------------------------------------------
C     CONSTANT ELASTICITY D MATRIX
C-----------------------------------------------------------------------
   26 CALL DCON(K,MUS,IBLK,NEL,NDIM,NS,NPR,NMT,MAT,PR,D,IPLSTK)
C-----------------------------------------------------------------------
C     LOOP ON ALL INTEGRATION POINTS
C-----------------------------------------------------------------------
   28 DO 80 IP=1,NGP
      IPA=IP+INDX
      DO 30 IL=1,NAC
   30 LL(IL)=L(IL,IPA)
C-----------------------------------------------------------------------
C     FORM B MATRIX FOR CURRENT INTEGRATION POINT
C-----------------------------------------------------------------------
      ISTGE=3
      CALL FORMB2(K,MUS,R,RI,NDIM,NDMX,NDN,NS,
     +            NB,NAC,B,ELCOD,CARTD,SHFN,DS,LL,LT,IP,ISTGE)
      F9=CR*DJACB*W(IPA)
      ISTGE=4
      IF(ICPL.EQ.1)CALL FLOWST(K,NDIM,NPN,NS,NB,NAC,
     +                         B,E,RN,AA,CARTP,DS,LL,LT,IP,ISTGE)
      IF(NPLAX.EQ.1)F9=F9*R
      KGO=NTY(KM)
      GO TO(39,32,33,34,35,36,39,39),KGO
C-----------------------------------------------------------------------
C     D MATRIX
C-----------------------------------------------------------------------
   32 CALL DLIN(IP,K,MUS,IBLK,NEL,NDIM,NDN,NS,NPR,NMT,
     +          ELCOD,SHFN,MAT,D,PR,INDX)
      IPLSTK=0
      GO TO 39
   33 CALL DMCAM(IP,K,MUS,IBLK,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +           VARINT,MAT,D,PR,IPLSTK)
      GO TO 39
   34 CALL DCAM(IP,K,MUS,IBLK,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +          VARINT,MAT,D,PR,ITP,IPLSTK)
      GO TO 39
   35 CALL DELP(IP,K,MUS,IBLK,NEL,NIP,NVRS,NDIM,NDN,NS,NPR,NMT,
     +          ELCOD,SHFN,VARINT,MAT,D,PR,NMOD,0,IPLSTK)
      GO TO 39
   36 CALL DSCHO(IP,K,MUS,IBLK,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +           VARINT,MAT,D,PR,ITP,IPLSTK,IPROP)
C-----------------------------------------------------------------------
C     FORM D*B AND BT*D*B
C-----------------------------------------------------------------------
   39 CALL LSTIFA(SS,KSS,B,NS,NB,CARTD,NDN,NDIM,F9,IPLSTK)
C-----------------------------------------------------------------------
C     BYPASS IF NOT COUPLED CONSOLIDATION
C-----------------------------------------------------------------------
      IF(ICPL.EQ.0)GO TO 80
C-----------------------------------------------------------------------
C     FORM PERM*E
C-----------------------------------------------------------------------
crh      PERM(1)=PR(9,KM)
crh      PERM(2)=PR(10,KM)   
crh   replaced by 
      PERMO(1)=PR(9,KM)
      PERMO(2)=PR(10,KM)
      ENOL=PR(17,KM)
      EAKHIR=VARINT(6,IP,K)
      PERMCON1=PR(18,KM)
      PERMCON2=PR(19,KM)
      IF (IP.EQ.1) THEN
      WRITE(6,101)PERMO(1),PERMO(2),ENOL,EAKHIR   
      ENDIF
  101 FORMAT(/,1X,5H kx= ,E9.4,1X,5H ky= ,E9.4,1X,5H eo= ,F6.4,1X,
     +5H e1= ,1X,F6.4,/)
      IF (PERMCON1.EQ.0.0) GOTO 47
      IF (PERMCON1.EQ.1000.0)THEN
       PERMCON1=0.5*ENOL
      ENDIF       
      IF (PERMCON2.EQ.0.0) GOTO 47
      IF (PERMCON2.EQ.1000.0)THEN
       PERMCON2=0.5*ENOL
      ENDIF 
      PERMO(1)=PERMO(1)*10**((EAKHIR-ENOL)/PERMCON1)
      PERMO(2)=PERMO(2)*10**((EAKHIR-ENOL)/PERMCON2)
   47 PERM(1)=PERMO(1)
      PERM(2)=PERMO(2)
      VARINT(8,IP,K)=PERM(1)
      VARINT(9,IP,K)=PERM(2) 
C     only first integration point printed 
      IF (IP.EQ.1) THEN
      WRITE(6,102)PERM(1),PERM(2),PERMCON1,PERMCON2    
      ENDIF
  102 FORMAT(/,1X,6H kx1= ,E9.4,1X,6H ky1= ,E9.4,1X,6H Ckx= ,F9.4,     
     +6H Cky= ,F9.4/)
crh   end of replacement
      IF(KGO.NE.6)GOTO 45
C----------DIFFERENT PERMEABILITIES IN TENSILE CRACK REGION
C----------FOR ANS MODEL
      IF(IPROP.EQ.3) THEN
         PERM(1)=PR(15,KM)
         PERM(2)=PR(16,KM)
      ENDIF
   45 PERM(3)=PERM(1)
      GAMMAW=PR(7,KM)
C
      DO 40 JJ=1,NPN
      DO 40 IM=1,NDIM
      PE(IM,JJ)=PERM(IM)*E(IM,JJ)
   40 CONTINUE
C-----------------------------------------------------------------------
C     FORM ET*PERM*E
C-----------------------------------------------------------------------
      DO 50 II=1,NPN
      DO 50 JJ=1,NPN
      DO 50 KK=1,NDIM
   50 ETE(II,JJ)=ETE(II,JJ)+E(KK,II)*PE(KK,JJ)*DTIME*F9/GAMMAW
C-----------------------------------------------------------------------
C     FORM LT
C-----------------------------------------------------------------------
      DO 60 II=1,NDV
      DO 60 JJ=1,NPN
   60 RLT(II,JJ)=RLT(II,JJ)+RN(II)*AA(JJ)*F9
C-----------------------------------------------------------------------
C     END OF INTEGRATION POINT LOOP
C-----------------------------------------------------------------------
   80 CONTINUE
C
C-----------------------------------------------------------------------
C     BYPASS IF COUPLED CONSOLIDATION
C     CALCULATE NUMBER OF TERMS IN UPPER TRIANGLE OF MATRIX
C-----------------------------------------------------------------------
      IF(ICPL.EQ.1)GOTO 90
      NUT=NDV*(NDV+1)/2
C
      DO 84 IN=1,NUT
   84 SG(IN)=SS(IN)
      GOTO 200
CC    WRITE(6,901)((ETE(IU,JU),JU=1,NPN),IU=1,NPN)
CC901 FORMAT(4H0ETE/(1X,10E12.4))
CC    WRITE(6,902)(NWL(IU),IU=1,NPN)
CC902 FORMAT(4H0NWL/1X,15I6)
CC    WRITE(6,903)((RLT(IU,JU),JU=1,NPN),IU=1,NDV)
CC903 FORMAT(4H0RLT/(1X,10E12.4))
CC    WRITE(6,904)P
CC904 FORMAT(2H0P/(1X,10E12.4))
C
   90 INXD=NXD(LT)
C-----------------------------------------------------------------------
C     BYPASS IF NOT COUPLED CONSOLIDATION
C-----------------------------------------------------------------------
      IF(ICPL.EQ.0)GOTO 200
C-----------------------------------------------------------------------
C     COUPLED CONSOLIDATION
C-----------------------------------------------------------------------
      INXP=NXP(LT)
C-----------------------------------------------------------------------
C     CALCULATE RHS FOR PORE PRESSURES
C-----------------------------------------------------------------------
      DO 94 II=1,NPN
      N1=NWL(II)
      SUM=0.
      DO 92 JJ=1,NPN
      N2=NWL(JJ)
   92 SUM=SUM+ETE(II,JJ)*DA(N2)
   94 P(N1)=P(N1)+SUM
C-----------------------------------------------------------------------
C     FORM SG FROM SS
C-----------------------------------------------------------------------
C
      IF(NDIM.NE.2)GOTO 105
C *** FORM SG FROM SS FOR 2-D
      KDX1=1
      KDX2=2
      LDX1=1
      LDX2=2
      DO 100 J=1,NDN
      NQT=0
      DO 95 I=1,J
      NQL=LINFO(I+INXL,LT)
      NQT=NQT+NQL
      SG(KDX1)=SS(LDX1)
      IF(I.NE.J)SG(KDX1+1)=SS(LDX1+1)
      SG(KDX2)=SS(LDX2)
      SG(KDX2+1)=SS(LDX2+1)
      KDX1=KDX1+NQL
      KDX2=KDX2+NQL
      LDX1=LDX1+2
   95 LDX2=LDX2+2
      LDX1=LDX2
      LDX2=LDX1+2*J+1
      KDX1=KDX2
      KDX2=KDX2+NQT+1
      IF(NQL.NE.3)GO TO 100
      KDX1=KDX1+NQT-1
      KDX2=KDX2+NQT-1
  100 CONTINUE
C
  105 CONTINUE
      IF(NDIM.NE.3)GOTO 155
      KDX1=1
      KDX2=2
      KDX3=4
C
      LDX1=1
      LDX2=2
      LDX3=4
C
      DO 150 J=1,NDN
      JS=(J-1)*NDIM+1
      NQT=0
      DO 145 I=1,J
      IS=(I-1)*NDIM+1
      NQL=LINFO(I+INXL,LT)
      NQT=NQT+NQL
      SG(KDX1)=SS(LDX1)
      IF(I.NE.J)SG(KDX1+1)=SS(LDX1+1)
      IF(I.NE.J)SG(KDX1+2)=SS(LDX1+2)
C
      SG(KDX2)=SS(LDX2)
      SG(KDX2+1)=SS(LDX2+1)
      IF(I.NE.J)SG(KDX2+2)=SS(LDX2+2)
C
      SG(KDX3)=SS(LDX3)
      SG(KDX3+1)=SS(LDX3+1)
      SG(KDX3+2)=SS(LDX3+2)
C
      LDX1=LDX1+3
      LDX2=LDX2+3
      LDX3=LDX3+3
C
      KDX1=KDX1+NQL
      KDX2=KDX2+NQL
      KDX3=KDX3+NQL
  145 CONTINUE
C
      LDX1=LDX3
      LDX2=LDX1+3*J+1
      LDX3=LDX2+3*J+2
C
      KDX1=KDX3
      KDX2=KDX1+NQT+1
      KDX3=KDX2+NQT+2
      IF(NQL.NE.NDIM1)GO TO 150
C
      KDX1=KDX1+NQT-1
      KDX2=KDX2+NQT-1
      KDX3=KDX3+NQT-1
  150 CONTINUE
C-----------------------------------------------------------------------
C     SLOT RLT
C-----------------------------------------------------------------------
  155 CONTINUE
      DO 160 JA=1,NPN
      NJA=KP(JA+INXP)
      NCN=NJA*(NJA-1)/2
      DO 160 I=1,NDN
      NI=KD(I+INXD)-1
      DO 160 ID=1,NDIM
      NIA=NI+ID
      IA=I+(ID-1)*NDN
      LOC=NIA+NCN
      IF(NIA.GT.NJA)LOC=NIA*(NIA-1)/2+NJA
  160 SG(LOC)=RLT(IA,JA)
C-----------------------------------------------------------------------
C     SLOT ETE
C-----------------------------------------------------------------------
      DO 180 JE=1,NPN
      NJ=KP(JE+INXP)
      NCN=NJ*(NJ-1)/2
      DO 180 IE=1,JE
      NI=KP(IE+INXP)
  180 SG(NI+NCN)=-ETE(IE,JE)
  200 CONTINUE
      NR=LINFO(16,LT)
      NT=NR*(NR+1)/2
CC    WRITE(IW6,910)MUS,KM,NTY(KM)
CC910 FORMAT(/1X,'ELEMENT',I5,4X,'MAT ZONE NO.',I5,4X,
CC   +           'MAT TYPE NO.',I5/)
CC    CALL PRINTI(IW6,SG,NT,NR,P,NDF)
      RETURN
      END
      SUBROUTINE LSTSLP(IW6,NE,MUS,INXL,SG,KSG,NN,NEL,NTPE,NIP,NPR,NMT,
     +                  NDIM,NVRS,XYZ,VARINT,NCORR,MAT,LT,PR,NTY)
C
C***********************************************************************
C     CALCULATION  OF STIFFNESS MATRIX FOR 8-NODED SLIP ELEMENT (LT=13)
C***********************************************************************
C
      REAL L
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),MAT(NEL),NTY(NMT),
     +          VARINT(NVRS,NIP,NEL),PR(NPR,NMT),SG(KSG)
      DIMENSION T(3,3),D(3,3),SHF(3),DER(3),COD(2,6),CODS(2,6),
     +          B(3,12),BN(3,12),DB(3,12),ES(12,12)
      COMMON /FLOW / NPLAX
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /PROP / COH,PHI,AKN,AKS,AKSRES
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      CR=1.
      IF(NPLAX.EQ.1) CR=2.*PYI
C
C *** INITIALIZE MATRICES
C
      DO 10 J=1,3
      DO 10 I=1,3
   10 T(I,J)=ZERO
      T(3,3)=1.
      DO 20 I=1,KSG
   20 SG(I)=ZERO
C
      KM=MAT(NE)
      IF(NTY(KM).NE.8) THEN
         WRITE(IW6,900)MUS,KM,NTY(KM)
         WRITE(IW15,900)MUS,KM,NTY(KM)
         WRITE(IWS,900)MUS,KM,NTY(KM)
  900    FORMAT(1X,'*** ERROR - ELEMENT',I5,4X,'WITH MAT ZONE NUMBER',
     +          I5,4X,'HAS INADMISSIBLE MAT TYPE NUMBER',I5/
     +          5X,'(ROUTINE LSTSLP)')
         STOP
      ENDIF
C
      COH=PR(1,KM)
      PHI=PR(2,KM)*ATAN(1.0)/45.
      AKN=PR(3,KM)
      AKS=PR(4,KM)
      AKSRES=PR(5,KM)
      THICK=PR(6,KM)
C
C *** CALCULATE STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
      N3=NCORR(3,NE)
      N4=NCORR(4,NE)
      N5=NCORR(5,NE)
      N6=NCORR(7,NE)
      N1=IABS(N1)
      N2=IABS(N2)
      N3=IABS(N3)
      N4=IABS(N4)
      N5=IABS(N5)
      N6=IABS(N6)
      C=(XYZ(1,N2)+XYZ(1,N3))*0.5-(XYZ(1,N1)+XYZ(1,N4))*0.5
      S=(XYZ(2,N2)+XYZ(2,N3))*0.5-(XYZ(2,N1)+XYZ(2,N4))*0.5
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      COD(1,1)=XYZ(1,N1)
      COD(2,1)=XYZ(2,N1)
      COD(1,2)=XYZ(1,N2)
      COD(2,2)=XYZ(2,N2)
      COD(1,3)=XYZ(1,N5)
      COD(2,3)=XYZ(2,N5)
C
      COD(1,4)=XYZ(1,N4)
      COD(1,5)=XYZ(1,N3)
      COD(1,6)=XYZ(1,N6)
C
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
C
      DO 25 I=1,2
      DO 25 J=1,6
   25 CODS(I,J)=COD(I,J)
C
      CALL ROTAT(COD,NDIM,3,DL,T)
C
      DO 40 I=1,12
      DO 40 J=1,12
   40 ES(I,J)=ZERO
C
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      SHF(1)=XI*(XI-1.)/2.
      SHF(2)=XI*(XI+1.)/2.
      SHF(3)=(1.+XI)*(1.-XI)
C
C--------CALCULATE X (OR R)
      R=0.
      DO 50 I=1,3
      R=R+0.5*SHF(I)*CODS(1,I)+0.5*SHF(I)*CODS(1,I+3)
   50 CONTINUE
C
      DER(1)=(2.*XI-1.)/2.
      DER(2)=(2.*XI+1.)/2.
      DER(3)=-2.*XI
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,3
   60 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)NE,IP,DJACB
         WRITE(IW15,910)NE,IP,DJACB
         WRITE(IWS,910)NE,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=CR*DJACB*W(IPA)*THICK
      IF(NPLAX.EQ.1)FAC=FAC*R
CC    WRITE(6,710)SHF,DER
CC710 FORMAT(/1X,'SHF & DER'/(1X,9E14.5))
C
C--------- CALCULATE D MATRIX
      CALL DSLIP(NVRS,NIP,NEL,VARINT,D,IP,NE)
C
      DO 70 IS=1,3
      DO 70 IN=1,12
      B(IS,IN)=ZERO
   70 BN(IS,IN)=ZERO
C----------CALCULATE B MATRIX
      B(1,2)= SHF(1)/THICK
      B(1,4)= SHF(2)/THICK
      B(1,6)=-SHF(2)/THICK
      B(1,8)=-SHF(1)/THICK
      B(1,10)= SHF(3)/THICK
      B(1,12)=-SHF(3)/THICK
C
      B(2,1)= SHF(1)/THICK
      B(2,3)= SHF(2)/THICK
      B(2,5)=-SHF(2)/THICK
      B(2,7)=-SHF(1)/THICK
      B(2,9)= SHF(3)/THICK
      B(2,11)=-SHF(3)/THICK
C
      IF(NPLAX.EQ.1) THEN
         BN(3,1)=-SHF(1)/(R)
         BN(3,3)=-SHF(2)/(R)
         BN(3,5)=-SHF(2)/(R)
         BN(3,7)=-SHF(1)/(R)
         BN(3,9)=-SHF(3)/(R)
         BN(3,11)=-SHF(3)/(R)
      ENDIF
C
      DO 90 IN=1,6
C
      DO 80 I=1,2
      DO 80 J=1,2
      NJ=2*(IN-1)+J
      DO 80 K=1,2
      NK=2*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   80 CONTINUE
   90 CONTINUE
C
C----------CALCULATE BD = B * D
      DO 140 KC=1,12
      DO 140 KR=1,3
      SUM=ZERO
      DO 130 J=1,3
  130 SUM=SUM+D(KR,J)*BN(J,KC)
      DB(KR,KC)=SUM
  140 CONTINUE
C----------CALCULATE STIFFNESS MATRIX
      DO 160 KC=1,12
      DO 160 KR=1,12
      SUM=ZERO
      DO 150 J=1,3
  150 SUM=SUM+BN(J,KR)*DB(J,KC)*FAC
  160 ES(KR,KC)=ES(KR,KC)+SUM
  200 CONTINUE
CC    WRITE(IW6,902)NE,((ES(I,J),J=1,12),I=1,12)
CC902 FORMAT(/'  ELEMENT STIFFNESS - ES',I6/(1X,6E15.4))
C
C---------SLOT ES INTO SG
      IC=0
      DO 240 KC=1,12
      DO 240 KR=1,KC
      IC=IC+1
  240 SG(IC)=ES(KR,KC)
      RETURN
      END
      SUBROUTINE MAKENZ(NTPE,NEL,NN,MXDF,NCORR,LTYP,NQ,INXL,KDF)
C***********************************************************************
C     SETS UP THE NQ ARRAY WHICH CONTAINS THE NUMBER
C     OF DEGREES OF FREEDOM ASSOCIATED WITH EACH NODE
C     FOR ELEMENTS IN THIS ASSEMBLY.
C     ARRAY KDF THEN GIVES THE NODAL VARIABLE NUMBER FOR THE UNIVERSAL
C     VARIABLE NUMBER.
C***********************************************************************
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),NQ(NN),KDF(MXDF,NN)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C
C *** INXL - INDEX TO NO. OF DEGREES OF FREEDOM OF FIRST NODE OF ELEMENT
C *** (SEE BLOCK DATA ROUTINES BDATA1, MAIN2)
C
      DO 10 J=1,NN
      NQ(J)=0
      DO 10 I=1,MXDF
   10 KDF(I,J)=0
C
      DO 30 J=1,NEL
      IF(LTYP(J).LT.0) GOTO 30
      LT=LTYP(J)
      NDPT=LINFO(1,LT)
C
      DO 20 I=1,NDPT
      NDFN=LINFO(I+INXL,LT)
      IF(NDFN.EQ.0)GOTO 20
      NOD=NCORR(I,J)
C
      DO 15 IV=1,NDFN
      INX=MINFO(IV,I,LT)
      IF(KDF(INX,NOD).NE.0)GOTO 15
      NQ(NOD)=NQ(NOD)+1
      KDF(INX,NOD)=1
   15 CONTINUE
C
   20 CONTINUE
   30 CONTINUE
C
      DO 50 I=1,NN
      IVN=0
      DO 40 J=1,MXDF
      IF(KDF(J,I).EQ.0)GOTO 40
      IVN=IVN+1
      KDF(J,I)=IVN
   40 CONTINUE
      IF(IVN.EQ.NQ(I))GOTO 50
      WRITE(IW6,900)I,IVN,NQ(I),(KDF(JJ,I),JJ=1,MXDF)
      WRITE(IW15,900)I,IVN,NQ(I),(KDF(JJ,I),JJ=1,MXDF)
      WRITE(IWS,900)I,IVN,NQ(I),(KDF(JJ,I),JJ=1,MXDF)
  900 FORMAT(/1X,'****ERROR - PROGRAM NODE',I5,2X,'HAS INCONSISTENT',
     +       1X,'SET OF D.O.F',2I5/1X,'D.O.F LIST -',6I5/
     +       1X,'(ROUTINE MAKENZ)')
   50 CONTINUE
      RETURN
      END
      SUBROUTINE MAST2(G,LG,K,LK,LGMX,LKMX)
C***********************************************************************
C     ROUTINE TO SET-UP ARRAY SIZES AND INDEXES FOR MAIN PROGRAM.
C     REAL ARRAYS ARE ALLOCATED TO THE LEFT
C     OF ARRAY G AND INTEGER ARRAYS TO THE RIGHT
C     ROUTINE LAST UPDATED ON 1/09/92
C     (1/10/91,1/6/88,19/1/87,2/1/87,12/4/86,12/11/85)
C***********************************************************************
      CHARACTER*1 JDO,TITLE
      REAL L,LL
      INTEGER TF
      DIMENSION G(LG),K(LK)
      DIMENSION KLT(15),NTY(100),PR(20,100),PDISLD(3,5), 
CRA ORIGINALLY     NTY(25),NPR(16,25) 
     +          PRES(3,5),V(5),FXYZ(3),CIP(3),LL(4)
      COMMON /LABEL / TITLE(80)
      COMMON /FLOW  / NPLAX
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /PRLDI / PRSLDI(10,400),LEDI(400),NDI1(400),NDI2(400),ILOD
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
      COMMON /FFL   / JDO(130)
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /SAMP  / POSSP(5),WEIGP(5)
      COMMON /POINT / IPT(6),KPT(6)
      COMMON /DEBUGS/ IDB(10)
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /EQBM  / RMAX(6),TER(3),IW16
      COMMON /MP92/NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
     + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN
CT   + INXL,MXEN,MXLD,MXFXT,LV,LL,MCORE,NVTX,ND,MDZ,NEDZ,KSS
C
C *** DEVICE NUMBERS R - READ ; W - WRITE ; P - PLOT
      IR1=11
      IR4=4
      IR5=5
      IW2=12
      IW4=4
      IW6=6
      IW7=7
      IWP=8
      IW9=9
      LUN=IR5
      IW14=14
      IW15=15
      IWS=2
      IW16=16
C
C *** SET SOME CONSTANTS
      PYI=4.*ATAN(1.)
      ALAR=1.E+17
      ASMVL=1.E-20
      ZERO=0.
C
      DO 5 IB=1,10
    5 IDB(IB)=0
C-----------------------------------------------------------------------
C     READ FIRST PART OF LINK FILE
C-----------------------------------------------------------------------
      REWIND IR4
      READ(IR4,ERR=100,END=150)LINK1
      READ(IR4,ERR=100,END=150)NN,NVTX,ND,MXDF,NNZ,NDZ,MDZ,NEDZ
      READ(IR4,ERR=100,END=150)NEL,MUMAX
      READ(IR4,ERR=100,END=150)NDF,NDIM,NTPE,NPL,LTZ,INXL
      READ(IR4,ERR=100,END=150)IFRZ,MAXNFZ,MCORE,NCORET
      READ(IR4,ERR=100,END=150)(KLT(IK),IK=1,LTZ)
CC    WRITE(IW6,801)NN,NVTX,ND,MXDF,NNZ,NDZ
CC    WRITE(IW6,802)NEL,MUMAX
CC    WRITE(IW6,803)NDF,NDIM,NTPE,NPL,LTZ,INXL
CC    WRITE(IW6,804)IFRZ,MAXNFZ,MCORE,NCORET
CC    WRITE(IW6,805)(KLT(IK),IK=1,LTZ)
CC801 FORMAT(/1X,2HNN,I5,2X,4HNVTX,I5,2X,2HND,I5,2X,
CC   + 4HMXDF,I5,2X,3HNNZ,I5,2X,3HNDZ,I5)
CC802 FORMAT(/1X,3HNEL,I5,2X,5HMUMAX,I5)
CC803 FORMAT(/1X,3HNDF,I5,2X,4HNDIM,I5,2X,4HNTPE,I5,2X,
CC   + 3HNPL,I5,2X,3HLTZ,I5,2X,4HINTL,I5)
CC804 FORMAT(/1X,4HIFRZ,I5,2X,6HMAZNFX,I5,2X,5HMCORE,I5,2X,
CC   + 6HNCORET,I5)
CC805 FORMAT(/1X,3HKLT,12I5)
C
      WRITE(IW6,900)
      READ(LUN,901)TITLE
      NCARD=1
      WRITE(IW6,903)TITLE
C
      CALL FFIN(1,1)
      LINK2=IFIX(AR(1))
      IF(LINK1.EQ.LINK2)GOTO 1
CX    WRITE(IW6,905)LINK1,LINK2
CX    WRITE(IW15,905)LINK1,LINK2
CX    WRITE(IWS,905)LINK1,LINK2
CX    STOP
C
    1 WRITE(IW6,906)LINK1
C
C-----------------------------------------------------------------------
C *** NVRS  - NUMBER OF STRESS PARAMETERS
C *** NVRN  - NUMBER OF STRAIN AND STRESS COMPONENTS
C-----------------------------------------------------------------------    
cra   change to accomodate the current permeability at nvrs =8
cra      NVRS=7  
      NVRS=9
cra
      NVRN=4
      IF(NDIM.NE.3)GOTO 10
CRA      NVRS=9     
      NVRS=11
      NVRN=6
   10 CALL MAXVAL(IW6,KLT,LTZ,NDIM,NVRN,NDMX,NPMX,NIP,NS,NB,NL,NPT,NSP,
     + NPR,NMT,MDFE,KES,KSS,NVPN,LV,MXEN,MXLD,MXFXT,MXDF,ICTL)
C-----------------------------------------------------------------------
C     G(1) -  G(L1-1) = COORDINATES OF NODES................XYZ(NDIM,NN)
C    G(L1) -  G(L2-1) = INCREMENTAL DISPLACEMENTS................DI(NDF)
C    G(L2) -  G(L3-1) =  CUMULATIVE DISPLACEMENTS................DA(NDF)
C    G(L3) -  G(L4-1) = STRESS PARS AT GAUSS POINTS.VARINT(NVRS,NIP,NEL)
C    G(L4) -  G(L5-1) = INCREMENTAL NODAL LOADS...................P(NDF)
C    G(L5) -  G(L6-1) =  CUMULATIVE NODAL LOADS..................PT(NDF)
C    G(L6) -  G(L7-1) = NODAL LOADS FOR INCREMENTAL BLOCK.......PIB(NDF)
C    G(L7) -  G(L8-1) = REACTIONS TO EARTH.....................REAC(NDF)
C    G(L8) -  G(L9-1) = OUT OF BALANCE LOADS...................PCOR(NDF)
C    G(L9) - G(L10-1) = TOTAL EQUILIBRIUM LOADS................PEQT(NDF)
C   G(L10) - G(L11-1) = INCREMENTAL POINT LOADS................XYFT(NDF)
C   G(L11) - G(L12-1) = POINT LOADS FOR INCREMENTAL BLOCK.....XYFIB(NDF)
C   G(L12) - G(L13-1) = STRAIN PARS AT GAUSS POINTS....STR(NVRN,NIP,NEL)
C   G(L13) - G(L14-1) = EXCAVATION LOADS FOR INCR BLOCK.......PEXIB(NDF)
C   G(L14) - G(L15-1) = EXCAVATION LOADS FOR INCREMENT.........PEXI(NDF)
C   G(L15) - G(LS1-1) = INSITU EQUILIBRIUM POINT LOADS........PCONI(NDF)
C   G(LS1) - G(LS2-1) = D (STRESS - STRAIN ) MATRIX.............D(NS,NS)
C   G(LS2) - G(LS3-1) = DISP. NODE COORDS. OF ELEMENT...ELCOD(NDIM,NDMX)
C   G(LS3) - G(LS4-1) = DERIVATIVES OF SHAPE FUNS(LOCAL)...DS(NDIM,NDMX)
C   G(LS4) - G(LS5-1) = SHAPE FUNCTIONS.......................SHFN(NDMX)
C   G(LS5) - G(LS6-1) = CARTESIAN DERIV. OF DISP SHFN...CARTD(NDIM,NDMX)
C   G(LS6) - G(LS7-1) = STRAIN - DISPLACEMENT MATRIX............B(NS,NB)
C   G(LS7) - G(LS8-1) = D * B MATRIX...........................DB(NS,NB)
C   G(LS8) - G(LS9-1) = ELEMENT FORCE MATRIX...............FT(NDIM,NDMX)
C   G(LS9) -G(LS10-1) = ELEMENT STIFFNESS MATRIX (TRIANGULAR)....SS(KSS)
C  G(LS10) - G(LC1-1) = UPPER TRIANGULAR ELEMENT STIFF MATRIX....ES(KES)
C   G(LC1) - G(LC2-1) = PORE PRESSURE GRADIENTS.............E(NDIM,NPMX)
C   G(LC2) - G(LC3-1) = PERMEABILITY * POREPRES GRADIENTS..PE(NDIM,NPMX)
C   G(LC3) - G(LC4-1) = AN ARRAY FOR LINK MATRIX..................RN(NB)
C   G(LC4) - G(LC5-1) = AN ARRAY FOR LINK MATRIX................AA(NPMX)
C   G(LC5) - G(LC6-1) = FLOW MATRIX.......................ETE(NPMX,NPMX)
C   G(LC6) - G(LC7-1) = LINK MATRIX.........................RLT(NB,NPMX)
C   G(LC7) - G(LC8-1) = CARTESIAN DERIV OF PP SHFN......CARTP(NDIM,NPMX)
C   G(LC8) - G(LC9-1) = IN SITU PORE PRESSURES AT NODES.......PORINS(NN)
C
C   WHERE
C     KES   - MAXM SIZE OF UPPER TRIANGULAR ELEMENT STIFFNESS MATRIX
C     NB    - SIZE OF STIFFNESS MATRIX SS ( = NDIM * NDMX )
C     NDF   - TOTAL NO. OF D.O.F. IN PROBLEM
C     NDIM  - DIMENSION OF PROBLEM (2 OR 3)
C     NDMX  - MAXM NO. OF DISP. NODES IN ANY ELEMENT IN MESH
C     NEL   - TOTAL NO. OF ELEMENTS IN MESH
C     NIP   - MAXM NO. OF INTEGRATION POINTS IN ANY ELEMENT IN MESH
C     NN    - TOTAL NO. OF NODES IN MESH
C     NPMX  - MAXM NO. OF P.P. NODES IN ANY ELEMENT IN MESH
C     NS    - SIZE OF D - MATRIX ( = NO. OF STRESS/STRAIN COMPONENTS)
C     NVRN  - NO. OF STRAIN (AND STRESS) COMPONENTS
C     NVRS  - NO. OF STRESS COMPONENTS PLUS PARAMETERS (U,P,Q ETC.)
C-----------------------------------------------------------------------
C *** INDEXES FOR REAL ARRAYS - LEFT HAND SIDE
      L1=1+NDIM*NN
      L2=L1+NDF
      L3=L2+NDF
      L4=L3+NVRS*NIP*NEL
      L5=L4+NDF
      L6=L5+NDF
      L7=L6+NDF
      L8=L7+NDF
      L9=L8+NDF
      L10=L9+NDF
      L11=L10+NDF
      L12=L11+NDF
      L13=L12+NVRN*NIP*NEL
      L14=L13+NDF
      L15=L14+NDF
      LS1=L15+NDF
      LS2=LS1+NS*NS
      LS3=LS2+NDIM*NDMX
      LS4=LS3+NDIM*NDMX
      LS5=LS4+NDMX
      LS6=LS5+NDIM*NDMX
      LS7=LS6+NS*NB
      LS8=LS7+NS*NB
      LS9=LS8+NDIM*NDMX
      LS10=LS9+KSS
      LC1=LS10+KES
      LC2=LC1+NDIM*NPMX
      LC3=LC2+NDIM*NPMX
      LC4=LC3+NB
      LC5=LC4+NPMX
      LC6=LC5+NPMX*NPMX
      LC7=LC6+NB*NPMX
      LC8=LC7+NDIM*NPMX
      LC9=LC8+NN
      LZ=LC9
CC    WRITE(IW6,807)L5,L10,LS10,LZ
CC807 FORMAT(/1X,2HL5,I8,2X,3HL10,I8,2X,4HLS10,I8,2X,2HLZ,I8)
C-----------------------------------------------------------------------
C    K(N1) -  K(N2-1) = ELEMENT-NODAL CONNECTIVITY.......NCORR(NTPE,NEL)
C    K(N2) -  K(N3-1) = MATERIAL PROPERTY NUMBER................MAT(NEL)
C    K(N3) -  K(N4-1) = ELEMENT TYPE NUMBER....................LTYP(NEL)
C    K(N4) -  K(N5-1) = USER ELEMENT NUMBERS.................MRELVV(NEL)
C    K(N5) -  K(N6-1) = PROGRAM ELEMENT MUMBERS..............MREL(MUMAX)
C    K(N6) -  K(N7-1) = USER NODE NUMBERS.....................NRELVV(NN)
C    K(N7) -  K(N8-1) = PROGRAM NODE NUMBERS...................NREL(NNZ)
C    K(N8) -  K(N9-1) = GLOBAL VARIABLE NUMBERS............KGVN(MXDF,NN)
C    K(N9) - K(N10-1) = NO. OF D.O.F. OF EACH NODE................NQ(NN)
C   K(N10) - K(N11-1) = INDICATOR OF ELEMENT CHANGES............JEL(NEL)
C   K(N11) - K(N12-1) = INDICATOR OF RESTRIANED VARIABLES......IDFX(NDF)
C   K(N12) - K(N13-1) = FRONTAL DESTINATION OF NODES...........NDEST(NN)
C   K(N13) - K(N14-1) = INDEX OF ONE END OF ELEMENT EDGE........NP1(NPL)
C   K(N14) - K(NS1-1) = INDEX OF OTHER END OF ELEMENT EDGE......NP2(NPL)
C   K(NS1) - K(NS2-1) = LIST OF NODES (AND D.O.F.) IN FRONT....IFR(IFRZ)
C   K(NS2) - K(NS3-1) = DESTINATION IN FRONT OF ELEMENT D.O.F..NDL(MDFE)
C   K(NS3) - K(NS4-1) = INDEX TO POREPRESSURE DOF OF ELEMENT...NWL(NPMX)
C   K(NS4) - K(NS5-1) = STRESS STATE INDICATOR FOR MODEL5..NMOD(NIP,NEL)
C   K(NS5) - K(NS6-1) = FLAG TO INDICATE PRESENCE OF D.O.F..KDF(MXDF,NN)
C
C   WHERE   (ONLY IF NOT DEFINED PREVIOUSLY)
C
C     IFRZ  - LENGTH OF ARRAY IFR
C     MDFE  - MAXM NO. OF D.O.F. IN ANY ELEMENT IN MESH
C     MUMAX - MAXM VALUE OF USER ELEMENT NUMBER
C     NNZ   - MAXM VALUE OF USER NODE NUMBER
C-----------------------------------------------------------------------
C *** INDEXES FOR INTEGER ARRAYS - RIGHT HAND SIDE
      N1=1
      N2=N1+NTPE*NEL
      N3=N2+NEL
      N4=N3+NEL
      N5=N4+NEL
      N6=N5+MUMAX
      N7=N6+NN
      N8=N7+NNZ
      N9=N8+MXDF*NN
      N10=N9+NN
      N11=N10+NEL
      N12=N11+NDF
      N13=N12+NN
      N14=N13+NPL
      NS1=N14+NPL
      NS2=NS1+IFRZ
      NS3=NS2+MDFE
      NS4=NS3+NPMX
      NS5=NS4+NIP*NEL
      NS6=NS5+MXDF*NN
      NZ=NS6
C-----------------------------------------------------------------------
C     CALCULATE SIZE OF WORKING REGION
C-----------------------------------------------------------------------
      NWORK=LG-LZ+1
      KVARS=LZ-1
      INCORE=NCORET-MCORE
      WRITE(IW6,915)LG,KVARS,NWORK,MCORE,INCORE
      NCV=10
      NSTP=10
      NVL=200
      NIEL=NIP*NEL
C
      IERM=0
C--------SIZE OF  REAL   ARRAY REQUIRED AT OUTPUT STAGE
C
      MOUTR=NCV*NIEL+NSTP*NVL+NVL
      MCR=MOUTR
      IF(MCORE.GT.MOUTR)MCR=MCORE
      IF(NWORK.GT.MCR)GOTO 50
      INCLG=MCR-NWORK
      WRITE(IW6,912)INCLG
      WRITE(IW15,912)INCLG
CC    WRITE(IWS,912)INCLG
      IERM=IERM+1
   50 CONTINUE
C
      KWORK=LK-NZ+1
C--------SIZE OF INTEGER ARRAY REQUIRED AT OUTPUT STAGE
      MOUTI=3*NIEL+5*NEL
      IF(KWORK.GT.MOUTI)GOTO 60
      INCLK=MOUTI-KWORK
      WRITE(IW6,913)INCLK
      WRITE(IW15,913)INCLK
      IERM=IERM+1
   60 CONTINUE
      IF(IERM.GT.0) STOP
CC    MTOTG=KVARS+MCR
CC    WRITE(IW6,922)MTOTG,LG
      IBUF=NWORK-MCORE
      WRITE(IW6,920)IBUF
  920 FORMAT(
     + 10X,50HAMOUNT OF STORE LEFT FOR BUFFER..................=,I10/)
      IF(NWORK.GE.NCORET)WRITE(IW6,940)
      IF(NWORK.LT.NCORET)WRITE(IW6,950)
C
      MTOTK=NZ-1+MOUTI
      WRITE(IW6,923)MTOTK,LK
  923 FORMAT(/10X,
     + 'AMOUNT OF  K  USED ',I10,4X,'OUT OF ALLOCATED',I10)
C
      CALL SETUP(
CT    CALL SETUP(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
CT   + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
     + INXL,MXEN,MXLD,MXFXT,LV,LL,MCORE,NVTX,ND,MDZ,NEDZ,KSS,
     + G(1),G(L1),G(L2),G(L3),G(L4),G(L5),G(L6),G(L7),
     + G(L8),G(L9),G(L10),G(L11),G(L12),G(L13),G(L14),G(L15),
     + G(LS1),G(LS2),G(LS3),G(LS4),G(LS5),G(LS6),G(LS7),G(LS8),G(LS9),
     + G(LS10),G(LC1),G(LC2),G(LC3),G(LC4),G(LC5),G(LC6),G(LC7),G(LC8),
     + K(N1),K(N2),K(N3),K(N4),K(N5),K(N6),K(N7),K(N8),K(N9),K(N10),
     + K(N11),K(N12),K(N13),K(N14),K(NS1),K(NS2),K(NS3),K(NS4),
     + K(NS5),CIP,V,FXYZ,PR,PDISLD,PRES,NTY,G(LZ),NWORK,K(NZ),KWORK,
     + KLT,LTZ,ICTL)
      RETURN
C-----------ERROR IN READING LINK FILE
  100 CONTINUE
      WRITE(IWS,960)
  960 FORMAT(//1X,'****** Error in reading the LINK file (*.LIK) ******'
     +        /1x,'****** Re-run Geometry program again.         ******'
     +        /)
      STOP
C-----------END OF LINK FILE HAS BEEN REACHED
  150 CONTINUE
      WRITE(IWS,970)
  970 FORMAT(//1X,'**** End of LINK file (*.LIK) has been reached. ****'
     +        /1X,'**** The LINK file (*.LIK) is incomplete.       ****'
     +        /1x,'****     Re-run Geometry program again.         ****'
     +        /)
      STOP
  900 FORMAT(1H1,120(1H*)//
     + 17H CRISP 1993 (MP1)//
     + 36H PROGRAM LAST MODIFIED ON   6/03/93
     + )
  901 FORMAT(80A1)
CC902 FORMAT(12I5)
  903 FORMAT(/1X,80A1)
CC905 FORMAT(//10X,29HERROR ---- LINK CODE MISMATCH,2I10,
CC   + 2X,15H(ROUTINE MAST2))
  906 FORMAT(/1X,14HLINK NUMBER = ,I6)
  912 FORMAT(/10X,42HTO PROVIDE MINIMUM CORE TO SOLVE EQUATIONS/
     + 10X,29HINCREASE SIZE OF ARRAY G BY =,I10,2X,
     + 23HIN MAST (ROUTINE MAST2)//1X,120(1H*))
  913 FORMAT(/10X,
     + 10X,29HINCREASE SIZE OF ARRAY K BY =,I10,2X,
     + 23HIN MAST (ROUTINE MAST2)//1X,120(1H*))
  915 FORMAT(//1X,120(1H*)//
     + 10X,50HTOTAL ALLOCATION OF STORE FOR G..................=,I10/
     + 10X,50HSTORE FOR MAIN ARRAYS............................=,I10/
     + 10X,50HWORKING REGION LEFT FOR SOLVING EQUATIONS........=,I10/
     + 10X,50HMINIMUM CORE REQUIRED TO SOLVE EQUATIONS.........=,I10/
     + 10X,50HADDITIONAL CORE REQUIRED FOR IN-CORE SOLUTION....=,I10)
  940 FORMAT(/10X,28HEQUATIONS ARE SOLVED IN-CORE//1X,120(1H*))
  950 FORMAT(/10X,32HEQUATIONS ARE SOLVED OUT-OF-CORE//1X,120(1H*))
      END
      SUBROUTINE MAXVAL(IW6,KLT,LTZ,NDIM,NVRN,NDMX,NPMX,NIP,
     +                  NS,NB,NL,NPT,NSP,NPR,NMT,MDFE,KES,KSS,NVPN,LV,
     +                  MXEN,MXLD,MXFXT,MXDF,ICTL)
C***********************************************************************
C     SETS MAXIMUM VALUES AND SIZES OF SOME ARRAYS
C     ROUTINE LAST MODIFIED ON 19/1/87   
cra   nmt increased TO 100
C***********************************************************************
      DIMENSION KLT(LTZ)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /POINT / IPT(6),KPT(6)
C-----------------------------------------------------------------------
C     MXEN,MXLD - SIZE OF ARRAYS IN COMMON BLOCKS PRSLD,PRLDI
C     MXLD - MAXIMUM NUMBER OF ELEMENT EDGES WITH PRESSURE LOADING
C     MXEN - MAXIMUM NUMBER OF DISPLACEMENT NODES ALONG AN EDGE
C     MXFXT- MAXIMUM NUMBER OF FIXITIES (SIZE OF ARRAYS MF,TF,DXYT)
C-----------------------------------------------------------------------
      MXEN=10
      MXLD=400
      MXFXT=2000
C-----------------------------------------------------------------------
C     SIZE OF MATERIAL PROPERTIES (PR) AND TYPE (NTY) ARRAYS
C-----------------------------------------------------------------------
cra      NPR=16
CRA      NMT=25   
      NPR=20
      NMT=100
CRA   @@@@@@@
C-----------------------------------------------------------------------
C     ONE-DIMENSIONAL INTEGRATION - NUMBER OF SAMPLING POINTS
C-----------------------------------------------------------------------
      NSP=5
C-----------------------------------------------------------------------
C     NS - SIZE OF D-MATRIX
C-----------------------------------------------------------------------
      NS=NVRN
      DO 10 I=1,MXDF
      IPT(I)=0
   10 KPT(I)=0
C----------INDEXES TO IPT ARE PROGRAM IDENTIFICATION NUMBERS.
C----------INDEXES TO KPT ARE USER    IDENTIFICATION NUMBERS.
      IF(NDIM.EQ.2)THEN
         IPT(1)=1
         IPT(2)=2
         IPT(4)=3
         IPT(5)=5
C
         KPT(1)=1
         KPT(2)=2
         KPT(3)=4
         KPT(5)=5
C
      ELSE IF(NDIM.EQ.3)THEN
         IPT(1)=1
         IPT(2)=2
         IPT(3)=3
         IPT(4)=4
C
         KPT(1)=1
         KPT(2)=2
         KPT(3)=3
         KPT(4)=4
      ENDIF
C-----------------------------------------------------------------------
C     NVPN - MAXIMUM NUMBER OF D.O.F. IN ANY NODE
C-----------------------------------------------------------------------
      ICT=0
      WRITE(IW6,920)
  920 FORMAT(/1X,'DETAILS OF ELEMENT TYPES IN MESH'/1X,33(1H-)//
     +        1X,'ELEMENT TYPES',4X,'NO. OF ELEMENTS'/)
      DO 15 LT=1,LTZ
      KC=KLT(LT)
      IF(KC.NE.0) WRITE(IW6,930)LT,KC
  930 FORMAT(8X,I5,9X,I5)
      GOTO(15,15,12,15,12,15,12,15,12,15,12,15,15,15,15),LT
   12 ICT=ICT+KC
   15 CONTINUE
      NVPN=NDIM
      IF(ICT.NE.0)NVPN=NDIM+1
      ICTL=ICT
C-----------------------------------------------------------------------
C     MAXIMUM VALUES OF NDMX,NPMX,LV,NIP,NL,MDFE
C     FOR ANY ELEMENT IN MESH
C-----------------------------------------------------------------------
      NDMX=0
C-----------------------------------------------------------------------
C     IN THE ABSENCE OF ANY CONSOLIDATION ELEMENTS IN THE MESH
C     NPMX WILL REMAIN 0. IN ORDER TO PREVENT ARRAYS BEING SET UP
C     WITH ZERO DIMENSIONS (IN ROUTINE MAIN2) NPMX IS SET TO 1
C-----------------------------------------------------------------------
      NPMX=1
      LV=0
      NIP=0
      NL=0
      MDFE=0
C
      DO 30 LT=1,LTZ
      IF(KLT(LT).EQ.0)GOTO 30
      IF(NDMX.LT.LINFO(5,LT))NDMX=LINFO(5,LT)
      IF(NPMX.LT.LINFO(6,LT))NPMX=LINFO(6,LT)
      IF(LV.LT.LINFO(7,LT))LV=LINFO(7,LT)
      IF(NIP.LT.LINFO(11,LT))NIP=LINFO(11,LT)
      IF(NL.LT.LINFO(15,LT))NL=LINFO(15,LT)
      IF(MDFE.LT.LINFO(16,LT))MDFE=LINFO(16,LT)
   30 CONTINUE
C-----------------------------------------------------------------------
C     NB  - NUMBER OF COLUMNS IN B - MATRIX
C     KES - SIZE OF UPPER TRIANGULAR ELEMENT STIFFNESS MATRIX ES
C     KSS - SIZE OF UPPER TRIANGULAR BT*D*B MATRIX
C     LV  - MAXIMUM NUMBER OF DISPLACEMENT NODES ALONG ELEMENT EDGE
C-----------------------------------------------------------------------
      NB=NDIM*NDMX
      KES=MDFE*(MDFE+1)/2
      KSS=NB*(NB+1)/2
      LV=LV+2
      NPT=LV
CC    WRITE(IW6,900)NDIM,NVPN,NPMX,LV,NIP,NL,MDFE
CC900 FORMAT(/1X,4HNDIM,I6,2X,4HNVPN,I6,2X,4HNPMX,I6,2X,2HLV,I6,
CC   + 2X,3HNIP,I6,2X,2HNL,I6,2X,4HMDFE,I6)
CC    WRITE(IW6,910)NDMX,NB,KES,NPT
CC910 FORMAT(/1X,4HNDMX,I6,2X,2HNB,I6,2X,3HKES,I6,2X,3HNPT,I6)
      RETURN
      END
      SUBROUTINE MLAPZ(MXND,NEL,NN,NCORR,LTYP,NQ)
C***********************************************************************
C     MARKS LAST APPEARANCES OF NODES BY MAKING THEM NEGATIVE
C     IN NCORR ARRAY
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),LTYP(NEL),NQ(NN)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
C
      NEL1=NEL+1
C
      DO 30 M=1,NN
      IF(NQ(M).EQ.0) GOTO 30
      DO 20 J=1,NEL
      JB=NEL1-J
      IF(LTYP(JB).LT.0) GOTO 20
      LT=LTYP(JB)
      NDPT=LINFO(1,LT)
      DO 10 I=1,NDPT
      IF(NCORR(I,JB).NE.M) GOTO 10
      NCORR(I,JB)=-NCORR(I,JB)
      GOTO 30
   10 CONTINUE
   20 CONTINUE
   30 CONTINUE
C
      RETURN
      END
      SUBROUTINE MSG(
CX    SUBROUTINE MSG(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
CX   + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
     + INXL,MXEN,MXLD,MXFXT,LV,NVTX,ND,KSS,
     + XYZ,DI,DA,VARINT,P,PT,PIB,REAC,PCOR,PEQT,XYFT,XYFIB,
     + STR,PEXIB,PEXI,PCONI,D,ELCOD,DS,SHFN,CARTD,B,DB,FT,SS,ES,
     + E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     + JEL,IDFX,NDEST,NP1,NP2,IFR,NDL,NWL,NMOD,KDF,
     + CIP,LL,V,FXYZ,PR,PDISLD,PRES,NTY,A,MFZ,NOIB,
     + TTIME,TGRAV,IUPD,ICOR,IBC,IDCHK,INCT,NINCP,INCLST,MXP,
     + KK,LKK,KLT,LTZ,ICTL)
C***********************************************************************
C     MAIN CONTROLLING ROUTINE
C     ROUTINE LAST UPDATED ON 1/9/92
C     (1/6/88,12/11/85)
C***********************************************************************
CF    CHARACTER*1 JDO
      REAL L,LL
      INTEGER TF
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),VARINT(NVRS,NIP,NEL),
     + P(NDF),PT(NDF),PIB(NDF),REAC(NDF),PCOR(NDF),PEQT(NDF),XYFT(NDF),
     + XYFIB(NDF),STR(NVRN,NIP,NEL),PEXIB(NDF),PEXI(NDF),PCONI(NDF)
      DIMENSION D(NS,NS),ELCOD(NDIM,NDMX),DS(NDIM,NDMX),SHFN(NDMX),
     + CARTD(NDIM,NDMX),B(NS,NB),DB(NS,NB),FT(NDIM,NDMX),
     + SS(KSS),ES(KES),KLT(LTZ)
      DIMENSION E(NDIM,NPMX),PE(NDIM,NPMX),
     + RN(NB),AA(NPMX),ETE(NPMX,NPMX),RLT(NB,NPMX),CARTP(NDIM,NPMX),
     + PORINS(NN)
      DIMENSION NCORR(NTPE,NEL),MAT(NEL),LTYP(NEL),MRELVV(NEL),
     + MREL(MUMAX),NRELVV(NN),NREL(NNZ),KGVN(MXDF,NN),NQ(NN),JEL(NEL),
     + IDFX(NDF),NDEST(NN),NP1(NPL),NP2(NPL),KDF(MXDF,NN)
      DIMENSION IFR(IFRZ),NDL(MDFE),NWL(NPMX),NMOD(NIP,NEL)
      DIMENSION CIP(NDIM),LL(NL),V(LV),FXYZ(NDIM),PR(NPR,NMT),
     + PDISLD(NDIM,NPT),PRES(NDIM,NPT),NTY(NMT),A(MFZ),KK(LKK)
      DIMENSION RINCC(1000),DTM(1000),IOPT(1000),INCLST(MXP)
      COMMON /FLOW  / NPLAX
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /PRLDI / PRSLDI(10,400),LEDI(400),NDI1(400),NDI2(400),ILOD
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      COMMON /LOADS / FB(2,15)
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /NUNIT2/ NFREQ,IWRU2
      COMMON /MP92/NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
     + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN
C
C *** MAXIMUM NUMBER OF INCREMENTS IN AN INCREMENT BLOCK
      INCZ=1000
      NDIM1=NDIM+1
      IF(IDCHK.EQ.0)GOTO 10
      WRITE(IW6,907)
      STOP
C-----------------------------------------------------------------------
C     START  OF  INCREMENT  CYCLE
C-----------------------------------------------------------------------
   10 DO 250 J=1,NOIB
C
      WRITE(IW6,908) J
C-----------------------------------------------------------------------
C     INITIALISE  LOAD  VECTOR
C-----------------------------------------------------------------------
      CALL ZEROR1(XYFIB,NDF)
      CALL ZEROR1(PIB,NDF)
      CALL ZEROR1(PEXIB,NDF)
      CALL ZEROR2(PRSLDI,MXEN,MXLD)
      ILOD=0
      CALL ZEROI1(JEL,NEL)
      CALL ZEROI1(IOPT,INCZ)
      CALL ZEROR1(DTM,INCZ)
      CALL ZEROR1(RINCC,INCZ)
      FRACT=ZERO
C-----------------------------------------------------------------------
C     READ  INCREMENT  CONTROL  OPTIONS
C-----------------------------------------------------------------------
      CALL FFIN(13,3071)
      IBNO=IFIX(AR(1))
      INC1=IFIX(AR(2))
      INC2=IFIX(AR(3))
      ICHEL=IFIX(AR(4))
      NLOD=IFIX(AR(5))
      ILDF=IFIX(AR(6))
      NFX=IFIX(AR(7))
      NFXB=IFIX(AR(8))
      IOUTS=IFIX(AR(9))
      IOCD=IFIX(AR(10))
      DTIME=AR(11)
      ITMF=IFIX(AR(12))
      DGRAV=AR(13)
      WRITE(IW6,912)IBNO,INC1,INC2,ICHEL,NLOD,ILDF,NFX,NFXB,IOUTS,
     + IOCD,DTIME,ITMF,DGRAV
C--------CHECK THAT TIME STEP IS NOT SPECIFIED AS ZERO IN A
C        CONSOLIDATION ANALYSIS.
      IF(ICTL.NE.0) THEN
         IF(ABS(DTIME).LT.ASMVL) THEN
            WRITE(IW6,970)DTIME
            WRITE(IW15,970)DTIME
            WRITE(IWS,970)DTIME
  970       FORMAT(/1X,'*** ERROR - TIME STEP SPECIFIED AS ZERO',
     +      1X,'IN A CONSOLIDATION ANALYSIS.  DTIME =',E16.5/
     +      1X,'(ROUTINE MSG)')
         STOP
        ENDIF
      ENDIF
C
      NOINC=INC2+1-INC1
      IF(NOINC.LE.INCZ)GOTO 70
      WRITE(IWS,950)NOINC,INCZ
      WRITE(IW15,950)NOINC,INCZ
      WRITE(IW6,950)NOINC,INCZ
      STOP
   70 IF(IBNO.EQ.J) GO TO 72
      WRITE(IW6,913) IBNO,J
      STOP
   72 IF(ICHEL.EQ.0) GO TO 76
C-----------------------------------------------------------------------
C     ALTER  GEOMETRY  AS  SPECIFIED
C-----------------------------------------------------------------------
      WRITE(IW6,914)
      CALL RDINT(JEL,ICHEL)
      WRITE(IW6,920) (JEL(JJ),JJ=1,ICHEL)
      CALL CHANGE(IW6,1,ICHEL,NN,MXDF,NTPE,NIP,NEL,MUMAX,NDF,
     + NDIM,NVRS,NDMX,NL,NB,NS,NPR,NMT,NPT,NPL,NNZ,XYZ,PIB,PEXIB,
     + VARINT,MREL,NREL,B,ELCOD,DS,SHFN,FT,CARTD,LL,PR,PRES,
     + NCORR,KGVN,NQ,JEL,LTYP,MAT,NP1,NP2,NSP,TGRAV)
C-----------------------------------------------------------------------
C     CALCULATE  BODY  FORCE  LOAD  VECTOR
C     FOR SELF-WEIGHT LOADING AND GRAVITY LOADING
C-----------------------------------------------------------------------
   76 CALL SEL1(IW6,ICHEL,NN,MXDF,NTPE,NIP,NEL,NDF,MUMAX,NL,NDIM,
     + NDMX,NPR,NMT,XYZ,PIB,ELCOD,SHFN,DS,FT,LL,NCORR,JEL,
     + LTYP,MAT,MREL,MRELVV,KGVN,NTY,PR,DGRAV)
C-----------------------------------------------------------------------
C     READ LOAD FACTORS, TIME FACTORS AND OUTPUT OPTIONS
C-----------------------------------------------------------------------
      CALL FACTOR(IW6,NOINC,ILDF,IOCD,ITMF,IOUTS,RINCC,DTM,IOPT,DTIME)
      IF(NLOD.EQ.0)GO TO 95
      IF(NLOD.GT.0)GO TO 82
C-----------------------------------------------------------------------
C     PRESSURE LOADING ALONG ELEMENT EDGE
C-----------------------------------------------------------------------
      WRITE(IW6,1000)
      NLDS=IABS(NLOD)
      IF(NDIM.EQ.2)GOTO 78
      WRITE(IW6,955)
      WRITE(IW15,955)
      WRITE(IWS,955)
  955 FORMAT(/1X,34HNO OPTION TO CALCULATE NODAL LOADS,1X,
     + 50HFROM PRESSURE LOADING IN 3-D PROBLEM (ROUTINE MSG))
      STOP
C
   78 NTM=NDIM*NPT+3
      DO 80 KLOD=1,NLDS
      CALL FFIN(NTM,7)
      LNE=IFIX(AR(1))
      ND1=IFIX(AR(2))
      ND2=IFIX(AR(3))
      INX=3
C
      DO 79 IV=1,NPT
      PDISLD(2,IV)=AR(INX+1)
      PDISLD(1,IV)=AR(INX+2)
   79 INX=INX+2
      WRITE(IW6,1002)LNE,ND1,ND2,((PDISLD(ID,IV),ID=1,NDIM),IV=1,NPT)
C
      CALL EDGLD(IW6,NEL,NDIM,NTPE,NNZ,MUMAX,NPL,NCORR,LTYP,MREL,NREL,
     + LNE,ND1,ND2,NP1,NP2,PDISLD,PRES,KLOD,NPT,0,MXLD)
      CALL DISTLD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,
     + NPL,PIB,XYZ,NP1,NP2,
     + KGVN,NCORR,LTYP,MREL,NREL,LNE,ND1,ND2,PRES,NPT,NSP,1,1,1.)
   80 CONTINUE
      GO TO 95
C-----------------------------------------------------------------------
C     READ INCREMENTAL POINT LOADS
C-----------------------------------------------------------------------
   82 WRITE(IW6,916)
      NTM=NDIM+1
      DO 90 JJ=1,NLOD
      CALL FFIN(NTM,1)
      KKT=IFIX(AR(1))
C
      DO 85 ID=1,NDIM
   85 FXYZ(ID)=AR(ID+1)
      WRITE(IW6,940)KKT,(FXYZ(ID),ID=1,NDIM)
C  NO PROVISION FOR PORE PRESSURE TERMS IN 'APPLIED' NODAL LOADS
      FTT=ZERO
      KJ=NREL(KKT)  
      IF(KJ.LT.1.OR.KJ.GT.NN) THEN
         WRITE(IW6,765)KKT
         WRITE(IWS,765)KKT
  765    FORMAT(/1X,'**** ERROR : ATTEMPT TO APPLY POINT LOADS'/
     +           1X,'             TO NON-EXISTANT NODE',I8)     
         GOTO 90
      ENDIF      
      N1=KGVN(1,KJ)-1
      IDF=NQ(KJ)
      IF(IDF.EQ.1)GO TO 84
      DO 83 ID=1,NDIM
   83 XYFIB(N1+ID)=FXYZ(ID)
      IF(IDF.EQ.NDIM1)XYFIB(N1+NDIM1)=FTT
      GO TO 90
   84 XYFIB(N1+1)=FTT
   90 CONTINUE
C
   95 IF(NFX.EQ.0) GO TO 137
C-----------------------------------------------------------------------
C     READ  CHANGE  TO  NODAL  FIXITIES
C-----------------------------------------------------------------------
      WRITE(IW6,931)
      IF(NDIM.EQ.2)CALL FIXX2(IW6,NEL,NTPE,NDIM,NPL,LV,
     + NCORR,LTYP,MUMAX,NNZ,NP1,NP2,MREL,NREL,V,NFX,MXFXT)
      IF(NDIM.EQ.3)CALL FIXX3(IW6,NEL,NTPE,NDIM,NPL,LV,
     + NCORR,LTYP,MUMAX,NNZ,NP1,NP2,MREL,NREL,V,NFX,MXFXT)
  137 CONTINUE
      IF(NFXB.EQ.0)GOTO 139
      WRITE(IW6,960)
      CALL FIXX2B(IW6,NNZ,NREL,NFXB,MXFXT)
  139 CONTINUE
C-----------------------------------------------------------------------
C     START OF INCREMENT LOOP
C-----------------------------------------------------------------------
      DO 200 JS=INC1,INC2
      INCT=INCT+1
      IF(JS.EQ.INCT)GO TO 138
      WRITE(IW6,933)JS,INCT
      WRITE(IW15,933)JS,INCT
      WRITE(IWS,933)JS,INCT
      STOP
  138 JC=JS+1-INC1
      FRACLD=RINCC(JC)
      FRACT=FRACT+FRACLD
      DTIMEI=DTM(JC)
      TTIME=TTIME+DTIMEI
      DGRAVI=FRACLD*DGRAV
      TGRAV=TGRAV+DGRAVI
      IOUT=IOPT(JC)
C-----------------------------------------------------------------------
C     SET SWITCH TO WRITE RESULTS FROM CURRENT INCREMENT
C     TO DISK FILE ON UNIT IW7
C-----------------------------------------------------------------------
      DO 140 IL=1,MXP
      IF(INCLST(IL).EQ.JS)GOTO 142
  140 CONTINUE
      IWRDK=0
      GOTO 145
  142 IWRDK=1
  145 CONTINUE
C
C----------FLAG TO INDICATE THE LAST INCREMENT IN CURRENT RUN
      IWL=0
      IWRU2=0
      IF(J.EQ.NOIB.AND.JS.EQ.INC2)IWL=1
C
C----------SET FLAG TO INDICATE WHICH INCREMENTS SHOULD BE WRITTEN
C          TO NRS FILE - IWRU2   (OPTION ISR = 2)
C
      IF(JS.EQ.1) IWRU2 = 1
      IF(JS.EQ.INC2) IWRU2 = 1
      IF(MOD(JS,NFREQ).EQ.0) IWRU2 = 1
      IF(IWL.EQ.1) IWRU2 = 1
C
      CALL LODINC(
CX    CALL LODINC(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,
CX   + NVRN,NDIM,MUMAX,NDZ,IFRZ,NNZ,NDMX,NPMX,
CX   + NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
     + INXL,MXEN,MXLD,LV,NVTX,ND,KSS,
     + XYZ,DI,DA,VARINT,P,PT,PIB,REAC,PCOR,PEQT,XYFT,XYFIB,
     + STR,PEXIB,PEXI,PCONI,D,ELCOD,DS,SHFN,CARTD,B,DB,FT,SS,ES,
     + E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     + JEL,IDFX,NDEST,NP1,NP2,IFR,NDL,NWL,NMOD,KDF,
     + CIP,LL,V,FXYZ,PR,PDISLD,PRES,NTY,A,MFZ,
     + DTIMEI,TTIME,DGRAVI,TGRAV,IOUT,JS,J,FRACLD,
     + FRACT,ICOR,IUPD,IBC,NLOD,NLDS,IWRDK,KK,LKK,
     + KLT,LTZ)
C
  200 CONTINUE
C-----------------------------------------------------------------------
C     ZERO ALL NON-ZERO PRESCRIBED VALUES
C-----------------------------------------------------------------------
      IF(NF.NE.0)CALL ZEROR2(DXYT,6,NF)
C
  250 CONTINUE
  907 FORMAT(/1X,24HANALYSIS NOT CARRIED OUT/)
  908 FORMAT(/120(1H=)//
     + 1X,43HSTART  OF  LOAD  INCREMENT  BLOCK  NUMBER  ,I5/1X,48(1H-))
CC909 FORMAT(1X,14HSPECIFIED LOAD,I5,3E15.5)
CC910 FORMAT(9I5,F10.0,I5,F10.0)
  912 FORMAT(/
     +1X,30HINCREMENT BLOCK NUMBER.......=,I8,
     +6X,30HSTARTING INCREMENT NUMBER....=,I8/
     +1X,30HFINISHING INCREMENT NUMBER...=,I8,
     +6X,30HNO. OF ELEMENT CHANGES.......=,I8/
     +1X,30HNUMBER OF LOADS..............=,I8,
     +6X,30HINCREMENT RATIO OPTION.......=,I8/
     +1X,30HNUMBER OF SIDE FIXITIES......=,I8,
     +6X,30HNUMBER OF NODAL FIXITIES.....=,I8/
     +1X,30HSTD OUTPUT CODE..............=,I8,
     +6X,30HOUTPUT OPTION................=,I8/
     +1X,30HTIME INCREMENT...............=,F10.1,
     +4X,30HTIME INCREMENT OPTION........=,I8/
     +1X,30HINCR IN GRAVITY LEVEL........=,F10.1/)
  913 FORMAT(//1X,39HERROR *** MISMATCH IN INCR BLOCK NUMBER,2I6,
     + 2X,13H(ROUTINE MSG))
  914 FORMAT(//28H LIST OF ELEMENT ALTERATIONS/1X,27(1H-)/)
  916 FORMAT(//32H LIST OF INCREMENTAL NODAL LOADS/1X,31(1H-)//
     + 3X,4HNODE,8X,1HX,9X,1HY,9X,1HZ/)
  920 FORMAT(1X,10I8)
  931 FORMAT(/1X,30HPRESCRIBED BOUNDARY CONDITIONS/1X,30(1H-)/)
  933 FORMAT(//1X,' *** ERROR IN INCREMENT NUMBER IN INPUT DATA=',I5,
     + 5X,'INCREMENT NO. EXPECTED =',I5,5X,'(ROUTINE MSG)')
  940 FORMAT(1X,I5,3F10.3)
  950 FORMAT(/1X,46HINCREASE SIZE OF ARRAYS RINCC, DTM AND IOPT TO,
     + I5,2X,32HALSO RE-SET INCZ IN ROUTINE MSG./
     + 1X,'CURRENT SIZE OF INCZ',I5,2X,'INSUFFICIENT.'/)
  960 FORMAT(/1X,'LIST OF NODAL FIXITIES'/1X,22(1H-))
 1000 FORMAT(/1X,38HSPECIFIED NODAL VALUES OF SHEAR/NORMAL,
     + 36H STRESSES AND EQUIVALENT NODAL LOADS/1X,74(1H-)/1X,4HELEM,
     + 1X,4HNDE1,2X,4HNDE2,2X,4HNOR1,8X,4HSHR1,8X,4HNOR2,8X,4HSHR2,
     + 8X,4HNOR3,8X,4HSHR3,8X,4HNOR4,8X,4HSHR4,8X,4HNOR5,8X,4HSHR5/
     + 1X,16H(LOAD DIRECTION),2X,3H(X),9X,3H(Y),9X,3H(X),9X,3H(Y),
     + 9X,3H(X),9X,3H(Y),9X,3H(X),9X,3H(Y),9X,3H(X),9X,3H(Y)/)
 1002 FORMAT(1X,3I4,10E12.4)
      RETURN
      END
C-----------------------------------------------------------------------
      FUNCTION Q(A,N,NDIM)
      DIMENSION A(N)
      Q2=0.5*((A(1)-A(2))*(A(1)-A(2))+(A(2)-A(3))*(A(2)-A(3))+
     +   (A(3)-A(1))*(A(3)-A(1)))+3.*A(4)*A(4)
      IF(NDIM.EQ.2)GOTO 10
      Q2=Q2+3.*A(5)*A(5)+3.*A(6)*A(6)
   10 Q=SQRT(Q2)
      RETURN
      END
C-----------------------------------------------------------------------
      FUNCTION EDS(A,N,NDIM)
      DIMENSION A(N)
      EDS2=0.5*((A(1)-A(2))*(A(1)-A(2))+(A(2)-A(3))*(A(2)-A(3))+
     +   (A(3)-A(1))*(A(3)-A(1)))+0.75*A(4)*A(4)
      IF(NDIM.EQ.2)GOTO 10
      EDS2=EDS2+0.75*A(5)*A(5)+0.75*A(6)*A(6)
   10 EDS=2.*SQRT(EDS2)/3.
      RETURN
      END
      FUNCTION AMULT(X,NDIM,KR1,KR2,KC1,KC2)
C-----------------------------------------------------------------------
C     CALCULATES DETERMINANT OF A TWO BY TWO MATRIX
C-----------------------------------------------------------------------
      DIMENSION X(NDIM,NDIM)
C
      AMULT=X(KR1,KC1)*X(KR2,KC2)-X(KR1,KC2)*X(KR2,KC1)
      RETURN
      END
C-----------------------------------------------------------------------
      FUNCTION STRMAX(A,N,NDIM)
      DIMENSION A(N)
      DIFF=ABS(A(2)-A(1))
      STRMAX=SQRT(DIFF**2+A(4)**2)
      RETURN
      END
      SUBROUTINE MSUB1(NPR,NMT,NPLAX,NMAT,NOIB,INCS,INCF,INCT,
     +                 IPRIM,IUPD,ICOR,IBC,PR,NTY,NDIM,NINCP,INCLST,MXP)
C***********************************************************************
C     READ CONTROL OPTIONS AND MATERIAL PROPERTIES
C     ROUTINE LAST MODIFIED ON 19/1/87
C***********************************************************************
CF    CHARACTER*1 JDO
      DIMENSION PR(NPR,NMT),NTY(NMT),INCLST(MXP)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /NUNIT2/ NFREQ,IWRU2
      DATA CONV/57.295779513/
C-----------------------------------------------------------------------
C     ICOR - OPTION TO APPLY OUT-OF-BALANCE LOADS AS CORRECTING
C            LOADS IN THE NEXT INCREMENT
C     ICOR = 0 - CORRECTING LOADS ARE NOT APPLIED
C     ICOR = 1 - CORRECTING LOADS ARE APPLIED
C-----------------------------------------------------------------------
      CALL FFIN(9,511)
      NPLAX=IFIX(AR(1))
      NMAT=IFIX(AR(2))
      NOIB=IFIX(AR(3))
      INCS=IFIX(AR(4))
      INCF=IFIX(AR(5))
      IPRIM=IFIX(AR(6))
      IUPD=IFIX(AR(7))
      ICOR=IFIX(AR(8))
      ISR=IFIX(AR(9))
      WRITE(IW6,922)NPLAX,NMAT,NOIB,INCS,INCF,IPRIM,IUPD,ICOR,ISR
      NOINC=INCF-INCS+1
      IF(NOINC.GT.0)GOTO 5
      WRITE(IW6,925)NOINC,INCS,INCF
      WRITE(IW15,925)NOINC,INCS,INCF
      WRITE(IWS,925)NOINC,INCS,INCF
      STOP
C
    5 CONTINUE
      IF(ISR.EQ.0) THEN
         IF(INCS.NE.1) THEN
            WRITE(IW6,955)INCS,ISR
            WRITE(IW15,955)INCS,ISR
            WRITE(IWS,955)INCS,ISR
  955       FORMAT(/1X,'**** ERROR - STARTING INCREMENT NO. (INCS) =',
     +             I5,5X,'WHEN STOP/RESTART OPTION IS NOT USED (ISR) =',
     +              I5/1X,'(ROUTINE MSUB1)')
            STOP
         ENDIF
      ENDIF
C
C---------GET NFREQ - INCREMENT FREQUENCY FOR WRITING TO NRS FILE
      CALL GETFREQ(IW6,INCF)
C
      CALL FFIN(9,511)
      INSOP=IFIX(AR(1))
      IBC=IFIX(AR(2))
      IRAC=IFIX(AR(3))
      NVOS=IFIX(AR(4))
      NVOF=IFIX(AR(5))
      NMOS=IFIX(AR(6))
      NMOF=IFIX(AR(7))
      NELOS=IFIX(AR(8))
      NELOF=IFIX(AR(9))
      WRITE(IW6,924)INSOP,IBC,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF
C------------------------------------------------------------------------
C     MXP - MAXIMUM NO. OF INCREMENTS THAT CAN BE WRITTEN TO DISK FILE
C-----------------------------------------------------------------------
      CALL ZEROI1(INCLST,MXP)
      CALL FFIN(1,1)
      NINCP=IFIX(AR(1))
      WRITE(IW6,927)NINCP
      IF(NINCP.EQ.0)GOTO 7
      CALL RDINT(INCLST,NINCP)
      WRITE(IW6,938)(INCLST(IK),IK=1,NINCP)
C *** INCT - COUNTER OF INCREMENT NUMBER
    7 INCT=INCS-1
      IF(NDIM.NE.3)GOTO 8
      WRITE(IW6,928)
      GOTO 10
    8 IF(NPLAX.EQ.0)WRITE(IW6,930)
      IF(NPLAX.EQ.1)WRITE(IW6,931)
C
C *** READ MATERIAL PROPERTIES
   10 CALL ZEROR2(PR,NPR,NMT)
C
      NPRT=12
      WRITE(IW6,932)
      WRITE(IW6,985)
      WRITE(IW6,990)
      WRITE(IW6,933)
      DO 200 I=1,NMAT
      NTM=NPRT+2
      CALL FFIN(NTM,3)
      II=IFIX(AR(1))
C
      IF(II.NE.I) THEN
         WRITE(IW6,980)II
         WRITE(IW15,980)II
         WRITE(IWS,980)II
  980    FORMAT(/1X,'*** ERROR - MAT ZONE NUMBER IN INPUT DATA IS',I5/
     +           1X,'WHEREAS ZONE NO. EXPECTED IS -',I5,4X,
     +              '(ROUTINE MSUB1)')
         STOP
      ENDIF
C
      NTY(II)=IFIX(AR(2))
C
      DO 15 JJ=1,NPRT
   15 PR(JJ,II)=AR(JJ+2)
C----------READ IN 4 EXTRA MATERIAL PROPERTIES FOR ANS MODEL (NO. 6)
CRA      NPC=NPRT
CRA      IF(NTY(II).EQ.6) THEN
CRA         CALL FFIN(4,0)
CRA         DO 18 JJ=1,4
CRA   18    PR(NPRT+JJ,II)=AR(JJ)
CRA         NPC=NPRT+4
CRA      ENDIF
CRA      WRITE(IW6,936)II,NTY(II),(PR(JJ,II),JJ=1,NPC)   
CRA   REPLACED BY :
      NPC=NPRT+8
      CALL FFIN(8,0)
      DO 18 JJ=1,8
   18 PR(NPRT+JJ,II)=AR(JJ)
      WRITE(IW6,936)II,NTY(II),(PR(JJ,II),JJ=1,NPC)
CRA   END OF REPLACEMENT

C--------FOR MODEL NUMBER 1 SET 6TH PROPERTY TO 1 TO IDENTIFY
C        ANISOTROPIC PROPERTIES (FOR ISOTROPIC IT IS 0).
      IF(NTY(II).EQ.1) THEN
         PR(6,II)=1.
         DIFE=ABS(PR(1,II)-PR(2,II))
         DIFV=ABS(PR(3,II)-PR(4,II))
         IF(DIFE.LT.ASMVL.AND.DIFV.LT.ASMVL) THEN
            PR(6,II)=ZERO
         ENDIF
      ENDIF
C-----------------------------------------------------------------------
C     CONVERT ANGLE OF FRICTION TO RADIANS FOR ELASTO PLASTIC MODELS
C-----------------------------------------------------------------------
      IF(NTY(II).EQ.5) THEN
         PR(4,II)=PR(4,II)/CONV
      ENDIF
      IF(NTY(II).NE.6)GOTO 100
C***********************************************************************
C     FOR SCHOFIELD SOIL MODEL - 6                                     *
C     H IS SLOPE OF HVORSLEV SURFACE ALONG CONSTANT VOLUME LINE        *
C     CALCULATE P (PA) AT INTERSECTION OF TENSILE                      *
C     AND HVORSLEV REGION AS A FACTOR OF CRITICAL                      *
C     STATE STRESS P (PU), I.E. AN=PA/PU, FROM THE                     *
C     SLOPE OF TENSILE REGION S.                                       *
C***********************************************************************
      PI=4.*ATAN(1.)
      S=PR(12,II)
      AMU=PR(4,II)
      H=PR(11,II)
      IF(H.GT.AMU) THEN
         WRITE(IW6,950)H,AMU,II
         WRITE(IW15,950)H,AMU,II
         WRITE(IWS,950)H,AMU,II
  950    FORMAT(/1X,' **** ERROR - THE SLOPE YOU HAVE SPECIFIED FOR',
     +   1X,'THE HVORSLEV SURFACE ALONG CONSTANT VOLUME LINE (H)',F10.3/
     +   1X,'IS GREATER THAN THE SLOPE OF THE CRITICAL STATE LINE',F10.3
     +   ,5X,'FOR MAT ZONE NUMBER',I5/1X,'(ROUTINE MSUB1)')
         STOP
      ENDIF
      RAT=PR(1,II)/PR(2,II)
      ITR=0
      ANU=(AMU-H)/(S-H)
   42 AN=ANU
      FNPA=(AMU-H)*AN**RAT+(H-S)*AN
      FNPA2=(AMU-H)*RAT*AN**(RAT-1.)+(H-S)
      ANU=AN-FNPA/FNPA2
      FAC=(ANU-AN)/AN
      ITR=ITR+1
CC    WRITE(6,700)AN,FNPA,FNPA2,ANU,FAC,ITR
CC700 FORMAT(5E16.4,I5)
      IF(ABS(FAC).LT.1.E-3)GO TO 45
      IF(ITR.GT.100) THEN
         WRITE(IW6,960)ITR,I
         WRITE(IW15,960)ITR,I
         WRITE(IWS,960)ITR,I
  960    FORMAT(/1X,'*** ERROR - AFTER',I5,4X,'ITERATIONS CANNOT FIND',
     +   1X,'INTERSECTION POINT BETWEEN TENSILE CRACK REGION AND'/1X,
     +   'HVORSLEV REGION. CHECK YOUR PARAMETERS FOR MODEL NO. 6'/
     +   1X,'- MAT ZONE NUMBER',I5,5X,'(ROUTINE MSUB1)')
         STOP
      ENDIF
      GO TO 42
C
   45 WRITE(IW6,111)ANU,ITR
      PR(14,II)=ANU
  111 FORMAT(/1X,'RATIO PA/PU =',F10.3,3X,'AFTER ITERATIONS =',I5/
     +  1X,'PA - VALUE OF PE AT DEMARCATION POINT OF TENSILE CRACK',
     + 1X,'REGION AND HVORSLEV REGION'/1X,'PU - CRITICAL STATE',
     + 1X,'VALUE OF PE'/)
C
  100 CONTINUE
  200 CONTINUE
      RETURN
  922 FORMAT(/
     + 10X,46HPROBLEM TYPE.................................=,I5/
     + 10X,46HNUMBER OF MATERIALS..........................=,I5/
     + 10X,46HNUMBER OF INCREMENT BLOCKS...................=,I5/
     + 10X,46HSTARTING INCR NUMBER OF ANALYSIS.............=,I5/
     + 10X,46HFINISHING INCR NUMBER OF ANALYSIS............=,I5/
     + 10X,46HNUMBER OF PRIMARY ELEMENT CHANGES............=,I5/
     + 10X,46HOPTION TO UPDATE COORDINATES.................=,I5/
     + 10X,46HOPTION TO APPLY CORRECTING LOADS.............=,I5/
     + 10X,46HOPTION TO STOP/RESTART ANALYSIS..............=,I5/
     + )
  924 FORMAT(/120(1H*)//
     + 10X,46HOPTION TO PRINT IN SITU STRESSES.............=,I5/
     + 10X,46HOPTION TO PRINT BOUNDARY CONDITIONS..........=,I5/
     + 10X,46HOPTION TO PRINT REACTIONS....................=,I5/
     + 10X,46HSTARTING VERTEX NODE NUMBER FOR OUTPUT.......=,I5/
     + 10X,46HFINISHING VERTEX NODE NUMBER FOR OUTPUT......=,I5/
     + 10X,46HSTARTING MIDSIDE NODE NUMBER FOR OUTPUT......=,I5/
     + 10X,46HFINISHING MIDSIDE NODE NUMBER FOR OUTPUT.....=,I5/
     + 10X,46HSTARTING ELEMENT NUMBER FOR OUTPUT...........=,I5/
     + 10X,46HFINISHING ELEMENT NUMBER FOR OUTPUT..........=,I5/
     + /120(1H*)/)
  925 FORMAT(/1X,29HERROR IN NO. OF INCREMENTS = ,I5,
     + 4X,7HINCS = ,I5,4X,7HINCF = ,I5)
  927 FORMAT(/1X,'DETAILS OF INCREMENTS FOR POST PROCESSING'/1X,
     + 41(1H-)//
     + 1X,'NUMBER OF INCREMENTS WRITTEN TO DISK.....=',I5/)
  928 FORMAT(//1X,22H3-DIMENSIONAL ANALYSIS)
  930 FORMAT(//1X,21HPLANE STRAIN ANALYSIS)
  931 FORMAT(//1X,22HAXI-SYMMETRIC ANALYSIS)
  932 FORMAT(//24H MATERIAL PROPERTY TABLE
     + /1X,23(1H-))
  933 FORMAT(/4X,8HMAT TYPE,5X,1H1,11X,1H2,11X,1H3,11X,1H4,11X,1H5,
     + 11X,1H6,11X,1H7,11X,1H8,11X,1H9,11X,2H10/)
  985 FORMAT(/
     + 1X,'(AN)ISO  1     E1           E2          V1          V2     ',
     +'    G2           -       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'LIN ELS  2     EO           YO           M           V     ',
     +'     -           -       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'MOD CAM  3    KAPPA       LAMBDA       ECS           M     ',
     +'  G OR V         -       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'CAMCLAY  4    KAPPA       LAMBDA       ECS           M     ',
     +'  G OR V         -       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'EL-PLAS  5     EO            V           C          PHI    ',
     +'    YO           J       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'               (M)           -                             '
     +)
  990 FORMAT(
     + 1X,'SCHO     6    KAPPA       LAMBDA       ECS           M     ',
     +'  G OR V         -       KW OR GW       BULK      PERM-X     ',
     +' PERM-Y'
     +/1X,'               (H)          (S)          -           -     ',
     +' (PERM-XT)    (PERM-YT)'
     +/1X,'BAR      8      E            V           A           -     ',
     +'    -            -           -            -          -       ',
     +'   -'
     +/1X,'BEAM     8      E            V           A           I     ',
     +'    -            -           -            -          -       ',
     +'   -'
     +/1X,'SLIP     8      C           PHI         KN          KS     ',
     +'  KSRES          T           -            -          -       ',
     +'   -'
     +)
  936 FORMAT(1X,2I5,10E12.4/11X,10E12.4)
  938 FORMAT(1X,32HINCREMENTS WRITTEN TO DISK.....=,10I5/)
      END
      SUBROUTINE MSUB2(INCS,INCF,NN,NVTX,ND,NEL,NDF,NTPE,NIP,
     + NVRS,NVRN,MUMAX,NNZ,MXDF,NDIM,MDZ,NEDZ,NL,INXL,NPR,NMT,
     + NCORR,MAT,LTYP,NREL,MREL,NRELVV,MRELVV,KGVN,NMOD,NTY,
     + XYZ,VARINT,DA,STR,XYFT,PCOR,PCONI,REAC,PORINS,PR,
     + TTIME,TGRAV,NINCP,INCLST,MXP)
C***********************************************************************
C     STOP/START FACILITY
C
C     UNIT IW9 - DISK FILE TO WHICH RESULTS OF SELECTED INCREMENTS
C                ARE WRITTEN FOR POST PROCESSING.
C     UNIT IR1 - A DISK FILE OR FILE IN MAGNETIC TAPE CONTAINS
C                PREVIOUS RESULTS (IN CASE OF RE-STARTED ANALYSIS).
C                DISK FILE CONTAINS ONLY THE LAST INCREMENT IN THE
C                PREVIOUS RUN. (OPTION ISR = 1).
C                FILE IN MAGNETIC TAPE CONTAINS THE RESULTS FROM
C                EVERY INCREMENT OF PREVIOUS RUN (OPTION ISR = 2).
C     UNIT IW2 - A DISK FILE OR FILE IN MAGNETIC TAPE TO WHICH
C                RESULTS FROM CURRENT RUN IS WRITTEN TO.
C                ISR = 1. ONLY THE RESULTS FROM THE LAST INCREMENT
C                IN THE CURRENT RUN IS WRITTEN TO DISK FILE.
C                ISR = 2. RESULTS FROM EVERY INCREMENT FROM THE
C                CURRENT RUN IS WRITTEN TO FILE IN MAGNETIC TAPE.
C     IF ISR = 0, THE STOP-RESTART FACILITY IS NOT USED.
C
C     ROUTINE LAST MODIFIED ON 7/8/91
C     (28/1/87)
C***********************************************************************
      INTEGER TF
      DIMENSION NCORR(NTPE,NEL),LTYP(NEL),NREL(NNZ),MREL(MUMAX),
     + NRELVV(NN),MRELVV(NEL),KGVN(MXDF,NN),NMOD(NIP,NEL),INCLST(MXP)
      DIMENSION XYZ(NDIM,NN),VARINT(NVRS,NIP,NEL),DA(NDF),
     + STR(NVRN,NIP,NEL),XYFT(NDF),PCOR(NDF),PCONI(NDF),REAC(NDF),
     + PORINS(NN),PR(NPR,NMT),NTY(NMT),MAT(NEL)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /FLOW  / NPLAX
C
      IF(ISR.EQ.0.AND.NINCP.EQ.0)RETURN
      IF(ISR.EQ.0.AND.NINCP.NE.0)GOTO 21
C
      IF(ISR.EQ.2)GOTO 20
C
      IF(ISR.EQ.1)GOTO 10
      WRITE(IW6,910)ISR
      WRITE(IW15,910)ISR
      WRITE(IWS,910)ISR
  910 FORMAT(/24H ***ERROR - INADMISSIBLE,1X,
     +  21HSTOP/RESTART OPTION =,I5)
      STOP
C
   10 CONTINUE
      IF(INCS.EQ.1)GOTO 21
C---------DISK FILE OPTION (ONLY ONE INCREMENT IS IN FILE WHICH IS READ)
C---------READ INCREMENT NO. OF RESULTS STORED FROM PREVIOUS RUN
C---------AND CHECK IT IS EQUAL TO INCS - 1.
      INCSM1=INCS-1
      INCS1=INCS-1
      READ(IR1)LINC
      IF(LINC.NE.INCSM1) THEN
         WRITE(IW6,920)LINC,INCSM1
         WRITE(IW15,920)LINC,INCSM1
         WRITE(IWS,920)LINC,INCSM1
  920    FORMAT(/1X,'****** ERROR IN STOP/RE-START FACILITY USING',
     +           1X,'DISK FILE OPTION (ISR = 1)'/
     +           1X,'THE RESULTS (OF LAST INCREMENT) STORED FROM',
     +           1X,'PREVIOUS RUN IS OF INCREMENT ',I5/
     +           1X,'THE RESULTS EXPECTED IS THAT OF INCREMENT ',I5/
     +   1X,'(1) CHECK THAT THE CORRECT FILE WHICH STORES THE',
     +   1X,'LAST INCREMENT FROM PREVIOUS RUN HAS BEEN SPECIFIED'/
     +   1X,'(2) CHECK THE VALUE OF PARAMETER INC1 IN RECORD C1',
     +   1X,'OF MP INPUT DATA'/20X,'(ROUTINE MSUB2)'/)
         STOP
      ENDIF
      READ(IR1)TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,PCONI,LTYP,NMOD,
     +         REAC
      READ(IR1)NF,MF,TF,DXYT
      READ(IR1)NLED,LEDG,NDE1,NDE2,PRESLD
      WRITE(IW6,960)INCS1
  960 FORMAT(/1X,'**** RESULTS FROM INCREMENT',I5,4X,'HAS BEEN READ',
     +        1X,'FROM DISK FILE ****'/)
      GOTO 21
   20 CONTINUE
C
      IF(INCS.NE.1)GO TO 22
C-----------------------------------------------------------------------
C     WRITE GEOMETRY DATA ON UNIT IW2 FOR A NEW ANALYSIS
C-----------------------------------------------------------------------
      REWIND IW2
      WRITE(IW2)NN,NVTX,ND,NEL,NDF,NTPE,NIP,NVRS,NVRN,
     + MUMAX,NNZ,MDZ,NEDZ,NL,INXL,MXDF,NPLAX,NPR,NMT
      WRITE(IW2)NCORR,NREL,MREL,NRELVV,MRELVV,KGVN,MAT,NTY,LTYP
      WRITE(IW2)XYZ
      WRITE(IW2)VARINT,PORINS,PR
C-----------------------------------------------------------------------
C     WRITE GEOMETRY DATA TO DISK FILE
C-----------------------------------------------------------------------
   21 REWIND IW9
      WRITE(IW9)NN,NVTX,ND,NEL,NDF,NTPE,NIP,NVRS,NVRN,MUMAX,NNZ,MDZ,
     + NEDZ,NL,INXL,MXDF,NPLAX,NPR,NMT
      WRITE(IW9)NCORR,NREL,MREL,NRELVV,MRELVV,KGVN,MAT,NTY,LTYP
      WRITE(IW9)XYZ
      WRITE(IW9)NINCP
      IF(NINCP.GT.0)WRITE(IW9)(INCLST(IK),IK=1,NINCP)
      RETURN
C-----------------------------------------------------------------------
C     READ GEOMETRY DATA FROM UNIT IR1 AND WRITE TO UNIT IW2
C     FOR A RE-STARTED ANALYSIS
C-----------------------------------------------------------------------
   22 INCS1=INCS-1
C========WRITE DUMMY IN SITU EQLBM CHECK FOR RE-STRATED ANALYSIS.
C        TO *.MAS FILE (UNIT 14)
      IZRO=0
      IF(NDIM.EQ.2) THEN
         WRITE(IW14,700)IZRO,IZRO,IZRO,IZRO,IZRO,IZRO
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IW14,700)IZRO,IZRO,IZRO,IZRO,IZRO,IZRO,IZRO,IZRO,IZRO
  700    FORMAT(1X,9I6)
      ENDIF
C
      WRITE(IWS,968)
  968 FORMAT(/1X,'===== Reading previous results from ORS file',
     +     1X,'and writing to new NRS file ====='/)
      REWIND IR1
      READ(IR1,END=24,ERR=25)NNT,NVTXT,NDT,NELT,NDFT,NTPET,NIPT,NVRST,
     + NVRNT,MUMAXT,NNZT,MDZT,NEDZT,NLT,INXLT,MXDFT,NPLAXT,NPRT,NMTT
      READ(IR1,END=24,ERR=25)NCORR,NREL,MREL,NRELVV,MRELVV,KGVN,MAT,NTY,
     +                       LTYP
      READ(IR1,END=24,ERR=25)XYZ
      READ(IR1,END=24,ERR=25)VARINT,PORINS,PR
      GOTO 28
C-----------END OF ORS FILE HAS BEEN REACHED
   24 CONTINUE
      WRITE(IWS,962)
  962 FORMAT(//1X,'***     End of  ORS  file  has been reached.     ***'
     +        /1X,'***         The  ORS file is incomplete.         ***'
     +        /1X,'*** Check whether the NRS file from the previous ***'
     +        /1X,'*** run has been re-named as a  ORS  file        ***'
     +        /)
      STOP
C-----------ERROR IN READING  ORS FILE
   25 CONTINUE
      WRITE(IWS,964)
  964 FORMAT(//1X,'****** Error in reading the  ORS file          *****'
     +        /1X,'****** Re-run the MP for previous stage again. *****'
     +        /)
      STOP
C
   28 CONTINUE
      WRITE(IW2)NNT,NVTXT,NDT,NELT,NDFT,NTPET,NIPT,NVRST,NVRNT,
     + MUMAXT,NNZT,MDZT,NEDZT,NLT,INXLT,MXDFT,NPLAXT,NPRT,NMTT
      WRITE(IW2)NCORR,NREL,MREL,NRELVV,MRELVV,KGVN,MAT,NTY,LTYP
      WRITE(IW2)XYZ
      WRITE(IW2)VARINT,PORINS,PR
C-----------------------------------------------------------------------
C     WRITE GEOMETRY DATA TO DISK FILE
C-----------------------------------------------------------------------
      WRITE(IW9)NNT,NVTXT,NDT,NELT,NDFT,NTPET,NIPT,NVRST,NVRNT,
     + MUMAXT,NNZT,MDZT,NEDZT,NLT,INXLT,MXDFT,NPLAXT,NPRT,NMTT
      WRITE(IW9)NCORR,NREL,MREL,NRELVV,MRELVV,KGVN,MAT,NTY,LTYP
      WRITE(IW9)XYZ
      WRITE(IW9)NINCP
      IF(NINCP.GT.0)WRITE(IW9)(INCLST(IK),IK=1,NINCP)
C-----------------------------------------------------------------------
C     READ STORED RESULTS OF PREVIOUS INCREMENTS FROM UNIT IR1
C-----------------------------------------------------------------------
      INCP=0
   29 CONTINUE
      READ(IR1,END=60,ERR=70)INCNO
      READ(IR1,END=62,ERR=72)TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,
     +                       PCONI,LTYP,NMOD,REAC
      READ(IR1,END=62,ERR=72)NF,MF,TF,DXYT
      READ(IR1,END=62,ERR=72)NLED,LEDG,NDE1,NDE2,PRESLD
      INCP=INCNO
C-----------------------------------------------------------------------
C     AND STORE RESULTS ON UNIT IW2 FOR SUBSEQUENT RUN
C-----------------------------------------------------------------------
      WRITE(IW2)INCNO
      WRITE(IW2)TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,PCONI,LTYP,NMOD,
     +         REAC
      WRITE(IW2)NF,MF,TF,DXYT
      WRITE(IW2)NLED,LEDG,NDE1,NDE2,PRESLD
C-----------------------------------------------------------------------
C     WRITE RESULTS FROM SELECTED INCREMENTS TO DISK FILE
C-----------------------------------------------------------------------
      DO 30 IL=1,MXP
      IF(INCLST(IL).EQ.INCNO)GOTO 40
   30 CONTINUE
      GOTO 45
   40 WRITE(IW9)INCNO
      WRITE(IW9)TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,PCONI,LTYP,NMOD,
     +          REAC
      WRITE(IW9)NF,MF,TF,DXYT
      WRITE(IW9)NLED,LEDG,NDE1,NDE2,PRESLD
C
   45 WRITE(IW6,970)INCNO
      WRITE(IW15,970)INCNO
  970 FORMAT(/1X,'**** RESULTS FROM INCREMENT ',I5,4X,'HAS BEEN READ',
     +        1X,'FROM ORS FILE ****')
      WRITE(IWS,973)INCNO
  973 FORMAT(/1X,'**** Results from increment ',I5,4X,'has been read',
     +        1X,'from ORS file ****')
C
      IF(INCNO.EQ.INCS1) THEN
         RETURN
      ELSE IF(INCNO.GT.INCS1) THEN
C
C--------RESULTS FOR INCREMENT INCS1 NOT PRESENT IN NRS FILE.
         WRITE(IWS,961)INCS1
  961    FORMAT(/1X,'Results from increment :',I8,
     +           1X,'Not found in  ORS  file. Program terminated.'
     +          /1X,'(ROUITNE MSUB2)'/)
C
         STOP
      ENDIF
      GOTO 29
C
   60 CONTINUE
C-------END OF NRS FILE HAS BEEN REACHED
      WRITE(IWS,975)INCS1,INCNO
  975 FORMAT(/1X,'End of  ORS  file  has been reached. Results from'
     +       /1X,'increment ',I8,2X,'not found.'
     +       /1X,'The last increment for which results were read from'
     +       /1X,'the  ORS  file was :',I8,'.',2X,'Program terminated.'
     +       /25X,'(ROUTINE MSUB2)'/)
      STOP
C
   62 CONTINUE
C-------END OF NRS FILE HAS BEEN REACHED
      WRITE(IWS,976)INCS1,INCP
  976 FORMAT(/1X,'End of  ORS  file  has been reached. Results from'
     +       /1X,'increment ',I8,2X,'not found.'
     +       /1X,'The last increment for which results were read from'
     +       /1X,'the  ORS  file was :',I8,'.',2X,'Program terminated.'
     +       /25X,'(ROUTINE MSUB2)'/)
      STOP
C
   70 CONTINUE
C-------ERROR IN READING NRS FILE
      WRITE(IWS,980)INCS1,INCNO
  980 FORMAT(/1X,'Error encountered in reading the  ORS  file.'
     +       /1X,'Results for increment ',I8,2X,'not found.'
     +       /1X,'The last increment for which results were read from'
     +       /1X,'the ORS file was :',I8,'.',2X,'Program terminated.'
     +       /25X,'(ROUTINE MSUB2)'/)
      STOP
C
   72 CONTINUE
C-------ERROR IN READING NRS FILE
      WRITE(IWS,981)INCS1,INCP
  981 FORMAT(/1X,'Error encountered in reading the  ORS  file.'
     +       /1X,'Results for increment ',I8,2X,'not found.'
     +       /1X,'The last increment for which results were read from'
     +       /1X,'the ORS file was :',I8,'.',2X,'Program terminated.'
     +       /25X,'(ROUTINE MSUB2)'/)
      STOP
      END
      SUBROUTINE MSUB3(NN,NEL,NDF,MXDF,NTPE,NIP,NDIM,NVRS,
     + MUMAX,NNZ,NDZ,NPL,NDMX,NS,NB,NL,LV,NPR,NMT,NPT,NSP,
     + XYZ,DA,P,PT,PEQT,XYFT,PCOR,VARINT,PEXIB,PCONI,REAC,PORINS,
     + NCORR,NQ,KGVN,JEL,MRELVV,MREL,NREL,LTYP,MAT,NMOD,IDFX,KDF,NTY,
     + PR,CIP,F,LL,B,DS,ELCOD,CARTD,SHFN,PRES,
     + NP1,NP2,V,PDISLD,A,MFZ,INXL,MXEN,MXLD,MXFXT,TGRAVI,IPRIM,
     + KLT,LTZ)
C***********************************************************************
C     SET UP INSITU STRESSES AND CHECK FOR EQUILIBRIUM
C     ROUTINE LAST UPDATED ON 28/09/92
C     (12/11/85)
C***********************************************************************
CF    CHARACTER*1 JDO
      REAL LL
      INTEGER TF
      DIMENSION JEL(NEL),LTYP(NEL),MAT(NEL),KGVN(MXDF,NN),NMOD(NIP,NEL),
     + NCORR(NTPE,NEL),MREL(MUMAX),NREL(NNZ),NP1(NPL),NP2(NPL),NQ(NN)
      DIMENSION IDFX(NDF),PR(NPR,NMT),CIP(NDIM),F(NDIM,NDMX),
     + B(NS,NB),DS(NDIM,NDMX),ELCOD(NDIM,NDMX),CARTD(NDIM,NDMX),
     + SHFN(NDMX),V(LV),NTY(NMT),KDF(MXDF,NN),MRELVV(NEL)
      DIMENSION VARINT(NVRS,NIP,NEL),PCOR(NDF),XYFT(NDF),P(NDF),
     + DA(NDF),PDISLD(NDIM,NPT),PRES(NDIM,NPT),PEQT(NDF),PEXIB(NDF),
     + PCONI(NDF),PT(NDF),XYZ(NDIM,NN),LL(NL),A(MFZ),KLT(LTZ),REAC(NDF)
      DIMENSION NLI(100),NHI(100),PORINS(NN)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /FF    / AR(40),NCARD,NERR,JERR,LUN
CF    COMMON /FFL   / JDO(130)
      COMMON /DEVSUP/ IW14,IW15,IWS
C
C--------CODE TO INDICATE STAGE OF THE ANALYSIS
      KSTGE=1
      CALL ZEROI1(JEL,NEL)
C
      IF(IPRIM.EQ.0) GO TO 28
C-----------------------------------------------------------------------
C     READ  AND  REMOVE  ELEMENTS  TO  FORM  PRIMARY  MESH
C-----------------------------------------------------------------------
      WRITE(IW6,907)
      CALL RDINT(JEL,IPRIM)
      WRITE(IW6,920)(JEL(J),J=1,IPRIM)
      CALL CHANGE(IW6,0,IPRIM,NN,MXDF,NTPE,NIP,NEL,MUMAX,NDF,
     + NDIM,NVRS,NDMX,NL,NB,NS,NPR,NMT,NPT,NPL,NNZ,XYZ,P,
     + PEXIB,VARINT,MREL,NREL,B,ELCOD,DS,SHFN,F,CARTD,LL,PR,PRES,
     + NCORR,KGVN,NQ,JEL,LTYP,MAT,NP1,NP2,NSP,ZERO)
C-----------------------------------------------------------------------
C     INITIALISE PRESSURE LOADS
C-----------------------------------------------------------------------
   28 NDIM1=NDIM+1
      CALL ZEROR1(PCONI,NDF)
      CALL ZEROR1(REAC,NDF)
      CALL ZEROR2(PRESLD,MXEN,MXLD)
      CALL ZEROI1(LEDG,MXLD)
      CALL ZEROI1(NDE1,MXLD)
      CALL ZEROI1(NDE2,MXLD)
      CALL ZEROI1(MF,MXFXT)
      CALL ZEROI2(TF,6,MXFXT)
      CALL ZEROR2(DXYT,6,MXFXT)
      CALL ZEROI2(NMOD,NIP,NEL)
C-----------------------------------------------------------------------
C     SET  UP  IN SITU  STRESS  SYSTEM
C-----------------------------------------------------------------------
      CALL FFIN(2,3)
      KT=IFIX(AR(1))
      NI=IFIX(AR(2))
      WRITE(IW6,926)KT,NI
      IF(NI.EQ.0)NI=1
      L1=NI+1
      L2=L1+NVRS*NI
CC    L3=L2+NI
CC    L4=L3+NI
      MORE=L2-MFZ+1
      IF(L2.GT.MFZ) THEN
         WRITE(IW6,922)MORE
  922    FORMAT(/1X,
     +          'INCREASE SIZE OF ARRAYS   G    BY',I10)
         STOP
      ENDIF
C
      IF(NI.GT.100) THEN
         WRITE(IW6,932)NI
  932    FORMAT(/1X,
     +          'INCREASE SIZE OF ARRAYS  NLI,  NHI   TO ',I10/
     +        1X,'(ROUTINE INSIT)'/)
         STOP
      ENDIF
C
      CALL INSIT(NN,NEL,NDF,MXDF,MUMAX,NTPE,NIP,NVRS,NL,NB,NS,NPR,
     + NMT,PR,XYZ,VARINT,NCORR,KGVN,LTYP,MAT,MRELVV,MREL,NMOD,PEQT,KT,
     + ELCOD,LL,NDIM,NDMX,CARTD,SHFN,B,DS,CIP,PORINS,NTY,F,
CX   + A(1),A(L1),A(L2),A(L3),NI,KLT,LTZ)
     + A(1),A(L1),NLI,NHI,NI,KLT,LTZ)
C-----------------------------------------------------------------------
C     INITIALISE FIXED LOADS, TOTAL POINT LOADS AND TOTAL DISPLACEMENTS
C     NF - NUMBER OF FIXITIES
C-----------------------------------------------------------------------
      NF=0
C
      CALL ZEROR1(PCOR,NDF)
      CALL ZEROR1(XYFT,NDF)
      CALL ZEROR1(P,NDF)
      CALL ZEROR1(DA,NDF)
C-----------------------------------------------------------------------
C     READ LOADS IN EQUILIBRIUM WITH IN SITU STRESSES
C-----------------------------------------------------------------------
      NLED=0
      TGRAVI=ZERO
      IF(KT.EQ.0)GO TO 82
C
      CALL FFIN(3,3)
      NLODI=IFIX(AR(1))
      NFXI=IFIX(AR(2))
      TGRAVI=AR(3)
C
      IF(NLODI.EQ.0)GO TO 75
      IF(NLODI.GT.0)GOTO 51
      NLODI=IABS(NLODI)
C---------- PRESSURE LOADING
C
      WRITE(IW6,952)NLODI,NFXI,TGRAVI
      WRITE(IW6,960)
      NTM=2*NPT+3
      DO 50 KL=1,NLODI
      CALL FFIN(NTM,7)
      LNE=IFIX(AR(1))
      ND1=IFIX(AR(2))
      ND2=IFIX(AR(3))
      INX=3
C
      DO 40 IV=1,NPT
      PDISLD(2,IV)=AR(INX+1)
      PDISLD(1,IV)=AR(INX+2)
   40 INX=INX+2
      WRITE(IW6,962)LNE,ND1,ND2,((PDISLD(ID,IV),ID=1,2),IV=1,NPT)
C
      CALL EDGLD(IW6,NEL,NDIM,NTPE,NNZ,MUMAX,NPL,NCORR,LTYP,MREL,NREL,
     + LNE,ND1,ND2,NP1,NP2,PDISLD,PRES,KL,NPT,1,MXLD)
   50 CONTINUE
      GOTO 75
C--------- CONCENTRATED LOADING
   51 WRITE(IW6,953)NLODI,NFXI,TGRAVI
      WRITE(IW6,965)
C
      DO 60 JL=1,NLODI
      NTM=NDIM1
      CALL FFIN(NTM,1)
      NDE=IFIX(AR(1))
      NDEP=NREL(NDE)
CC    LOADS BEING APPLIED TO NODES WITH PORE PRESSURE D.O.F ONLY
CC    MUST BE CHECKED.
CC    IF(NQ(NDEP).LT.NDIM)GOTO 52
      IN=KGVN(1,NDEP)-1
C
      DO 55 ID=1,NDIM
   55 PCONI(IN+ID)=PCONI(ID+IN)+AR(ID+1)
C
      WRITE(IW6,970)NDE,(AR(ID),ID=2,NDIM1)
   60 CONTINUE
      WRITE(IW6,880)PCONI
  880 FORMAT(/1X,5HPCONI/(1X,6E16.5))
   75 IF(NFXI.EQ.0)GO TO 82
C-----------------------------------------------------------------------
C     IN SITU BOUNDARY CONDITIONS
C-----------------------------------------------------------------------
      WRITE(IW6,930)
      IF(NDIM.EQ.2)CALL FIXX2(IW6,NEL,NTPE,NDIM,NPL,LV,NCORR,LTYP,MUMAX,
     + NNZ,NP1,NP2,MREL,NREL,V,NFXI,MXFXT)
      IF(NDIM.EQ.3)CALL FIXX3(IW6,NEL,NTPE,NDIM,NPL,LV,NCORR,LTYP,MUMAX,
     + NNZ,NP1,NP2,MREL,NREL,V,NFXI,MXFXT)
C
      CALL MAKENZ(NTPE,NEL,NN,MXDF,NCORR,LTYP,NQ,INXL,KDF)
C
      WRITE(IWS,700)
  700 FORMAT(/1X,'---------------IN SITU STAGE-----------------------')
      CALL EQLOD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,NDZ,NPR,NMT,
     + NDMX,NL,NPL,NCORR,NQ,KGVN,IDFX,LTYP,MAT,JEL,MREL,NREL,NP1,NP2,
     + XYZ,P,PT,PEQT,PCOR,XYFT,PCONI,REAC,PR,F,ELCOD,SHFN,DS,LL,
     + NPT,NSP,MXEN,2,0,TGRAVI,0,ZERO,1,KSTGE,1)
C
   82 RETURN
  907 FORMAT(//1X,38HLIST  OF  REMOVED  ELEMENTS  TO  FORM ,
     + 14H PRIMARY  MESH/1X,52(1H-)/)
  920 FORMAT(20I6/)
  926 FORMAT(//10X,30HIN SITU STRESS OPTION........=,I10
     +        /10X,30HNUMBER OF REFERENCE POINTS...=,I10/)
  930 FORMAT(//1X,27HIN SITU BOUNDARY CONDITIONS/1X,27(1H-))
  952 FORMAT(/
     + 10X,46HNUMBER OF ELEMENT SIDES WITH PRESSURE LOAD...=,I8/
     + 10X,46HNUMBER OF ELEMENT SIDES RESTRAINED...........=,I8/
     + 10X,46HIN SITU GRAVITY LEVEL........................=,F8.1//)
  953 FORMAT(/
     + 10X,46HNUMBER OF NODES WITH POINT LOADS.............=,I8/
     + 10X,46HNUMBER OF ELEMENT SIDES RESTRAINED...........=,I8/
     + 10X,46HIN SITU GRAVITY LEVEL........................=,F8.1//)
  960 FORMAT(/1X,38HSPECIFIED NODAL VALUES OF SHEAR/NORMAL,
     + 19H STRESSES (IN SITU)/1X,57(1H-)/1X,4HELEM,
     + 1X,4HNDE1,2X,4HNDE2,2X,4HNOR1,8X,4HSHR1,8X,4HNOR2,8X,4HSHR2,
     + 8X,4HNOR3,8X,4HSHR3,8X,4HNOR4,8X,4HSHR4,8X,4HNOR5,8X,4HSHR5/)
  962 FORMAT(1X,3I4,10E12.4)
  965 FORMAT(/1X,19HIN SITU POINT LOADS/1X,19(1H-)//
     + 2X,4HNODE,8X,1HX,11X,1HY,11X,1HZ/)
  970 FORMAT(1X,I5,3F12.3)
      END
      SUBROUTINE OUTBM(IW6,IOUT2,MR,KM,JP,ELCOD,VARINT,FT,PR,
     +                 NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,NDF,
     +                 INDX,NDIM,NDN,NEL,NVRS,NIP,NGP,NPR,NMT,LT)
C
C***********************************************************************
C     ROUTINE TO CALCULATE INCREMENTAL STRESSES AND NODAL LOADS
C     EQUIVALENT TO ELEMENT STRESSES FOR 3-NODED BEAM ELEMENT (LT=12)
C***********************************************************************
C
      REAL L
      DIMENSION ELCOD(NDIM,NDN),VARINT(NVRS,NIP,NEL),FT(NDIM,NDN),
     +          PR(NPR,NMT),DI(NDF),KGVN(MXDF,NN),NCORR(NTPE,NEL),
     +          CIP(NDIM)
      DIMENSION SHF(9),DER(9),T(3,3),
     +          DS(9),DM(9),COD(2,3),B(2,9),BN(2,9),BMF(5)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      IF(IOUT2.NE.2)GOTO 10
      WRITE(IW6,900)MR
  900 FORMAT(/15H ELEMENT NUMBER,I5,5X,16H(BEAM - TYPE 12)/1X,19(1H-)/)
      WRITE(IW6,914)
  914 FORMAT(84X,9HAXI FORCE,7X,2HBM,7X,5HLSFBM)
   10 CONTINUE
C
      NDOF=9
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      AI=PR(4,KM)
      NCGP=LINFO(17,LT)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
      D11=E*A
      D22=E*AI
C
      C=ELCOD(1,2)-ELCOD(1,1)
      S=ELCOD(2,2)-ELCOD(2,1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 20 J=1,3
      DO 20 I=1,2
   20 COD(I,J)=ELCOD(I,J)
C
      CALL ROTAT(COD,NDIM,NDN,DL,T)
C
C----------SYSTEM DISPLACEMENTS
      DO 35 I=1,3
      NDE=NCORR(I,JP)
      LOC=KGVN(1,NDE)-1
      NA=3*(I-1)
      DO 30 J=1,2
   30 DS(NA+J)=DI(LOC+J)
C----------ROTATION
      LOCR=KGVN(5,NDE)
   35 DS(NA+3)=DI(LOCR)
C----------TRANSFORM SYSTEM DISPLACEMENTS INTO LOCAL DISPLACEMENTS
      DO 40 I=1,9
   40 DM(I)=ZERO
C
      DO 50 I=1,3
      DO 50 J=1,3
      DM(I)=DM(I)+DS(J)*T(J,I)
      DM(I+3)=DM(I+3)+DS(J+3)*T(J,I)
   50 DM(I+6)=DM(I+6)+DS(J+6)*T(J,I)
C
CC    WRITE(IW6,700)JP,DS,DM
CC700 FORMAT(/1X,'ELEMENT = ',I5,5X,'DS & DM '/(1X,9E14.5))
CC    WRITE(IW6,750)T
CC750 FORMAT(/1X,'T'/(1X,9E14.5))
      BFAC=E*AI/(BL*BL)
C
      CALL CUVFIT(BMF,DM,BFAC,BL)
C
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBM(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,3
   60 DJACB=DJACB+DER(3*IN-2)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)JP,IP,DJACB
         WRITE(IW15,910)JP,IP,DJACB
         WRITE(IWS,910)JP,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
CC    WRITE(IW6,710)SHF,DER
CC710 FORMAT(/1X,'SHF & DER'/(1X,9E14.5))
CC    WRITE(IW6,720)DJACB,FAC
CC720 FORMAT(/1X,'DJACB=',E12.5,4X,'FAC=',E12.5)
C
      DO 70 J=1,9
      DO 70 I=1,2
      B(I,J)=ZERO
   70 BN(I,J)=ZERO
C----------CALCULATE B MATRIX
      B(1,1)=-DER(1)/DJACB
      B(1,4)=-DER(4)/DJACB
      B(1,7)=-DER(7)/DJACB
C
      B(2,2)=-DER(2)/(DJACB**2)
      B(2,3)=-DER(3)/(DJACB**2)
      B(2,5)=-DER(5)/(DJACB**2)
      B(2,6)=-DER(6)/(DJACB**2)
      B(2,8)=-DER(8)/(DJACB**2)
      B(2,9)=-DER(9)/(DJACB**2)
C-----------ALTERNATE STRESS CALCULATION
      DO 90 IN=1,3
C
      DO 80 I=1,2
      DO 80 J=1,3
      NJ=3*(IN-1)+J
      DO 80 K=1,3
      NK=3*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   80 CONTINUE
   90 CONTINUE
C----------CALCULATE STRAINS
      ST1=BN(1,1)*DS(1)+BN(1,4)*DS(4)+BN(1,7)*DS(7)+
     +    BN(1,2)*DS(2)+BN(1,5)*DS(5)+BN(1,8)*DS(8)
      ST2=BN(2,2)*DS(2)+BN(2,3)*DS(3)+BN(2,5)*DS(5)+
     +      BN(2,6)*DS(6)+BN(2,8)*DS(8)+BN(2,9)*DS(9)+
     +      BN(2,1)*DS(1)+BN(2,4)*DS(4)+BN(2,7)*DS(7)
C----------CALCULATE STRESSES
      SS1=D11*ST1
      SS2=D22*ST2
C----------STORE STRESSES
      VARINT(5,IP,JP)=VARINT(5,IP,JP)+SS1
      VARINT(6,IP,JP)=VARINT(6,IP,JP)+SS2
C----------STORE LEAST SQUARE FIT VALUE OF BENDING MOMENT
C----------AT QUARTER POINTS.
      VARINT(7,IP,JP)=VARINT(7,IP,JP)+BMF(IP)
      VARINT(1,IP,JP)=VARINT(1,IP,JP)+SS1*T(1,1)
      VARINT(2,IP,JP)=VARINT(2,IP,JP)+SS1*T(2,1)
C----------PRINT OUT RESULTS
CC    WRITE(IW6,730)B
CC730 FORMAT(1X,'B'/(1X,6E20.5))
CC    WRITE(IW6,740)BN
CC740 FORMAT(1X,'BN'/(1X,6E20.5))
      IF(IOUT2.EQ.0)GOTO 125
      IF(IOUT2.EQ.1)GOTO 120
      IKM=IP
      GOTO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NCGP)GOTO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
      IND=3*IN-2
  123 SUM=SUM+SHF(IND)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
C
      WRITE(IW6,920)IKM,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,JP),IK=1,7)
  920 FORMAT(1X,I3,8E13.5,2E12.4)
  125 CONTINUE
C----------CALCULATE COMPONENTS OF FT
      DO 160 IN=1,3
      DO 150 ID=1,2
      DO 150 J=1,2
      IND=3*(IN-1)+ID
      FT(ID,IN)=FT(ID,IN)+BN(J,IND)*VARINT(J+4,IP,JP)*FAC
  150 CONTINUE
  160 CONTINUE
C
  200 CONTINUE
CC    WRITE(IW6,930)MR,((FT(I,J),J=1,3),I=1,2)
CC930 FORMAT(/1X,'ELEMENT',I5,4X,'FT'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE OUTBR(IW6,IOUT2,MR,KM,JP,ELCOD,VARINT,FT,PR,
     +                 NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,NDF,
     +                 INDX,NDIM,NDN,NEL,NVRS,NIP,NGP,NPR,NMT,LT)
C
C***********************************************************************
C     ROUTINE TO CALCULATE INCREMENTAL STRESSES AND NODAL LOADS
C     EQUIVALENT TO ELEMENT STRESSES FOR 3-NODED BAR ELEMENT (LT=1)
C***********************************************************************
C
      REAL L
      DIMENSION ELCOD(NDIM,NDN),VARINT(NVRS,NIP,NEL),FT(NDIM,NDN),
     +          PR(NPR,NMT),DI(NDF),KGVN(MXDF,NN),NCORR(NTPE,NEL),
     +          CIP(NDIM)
      DIMENSION SHF(3),DER(3),T(3,3),
     +          DS(6),DM(3),COD(2,3),B(3),BN(6)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      IF(IOUT2.NE.2)GOTO 10
      WRITE(IW6,900)MR
  900 FORMAT(/15H ELEMENT NUMBER,I5,5X,14H(BAR - TYPE 1)/1X,19(1H-)/)
      WRITE(IW6,914)
  914 FORMAT(98X,9HAXI FORCE)
   10 CONTINUE
C
      NDOF=9
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      NCGP=LINFO(17,LT)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
      D11=E*A
      NDOF=3
C
      C=ELCOD(1,2)-ELCOD(1,1)
      S=ELCOD(2,2)-ELCOD(2,1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 20 J=1,3
      DO 20 I=1,2
   20 COD(I,J)=ELCOD(I,J)
C
      CALL ROTAT(COD,NDIM,NDN,DL,T)
C
C----------SYSTEM DISPLACEMENTS
      DO 30 I=1,3
      NDE=NCORR(I,JP)
      LOC=KGVN(1,NDE)-1
      NA=2*(I-1)
      DO 30 J=1,2
   30 DS(NA+J)=DI(LOC+J)
C----------TRANSFORM SYSTEM DISPLACEMENTS INTO LOCAL DISPLACEMENTS
      DO 40 I=1,3
   40 DM(I)=ZERO
C
      DO 50 J=1,2
      DM(1)=DM(1)+DS(J)*T(J,1)
      DM(2)=DM(2)+DS(J+2)*T(J,1)
   50 DM(3)=DM(3)+DS(J+4)*T(J,1)
C
CC    WRITE(6,700)JP,DS,DM
CC700 FORMAT(/1X,'ELEMENT = ',I5,5X,'DS AND DM '/(1X,9E14.5))
CC    WRITE(6,750)T
CC750 FORMAT(/1X,'T'/(1X,9E14.5))
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBR(XI,SHF,DER,NDOF,DL)
C----------CALCULATE AXIAL STRESS
      HT=DM(1)*DER(1)+DM(2)*DER(2)+DM(3)*DER(3)
      HT=-2.*HT*E/BL
C----------CALCULATE CUMULATIVE STRESSES
CC    VARINT(2,IP,JP)=VARINT(2,IP,JP)+HT
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,3
   60 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)JP,IP,DJACB
         WRITE(IW15,910)JP,IP,DJACB
         WRITE(IWS,910)JP,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
CC    WRITE(6,710)SHF,DER
CC710 FORMAT(/1X,'SHF AND DER'/(1X,9E14.5))
C
      DO 70 J=1,3
      B(J)=ZERO
      BN(2*J-1)=ZERO
   70 BN(2*J)=ZERO
C----------CALCULATE B MATRIX
      DO 75 J=1,3
   75 B(J)=-DER(J)/DJACB
C
C-----------ALTERNATE STRESS CALCULATION
      DO 80 J=1,3
      BN(2*J-1)=B(J)*T(1,1)
      BN(2*J)  =B(J)*T(2,1)
   80 CONTINUE
C----------CALCULATE AXIAL STRAIN
      ST=BN(1)*DS(1)+BN(2)*DS(2)+BN(3)*DS(3)+
     +    BN(4)*DS(4)+BN(5)*DS(5)+BN(6)*DS(6)
C----------CALCULATE AXIAL STRESS
      SS=D11*ST
C----------STORE STRESS
      VARINT(6,IP,JP)=VARINT(6,IP,JP)+SS
      VARINT(1,IP,JP)=VARINT(1,IP,JP)+SS*T(1,1)
      VARINT(2,IP,JP)=VARINT(2,IP,JP)+SS*T(2,1)
C----------PRINTOUT RESULTS
CC    WRITE(IW6,730)B
CC730 FORMAT(1X,'B'/(1X,6E20.5))
CC    WRITE(IW6,740)BN
CC740 FORMAT(1X,'BN'/(1X,6E20.5))
      IF(IOUT2.EQ.0)GOTO 125
      IF(IOUT2.EQ.1)GOTO 120
      IKM=IP
      GOTO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NCGP)GOTO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
  123 SUM=SUM+SHF(IN)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
C
      WRITE(IW6,920)IKM,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,JP),IK=1,7)
  920 FORMAT(1X,I3,9E13.5)
  125 CONTINUE
C----------CALCULATE COMPONENTS OF FT
      DO 110 IN=1,3
      DO 100 ID=1,2
      FT(ID,IN)=FT(ID,IN)+B(IN)*VARINT(ID,IP,JP)*FAC
  100 CONTINUE
  110 CONTINUE
C
  200 CONTINUE
CC    WRITE(IW6,930)MR,((FT(I,J),J=1,3),I=1,2)
CC930 FORMAT(/1X,'ELEMENT',I5,4X,'FT'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE OUTBM2(IW6,IOUT2,MR,KM,JP,ELCOD,VARINT,FT,PR,
     +                  NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,NDF,
     +                  INDX,NDIM,NDN,NEL,NVRS,NIP,NGP,NPR,NMT,LT)
C
C***********************************************************************
C     ROUTINE TO CALCULATE INCREMENTAL STRESSES AND NODAL LOADS
C     EQUIVALENT TO ELEMENT STRESSES FOR 2-NODED BEAM ELEMENT (LT=15)
C***********************************************************************
C
      REAL L
      DIMENSION ELCOD(NDIM,NDN),VARINT(NVRS,NIP,NEL),FT(NDIM,NDN),
     +          PR(NPR,NMT),DI(NDF),KGVN(MXDF,NN),NCORR(NTPE,NEL),
     +          CIP(NDIM)
      DIMENSION SHF(6),DER(6),T(3,3),
     +          DS(6),DM(6),COD(2,2),B(2,6),BN(2,6),BMF(5)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
      IF(IOUT2.NE.2)GOTO 10
      WRITE(IW6,900)MR
  900 FORMAT(/15H ELEMENT NUMBER,I5,5X,16H(BEAM - TYPE 15)/1X,19(1H-)/)
      WRITE(IW6,914)
  914 FORMAT(84X,8HAX FORCE,8X,2HBM,7X,5HLSFBM)
   10 CONTINUE
C
      NDOF=6
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      AI=PR(4,KM)
      NCGP=LINFO(17,LT)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
      D11=E*A
      D22=E*AI
C
      C=ELCOD(1,2)-ELCOD(1,1)
      S=ELCOD(2,2)-ELCOD(2,1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 20 J=1,2
      DO 20 I=1,2
   20 COD(I,J)=ELCOD(I,J)
C
      CALL ROTAT(COD,NDIM,NDN,DL,T)
C
C----------SYSTEM DISPLACEMENTS
      DO 35 I=1,2
      NDE=NCORR(I,JP)
      LOC=KGVN(1,NDE)-1
      NA=3*(I-1)
      DO 30 J=1,2
   30 DS(NA+J)=DI(LOC+J)
C----------ROTATION
      LOCR=KGVN(5,NDE)
   35 DS(NA+3)=DI(LOCR)
C----------TRANSFORM SYSTEM DISPLACEMENTS INTO LOCAL DISPLACEMENTS
      DO 40 I=1,6
   40 DM(I)=ZERO
C
      DO 50 I=1,2
      DO 50 J=1,2
      DM(I)=DM(I)+DS(J)*T(J,I)
   50 DM(I+3)=DM(I+3)+DS(J+3)*T(J,I)
C
      WRITE(IW6,700)JP,DS,DM
  700 FORMAT(/1X,'ELEMENT = ',I5,5X,'DS & DM '/(1X,9E14.5))
      WRITE(IW6,750)T
  750 FORMAT(/1X,'T'/(1X,9E14.5))
      BFAC=E*AI/(BL*BL)
C
      CALL CUVFIT(BMF,DM,BFAC,BL)
C
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBM(XI,SHF,DER,NDOF,DL)
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,2
   60 DJACB=DJACB+DER(3*IN-2)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)JP,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
      WRITE(IW6,710)SHF,DER
  710 FORMAT(/1X,'SHF & DER'/(1X,9E14.5))
      WRITE(IW6,720)DJACB,FAC
  720 FORMAT(/1X,'DJACB=',E12.5,4X,'FAC=',E12.5)
C
      DO 70 J=1,6
      DO 70 I=1,2
      B(I,J)=ZERO
   70 BN(I,J)=ZERO
C----------CALCULATE B MATRIX
      B(1,1)=-DER(1)/DJACB
      B(1,4)=-DER(4)/DJACB
C
      B(2,2)=-DER(2)/(DJACB**2)
      B(2,3)=-DER(3)/(DJACB**2)
      B(2,5)=-DER(5)/(DJACB**2)
      B(2,6)=-DER(6)/(DJACB**2)
C-----------ALTERNATE STRESS CALCULATION
      DO 90 IN=1,2
C
      DO 80 I=1,2
      DO 80 J=1,3
      NJ=3*(IN-1)+J
      DO 80 K=1,3
      NK=3*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   80 CONTINUE
   90 CONTINUE
C----------CALCULATE STRAINS
      ST1=BN(1,1)*DS(1)+BN(1,4)*DS(4)+
     +    BN(1,2)*DS(2)+BN(1,5)*DS(5)
      ST2=BN(2,2)*DS(2)+BN(2,3)*DS(3)+BN(2,5)*DS(5)+
     +      BN(2,6)*DS(6)+
     +      BN(2,1)*DS(1)+BN(2,4)*DS(4)
C----------CALCULATE STRESSES
      SS1=D11*ST1
      SS2=D22*ST2
C----------STORE STRESSES
      VARINT(5,IP,JP)=VARINT(5,IP,JP)+SS1
      VARINT(6,IP,JP)=VARINT(6,IP,JP)+SS2
C----------STORE LEAST SQUARE FIT VALUE OF BENDING MOMENT
C----------AT QUARTER POINTS.
      VARINT(7,IP,JP)=VARINT(7,IP,JP)+BMF(IP)
      VARINT(1,IP,JP)=VARINT(1,IP,JP)+SS1*T(1,1)
      VARINT(2,IP,JP)=VARINT(2,IP,JP)+SS1*T(2,1)
C----------PRINT OUT RESULTS
      WRITE(IW6,730)B
  730 FORMAT(1X,'B'/(1X,6E20.5))
      WRITE(IW6,740)BN
  740 FORMAT(1X,'BN'/(1X,6E20.5))
      IF(IOUT2.EQ.0)GOTO 125
      IF(IOUT2.EQ.1)GOTO 120
      IKM=IP
      GOTO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NCGP)GOTO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
      IND=3*IN-2
  123 SUM=SUM+SHF(IND)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
C
      WRITE(IW6,920)IKM,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,JP),IK=1,7)
  920 FORMAT(1X,I3,8E13.5,2E12.4)
  125 CONTINUE
C----------CALCULATE COMPONENTS OF FT
      DO 160 IN=1,2
      DO 150 ID=1,2
      DO 150 J=1,2
      IND=3*(IN-1)+ID
      FT(ID,IN)=FT(ID,IN)+BN(J,IND)*VARINT(J+4,IP,JP)*FAC
  150 CONTINUE
  160 CONTINUE
C
  200 CONTINUE
      WRITE(IW6,930)MR,((FT(I,J),J=1,2),I=1,2)
  930 FORMAT(/1X,'ELEMENT',I5,4X,'FT'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE OUTBR2(IW6,IOUT2,MR,KM,JP,ELCOD,VARINT,FT,PR,
     +                  NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,NDF,
     +                  INDX,NDIM,NDN,NEL,NVRS,NIP,NGP,NPR,NMT,LT)
C
C***********************************************************************
C     ROUTINE TO CALCULATE INCREMENTAL STRESSES AND NODAL LOADS
C     EQUIVALENT TO ELEMENT STRESSES FOR 2-NODED BAR ELEMENT (LT=14)
C***********************************************************************
C
      REAL L
      DIMENSION ELCOD(NDIM,NDN),VARINT(NVRS,NIP,NEL),FT(NDIM,NDN),
     +          PR(NPR,NMT),DI(NDF),KGVN(MXDF,NN),NCORR(NTPE,NEL),
     +          CIP(NDIM)
      DIMENSION SHF(2),DER(2),T(3,3),
     +          DS(4),DM(2),COD(2,2),B(2),BN(4)
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
C
      IF(IOUT2.NE.2)GOTO 10
      WRITE(IW6,900)MR
  900 FORMAT(/15H ELEMENT NUMBER,I5,5X,15H(BAR - TYPE 14)/1X,19(1H-)/)
      WRITE(IW6,914)
  914 FORMAT(98X,8HAX FORCE)
   10 CONTINUE
C
      E=PR(1,KM)
      VS=PR(2,KM)
      A=PR(3,KM)
      NCGP=LINFO(17,LT)
C
C *** FOR PLANE STRAIN CONDITION MODIFY E
C
      E=E/(1.-VS*VS)
      D11=E*A
      NDOF=2
C
      C=ELCOD(1,2)-ELCOD(1,1)
      S=ELCOD(2,2)-ELCOD(2,1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      DO 20 J=1,2
      DO 20 I=1,2
   20 COD(I,J)=ELCOD(I,J)
C
      CALL ROTAT(COD,NDIM,NDN,DL,T)
C
C----------SYSTEM DISPLACEMENTS
      DO 30 I=1,2
      NDE=NCORR(I,JP)
      LOC=KGVN(1,NDE)-1
      NA=2*(I-1)
      DO 30 J=1,2
   30 DS(NA+J)=DI(LOC+J)
C----------TRANSFORM SYSTEM DISPLACEMENTS INTO LOCAL DISPLACEMENTS
      DO 40 I=1,2
   40 DM(I)=ZERO
C
      DO 50 J=1,2
      DM(1)=DM(1)+DS(J)*T(J,1)
   50 DM(2)=DM(2)+DS(J+2)*T(J,1)
C
CC    WRITE(6,700)JP,DS,DM
CC700 FORMAT(/1X,'ELEMENT = ',I5,5X,'DS AND DM '/(1X,9E14.5))
CC    WRITE(6,750)T
CC750 FORMAT(/1X,'T'/(1X,9E14.5))
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      CALL SFRBR(XI,SHF,DER,NDOF,DL)
C----------CALCULATE AXIAL STRESS
      HT=DM(1)*DER(1)+DM(2)*DER(2)
      HT=-2.*HT*E/BL
C----------CALCULATE CUMULATIVE STRESSES
CC    VARINT(2,IP,JP)=VARINT(2,IP,JP)+HT
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,2
   60 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)JP,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=DJACB*W(IPA)
CC    WRITE(6,710)SHF,DER
CC710 FORMAT(/1X,'SHF AND DER'/(1X,9E14.5))
C
      DO 70 J=1,2
      BN(2*J-1)=ZERO
   70 BN(2*J)=ZERO
C----------CALCULATE B MATRIX
      DO 75 J=1,2
   75 B(J)=-DER(J)/DJACB
C
C-----------ALTERNATE STRESS CALCULATION
      DO 80 J=1,2
      BN(2*J-1)=B(J)*T(1,1)
      BN(2*J)  =B(J)*T(2,1)
   80 CONTINUE
C----------CALCULATE AXIAL STRAIN
      ST=BN(1)*DS(1)+BN(2)*DS(2)+BN(3)*DS(3)+
     +    BN(4)*DS(4)
C----------CALCULATE AXIAL STRESS
      SS=D11*ST
C----------STORE STRESS
      VARINT(6,IP,JP)=VARINT(6,IP,JP)+SS
      VARINT(1,IP,JP)=VARINT(1,IP,JP)+SS*T(1,1)
      VARINT(2,IP,JP)=VARINT(2,IP,JP)+SS*T(2,1)
C----------PRINTOUT RESULTS
CC    WRITE(6,730)B
CC730 FORMAT(1X,'B'/(1X,6E20.5))
CC    WRITE(6,740)BN
CC740 FORMAT(1X,'BN'/(1X,6E20.5))
      IF(IOUT2.EQ.0)GOTO 125
      IF(IOUT2.EQ.1)GOTO 120
      IKM=IP
      GOTO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NCGP)GOTO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
  123 SUM=SUM+SHF(IN)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
C
      WRITE(IW6,920)IKM,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,JP),IK=1,7)
  920 FORMAT(1X,I3,9E13.5)
  125 CONTINUE
C----------CALCULATE COMPONENTS OF FT
      DO 110 IN=1,2
      DO 100 ID=1,2
      FT(ID,IN)=FT(ID,IN)+B(IN)*VARINT(ID,IP,JP)*FAC
  100 CONTINUE
  110 CONTINUE
C
  200 CONTINUE
CC    WRITE(IW6,930)MR,((FT(I,J),J=1,2),I=1,2)
CC930 FORMAT(/1X,'ELEMENT',I5,4X,'FT'/(1X,3E20.5))
      RETURN
      END
      SUBROUTINE OUTSLP(IW6,IOUT2,MR,KM,NE,ELCOD,VARINT,FT,PR,
     +                 NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,NDF,
     +                 INDX,NDIM,NDN,NEL,NVRS,NIP,NGP,NPR,NMT,LT)
C
C***********************************************************************
C     ROUTINE TO CALCULATE INCREMENTAL STRESSES AND NODAL LOADS
C     EQUIVALENT TO ELEMENT STRESSES FOR 8-NODED SLIP ELEMENT (LT=13)
C***********************************************************************
C
      REAL L
      DIMENSION ELCOD(NDIM,NDN),VARINT(NVRS,NIP,NEL),FT(NDIM,NDN),
     +          PR(NPR,NMT),DI(NDF),KGVN(MXDF,NN),NCORR(NTPE,NEL),
     +          CIP(NDIM)
      DIMENSION T(3,3),D(3,3),SHF(3),DER(3),COD(2,6),CODS(2,6),
     +          B(3,12),BN(3,12),DM(12),DS(12),ST(3),SS(2)
      COMMON /FLOW / NPLAX
      COMMON /DATL / L(4,100)
      COMMON /DATW / W(100)
      COMMON /ELINF/ MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS / PYI,ALAR,ASMVL,ZERO
      COMMON /PROP / COH,PHI,AKN,AKS,AKSRES
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      CR=1.
      IF(NPLAX.EQ.1)CR=2.*PYI
C
      IF(IOUT2.NE.2)GOTO 10
      WRITE(IW6,900)MR
  900 FORMAT(/15H ELEMENT NUMBER,I5,4X,
     + 24H(SLIP ELEMENT - TYPE 13)/1X,19(1H-)/)
      WRITE(IW6,914)
  914 FORMAT(101X,5HSIG-N,7X,5HSIG-S)
   10 CONTINUE
C
      DO 20 J=1,3
      DO 20 I=1,3
   20 T(I,J)=ZERO
      T(3,3)=1.
C
      COH=PR(1,KM)
      PHI=PR(2,KM)*ATAN(1.0)/45.
      AKN=PR(3,KM)
      AKS=PR(4,KM)
      AKSRES=PR(5,KM)
      THICK=PR(6,KM)
C
C *** CALCULATE STIFFNESS
C
      N1=NCORR(1,NE)
      N2=NCORR(2,NE)
      N3=NCORR(3,NE)
      N4=NCORR(4,NE)
      N5=NCORR(5,NE)
      N1=IABS(N1)
      N2=IABS(N2)
      N3=IABS(N3)
      N4=IABS(N4)
      N5=IABS(N5)
      C=(ELCOD(1,2)+ELCOD(1,3))*0.5-(ELCOD(1,1)+ELCOD(1,4))*0.5
      S=(ELCOD(2,2)+ELCOD(2,3))*0.5-(ELCOD(2,1)+ELCOD(2,4))*0.5
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      COD(1,1)=ELCOD(1,1)
      COD(2,1)=ELCOD(2,1)
      COD(1,2)=ELCOD(1,2)
      COD(2,2)=ELCOD(2,2)
      COD(1,3)=ELCOD(1,5)
      COD(2,3)=ELCOD(2,5)
C
      COD(1,4)=ELCOD(1,4)
      COD(1,5)=ELCOD(1,3)
      COD(1,6)=ELCOD(1,7)
C
C
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NCGP=LINFO(17,LT)
C
      DO 25 I=1,2
      DO 25 J=1,6
   25 CODS(I,J)=COD(I,J)
C
      CALL ROTAT(COD,NDIM,3,DL,T)
C----------SYSTEM DISPLACEMENTS
      IN=0
      DO 35 I=1,8
      NDE=NCORR(I,NE)
      IF(KGVN(1,NDE).EQ.0)GOTO 35
      LOC=KGVN(1,NDE)-1
      IN=IN+1
      NA=2*(IN-1)
      DO 30 J=1,2
   30 DS(NA+J)=DI(LOC+J)
   35 CONTINUE
C----------TRANSFORM SYSTEM DISPLACEMENTS INTO LOCAL DISPLACEMENTS
      DO 40 I=1,12
   40 DM(I)=ZERO
C
      DO 50 K=1,6
      DO 50 J=1,2
   50 DM(2*K+J-2)=DS(2*K-1)*T(1,J)+DS(2*K)*T(2,J)
C
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      SHF(1)=XI*(XI-1.)/2.
      SHF(2)=XI*(XI+1.)/2.
      SHF(3)=(1.+XI)*(1.-XI)
C
C--------CALCULATE X (OR R)
      R=0.
      DO 55 I=1,3
      R=R+0.5*SHF(I)*CODS(1,I)+0.5*SHF(I)*CODS(1,I+3)
   55 CONTINUE
C
      DER(1)=(2.*XI-1.)/2.
      DER(2)=(2.*XI+1.)/2.
      DER(3)=-2.*XI
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 60 IN=1,3
   60 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)MR,IP,DJACB
         WRITE(IW15,910)MR,IP,DJACB
         WRITE(IWS,910)MR,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO')
         STOP
      ENDIF
C
      FAC=CR*DJACB*W(IPA)*THICK
      IF(NPLAX.EQ.1) FAC=FAC*R
CC    WRITE(6,710)SHF,DER
CC710 FORMAT(/1X,'SHF & DER'/(1X,9E14.5))
C
C--------- CALCULATE D MATRIX
      CALL DSLIP(NVRS,NIP,NEL,VARINT,D,IP,NE)
C
      DO 70 IS=1,3
      DO 70 IN=1,12
      B(IS,IN)=ZERO
   70 BN(IS,IN)=ZERO
C----------CALCULATE B MATRIX
      B(1,2)= SHF(1)/THICK
      B(1,4)= SHF(2)/THICK
      B(1,6)=-SHF(2)/THICK
      B(1,8)=-SHF(1)/THICK
      B(1,10)= SHF(3)/THICK
      B(1,12)=-SHF(3)/THICK
C
      B(2,1)= SHF(1)/THICK
      B(2,3)= SHF(2)/THICK
      B(2,5)=-SHF(2)/THICK
      B(2,7)=-SHF(1)/THICK
      B(2,9)= SHF(3)/THICK
      B(2,11)=-SHF(3)/THICK
C
      IF(NPLAX.EQ.1) THEN
         B(3,1)=-SHF(1)/(R)
         B(3,3)=-SHF(2)/(R)
         B(3,5)=-SHF(2)/(R)
         B(3,7)=-SHF(1)/(R)
         B(3,9)=-SHF(3)/(R)
         B(3,11)=-SHF(3)/(R)
C
         BN(3,1)=-SHF(1)/(4.*R)
         BN(3,3)=-SHF(2)/(4.*R)
         BN(3,5)=-SHF(2)/(4.*R)
         BN(3,7)=-SHF(1)/(4.*R)
         BN(3,9)=-SHF(3)/(2.*R)
         BN(3,11)=-SHF(3)/(2.*R)
      ENDIF
C
      DO 90 IN=1,6
C
      DO 80 I=1,2
      DO 80 J=1,2
      NJ=2*(IN-1)+J
      DO 80 K=1,2
      NK=2*(IN-1)+K
      BN(I,NJ)=BN(I,NJ)+B(I,NK)*T(J,K)
   80 CONTINUE
   90 CONTINUE
C
C----------CALCULATE STRAINS
      DO 100 I=1,3
      ST(I)=ZERO
      DO 100 J=1,12
  100 ST(I)=ST(I)+BN(I,J)*DS(J)
C
C---------TEST FOR POSSIBILITY OF RE-CONTACT AFTER TENSION
C---------HAS DEVELOPED.
      IF(VARINT(6,IP,NE).GT.-ASMVL)GOTO 105
      SIGNRI=ST(1)*D(1,1)
      IF(SIGNRI.GT.ZERO) THEN
         VARINT(6,IP,NE)=ZERO
         VARINT(7,IP,NE)=ZERO
      ELSE
         VARINT(6,IP,NE)=-2.*ASMVL
         VARINT(7,IP,NE)=-2.*ASMVL
      ENDIF
C
  105 CONTINUE
C
C----------CALCULATE INCR STRESSES
      DO 110 I=1,2
      SS(I)=ST(I)*D(I,I)
  110 VARINT(I+5,IP,NE)=VARINT(I+5,IP,NE)+SS(I)
      VARINT(4,IP,NE)=VARINT(4,IP,NE)+ST(3)*D(3,3)
C---------IF SHEAR STRESS EXCEEDS LIMITING VALUE REDUCE IT
      SIGSH=VARINT(7,IP,NE)
      SIGNR=VARINT(6,IP,NE)
      IF(SIGNR.GT.ASMVL) THEN
         SHRL=COH+TAN(PHI)*SIGNR
         IF(ABS(SIGSH).GT.SHRL) THEN
            SGN=SIGN(1.0,SIGSH)
            VARINT(7,IP,NE)=SGN*SHRL
         ENDIF
      ENDIF
C
C----------STORE STRESSES
      VARINT(1,IP,NE)=VARINT(1,IP,NE)+T(1,1)*SS(1)+T(2,1)*SS(2)
      VARINT(2,IP,NE)=VARINT(2,IP,NE)+T(1,2)*SS(1)+T(2,2)*SS(2)
C----------PRINTOUT RESULTS
CC    WRITE(IW6,730)B
CC730 FORMAT(1X,'B'/(1X,6E20.5))
CC    WRITE(IW6,740)BN
CC740 FORMAT(1X,'BN'/(1X,6E20.5))
      IF(IOUT2.EQ.0)GOTO 125
      IF(IOUT2.EQ.1)GOTO 120
      IKM=IP
      GOTO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NCGP)GOTO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,3
      MN=IN
      IF(IN.EQ.3)MN=5
  123 SUM=SUM+SHF(IN)*ELCOD(ID,MN)
  124 CIP(ID)=SUM
C
      WRITE(IW6,920)IKM,(CIP(ID),ID=1,NDIM),(VARINT(IK,IP,NE),IK=1,7)
  920 FORMAT(1X,I3,9E13.5)
  125 CONTINUE
C----------CALCULATE COMPONENTS OF FT
      DO 180 IN=1,6
      DO 160 ID=1,2
      DO 160 J=1,2
      KN=IN
      IF(IN.EQ.6)KN=7
      IND=2*(IN-1)+ID
      IF(J.EQ.1)FT(ID,KN)=FT(ID,KN)+BN(J,IND)*(VARINT(J+5,IP,NE)
     +        +VARINT(5,IP,NE))*FAC
      IF(J.EQ.2)FT(ID,KN)=FT(ID,KN)+BN(J,IND)*VARINT(J+5,IP,NE)*FAC
  160 CONTINUE
  180 CONTINUE
  200 CONTINUE
C
CC    WRITE(IW6,930)MR,((FT(I,J),J=1,8),I=1,2)
CC930 FORMAT(/1X,'ELEMENT',I5,4X,'FT'/(1X,4E20.6))
      RETURN
      END
      SUBROUTINE OUTSM(IW6,ICCSM)
C
C***********************************************************************
C
C     PRINT OUT SUMMARY OF CAM CLAY BEHAVIOUR
C
C***********************************************************************
C
      CHARACTER*50 CCTI
      DIMENSION ICCSM(20),CCTI(20)
      DATA (CCTI(I1),I1=1,10)/
     +     'APPROACHING CRITICAL STATE.........        -      ',
     +     'ELASTIC  (CODES 0,1,2) ............        < 1.0  ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.00 - 1.05 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.05 - 1.10 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.10 - 1.20 ',
     +     'HARDENING ON WET SIDE (CODE 3).....   1.20 - 1.50 ',
     +     'HARDENING ON WET SIDE (CODE 3).....        > 1.50 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)   0.95 - 1.00 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)   0.90 - 0.95 ',
     +     'SOFTENING ON DRY SIDE (CODE 4 OR 5)        < 0.90 '/
      DATA (CCTI(I2),I2=11,20)/
     +     'YIELDING ON TENSION CUTOFF (CODE 6)            -  ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....   1.00 - 1.05 ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....   1.05 - 1.10 ',
     +     'HARDENING ABOVE C.S.L.(CODE 7).....        > 1.10 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.00 - 1.05 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.05 - 1.10 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.10 - 1.20 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....   1.20 - 1.50 ',
     +     'HARDENING ON DRY SIDE (CODE 8).....        > 1.50 ',
     +     'NEGATIVE EFFECTIVE P  (CODE 9).....        -      '/
C
      WRITE(IW6,900)
  900 FORMAT(//1X,'SUMMARY OF CAM-CLAY BEHAVIOUR'/1X,29(1H-)/
     + 38X,'YIELD RATIOS',2X,'NUMBER OF',44X,'YIELD RATIOS',2X,
     + 'NUMBER OF'/
     + 14X,'STRESS STATE',16X,'RANGE',5X,'INT. PTS',26X,'STRESS STATE',
     + 11X,'RANGE',5X,'INT. PTS'/14X,12(1H-),16X,5(1H-),5X,8(1H-),
     + 26X,12(1H-),11X,5(1H-),5X,8(1H-)/)
C
      DO 50 IL=1,10
      I1=IL
      I2=IL+10
      IF(IL.LE.10) THEN
         WRITE(IW6,910)CCTI(I1),ICCSM(I1),CCTI(I2),ICCSM(I2)
      ELSE
         WRITE(IW6,910)CCTI(I1),ICCSM(I1)
      ENDIF
  910 FORMAT(1X,A50,2X,I5,10X,A50,2X,I5)
   50 CONTINUE
      WRITE(IW6,920)
  920 FORMAT(/)
      RETURN
      END
      SUBROUTINE OUTSTR(IW6,NN,NEL,NTPE,NIP,NVRS,
     +                  NVRN,NDIM,MUMAX,NDMX,NS,NL,INXL,XYZ,STR,
     +                  CIP,LL,DS,ELCOD,SHFN,NCORR,LTYP,MAT,MREL,
     +                  VARINT,IOUT3)
C
C***********************************************************************
C     ROUTINE TO OUTPUT  STRAINS
C***********************************************************************
C
      REAL L,LL
      DIMENSION XYZ(NDIM,NN),NCORR(NTPE,NEL),LTYP(NEL),MAT(NEL)
      DIMENSION STR(NVRN,NIP,NEL),CIP(NDIM),MREL(MUMAX),
     + DS(NDIM,NDMX),ELCOD(NDIM,NDMX),SHFN(NDMX),LL(NL)
      DIMENSION VARINT(NVRS,NIP,NEL)
      COMMON /DATL  / L(4,100)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      PARAMETER (CONV=57.2937795)
C
      IF(NDIM.EQ.2)THEN
         IF(IOUT3.EQ.2)WRITE(IW6,904)
         IF(IOUT3.EQ.1)WRITE(IW6,906)
      ELSE IF(NDIM.EQ.3) THEN
         IF(IOUT3.EQ.2)WRITE(IW6,904)
         IF(IOUT3.EQ.1)WRITE(IW6,936)
      ENDIF
C
      DO 200 MR=1,MUMAX
      J=MREL(MR)
      IF(J.EQ.0) GO TO 200
      LT=LTYP(J)
      IF(LT.LT.0)GO TO 200
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
C-----------------------------------------------------------------------
C     SET UP LOCAL NODAL COORDINATES OF ELEMENT
C-----------------------------------------------------------------------
      DO 20 KN=1,NDN
      NDE=NCORR(KN,J)
      DO 20 ID=1,NDIM
   20 ELCOD(ID,KN)=XYZ(ID,NDE)
C
      KM=MAT(J)
C
      IF(LT.EQ.1.OR.LT.EQ.12.OR.LT.EQ.13)GOTO 130
C
      IF(IOUT3.NE.2)GO TO 26
      IF(MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,908)MR
      IF(NDIM.EQ.2.AND.MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,914)
      IF(NDIM.EQ.3.AND.MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,944)
   26 CONTINUE
      IPS=1
      IF(IOUT3.EQ.1)IPS=NGP
C-----------------------------------------------------------------------
C     LOOP ON ALL INTEGRATION POINTS OR CENTROID
C-----------------------------------------------------------------------
      DO 125 IP=IPS,NGP
      IPA=IP+INDX
      DO 35 IL=1,NAC
   35 LL(IL)=L(IL,IPA)
C-----------------------------------------------------------------------
C     CALCULATE SHAPE FUNCTIONS
C-----------------------------------------------------------------------
      CALL SHAPE(IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,1)
C
      IKM=MR
      IF(IOUT3.EQ.2)IKM=IP
C
      DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
  123 SUM=SUM+SHFN(IN)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
      IF(MR.LT.NELOS.OR.MR.GT.NELOF)GOTO 125
C
      IF(NDIM.EQ.2) THEN
         S=0.5*(VARINT(1,IP,J)+VARINT(2,IP,J))
         T=SQRT(0.25*(VARINT(2,IP,J)-VARINT(1,IP,J))**2
     +   +VARINT(4,IP,J)**2)
         IF(ABS(S).LT.ASMVL) THEN
            VAL=999.
         ELSE
            RAT=T/S
            IF(ABS(RAT).GT.1.) THEN
CC                WRITE(IW6,920)T,S,RAT
CC920             FORMAT(1X,' **** T =',E16.5,5X,'S =',E16.5,
CC   +                   5X,'T/S =',E16.5)
               RAT=SIGN(1.0,RAT)
            ENDIF
            PHI=ASIN(RAT)*CONV
         ENDIF
C
         VOL=STR(1,IP,J)+STR(2,IP,J)
         SHR=0.5*(STRMAX(STR(1,IP,J),NVRN,NDIM))
         IF(ABS(SHR).LT.ASMVL) THEN
            VAL=999.
         ELSE
            RAT=VOL/SHR
            IF(ABS(RAT).GT.1.) THEN
CC                WRITE(IW6,930)VOL,SHR,RAT
CC930             FORMAT(1X,' **** VOL =',E16.5,5X,'SHR =',E16.5,
CC   +                   5X,'VOL/SHR =',E16.5)
                RAT=SIGN(1.0,RAT)
            ENDIF
            PSI=ASIN(-RAT)*CONV
         ENDIF
         STRMX=STRMAX(STR(1,IP,J),NVRN,NDIM)
      ENDIF
      ED=EDS(STR(1,IP,J),NVRN,NDIM)
C
      IF(NDIM.EQ.2)WRITE(IW6,916)IKM,(CIP(ID),ID=1,NDIM),
     + (STR(IK,IP,J),IK=1,NVRN),ED,STRMX,PHI,PSI
      IF(NDIM.EQ.3)WRITE(IW6,946)IKM,(CIP(ID),ID=1,NDIM),
     + (STR(IK,IP,J),IK=1,NVRN)
  125 CONTINUE
  130 CONTINUE
C
  200 CONTINUE
C
CC900 FORMAT(1X,I5,6E15.5)
  904 FORMAT(//41H CUMULATIVE STRAINS AT INTEGRATION POINTS/
     + 1X,40(1H-)//)
  908 FORMAT(/15H ELEMENT NUMBER,I5/1X,19(1H-)/)
  914 FORMAT(2X,2HIP,7X,1HX,13X,1HY,9X,6HEPS-XX,7X,6HEPS-YY,7X,6HEPS-ZZ,
     + 8X,3HGXY,9X,6HDEVSTR,7X,6HMAXSTR,6X,7HMOB ANG,3X,7HDIL ANG)
  916 FORMAT(1X,I3,8E13.5,2F10.1)
  906 FORMAT(//29H STRAINS AT ELEMENT CENTROIDS/1X,28(1H-)//8H ELEMENT,
     + 3X,1HX,13X,1HY,9X,6HEPS-XX,7X,6HEPS-YY,7X,6HEPS-ZZ,8X,
     + 3HGXY,9X,6HDEVSTR,7X,6HMAXSTR,6X,7HMOB ANG,5X,7HDIL ANG)
  936 FORMAT(//29H STRAINS AT ELEMENT CENTROIDS/1X,28(1H-)//8H ELEMENT,
     + 3X,1HX,13X,1HY,12X,1HZ,9X,6HEPS-XX,7X,6HEPS-YY,7X,
     + 6HEPS-ZZ,9X,3HGXY,11X,3HGYZ,10X,3HGZX)
CC940 FORMAT(1X,I5,8E15.5)
CC941 FORMAT(1X,I5,3E15.5,15X,3E15.5)
  944 FORMAT(2X,2HIP,7X,1HX,12X,1HY,12X,1HZ,9X,6HEPS-XX,
     + 7X,6HEPS-YY,7X,6HEPS-ZZ,7X,3HGXY,9X,3HGYZ,9X,3HGZX)
  946 FORMAT(1X,I2,9E13.5,E12.5)
      RETURN
      END
      SUBROUTINE PRINC(C,D,E,B)
C***********************************************************************
C     CALCULATES  PRINCIPAL  STRESSES  AND  THEIR  DIRECTIONS
C***********************************************************************
      DIMENSION B(3)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C
      AP=C+D
      AD=C-D
      S=SQRT(.25*AD*AD+E*E)
      B(1)=.5*AP+S
      B(2)=.5*AP-S
      B(3)=0.
      IF(ABS(AD).LT.ASMVL) GO TO 2
      B(3)=28.6479*ATAN(2.*E/AD)
    2 RETURN
      END
      SUBROUTINE PRINTF(IWT,ELPA,MFZ,NDF,RHS)
C***********************************************************************
C     PRINTS OUT UPPER TRIANGULAR MATRIX
C***********************************************************************
      CHARACTER*4 IG,IFORM
      DIMENSION RHS(NDF),BUFF(10),IFORM(4),IG(10),ELPA(MFZ)
      DATA IFORM(2),IFORM(3),IFORM(4)/'X,10','E12.','4)  '/
      DATA IG(1),IG(2),IG(3),IG(4),IG(5),IG(6),IG(7),IG(8),IG(9),IG(10)/
     +'  (1',' (13',' (25',' (37',' (49',' (61',' (73',' (85',
     +' (97','(109'/
C
      WRITE(IWT,900)
  900 FORMAT(8H0GRANDPA)
      IF(NDF.EQ.0) RETURN
CC    GOTO 99
C
      NSUB=(NDF+9)/10
C
      DO 20 JJ=1,NSUB
      J2=10*JJ
      J1=J2-9
      IF(J2.GT.NDF)J2=NDF
      WRITE(IWT,904) J1,J2
  904 FORMAT(8H0COLUMNS,I4,3H TO,I4)
      DO 18 II=1,JJ
      IFORM(1)=IG(1)
      I2=10*II
      I1=I2-9
      IF(I2.GT.NDF)I2=NDF
      WRITE(IWT,905)I1,I2
  905 FORMAT(5H0ROWS,I4,3H TO,I4)
C
      DO 16 I=I1,I2
      JI=0
      IF(JJ.GT.II) GOTO 12
      J1=I
      IF=I-I1+1
      IFORM(1)=IG(IF)
   12 DO 14 J=J1,J2
      JI=JI+1
      IJ=J*(J-1)/2+I
   14 BUFF(JI)=ELPA(IJ)
      WRITE(IWT,IFORM)(BUFF(K),K=1,JI)
   16 CONTINUE
C
   18 CONTINUE
C
   20 CONTINUE
C
CC 99 CONTINUE
      WRITE(IWT,910)(RHS(K),K=1,NDF)
  910 FORMAT(4H0RHS/(1X,10E12.4))
      RETURN
      END
      SUBROUTINE PRINTI(IW6,ELPA,MFZ,NDF,RHS,NRHS)
C***********************************************************************
C     PRINTS OUT UPPER TRIANGULAR MATRIX
C***********************************************************************
      CHARACTER*4 IG,IFORM
      DIMENSION RHS(NDF),BUFF(10),IFORM(4),IG(10),ELPA(MFZ)
      DATA IFORM(2),IFORM(3),IFORM(4)/'X,10','E12.','4)  '/
      DATA IG(1),IG(2),IG(3),IG(4),IG(5),IG(6),IG(7),IG(8),IG(9),IG(10)/
     +'  (1',' (13',' (25',' (37',' (49',' (61',' (73',' (85',
     +' (97','(109'/
C
      WRITE(IW6,900)
  900 FORMAT(1X,17HELEMENT STIFFNESS)
      IF(NDF.EQ.0) RETURN
CC    GOTO 99
C
      NSUB=(NDF+9)/10
C
      DO 20 JJ=1,NSUB
      J2=10*JJ
      J1=J2-9
      IF(J2.GT.NDF)J2=NDF
      WRITE(IW6,904) J1,J2
  904 FORMAT(8H0COLUMNS,I4,3H TO,I4)
      DO 18 II=1,JJ
      IFORM(1)=IG(1)
      I2=10*II
      I1=I2-9
      IF(I2.GT.NDF)I2=NDF
      WRITE(IW6,905)I1,I2
  905 FORMAT(5H0ROWS,I4,3H TO,I4)
C
      DO 16 I=I1,I2
      JI=0
      IF(JJ.GT.II) GOTO 12
      J1=I
      IF=I-I1+1
      IFORM(1)=IG(IF)
   12 DO 14 J=J1,J2
      JI=JI+1
      IJ=J*(J-1)/2+I
   14 BUFF(JI)=ELPA(IJ)
      WRITE(IW6,IFORM)(BUFF(K),K=1,JI)
   16 CONTINUE
C
   18 CONTINUE
C
   20 CONTINUE
C
CC 99 CONTINUE
      WRITE(IW6,910)(RHS(K),K=1,NRHS)
  910 FORMAT(1X,1HP/(1X,10E12.4))
      RETURN
      END
      SUBROUTINE PRNTSM(NDIM,INCNO,ICCSM)
C
C***********************************************************************
C
C     PRINT OUT SUMMARY TABLE OF
C     CAM CLAY BEHAVIOUR AND EQUILIBRIUM CHECK.
C
C***********************************************************************
C
      COMMON /EQBM/ RMAX(6),TER(3),IW16
C
      DIMENSION ICCSM(20)
C
      IF(NDIM.EQ.2) THEN
         WRITE(IW16,900)INCNO,(TER(ID),ID=1,NDIM),(ICCSM(II),II=1,20)
  900    FORMAT(I4,2F9.3,20I5)
      ELSE IF(NDIM.EQ.3) THEN
         WRITE(IW16,910)INCNO,(TER(ID),ID=1,NDIM),(ICCSM(II),II=1,20)
  910    FORMAT(I4,3F9.3,20I5)
      ENDIF
C
      RETURN
      END
      SUBROUTINE RDINT(NPAR,N)
C***********************************************************************
C     ROUTINE TO READ A SET OF N INTEGER NUMBERS
C***********************************************************************
      DIMENSION NPAR(N)
      COMMON /FF/ AR(40),NCARD,NERR,JERR,LUN
C
      NT=N
      MNPC=10
      IC=0
   10 IF(NT.LT.MNPC)MNPC=NT
      CALL FFIN(MNPC,1023)
C
      DO 20 IK=1,MNPC
      IC=IC+1
   20 NPAR(IC)=IFIX(AR(IK))
      NT=NT-MNPC
      IF(NT.NE.0)GO TO 10
      NT=IC
      RETURN
      END
      SUBROUTINE RDN(N,A,M)
C***********************************************************************
C     READ ONE DIMENSIONAL ARRAY
C***********************************************************************
      DIMENSION A(M)
      READ(N) A
      RETURN
      END
      SUBROUTINE RDREL(PAR,N)
C***********************************************************************
C     ROUTINE TO READ A SET OF N REAL NUMBERS
C***********************************************************************
      DIMENSION PAR(N)
      COMMON /FF/ AR(40),NCARD,NERR,JERR,LUN
C
      NT=N
      MNPC=10
      IC=0
   10 IF(NT.LT.MNPC)MNPC=NT
      CALL FFIN(MNPC,0)
C
      DO 20 IK=1,MNPC
      IC=IC+1
   20 PAR(IC)=AR(IK)
      NT=NT-MNPC
      IF(NT.NE.0)GO TO 10
      NT=IC
      RETURN
      END
      SUBROUTINE REACT(IW6,NN,MXDF,NDF,NDIM,NNZ,NQ,KGVN,NREL,
     +                 PEQT,REAC,PT,IDFX)
C***********************************************************************
C     CALCULATES REACTION TO EARTH AT RESTRAINED NODES
C***********************************************************************
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      DIMENSION PEQT(NDF),PT(NDF),KGVN(MXDF,NN),NQ(NN),REAC(NDF),
     +          IDFX(NDF),NREL(NNZ)
      DIMENSION R(500),NDENO(500),NDIR(500)
C
C *** NCT - SIZE OF ARRAYS R, NDENO AND NDIR
      NCT=500
C *** ICT - COUNTER OF TOTAL NO. OF REACTIONS
      ICT=0
C
      CALL ZEROR1(REAC,NDF)
C
      IF(IRAC.EQ.0)RETURN
C
      DO 25 JR=1,NNZ
      IF(NREL(JR).EQ.0)GOTO 25
      J=NREL(JR)
      NQL=NQ(J)
C *** SKIP IF NODE HAS PORE PRESSURE D.O.F. ONLY
      IF(NQL.LE.1)GOTO 25
      N1=KGVN(1,J)
      N2=N1+NDIM-1
      IDF=0
      DO 20 KN=N1,N2
      IDF=IDF+1
      IF(IDFX(KN).NE.1)GOTO 20
      ICT=ICT+1
      IF(ICT.GT.NCT)GOTO 20
      R(ICT)=-(PEQT(KN)-PT(KN))
      NDENO(ICT)=JR
      NDIR(ICT)=IDF
      REAC(KN)=R(ICT)
   20 CONTINUE
   25 CONTINUE
C
      IF(ICT.LE.NCT) THEN
         WRITE(IW6,901)
         WRITE(IW6,903)(NDENO(JCT),NDIR(JCT),R(JCT),JCT=1,ICT)
         RETURN
      ELSE
         WRITE(IW6,906)NCT
         STOP
      ENDIF
  901 FORMAT(//1X,18H LIST OF REACTIONS/2X,17(1H-)/
     + 2X,3(4HNODE,4X,9HDIRECTION,7X,8HREACTION,11X)/)
  903 FORMAT(3(1X,I5,5X,I4,5X,E14.4,10X))
  906 FORMAT(/1X,44HINCREASE ARRAY SIZE OF R, NDENO AND NDIR  TO,I8
     + /1X,35HAND ALSO RESET NCT IN ROUTINE REACT)
      END
      SUBROUTINE RESTRN(NDF,MXDF,NDIM,KGVN,IDFX,NQ,NN)
C***********************************************************************
C     ROUTINE TO IDENTIFY ALL DISPLACEMENT BOUNDARY CONDITIONS
C     WHICH ARE SPECIFIED. ( SET IDFX = 1 FOR ALL DOF
C     WHICH ARE RESTRAINED.)
C***********************************************************************
      INTEGER TF
      DIMENSION KGVN(MXDF,NN),IDFX(NDF),NQ(NN)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
C
C *** LOOP ON ALL NODES WITH ONE OR MORE FIXITIES
C
      DO 10 J=1,NDF
   10 IDFX(J)=0
C
      IF(NF.EQ.0)RETURN
      DO 40 JN=1,NF
      NDE=MF(JN)
      NFS=KGVN(1,NDE)-1
C
C *** BY-PASS IF NODE HAS ONLY PORE-PRESSURE DOF
C
      JP=NQ(NDE)
      IF(JP.LT.NDIM)GO TO 40
C
      DO 20 JF=1,NDIM
      NCDE=TF(JF,JN)
      IF(NCDE.EQ.0)GO TO 20
      IDFX(NFS+JF)=1
   20 CONTINUE
   40 CONTINUE
      RETURN
      END
      SUBROUTINE ROTAT(ELCOD,NDIM,NDN,AL,T)
C
C***********************************************************************
C     TRANFORMS SYSTEM CO-ORDINATES TO LOCAL CO-RDINATES
C     LAST MODIFIED ON 6 MAR 93
C***********************************************************************
C
      DIMENSION ELCOD(NDIM,NDN),T(3,3),COD(2,3)
C
      DO 10 I=1,2
      DO 10 J=1,NDN
   10 COD(I,J)=ELCOD(I,J)
C
      C=COD(1,2)-COD(1,1)
      S=COD(2,2)-COD(2,1)
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
C
      DO 20 J=1,3
      DO 20 I=1,3
   20 T(I,J)=0.
C
      T(1,1)=C
      T(1,2)=-S
      T(2,1)=S
      T(2,2)=C
      T(3,3)=1.
C
      DO 30 IN=1,NDN
      ELCOD(1,IN)=COD(1,IN)*C+COD(2,IN)*S
   30 ELCOD(2,IN)=-COD(1,IN)*S+COD(2,IN)*C
      RETURN
      END
      SUBROUTINE SCOCAM(IP,MR,KM,ICS,INGP,IEL,NIP,NEL,NCODE,VARC,NCV,PR,
     +                  NTY,P,Q,PCO,PYE,U,EV,EE,PC,ED,LED,NPR,NMT,
     +                  SGNQ,ICCSM)
C
C***********************************************************************
C                                                                      *
C *** ROUTINE TO DETERMINE STRESS STATE FOR SCHOFIELD SOIL MODEL       *
C *** THIS ROUTINE DETERMINES THE CURRENT STRESS STATE AT THE          *
C *** END OF THE CURRENT INCREMENT AND USES IST TO INDICATE THE        *
C *** STRESS STATE OF THE INTEGRATION POINT WITH REFERENCE             *
C *** TO THE CURRENT YIELD LOCUS                                       *
C                                                                      *
C *** TYPE  CODE FOR STRESS STATES                     IST             *
C ***  0    SOIL IS ELASTIC   WITH P>PCS AND Q<M*P    - 0              *
C ***  1    SOIL IS ELASTIC   WITH P<PCS AND Q<M*P    - 1              *
C ***  2    SOIL IS ELASTIC   WITH P<PCS AND Q>M*P    - 2              *
C ***  3    SOIL IS HARDENING WITH P>PCS AND Q<M*P    - 3              *
C ***  5    SOIL IS SOFTENING WITH P<PCS AND Q>M*P    - 5              *
C ***  7    SOIL IS HARDENING WITH P>PCS AND Q>M*P    - 7              *
C ***  8    SOIL IS HARDENING WITH P<PCS AND Q>M*P    - 8              *
C                                                                      *
C *** WHERE    P - EFFECTIVE MEAN NORMAL STRESS                        *
C ***        PCS - CRITICAL STATE VALUE OF P                           *
C *** TYPES 7 AND 8 ARE IMPERMISSIBLE AND ARISE FROM NUMERICAL         *
C *** PROBLEMS.                                                        *
C***********************************************************************
C     ROUTINE LAST MODIFIED ON 2/1/87
C
      DIMENSION PR(NPR,NMT),VARC(NCV,NIP,NEL),NCODE(NIP,NEL),
     +          NTY(NMT),ED(LED),ICCSM(20)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
      DATA FCAM/2.7182818/
C
      EO=PR(3,KM)
      H=PR(11,KM)
      ALAM=PR(2,KM)
      AKAP=PR(1,KM)
      RAT=PR(1,KM)/PR(2,KM)
      SLT=PR(12,KM)
      AMU=PR(4,KM)
      PUO=PCO/2.7182818
      PA=PR(14,KM)*PUO
C
C *** DETERMINE CURRENT STRESS REGION
C
      IF(P.GT.PUO)GO TO 30
CC    IOCR=1
      QB=SLT*P
      IF(Q.LT.0.999*QB)GO TO 12
      IF(P.GT.PA)GO TO 12
      IF(P.LT.0.)GO TO 10
C *** TENSILE CRACKS
      PY=EXP(((EO-EV)-AKAP*ALOG(P))/(ALAM-AKAP))*FCAM
      PC=PY
      EE=EV
      IST=6
      GO TO 152
C *** P IS NEGATIVE
   10 PC=PCO
      PY=1.E30
      INGP=1
      IST=9
      WRITE(IW6,900)MR,IP,P,KM
      WRITE(IW15,900)MR,IP,P,KM
      WRITE(IWS,900)MR,IP,P,KM
  900 FORMAT(1X,' *** ELEMENT ',I5,4X,'INT. PT',I5,4X,
     +          'PE IS NEGATIVE',E16.5,4X,'MAT ZONE NUMBER',I5/
     +          1X,'(ROUTINE SCOCAM)')
      P=1.
      IF(P.GT.0.1*PC)PE=0.1*PC
      GO TO 152
C *** DRY SIDE - ELASTIC OR HVORSLEV YIELDING
   12 FN=(EO-EV)-AKAP*ALOG(P)
      PU=EXP(FN/(ALAM-AKAP))
      PY=PU*FCAM
      QA=(AMU-H)*PU*(P/PU)**RAT+H*P
      IF(Q.GT.0.999*QA)GO TO 25
C
      PY=P*EXP(Q/(AMU*P))
      IF(PYE.LT.0.)GO TO 16
      IF(PY.GT.PCO)GO TO 18
C *** DRY OF CRITICAL - ELASTIC
      QC=AMU*P
      IST=1
      IF(Q.GT.QC)IST=2
      PC=PCO
      GO TO 150
C
   16 IF(PY.GT.PCO)GO TO 20
C *** CHECK PROXIMITY TO CRITICAL STATE
      ETAOM=Q/(AMU*P)
      IF(ABS(ETAOM-1.).LT.0.01)GO TO 22
      IST=11
      PC=PY
      GO TO 150
C
   18 PC=PY
      IST=12
      GO TO 150
C
   20 PC=PY
      IST=18
      GO TO 150
C
   22 IST=10
      ICS=1
      GO TO 150
C *** HVORSLEV YIELD
   25 ETAOM=Q/(AMU*P)
      IF(ABS(ETAOM-1.).LT.0.01)GO TO 28
      PC=PY
      IST=5
      GO TO 150
C *** APPROACHING CRITICAL STATE
C *** CAM-CLAY REGION
   28 PY=P*EXP(Q/(AMU*P))
      PC=PY
      IST=5
      GO TO 150
   30 PY=P*EXP(Q/(AMU*P))
      IF(PY.GT.PCO)GO TO 36
C *** ELASTIC - REGION 0
      PC=PCO
      IST=0
      GO TO 150
C *** HARDENING - REGION 3 OR 7
   36 ETAOM=Q/(AMU*P)
      IF(ETAOM.GT.1.001)GO TO 42
C *** HARDENING - REGION 3
      PC=PY
      IST=3
      GO TO 150
C *** REGION 7
   42 PC=PCO
      IST=7
      GO TO 150
C *** CALCULATE VOIDS RATIO FROM E - LOG(P) RELATIONSHIP
  150 ETAOM=Q/(AMU*P)
      IF(ABS(ETAOM-1.).LT.0.05.AND.PYE.LT.0.)ICS=1
      EE=EO-AKAP*ALOG(P)-(ALAM-AKAP)*ALOG(PC/FCAM)
C *** STORE CAM-CLAY PARAMETERS
  152 VARC(1,IP,IEL)=P
      VARC(2,IP,IEL)=Q
      VARC(3,IP,IEL)=P+U
      VARC(4,IP,IEL)=PC
      VARC(5,IP,IEL)=SGNQ*Q/P
      VARC(6,IP,IEL)=Q/(AMU*P)
      VARC(7,IP,IEL)=PY/PCO
      VARC(8,IP,IEL)=EE
      VARC(9,IP,IEL)=EV
      NCODE(IP,IEL)=IST
C
      KGO=NTY(KM)
      CALL CCSTRS(IST,PY,PCO,ICS,KGO,ICCSM)
C
      RETURN
      END
      SUBROUTINE SELF(IW6,I,NN,NEL,NTPE,NDN,NDIM,NAC,NPR,NMT,XYZ,PR,
     + ELCOD,SHFN,DS,F,NCORR,MAT,LL,LT,INDX,DENS,MUS,KSTGE)
C***********************************************************************
C      CALCULATES SELF WEIGHT LOADS
C***********************************************************************
      REAL L,LL
      DIMENSION NCORR(NTPE,NEL),MAT(NEL)
      DIMENSION XYZ(NDIM,NN),PR(NPR,NMT),GCOM(3)
      DIMENSION ELCOD(NDIM,NDN),SHFN(NDN),DS(NDIM,NDN),
     + F(NDIM,NDN),LL(NAC)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /FLOW  / NPLAX
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C
      TPI=2.*PYI
      NGP=LINFO(11,LT)
      K=MAT(I)
C *** INITIALISE ARRAY F
      CALL ZEROR2(F,NDIM,NDN)
C
      IF(DENS.LE.ASMVL)GO TO 100
      THETA=ZERO
      GCOM(1)= DENS*SIN(THETA)
      GCOM(2)=-DENS*COS(THETA)
      GCOM(3)=ZERO
C
C *** SET UP LOCAL ARRAY FOR CO-ORDINATES
      DO 10 KC=1,NDN
      NDE=NCORR(KC,I)
      DO 10 ID=1,NDIM
   10 ELCOD(ID,KC)=XYZ(ID,NDE)
CC    WRITE(IW6,801)I,ELCOD
CC801 FORMAT(/1X,9HELEMENT =,I5/1X,5HELCOD/(6F10.3))
C
C *** LOOP FOR NUMERICAL INTEGRATION
      DO 60 IP=1,NGP
      IPA=IP+INDX
      DO 35 IL=1,NAC
   35 LL(IL)=L(IL,IPA)
CC    WRITE(IW6,802)IP,LL
CC802 FORMAT(/1X,4HIP =,I5,4X,2HLL,4X,4F12.5)
C
C *** EVALUATE SHAPE FUNCTION FOR INTEGRATION POINT
      CALL SHAPE(IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,2)
CC    WRITE(IW6,805)SHFN
CC805 FORMAT(/1X,4HSHFN/(1X,10E13.5))
CC    WRITE(IW6,810)DS
CC810 FORMAT(/1X,2HDS/(1X,12E11.3))
      CALL DETJCB(IW6,DJACB,NDN,NDIM,ELCOD,DS,LT,IP,MUS,KSTGE)
CC    WRITE(IW6,900)I,IP,DJACB
CC900 FORMAT(1X,2I5,E16.5)
      DV=DJACB*W(IPA)
      IF(NPLAX.EQ.0)GO TO 45
C
      RAD=0.0
      DO 40 IN=1,NDN
   40 RAD=RAD+ELCOD(1,IN)*SHFN(IN)
      DV=DV*TPI*RAD
C
   45 DO 50 IN=1,NDN
      DO 50 ID=1,NDIM
   50 F(ID,IN)=F(ID,IN)+GCOM(ID)*SHFN(IN)*DV
   60 CONTINUE
  100 CONTINUE
      RETURN
      END
      SUBROUTINE SELF2(IW6,I,NN,NEL,NTPE,NDN,NDIM,NPR,NMT,XYZ,PR,
     +                 ELCOD,SHFN,F,NCORR,MAT,LT,INDX,DENS,MUS,KSTGE)
C
C***********************************************************************
C     ROUTINE TO CALCULATE SELF-WEIGHT LOADS FOR INTERFACE ELEMENT
C     LT = 13.
C***********************************************************************
C
      REAL L
      DIMENSION NCORR(NTPE,NEL),MAT(NEL)
      DIMENSION XYZ(NDIM,NN),PR(NPR,NMT),GCOM(3)
      DIMENSION ELCOD(NDIM,NDN),SHFN(NDN),F(NDIM,NDN)
      DIMENSION T(3,3),SHF(3),DER(3),COD(2,3)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /FLOW  / NPLAX
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      TPI=2.*PYI
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      KM=MAT(I)
      THICK=PR(6,KM)
C *** INITIALISE ARRAY F
      CALL ZEROR2(F,NDIM,NDN)
C
      IF(DENS.LE.ASMVL)GO TO 500
      THETA=ZERO
      GCOM(1)= DENS*SIN(THETA)
      GCOM(2)=-DENS*COS(THETA)
      GCOM(3)=ZERO
C
C *** SET UP LOCAL ARRAY FOR CO-ORDINATES
      DO 10 KC=1,NDN
      NDE=NCORR(KC,I)
      DO 10 ID=1,NDIM
   10 ELCOD(ID,KC)=XYZ(ID,NDE)
CC    WRITE(IW6,801)MUS,ELCOD
CC801 FORMAT(/1X,9HELEMENT =,I5/1X,5HELCOD/(6F10.3))
C
      DO 20 J=1,3
      DO 20 K=1,3
   20 T(K,J)=ZERO
      T(3,3)=1.
C
      C=(ELCOD(1,2)+ELCOD(1,3))*0.5-(ELCOD(1,1)+ELCOD(1,4))*0.5
      S=(ELCOD(2,2)+ELCOD(2,3))*0.5-(ELCOD(2,1)+ELCOD(2,4))*0.5
      AL=SQRT(C*C+S*S)
      C=C/AL
      S=S/AL
      BL=AL
C
      COD(1,1)=ELCOD(1,1)
      COD(2,1)=ELCOD(2,1)
      COD(1,2)=ELCOD(1,2)
      COD(2,2)=ELCOD(2,2)
      COD(1,3)=ELCOD(1,5)
      COD(2,3)=ELCOD(2,5)
C
      CALL ROTAT(COD,NDIM,3,DL,T)
C
C----------LOOP ON INTEGRATION POINTS
      DO 200 IP=1,NGP
      IPA=IP+INDX
      XI=L(1,IPA)
C
      SHF(1)=XI*(XI-1.)/2.
      SHF(2)=XI*(XI+1.)/2.
      SHF(3)=(1.+XI)*(1.-XI)
C
      DER(1)=(2.*XI-1.)/2.
      DER(2)=(2.*XI+1.)/2.
      DER(3)=-2.*XI
C----------CALCULATE DETERMINANT OF JACOBIAN
      DJACB=ZERO
      DO 30 IN=1,3
   30 DJACB=DJACB+DER(IN)*COD(1,IN)
      IF(ABS(DJACB).LT.ASMVL)THEN
         WRITE(IW6,910)MUS,IP,DJACB
         WRITE(IW15,910)MUS,IP,DJACB
         WRITE(IWS,910)MUS,IP,DJACB
  910    FORMAT(/1X,'****ERROR - JACOBIAN OF ELEMENT',I5,2X,
     +           'INT. POINT',I4,2X,'LE ZERO',3X,'DJACB =',E16.5/
     +           1X,'(ROUTINE SELF2)')
         WRITE(IW6,920)KSTGE
         WRITE(IW15,920)KSTGE
         WRITE(IWS,920)KSTGE
  920    FORMAT(/1X,36HCODE TO INDICATE STAGE OF ANALYSIS =,I5/
     +   4X,4HCODE,20X,21HSTAGE OF THE ANALYSIS//
     +   6X,46H1 - CALLED BY MSUB3/EQLOD/SELF2 CALCULATION OF,
     +   1X,25HIN SITU SELF WEIGHT LOADS/6X,13H2 - CALLED BY,
     +   1X,45HMSG/CHANGE/SELF2 LOADS DUE TO ELEMENT CHANGES/
     +   6X,45H3 - CALLED BY MSG/SEL1/SELF2 INCREMENTAL SELF,
     +   1X,12HWEIGHT LOADS/6X,25H4 - CALLED BY UPOUT/EQLOD,
     +   46H/SELF2 SELF WEIGHT LOADS FOR EQUILIBRIUM CHECK)
         STOP
      ENDIF
C
      DV=0.5*DJACB*W(IPA)*THICK
C
      SHFN(1)=SHF(1)
      SHFN(2)=SHF(2)
      SHFN(3)=SHF(2)
      SHFN(4)=SHF(1)
      SHFN(5)=SHF(3)
      SHFN(6)=ZERO
      SHFN(7)=SHF(3)
      SHFN(8)=ZERO
      IF(NPLAX.EQ.0)GO TO 45
C
      RAD=0.0
      DO 40 JN=1,3
   40 RAD=RAD+ELCOD(1,JN)*SHF(JN)
      DV=DV*TPI*RAD
C
   45 DO 50 IN=1,NDN
      DO 50 ID=1,NDIM
   50 F(ID,IN)=F(ID,IN)+GCOM(ID)*SHFN(IN)*DV
  200 CONTINUE
CC    WRITE(IW6,850)I,((F(II,JJ),JJ=1,8),II=1,2)
CC850 FORMAT(/1X,'ELEMENT ******  ',I5/(1X,8E16.5))
C
  500 CONTINUE
      RETURN
      END
      SUBROUTINE SEL1(IW6,ICHEL,NN,MXDF,NTPE,NIP,NEL,NDF,
     + MUMAX,NL,NDIM,NDMX,NPR,NMT,XYZ,P,ELCOD,SHFN,
     + DS,F,LL,NCORR,JEL,LTYP,MAT,MREL,MRELVV,KGVN,NTY,PR,DGRAV)
C***********************************************************************
C     CALCULATES  SELF-WEIGHT  LOAD  VECTOR
C     LAST MODIFED ON 1/6/88
C***********************************************************************
      REAL LL
      DIMENSION XYZ(NDIM,NN),P(NDF),MREL(MUMAX),MRELVV(NEL)
      DIMENSION NCORR(NTPE,NEL),JEL(NEL),LTYP(NEL),MAT(NEL),
     + KGVN(MXDF,NN)
      DIMENSION PR(NPR,NMT),F(NDIM,NDMX),DS(NDIM,NDMX),LL(NL),
     + ELCOD(NDIM,NDMX),SHFN(NDMX),NTY(NMT)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C--------CODE TO INDICATE STAGE OF THE ANALYSIS
      KSTGE=3
C
C *** LOOP  ON  ALL  ELEMENTS
C
      DO 50 J=1,NEL
      JK=MRELVV(J)
      LT=LTYP(J)
      IF(LT.LT.0)GO TO 50
      GOTO(50,22,22,22,22,22,22,22,22,50,50,50,22,50,50),LT
   22 INDX=LINFO(12,LT)
      NDN=LINFO(5,LT)
      NAC=LINFO(15,LT)
      K=MAT(J)
      DENS=DGRAV*PR(8,K)
      IF(DENS.LE.ASMVL)GO TO 50
      IF(LT.EQ.13) THEN
         CALL SELF2(IW6,J,NN,NEL,NTPE,NDN,NDIM,NPR,NMT,XYZ,PR,
     +              ELCOD,SHFN,F,NCORR,MAT,LT,INDX,DENS,JK,KSTGE)
      ELSE
         CALL SELF(IW6,J,NN,NEL,NTPE,NDN,NDIM,NAC,NPR,NMT,XYZ,PR,
     +             ELCOD,SHFN,DS,F,NCORR,MAT,LL,LT,INDX,DENS,JK,KSTGE)
      ENDIF
C
      DO 30 JJ=1,NDN
      JN=NCORR(JJ,J)
      JL=KGVN(1,JN)-1
      DO 30 ID=1,NDIM
   30 P(JL+ID)=P(JL+ID)+F(ID,JJ)
   50 CONTINUE
      RETURN
      END
      SUBROUTINE SETNP(NP1,NP2,NPL)
C***********************************************************************
C     SET UP ARRAYS NP1 AND NP2 WHICH GIVE THE INDEX TO ARRAY
C     NCORR FOR NODES AT EITHER END OF EACH ELEMENT EDGE
C***********************************************************************
      DIMENSION NPL1(21),NPL2(21),NP1(NPL),NP2(NPL)
C-----------------------------------------------------------------------
C              INDEXES OF ARRAYS NPL1,NPL2,NP1,NP2
C           INDEX            ELEMENT TYPE
C           1 -  3            1, 2, 3, 6, 7, 12
C           4 -  7            4, 5, 13
C           4 - 15            8, 9
C          16 - 21           10, 11
C-----------------------------------------------------------------------
      DATA NPL1(1),NPL1(2),NPL1(3),NPL1(4),NPL1(5),NPL1(6),NPL1(7),
     + NPL1(8),NPL1(9),NPL1(10),NPL1(11),NPL1(12),NPL1(13),NPL1(14),
     + NPL1(15),NPL1(16),NPL1(17),NPL1(18),NPL1(19),NPL1(20),NPL1(21)/
     + 1,2,3,1,2,3,4,5,6,7,8,1,2,3,4,1,2,3,1,2,3/
      DATA NPL2(1),NPL2(2),NPL2(3),NPL2(4),NPL2(5),NPL2(6),NPL2(7),
     + NPL2(8),NPL2(9),NPL2(10),NPL2(11),NPL2(12),NPL2(13),NPL2(14),
     + NPL2(15),NPL2(16),NPL2(17),NPL2(18),NPL2(19),NPL2(20),NPL2(21)/
     + 2,3,1,2,3,4,1,6,7,8,5,5,6,7,8,2,3,1,4,4,4/
C
      DO 10 I=1,NPL
      NP1(I)=NPL1(I)
   10 NP2(I)=NPL2(I)
C
      RETURN
      END
      SUBROUTINE SETUP(
CT    SUBROUTINE SETUP(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,
CT   + NVRN,NDIM,MUMAX,NDZ,IFRZ,NNZ,NDMX,NPMX,
CT   + NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
     + INXL,MXEN,MXLD,MXFXT,LV,LL,MCORE,NVTX,ND,MDZ,NEDZ,KSS,
     + XYZ,DI,DA,VARINT,P,PT,PIB,REAC,PCOR,PEQT,XYFT,XYFIB,
     + STR,PEXIB,PEXI,PCONI,D,ELCOD,DS,SHFN,CARTD,B,DB,FT,SS,ES,
     + E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     + JEL,IDFX,NDEST,NP1,NP2,IFR,NDL,NWL,NMOD,KDF,
     + CIP,V,FXYZ,PR,PDISLD,PRES,NTY,A,MFZ,KK,LKK,KLT,LTZ,ICTL)
C***********************************************************************
C     MAIN CONTROLLING ROUTINE
C     Calls to MSUB2 and MSUB3 interchanged to allow In situ VARINT
C     to be written to the NRS file.
C     LAST MODIFIED ON 28 AUGUST 92
C***********************************************************************
      CHARACTER*1 TITLE
      REAL L,LL
      INTEGER TF
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),VARINT(NVRS,NIP,NEL),
     + P(NDF),PT(NDF),PIB(NDF),REAC(NDF),PCOR(NDF),PEQT(NDF),XYFT(NDF),
     + XYFIB(NDF),STR(NVRN,NIP,NEL),PEXIB(NDF),PEXI(NDF),PCONI(NDF)
      DIMENSION D(NS,NS),ELCOD(NDIM,NDMX),DS(NDIM,NDMX),SHFN(NDMX),
     + CARTD(NDIM,NDMX),B(NS,NB),DB(NS,NB),FT(NDIM,NDMX),
     + SS(KSS),ES(KES),LL(NL),KLT(LTZ)
      DIMENSION E(NDIM,NPMX),PE(NDIM,NPMX),PORINS(NN),
     + RN(NB),AA(NPMX),ETE(NPMX,NPMX),RLT(NB,NPMX),CARTP(NDIM,NPMX)
      DIMENSION NCORR(NTPE,NEL),MAT(NEL),LTYP(NEL),MRELVV(NEL),
     + MREL(MUMAX),NRELVV(NN),NREL(NNZ),KGVN(MXDF,NN),NQ(NN),JEL(NEL),
     + IDFX(NDF),NDEST(NN),NP1(NPL),NP2(NPL),KDF(MXDF,NN)
      DIMENSION IFR(IFRZ),NDL(MDFE),NWL(NPMX),NMOD(NIP,NEL)
      DIMENSION CIP(NDIM),V(LV),FXYZ(NDIM),PR(NPR,NMT),
     + PDISLD(NDIM,LV),PRES(NDIM,LV),NTY(NMT),A(MFZ),KK(LKK)
      DIMENSION INCLST(10)
      COMMON /LABEL / TITLE(80)
      COMMON /FLOW  / NPLAX
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /DIN   / DEL(3),DEP(21)
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /PRLDI / PRSLDI(10,400),LEDI(400),NDI1(400),NDI2(400),ILOD
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /MP92/NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
     + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN
CT   + INXL,MXEN,MXLD,MXFXT,LV,LL,MCORE,NVTX,ND,MDZ,NEDZ,KSS
C-----------------------------------------------------------------------
C     INITIALISE ALL ARRAYS
C-----------------------------------------------------------------------
      CALL ZEROR2(XYZ,NDIM,NN)
      CALL ZEROR1(DI,NDF)
      CALL ZEROR1(DA,NDF)
      CALL ZEROR3(VARINT,NVRS,NIP,NEL)
      CALL ZEROR1(P,NDF)
      CALL ZEROR1(PT,NDF)
      CALL ZEROR1(PIB,NDF)
      CALL ZEROR1(REAC,NDF)
      CALL ZEROR1(PCOR,NDF)
      CALL ZEROR1(PEQT,NDF)
      CALL ZEROR1(XYFT,NDF)
      CALL ZEROR1(XYFIB,NDF)
      CALL ZEROR3(STR,NVRN,NIP,NEL)
      CALL ZEROR1(PEXIB,NDF)
      CALL ZEROR1(PEXI,NDF)
      CALL ZEROR1(PCONI,NDF)
      CALL ZEROR2(D,NS,NS)
      CALL ZEROR2(ELCOD,NDIM,NDMX)
      CALL ZEROR2(DS,NDIM,NDMX)
      CALL ZEROR1(SHFN,NDMX)
      CALL ZEROR2(CARTD,NDIM,NDMX)
      CALL ZEROR2(B,NS,NB)
      CALL ZEROR2(DB,NS,NB)
      CALL ZEROR2(FT,NDIM,NDMX)
      CALL ZEROR1(SS,KSS)
      CALL ZEROR1(ES,KES)
      CALL ZEROR1(LL,NL)
      CALL ZEROR2(E,NDIM,NPMX)
      CALL ZEROR2(PE,NDIM,NPMX)
      CALL ZEROR1(RN,NB)
      CALL ZEROR1(AA,NPMX)
      CALL ZEROR2(ETE,NPMX,NPMX)
      CALL ZEROR2(RLT,NB,NPMX)
      CALL ZEROR2(CARTP,NDIM,NPMX)
      CALL ZEROR1(PORINS,NN)
      CALL ZEROR1(A,MFZ)
C
      CALL ZEROI2(NCORR,NTPE,NEL)
      CALL ZEROI1(MAT,NEL)
      CALL ZEROI1(LTYP,NEL)
      CALL ZEROI1(MRELVV,NEL)
      CALL ZEROI1(MREL,MUMAX)
      CALL ZEROI1(NRELVV,NEL)
      CALL ZEROI1(NREL,NNZ)
      CALL ZEROI2(KGVN,MXDF,NN)
      CALL ZEROI1(NQ,NN)
      CALL ZEROI1(JEL,NEL)
      CALL ZEROI1(IDFX,NDF)
      CALL ZEROI1(NDEST,NN)
      CALL ZEROI1(NP1,NPL)
      CALL ZEROI1(NP2,NPL)
      CALL ZEROI1(IFR,IFRZ)
      CALL ZEROI1(NDL,MDFE)
      CALL ZEROI1(NWL,NPMX)
      CALL ZEROI2(NMOD,NIP,NEL)
      CALL ZEROI2(KDF,MXDF,NN)
      CALL ZEROR1(CIP,NDIM)
      CALL ZEROR1(V,LV)
      CALL ZEROR1(FXYZ,NDIM)
      CALL ZEROR2(PR,NPR,NMT)
      CALL ZEROR2(PDISLD,NDIM,LV)
      CALL ZEROR2(PRES,NDIM,LV)
      CALL ZEROI1(NTY,NMT)
C-----------------------------------------------------------------------
C     READ  GEOMETRY  DATA  FROM  LINK  FILE
C-----------------------------------------------------------------------
      READ(IR4,ERR=100,END=150) ((XYZ(ID,IN),ID=1,NDIM),IN=1,NN)
      READ(IR4,ERR=100,END=150) ((NCORR(I,J),I=1,NTPE),J=1,NEL)
      READ(IR4,ERR=100,END=150) (MAT(J),J=1,NEL)
      READ(IR4,ERR=100,END=150) (NREL(I),I=1,NNZ)
      READ(IR4,ERR=100,END=150) (MREL(I),I=1,MUMAX)
      READ(IR4,ERR=100,END=150) (NRELVV(I),I=1,NN)
      READ(IR4,ERR=100,END=150) (MRELVV(I),I=1,NEL)
      READ(IR4,ERR=100,END=150) (LTYP(J),J=1,NEL)
      READ(IR4,ERR=100,END=150) ((KGVN(I,J),I=1,MXDF),J=1,NN)
C
CC    WRITE(6,890)KGVN
CC890 FORMAT(/1X,20HROUTINE SETUP - KGVN/(20I5))
      TTIME=ZERO
      IDCHK=0
C-----------------------------------------------------------------------
C     SET UP ARRAYS NP1 AND NP2 WHICH GIVE THE INDEXES TO
C     ARRAY NCORR FOR NODES AT EITHER END OF ELEMENT EDGES
C-----------------------------------------------------------------------
      CALL SETNP(NP1,NP2,NPL)
C
CC    WRITE(IW6,918)
C
      WRITE(IW6,801)NN,NEL,NDF,MXDF,NTPE,NIP,NVRS
      WRITE(IW6,802)NDIM,MUMAX,NDZ,IFRZ,NNZ,NDMX,NPMX
      WRITE(IW6,803)NS,NB,NL,NPR,NMT,NPT,NSP
      WRITE(IW6,804)NPL,MDFE,KES,NVPN,INXL,MXEN,MXLD
      WRITE(IW6,805)MXFXT,LV,MCORE,NVTX,ND
C
  801 FORMAT(/1X,8HNN    = ,I6,3X,8HNEL   = ,I6,3X,8HNDF   = ,I6,
     + 3X,8HMXDF  = ,I6,3X,8HNTPE  = ,I6,3X,8HNIP   = ,I6,
     + 3X,8HNVRS  = ,I6)
C
  802 FORMAT(/1X,8HNDIM  = ,I6,3X,8HMUMAX = ,I6,3X,8HNDZ   = ,I6,
     + 3X,8HIFRZ  = ,I6,3X,8HNNZ   = ,I6,3X,8HNDMX  = ,I6,
     + 3X,8HNPMX  = ,I6)
C
  803 FORMAT(/1X,8HNS    = ,I6,3X,8HNB    = ,I6,3X,8HNL    = ,I6,
     + 3X,8HNPR   = ,I6,3X,8HNMT   = ,I6,3X,8HNPT   = ,I6,
     + 3X,8HNSP   = ,I6)
C
  804 FORMAT(/1X,8HNPL   = ,I6,3X,8HMDFE  = ,I6,3X,8HKES   = ,I6,
     + 3X,8HNVPN  = ,I6,3X,8HINXL  = ,I6,3X,8HMXEN  = ,I6,
     + 3X,8HMXLD  = ,I6)
C
  805 FORMAT(/1X,8HMXFXT = ,I6,3X,8HLV    = ,I6,3X,8HMCORE = ,I6,
     + 3X,8HNVTX  = ,I6,3X,8HND    = ,I6//1X,120(1H*))
C-----------------------------------------------------------------------
C     ROUTINE TO READ CONTROL OPTIONS AND MATERIAL PROPERTIES
C-----------------------------------------------------------------------
      MXP=10
      CALL MSUB1(NPR,NMT,NPLAX,NMAT,NOIB,INCS,INCF,INCT,
     + IPRIM,IUPD,ICOR,IBC,PR,NTY,NDIM,NINCP,INCLST,MXP)
CC    WRITE(IW6,918)
C--------CHNAGES MADE ON 23 APRIL 1990
      WRITE(IW14,800)NEL,NMAT,NPR,NIP,NDIM
  800 FORMAT(1X,10I8)
      WRITE(IW14,810)(NTY(IM),IM=1,NMAT)
  810 FORMAT(1X,20I5)
      DO 50 IM=1,NMAT
   50 WRITE(IW14,820)(PR(IPR,IM),IPR=1,NPR)
  820 FORMAT(1X,5E15.5)
      WRITE(IW14,830)(LTYP(IL),IL=1,NEL)
  830 FORMAT(1X,15I5)
      WRITE(IW14,840)(MAT(IL),IL=1,NEL)
  840 FORMAT(1X,15I5)
C-----------------------------------------------------------------------
C     SETUP IN SITU STRESSES AND CHECK FOR EQUILIBRIUM
C-----------------------------------------------------------------------
C=========WRITE HEADERS FOR CAM-CLAY SUMMARY TO UNIT 16
      CALL HEDSM(NDIM)
      IF(INCS.EQ.1)CALL MSUB3(NN,NEL,NDF,MXDF,NTPE,NIP,NDIM,NVRS,
     + MUMAX,NNZ,NDZ,NPL,NDMX,NS,NB,NL,LV,NPR,NMT,NPT,NSP,
     + XYZ,DA,P,PT,PEQT,XYFT,PCOR,VARINT,
     + PEXIB,PCONI,REAC,PORINS,NCORR,NQ,KGVN,JEL,MRELVV,MREL,NREL,LTYP,
     + MAT,NMOD,IDFX,KDF,NTY,PR,CIP,FT,LL,B,DS,ELCOD,CARTD,SHFN,
     + PRES,NP1,NP2,V,PDISLD,A,MFZ,INXL,MXEN,MXLD,MXFXT,TGRAV,IPRIM,
     + KLT,LTZ)
C-----------------------------------------------------------------------
C     STOP/RESTART FACILITY
C-----------------------------------------------------------------------
      CALL MSUB2(INCS,INCF,NN,NVTX,ND,NEL,NDF,NTPE,NIP,
     + NVRS,NVRN,MUMAX,NNZ,MXDF,NDIM,MDZ,NEDZ,NL,INXL,NPR,NMT,
     + NCORR,MAT,LTYP,NREL,MREL,NRELVV,MRELVV,KGVN,NMOD,NTY,
     + XYZ,VARINT,DA,STR,XYFT,PCOR,PCONI,REAC,PORINS,PR,
     + TTIME,TGRAV,NINCP,INCLST,MXP)
C-----------------------------------------------------------------------
C     MASTER CONTROL ROUTINE FOR SOLUTION
C-----------------------------------------------------------------------
      CALL CAMCDE(IW6)
C
      CALL MSG(
CX    CALL MSG(NN,NEL,NDF,MXDF,NTPE,NIP,NVRS,NVRN,NDIM,MUMAX,NDZ,
CX   + IFRZ,NNZ,NDMX,NPMX,NS,NB,NL,NPR,NMT,NPT,NSP,NPL,MDFE,KES,NVPN,
CX   + KES,NVPN,INXL,MXEN,MXLD,MXFXT,LV,NVTX,ND,KSS,
     + INXL,MXEN,MXLD,MXFXT,LV,NVTX,ND,KSS,
     + XYZ,DI,DA,VARINT,P,PT,PIB,REAC,PCOR,PEQT,XYFT,XYFIB,
     + STR,PEXIB,PEXI,PCONI,D,ELCOD,DS,SHFN,CARTD,
     + B,DB,FT,SS,ES,E,PE,RN,AA,ETE,RLT,CARTP,PORINS,
     + NCORR,MAT,LTYP,MRELVV,MREL,NRELVV,NREL,KGVN,NQ,
     + JEL,IDFX,NDEST,NP1,NP2,IFR,NDL,NWL,NMOD,KDF,CIP,LL,V,FXYZ,PR,
     + PDISLD,PRES,NTY,A,MFZ,NOIB,TTIME,TGRAV,
     + IUPD,ICOR,IBC,IDCHK,INCT,NINCP,INCLST,MXP,KK,LKK,KLT,LTZ,ICTL)
C
      RETURN
C-----------ERROR IN READING LINK FILE
  100 CONTINUE
      WRITE(IWS,960)
  960 FORMAT(//1X,'****** Error in reading the LINK file (*.LIK) ******'
     +        /1x,'****** Re-run Geometry program again.         ******'
     +        /)
      STOP
C-----------END OF LINK FILE HAS BEEN REACHED
  150 CONTINUE
      WRITE(IWS,970)
  970 FORMAT(//1X,'**** End of LINK file (*.LIK) has been reached. ****'
     +        /1X,'**** The LINK file (*.LIK) is incomplete.       ****'
     +        /1x,'****     Re-run Geometry program again.         ****'
     +        /)
      STOP
CC917 FORMAT(I5)
CC918 FORMAT(/1X,120(1H*))
      END
      SUBROUTINE SFRBM(S,SHF,DER,NDOF,DL)
C
C***********************************************************************
C     CALCULATES SHAPE FUNCTIONS AND DERIVATIVES
C***********************************************************************
C
      DIMENSION SHF(NDOF),DER(NDOF)
C
      S2=S*S
      S3=S2*S
      S4=S3*S
      S5=S4*S
C
      IF(NDOF.EQ.6) THEN
         SHF(1)=(1.-S)/2.
         SHF(2)=(S3-3.*S+2.)/4.
         SHF(3)=(S3-S2-S+1.)*DL/8.
         SHF(4)=(1.+S)/2.
         SHF(5)=(-S3+3.*S+2.)/4.
         SHF(6)=(S3+S2-S-1.)*DL/8.
         SHF(6)=-SHF(6)
C
         DER(1)=-0.5
         DER(2)=(3.*S2-3.)/4.
         DER(3)=(3.*S2-2.*S-1.)*DL/8.
         DER(4)= 0.5
         DER(5)=(-3.*S2+3.)/4.
         DER(6)=(3.*S2+2.*S-1.)*DL/8
         DER(6)=-DER(6)
                  
      ELSE IF(NDOF.EQ.9) THEN
C----------SHAPE FUNCTIONS
         SHF(1)=S*(S-1.)/2.
         SHF(2)=(3.*S5-2.*S4-5.*S3+4.*S2)/4.
         SHF(3)=(S5-S4-S3+S2)*DL/8.
         SHF(4)=S*(S+1.)/2.
         SHF(5)=(4.*S2+5.*S3-2.*S4-3.*S5)/4.
         SHF(6)=(S5+S4-S3-S2)*DL/8.
         SHF(7)=(1.+S)*(1.-S)
         SHF(8)=(S4-2.*S2+1.)
         SHF(9)=(S5-2.*S3+S)*DL/2.
C----------DERIVATIVES W.R.T. LOCAL COORDINATES
         DER(1)=(2.*S-1.)/2.
         DER(2)=(60.*S3-24.*S2-30.*S+8.)/4.
         DER(3)=(20.*S3-12.*S2-6.*S+2.)*DL/8.
         DER(4)=(2.*S+1.)/2.
         DER(5)=(8.+30.*S-24.*S2-60.*S3)/4.
         DER(6)=(20.*S3+12.*S2-6.*S-2.)*DL/8.
         DER(7)=-2.*S
         DER(8)=(12.*S2-4.)
         DER(9)=(20.*S3-12.*S)*DL/2.
      ENDIF
      RETURN
      END
      SUBROUTINE SFRBR(S,SHF,DER,NDOF,DL)
C
C***********************************************************************
C     CALCULATES SHAPE FUNCTIONS AND DERIVATIVES
C      FOR 2 & 3-NODED BAR ELEMENT (LT = 1, 14)
C***********************************************************************
C
      DIMENSION SHF(NDOF),DER(NDOF)
C
C----------SHAPE FUNCTIONS
      IF(NDOF.EQ.3) THEN
         SHF(1)=S*(S-1.)/2.
         SHF(2)=S*(S+1.)/2.
         SHF(3)=(1.+S)*(1.-S)
C----------DERIVATIVES W.R.T. LOCAL COORDINATES
         DER(1)=(2.*S-1.)/2.
         DER(2)=(2.*S+1.)/2.
         DER(3)=-2.*S
      ELSE IF(NDOF.EQ.2) THEN
         SHF(1)=(1.-S)/2.
         SHF(2)=(1.+S)/2.
C
         DER(1)=-0.5
         DER(2)= 0.5
      ENDIF
      RETURN
      END
      SUBROUTINE SFR1(S,SHF,DERIV,NSD)
C***********************************************************************
C     SHAPE FUNCTIONS AND DERIVATIVES FOR ONE-DIMENSIONAL              *
C     GAUSSIAN INTEGRATION ALONG ELEMENT EDGE                          *
C***********************************************************************
      DIMENSION SHF(NSD),DERIV(NSD)
C *** INITIALISE
      CALL ZEROR1(SHF,NSD)
      CALL ZEROR1(DERIV,NSD)
C
      GO TO(80,21,31,41,51),NSD
C *** 2 NODES ALONG EDGE
   21 CONTINUE
      GO TO 80
C *** 3 NODES ALONG EDGE
   31 CONTINUE
      SHF(1)=0.5*S*(S-1.)
      SHF(2)=(1.-S)*(1.+S)
      SHF(3)=0.5*S*(S+1.)
      DERIV(1)=S-0.5
      DERIV(2)=-2.*S
      DERIV(3)=S+0.5
      GO TO 80
C *** 4 NODES ALONG EDGE
   41 CONTINUE
      GO TO 80
C *** 5 NODES ALONG EDGE
   51 S0=S
      S1=S+0.5
      S2=S-0.5
      S3=S+1.0
      S4=S-1.0
      C1=2./3.
      C2=8./3.
      C3=4.
      SHF(1)= C1*S0*S1*S2*S4
      SHF(2)=-C2*S0*S2*S3*S4
      SHF(3)= C3*S1*S2*S3*S4
      SHF(4)=-C2*S0*S1*S3*S4
      SHF(5)= C1*S0*S1*S2*S3
      DERIV(1)= C1*(S2*S4*(S1+S0)+S0*S1*(S2+S4))
      DERIV(2)=-C2*(S2*S4*(S3+S0)+S0*S3*(S2+S4))
      DERIV(3)= C3*(S3*S4*(S1+S2)+S1*S2*(S3+S4))
      DERIV(4)=-C2*(S3*S4*(S1+S0)+S1*S0*(S3+S4))
      DERIV(5)= C1*(S2*S3*(S1+S0)+S1*S0*(S2+S3))
   80 CONTINUE
      RETURN
      END
      SUBROUTINE SFWZ(MNFZ,MXND,NEL,NN,MUMAX,NNZ,IFRZ,
     + NCORR,LTYP,NQ,NDEST,MREL,NREL,IFR,MULT,MCORE,NCORET)
C***********************************************************************
C     WORKS OUT FRONT WIDTH (IN NODES) FOR SYMMETRIC SOLUTION
C     USING LAST APPEARANCES MARKED BY SUBROUTINE MLAPZ.
C***********************************************************************
      DIMENSION NCORR(MXND,NEL),LTYP(NEL),MREL(MUMAX),NREL(NNZ)
      DIMENSION NDEST(NN),NQ(NN),IFR(IFRZ)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEBUGS/ ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /DEVSUP/ IW14,IW15,IWS
C
      INCORE=0
      DO 6 J=1,NEL
      IF(LTYP(J).LT.0) GOTO 6
      N=NCORR(1,J)
      NA=IABS(N)
      NDFN=NQ(NA)
      IF(NDFN.EQ.0)GOTO 6
      DO 4 I=1,NDFN
    4 IFR(I)=NA
      NFZ=NDFN
      MNFZ=NDFN
      NDEST(NA)=1
      GOTO 8
    6 CONTINUE
C
      WRITE(IW6,900)
      STOP
C
    8 CONTINUE
C-----------------------------------------------------------------------
C     CONSIDER EACH ELEMENT IN TURN
C-----------------------------------------------------------------------
      DO 40 J=1,NEL
C-----------------------------------------------------------------------
C     IGNORE OMITTED ELEMENTS
C-----------------------------------------------------------------------
      IF(LTYP(J).LT.0) GOTO 40
C-----------------------------------------------------------------------
C     CONSIDER EACH NODE OF THIS ELEMENT - DOES IT ALREADY HAVE
C     A ROW/COLUMN ALLOCATED TO IT IN THE GLOBAL STIFFNESS MATRIX ?
C-----------------------------------------------------------------------
      LT=LTYP(J)
      NNE=LINFO(1,LT)
      DO 20 I=1,NNE
      N=NCORR(I,J)
      NA=IABS(N)
      IF(NQ(NA).EQ.0)GOTO 20
C
      DO 10 K=1,NFZ
      IF(IFR(K).EQ.NA) GOTO 20
   10 CONTINUE
C-----------------------------------------------------------------------
C     FIND A (LARGE ENOUGH) GAP OR PUT ON END
C-----------------------------------------------------------------------
      K1=1
   11 DO 12 K=K1,NFZ
      IF(IFR(K).EQ.0) GOTO 15
   12 CONTINUE
C-----------------------------------------------------------------------
C     PUT ON END
C-----------------------------------------------------------------------
      K=NFZ+1
      NFZ=NFZ+NQ(NA)
      IF(NFZ.LE.IFRZ) GOTO 14
      WRITE(IW6,904)
      WRITE(IW15,904)
      WRITE(IWS,904)
      STOP
C
   14 K2=NFZ
      IF(NFZ.GT.MNFZ)MNFZ=NFZ
      GOTO 18
C
   15 DO 16 KK=K,NFZ
      IF(IFR(KK).NE.0) GOTO 17
   16 CONTINUE
C
      WRITE(IW6,905)
      WRITE(IW6,997)J,I
      WRITE(IW6,998)NFZ
      WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
      WRITE(IW15,905)
      WRITE(IW15,997)J,I
      WRITE(IW15,998)NFZ
      WRITE(IW15,999)(IFR(LL),LL=1,NFZ)
      WRITE(IWS,905)
      WRITE(IWS,997)J,I
      WRITE(IWS,998)NFZ
      WRITE(IWS,999)(IFR(LL),LL=1,NFZ)
      STOP
C
   17 K1=KK
      IF(NQ(NA).GT.KK-K) GOTO 11
      K2=K+NQ(NA)-1
   18 NDEST(NA)=K
C
      DO 19 KK=K,K2
   19 IFR(KK)=NA
   20 CONTINUE
CC    WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
C-----------------------------------------------------------------------
C     ELIMINATE NODES FROM FRONT THAT ARE MAKING THEIR LAST APPEARANCES.
C-----------------------------------------------------------------------
      DO 30 I=1,NNE
      IF(NCORR(I,J).GT.0) GOTO 30
C
      NOD=NCORR(I,J)
      NOD=IABS(NOD)
      IF(NQ(NOD).EQ.0)GOTO 30
      DO 22 K=1,NFZ
      N=NCORR(I,J)
      NA=IABS(N)
      IF(NA.EQ.IFR(K)) GOTO 23
   22 CONTINUE
      WRITE(IW6,908)
      WRITE(IW15,908)
      WRITE(IWS,908)
      STOP
C
   23 K2=K+NQ(NA)-1
      NCORR(I,J)=NCORR(I,J)*MULT
      DO 24 KK=K,K2
      INCORE=INCORE+NFZ+4
   24 IFR(KK)=0
      IF(K2.LT.NFZ) GOTO 30
C
   26 NFZ=NFZ-1
      IF(NFZ.EQ.0) GOTO 30
      IF(IFR(NFZ).EQ.0) GOTO 26
C
   30 CONTINUE
C
      IF(ID3.NE.1)GOTO 40
      IF(NFZ.GT.0) WRITE(IW6,999)(IFR(LL),LL=1,NFZ)
   40 CONTINUE
C
CC    WRITE(IW6,910) MNFZ
C
      IF(ID4.EQ.1)WRITE(IW6,950)NDEST
      MCORE=MNFZ*(MNFZ+1)/2+2*MNFZ+502
      NCORET=MCORE+INCORE
CC    WRITE(IW6,915)MCORE
CC    WRITE(IW6,920)INCORE
      RETURN
  900 FORMAT(1X,40HNO ELEMENTS IN SOLUTION * (ROUTINE SFWZ))
  904 FORMAT(1X,47H***ERROR** TOO MANY DEGREES OF FREEDOM IN FRONT,
     + 1X,14H(ROUTINE SFWZ))
  905 FORMAT(40H0PROGRAM ERROR - NO NODE ON END OF FRONT/
     + 15H0(ROUTINE SFWZ))
  908 FORMAT(1X,52HPROGRAM ERROR - LAST APPEARANCE NODE IS NOT IN FRONT,
     + 1X,14H(ROUTINE SFWZ))
CC910 FORMAT(/1X,35HMAXIMUM FRONT WIDTH FOR SOLUTION = ,I4,
CC   + 19H DEGREES OF FREEDOM)
CC915 FORMAT(/1X,43HMINIMUM CORE REQUIRED TO SOLVE EQUATIONS = ,I10)
CC920 FORMAT(/1X,47HADDITIONAL CORE REQUIRED FOR INCORE SOLUTION = ,I10)
  950 FORMAT(//1X,5HNDEST/(1X,20I5))
  997 FORMAT(5H J = ,I5,7H   I = ,I5)
  998 FORMAT(7H NFZ = ,I12)
  999 FORMAT(4H0IFR/(1X,25I5))
      END
      SUBROUTINE SHAPE(IW6,LL,NAC,DS,SHFN,NDIM,NDN,LT,ICODE)
C***********************************************************************
C     SHAPE FUNCTIONS AND DERIVATIVES FOR DIFFERENT ELEMENT TYPES
C     LAST MODIFIED ON 6 MAR 93
C***********************************************************************
      REAL LL
      DIMENSION LL(NAC),SHFN(NDN),DS(NDIM,NDN)
C
      AC1=LL(1)
      IF(NAC.LT.2)GOTO 5
      AC2=LL(2)
      IF(NAC.LT.3)GOTO 5
      AC3=LL(3)
      IF(NAC.LT.4)GOTO 5
      AC4=LL(4)
C
    5 CONTINUE
C
      DO 10 IN=1,NDN
      DO 10 ID=1,NDIM
   10 DS(ID,IN)=0.
C
      GOTO(11,13,13,14,14,15,15,17,17,18,18,11,33,12,12),LT
      WRITE(IW6,900)LT
  900 FORMAT(/1X,24HUNKNOWN ELEMENT TYPE ***,I5,2X,
     + 15H(ROUTINE SHAPE))
      STOP
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR BAR AND BEAM ELEMENTS
   11 CONTINUE
      SHFN(1)=AC1*(AC1-1.)/2.
      SHFN(2)=AC1*(AC1+1.)/2.
      SHFN(3)=(1.+AC1)*(1.-AC1)
C
      DS(1,1)=(2.*AC1-1.)/2.
      DS(1,2)=(2.*AC1+1.)/2.
      DS(1,3)=-2.*AC1
CC    WRITE(IW6,902)LT
  902 FORMAT(/1X,22HERROR *** ELEMENT TYPE,I5,2X,
     + 31HNOT IMPLEMENTED (ROUTINE SHAPE))
      GOTO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR 2-NODED BAR AND BEAM ELEMENTS
   12 CONTINUE
      SHFN(1)=(1.-AC1)/2.
      SHFN(2)=(1.+AC1)/2.
      IF(ICODE.EQ.1) GOTO 80
C
      DS(1,1)=-0.5
      DS(1,2)= 0.5
      GOTO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR LST
   13 SHFN(1)=AC1*(2.*AC1-1.)
      SHFN(2)=AC2*(2.*AC2-1.)
      SHFN(3)=AC3*(2.*AC3-1.)
      SHFN(4)=4.*AC1*AC2
      SHFN(5)=4.*AC2*AC3
      SHFN(6)=4.*AC1*AC3
      IF(ICODE.EQ.1)GOTO 80
C
      DS(1,1)=4.*AC1-1.
      DS(1,2)=0.
      DS(1,3)=-(4.*AC3-1.)
      DS(1,4)=4.*AC2
      DS(1,5)=-4.*AC2
      DS(1,6)=4.*(AC3-AC1)
C
      DS(2,1)=0.
      DS(2,2)=4.*AC2-1.
      DS(2,3)=-(4.*AC3-1.)
      DS(2,4)=4.*AC1
      DS(2,5)=4.*(AC3-AC2)
      DS(2,6)=-4.*AC1
      GO TO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR QUADRILATERALS
   14 CONTINUE
      C1=0.25
      C2=0.50
      SHFN(1) =-C1*(AC2-1.)*(AC1-1.)*(1.+AC1+AC2)
      SHFN(2) = C1*(AC2-1.)*(AC1+1.)*(1.-AC1+AC2)
      SHFN(3) = C1*(AC2+1.)*(AC1+1.)*(AC1+AC2-1.)
      SHFN(4) =-C1*(AC2+1.)*(AC1-1.)*(AC2-AC1-1.)
      SHFN(5) = C2*(AC2-1.)*(AC1+1.)*(AC1-1.)
      SHFN(6) =-C2*(AC1+1.)*(AC2+1.)*(AC2-1.)
      SHFN(7) =-C2*(AC2+1.)*(AC1+1.)*(AC1-1.)
      SHFN(8) = C2*(AC1-1.)*(AC2+1.)*(AC2-1.)
      IF(ICODE.EQ.1)GOTO 80
C
      DS(1,1)=-C1*(AC2-1.)*(2.*AC1+AC2)
      DS(1,2)= C1*(AC2-1.)*(AC2-2.*AC1)
      DS(1,3)= C1*(AC2+1.)*(2.*AC1+AC2)
      DS(1,4)=-C1*(AC2+1.)*(AC2-2.*AC1)
      DS(1,5)= C2*(AC2-1.)*(2.*AC1)
      DS(1,6)=-C2*(AC2+1.)*(AC2-1.)
      DS(1,7)=-C2*(AC2+1.)*(2.*AC1)
      DS(1,8)= C2*(AC2+1.)*(AC2-1.)
C
      DS(2,1)=-C1*(AC1-1.)*(2.*AC2+AC1)
      DS(2,2)= C1*(AC1+1.)*(2.*AC2-AC1)
      DS(2,3)= C1*(AC1+1.)*(2.*AC2+AC1)
      DS(2,4)=-C1*(AC1-1.)*(2.*AC2-AC1)
      DS(2,5)= C2*(AC1+1.)*(AC1-1.)
      DS(2,6)=-C2*(AC1+1.)*(2.*AC2)
      DS(2,7)=-C2*(AC1+1.)*(AC1-1.)
      DS(2,8)= C2*(AC1-1.)*(2.*AC2)
      GOTO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR CUBIC STRAIN TRIANGLE
   15 CONTINUE
      C1=32./3.
      C2=64.
      C3=128./3.
      C4=128.
      T11=AC1-0.25
      T12=AC1-0.50
      T13=AC1-0.75
      T21=AC2-0.25
      T22=AC2-0.50
      T23=AC2-0.75
      T31=AC3-0.25
      T32=AC3-0.50
      T33=AC3-0.75
C *** SHAPE FUNCTIONS
      SHFN(1) =C1*AC1*T11*T12*T13
      SHFN(2) =C1*AC2*T21*T22*T23
      SHFN(3) =C1*AC3*T31*T32*T33
      SHFN(4) =C3*AC1*AC2*T11*T12
      SHFN(5) =C2*AC1*AC2*T11*T21
      SHFN(6) =C3*AC1*AC2*T21*T22
      SHFN(7) =C3*AC2*AC3*T21*T22
      SHFN(8) =C2*AC2*AC3*T21*T31
      SHFN(9) =C3*AC2*AC3*T31*T32
      SHFN(10)=C3*AC1*AC3*T31*T32
      SHFN(11)=C2*AC1*AC3*T11*T31
      SHFN(12)=C3*AC1*AC3*T11*T12
      SHFN(13)=C4*AC1*AC2*AC3*T11
      SHFN(14)=C4*AC1*AC2*AC3*T21
      SHFN(15)=C4*AC1*AC2*AC3*T31
      IF(ICODE.EQ.1)GOTO 80
C
      DS(1,1)=C1*(T12*T13*(T11+AC1)+AC1*T11*(T13+T12))
      DS(1,2)= 0.
      DS(1,3)=-C1*(T32*T33*(AC3+T31)+AC3*T31*(T32+T33))
      DS(1,4)= C3*AC2*(T11*T12+AC1*(T11+T12))
      DS(1,5)= C2*AC2*T21*(AC1+T11)
      DS(1,6)= C3*AC2*T21*T22
      DS(1,7)=-C3*AC2*T21*T22
      DS(1,8)=-C2*AC2*T21*(AC3+T31)
      DS(1,9)=-C3*AC2*(T31*T32+AC3*(T31+T32))
      DS(1,10)=-C3*(AC1*AC3*(T31+T32)-T31*T32*(AC3-AC1))
      DS(1,11)= C2*(AC1*AC3*(T31-T11)+T31*T11*(AC3-AC1))
      DS(1,12)= C3*(AC1*AC3*(T11+T12)+T11*T12*(AC3-AC1))
      DS(1,13)= C4*AC2*(AC1*AC3+T11*(AC3-AC1))
      DS(1,14)= C4*AC2*T21*(AC3-AC1)
      DS(1,15)=-C4*AC2*(AC1*AC3+T31*(AC1-AC3))
C
      DS(2,1) = 0.
      DS(2,2) = C1*(T22*T23*(AC2+T21)+AC2*T21*(T22+T23))
      DS(2,3) =-C1*(T32*T33*(AC3+T31)+AC3*T31*(T32+T33))
      DS(2,4) = C3*AC1*T11*T12
      DS(2,5) = C2*AC1*T11*(AC2+T21)
      DS(2,6) = C3*AC1*(T21*T22+AC2*(T21+T22))
      DS(2,7) = C3*(AC2*AC3*(T21+T22)+T21*T22*(AC3-AC2))
      DS(2,8) = C2*(AC2*AC3*(T31-T21)+T21*T31*(AC3-AC2))
      DS(2,9) =-C3*(AC2*AC3*(T31+T32)+T31*T32*(AC2-AC3))
      DS(2,10)=-C3*AC1*(T31*T32+AC3*(T31+T32))
      DS(2,11)=-C2*AC1*T11*(AC3+T31)
      DS(2,12)=-C3*AC1*T11*T12
      DS(2,13)= C4*AC1*T11*(AC3-AC2)
      DS(2,14)= C4*AC1*(AC2*AC3+T21*(AC3-AC2))
      DS(2,15)=-C4*AC1*(AC2*AC3+T31*(AC2-AC3))
      GO TO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR BRICK ELEMENT
   17 CONTINUE
      C1=0.125
      C2=0.25
      ACP1=AC1+1.
      ACM1=AC1-1.
      ACP2=AC2+1.
      ACM2=AC2-1.
      ACP3=AC3+1.
      ACM3=AC3-1.
      T1=AC1+AC2-AC3+2.
      T2=AC2-AC3-AC1+2.
      T3=2.-AC1-AC2-AC3
      T4=AC1-AC2-AC3+2.
      T5=AC1+AC2+AC3+2.
      T6=AC2+AC3-AC1+2.
      T7=AC3-AC2-AC1+2.
      T8=AC1+AC3-AC2+2.
C
      SHFN(1) =-C1*ACM1*ACM2*ACP3*T1
      SHFN(2) = C1*ACP1*ACM2*ACP3*T2
      SHFN(3) =-C1*ACP1*ACP2*ACP3*T3
      SHFN(4) = C1*ACM1*ACP2*ACP3*T4
      SHFN(5) = C1*ACM1*ACM2*ACM3*T5
      SHFN(6) =-C1*ACP1*ACM2*ACM3*T6
      SHFN(7) = C1*ACP1*ACP2*ACM3*T7
      SHFN(8) =-C1*ACM1*ACP2*ACM3*T8
      SHFN(9) = C2*ACP1*ACM1*ACM2*ACP3
      SHFN(10)=-C2*ACP1*ACP2*ACM2*ACP3
      SHFN(11)=-C2*ACP1*ACM1*ACP2*ACP3
      SHFN(12)= C2*ACM1*ACP2*ACM2*ACP3
      SHFN(13)=-C2*ACP1*ACM1*ACM2*ACM3
      SHFN(14)= C2*ACP1*ACP2*ACM2*ACM3
      SHFN(15)= C2*ACP1*ACM1*ACP2*ACM3
      SHFN(16)=-C2*ACM1*ACP2*ACM2*ACM3
      SHFN(17)=-C2*ACM1*ACM2*ACP3*ACM3
      SHFN(18)= C2*ACP1*ACM2*ACP3*ACM3
      SHFN(19)=-C2*ACP1*ACP2*ACP3*ACM3
      SHFN(20)= C2*ACM1*ACP2*ACP3*ACM3
      IF(ICODE.EQ.1)GOTO 80
C
      DS(1,1) =-C1*ACM2*ACP3*(T1+ACM1)
      DS(1,2) = C1*ACM2*ACP3*(T2-ACP1)
      DS(1,3) =-C1*ACP2*ACP3*(T3-ACP1)
      DS(1,4) = C1*ACP2*ACP3*(T4+ACM1)
      DS(1,5) = C1*ACM2*ACM3*(T5+ACM1)
      DS(1,6) =-C1*ACM2*ACM3*(T6-ACP1)
      DS(1,7) = C1*ACP2*ACM3*(T7-ACP1)
      DS(1,8) =-C1*ACP2*ACM3*(T8+ACM1)
      DS(1,9) = C2*ACM2*ACP3*(2.*AC1)
      DS(1,10)=-C2*ACP2*ACM2*ACP3
      DS(1,11)=-C2*ACP2*ACP3*(2.*AC1)
      DS(1,12)= C2*ACP2*ACM2*ACP3
      DS(1,13)=-C2*ACM2*ACM3*(2.*AC1)
      DS(1,14)= C2*ACP2*ACM2*ACM3
      DS(1,15)= C2*ACP2*ACM3*(2.*AC1)
      DS(1,16)=-C2*ACP2*ACM2*ACM3
      DS(1,17)=-C2*ACM2*ACP3*ACM3
      DS(1,18)= C2*ACM2*ACP3*ACM3
      DS(1,19)=-C2*ACP2*ACP3*ACM3
      DS(1,20)= C2*ACP2*ACP3*ACM3
C
      DS(2,1) =-C1*ACM1*ACP3*(T1+ACM2)
      DS(2,2) = C1*ACP1*ACP3*(T2+ACM2)
      DS(2,3) =-C1*ACP1*ACP3*(T3-ACP2)
      DS(2,4) = C1*ACM1*ACP3*(T4-ACP2)
      DS(2,5) = C1*ACM1*ACM3*(T5+ACM2)
      DS(2,6) =-C1*ACP1*ACM3*(T6+ACM2)
      DS(2,7) = C1*ACP1*ACM3*(T7-ACP2)
      DS(2,8) =-C1*ACM1*ACM3*(T8-ACP2)
      DS(2,9) = C2*ACP1*ACM1*ACP3
      DS(2,10)=-C2*ACP1*ACP3*(2.*AC2)
      DS(2,11)=-C2*ACP1*ACM1*ACP3
      DS(2,12)= C2*ACM1*ACP3*(2.*AC2)
      DS(2,13)=-C2*ACP1*ACM1*ACM3
      DS(2,14)= C2*ACP1*ACM3*(2.*AC2)
      DS(2,15)= C2*ACP1*ACM1*ACM3
      DS(2,16)=-C2*ACM1*ACM3*(2.*AC2)
      DS(2,17)=-C2*ACM1*ACP3*ACM3
      DS(2,18)= C2*ACP1*ACP3*ACM3
      DS(2,19)=-C2*ACP1*ACP3*ACM3
      DS(2,20)= C2*ACM1*ACP3*ACM3
C
      DS(3,1) =-C1*ACM1*ACM2*(T1-ACP3)
      DS(3,2) = C1*ACP1*ACM2*(T2-ACP3)
      DS(3,3) =-C1*ACP1*ACP2*(T3-ACP3)
      DS(3,4) = C1*ACM1*ACP2*(T4-ACP3)
      DS(3,5) = C1*ACM1*ACM2*(T5+ACM3)
      DS(3,6) =-C1*ACP1*ACM2*(T6+ACM3)
      DS(3,7) = C1*ACP1*ACP2*(T7+ACM3)
      DS(3,8) =-C1*ACP2*ACM1*(T8+ACM3)
      DS(3,9) = C2*ACP1*ACM1*ACM2
      DS(3,10)=-C2*ACP1*ACP2*ACM2
      DS(3,11)=-C2*ACP1*ACM1*ACP2
      DS(3,12)= C2*ACM1*ACP2*ACM2
      DS(3,13)=-C2*ACP1*ACM1*ACM2
      DS(3,14)= C2*ACP1*ACP2*ACM2
      DS(3,15)= C2*ACP1*ACM1*ACP2
      DS(3,16)=-C2*ACM1*ACP2*ACM2
      DS(3,17)=-C2*ACM1*ACM2*(2.*AC3)
      DS(3,18)= C2*ACP1*ACM2*(2.*AC3)
      DS(3,19)=-C2*ACP1*ACP2*(2.*AC3)
      DS(3,20)= C2*ACM1*ACP2*(2.*AC3)
      GOTO 80
C *** SHAPE FUNCTIONS AND DERIVATIVES FOR TETRA-HEDRA
   18 CONTINUE
      WRITE(IW6,902)LT
      GOTO 80
C *** SHAPE FUNCTIONS FOR SLIP ELEMENTS
   33 CONTINUE
      DO 30 IJ=1,8
      DS(1,IJ)=0.
   30 SHFN(IJ)=0.
CC 33 SHFN(1)=AC1*(AC1-1.)/2.
      SHFN(1)=AC1*(AC1-1.)/2.
      SHFN(2)=AC1*(AC1+1.)/2.
CC    SHFN(3)=AC1*(AC1+1.)/2.
CC    SHFN(4)=AC1*(AC1-1.)/2.
      SHFN(5)=(1.+AC1)*(1.-AC1)
CC    SHFN(6)=(1.+AC1)/2.
CC    SHFN(7)=(1.+AC1)*(1.-AC1)
CC    SHFN(8)=(1.-AC1)/2.
C
      DS(1,1)=(2.*AC1-1.)/2.
      DS(1,2)=(2.*AC1+1.)/2.
CC    DS(1,3)=(2.*AC1+1.)/2.
CC    DS(1,4)=(2.*AC1-1.)/2.
      DS(1,5)=-2.*AC1
CC    DS(1,6)=1./2.
CC    DS(1,7)=-2.*AC1
CC    DS(1,8)=-1./2.
C
   80 CONTINUE
      RETURN
      END
      SUBROUTINE SHFNPP(IW6,LL,NAC,DS,SHFP,NDIM,NPN,LT,IFL)
C***********************************************************************
C     SHAPE FUNCTIONS AND DERIVATIVES FOR PORE PRESSURE VARIATION
C     ROUTINE LAST UPDATED ON 12/11/85
C***********************************************************************
      REAL LL,L1,L2,L3,L4
      DIMENSION SHFP(NPN),DS(NDIM,NPN),LL(NAC)
C
      L1=LL(1)
      L2=LL(2)
      IF(NAC.LT.3)GOTO 10
      L3=LL(3)
      IF(NAC.LT.4)GOTO 10
      L4=LL(4)
C
   10 GOTO(80,80,13,80,25,80,37,80,49,80,71),LT
      WRITE(IW6,900)LT
  900 FORMAT(/1X,24H*** UNKNOWN ELEMENT TYPE,I5,2X,
     + 16H(ROUTINE SHFNPP))
      STOP
C *** LINEAR STRAIN TRIANGLE
   13 IF(IFL.EQ.0)GO TO 23
      DS(1,1)=1.
      DS(1,2)=0.
      DS(1,3)=-1.
      DS(2,1)=0.
      DS(2,2)=1.
      DS(2,3)=-1.
C
   23 SHFP(1)=L1
      SHFP(2)=L2
      SHFP(3)=L3
      RETURN
C *** LINEAR STRAIN QUADRILATERAL
   25 CONTINUE
      C1=0.25
      IF(IFL.EQ.0)GOTO 35
C
      DS(1,1)= C1*(L2-1.)
      DS(1,2)=-C1*(L2-1.)
      DS(1,3)= C1*(L2+1.)
      DS(1,4)=-C1*(L2+1.)
C
      DS(2,1)= C1*(L1-1.)
      DS(2,2)=-C1*(L1+1.)
      DS(2,3)= C1*(L1+1.)
      DS(2,4)=-C1*(L1-1.)
C
   35 CONTINUE
      SHFP(1)= C1*(L1-1.)*(L2-1.)
      SHFP(2)=-C1*(L1+1.)*(L2-1.)
      SHFP(3)= C1*(L1+1.)*(L2+1.)
      SHFP(4)=-C1*(L1-1.)*(L2+1.)
      RETURN
C *** CUBIC STRAIN TRIANGLE
   37 C1=9./2.
      C2=27./2.
      C3=27.
      T11=L1-1./3.
      T12=L1-2./3.
      T21=L2-1./3.
      T22=L2-2./3.
      T31=L3-1./3.
      T32=L3-2./3.
      IF(IFL.EQ.0)GO TO 40
C
      DS(1,1)=C1*(T11*T12+L1*(T11+T12))
      DS(1,2)=0.
      DS(1,3)=-C1*(T31*T32+L3*(T31+T32))
      DS(1,4)=C2*L2*(L1+T11)
      DS(1,5)=C2*L2*T21
      DS(1,6)=-C2*L2*T21
      DS(1,7)=-C2*L2*(L3+T31)
      DS(1,8)=C2*L3*T31-C2*L1*(L3+T31)
      DS(1,9)=C2*L3*(L1+T11)-C2*L1*T11
      DS(1,10)=C3*L2*L3-C3*L2*L1
C
      DS(2,1)=0.
      DS(2,2)=C1*(T21*T22+L2*(T21+T22))
      DS(2,3)=-C1*(T31*T32+L3*(T31+T32))
      DS(2,4)=C2*L1*T11
      DS(2,5)=C2*L1*(L2+T21)
      DS(2,6)=C2*L3*(L2+T21)-C2*L2*T21
      DS(2,7)=C2*L3*T31-C2*L2*(L3+T31)
      DS(2,8)=-C2*L1*(L3+T31)
      DS(2,9)=-C2*L1*T11
      DS(2,10)=C3*L1*L3-C3*L1*L2
C
   40 SHFP(1) =C1*L1*T11*T12
      SHFP(2) =C1*L2*T21*T22
      SHFP(3) =C1*L3*T31*T32
      SHFP(4) =C2*L1*L2*T11
      SHFP(5) =C2*L1*L2*T21
      SHFP(6) =C2*L2*L3*T21
      SHFP(7) =C2*L2*L3*T31
      SHFP(8) =C2*L1*L3*T31
      SHFP(9) =C2*L1*L3*T11
      SHFP(10)=C3*L1*L2*L3
      RETURN
C *** BRICK ELEMENT
   49 CONTINUE
      C1=0.125
      IF(IFL.EQ.0)GOTO 59
C
      DS(1,1)= C1*(L2-1.)*(L3+1.)
      DS(1,2)=-C1*(L2-1.)*(L3+1.)
      DS(1,3)= C1*(L2+1.)*(L3+1.)
      DS(1,4)=-C1*(L2+1.)*(L3+1.)
      DS(1,5)=-C1*(L2-1.)*(L3-1.)
      DS(1,6)= C1*(L2-1.)*(L3-1.)
      DS(1,7)=-C1*(L2+1.)*(L3-1.)
      DS(1,8)= C1*(L2+1.)*(L3-1.)
C
      DS(2,1)= C1*(L1-1.)*(L3+1.)
      DS(2,2)=-C1*(L1+1.)*(L3+1.)
      DS(2,3)= C1*(L1+1.)*(L3+1.)
      DS(2,4)=-C1*(L1-1.)*(L3+1.)
      DS(2,5)=-C1*(L1-1.)*(L3-1.)
      DS(2,6)= C1*(L1+1.)*(L3-1.)
      DS(2,7)=-C1*(L1+1.)*(L3-1.)
      DS(2,8)= C1*(L1-1.)*(L3-1.)
C
      DS(3,1)= C1*(L1-1.)*(L2-1.)
      DS(3,2)=-C1*(L1+1.)*(L2-1.)
      DS(3,3)= C1*(L1+1.)*(L2+1.)
      DS(3,4)=-C1*(L1-1.)*(L2+1.)
      DS(3,5)=-C1*(L1-1.)*(L2-1.)
      DS(3,6)= C1*(L1+1.)*(L2-1.)
      DS(3,7)=-C1*(L1+1.)*(L2+1.)
      DS(3,8)= C1*(L1-1.)*(L2+1.)
C
   59 CONTINUE
      SHFP(1)= C1*(L1-1.)*(L2-1.)*(L3+1.)
      SHFP(2)=-C1*(L1+1.)*(L2-1.)*(L3+1.)
      SHFP(3)= C1*(L1+1.)*(L2+1.)*(L3+1.)
      SHFP(4)=-C1*(L1-1.)*(L2+1.)*(L3+1.)
      SHFP(5)=-C1*(L1-1.)*(L2-1.)*(L3-1.)
      SHFP(6)= C1*(L1+1.)*(L2-1.)*(L3-1.)
      SHFP(7)=-C1*(L1+1.)*(L2+1.)*(L3-1.)
      SHFP(8)= C1*(L1-1.)*(L2+1.)*(L3-1.)
      RETURN
C *** TETRA-HEDRA ELEMENT
   71 CONTINUE
      WRITE(IW6,902)LT
  902 FORMAT(/1X,22HERROR *** ELEMENT TYPE,I5,2X,
     + 32HNOT IMPLEMENTED (ROUTINE SHFNPP))
   80 RETURN
      END
      SUBROUTINE SORTN2(Y1,Y2,N1,N2,NMIN,NMAX)
C***********************************************************************
C     ROUTINE TO SORT TWO INTEGERS
C***********************************************************************
      NMIN=N1
      NMAX=N2
      IF(Y1.LT.Y2)RETURN
      NMAX=N1
      NMIN=N2
      RETURN
      END
      SUBROUTINE STOREQ(ELPA,MFZ,NBAX0,IBA,NDEQN,KURPA,IW7)
C***********************************************************************
C     WHEN SATURATED WRITES BUFFER TO DISK
C***********************************************************************
      DIMENSION ELPA(MFZ)
      LREC=IBA-NBAX0
      CALL WRTN(IW7,ELPA(NBAX0+1),LREC)
      WRITE(IW7) LREC
      IBA=NBAX0
      NDEQN=IBA+KURPA+4
      RETURN
      END
      SUBROUTINE STRSEQ(JJ,IP,IPA,NVRS,NIP,NEL,NDN,NDIM,NS,
     1 VARINT,F,CARTD,SHFN,DJACB,R,RI,CR)
C***********************************************************************
C     ROUTINE TO CALCULATE FORCES EQUILIBRATING
C     ELEMENTAL STRESSES (INTEGRATION POINT CONTRIBUTION)
C***********************************************************************
      DIMENSION VARINT(NVRS,NIP,NEL),F(NDIM,NDN),CARTD(NDIM,NDN)
      DIMENSION SHFN(NDN)
      COMMON /DATW  / W(100)
      COMMON /FLOW  / NPLAX
C
      F9=CR*DJACB*W(IPA)
      IF(NPLAX.EQ.1)F9=F9*R
C
      U=VARINT(NS+1,IP,JJ)
      SIGXT=VARINT(1,IP,JJ)+U
      SIGYT=VARINT(2,IP,JJ)+U
      SIGZT=VARINT(3,IP,JJ)+U
      TXY=VARINT(4,IP,JJ)
      IF(NDIM.EQ.2)GOTO 35
C
      TYZ=VARINT(5,IP,JJ)
      TZX=VARINT(6,IP,JJ)
C
      DO 30 IN=1,NDN
      F(1,IN)=F(1,IN)+(CARTD(1,IN)*SIGXT+CARTD(2,IN)*TXY
     1               +CARTD(3,IN)*TZX)*F9
      F(2,IN)=F(2,IN)+(CARTD(2,IN)*SIGYT+CARTD(1,IN)*TXY
     1               +CARTD(3,IN)*TYZ)*F9
      F(3,IN)=F(3,IN)+(CARTD(3,IN)*SIGZT+CARTD(2,IN)*TYZ
     1               +CARTD(1,IN)*TZX)*F9
   30 CONTINUE
      GOTO 60
C
   35 DO 40 IN=1,NDN
      F(1,IN)=F(1,IN)+(CARTD(1,IN)*SIGXT+SHFN(IN)*SIGZT*RI
     1               +CARTD(2,IN)*TXY)*F9
   40 F(2,IN)=F(2,IN)+(CARTD(2,IN)*SIGYT+CARTD(1,IN)*TXY)*F9
   60 RETURN
      END
      SUBROUTINE UPARAL(TTIME,TGRAV,IOUT,NN,ND,MXDF,NEL,NDF,NTPE,NIP,
     + NPT,NSP,NPL,NDZ,NVRS,NVRN,NDIM,MUMAX,NNZ,NDMX,NPMX,
     + NS,NB,NL,INXL,NPR,NMT,MXEN,XYZ,DI,DA,P,PT,XYFT,PEQT,VARINT,
     + STR,PEXI,PCONI,REAC,PR,CIP,FT,LL,B,DS,D,ELCOD,CARTD,SHFN,AA,
     + NCORR,NQ,KGVN,LTYP,MAT,JEL,IDFX,MREL,NREL,NWL,NMOD,NTY,NP1,NP2,
     + A,MFZ,PCOR,ICOR,IUPD,FRACT,IWRDK,JS,KK,LKK,
     + KLT,LTZ)
C***********************************************************************
C     ROUTINE TO ALLOCATE ARRAY STORE FOR USE IN UPOUT
C***********************************************************************
      REAL LL
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),VARINT(NVRS,NIP,NEL)
      DIMENSION XYFT(NDF),STR(NVRN,NIP,NEL),PEXI(NDF),P(NDF),PT(NDF)
      DIMENSION PEQT(NDF),PCOR(NDF),PCONI(NDF),REAC(NDF)
      DIMENSION NCORR(NTPE,NEL),NQ(NN),KGVN(MXDF,NN),LTYP(NEL),MAT(NEL)
      DIMENSION JEL(NEL),IDFX(NDF),MREL(MUMAX),NREL(NNZ),A(MFZ),
     + AA(NPMX),LL(NL),NWL(NPMX),NP1(NPL),NP2(NPL),NMOD(NIP,NEL)
      DIMENSION PR(NPR,NMT),CIP(NDIM),FT(NDIM,NDMX),
     + B(NS,NB),DS(NDIM,NDMX),ELCOD(NDIM,NDMX),CARTD(NDIM,NDMX),
     + SHFN(NDMX),NTY(NMT),D(NS,NS),KLT(LTZ),KK(LKK)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /DEVSUP/ IW14,IW15,IWS
C-----------------------------------------------------------------------
C     NCV   - NUMBER OF CAM-CLAY OUTPUT PARAMETERS (SIZE OF ARRAY VARC)
C     NSTP  - NUMBER OF SUB-INCREMENTS (ONLY FOR ELASTO-PLASTIC MODELS)
C     NVL   - SIZE OF ARRAY VLDL (ONLY FOR ELASTO-PLASTIC MODELS)
C-----------------------------------------------------------------------
      NCV=10
      NSTP=10
      NVL=200
      NIEL=NIP*NEL
      N1=NCV*NIEL+1
      N2=N1+NSTP*NVL
      N3=N2+NSTP
      LZ=N3
      M1=1
      M2=M1+NIEL
      M3=M2+NIEL
      M4=M3+NIEL
      M5=M4+NEL
      M6=M5+NEL
      M7=M6+NEL
      M8=M7+NEL
      M9=M8+NEL
      KZ=M9
C
      IERUP=0
      IF(LZ.LE.MFZ) GOTO 10
      MOREG=LZ-MFZ
      WRITE(IW6,901)MOREG
      WRITE(IW15,901)MOREG
      WRITE(IWS,901)MOREG
  901 FORMAT(1X,'ALLOCATED STORE FOR G EXCEEDED; INCREASE SIZE OF',
     + 1X,'ARRAY G  BY  AT LEAST ',I10,4X,'(ROUTINE UPARAL)'/)
      IERUP=IERUP+1
C
   10 CONTINUE
C
      IF(KZ.LE.LKK) GOTO 20
      MOREK=KZ-LKK
      WRITE(IW6,906)MOREK
      WRITE(IW15,906)MOREK
      WRITE(IWS,906)MOREK
  906 FORMAT(1X,'ALLOCATED STORE FOR K EXCEEDED; INCREASE SIZE OF',
     + 1X,'ARRAY K  BY  AT LEAST ',I10,4X,'(ROUTINE UPARAL)'/)
      IERUP=IERUP+1
C
   20 CONTINUE
      IF(IERUP.GT.0) STOP
C
CC 10 WRITE(IW6,902)LZ,MFZ
CC902 FORMAT(/34H0ARRAY STORE USED IN ROUTINE UPOUT,I8,1H/,I7/)
      CALL UPOUT(TTIME,TGRAV,IOUT,NN,ND,MXDF,NEL,NDF,NTPE,NIP,
     + NPT,NSP,NPL,NDZ,NVRS,NVRN,NDIM,MUMAX,NNZ,NDMX,NPMX,
     + NS,NB,NL,INXL,NPR,NMT,MXEN,XYZ,DI,DA,P,PT,XYFT,PEQT,VARINT,
     + STR,PEXI,PCONI,REAC,PR,CIP,FT,LL,B,DS,D,ELCOD,CARTD,SHFN,AA,
     + NCORR,NQ,KGVN,LTYP,MAT,JEL,IDFX,MREL,NREL,NWL,NMOD,NTY,NP1,NP2,
     + PCOR,ICOR,IUPD,FRACT,IWRDK,JS,NCV,NSTP,NVL,
     + A(1),A(N1),A(N2),KK(M1),KK(M2),KK(M3),KK(M4),KK(M5),KK(M6),
     + KK(M7),KK(M8),KLT,LTZ)
      RETURN
      END
      SUBROUTINE UPOUT(TTIME,TGRAV,IOUT,NN,ND,MXDF,NEL,NDF,NTPE,NIP,
     + NPT,NSP,NPL,NDZ,NVRS,NVRN,NDIM,MUMAX,NNZ,NDMX,NPMX,
     + NS,NB,NL,INXL,NPR,NMT,MXEN,XYZ,DI,DA,P,PTT,XYFT,PEQT,VARINT,STR,
     + PEXI,PCONI,REAC,PR,CIP,FT,LL,B,DS,D,ELCOD,CARTD,SHFN,AA,
     + NCORR,NQ,KGVN,LTYP,MAT,JEL,IDFX,MREL,NREL,NWL,NMOD,
     + NTY,NP1,NP2,PCOR,ICOR,IUPD,FRACT,IWRDK,JS,NCV,NSTP,NVL,
     + VARC,VLDL,VLAMB,NCODE,LCS,LNGP,
     + NELPR,NELUS,NELCM,MCS,MNGP,KLT,LTZ)
C
C***********************************************************************
C     UPDATE  AND  OUTPUT  ROUTINE
C***********************************************************************
C
      REAL L,LL
      INTEGER TF
      DIMENSION XYZ(NDIM,NN),DI(NDF),DA(NDF),VARINT(NVRS,NIP,NEL)
      DIMENSION P(NDF),PTT(NDF),XYFT(NDF),PEQT(NDF),PCOR(NDF)
      DIMENSION NCORR(NTPE,NEL),NQ(NN),KGVN(MXDF,NN),LTYP(NEL),MAT(NEL)
      DIMENSION JEL(NEL),IDFX(NDF),STR(NVRN,NIP,NEL),NMOD(NIP,NEL)
      DIMENSION PEXI(NDF),PCONI(NDF),REAC(NDF)
      DIMENSION MREL(MUMAX),NREL(NNZ),PR(NPR,NMT),CIP(NDIM),AA(NPMX),
     + B(NS,NB),DS(NDIM,NDMX),ELCOD(NDIM,NDMX),CARTD(NDIM,NDMX),
     + SHFN(NDMX),NTY(NMT),D(NS,NS),LL(NL),ED(2),NP1(NPL),NP2(NPL)
      DIMENSION VARC(NCV,NIP,NEL),VLDL(NSTP,NVL),VLAMB(NSTP)
      DIMENSION MCS(NEL),MNGP(NEL)
      DIMENSION LCS(NIP,NEL),LNGP(NIP,NEL),NCODE(NIP,NEL)
      DIMENSION NELPR(NEL),NELUS(NEL),NELCM(NEL),KLT(LTZ)
      DIMENSION ST(6),VARO(6),SS(6),SPA(3),SST(6),ICCSM(20)
      DIMENSION NWL(NPMX),FT(NDIM,NDMX)
CHR   FOR THESIS PRINTING
      DIMENSION NNODE(30),RNODE(30)
chr   END OF ADDITION
      COMMON /FIX   / DXYT(6,2000),TF(6,2000),MF(2000),NF
      COMMON /DATL  / L(4,100)
      COMMON /DATW  / W(100)
      COMMON /FLOW  / NPLAX
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /PRSLD / PRESLD(10,400),LEDG(400),NDE1(400),NDE2(400),NLED
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /COUNT / NCS,NNGP
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
      COMMON /JACB  / XJACI(3,3),DJACB
      COMMON /ELASP / NDLM,NULP
      COMMON /DEVSUP/ IW14,IW15,IWS
      COMMON /NUNIT2/ NFREQ,IWRU2
C
      ISTGE=4
      KSTGE=4
      LED=2
      NS1=NS+1    
CRA --- ADDITION ---- TO INCLUDE VOID RATIO AND PRINT CURRENT PERMEABILITY
      NS2=NS+2
      NS4=NS+4
      NS5=NS+5
CRA --- END OF ADDITION--------------
      NDIM1=NDIM+1
C-----------------------------------------------------------------------
C     BREAK OUTPUT CODE
C-----------------------------------------------------------------------
      IOUT5=IOUT/10000
      IOUT4=(IOUT-10000*IOUT5)/1000
      IOUT3=(IOUT-10000*IOUT5-1000*IOUT4)/100
      IOUT2=(IOUT-10000*IOUT5-1000*IOUT4-100*IOUT3)/10
      IOUT1=(IOUT-10000*IOUT5-1000*IOUT4-100*IOUT3-10*IOUT2)
      IF(IOUT1.LT.1)GO TO 5
      LT1=LTYP(1)
      LT1=IABS(LT1)
      GOTO(1,1,2,1,2,1,2,3,4,3,4,1,1),LT1
    1 WRITE(IW6,902)
      GOTO 5
    2 WRITE(IW6,901)
      GOTO 5
    3 WRITE(IW6,933)
      GOTO 5
    4 WRITE(IW6,934)
C-----------------------------------------------------------------------
C     UPDATE  ABSOLUTE  DISPLACEMENTS
C-----------------------------------------------------------------------
    5 CR=1.
      IF(NPLAX.EQ.1)CR=2.*PYI
C
      DO 6 KD=1,NDF
    6 DA(KD)=DA(KD)+DI(KD)
C
C
CHR   PRINTING PURPOSES CHR     
c      IF(IOUT1.EQ.0) GO TO 2007
      OPEN(50,FILE='NODLAT.DAT')
      REWIND(50)          
      READ(50,*)N20 
      READ(50,*)(NNODE(I),I=1,N20)  
      DO 2001 IX=1,N20
       JRH=NNODE(IX)
       JH=NREL(JRH)
       NQLH=NQ(JH)
       N1=KGVN(1,JH)
       RNODE(IX)=DA(N1)
 2001 CONTINUE
      OPEN(53,FILE='NODLAT.OUT',STATUS='APPEND') 
      WRITE(53,3001)TTIME,(RNODE(I),I=1,N20)
ch            
      OPEN(51,FILE='NODVER.DAT')
      REWIND(51)
      READ(51,*)N21  
      READ(51,*)(NNODE(I),I=1,N21)                   
      DO 2002 IX=1,N21
       JRH=NNODE(IX)
       JH=NREL(JRH)
       NQLH=NQ(JH)
       N1=KGVN(1,JH)+1
       RNODE(IX)=DA(N1)
 2002 CONTINUE
      OPEN(54,FILE='NODVER.OUT',STATUS='APPEND') 
      WRITE(54,3001)TTIME,(RNODE(I),I=1,N21)
CH      
      OPEN(52,FILE='NODPWP.DAT')      
      REWIND(52)                
      READ(52,*)N22
      READ(52,*)(NNODE(I),I=1,N22)
      DO 2003 IX=1,N22
       JRH=NNODE(IX)
       JH=NREL(JRH)
       NQLH=NQ(JH)
       N1=KGVN(1,JH)+2
       RNODE(IX)=DA(N1)
 2003 CONTINUE
      OPEN(55,FILE='NODPWP.OUT',STATUS='APPEND') 
      WRITE(55,3001)TTIME,(RNODE(I),I=1,N22)  
ch
      OPEN(56,FILE='NODPRO.DAT')      
      REWIND(56)                
      READ(56,*)N23
      READ(56,*)(NNODE(I),I=1,N23)
      DO 2004 IX=1,N23
       JRH=NNODE(IX)
       JH=NREL(JRH)
       NQLH=NQ(JH)
       N1=KGVN(1,JH)+1
       RNODE(IX)=DA(N1)
 2004 CONTINUE
      OPEN(57,FILE='NODPRO.OUT',STATUS='APPEND') 
      WRITE(57,3001)TTIME,(RNODE(I),I=1,N23)  
      CLOSE(50)
      CLOSE(51)
      CLOSE(52)
      CLOSE(53)
      CLOSE(54)
      CLOSE(55)
      CLOSE(56)
      CLOSE(57) 
 3001 FORMAT(1X,30E15.5)     
CHR   END OF ADDITION
      DO 10 JR=1,NNZ
      IF(NREL(JR).EQ.0) GO TO 10
      J=NREL(JR)
      NQL=NQ(J)
      IF(NQL.EQ.0) GOTO 10
      N1=KGVN(1,J)
      IF(IOUT1.EQ.0) GO TO 10
      IF(IOUT1.EQ.1.AND.JR.GT.NDZ) GO TO 10
      IF(JR.LT.NDZ)GOTO 7
      IF(JR.LT.NMOS.OR.JR.GT.NMOF)GOTO 10
      GOTO 8
    7 CONTINUE
      IF(JR.LT.NVOS.OR.JR.GT.NVOF)GOTO 10
    8 CONTINUE
C-----------------------------------------------------------------------
C     OUTPUT  DISPLACEMENTS
C-----------------------------------------------------------------------
      N2=N1+NQL-1
      IF(NDIM.EQ.3)GOTO 9
      IF(NQL.EQ.3)WRITE(IW6,900)JR,(DI(JJ),JJ=N1,N2),(DA(JJ),JJ=N1,N2)
      IF(NQL.EQ.2)WRITE(IW6,910)JR,(DI(JJ),JJ=N1,N2),(DA(JJ),JJ=N1,N2)
      IF(NQL.EQ.1)WRITE(IW6,911)JR,DI(N1),DA(N1)
      GOTO 10
    9 CONTINUE
      IF(NQL.EQ.4)WRITE(IW6,940)JR,(DI(JJ),JJ=N1,N2),(DA(JJ),JJ=N1,N2)
      IF(NQL.EQ.3)WRITE(IW6,941)JR,(DI(JJ),JJ=N1,N2),(DA(JJ),JJ=N1,N2)
CC    IF(NQL.EQ.1)WRITE(IW6,911)JR,DI(N1),DA(N1)
   10 CONTINUE
      IF(NDIM.EQ.3)GOTO 12
      IF(IOUT2.EQ.2)WRITE(IW6,904)
      IF(IOUT2.EQ.1)WRITE(IW6,906)
      GOTO 14
C
   12 CONTINUE
      IF(IOUT2.EQ.2)WRITE(IW6,904)
      IF(IOUT2.EQ.1)WRITE(IW6,936)
C
   14 CONTINUE
C--------PRINT STRESS HEADERS FOR BEAM/BAR/SLIP ELEMENTS (IF PRESENT)
      IF(IOUT2.EQ.1) THEN
         IF(KLT(1).NE.0.OR.KLT(14).NE.0)WRITE(IW6,961)
         IF(KLT(12).NE.0.OR.KLT(15).NE.0)WRITE(IW6,962)
         IF(KLT(13).NE.0)WRITE(IW6,963)
  961    FORMAT(1X,'BAR',94X,'AXI FORCE')
  962    FORMAT(1X,'BEAM',79X,'AXI FORCE',7X,'BM',7X,'LSFBM')
  963    FORMAT(1X,'SLIP',96X,'SIG-N',8X,'SIG-S')
      ENDIF
C
      CALL ZEROR1(PTT,NDF)
      CALL ZEROR1(PEQT,NDF)
C
C     INITIALISE
      DO 18 IM=1,NEL
      MCS(IM)=0
      MNGP(IM)=0
      NELPR(IM)=0
      NELCM(IM)=0
      NELUS(IM)=0
      DO 18 IP=1,NIP
      LCS(IP,IM)=0
   18 LNGP(IP,IM)=0
      CALL ZEROR2(VLDL,NSTP,NVL)
      CALL ZEROR3(VARC,NCV,NIP,NEL)
C-----------------------------------------------------------------------
C     CALCULATE  STRESSES  AND  STRAINS  IN  ELEMENTS
C     IEL COUNTER - NO. OF ELEMENTS PROCESSED
C-----------------------------------------------------------------------
      IEL=0
      IDL=0
      NCAM=0
      NELP=0
C--------ZERO ARRAY ICCSM
      DO 19 IC=1,20
   19 ICCSM(IC)=0
C
      DO 200 MR=1,MUMAX
      CALL ZEROR1(SST,NS)
      ICAM=0
      IELST=0
      IELPL=0
      J=MREL(MR)
      IF(J.EQ.0) GO TO 200
      LT=LTYP(J)
      IF(LT.LT.0)GO TO 200
      NDN=LINFO(5,LT)
      NGP=LINFO(11,LT)
      INDX=LINFO(12,LT)
      NAC=LINFO(15,LT)
CC    NDP1=NDN+1
CC    NDP2=NDN+NDN
      NPN=LINFO(6,LT)
      NDPT=LINFO(1,LT)
C-----------------------------------------------------------------------
C     SETUP LOCAL NODAL COORDINATES OF ELEMENT
C-----------------------------------------------------------------------
      DO 20 KN=1,NDN
      NDE=NCORR(KN,J)
      DO 20 ID=1,NDIM
   20 ELCOD(ID,KN)=XYZ(ID,NDE)
C
      KM=MAT(J)
C-----------------------------------------------------------------------
C     INITIALISE  FT
C-----------------------------------------------------------------------
      CALL ZEROR2(FT,NDIM,NDMX)
      IF(LT.EQ.1)CALL OUTBR(IW6,IOUT2,MR,KM,J,ELCOD,VARINT,
     +                       FT,PR,NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,
     +                       NDF,INDX,NDIM,NDN,NEL,NVRS,NIP,
     +                       NGP,NPR,NMT,LT)
      IF(LT.EQ.12)CALL OUTBM(IW6,IOUT2,MR,KM,J,ELCOD,VARINT,
     +                       FT,PR,NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,
     +                       NDF,INDX,NDIM,NDN,NEL,NVRS,NIP,
     +                       NGP,NPR,NMT,LT)
      IF(LT.EQ.13)CALL OUTSLP(IW6,IOUT2,MR,KM,J,ELCOD,VARINT,
     +                       FT,PR,NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,
     +                       NDF,INDX,NDIM,NDN,NEL,NVRS,NIP,
     +                       NGP,NPR,NMT,LT)
      IF(LT.EQ.14)CALL OUTBR2(IW6,IOUT2,MR,KM,J,ELCOD,VARINT,
     +                       FT,PR,NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,
     +                       NDF,INDX,NDIM,NDN,NEL,NVRS,NIP,
     +                       NGP,NPR,NMT,LT)
      IF(LT.EQ.15)CALL OUTBM2(IW6,IOUT2,MR,KM,J,ELCOD,VARINT,
     +                       FT,PR,NCORR,KGVN,DI,CIP,NTPE,NN,MXDF,
     +                       NDF,INDX,NDIM,NDN,NEL,NVRS,NIP,
     +                       NGP,NPR,NMT,LT)
      IF(LT.EQ.1.OR.LT.EQ.12.OR.LT.EQ.13.OR.LT.EQ.14.OR.LT.EQ.15)
     +        GOTO 130
C
      GOTO(25,25,23,25,23,25,23,25,23,25,23),LT
C-----------------------------------------------------------------------
C     SETUP LOCAL ARRAY OF KGVN AS NWL GIVING THE INDEX TO
C     PORE-PRESSURE VARIABLES
C-----------------------------------------------------------------------
   23 IPP=0
      DO 24 IV=1,NDPT
      IQ=LINFO(IV+INXL,LT)
      IF(IQ.NE.NDIM1.AND.IQ.NE.1)GO TO 24
      IPP=IPP+1
      NDE=NCORR(IV,J)
      NWL(IPP)=KGVN(4,NDE)
   24 CONTINUE
   25 IF(IOUT2.NE.2)GO TO 26  
CRA ---- REPLACED BY ---------
CRA      IF(MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,908)MR     
CRA   REPLACED  --------------       
      IF(MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,908)MR,VARINT(NS4,NGP,J),
     + VARINT(NS5,NGP,J)
CRA ----- END OF REPLACEMENT--------------------  
      IF(NDIM.EQ.2.AND.MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,914)
      IF(NDIM.EQ.3.AND.MR.GE.NELOS.AND.MR.LE.NELOF)WRITE(IW6,944)
   26 CONTINUE
      KGO=NTY(KM)
      IF(NTY(KM)-2)27,28,28
   27 CALL  DCON(J,MR,0,NEL,NDIM,NS,NPR,NMT,MAT,PR,D,IPLSTK)
      IELST=1
   28 IEL=IEL+1
      NELUS(IEL)=MR
      NELPR(IEL)=J
C-----------------------------------------------------------------------
C     LOOP ON INTEGRATION POINTS
C-----------------------------------------------------------------------
      DO 125 IP=1,NGP
      IPA=IP+INDX
      DO 35 IL=1,NAC
   35 LL(IL)=L(IL,IPA)
C-----------------------------------------------------------------------
C     FORM  B  MATRIX
C-----------------------------------------------------------------------
      RI=0.
      CALL FORMB2(J,MR,R,RI,NDIM,NDMX,NDN,NS,NB,NAC,B,ELCOD,CARTD,
     +            SHFN,DS,LL,LT,IP,ISTGE)
C
      CALL ZEROR1(ST,NS)
C
      DO 44 II=1,NDN
      IN=NCORR(II,J)
      N1=KGVN(1,IN)
      N2=N1+1
      ST(1)=ST(1)+CARTD(1,II)*DI(N1)
      ST(2)=ST(2)+CARTD(2,II)*DI(N2)
      ST(3)=ST(3)+SHFN(II)*DI(N1)*RI
      ST(4)=ST(4)+CARTD(1,II)*DI(N2)+CARTD(2,II)*DI(N1)
      IF(NDIM.EQ.2)GOTO 44
      N3=N1+2
      ST(3)=ST(3)+CARTD(3,II)*DI(N3)
      ST(5)=ST(5)+CARTD(3,II)*DI(N2)+CARTD(2,II)*DI(N3)
      ST(6)=ST(6)+CARTD(3,II)*DI(N1)+CARTD(1,II)*DI(N3)
   44 CONTINUE
C
      ED(1)=EDS(STR(1,IP,J),NS,NDIM)
C
      DO 45 IS=1,NS
   45 STR(IS,IP,J)=STR(IS,IP,J)+ST(IS)
      ED(2)=EDS(STR(1,IP,J),NS,NDIM)
C-----------------------------------------------------------------------
C     CALCULATE  INCREMENTAL STRESSES
C-----------------------------------------------------------------------
      GO TO(59,52,53,54,55,56,59,59),KGO
   52 CALL  DLIN(IP,J,MR,0,NEL,NDIM,NDN,NS,NPR,NMT,
     +           ELCOD,SHFN,MAT,D,PR,INDX)
      IELST=1
      GO TO 59
   53 CALL DMCAM(IP,J,MR,0,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +           VARINT,MAT,D,PR,IPLSTK)
      ICAM=1
      GO TO 59
   54 CALL DCAM(IP,J,MR,0,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +          VARINT,MAT,D,PR,ITP,IPLSTK)
      ICAM=1
      GO TO 59
   55 CALL DELP(IP,J,MR,0,NEL,NIP,NVRS,NDIM,NDN,NS,NPR,NMT,
     +          ELCOD,SHFN,VARINT,MAT,D,PR,NMOD,1,IPLSTK)
      IELPL=1
      GO TO 59
   56 CALL DSCHO(IP,J,MR,0,NEL,NIP,NVRS,NDIM,NS,NPR,NMT,
     +           VARINT,MAT,D,PR,ITP,IPLSTK,IPROP)
      ICAM=1
C
   59 DO 60 II=1,NS
      SS(II)=0.
      DO 60 JJ=1,NS
   60 SS(II)=SS(II)+D(II,JJ)*ST(JJ)
C-----------------------------------------------------------------------
C     UPDATE  ABSOLUTE  STRESSES
C-----------------------------------------------------------------------
      DO 65 JJ=1,NS
      SST(JJ)=SST(JJ)+SS(JJ)
      VARO(JJ)=VARINT(JJ,IP,J)
   65 VARINT(JJ,IP,J)=VARINT(JJ,IP,J)+SS(JJ)
C-----------------------------------------------------------------------
C     CALCULATE  PORE  PRESSURES
C-----------------------------------------------------------------------
      GOTO(70,70,66,70,66,70,66,70,66,70,66),LT
   66 CALL SHFNPP(IW6,LL,NAC,DS,AA,NDIM,NPN,LT,0)
      SUM=ZERO
      DO 68 IC=1,NPN
      IVR=NWL(IC)
   68 SUM=SUM+AA(IC)*DI(IVR)
      V=ST(1)+ST(2)+ST(3)
      UI=SUM   
CRA -- ADDITIONAL TO CALCULATE VOID RATIO  FOR NTY=1,2: elastic models ----  
      IF (KGO.EQ.1.OR.KGO.EQ.2) THEN   
      VTOT=STR(1,IP,J)+STR(2,IP,J)+STR(3,IP,J)
      VARINT(NS+2,IP,J)=PR(17,KM)-VTOT*(1.0+PR(17,KM))
      ENDIF
CRA -- END OF ADDITIONAL--
      GO TO 72
   70 V=ST(1)+ST(2)+ST(3)
      UI=PR(7,KM)*V
   72 VARINT(NS+1,IP,J)=VARINT(NS+1,IP,J)+UI     

C
      IF(KGO.NE.3.AND.KGO.NE.4.AND.KGO.NE.6)GOTO 85
C-----------------------------------------------------------------------
C     CALCULATE  EXTRA  VARIABLES  FOR  CAM-CLAY  ONLY
C-----------------------------------------------------------------------
      CALL EVCAM(VARINT,NEL,NVRS,NDIM,NIP,IP,J,MR,KM,
     +           IEL,NS,NPR,NMT,PR,NTY,NCAM,V,NCODE,LCS,LNGP,
     +           MCS,MNGP,NELCM,VARC,NGP,ED,LED,NCV,ICCSM)  

C-----------------------------------------------------------------------
C     FIND STRESS STATE FOR ELASTO PLASTIC MODEL
C-----------------------------------------------------------------------
   85 IF(KGO.NE.5)GOTO 95
      CALL YIELD(IP,J,MR,SS,MAT,NEL,NIP,NVRS,VARINT,PR,NPR,NMT,VARO,
     +           NMOD,IEL,IDL,NELP,VLDL,VLAMB,NVL,LCS,LNGP,MCS,MNGP,
     +           NELCM,VARC,NCV,NSTP,NDIM,NS,NGP,ELCOD,SHFN,NDN)
C-----------------------------------------------------------------------
C     CALCULATE NODAL LOADS EQUILIBRATING ELEMENT STRESSES
C-----------------------------------------------------------------------
   95 CALL STRSEQ(J,IP,IPA,NVRS,NIP,NEL,NDN,NDIM,NS,
     +            VARINT,FT,CARTD,SHFN,DJACB,R,RI,CR)
C-----------------------------------------------------------------------
C     OUTPUT ABSOLUTE STRESSES
C-----------------------------------------------------------------------
      IF(NDIM.EQ.2)CALL PRINC(VARINT(1,IP,J),VARINT(2,IP,J),
     +                        VARINT(4,IP,J),SPA)
      IF(IOUT2.EQ.0)GO TO 125
      IF(IOUT2.EQ.1)GO TO 120
      IKM=IP
      GO TO 122
  120 IF(IOUT2.NE.1.OR.IP.NE.NGP)GO TO 125
      IKM=MR
  122 DO 124 ID=1,NDIM
      SUM=ZERO
      DO 123 IN=1,NDN
  123 SUM=SUM+SHFN(IN)*ELCOD(ID,IN)
  124 CIP(ID)=SUM
      IF(MR.LT.NELOS.OR.MR.GT.NELOF)GOTO 125
CRA   -- REPLACEMENT ---
CRA      IF(NDIM.EQ.2)WRITE(IW6,916)IKM,(CIP(ID),ID=1,NDIM),
CRA     + (VARINT(IK,IP,J),IK=1,NS1),(SPA(JL),JL=1,3)
CRA   REPLACE TO INCLUDE VOID RATIO BY
      IF(NDIM.EQ.2)WRITE(IW6,916)IKM,(CIP(ID),ID=1,NDIM),
     + (VARINT(IK,IP,J),IK=1,NS2),(SPA(JL),JL=1,3)
      IF (IOUT2.EQ.1) WRITE(IW6,908)MR,VARINT(NS4,NGP,J),
     + VARINT(NS5,NGP,J)
CRA ------END OF REPLACEMENT -----     
     
      IF(NDIM.EQ.3)WRITE(IW6,946)IKM,(CIP(ID),ID=1,NDIM),
     + (VARINT(IK,IP,J),IK=1,NS1)
  125 CONTINUE
C-----------------------------------------------------------------------
C     ASSEMBLE EQUILIBRATING NODAL FORCES INTO GLOBAL ARRAY - PEQT
C-----------------------------------------------------------------------
  130 CONTINUE
CC    WRITE(IW6,810)MR,FT
CC810 FORMAT(/1X,'ELEMENT -',I5,2X,'FT'/(1X,9E12.5))
      DO 155 IK=1,NDN
      II=NCORR(IK,J)
      IF(NQ(II).EQ.0)GOTO 155
      N1=KGVN(1,II)-1
      DO 150 ID=1,NDIM
  150 PEQT(N1+ID)=PEQT(N1+ID)+FT(ID,IK)
  155 CONTINUE
  200 CONTINUE
C-----------------------------------------------------------------------
C     PRINT STRAINS AT INTEGRATION POINTS OR CENTRIODS
C-----------------------------------------------------------------------
      IF(IOUT3.NE.0) CALL OUTSTR(IW6,NN,NEL,NTPE,NIP,NVRS,NVRN,NDIM,
     + MUMAX,NDMX,NS,NL,INXL,XYZ,STR,CIP,LL,DS,ELCOD,SHFN,NCORR,LTYP,
     + MAT,MREL,VARINT,IOUT3)
C-----------------------------------------------------------------------
C     OUTPUT ADDITIONAL PARAMETERS AND WARNING MESSAGES
C     FOR CAM-CLAYS
C-----------------------------------------------------------------------
      CALL UPOUT2(IW6,NDIM,NMOD,NEL,NIP,LTYP,MAT,NCAM,IOUT4,IEL,NELP,
     + NCODE,LCS,LNGP,MCS,MNGP,NELPR,NELUS,NELCM,NCV,VARC,VLDL,NSTP,NVL,
     + ICCSM)
CC    WRITE(IW6,800)PEQT
CC800 FORMAT(/1X,'PEQT'/(1X,9E12.5))
C-----------------------------------------------------------------------
C     OUTPUT EQUILIBRIUM AND OUT-OF-BALANCE NODAL LOADS
C-----------------------------------------------------------------------
      DO 220 IM=1,NDF
  220 PEQT(IM)=PEQT(IM)+PEXI(IM)
C
C--------CHANGES MADE ON 23 APRIL 90
      WRITE(IWS,800)JS
  800 FORMAT(/1X,26(1H-),'  INC NO. =',I5,4X,26(1H-))   
      IF(IWRU2.EQ.1) THEN
         WRITE(IW14,805)JS
  805    FORMAT(1X,I5,5X,'INCRMEMENT NUMBER')
         WRITE(IW14,810)ICCSM
  810    FORMAT(1X,10I5/1X,10I5)
         WRITE(IW14,820)((VARC(7,IY,IG),IY=1,NIP),IG=1,NEL)
  820    FORMAT(1X,5F15.3)  
      ENDIF
C
      CALL EQLOD(IW6,NN,NEL,NDF,MXDF,NTPE,NDIM,MUMAX,NNZ,NDZ,
     +           NPR,NMT,NDMX,NL,NPL,NCORR,NQ,KGVN,IDFX,LTYP,
     +           MAT,JEL,MREL,NREL,NP1,NP2,XYZ,
     +           P,PTT,PEQT,PCOR,XYFT,PCONI,REAC,PR,FT,ELCOD,SHFN,DS,LL,
     +           NPT,NSP,MXEN,IOUT5,ICOR,TGRAV,1,FRACT,0,KSTGE,IWRU2)
C-----------------------------------------------------------------------
C     UPDATE  NODAL  CO-ORDINATES
C-----------------------------------------------------------------------
      IF(IUPD.EQ.0) GO TO 235
      WRITE(IW6,926)
      DO 230 J=1,ND
      N1=KGVN(1,J)-1
      DO 230 ID=1,NDIM
  230 XYZ(ID,J)=XYZ(ID,J)+DI(N1+ID)
  235 CONTINUE
C
      IF(ISR.EQ.0)GOTO 245
      IF(ISR.EQ.2)GOTO 240
      IF(ISR.EQ.1.AND.IWL.EQ.1) THEN
         WRITE(IW2)JS
      ELSE
         GOTO 245
      ENDIF
C
  240 CONTINUE
C-----------------------------------------------------------------------
C     WRITE RESULTS TO TAPE  - ONLY WHEN USING STOP-START FACILITY
C-----------------------------------------------------------------------
      IF(IWRU2.EQ.1) THEN
      WRITE(IW2) JS
      WRITE(IW2) TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,PCONI,LTYP,NMOD
     +           ,REAC
      WRITE(IW2) NF,MF,TF,DXYT
      WRITE(IW2) NLED,LEDG,NDE1,NDE2,PRESLD
      IF(ISR.EQ.2) WRITE(IW6,965)JS
  965 FORMAT(/1X,'**** RESULTS FROM INCREMENT',I5,4X,'HAS BEEN WRITTEN',
     +        1X,'TO UNIT 2 (DISK) ****'/)
      ENDIF
C-----------------------------------------------------------------------
C     WRITE RESULTS AT THE END OF SELECTED INCREMENT(S) TO DISK FILE
C-----------------------------------------------------------------------
  245 CONTINUE
      IF(IWRDK.NE.1)GOTO 250
      WRITE(IW9) JS
      WRITE(IW9) TTIME,TGRAV,XYZ,VARINT,STR,DA,XYFT,PCOR,PCONI,LTYP,NMOD
     +           ,REAC
      WRITE(IW9) NF,MF,TF,DXYT
      WRITE(IW9) NLED,LEDG,NDE1,NDE2,PRESLD
C
  250 CONTINUE
C
C==========OUTPUT CAM-CLAY SUMMARY TO UNIT 16
      CALL PRNTSM(NDIM,JS,ICCSM)
C
  900 FORMAT(1X,I5,6E15.5)
  901 FORMAT(//46H NODAL DISPLACEMENTS AND EXCESS PORE PRESSURES/
     + 1X,45(1H-)//26X,11HINCREMENTAL,36X,22HABSOLUTE  (CUMULATIVE)//
     + 2X,4HNODE,7X,2HDX,13X,2HDY,13X,2HDU,13X,2HDX,13X,2HDY,13X,2HDU/)
  904 FORMAT(//40H ABSOLUTE STRESSES AT INTEGRATION POINTS/1X,39(1H-)//)
CRA  -- REPLACED TO ACCOMODATE 
CRA  908 FORMAT(/15H ELEMENT NUMBER,I5/1X,19(1H-)/)
CRA --- REPLACED BY -----
  908 FORMAT (/15H ELEMENT NUMBER,I5/1X,19(1H-)/,2X,
     + 14H current kx = ,E13.5,2X,14H current ky = ,E13.5,/)
CRA  -- END IF REPLACEMENT ---    
  910 FORMAT(1X,I5,2E15.5,15X,2E15.5)
  911 FORMAT(1X,I5,30X,E15.5,30X,E15.5)
CRA 
CRA  914 FORMAT(2X,2HIP,7X,1HX,13X,1HY,9X,6HSIG-X',7X,6HSIG-Y',7X,6HSIG-Z',
CRA     + 8X,3HTXY,12X,1HU,10X,5HSIG-1,8X,5HSIG-2,7X,5HTH-XY)   
CRA   REPLACED BY  
  914 FORMAT(2X,2HIP,7X,1HX,13X,1HY,9X,6HSIG-X',7X,6HSIG-Y',7X,6HSIG-Z',
     + 8X,3HTXY,12X,1HU,7X,3H e ,5X,5HSIG-1,8X,5HSIG-2,7X,5HTH-XY) 
CRA   END OF REPLACEMENT       
CRA   
CRA  916 FORMAT(1X,I3,9E13.5,F10.1)  
CRA -- REPLACED BY TO INCLUDE VOID RATIO
CRA        
  916 FORMAT(1X,I2,7E13.5,1X,F6.4,2E13.5,F5.1)
CRA   END OF REPLACEMENT  
  902 FORMAT(//20H NODAL DISPLACEMENTS/1X,19(1H-)//
     + 18X,11HINCREMENTAL,30X,21HABSOLUTE (CUMULATIVE)//
     + 2X,4HNODE,7X,2HDX,13X,2HDY,28X,2HDX,13X,2HDY/)
  906 FORMAT(//30H STRESSES AT ELEMENT CENTROIDS/1X,29(1H-)//8H ELEMENT,
     + 3X,1HX,13X,1HY,9X,6HSIG-X',7X,6HSIG-Y',7X,6HSIG-Z',8X,
     + 3HTXY,12X,1HU,10X,5HSIG-1,8X,5HSIG-2,7X,5HTH-XY)
  926 FORMAT(/48H WARNING **** THE NODAL CO-ORDINATES ARE UPDATED/)
  934 FORMAT(//46H NODAL DISPLACEMENTS AND EXCESS PORE PRESSURES/
     + 1X,45(1H-)//26X,11HINCREMENTAL,51X,22HABSOLUTE  (CUMULATIVE)//
     + 2X,4HNODE,7X,2HDX,13X,2HDY,13X,2HDZ,13X,2HDU,
     + 13X,2HDX,13X,2HDY,13X,2HDZ,13X,2HDU/)
  933 FORMAT(//20H NODAL DISPLACEMENTS/1X,19(1H-)//
     + 18X,11HINCREMENTAL,51X,8HABSOLUTE//
     + 2X,4HNODE,7X,2HDX,13X,2HDY,13X,2HDZ,28X,2HDX,13X,2HDY,13X,2HDZ/)
  936 FORMAT(//30H STRESSES AT ELEMENT CENTROIDS/1X,29(1H-)//8H ELEMENT,
     + 3X,1HX,13X,1HY,12X,1HZ,9X,6HSIG-X',7X,6HSIG-Y',7X,
     + 6HSIG-Z',9X,3HTXY,11X,3HTYZ,10X,3HTZX,11X,1HU)
  940 FORMAT(1X,I5,8E15.5)
  941 FORMAT(1X,I5,3E15.5,15X,3E15.5)
  944 FORMAT(2X,2HIP,7X,1HX,12X,1HY,12X,1HZ,9X,6HSIG-X',
     + 7X,6HSIG-Y',7X,6HSIG-Z',7X,3HTXY,9X,3HTYZ,9X,3HTZX,8X,1HU)
  946 FORMAT(1X,I3,8E13.5,2E12.5)
      RETURN
      END
      SUBROUTINE UPOUT2(IW6,NDIM,NMOD,NEL,NIP,LTYP,MAT,NCAM,IOUT4,IEL,
     + NELP,NCODE,LCS,LNGP,MCS,MNGP,NELPR,NELUS,NELCM,
     + NCV,VARC,VLDL,NSTP,NVL,ICCSM)
C***********************************************************************
C     OUTPUT ADDITIONAL PARAMETERS CAM-CLAYS
C***********************************************************************
      DIMENSION MAT(NEL),LTYP(NEL),VARC(NCV,NIP,NEL),MCS(NEL),MNGP(NEL)
      DIMENSION LCS(NIP,NEL),LNGP(NIP,NEL),NCODE(NIP,NEL),NMOD(NIP,NEL)
      DIMENSION NELPR(NEL),NELUS(NEL),NELCM(NEL),VLDL(NSTP,NVL)
      DIMENSION ICCSM(20)
      COMMON /ELINF / MINFO(6,30,15),LINFO(50,15)
      COMMON /OUT   / INSOP,IRAC,NVOS,NVOF,NMOS,NMOF,NELOS,NELOF,ISR,IWL
C
      IF(NCAM.EQ.0)GOTO 46
CT    IF(IOUT4.EQ.0)GOTO 25
      IF(IOUT4.EQ.1)WRITE(IW6,911)
      IF(IOUT4.EQ.1)WRITE(IW6,902)
      IF(IOUT4.EQ.2)WRITE(IW6,912)
      IF(IOUT4.EQ.2)WRITE(IW6,901)
C
      DO 20 ILM=1,IEL
      J=NELPR(ILM)
      IC=NELCM(ILM)
      IF(IC.NE.1)GOTO 20
      MR=NELUS(ILM)
      KM=MAT(J)
      LT=LTYP(J)
      NGP=LINFO(11,LT)
      DO 5 IP=1,NGP
    5 NMOD(IP,J)=NCODE(IP,ILM)
      IF(MR.LT.NELOS.OR.MR.GT.NELOF)GOTO 16
      IF(IOUT4.EQ.0)GOTO 16
      IF(IOUT4.EQ.1)GOTO 12
      IF(IOUT4.EQ.2)WRITE(IW6,904)MR
C
CRA -- ADDITIONAL AWAL - TO CALCULATE AVERAGE VOID RATIO IN ELEMENT --
      AWAL1=0.
      AWAL2=0.
      RATA1=0.
      RATA2=0.
CRA  -- AKHIR ---
      DO 10 IGP=1,NGP
CRA -- AWAL 
      AWAL1=AWAL1+VARC(8,IGP,ILM)
      AWAL2=AWAL2+VARC(9,IGP,ILM)
CRA -- AKHIR --
      WRITE(IW6,905)IGP,(VARC(IK,IGP,ILM),IK=1,10),NCODE(IGP,ILM)
   10 CONTINUE 
CRA  -- AWAL 
      RATA1=AWAL1/NGP
      RATA2=AWAL2/NGP
CRA   -- WRITE THE AVERAGE VOID RATIO ---
cra      WRITE(IW6,968)RATA1,RATA2
CRA -------- AKHIR --------
      GOTO 16
   12 WRITE(IW6,905)MR,(VARC(IK,NGP,ILM),IK=1,10),
     + (NCODE(IP,ILM),IP=1,NGP)
C-----------------------------------------------------------------------
C     WARNING MESSAGES - CAM-CLAYS
C-----------------------------------------------------------------------
   16 IF(MCS(ILM).EQ.0)GOTO 17
      IF(NGP.GE.7) THEN
         WRITE(IW6,916)MR,(LCS(IP,ILM),IP=1,NGP)
      ELSE
         WRITE(IW6,966)MR,(LCS(IP,ILM),IP=1,NGP)
      ENDIF
   17 IF(MNGP(ILM).EQ.0)GOTO 20
      IF(NGP.GE.7) THEN
         WRITE(IW6,917)MR,(LNGP(IP,ILM),IP=1,NGP)
      ELSE
         WRITE(IW6,967)MR,(LNGP(IP,ILM),IP=1,NGP)
      ENDIF
   20 CONTINUE
CN    GOTO 45
C-----------------------------------------------------------------------
C     WARNING MESSAGES (ONLY) FOR CAM-CLAYS
C-----------------------------------------------------------------------
CN 25 WRITE(IW6,935)
C
CN    DO 40 ILM=1,IEL
CN    J=NELPR(ILM)
CN    IC=NELCM(ILM)
CN    IF(IC.NE.1)GOTO 40
CN    MR=NELUS(ILM)
CN    IF(MCS(ILM).EQ.0)GOTO 37
CN    LT=LTYP(J)
CN    NGP=LINFO(11,LT)
CN    IF(NGP.GE.7) THEN
CN       WRITE(IW6,916)MR,(LCS(IP,ILM),IP=1,NGP)
CN    ELSE
CN       WRITE(IW6,966)MR,(LCS(IP,ILM),IP=1,NGP)
CN    ENDIF
CN 37 IF(MNGP(ILM).EQ.0)GOTO 40
CN    IF(NGP.GE.7) THEN
CN       WRITE(IW6,917)MR,(LNGP(IP,ILM),IP=1,NGP)
CN    ELSE
CN       WRITE(IW6,967)MR,(LNGP(IP,ILM),IP=1,NGP)
CN    ENDIF
CN 40 CONTINUE
CN 45 CONTINUE
      CALL OUTSM(IW6,ICCSM)
C-----------------------------------------------------------------------
C     PARAMETERS FOR ELASTO-PLASTIC MODEL
C-----------------------------------------------------------------------
   46 IF(NELP.EQ.0)GOTO 100
      IF(IOUT4.EQ.0)GOTO 72
      IF(IOUT4.EQ.1)WRITE(IW6,921)
      IF(IOUT4.EQ.1.AND.NDIM.EQ.2)WRITE(IW6,924)
      IF(IOUT4.EQ.1.AND.NDIM.EQ.3)WRITE(IW6,944)
      IF(IOUT4.EQ.2)WRITE(IW6,922)
      IF(IOUT4.EQ.2.AND.NDIM.EQ.2)WRITE(IW6,923)
      IF(IOUT4.EQ.2.AND.NDIM.EQ.3)WRITE(IW6,943)
C
      DO 70 ILM=1,IEL
      IC=NELCM(ILM)
      IF(IC.NE.2)GOTO 70
      MR=NELUS(ILM)
      J=NELPR(ILM)
      LT=LTYP(J)
      NGP=LINFO(11,LT)
      IF(MR.LT.NELOS.OR.MR.GT.NELOF)GOTO 55
C
      IF(IOUT4.EQ.1)GOTO 52
      IF(IOUT4.EQ.2)WRITE(IW6,904)MR
C
      DO 50 IGP=1,NGP
      IF(NDIM.EQ.2)WRITE(IW6,925)IGP,(VARC(IK,IGP,ILM),IK=1,6),
     + NMOD(IGP,J)
      IF(NDIM.EQ.3)WRITE(IW6,955)IGP,(VARC(IK,IGP,ILM),IK=1,3),
     + NMOD(IGP,J)
   50 CONTINUE
      GOTO 55
C
   52 CONTINUE
      IF(NDIM.EQ.2)WRITE(IW6,925)MR,(VARC(IK,NGP,ILM),IK=1,6),
     + (NMOD(IP,J),IP=1,NGP)
      IF(NDIM.EQ.3)WRITE(IW6,955)MR,(VARC(IK,NGP,ILM),IK=1,3),
     + (NMOD(IP,J),IP=1,NGP)
C-----------------------------------------------------------------------
C     WARNING MESSAGES - ELASTO-PLASTIC MODEL
C-----------------------------------------------------------------------
   55 IF(MCS(ILM).EQ.0)GOTO 62
C
      DO 60 IP=1,NGP 
c
      IDL=LCS(IP,ILM)
      IF(IDL.EQ.0)GOTO 60
      WRITE(IW6,928)MR,IP,(VLDL(IV,IDL),IV=1,NSTP)
   60 CONTINUE
C
   62 IF(MNGP(ILM).EQ.0)GOTO 70
      IF(NGP.GE.7) THEN
         WRITE(IW6,930)MR,(LNGP(IP,ILM),IP=1,NGP)
      ELSE
         WRITE(IW6,970)MR,(LNGP(IP,ILM),IP=1,NGP)
      ENDIF
   70 CONTINUE
      GOTO 100
C-----------------------------------------------------------------------
C     WARNING MESSAGES (ONLY) FOR ELASTO-PLASTIC MODEL
C-----------------------------------------------------------------------
   72 WRITE(IW6,935)
C
      DO 90 ILM=1,IEL
      J=NELPR(ILM)
      IC=NELCM(ILM)
      IF(IC.NE.2)GOTO 90
      MR=NELUS(ILM)
      LT=LTYP(J)
      NGP=LINFO(11,LT)
      IF(MCS(ILM).EQ.0)GOTO 82
C
      DO 80 IP=1,NGP
      IDL=LCS(IP,ILM)
      IF(IDL.EQ.0)GOTO 80
      WRITE(IW6,928)MR,IP,(VLDL(IV,IDL),IV=1,NSTP)
   80 CONTINUE
C
   82 IF(MNGP(ILM).EQ.0)GOTO 90
      IF(NGP.GE.7) THEN
         WRITE(IW6,930)MR,(LNGP(IP,ILM),IP=1,NGP)
      ELSE
         WRITE(IW6,970)MR,(LNGP(IP,ILM),IP=1,NGP)
      ENDIF
   90 CONTINUE
  100 CONTINUE
      RETURN
  901 FORMAT(2X,6HELM-IP,6X,2HPE,11X,1HQ,11X,2HPT,11X,
     + 2HPC,9X,3HETA,5X,5HETA/M,6X,2HYR,4X,6HE-STRS,3X,
     + 6HE-STRN,3X,4HTH-3,2X,4HCODE)
  902 FORMAT(127X,5HCODES/2X,6HELM-IP,6X,2HPE,11X,1HQ,11X,2HPT,11X,
     + 2HPC,9X,3HETA,5X,5HETA/M,6X,2HYR,4X,6HE-STRS,3X,
     + 6HE-STRN,3X,4HTH-3,2X,14H 1 2 3 4 5 6 7)
  904 FORMAT(I4)
  905 FORMAT(2X,I4,4E13.5,2F9.3,3X,F6.3,2F9.4,F7.1,2X,8I2/5X,19I3)
CC906 FORMAT(/18H CENTROID STRESSES/1X,17(1H-)/)
  911 FORMAT(/33H0CAM CLAY PARAMETERS AT CENTROIDS/
     + 1X,32(1H-)/)
  912 FORMAT(/42H0CAM CLAY PARAMETERS AT INTEGRATION POINTS/
     + 1X,41(1H-)/)
  916 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 24H HAS INTEGRATION POINTS ,7I2,27H APPROACHING CRITICAL STATE,
     + 2X,9I3/4X,11I3)
  917 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 23H AT INTEGRATION POINTS ,7I2,15H PE IS NEGATIVE,2X,20I3)
  966 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 24H HAS INTEGRATION POINTS ,4I2,27H APPROACHING CRITICAL STATE,
     + 2X,9I3/4X,11I3)
  967 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 23H AT INTEGRATION POINTS ,4I2,15H PE IS NEGATIVE,2X,20I3)
CRA    --- FORMAT FOR AVERAGE VOID RATIO ----
cra  968 FORMAT(/21H AVERAGE VOID RATIO :/13H FOR E-STRS: ,F9.4/
cra     + 13H FOR E-STRN: ,F9.4)
CRA   --- END OF FORMAT ----     
  921 FORMAT(/49H0PARAMETERS FOR ELASTO-PLASTIC MODEL AT CENTROIDS/
     + 1X,48(1H-)/)
  922 FORMAT(51H0PARAMETERS FOR ELASTO-PLASTIC MODEL AT INTEGRATION,
     + 7H POINTS/1X,57(1H-)/)
  923 FORMAT(2X,6HELM-IP,6X,2HPE,11X,4HSBAR,8X,5HTHETA,7X,
     + 1HS,12X,1HT,10X,5HTH-XY,2X,4HCODE/)
  924 FORMAT(2X,6HELM-IP,6X,2HPE,11X,4HSBAR,8X,5HTHETA,
     + 9X,1HS,12X,1HT,10X,5HTH-XY,2X,
     + 48H  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16/)
  925 FORMAT(2X,I4,2E14.5,F10.3,2E14.5,F10.3,2X,16I3)
  928 FORMAT(24H WARNING     AT ELEMENT ,I3,18H INTEGRATION POINT,I3,
     + 18H DLAMB IS NEGATIVE/1X,10E12.4)
  930 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 23H HAS INTEGRATION POINTS,7I2,27H UNLOADING TO ELASTIC STATE,
     + 10I3/96X,10I3)
  970 FORMAT(29H ******WARNING****** ELEMENT ,I3,
     + 23H HAS INTEGRATION POINTS,4I2,27H UNLOADING TO ELASTIC STATE,
     + 10I3/96X,10I3)
  935 FORMAT(//)
  943 FORMAT(2X,6HELM-IP,6X,2HPE,11X,4HSBAR,8X,5HTHETA,2X,4HCODE/)
  944 FORMAT(2X,6HELM-IP,6X,2HPE,11X,4HSBAR,8X,5HTHETA,
     + 2X,48H  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16,
     + 1X,32H17 18 19 20 21 22 23 24 25 26 27/)
  955 FORMAT(2X,I4,2E14.5,F10.3,2X,27I3)
      END
      SUBROUTINE VALFUN(SIGM,SBAR,TH,FNF,COH,PHI,KTN,MUS,IP)
C***********************************************************************
C     CALCULATE VALUE OF YIELD FUNCTION
C***********************************************************************
C
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
C
CC    WRITE(IW6,920)MUS,IP,KTN,SIGM,SBAR,COH,PHI
CC920 FORMAT(1X,'MUS =',I5,3X,'IP =',I5,3X,'KTN =',I5,3X,'SIGM =',E15.4,
CC   +       3X,'SBAR =',E15.4,3X,'COH =',E15.4,3X,'PHI =',E15.4)
      GO TO(1,2,3,4,5),KTN
      WRITE(IW6,900)KTN
  900 FORMAT(/1X,38H*** ERROR UNKNOWN YIELD CRITERION TYPE,I5,
     + 2X,16H(ROUTINE VALFUN))
      STOP
C-----------------------------------------------------------------------
C     VON MISES
C-----------------------------------------------------------------------
    1 SRT3=SQRT(3.)
      FNF=SRT3*SBAR-2.*COH
      RETURN
C-----------------------------------------------------------------------
C     TRESCA
C-----------------------------------------------------------------------
    2 FNF=2.*SBAR*COS(TH)-2.*COH
      RETURN
C-----------------------------------------------------------------------
C     DRUCKER PRAGER (OUTSCRIBING CIRCLE)
C-----------------------------------------------------------------------
    3 S=SIN(PHI)
      C=COS(PHI)
      SRT3=SQRT(3.)
      DENOM=SRT3*(3.-S)
      ALPHA=2.*S/DENOM
      AK=6.*COH*C/DENOM
      FNF=-ALPHA*SIGM+SBAR-AK
CC    WRITE(IW6,910)S,DENOM,ALPHA,AK,FNF
CC910 FORMAT(1X,'S =',E15.4,3X,'DENOM =',E15.4,3X,'ALPHA =',E15.4,
CC   +       3X,'AK =',E15.4,3X,'FNF =',E15.4)
      RETURN
C-----------------------------------------------------------------------
C     DRUCKER PRAGER (INSCRIBING CIRCLE)
C-----------------------------------------------------------------------
    5 S=SIN(PHI)
      C=COS(PHI)
      SRT3=SQRT(3.)
      DENOM=SQRT(9.+3.*S*S)
      ALPHA=S/DENOM
      AK=3.*COH*C/DENOM
      FNF=-ALPHA*SIGM+SBAR-AK
CC    WRITE(IW6,910)S,DENOM,ALPHA,AK,FNF
CC910 FORMAT(1X,'S =',E15.4,3X,'DENOM =',E15.4,3X,'ALPHA =',E15.4,
CC   +       3X,'AK =',E15.4,3X,'FNF =',E15.4)
      RETURN
C-----------------------------------------------------------------------
C     MOHR COULOMB
C-----------------------------------------------------------------------
    4 S=SIN(PHI)
      C=COS(PHI)
      SRT3=SQRT(3.)
      FNF=-SIGM*S/3.+SBAR*COS(TH)+SBAR*S*SIN(TH)/SRT3-COH*C
      RETURN
      END
      SUBROUTINE VARCAM(IP,MR,KM,ICS,INGP,IEL,NIP,NEL,NCODE,VARC,NCV,PR,
     +                  NTY,PE,QT,PCO,PYE,U,EV,EE,PC,ED,LED,NPR,NMT,
     +                  SGNQ,ICCSM)
C***********************************************************************
C *** FOR CAM-CLAYS ONLY  ***                                          *
C *** THIS ROUTINE DETERMINES THE CURRENT STRESS STATE AT THE          *
C *** END OF THE CURRENT INCREMENT AND USES IST TO INDICATE THE        *
C *** STRESS STATE OF THE INTEGRATION POINT WITH REFERENCE             *
C *** TO THE CURRENT YIELD LOCUS                                       *
C                                                                      *
C *** TYPE  CODE FOR STRESS STATES                     IST             *
C ***  0    SOIL IS ELASTIC   WITH P>PCS AND Q<M*P    - 0              *
C ***  1    SOIL IS ELASTIC   WITH P<PCS AND Q<M*P    - 1              *
C ***  2    SOIL IS ELASTIC   WITH P<PCS AND Q>M*P    - 2              *
C ***  3    SOIL IS HARDENING WITH P>PCS AND Q<M*P    - 3              *
C ***  4    SOIL IS SOFTENING WITH P<PCS AND Q>M*P    - 4              *
C ***  7    SOIL IS HARDENING WITH P>PCS AND Q>M*P    - 7              *
C ***  8    SOIL IS HARDENING WITH P<PCS AND Q>M*P    - 8              *
C                                                                      *
C *** WHERE    P - EFFECTIVE MEAN NORMAL STRESS                        *
C ***        PCS - CRITICAL STATE VALUE OF P                           *
C *** TYPES 7 AND 8 ARE IMPERMISSIBLE AND ARISE FROM NUMERICAL         *
C *** PROBLEMS.                                                        *
C***********************************************************************
      DIMENSION PR(NPR,NMT),NCODE(NIP,NEL),VARC(NCV,NIP,NEL)
      DIMENSION ED(LED),NTY(NMT),ICCSM(20)
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
C
      VLMX=30.
C
C *** FIND NEW YIELD LOCUS
C
      PC=ABS(PYE)
C *** EFFECTIVE P IS NEGATIVE
      IF(PE.LT.0.D0)GOTO 38
C *** SKIP IF EFFECTIVE P = 0
      IF(ABS(PE).LT.ASMVL) THEN
         PY=PCO
         EE=EV
         WRITE(IW6,666)MR,IP,QT,PCO
  666    FORMAT(1X,' PE = ZERO FOR ELEMENT =',I5,4X,'INT PT =',I4,
     +    3X,'Q =',E20.4,3X,'PCO =',E16.4)
      GOTO 21
      ELSE
         IF(NTY(KM).NE.3) GO TO 10
         PCS=PC/2.
         PY=PE+QT*QT/(PE*PR(4,KM)*PR(4,KM))
         GO TO 12
   10    PCS=PC/2.7182818
C
         VL=QT/(PR(4,KM)*PE)
         IF(VL.GT.VLMX) THEN
            PY=PE*EXP(VLMX)
            WRITE(IW6,920)MR,IP,QT,PE,PY,VL
  920       FORMAT(1X,'*** ELEMENT',I5,4X,'INT. POINT',I5,5X,'Q =',
     +      E15.4,4X,'PE =',E15.4,4X,'PY =',E15.4/4X,'QT/(M*PE) =',
     +      E15.4)
            IF(PY.GT.1.05*PC)PY=PC
            IF(PY.LT.0.95*PC)PY=PC
         ELSE
            PY=PE*EXP(QT/(PR(4,KM)*PE))
         ENDIF
   12    CONTINUE
      ENDIF
      IF(PY.GT.PC) GO TO 13
C *** MATERIAL IS EITHER ELASTIC OR HAS SOFTENED.
      IF(PE.GT.PCS) GO TO 14
C *** MATERIAL IS IN REGION 1 OR 2 OR 4
      IF(QT.GT.0.999*PR(4,KM)*PE) GO TO 15
C *** MATERIAL IS IN REGION 2 AND ELASTIC
      IST=1
      GO TO 17
   15 CONTINUE
C *** MATERIAL IS IN REGION 2 OR 4
      IF(PYE.LT.0.) GO TO 16
C *** MATERIAL IS ELASTIC AND IN REGION 2
  155 IST=2
      GO TO 17
   16 CONTINUE
      IF(ED(2).LT.ED(1)) GOTO 155
C *** MATERIAL HAS SOFTENED IN REGION 4
      IST=4
      PCS=PCS*PY/PC
      PC=PY
      GO TO 17
   14 CONTINUE
C *** MATERIAL IS IN REGION 0 AND ELASTIC
      IST=0
      GO TO 17
   13 CONTINUE
C *** MATERIAL HAS HARDENED
      IF(PE.GT.PCS) GO TO 18
C *** MATERIAL IS IN REGION 8 AND IS INVALID
      PCS=PCS*PY/PC
      PC=PY
      IST=8
      GO TO 17
   18 CONTINUE
C *** MATERIAL IS IN REGION 3 OR 7
      IF(QT.GT.1.001*PR(4,KM)*PE) GO TO 19
C *** MATERIAL IS IN REGION 3
      PCS=PCS*PY/PC
      PC=PY
      IST=3
      GO TO 17
C *** PE IS NEGATIVE
   38 CONTINUE
      PC=PCO
      PY=1.E10
      INGP=1
      IST=9
      WRITE(6,900)MR,IP,P,KM
  900 FORMAT(1X,' *** ELEMENT ',I5,4X,'INT. PT',I5,4X,
     +          'PE IS NEGATIVE',E16.5,4X,'MAT ZONE NUMBER',I5/
     +          1X,'(ROUTINE VARCAM)')
      P=1.
      IF(P.GT.0.1*PC)PE=0.1*PC
      GOTO 17
C *** MATERIAL IS IN REGION 7
   19 IST=7
      PC=PY
   17 WARN=QT/PE
      IF(WARN.LT.0.95*PR(4,KM)) WARN=0.
      WARN=(WARN-PR(4,KM))/PR(4,KM)
      IF(ABS(WARN).LT.0.05.AND.PYE.LT.0.) ICS=1
C
C   ***   CALCULATE NEW VOIDS RATIO
C
      IF(PE.GT.0.) GO TO 20
CC    WRITE(IW6,900)MR,IP,PC,PE
      INGP=1
      GO TO 21
   20 EE=PR(3,KM)-PR(1,KM)*ALOG(PE)-(PR(2,KM)-PR(1,KM))*ALOG(PCS)
   21 CONTINUE
CC900 FORMAT(1X,19H****WARNING ELEMENT,I4,1X,22HHAS  PE LESS THAN 0 AT,
CC   + I4,17HINTEGRATION POINT,I5,5H PC= ,E12.4,5H PE= ,E12.4)
C
      VARC(1,IP,IEL)=PE
      VARC(2,IP,IEL)=SGNQ*QT
      VARC(3,IP,IEL)=PE+U
      VARC(4,IP,IEL)=PC
      IF(ABS(PE).LT.ASMVL) THEN
         VARC(5,IP,IEL)=999.
         VARC(6,IP,IEL)=999.
      ELSE
         VARC(5,IP,IEL)=QT/PE
         VARC(6,IP,IEL)=QT/(PR(4,KM)*PE)
      ENDIF
      VARC(7,IP,IEL)=PY/PCO
      VARC(8,IP,IEL)=EE
      VARC(9,IP,IEL)=EV
      NCODE(IP,IEL)=IST
C
      KGO=NTY(KM)
      CALL CCSTRS(IST,PY,PCO,ICS,KGO,ICCSM)
C
      RETURN
      END
      SUBROUTINE WRTN(N,A,M)
C***********************************************************************
C     WRITES ONE DIMESNIONAL ARRAY
C***********************************************************************
      DIMENSION A(M)
      WRITE(N) A
      RETURN
      END
      SUBROUTINE YIELD(IP,J,MR,SS,MAT,NEL,NIP,NVRS,VARINT,PR,NPR,NMT,
     + VARO,NMOD,IEL,IDL,NELP,VLDL,VLAMB,NVL,
     + LDLM,LULP,MDLM,MULP,NELCM,VARC,NCV,NSTP,NDIM,NS,NGP,
     + ELCOD,SHFN,NDN)
C
C***********************************************************************
C     FOR ELASTO-PLASTIC MODELS CARRY OUT YIELD SURFACE CORRECTION
C     FOR YIELDED POINTS. THE PLASTIC STRESS COMPONENTS ARE EVALUATED
C     IN SMALL STEPS
C***********************************************************************
C
      DIMENSION VARINT(NVRS,NIP,NEL),VLDL(NSTP,NVL),NELCM(NEL),
     + LDLM(NIP,NEL),LULP(NIP,NEL),MDLM(NEL),MULP(NEL),
     + VARC(NCV,NIP,NEL),MAT(NEL),NMOD(NIP,NEL),PR(NPR,NMT),
     + ELCOD(NDIM,NDN),SHFN(NDN)
      DIMENSION SS(6),SSP(6),SSPI(6),A(6),DBAR(6),VLAMB(NSTP),VARO(6)
      DIMENSION VARI(6),SPA(3)
      COMMON /PARS  / PYI,ALAR,ASMVL,ZERO
      COMMON /DEVICE/ IR1,IR4,IR5,IW2,IW4,IW6,IW7,IWP,IW9
      COMMON /ELASP / NDLM,NULP
      DATA CONV/57.295779513/
C
      IF(IP.NE.1)GO TO 20
      NDLM=0
      NULP=0
C
   20 KM=MAT(J)
      KT=IFIX(PR(6,KM))
      YY=ZERO
      DO 5 IN=1,NDN
    5 YY=YY+SHFN(IN)*ELCOD(2,IN)
C
      COH=PR(3,KM)+PR(12,KM)*(PR(5,KM)-YY)
      PHI=PR(4,KM)
      CALL INVAR(VARINT(1,IP,J),NS,SBAR,SIGM,THETA,NDIM)
      CALL VALFUN(SIGM,SBAR,THETA,FNF,COH,PHI,KT,MR,IP)
C-----------------------------------------------------------------------
C     CHECK PREVIOUS STATE
C-----------------------------------------------------------------------
      IF(NMOD(IP,J).NE.0) GO TO 75
C-----------------------------------------------------------------------
C     INITIALLY ELASTIC STATE
C-----------------------------------------------------------------------
      IF(FNF)155,30,35
   30 NMOD(IP,J)=1
      GO TO 155
C-----------------------------------------------------------------------
C     FIRST YIELD
C-----------------------------------------------------------------------
   35 CALL INVAR(VARO,NS,SBARO,SIGMO,THETAO,NDIM)
      CALL VALFUN(SIGMO,SBARO,THETAO,FNFO,COH,PHI,KT,MR,IP)
      RA=-FNFO/(FNF-FNFO)
C-----------------------------------------------------------------------
C     CALCULATE INTERMEDIATE STRESS STATE ON THE YIELD SURFACE.
C-----------------------------------------------------------------------
      DO 54 I54=1,NS
      VARI(I54)=VARO(I54)+RA*SS(I54)
   54 SSP(I54)=(1.-RA)*SS(I54)
C-----------------------------------------------------------------------
C     ENTER SUB INCREMENT LOOP WHERE PLASTIC STRESSES ARE EVALUATED IN
C     SMALL INCREMENTS. ALSO THE STRESS STATE IS CORRECTED BACK TO THE
C     YIELD SURFACE.
C-----------------------------------------------------------------------
      NMOD(IP,J)=1
   55 NI=NSTP
      ILAMB=0
      FNTSP=1./FLOAT(NI)
      DO 56 I5=1,NS
   56 SSPI(I5)=SSP(I5)*FNTSP
C
      DO 70 II=1,NI
C-----------------------------------------------------------------------
C     CALCULATE DEP - PLASTIC D MATRIX
C-----------------------------------------------------------------------
      CALL DEPT(IP,J,NEL,MAT,A,DBAR,BBAR,VARI,NDIM,NDN,NS,PR,NPR,NMT,
     +          ELCOD,SHFN)
      DLAMB=(A(1)*SSPI(1)+A(2)*SSPI(2)+A(3)*SSPI(3)+A(4)*SSPI(4))/BBAR
      IF(NDIM.EQ.3)DLAMB=DLAMB+(A(5)*SSPI(5)+A(6)*SSPI(6))/BBAR
      IF(DLAMB.GE.ZERO) GOTO 59
      ILAMB=ILAMB+1
      VLAMB(ILAMB)=DLAMB
      DLAMB=ZERO
C
   59 DO 62 I6=1,NS
   62 VARI(I6)=VARI(I6)+SSPI(I6)-DLAMB*DBAR(I6)
C
      CALL INVAR(VARI,NS,SBARN,SIGMN,THN,NDIM)
      CALL VALFUN(SIGMN,SBARN,THN,FNFI,COH,PHI,KT,MR,IP)
C-----------------------------------------------------------------------
C     CORRECT STRESSES BACK TO YIELD SURFACE
C-----------------------------------------------------------------------
      DENOM=A(1)*A(1)+A(2)*A(2)+A(3)*A(3)+A(4)*A(4)
      IF(NDIM.EQ.3)DENOM=DENOM+A(5)*A(5)+A(6)*A(6)
      CONST=FNFI/DENOM
C
      DO 64 I6=1,NS
   64 VARI(I6)=VARI(I6)-A(I6)*CONST
   70 CONTINUE
C
CC    IF(ILAMB.GT.0)WRITE(IW6,915)IP,(VLAMB(JX),JX=1,ILAMB)
CC915 FORMAT(1X,3HIP=,I2,1X,7HDLAMB =,1X,10E11.3)
      IF(ILAMB.EQ.0)GO TO 74
      NDLM=NDLM+1
      IDL=IDL+1
      IF(IDL.LE.NVL)GOTO 71
      WRITE(IW6,921)
  921 FORMAT(1X,'*** TOO MANY INTEGRATION POINTS WITH',2X,
     + 'DLAMBDA NEGATIVE'/1X,'INCREASE SIZE OF ARRAY VLDL',1X,
     + 'AND ALSO RESET NVL IN ROUTINE MAXVAL - ROUTINE YIELD')
      STOP
   71 LDLM(IP,IEL)=IDL
      DO 72 ICN=1,ILAMB
   72 VLDL(ICN,IDL)=VLAMB(ICN)
C
   74 CALL INVAR(VARI,NS,SBAR,SIGM,THETA,NDIM)
      GOTO 90
C-----------------------------------------------------------------------
C     INITIALLY PLASTIC STATE
C-----------------------------------------------------------------------
   75 IF(FNF.LT.ZERO)GOTO 77
      GOTO 78
C-----------------------------------------------------------------------
C     HAS UNLOADED TO ELASTIC STATE
C-----------------------------------------------------------------------
   77 NMOD(IP,J)=0
CC    WRITE(IW6,927)MR,IP,FNF
CC927 FORMAT(10H ELEMENT =,I4,2X,6HI.P. =,I3,2X,3HF =,F12.8,2X,
CC   + 29HHAS UNLOADED TO ELASTIC STATE)
      NULP=NULP+1
      LULP(IP,IEL)=IP
      GOTO 155
C-----------------------------------------------------------------------
C     PREVIOUSLY ON YIELD SURFACE - CONTINUES TO YIELD
C     ENTER SUB INCREMENT LOOP
C-----------------------------------------------------------------------
   78 DO 80 I8=1,NS
      VARI(I8)=VARO(I8)
   80 SSP(I8)=SS(I8)
      NMOD(IP,J)=2
      GO TO 55
C-----------------------------------------------------------------------
C     CALCULATE CORRECTED STRESSES
C-----------------------------------------------------------------------
   90 DO 100 KV=1,NS
  100 VARINT(KV,IP,J)=VARI(KV)
C
      CALL INVAR(VARINT(1,IP,J),NS,SBAR,SIGM,THETA,NDIM)
  155 VARC(1,IP,IEL)=SIGM/3.
      VARC(2,IP,IEL)=SBAR
      VARC(3,IP,IEL)=THETA*CONV
C
      IF(NDIM.EQ.3)GOTO 170
      CALL PRINC(VARINT(1,IP,J),VARINT(2,IP,J),VARINT(4,IP,J),SPA)
      VARC(4,IP,IEL)=0.5*(SPA(1)+SPA(2))
      VARC(5,IP,IEL)=0.5*(SPA(1)-SPA(2))
      VARC(6,IP,IEL)=SPA(3)
C
CRA   NOTE: SPA(1) AND SPA(2): MAJOR AND MINOR PRINCIPAL STRESSES
CRA         SPA(3) : ANGLE BETWEEN X-AXIS AND MAJOR STRESS
  170 CONTINUE
      IF(IP.NE.NGP)GO TO 200
      NELCM(IEL)=2
      IF(NDLM.NE.0)MDLM(IEL)=1
      IF(NULP.NE.0)MULP(IEL)=1
      NELP=NELP+1
  200 RETURN
      END
      SUBROUTINE ZEROI1(N,LN)
C***********************************************************************
C     ROUTINE TO INITIALISE A 1-DIMENSIONAL INTEGER ARRAY
C***********************************************************************
      DIMENSION N(LN)
C
      DO 10 I=1,LN
   10 N(I)=0
      RETURN
      END
      SUBROUTINE ZEROI2(N,L1,L2)
C***********************************************************************
C     ROUTINE TO INITIALISE A 2-DIMENSIONAL INTEGER ARRAY
C***********************************************************************
      DIMENSION N(L1,L2)
C
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 N(I,J)=0
      RETURN
      END
      SUBROUTINE ZEROR1(V,LV)
C***********************************************************************
C     ROUTINE TO INITIALISE A 1-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(LV)
C
      DO 10 I=1,LV
   10 V(I)=0.
      RETURN
      END
      SUBROUTINE ZEROR2(V,L1,L2)
C***********************************************************************
C     ROUTINE TO INITIALISE A 2-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(L1,L2)
C
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 V(I,J)=0.
      RETURN
      END
      SUBROUTINE ZEROR3(V,L1,L2,L3)
C***********************************************************************
C     ROUTINE TO INITIALISE A 3-DIMENSIONAL REAL ARRAY
C***********************************************************************
      DIMENSION V(L1,L2,L3)
C
      DO 10 K=1,L3
      DO 10 J=1,L2
      DO 10 I=1,L1
   10 V(I,J,K)=0.
      RETURN
      END         
