program framedevelopment ; {Rev 22/6/94 CS}

         { Calculate coordinates for full 24.4mm external
           diameter frame development with hyperbolae offset }

uses dos,crt;


const a = 22.032 ;
      b = 15.574 ;
      E = 22.332 ;
      r = 12.2 ;
      offset = 0.23 ;
      hmax = 18.5 ;

         { Constants as defined by mathematically
           described frame geometry, Ho=offset    }


var n,k,i : integer ;
    theta,h,d,dmax : real ;
    c : char;
    f : text ;

procedure hcalc (var angle,p: real) ;
 var s,t,u,v,w,z: real ;
  begin
   s:= sqr(r*cos(angle) - offset) ;
   t:= sqr(r)*(1-sqr(cos(angle)))/3 ;
   u:= sqrt(abs(s-t)) ;
   v:= sqr((E-u-offset)/a) ;
   w:= 1-v ;
   z:= sqrt(abs(sqr(b)*w)) ;
   p:= hmax - z ;
  end ;

         { Procedure for single frame
           height calculation given
           value of theta. From Equation 5**   }

begin

assign(f,'a:framedev.asc') ; rewrite (f) ;

clrscr;

 n:= 0 ;
 theta:= 0 ;
 dmax:= 0;

for i:=1 to 3 do
begin

  begin
   for n:=0 to 10 do
    begin
     theta:= n*pi/36 ;
     hcalc (theta,h) ;
     d:= dmax + (theta*r) ;
     writeln(f,d:7:3,'      ',h:7:3) ;
    end ;

         { Calculates theta over desired range
           for input into hcalc procedure.
           Evaluates circumferential distance for
           each value of theta.                   }

   for n:=1 to 20 do
    begin
     theta:= (10+n*(0.09066157))*pi/36 ;
     hcalc (theta,h) ;
     d:= dmax + (theta*r) ;
     writeln(f,d:7:3,'      ',h:7:3) ;
    end;

 dmax:= dmax + ((10+20*(0.09066157))*pi/36 + 1.8677*pi/180)*r ;

         { Expansion for points at stent post.
           dmax redefined                      }

   for k:=20 downto 1 do
    begin
     theta:= (10 + k*(0.09066157))*pi/36 ;
     hcalc (theta,h) ;
     d:= dmax + (20-k)*(0.09066157)*pi/36*r ;
     writeln(f,d:7:3,'      ',h:7:3) ;
    end ;

         { Repeat of previous procedure for theta
           as decreasing function, input into hcalc.
           Circumferential distance evaluated for
           each polar rotation angle, theta.         }

   for k:=10 downto 0 do
    begin
     theta:= k*pi/36 ;
     hcalc (theta,h) ;
     d:= dmax + (10 + 20*(0.09066157) -k)*pi/36*r ;
     writeln(f,d:7:3,'      ',h:7:3) ;
    end;
 end;

         { Theta evaluation as decreasing function
           at stent post.                          }

 dmax:= dmax + (10 + 20*(0.09066157))*pi/36*r ;

         { dmax redefined }

end;

close(f);

end.