program profile;  {Rev 8:8:94 CS}

         {Calculates hyperbolae coordinates, arc lengths
          circumferential lengths and equivalent radii for
          a range of "valve-z" values.                     }


uses dos,crt;

const  a= 22.032 ;
       b= 15.574 ;
       E= 22.332 ;
       H= 0.23 ;
       r= 11.2 ;
       zmax= 13.44 ;

var  x: array[0..200] of real ;
     y: array[0..200] of real ;
     z: array[0..10] of real ;
     xmax,ymax: real ;
     L,d,alpha,s,t,u,v: real ;
     post,theta,circ,total,p,rad:real;
     i,zindex: integer;
     f: text;
     c: char;


procedure calcpts (var m,n:real);

 var i: integer;
 begin
 for i:= 0 to 200 do
  begin
   y[i]:= i*m/200;
   x[i]:= H + sqrt(sqr(n) + sqr(y[i])/3);

  end;
 end;

         {Calculates a series of (x,y) coordinates on
          a hyperbola for a given z position, over a
          range -ymax..ymax.                          }


procedure calclength (var length:real) ;

 var d: real;
     i:integer;

 begin

 length:= 0;
 for i:= 1 to 200 do
  begin
   d:= sqrt(sqr(x[i]-x[i-1]) + sqr(y[i]-y[i-1]));
   length:= length+d;
  end;
 end;

         {Approximates hyperbola arc length from sum
          of straight-line inter-coordinate distances.}

procedure calccirc (var circ,p: real);

 var theta: real;
     post:real;


 begin

  theta:= arctan(ymax/xmax);
  post:= (2*pi - 6*theta)*r ;
  circ:= 6*L + post;
  p:= circ/(2*pi);

 end;

         {Calculates contribution to circumference by the
          stent posts. Adds this to arc length. Calculates
          radius.                                          }

***************Main Program***********************

begin

assign(f,'a:hyper.asc') ; rewrite(f);

clrscr;

writeln(f,'    ','Z','       ','Length','   ','Circumf.','   ','Radius');

 for zindex:= 0 to 10 do
  begin
    z[i]:= zindex/10 * zmax ;
    s:= 1-sqr(z[i]/b);
    t:= a*sqrt(s);
    alpha:= E-H-t;

    u:= sqr(alpha) + sqr(r)/3 - sqr(H);
    v:= sqrt(4*sqr(H) + 16/3*u);
    xmax:= 3/8*(2*H + v);
     if (r-xmax)>0.0000001 then
      ymax:= sqrt(sqr(r) - sqr(xmax))
     else ymax:= 0;

         {Calculates hyperbola major axis distance. From this
          we calculate the (xmax,ymax) coordinates of the
          frame/hyperbola intersection.                        }


    calcpts(ymax,alpha);
    calclength(L);
    calccirc(total,rad);
    writeln(f,z[i]:7:3,'    ',2*L:7:3,'   ',total:7:3,'   ',rad:7:3);


  end;

close(f);

end.

