program templt;  {HPLG of frame template ACF&CS }



uses dos,crt,printer;

var count, filelength : integer;
    genstring : string;
    dummystring : array[1..3] of string;
    xycoords : array[1..186,1..2] of real;


procedure readinfile;

var fname : string;
    filename : text;

begin
  clrscr;
  {write('Input file name for frame coords ');
  readln(fname);}
  fname := 'frame1.asc';
  assign(filename,fname);
  reset(filename);
  for count := 1 to 3 do
    begin
      readln(filename,dummystring[count]);
      writeln(dummystring[count]);
    end;
  count := 1;
  repeat
    begin
      readln(filename,xycoords[count,1],xycoords[count,2]);
      writeln(xycoords[count,1],'  ',xycoords[count,2],'  ',count);
      inc(count);
    end;
  until eof(filename);
  filelength := count-1;
  writeln('File length = ',filelength);
end;


procedure init_graph_space;

var calfactx, calfacty : real;   {empirical corrections to LaserJet IIP HPLG}

begin
  calfactx := 97.20/100.0;
  calfacty := 49.76/50.0;
  writeln(lst,'IN;PA0,0;PD;PA200,0;PA0,0;PA0,200;PU'); {show true 0,0}
  writeln(lst,'IN;IP160,400,11040,7200'); {select a working area}
  writeln(lst,'SC0,',round(2800*calfactx),',0,',round(1700*calfacty),';SP1;PU'); {map space in 0.1 mm units}
  writeln(lst,'PA2700,1700;PD;PR-50,-50;PU;'); {mark top left corner}
  writeln(lst,'PW.1;LT2;'); {set dashed line}
  writeln(lst,'PA50,50;PD;EA2600,1500;PU;'); {do a box 255 by 145 mm}
  writeln(lst,'LT;PU;'); {restore line style}
end;

procedure do_labels;

var ypos : integer;

begin
  ypos := 1300;
  for count := 1 to 3 do
  begin
    writeln(lst,'PU;PA300,',ypos,';LB'+dummystring[count],','#3);
    ypos := ypos-100;
  end;
end;

procedure do_plot;

var offsetx, offsety : integer;
begin
  writeln(lst,'PU;'); {lift pen up}
  for count := 1 to filelength do
    begin
      offsetx := 750; offsety := 500; {shift origin to 100,50 mm offset}

writeln(lst,'PD;PA',round(10*xycoords[count,1]+offsetx),',',round(10*xycoords[
count,2]+offsety),';');
    end;
  writeln(lst,'PU;PA',offsetx,',500;PD;PR1000,0;PR0,500;PU;'); {scale bars}
end;


{............ main prog ..........}

begin
  writeln(lst,#27,'%0B'); {init HPGL}
  init_graph_space;
  readinfile;
  do_labels;
  do_plot;
  writeln(lst,#27,'%0A',#27,'E'); {init PCL & form feed}
end.
