
/*
 *  Data for DCSP test programs on PC 
 */

#include <stdio.h>
#include "set_op.h"
#include <math.h> 
#include <signal.h> 
#include <parallel/microtask.h> 
#include <parallel/parallel.h> 




#define  TRUE 1
#define  FALSE 0
#define  MAXLINE 120
#define  MAXCHAR 80
#define  MAX_AGENT 25 
#define  MAX_PROCESSOR 10 
#define  MAX_DOMAIN 16 
#define  MAX_DATA 10 
#define  MAX_ORDER 120 
#define  MAX_GROUP 10 
#define  MAX_BOX 10 
#define  BITE 5 
#define  SOL_LEN 100 



typedef struct info INFO;

typedef struct agent_home AGENT_HOME;

typedef struct proc_home  PROC_HOME;

struct info			/* the info for agents */
{
  SET set1;
  SET set2;
  struct info *view_ptr;
  struct info *next;
  struct info *front;
  int   id;
  int   to_id;
  int   value;
  int   length;
  int   order;
  int   logical_time;
  int   mail_no;
  int   mail_number;
  int   part_solution[MAX_AGENT];
  int   part_order[MAX_AGENT];
};

struct agent_home		/* for variable */
{
  SET domain;
  SET avail_domain;
  SET past_fc;
  SET future_fc;
  SET conf_set;
  struct info *value_view_ptr;
  struct info *view_tail_ptr;
  struct info *position_ptr[MAX_AGENT];
  struct info *nogood_ptr;
  struct info *message_ptr;
  struct info *move_nogood_ptr;
  int   relation[MAX_AGENT];
  int   in_link[MAX_AGENT];
  int   out_link[MAX_PROCESSOR];
  int   to_be_sent;
  int   logical_time;
  int   logical_time2;
  int   next_id;
  int   going_value[MAX_AGENT];
  int   my_id;
  int   my_value;
  int   processor_id;
  int   order;
  int   rel_length;
  int   dom_length;
  int   avail_length;
  int   dom_choice;
  int   apply_count;
  int   apply_arc_count;
  int   message_count;
  int   rece_count;
  int   back_count;
  int   help_count;
  int   ask_count;
  int   ok_count;
  int   undo_count;
  int   block_send;
  int   block_rece;
  int   temp_rece;
  int   temp_send;
  int   time_count;
  int   send_place;
};

struct proc_home		/* for processor */
{
  struct info *message_ptr;
  struct info *tail_ptr;
  struct info *part_solution_ptr;
  struct info *solution_tail_ptr;
  int   id;
  int   status;
  int   work_again;
  int   wait_proc;
  int   proc_wait;
  int   lower_order;
  int   high_order;
  int   terminated;
  int   wait_signal;
  int   values[MAX_AGENT];
  int   orders[MAX_AGENT];
  int   places[MAX_AGENT];
  int   nothing_to_do;
  int   got_message;
  int   relation_link[MAX_AGENT];
  int   sol_length;
  int   mail_numbers[MAX_PROCESSOR];
  int   mail_no[MAX_PROCESSOR];
  int   mail_val[MAX_PROCESSOR];
  int   mail_id[MAX_PROCESSOR];
  int   mail_to_id[MAX_PROCESSOR];
  int   mail_lt[MAX_PROCESSOR];
  int   mail_lt2[MAX_PROCESSOR];
  int   mail_pid[MAX_PROCESSOR];
};

