/*
 *  Routines to handle sets.
 */

#include "set_op.h"

static int  get_bit_pos (word_ptr, bit_ptr, elem)
int  *word_ptr,
     *bit_ptr;
ELEMENT elem;
{
  *word_ptr = elem / _WORD_SIZE;
  *bit_ptr = elem % _WORD_SIZE;
  return elem >= SET_MIN && elem <= SET_MAX;
}

static  void set_bits (s, elem, inset)
        SET s;
ELEMENT elem;
int   inset;
{
  int   word,
        bit;

  if (get_bit_pos (&word, &bit, elem))
    if (inset != 0)
      s[word] |= (01 << bit);
    else
      s[word] &= ~(01 << bit);

}

static int  get_bit (s, elem)
            SET s;
ELEMENT elem;
{
  int   word,
        bit;

  return get_bit_pos (&word, &bit, elem) ? (s[word] >> bit) & 01 : 0;
}

void set_Add (s, elem)
SET s;
ELEMENT elem;
{
  set_bits (s, elem, 1);
}

void set_Del (s, elem)
SET s;
ELEMENT elem;
{
  set_bits (s, elem, 0);
}

int   set_Mem (s, elem)
      SET s;
ELEMENT elem;
{
  return get_bit (s, elem);
}

void set_Empty (s)
SET s;
{
  int   i;

  for (i = 0; i < _SET_WORDS; s[i++] = 0)
    ;
}

void set_Emptyn (s, max)
SET s;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; s[i++] = 0)
    ;
}

void set_Union (x, y, res)
SET x, y, res;
{
  int   i;

  for (i = 0; i < _SET_WORDS; i++)
    res[i] = x[i] | y[i];
}

void set_Unionn (x, y, res, max)
SET x, y, res;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
    res[i] = x[i] | y[i];
}

void set_Assign (x, y)
SET x, y;
{
  int   i;

  for (i = 0; i < _SET_WORDS; i++)
    x[i] = y[i];
}

void set_Assignn (x, y, max)
SET x, y;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
    x[i] = y[i];
}

void set_Inter (x, y, res)
SET x, y, res;
{
  int   i;

  for (i = 0; i < _SET_WORDS; i++)
    res[i] = x[i] & y[i];
}

void set_Intern (x, y, res, max)
SET x, y, res;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
    res[i] = x[i] & y[i];
}

void set_Exclor (x, y, res)	/* Exclusive OR */
SET x, y, res;
{
  int   i;

  for (i = 0; i < _SET_WORDS; i++)
    res[i] = x[i] ^ y[i];
}

void set_Exclorn (x, y, res, max)/* Exclusive OR n */
SET x, y, res;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
    res[i] = x[i] ^ y[i];
}

void set_Minus (x, y, res)	/* res = x - ( x & y ) */
SET x, y, res;
{
  int   i;
  int   bound;

  bound = _SET_WORDS;

  for (i = 0; i < bound; i++)
    res[i] = (x[i] ^ y[i]) & (~y[i]);
}

void set_Minusn (x, y, res, max)/* res = x - ( x & y ) */
SET x, y, res;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
    res[i] = (x[i] ^ y[i]) & (~y[i]);
}


void set_IntDel (x, y, res1, res2)
				/* res1 = x & y; res2 = x - ( x & y ) */
SET x, y, res1, res2;
{
  int   i;
  int   bound;

  bound = _SET_WORDS;

  for (i = 0; i < bound; i++)
  {
    res1[i] = x[i] & y[i];
    res2[i] = x[i] & (~res1[i]);
  }
}

void set_IntDeln (x, y, res1, res2, max)
/* res1 = x & y; res2 = x - ( x & y ) */
SET x, y, res1, res2;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
  {
    res1[i] = x[i] & y[i];
    res2[i] = x[i] & (~res1[i]);
  }
}

/* compare two sets, if the same return 1 otherwise return 0 */


/* someday later, we could add max to set operation which
   could cut down the counting cost (max / _WORD_SIZE ) + 1 */
int   set_Com (x, y)
      SET x, y;
{
  int   i;
  int   bound;

  bound = _SET_WORDS;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != y[i])
    {
      return 0;
    }
  }

  return 1;

}

/* compare two sets, if the same return 1 otherwise return 0 */

/* max can be added to set operation which
   could cut down the counting cost (max / _WORD_SIZE ) + 1 */
int   set_Comn (x, y, max)
      SET x, y;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != y[i])
    {
      return 0;
    }
  }

  return 1;

}

/* the relationship between x and y: return same 1; x in y 2, y in x 3 
   otherwise 0 */

int   set_Rel (x, y)
      SET x, y;
{
  int   flag;
  int   i;
  SET res;
  int   bound;

  bound = _SET_WORDS;

  flag = set_Com (x, y);
  if (flag)
  {
    return 1;			/* the same */
  }
 /* set_Inter(x, y, res); */
  for (i = 0; i < bound; i++)
    res[i] = x[i] & y[i];

  flag = set_Com (x, res);
  if (flag)
  {
    return 2;			/* x in y */
  }

  flag = set_Com (y, res);
  if (flag)
  {
    return 3;			/* y in x */
  }

  return 0;			/* x and y have no much relationship */

}

/* the relationship between x and y: return same 1; x in y 2, y in x 3 
   otherwise 0 */

int   set_Reln (x, y, max)
      SET x, y;
int   max;
{
  int   flag;
  int   i;
  SET res;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  flag = set_Comn (x, y, max);
  if (flag)
  {
    return 1;			/* the same */
  }
 /* set_Inter(x, y, res); */
  for (i = 0; i < bound; i++)
    res[i] = x[i] & y[i];

  flag = set_Comn (x, res, max);
  if (flag)
  {
    return 2;			/* x in y */
  }

  flag = set_Comn (y, res, max);
  if (flag)
  {
    return 3;			/* y in x */
  }

  return 0;			/* x and y have no much relationship */

}

int   set_Ele (x)		/* if the set is empty, return 0 otherwise
				   1 */
      SET x;
{
  int   i;
  int   bound;

  bound = _SET_WORDS;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != 0)
    {
      return 1;			/* not empty */
    }
  }
  return 0;			/* empty */
}

int   set_Elen (x, max)		/* if the set is empty, return 0 otherwise
				   1 */
      SET x;
int   max;
{
  int   i;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != 0)
    {
      return 1;			/* not empty */
    }
  }
  return 0;			/* empty */
}


int   set_First (x)		/* find the first element in the set */
      SET x;
{
  int   i;
  int   j;
  int   bit;
  int   bound;
  bound = _SET_WORDS;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != 0)
    {
      bit = x[i];
      for (j = 0; j < _WORD_SIZE; j++)
      {
	if ((bit & 01) != 0)
	{
	  break;
	}
	bit = bit >> 1;
      }
      break;
    }
  }
  if (i >= bound || j >= _WORD_SIZE)
  {
    return - 1;
  }
  return (i * _WORD_SIZE) + j;
}

int   set_Firstn (x, max)	/* find the first element in the set */
      SET x;
int   max;
{
  int   i;
  int   j;
  int   bit;
  int   bound;

  bound = (max / _WORD_SIZE) + 1;

  for (i = 0; i < bound; i++)
  {
    if (x[i] != 0)
    {
      bit = x[i];
      for (j = 0; j < _WORD_SIZE; j++)
      {
	if ((bit & 01) != 0)
	{
	  break;
	}
	bit = bit >> 1;
      }
      break;
    }
  }
  if (i >= bound || j >= _WORD_SIZE)
  {
    return - 1;
  }
  return (i * _WORD_SIZE) + j;
}



