

/*----------------------------------------------------------------*/
/* Distributed and sequential search algorithms (discrete domain) */
/* to solve distributed constraint satisfaction problems (DCSPs)  */
/* 8/Feb/93 the first version        				  */
/*----------------------------------------------------------------*/

#include "dcsp_alg.h"


/* for DCSP */

/* statistics data */

int   min_apply = 1000000;
int   min_arc = 1000000;
int   min_back = 1000000;
int   min_send = 1000000;
int   min_clear = 1000000;
int   min_rece = 1000000;
int   min_block_s = 1000000;
int   min_block_r = 1000000;
int   min_ask = 1000000;
int   min_help = 1000000;
int   min_ok = 1000000;
int   min_undo = 1000000;
int   min_time1 = 1000000;
int   min_time2 = 1000000;

int   max_apply = 0;
int   max_arc = 0;
int   max_back = 0;
int   max_send = 0;
int   max_clear = 0;
int   max_rece = 0;
int   max_block_s = 0;
int   max_block_r = 0;
int   max_ask = 0;
int   max_help = 0;
int   max_undo = 0;
int   max_ok = 0;
int   max_time1 = 0;
int   max_time2 = 0;



int   temp_apply[10];
int   temp_arc[10];
int   temp_send[10];
int   temp_clear[10];
int   temp_rece[10];
int   temp_block_s[10];
int   temp_block_r[10];
int   temp_ok[10];
int   temp_back[10];
int   temp_ask[10];
int   temp_help[10];
int   temp_undo[10];
int   temp_time1[10];
int   temp_time2[10];


int   an_apply,
      an_arc,
      an_back,
      an_send,
      an_rece,
      an_block_r,
      an_block_s,
      an_time1,
      an_time2;

double  sd_apply,
        sd_arc,
        sd_back,
        sd_send,
        sd_rece,
        sd_block_r,
        sd_block_s,
        sd_time1,
        sd_time2;


int   balance[MAX_DATA][MAX_PROCESSOR];

int   min_p_apply = 1000000;
int   min_p_arc = 1000000;
int   min_p_back = 1000000;
int   min_p_send = 1000000;
int   min_p_rece = 1000000;
int   min_p_b_s = 1000000;
int   min_p_b_r = 1000000;

int   max_p_apply = 0;
int   max_p_arc = 0;
int   max_p_back = 0;
int   max_p_send = 0;
int   max_p_rece = 0;
int   max_p_b_s = 0;
int   max_p_b_r = 0;

int   temp_p_apply[MAX_PROCESSOR][10];
int   temp_p_arc[MAX_PROCESSOR][10];
int   temp_p_send[MAX_PROCESSOR][10];
int   temp_p_rece[MAX_PROCESSOR][10];
int   temp_p_b_s[MAX_PROCESSOR][10];
int   temp_p_b_r[MAX_PROCESSOR][10];
int   temp_p_back[MAX_PROCESSOR][10];


int   an_p_apply,
      an_p_arc,
      an_p_back,
      an_p_send,
      an_p_rece,
      an_p_b_r,
      an_p_b_s;

double  sd_p_apply,
        sd_p_arc,
        sd_p_back,
        sd_p_send,
        sd_p_rece,
        sd_p_b_r,
        sd_p_b_s;

/* global marks */

shared int  OPT = FALSE;
shared int  CONFLICT = FALSE;
shared int  AUTO_ALLOCAT = FALSE;
private int PRINT = FALSE;
shared int  PRINT2 = FALSE;
shared int  ZEBRA = FALSE;
shared int  SINGLE = FALSE;
shared int  MULTI = FALSE;
shared int  FC = 1;
shared int  PS = 0;
shared int  BAL = FALSE;
shared int  SHA = FALSE;
shared int  D_O = FALSE;	/* dynamic order */
shared int  HEURISTIC;		/* 1 domre 2 redom 3 domre-o 4 re-o dom
				   etc */
shared int  ST_ORDER = 0;
shared int  RCV = FALSE;	/* Random Choose Value */
shared int  SMI = FALSE;	/* Share More Information */
shared int  SF = FALSE;		/* Search Forward */
shared int  PART_SOL[MAX_PROCESSOR];/* Partial Solutions */
shared int  NO_MORE[MAX_PROCESSOR];/* No More Partial Solutions */
private SET TRO_MAKER;
private SET DOM_WAITER;
private int FROM_ID;
private int THIS_ID;
private int NEED_BACK = FALSE;
shared int  need_print = FALSE;
shared int  np = 1;
shared int  divide_spa;
shared int  divide_level;
shared int  divide_sum;
shared int  search_level;
shared int  order_level;
shared int  change_level;
shared int  logical_time[MAX_PROCESSOR];
shared int  proc_space[MAX_PROCESSOR][MAX_AGENT];
shared int  dynamic_order[MAX_PROCESSOR][MAX_AGENT];
shared int  current_order[MAX_PROCESSOR];
shared int  current_back_order[MAX_PROCESSOR];
private int pid;
private int TESTING;
shared int  DID_SOMETHING[MAX_PROCESSOR];
private int STOP_WAIT;;
shared slock_t lock[MAX_PROCESSOR + 1];
shared sbarrier_t barrier[MAX_PROCESSOR + 1];
shared int  wait_for_work[MAX_PROCESSOR];
shared int  FORD_CHECK;
shared int  balance_finish;
private int private_check;

/* pointers */

shared struct agent_home *agent_index[MAX_PROCESSOR][MAX_AGENT];
				/* NULL first */
shared struct info *space_buffer_ptr[MAX_PROCESSOR];
shared FILE * out_ptr;

/* counters */

shared int  agent_count = 0;	/* set as 0 first */
shared int  group_count = 0;	/* set as 0 first */
shared int  processor_count = 0;/* set as 0 first */
shared int  get_count[MAX_PROCESSOR],
            free_count[MAX_PROCESSOR];
shared int  solution_count[MAX_PROCESSOR];
shared int  solution_count_all;
int   time_count1 = 0;
int   time_count2 = 0;
int   bad_value_count = 0;

/* records */

shared int  orders[MAX_ORDER][5];
shared int  agent_order[MAX_PROCESSOR][MAX_AGENT];/* set as 0 first */
shared int  get_order[MAX_PROCESSOR][MAX_AGENT];/* set as 0 first */
shared int  dom_length[MAX_AGENT];
shared int  dom1_length[MAX_AGENT];
shared int  dom2_length[MAX_AGENT];
shared int  dom_level[MAX_AGENT];
shared SET dom[MAX_AGENT];
shared SET dom1[MAX_AGENT];
shared SET dom2[MAX_AGENT];
shared INFO proc_view[MAX_PROCESSOR][MAX_AGENT];
shared PROC_HOME pid_info[MAX_PROCESSOR];
shared int  STEP;
shared int  sleep_proc = 0;
shared int  excu_count;

/* others */


shared SET empty;

/* for testing */

shared int  temp_count1[MAX_PROCESSOR];
shared int  temp_count2[MAX_PROCESSOR];
shared int  temp_count3[MAX_PROCESSOR];
shared int  temp_count4[MAX_PROCESSOR];
shared int  temp_count5[MAX_PROCESSOR];
shared int  temp_count6[MAX_PROCESSOR];

shared int  temp_count7[MAX_PROCESSOR];
shared int  temp_count8[MAX_PROCESSOR];
shared int  temp_count9[MAX_PROCESSOR];

set_signal ()
{
 /* 
  printf ("P%d set the signal\n", m_get_myid ());
  */
}

shared int  proc_ids[MAX_PROCESSOR];
shared int  still_pause[MAX_PROCESSOR][MAX_PROCESSOR];

shared int  nogood_make_count = 0;
shared int  nogood_del_count = 0;

/* test to reduce density */

shared int  REDUCE_ARCS = 0;
shared int  constraints[25][25];

/* main procedure */

main (argc, argv)
int   argc;
char **argv;
{

 /* for DCSP */

  FILE * bfp, *our_fopen ();
  FILE * Data_Record;
  char  filename[MAXCHAR];
  char  outname[MAXCHAR];
  char  screen[7];
  int   i;
  int   out;
  int   last_char;

  int   REPEAT = 0;
  int   ALLORDER = 0;
  int   BEGIN_ORDER;
  int   LAST_ORDER;
  int   nd;
  int   j;
  int   data_count[MAX_DATA][MAX_ORDER];
  int   repeat_count;
  double  temp;
  int   agent_id;

  void work_agent ();
  void work_agent2 ();
  void multi_check_release ();

 /* initialize and input data */

  if (argc != 24)
  {
    printf ("argc = %d\n", argc);
    printf ("alg problem outfile print(0,1) repeat(>1) begin-order \n");
    printf ("last-order all-solutions(0,1) single-run (0,1) zebra(0,1) optimize (0,1) \n");
    printf ("forward check FC (2: fc-cbj-ng 4: fc-cbj-ng-pr 5: fc-cbj 6: distributed fc-cbj-ng-pr 7: function fc-cbj-ng-pr) \n");
    printf ("program strategy PS (0: sequential 3: parallel 4: distributed 5 function) \n");
    printf ("divide-level(>2) np(>0) balance(0,1) share(0,1) dynamic-order(0,1) \n");
    printf ("random (0) share-more-info (0) search-forward (0,1)\n");
    printf ("heuristic 1 dom rel 2 rel dom 3 dom rel-out 4 rel-out dom\n");
    printf ("static ordering (0,1) reduce_cons (>0)\n");
    exit (0);
  }

 /* set 0 */

  for (j = 0; j < MAX_PROCESSOR; j++)
  {
    for (i = 0; i < MAX_AGENT; i++)
    {
      agent_index[j][i] = NULL;
    }
  }
  agent_count = 0;

 /* read the search file name first */
  for (i = 0; *argv[1] != '\0'; i++)
  {
    filename[i] = *argv[1];
    argv[1]++;
  }
  filename[i] = '\0';

 /* read the print file name first */
  for (i = 0; *argv[2] != '\0'; i++)
  {
    outname[i] = *argv[2];
    argv[2]++;
  }
  outname[i] = '\0';
  last_char = i;

  PRINT = atoi (argv[3]);

  REPEAT = atoi (argv[4]);

  if (REPEAT < 1)
  {
    printf ("No Repeat ?\n");
    exit (0);
  }
  BEGIN_ORDER = atoi (argv[5]);

  LAST_ORDER = atoi (argv[6]);

  MULTI = atoi (argv[7]);

  SINGLE = atoi (argv[8]);

  ZEBRA = atoi (argv[9]);

  OPT = atoi (argv[10]);

  FC = atoi (argv[11]);

  PS = atoi (argv[12]);

  search_level = atoi (argv[13]);

  np = atoi (argv[14]);
  if (np == 0)
  {
    np = 1;
  }

  BAL = atoi (argv[15]);

  SHA = atoi (argv[16]);

  D_O = atoi (argv[17]);

  RCV = atoi (argv[18]);

  SMI = atoi (argv[19]);

  SF = atoi (argv[20]);

  HEURISTIC = atoi (argv[21]);

  ST_ORDER = atoi (argv[22]);

  REDUCE_ARCS = atoi (argv[23]);

  if (D_O == 0 && HEURISTIC > 0 && HEURISTIC < 9 ||
      D_O == 1 && (HEURISTIC < 1 || HEURISTIC > 8))
  {
    printf ("look D_O and Heuristic\n");
    exit (0);
  }

  if (FC == 4 || FC == 6)
  {
    if (D_O && RCV)
    {
      printf ("Dynamic Ordering implies Random Choosing Value in FC4\n");
      exit (0);
    }
  }


  if (np > MAX_PROCESSOR)
  {
    printf ("np is too high\n");
    exit (0);
  }

  if (PS == 3 /* PS3 */ )
  {

    divide_sum = 1;
    divide_level = 0;
    while (divide_sum < np)
    {
      private_check++;
      if (private_check == 10000)
      {
	printf ("P%d rests so long Mark %d\n", pid, 39);
	private_check = 0;
      }
      divide_sum = divide_sum * 2;
      divide_level++;
    }
  }
  else
  {
    divide_sum = 2;

    for (i = 1; i < divide_level; i++)
    {
      divide_sum = divide_sum * 2;
    }
  }

  need_print = FALSE;

  bfp = our_fopen (&filename[0], "r");
  printf ("\n Open Search File %s is OK \n", &filename[0]);


  screen[0] = 's';
  screen[1] = 't';
  screen[2] = 'd';
  screen[3] = 'o';
  screen[4] = 'u';
  screen[5] = 't';
  screen[6] = '\0';

  out = strncmp (&outname[0], &screen[0], 6);

  if (out != 0)
  {
    out_ptr = our_fopen (&outname[0], "w");
    printf ("\n Open Out File %s is OK \n", &outname[0]);
    fprintf (out_ptr, "\n Open Search File %s is OK \n", &filename[0]);
    fprintf (out_ptr, "\n Open Out File %s is OK \n", &outname[0]);
  }
  else
  {
    out_ptr = stdout;
    printf ("\n Print on Screen \n");
  }
  printf ("PRINT %d RE %d BO %d LO %d MULTI %d SINGLE %d ZE %d \n",
      PRINT, REPEAT, BEGIN_ORDER, LAST_ORDER, MULTI, SINGLE, ZEBRA);
  printf (" OPT %d FC %d PS %d LE %d DS %d NP %d BAL %d SHA %d D_O %d \n",
      OPT, FC, PS, divide_level, divide_sum, np, BAL, SHA, D_O);
  printf ("RCV %d SMI %d SF %d HEU %d SO %d R_ARCS %d\n",
      RCV, SMI, SF, HEURISTIC, ST_ORDER, REDUCE_ARCS);
  if (out_ptr != stdout)
  {
    fprintf (out_ptr, "PRINT %d RE %d BO %d LO %d MULTI %d SINGLE %d ZE %d \n",
	PRINT, REPEAT, BEGIN_ORDER, LAST_ORDER, MULTI, SINGLE, ZEBRA);
    fprintf (out_ptr, "OP %d FC %d PS %d LE %d DS %d NP %d BA %d SH %d DO %d\n",
	OPT, FC, PS, divide_level, divide_sum, np, BAL, SHA, D_O);
    fprintf (out_ptr, " RCV %d SMI %d SF %d HEU %d SO %d R_ARCS %d\n",
	RCV, SMI, SF, HEURISTIC, ST_ORDER, REDUCE_ARCS);
  }

 /* ini 0 */

  for (i = 0; i < MAX_PROCESSOR; i++)
  {
    space_buffer_ptr[i] = NULL;
    get_count[i] = 0;
    free_count[i] = 0;
    s_init_lock (&lock[i]);
    s_init_barrier (&barrier[i], 2);
    pid_info[i].message_ptr = NULL;
    pid_info[i].tail_ptr = NULL;
    pid_info[i].part_solution_ptr = NULL;
    pid_info[i].solution_tail_ptr = NULL;
    pid_info[i].sol_length = 0;
    temp_count1[i] = 0;
    temp_count2[i] = 0;
    temp_count3[i] = 0;
    temp_count4[i] = 0;
    temp_count5[i] = 0;
    temp_count6[i] = 0;
    temp_count7[i] = 0;
    temp_count8[i] = 0;
    temp_count9[i] = 0;
  }

  s_init_lock (&lock[MAX_PROCESSOR]);
  s_init_barrier (&barrier[MAX_PROCESSOR], 2);

  for (j = 0; j < MAX_PROCESSOR; j++)
  {
    for (i = 0; i < MAX_AGENT; i++)
    {
      agent_index[j][i] = NULL;
    }
  }
  agent_count = 0;

  divide_spa = FALSE;

  pid = 0;

 /* main loop of algorithms */

  while (TRUE)
  {
    if (!read_files (&filename[0], &bfp))
      break;

    if (PS > 0 && !divide_spa)
    {
      divide_spa = TRUE;
      for (i = 0; i < agent_count; i++)
      {
	set_Assign (dom[i], agent_index[pid][i] -> domain);
	divide_dom (dom[i], dom1[i], dom2[i], i);
      }
    }

    if (SINGLE || OPT)
    {
      ALLORDER = 1;
      BEGIN_ORDER = 0;
      LAST_ORDER = 1;
    }
    else
    {
      if (ZEBRA)
      {
	ALLORDER = 120;
	make_order1 ();
      }
      else
      {
      /* reduced zebra */
	ALLORDER = 24;
	make_order2 ();
      }
    }
    if (np > 1)
    {
      i = cpus_online ();
      if (np >= i)
      {
	printf ("Less CPUs %d (-1) than NP %d\n", i, np);
	exit (0);
      }
      m_set_procs (np);
    }

    for (excu_count = BEGIN_ORDER; excu_count < ALLORDER &&
	excu_count <= LAST_ORDER; excu_count++)
    {

      fprintf (stderr, "Select Order %d\n", excu_count);

    /* read data file */
      outname[last_char] = 'D';
      outname[last_char + 1] = '\0';
      for (i = 0; i < MAX_DATA; i++)
      {
	for (j = 0; j < MAX_ORDER; j++)
	{
	  data_count[i][j] = -1;
	}
      }
      if (excu_count > 0)
      {
	Data_Record = our_fopen (&outname[0], "r");
	nd = fread ((char *) data_count, sizeof (int), MAX_DATA * MAX_ORDER,
	    Data_Record);
	if (nd == 0)
	{
	  fprintf (stderr, "problem in reading data_count file\n");
	  fprintf (out_ptr, "problem in reading data_count file\n");
	  exit (0);
	}
	(void) fclose (Data_Record);

	for (i = 0; i < BEGIN_ORDER && FALSE; i++)
	{
	  if (data_count[0][i] < 0)
	  {
	    printf ("The Order %d has not been done yet\n", i);
	    exit (0);
	  }
	}
      }
    /* the same order runs REPEAT times */
      for (repeat_count = 0; repeat_count < REPEAT; repeat_count++)
      {
	solution_count_all = 0;

	set_agent ();

	if (SINGLE)
	{
	  ini_agents (-1);
	}
	else
	{
	  ini_agents (excu_count);
	}

	if (agent_count == 0)
	{
	  printf ("agent_count=0\n");
	  exit (0);
	}
	if (REDUCE_ARCS > 0)
	{
	  del_constraints ();
	}

	fprintf (stdout, "Order_select %d Repeat_count %d \n",
	    excu_count, repeat_count);

	if ((int) signal (SIGUSR2, set_signal) == -1)
	{
	  fprintf (stderr, "later: Error during signal\n");
	  exit (0);
	}

      /* program strategies */

	switch (PS)
	{
	  case 0: 		/* sequential */
	    super_agent ();
	    break;
	  case 3: 		/* the parallel-agent-based strategy */
	    for (i = 0; i < np; i++)
	    {
	      wait_for_work[i] = FALSE;
	      pid_info[i].id = i;
	      pid_info[i].status = 1;
	      pid_info[i].wait_proc = -1;
	      pid_info[i].proc_wait = -1;
	      pid_info[i].message_ptr = NULL;
	      pid_info[i].tail_ptr = NULL;
	      pid_info[i].part_solution_ptr = NULL;
	      pid_info[i].solution_tail_ptr = NULL;
	      pid_info[i].sol_length = 0;
	      logical_time[i] = 0;
	      pid_info[i].lower_order = 0;
	      pid_info[i].high_order = agent_count - 1;
	    }
	    for (i = 1; i < np; i++)
	    {
	      copy_agent (i);
	    }
	    ini_sep_space ();
	    balance_finish = FALSE;
	    for (i = 0; i < np; i++)
	    {
	      pid = i;
	      set_space (i);
	    }
	  /* SHA */
	    if (order_level > search_level - 1)
	    {
	      change_level = order_level;
	    }
	    else
	    {
	      change_level = search_level - 1;
	    }

	    if (np > 1)
	    {
	      m_fork (work_agent);
	      m_park_procs ();
	    }
	    else
	    {
	      super_agent ();
	    }
	    pid = 0;
	    break;
	  case 4: 		/* the distributed-agent-based strategy */
	    if (FC != 6)
	    {
	      printf ("What FC\n");
	      exit (0);
	    }
	    for (i = 0; i < np; i++)
	    {
	      pid_info[i].id = i;
	      pid_info[i].status = 1;
	      pid_info[i].wait_proc = -1;
	      pid_info[i].proc_wait = -1;
	      pid_info[i].message_ptr = NULL;
	      pid_info[i].tail_ptr = NULL;
	      pid_info[i].part_solution_ptr = NULL;
	      pid_info[i].solution_tail_ptr = NULL;
	      pid_info[i].sol_length = 0;
	      pid_info[i].lower_order = -1;
	      pid_info[i].high_order = -1;
	      logical_time[i] = 0;
	    }
	  /* allocate agents to each processor */
	    allocat_order (np, agent_count);
	    for (i = 1; i < np; i++)
	    {
	      copy_agent (i);
	    }
	  /* run each processor */
	    if (np > 1)
	    {
	      m_fork (work_agent2);
	      m_park_procs ();
	    }
	    else
	    {
	      super_agent2 ();
	    }
	    pid = 0;
	    break;
	  case 5: 		/* the function-agent-based strategy */
	    if (FC != 7)
	    {
	      printf ("What FC\n");
	      exit (0);
	    }
	    for (i = 0; i < np; i++)
	    {
	      pid_info[i].id = i;
	      pid_info[i].status = 1;
	      pid_info[i].message_ptr = NULL;
	      pid_info[i].tail_ptr = NULL;
	      pid_info[i].part_solution_ptr = NULL;
	      pid_info[i].solution_tail_ptr = NULL;
	      pid_info[i].sol_length = 0;
	      pid_info[i].lower_order = 0;
	      pid_info[i].high_order = agent_count - 1;
	      logical_time[i] = 0;
	    }
	    pid = 0;

	  /* run each processor */
	    if (np > 1)
	    {
	      STEP = BITE;
	      super_agent3 ();
	    }
	    else
	    {
	      STEP = agent_count;
	      m_set_procs (1);
	      super_agent3 ();
	    }
	    break;
	  default: 
	    printf ("No PS\n");
	    exit (0);
	}

      /* get tested data */

	get_data (repeat_count);

	for (i = 0; i < np; i++)
	{
	  solution_count_all = solution_count_all + solution_count[i];
	}

	fprintf (stderr, "Got Solution %d\n", solution_count_all);

	if (ZEBRA && MULTI)
	{
	  if (solution_count_all != 11)
	  {
	    printf ("Wrong Number of Solutions\n");
	    for (pid = 0; pid < np; pid++)
	    {
	      display (1);
	    }
	    exit (0);
	  }
	}
      }				/* finish repeat */

    /* do statis */

      statis (temp_apply, REPEAT, &data_count[0][excu_count],
	  &temp, &min_apply, &max_apply);
      statis (temp_arc, REPEAT, &data_count[6][excu_count],
	  &temp, &min_arc, &max_arc);
      statis (temp_send, REPEAT, &data_count[1][excu_count],
	  &temp, &min_send, &max_send);
      statis (temp_rece, REPEAT, &data_count[2][excu_count],
	  &temp, &min_rece, &max_rece);
      statis (temp_back, REPEAT, &data_count[3][excu_count],
	  &temp, &min_back, &max_back);
      statis (temp_block_s, REPEAT, &data_count[4][excu_count],
	  &temp, &min_block_s, &max_block_s);
      statis (temp_block_r, REPEAT, &data_count[5][excu_count],
	  &temp, &min_block_r, &max_block_r);
      statis (temp_time1, REPEAT, &data_count[7][excu_count],
	  &temp, &min_time1, &max_time1);
      statis (temp_time2, REPEAT, &data_count[8][excu_count],
	  &temp, &min_time2, &max_time2);

      Data_Record = our_fopen (&outname[0], "w");
      nd = fwrite ((char *) data_count, sizeof (int),
	  MAX_DATA * MAX_ORDER, Data_Record);
      if (nd == 0)
      {
	fprintf (stderr, "problem in writing data_count file\n");
	fprintf (out_ptr, "problem in writing data_count file\n");
	exit (0);
      }
      (void) fclose (Data_Record);

    /* print partial results */
      if (ALLORDER > 1)
      {
	print_result (1, REPEAT, excu_count, data_count);
      }

    }				/* end of excu_count */

  /* do all statis */

    statis (data_count[0], ALLORDER, &an_apply,
	&sd_apply, &min_apply, &max_apply);
    statis (data_count[6], ALLORDER, &an_arc,
	&sd_arc, &min_arc, &max_arc);
    statis (data_count[1], ALLORDER, &an_send,
	&sd_send, &min_send, &max_send);
    statis (data_count[2], ALLORDER, &an_rece,
	&sd_rece, &min_rece, &max_rece);
    statis (data_count[3], ALLORDER, &an_back,
	&sd_back, &min_back, &max_back);
    statis (data_count[4], ALLORDER, &an_block_s,
	&sd_block_s, &min_block_s, &max_block_s);
    statis (data_count[5], ALLORDER, &an_block_r,
	&sd_block_r, &min_block_r, &max_block_r);
    statis (data_count[7], ALLORDER, &an_time1,
	&sd_time1, &min_time1, &max_time1);
    statis (data_count[8], ALLORDER, &an_time2,
	&sd_time2, &min_time2, &max_time2);

    if (np > 1)
    {
      for (i = 0; i < np; i++)
      {
	statis (temp_p_apply[i], REPEAT, &balance[0][i],
	    &temp, &min_p_apply, &max_p_apply);
	statis (temp_p_arc[i], REPEAT, &balance[6][i],
	    &temp, &min_p_arc, &max_p_arc);
	statis (temp_p_send[i], REPEAT, &balance[1][i],
	    &temp, &min_p_send, &max_p_send);
	statis (temp_p_rece[i], REPEAT, &balance[2][i],
	    &temp, &min_p_rece, &max_p_rece);
	statis (temp_p_back[i], REPEAT, &balance[3][i],
	    &temp, &min_p_back, &max_p_back);
	statis (temp_p_b_s[i], REPEAT, &balance[4][i],
	    &temp, &min_p_b_s, &max_p_b_s);
	statis (temp_p_b_r[i], REPEAT, &balance[5][i],
	    &temp, &min_p_b_r, &max_p_b_r);
      }
      statis (balance[0], np, &an_p_apply,
	  &sd_p_apply, &min_p_apply, &max_p_apply);
      statis (balance[6], np, &an_p_arc,
	  &sd_p_arc, &min_p_arc, &max_p_arc);
      statis (balance[1], np, &an_p_send,
	  &sd_p_send, &min_p_send, &max_p_send);
      statis (balance[2], np, &an_p_rece,
	  &sd_p_rece, &min_p_rece, &max_p_rece);
      statis (balance[3], np, &an_p_back,
	  &sd_p_back, &min_p_back, &max_p_back);
      statis (balance[4], np, &an_p_b_s,
	  &sd_p_b_s, &min_p_b_s, &max_p_b_s);
      statis (balance[5], np, &an_p_b_r,
	  &sd_p_b_r, &min_p_b_r, &max_p_b_r);
    }
    print_result (0, REPEAT, ALLORDER, data_count);

  }				/* end of while TRUE  */

  printf ("\nThe DCSP runs very well\n");

  fprintf (out_ptr, "The DCSP runs very well\n");

  (void) fclose (bfp);

  if (out != 0)
    (void) fclose (out_ptr);

  exit (0);

}				/* end of main */

/* read files */

int
      read_files (name_ptr, bfp_ptr)
char *name_ptr;
FILE ** bfp_ptr;
{
  FILE * bfp;
  char  line[MAXLINE];
  char  last;
  int   go_on;


  bfp = *bfp_ptr;
  while (fgets (line, sizeof (line), bfp))
  {
    go_on = FALSE;
    do
    {
      switch (line[0])
      {
	case 'o': 		/* operation */
	  last = 'o';
	  read_agent (line, go_on);/* read an operation */
	  go_on = FALSE;
	  break;
	case '*': 		/* display final result */
	  last = '*';
	  for (pid = 0; pid < np; pid++)
	  {
	    display (0);
	  }
	  pid = 0;
	  go_on = FALSE;
	  break;
	case ':': 		/* display detail result */
	  last = ':';
	  for (pid = 0; pid < np; pid++)
	  {
	    display (1);
	  }
	  pid = 0;
	  go_on = FALSE;
	  break;
	case '&': 		/* continue to read this line */
	  line[0] = last;
	  go_on = TRUE;
	  break;
	case '!': 		/* break reading, after excu, return */
	  *bfp_ptr = bfp;
	  return 1;
	case '$': 		/* break read not return */
	  *bfp_ptr = bfp;
	  return 0;
	case '/': 		/* just like comments */
	  break;
	case 'a': 		/* auto allocate processors */
	  if (need_print)
	  {
	    if (out_ptr != stdout)
	      fprintf (stderr, "AUTO allocate processors\n");
	    fprintf (out_ptr, "AUTO allocate processors\n");
	  }
	  AUTO_ALLOCAT = TRUE;
	  break;
	default: 		/* nothing happen */
	  break;
      }				/* end of switch */
    } while (go_on);
  }				/* end of while */
  *bfp_ptr = bfp;
  return 1;

}

/* open files */

FILE *
our_fopen (file_name, mode)
char *file_name,
     *mode;
{
  FILE * fp;

  fp = fopen (file_name, mode);

  if (!fp)
  {
  /* 
   * fprintf (stderr, "Can't open file \"%s\" for %s\n", file_name, (*mode
   * == 'r') ? "reading" : ((*mode == 'w') ? "writing" : "appending"));
   */
    if (out_ptr != stdout)
      fprintf (stderr, "Can't open file \"%s\" \n", file_name);
    fprintf (out_ptr, "Can't open file \"%s\" \n", file_name);
    exit (1);
  }
  return fp;
}

/* make order for the reduced zebra */

make_order2 ()
{
  int   i,
        j,
        k,
        m;
  int   count = 0;

  for (i = 0; i < 4; i++)
  {
    for (j = 0; j < 4; j++)
    {
      for (k = 0; k < 4; k++)
      {
	for (m = 0; m < 4; m++)
	{
	  if ((i != j) && (i != k) && (i != m) &&
	      (j != k) && (j != m) &&
	      (k != m))
	  {
	    orders[count][0] = i;
	    orders[count][1] = j;
	    orders[count][2] = k;
	    orders[count][3] = m;
	    count++;
	  }
	}
      }
    }
  }

}

/* make order for zebra */

make_order1 ()
{
  int   i,
        j,
        k,
        m,
        n;
  int   count = 0;

  for (i = 0; i < 5; i++)
  {
    for (j = 0; j < 5; j++)
    {
      for (k = 0; k < 5; k++)
      {
	for (m = 0; m < 5; m++)
	{
	  for (n = 0; n < 5; n++)
	  {
	    if ((i != j) && (i != k) && (i != m) && (i != n) &&
		(j != k) && (j != m) && (j != n) &&
		(k != m) && (k != n) &&
		(m != n))
	    {
	      orders[count][0] = i;
	      orders[count][1] = j;
	      orders[count][2] = k;
	      orders[count][3] = m;
	      orders[count][4] = n;
	      count++;

	    }
	  }
	}
      }
    }
  }

}

/* read agent or variables */

read_agent (line, go_on)
char  line[MAXLINE];
int   go_on;

{
  int   i;
  char  agent_name[MAXCHAR];
  int static  agent_id;

  if (go_on)
    i = 1;			/* the first letter & changed as 'o' we do
				   * not need it */
  else
    i = 0;



  while (line[i] != '\n')
  {
    switch (line[i])
    {
      case 'o': 

      /* read the op first */

	if (need_print)
	  fprintf (out_ptr, "Agent ");
	i = 1;

      /* read the op first */

	make_agent (line, agent_name, &agent_id, 20 /* the agent */ , &i);

      /* begin to read the relation and domains */

	break;
      case 'p': 		/* processor_id */
	if (need_print)
	  fprintf (out_ptr, "Processor ");
	make_agent (line, agent_name, &agent_id, 21, &i);
	break;
      case 'u': 		/* during */
	if (need_print)
	  fprintf (out_ptr, "During ");
	make_agent (line, agent_name, &agent_id, 1, &i);
	break;
      case 'n': 		/* not.during */
	if (need_print)
	  fprintf (out_ptr, "Not_During ");
	make_agent (line, agent_name, &agent_id, 2, &i);
	break;
      case 'b': 		/* before */
	if (need_print)
	  fprintf (out_ptr, "Before ");
	make_agent (line, agent_name, &agent_id, 3, &i);
	break;
      case 'a': 		/* after */
	if (need_print)
	  fprintf (out_ptr, "After ");
	make_agent (line, agent_name, &agent_id, 4, &i);
	break;
      case 'm': 		/* meet */
	if (need_print)
	  fprintf (out_ptr, "Meet ");
	make_agent (line, agent_name, &agent_id, 5, &i);
	break;
      case 's': 		/* start */
	if (need_print)
	  fprintf (out_ptr, "Start ");
	make_agent (line, agent_name, &agent_id, 6, &i);
	break;
      case 'e': 		/* end */
	if (need_print)
	  fprintf (out_ptr, "End ");
	make_agent (line, agent_name, &agent_id, 7, &i);
	break;
      case 'q': 		/* q_queen */
	if (need_print)
	  fprintf (out_ptr, "Q_Queen ");
	make_agent (line, agent_name, &agent_id, 8, &i);
	break;
      case 'c': 		/* confused q_queen */
	if (need_print)
	  fprintf (out_ptr, "Confused Q_Queen ");
	make_agent (line, agent_name, &agent_id, 9, &i);
	break;
      case 'd': 		/* domains */
	if (need_print)
	  fprintf (out_ptr, "Domains ");
	make_agent (line, agent_name, &agent_id, 0, &i);
	break;
      default: 
	i++;
	break;
    }
  }
  if (need_print)
    fprintf (out_ptr, "\n");
}				/* end of read_agent */

/* make structure of agent or variable */

make_agent (line, agent_name, agent_id_ptr, relation, i_ptr)
char  agent_name[MAXCHAR];
int  *agent_id_ptr;
char  line[MAXLINE];
int   relation;			/* 1 during 2 not.during 3 before 4 after
				   5 * meet 6 starts 7 ends 0 domains 20
				   the node */

int  *i_ptr;
{
  int   i,
        j,
        k;
  int   agent_id,
        other_id;
  int   processor_id;
  int   value;
  char  name[MAXCHAR];
  struct agent_home *agent_ptr;


  i = *i_ptr;

  switch (relation)
  {
    case 20: 			/* build the node */

    /* read the name */

      read_name (line, agent_name, &i);

      if (need_print)
	fprintf (out_ptr, " %s ", &agent_name[0]);

      agent_id = atoi (&agent_name[0]);

      if (agent_index[pid][agent_id] == NULL)
      {


      /* apply for a op_node */


	if ((agent_ptr =
	      (AGENT_HOME *) shmalloc (sizeof (AGENT_HOME))) == '\0')
	{
	  if (out_ptr != stdout)
	    fprintf (stderr, "Out of memory \n");
	  fprintf (out_ptr, "Out of memory \n");
	  (void) fclose (out_ptr);
	  exit (1);
	}
	agent_index[pid][agent_id] = agent_ptr;

      /* the node should be set to be 0 first */

	set_Empty (agent_ptr -> conf_set);
	set_Empty (agent_ptr -> past_fc);
	set_Empty (agent_ptr -> future_fc);
	set_Empty (agent_ptr -> domain);
	set_Empty (agent_ptr -> avail_domain);
	for (k = 0; k < MAX_AGENT; k++)
	{
	  agent_ptr -> relation[k] = -1;
	  agent_ptr -> in_link[k] = FALSE;
	}
	agent_ptr -> my_id = agent_id;
	agent_ptr -> my_value = -1;
	agent_ptr -> to_be_sent = FALSE;
	agent_ptr -> value_view_ptr = NULL;
	agent_ptr -> view_tail_ptr = NULL;
	agent_ptr -> message_ptr = NULL;
	agent_ptr -> nogood_ptr = NULL;
	agent_ptr -> rel_length = 0;
	agent_ptr -> dom_length = 0;
	agent_ptr -> avail_length = 0;
	agent_ptr -> apply_count = 0;
	agent_ptr -> message_count = 0;
	agent_ptr -> rece_count = 0;

	agent_ptr -> back_count = 0;

	agent_ptr -> block_send = 0;
	agent_ptr -> block_rece = 0;

	agent_ptr -> temp_rece = 0;
	agent_ptr -> temp_send = 0;

	agent_ptr -> processor_id = 0;

	agent_ptr -> order = agent_id;
	agent_order[pid][agent_ptr -> order] = agent_id;

	if (agent_id >= agent_count)
	  agent_count = agent_id + 1;
	if (agent_count > MAX_AGENT)
	{
	  if (out_ptr != stdout)
	    fprintf (stderr, "Too much AGENTs than MAX_AGENT %d \n",
		MAX_AGENT);
	  fprintf (out_ptr, "Too much AGENTs than MAX_AGENT %d \n",
	      MAX_AGENT);
	  (void) fclose (out_ptr);
	  exit (1);
	}
      }				/* end of apply a new node */
      *agent_id_ptr = agent_id;


    /* end of applying a agent_node */

      break;
    case 21: 			/* processor */
      i++;
      read_name (line, name, &i);
      if (need_print)
	fprintf (out_ptr, " %s ", &name[0]);
      processor_id = atoi (&name[0]);
      agent_ptr = agent_index[pid][*agent_id_ptr];
      agent_ptr -> processor_id = processor_id;
      if (processor_id >= processor_count)
	processor_count = processor_id + 1;
      if (processor_count > MAX_PROCESSOR)
      {
	if (out_ptr != stdout)
	  fprintf (stderr, "Too much GROUPs than MAX_PROCESSOR %d \n",
	      MAX_GROUP);
	fprintf (out_ptr, "Too much GROUPs than MAX_PROCESSOR %d \n",
	    MAX_GROUP);
	(void) fclose (out_ptr);
	exit (0);
      }
      break;
    default: 
    /* read others relation as well as domains */

      i++;
      while (line[i] != '*')	/* terminate */
      {

      /* read the name */

	read_name (line, name, &i);


	if (need_print)
	  fprintf (out_ptr, " %s ", &name[0]);
	while (line[i] != '"' && line[i] != '*')
	{
	  i++;
	}

      /* begin to build the relation and domains */

	if (relation != 0)	/* not a domain */

	{
	/* first to know this is a new one ( no one calls it before ) */


	  other_id = atoi (&name[0]);

	}
      /* we got the other_agent_id */

      /* we begin to make relation */



      /* set the agent_ptr */

	agent_ptr = agent_index[pid][*agent_id_ptr];

      /* set it to the queue according to its relation */

	if (relation >= 1 && relation <= 9)/* relations */
	{
	  agent_ptr -> relation[other_id] = relation;
	}
	else
	{
	/* domains */
	  value = atoi (&name[0]);
	  if (value >= MAX_DOMAIN)
	  {
	    printf ("Domain is too big\n");
	    (void) fclose (out_ptr);
	    exit (0);
	  }
	  set_Add (agent_ptr -> domain, value);
	  set_Add (agent_ptr -> avail_domain, value);
	}			/* end of if */

      /* end of setting one relation or a data of boundary */


      }
      i++;

      break;
  }				/* end of switch */

  *i_ptr = i;

}				/* end of make_agent */

/* read names */

read_name (line, name, i_ptr)	/* read "name" and return pointer to next 
				*/
char  line[MAXLINE];
char  name[MAXCHAR];
int  *i_ptr;
{
  int   j;

  while (line[*i_ptr] != '"')
  {
    (*i_ptr)++;
  }


 /* begin to read the name of that re */

  (*i_ptr)++;
  j = 0;

  while (line[*i_ptr] != '"')
  {
    name[j] = line[*i_ptr];
    (*i_ptr)++;
    j++;
  }
  name[j] = '\0';
  (*i_ptr)++;
}				/* end of read_name */

/* ini agents */

ini_agents (order_select)
int   order_select;
{
  struct agent_home *agent_ptr;
  int   i;
  int   k;

  struct info *order_ptr,
             *temp1_ptr,
             *temp2_ptr,
             *temp3_ptr;
  int   order_count,
        done,
        j;


  for (i = 0; i < agent_count; i++)
  {
    agent_ptr = agent_index[pid][i];
    if (agent_ptr != NULL)
    {

    /* the node should be set to be 0 first */

      set_Empty (agent_ptr -> conf_set);
      set_Empty (agent_ptr -> past_fc);
      set_Empty (agent_ptr -> future_fc);
      set_Empty (agent_ptr -> avail_domain);
      set_Union (agent_ptr -> avail_domain, agent_ptr -> domain,
	  agent_ptr -> avail_domain);
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;
      free_link (agent_ptr -> value_view_ptr, 2);
      free_link (agent_ptr -> message_ptr, 1);
      free_link (agent_ptr -> nogood_ptr, 3);
      agent_ptr -> value_view_ptr = NULL;
      agent_ptr -> view_tail_ptr = NULL;
      agent_ptr -> message_ptr = NULL;
      agent_ptr -> nogood_ptr = NULL;

      agent_ptr -> apply_count = 0;
      agent_ptr -> apply_arc_count = 0;
      agent_ptr -> message_count = 0;
      agent_ptr -> rece_count = 0;
      agent_ptr -> back_count = 0;

      agent_ptr -> block_send = 0;
      agent_ptr -> block_rece = 0;

      agent_ptr -> temp_rece = 0;
      agent_ptr -> temp_send = 0;

      agent_ptr -> rel_length = 0;
      for (j = 0; j < MAX_AGENT; j++)
      {
	if (agent_ptr -> relation[j] != -1)
	{
	  agent_ptr -> rel_length++;
	}
      }
      agent_ptr -> dom_length = 0;
      agent_ptr -> avail_length = 0;
      for (j = 0; j < MAX_DOMAIN; j++)
      {
	if (set_Mem (agent_ptr -> domain, j))
	{
	  agent_ptr -> dom_length++;
	}
      }
      for (k = 0; k < MAX_AGENT; k++)
      {
	agent_ptr -> position_ptr[k] = NULL;
	agent_ptr -> going_value[k] = -1;
	agent_ptr -> in_link[k] = FALSE;
      }
      agent_ptr -> avail_length = agent_ptr -> dom_length;


    }
  }

  if (order_select > -1)
  {
    if (ZEBRA)
    {
      assign_order1 (orders[order_select]);
    }
    else
    {
      assign_order2 (orders[order_select]);
    }
  }
  else
  {

    if (OPT)
    {
    /* 
     * select the order according to most constrainted (FF), e.g. the agent
     * with small domain and more relation goes first
     */

      pid_info[pid].lower_order = 0;
      pid_info[pid].high_order = agent_count - 1;
      current_order[pid] = -1;
      for (i = 0; i < agent_count; i++)
      {
	dynamic_order[pid][i] = -1;
      }
      for (i = 0; i < agent_count; i++)
      {
	dynamic_order_up ();
      }

    }				/* end of making order */
  }

  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[pid][i] != NULL)
    {
      agent_order[pid][agent_index[pid][i] -> order] = i;
      get_order[pid][i] = agent_index[pid][i] -> order;
    }
  }

}				/* end of ini_agent */

/* assign order for zebra */

assign_order1 (one_order)
int   one_order[5];
{
  int   i,
        j;
  int   order = 0;

  for (i = 0; i < 5; i++)
  {
    for (j = one_order[i] * 5; j < (one_order[i] * 5 + 5); j++)
    {
      agent_index[pid][j] -> order = order;
      agent_order[pid][order] = j;
      order++;
    }
  }

}

/* assign order for the reduced zebra */

assign_order2 (one_order)
int   one_order[5];
{
  int   i,
        j;
  int   order = 0;

  for (i = 0; i < 4; i++)
  {
    for (j = one_order[i] * 5; j < (one_order[i] * 5 + 5); j++)
    {
      agent_index[pid][j] -> order = order;
      agent_order[pid][order] = j;
      order++;
    }
  }

}

/* statis procedure */

statis (input_data, number_data, an, sd, min, max)
int   input_data[MAX_ORDER];
int   number_data;
int  *an,			/* average number */
     *min,
     *max;
double *sd;			/* standard deviation */
{
  double  temp_data;
  long  sum1 = 0;		/* it should long enough */
  double  sum2 = 0.0;
  int   i;


  for (i = 0; i < number_data && FALSE; i++)
  {
    if (input_data[i] == -1)
    {
      fprintf (out_ptr, "Order %d has not beed done in Sta\n", i);
      if (out_ptr != stdout)
	fprintf (stderr, "Order %d has not beed done in Sta\n", i);
      exit (0);
    }
  }
  for (i = 0; i < number_data; i++)
  {
    if (input_data[i] > *max)
      *max = input_data[i];
    if (input_data[i] < *min)
      *min = input_data[i];
    sum1 = sum1 + input_data[i];
  }

  *an = sum1 / number_data;

  if (*an != 0)
  {

    for (i = 0; i < number_data; i++)
    {
      temp_data = (*an) - input_data[i];
      sum2 = sum2 + (temp_data * temp_data);
    }

    sum2 = sum2 / *an;
    *sd = sqrt (sum2);
  }
  else
  {
    *sd = 0;
  }
}

/* get tested data */

get_data (time)
int   time;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr;
  int   message_count = 0;
  int   apply_count = 0;
  int   apply_arc_count = 0;
  int   rece_count = 0;
  int   ok_count = 0;
  int   back_count = 0;
  int   ask_count = 0;
  int   help_count = 0;
  int   undo_count = 0;
  int   block_send = 0;
  int   block_rece = 0;
  int   i,
        j,
        k;


  for (pid = 0; pid < np; pid++)
  {
    for (i = 0; i < agent_count; i++)
    {
      if (agent_index[pid][i] != NULL)
      {
	apply_count = apply_count + agent_index[pid][i] -> apply_count;
	apply_arc_count = apply_arc_count +
	  agent_index[pid][i] -> apply_arc_count;
	message_count = message_count + agent_index[pid][i] -> message_count;
	rece_count = rece_count + agent_index[pid][i] -> rece_count;
	block_send = block_send + agent_index[pid][i] -> block_send;
	block_rece = block_rece + agent_index[pid][i] -> block_rece;
	ok_count = ok_count + agent_index[pid][i] -> ok_count;
	back_count = back_count + agent_index[pid][i] -> back_count;
	ask_count = ask_count + agent_index[pid][i] -> ask_count;
	help_count = help_count + agent_index[pid][i] -> help_count;
	undo_count = undo_count + agent_index[pid][i] -> undo_count;
      }
    }
  }
  pid = 0;
  temp_apply[time] = apply_count;
  temp_arc[time] = apply_arc_count;
  temp_send[time] = message_count;
  temp_rece[time] = rece_count;
  temp_block_s[time] = block_send;
  temp_block_r[time] = block_rece;
  temp_ok[time] = ok_count;
  temp_back[time] = back_count;
  temp_ask[time] = ask_count;
  temp_help[time] = help_count;
  temp_undo[time] = undo_count;
  temp_time1[time] = time_count1;
  temp_time2[time] = time_count2;

  apply_count = 0;
  apply_arc_count = 0;
  message_count = 0;
  rece_count = 0;
  block_send = 0;
  block_rece = 0;
  back_count = 0;

 /* get the data for each processor */

  for (j = 0; j < np; j++)
  {

    message_count = 0;
    apply_count = 0;
    apply_arc_count = 0;
    rece_count = 0;
    back_count = 0;
    block_send = 0;
    block_rece = 0;

    for (pid = 0; pid < np; pid++)
    {
      for (i = 0; i < agent_count; i++)
      {
	if (agent_index[pid][i] != NULL &&
	    agent_index[pid][i] -> processor_id == j)
	{
	  apply_count = apply_count + agent_index[pid][i] -> apply_count;
	  apply_arc_count = apply_arc_count +
	    agent_index[pid][i] -> apply_arc_count;
	  message_count = message_count + agent_index[pid][i] -> message_count;
	  rece_count = rece_count + agent_index[pid][i] -> rece_count;
	  block_send = block_send + agent_index[pid][i] -> block_send;
	  block_rece = block_rece + agent_index[pid][i] -> block_rece;
	  back_count = back_count + agent_index[pid][i] -> back_count;
	}
      }
    }
    pid = 0;
    temp_p_apply[j][time] = apply_count;
    temp_p_arc[j][time] = apply_arc_count;
    temp_p_send[j][time] = message_count;
    temp_p_rece[j][time] = rece_count;
    temp_p_b_s[j][time] = block_send;
    temp_p_b_r[j][time] = block_rece;
    temp_p_back[j][time] = back_count;

  }
}				/* end of get_data */

/* print results */

print_result (mark, sample, data_collected, data_count)
int   mark;
int   sample;
int   data_collected;
int   data_count[MAX_DATA][MAX_ORDER];
{

  int   i,
        j;
  int   sum_data[MAX_DATA];

  for (i = 0; i < MAX_DATA; i++)
  {
    sum_data[i] = 0;
    for (j = 0; j < excu_count; j++)
    {
      sum_data[i] = sum_data[i] + data_count[i][j];
    }
    if (data_count[i][0] < 0)
    {
      sum_data[i] = 0;
    }
  }

  if (mark)
  {
    i = data_collected;
  /* print on screen */
    fprintf (stdout, "Apply %d Arc %d Sent_Messages %d Rece_Messages %d\n",
	data_count[0][i], data_count[6][i],
	data_count[1][i], data_count[2][i]);
    fprintf (stdout, "Sent_Blocks %d Backtracking %d\n",
	data_count[4][i], data_count[3][i]);
    fprintf (stdout, "All Excu Time (ms) %d Only Running Time (ms) %d\n",
	data_count[7][i], data_count[8][i]);
    fprintf (stdout, "\nMaking Nogoods %d Release Nogoods %d\n",
	nogood_make_count, nogood_del_count);
    return;

  }
  else
  {
    fprintf (out_ptr, "\nOne Total Order with samples %d \n", sample);
  }

 /* print file */

  fprintf (out_ptr, "\nStatis Data for Agents\n");

  fprintf (out_ptr, "\nCalling Apply:  An %d Sd %6.2f Min %d Max %d\n",
      an_apply, sd_apply, min_apply, max_apply);
  fprintf (out_ptr, "Arc Checks:  An %d Sd %6.2f Min %d Max %d\n",
      an_arc, sd_arc, min_arc, max_arc);
  fprintf (out_ptr, "Backtracking:  An %d Sd %6.2f Min %d Max %d\n",
      an_back, sd_back, min_back, max_back);
  fprintf (out_ptr, "Sent Messages:  An %d Sd %6.2f Min %d Max %d\n",
      an_send, sd_send, min_send, max_send);
  fprintf (out_ptr, "Rece Messages:  An %d Sd %6.2f Min %d Max %d\n",
      an_rece, sd_rece, min_rece, max_rece);
  fprintf (out_ptr, "Sent Blocks:  An %d Sd %6.2f Min %d Max %d\n",
      an_block_s, sd_block_s, min_block_s, max_block_s);
  fprintf (out_ptr, "Rece Blocks:  An %d Sd %6.2f Min %d Max %d\n",
      an_block_r, sd_block_r, min_block_r, max_block_r);
  fprintf (out_ptr, "All Excu Time (ms):  An %d Sd %6.2f Min %d Max %d\n",
      an_time1, sd_time1, min_time1, max_time1);
  fprintf (out_ptr, "Only Running Time (ms):  An %d Sd %6.2f Min %d Max %d\n",
      an_time2, sd_time2, min_time2, max_time2);
  fprintf (out_ptr, "\nMaking Nogoods %d Release Nogoods %d\n",
      nogood_make_count, nogood_del_count);

  fprintf (out_ptr, "\nSUM App %d Arc %d Back %d SM %d RM %d SB %d RB %d\n",
      sum_data[0], sum_data[6], sum_data[3],
      sum_data[1], sum_data[2], sum_data[4], sum_data[5]);

 /* print screen */

  fprintf (stdout, "\nStatis Data for Agents\n");

  fprintf (stdout, "\nCalling Apply:  An %d Sd %6.2f Min %d Max %d\n",
      an_apply, sd_apply, min_apply, max_apply);
  fprintf (stdout, "Arc Checks:  An %d Sd %6.2f Min %d Max %d\n",
      an_arc, sd_arc, min_arc, max_arc);
  fprintf (stdout, "Backtracking:  An %d Sd %6.2f Min %d Max %d\n",
      an_back, sd_back, min_back, max_back);
  fprintf (stdout, "Sent Messages:  An %d Sd %6.2f Min %d Max %d\n",
      an_send, sd_send, min_send, max_send);
  fprintf (stdout, "Rece Messages:  An %d Sd %6.2f Min %d Max %d\n",
      an_rece, sd_rece, min_rece, max_rece);
  fprintf (stdout, "Sent Blocks:  An %d Sd %6.2f Min %d Max %d\n",
      an_block_s, sd_block_s, min_block_s, max_block_s);
  fprintf (stdout, "Rece Blocks:  An %d Sd %6.2f Min %d Max %d\n",
      an_block_r, sd_block_r, min_block_r, max_block_r);
  fprintf (stdout, "All Excu Time (ms):  An %d Sd %6.2f Min %d Max %d\n",
      an_time1, sd_time1, min_time1, max_time1);
  fprintf (stdout, "Only Running Time (ms):  An %d Sd %6.2f Min %d Max %d\n",
      an_time2, sd_time2, min_time2, max_time2);
  fprintf (stdout, "\nMaking Nogoods %d Release Nogoods %d\n",
      nogood_make_count, nogood_del_count);

  fprintf (stdout, "\nSUM App %d Arc %d Back %d SM %d RM %d SB %d RB %d\n",
      sum_data[0], sum_data[6], sum_data[3],
      sum_data[1], sum_data[2], sum_data[4], sum_data[5]);

  if (np > 1)
  {
    fprintf (out_ptr, "\nStatis Data for Processors\n");

    for (i = 0; i < np && data_collected == 1; i++)
    {
      fprintf (out_ptr, "P %d AP %d ARC %d BA %d S_M %d R_M %d S_B %d R_B %d\n",
	  i, balance[0][i], balance[6][i],
	  balance[3][i], balance[1][i],
	  balance[2][i], balance[4][i], balance[5][i]);
    }
    if (data_collected == 1)
    {
      fprintf (out_ptr, "\nP Calling Apply:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_apply, sd_p_apply, min_p_apply, max_p_apply);
      fprintf (out_ptr, "P Arc Checks:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_arc, sd_p_arc, min_p_arc, max_p_arc);
      fprintf (out_ptr, "P Backtracking:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_back, sd_p_back, min_p_back, max_p_back);
      fprintf (out_ptr, "P Sent Messages:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_send, sd_p_send, min_p_send, max_p_send);
      fprintf (out_ptr, "P Rece Messages:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_rece, sd_p_rece, min_p_rece, max_p_rece);
      fprintf (out_ptr, "P Sent Blocks:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_b_s, sd_p_b_s, min_p_b_s, max_p_b_s);
      fprintf (out_ptr, "P Rece Blocks:  An %d Sd %6.2f Min %d Max %d\n",
	  an_p_b_r, sd_p_b_r, min_p_b_r, max_p_b_r);
    }
  }
  fprintf (out_ptr, "\nCPUs %d Agents %d\n\n",
      np, agent_count);

}				/* end of print_result */

/* monitor the processor finishing */

monitor_finish ()
{
  int   i;
  int   j;
  int   consistency;

  if (TRUE)
  {
    return;
  }

 /* check the result, if it is not correct, print warning */

  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[pid][i] != NULL)
    {
      if (agent_index[pid][i] -> my_value == -1)
      {
	printf ("P%d Value = -1\n", pid);
	fprintf (out_ptr, "P%d Value = -1\n", pid);
	if (PS == 4)
	{
	  for (i = 0; i < np; i++)
	  {
	    pid = i;
	    display (1);
	  }
	  exit (0);
	}
	else
	{
	  display (1);
	  exit (0);
	}
      }
    }
  }
  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[pid][i] != NULL)
    {
      for (j = i + 1; j < agent_count; j++)
      {
	if ((agent_index[pid][i] -> relation[j] != -1) &&
	    (agent_index[pid][j] != NULL))
	{
	  consistency = apply (agent_index[pid][i] -> my_value,
	      agent_index[pid][j] -> my_value,
	      agent_index[pid][i] -> relation[j],
	      i, j, -1);
	  agent_index[pid][i] -> apply_count--;
	  if (!consistency)
	  {
	    printf ("P%d Ag %d Val %d is in conflict with Ag %d Val %d\n",
		pid, i, agent_index[pid][i] -> my_value, j,
		agent_index[pid][j] -> my_value);
	    fprintf (out_ptr, "P%d Ag %d Val %d is in conflict with Ag %d Val %d\n",
		pid, i, agent_index[pid][i] -> my_value, j,
		agent_index[pid][j] -> my_value);
	    if (PS == 4)
	    {
	      for (i = 0; i < np; i++)
	      {
		pid = i;
		display (1);
	      }
	      exit (1);
	    }
	    else
	    {
	      display (1);
	      exit (0);
	    }
	  }
	}
      }
    }
  }

}				/* end of the monitor_finish */

/* display data and results */

display (detail)
int   detail;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr;
  int   message_count = 0;
  int   apply_count = 0;
  int   apply_arc_count = 0;
  int   clear_count = 0;
  int   rece_count = 0;
  int   ok_count = 0;
  int   back_count = 0;
  int   ask_count = 0;
  int   help_count = 0;
  int   undo_count = 0;
  int   block_send = 0;
  int   block_rece = 0;
  int   lock_conflict = 0;
  int   count;
  int   i,
        j,
        k;
  int   i_count;

  fprintf (out_ptr, "\n\n ** In Count %d Agents for Pid %d LT %d DID %d ** \n\n",
      excu_count, pid, logical_time[pid], DID_SOMETHING[pid]);

  if (detail)
  {

    print_message (pid_info[pid].message_ptr, out_ptr);

    if (np > 1)
    {
      fprintf (out_ptr, "  Status %d Lower_Order %d High_Order %d\n",
	  pid_info[pid].status, pid_info[pid].lower_order,
	  pid_info[pid].high_order);
      fprintf (out_ptr, "Order: ");
      for (i = 0; i < agent_count; i++)
      {
	fprintf (out_ptr, " O%dA%d ", i, agent_order[pid][i]);
	if ((i % 10) == 0 && i != 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
      fprintf (out_ptr, "\n");
      fprintf (out_ptr, "Agent: ");
      for (i = 0; i < agent_count; i++)
      {
	fprintf (out_ptr, " A%dO%d ", i, get_order[pid][i]);
	if ((i % 10) == 0 && i != 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
      fprintf (out_ptr, "\n");
      fprintf (out_ptr, "Value: ");
      for (i = 0; i < agent_count && !SF; i++)
      {
	fprintf (out_ptr, "A%dV%dT%dW%d ",
	    i, agent_index[pid][i] -> my_value,
	    agent_index[pid][i] -> logical_time,
	    agent_index[pid][i] -> send_place);
	if ((i % 10) == 0 && i != 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
      i_count = 0;
      for (i = 0; i < agent_count && SF; i++)
      {
	if (agent_index[pid][i] -> processor_id == pid)
	{
	  i_count++;
	  fprintf (out_ptr, "A%dSV%dT%dO%dP%dW%d ",
	      i, pid_info[pid].values[i],
	      agent_index[pid][i] -> logical_time,
	      pid_info[pid].orders[i],
	      pid_info[pid].places[i],
	      agent_index[pid][i] -> send_place);
	}
	else
	{
	  if (get_order[pid][i] < pid_info[pid].lower_order)
	  {
	    i_count++;
	    fprintf (out_ptr, "A%dRV%dT%dTM%dO%d ",
		i, agent_index[pid][i] -> my_value,
		agent_index[pid][i] -> logical_time,
		agent_index[pid][i] -> logical_time2,
		agent_index[pid][i] -> order);
	  }
	}
	if ((i_count % 5) == 0 && i_count != 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
      fprintf (out_ptr, "\n\n");
    }
  }

  for (i = 0; i < agent_count && detail; i++)
  {
    if (agent_index[pid][i] != NULL &&
	agent_index[pid][i] -> processor_id == pid)
    {

      agent_ptr = agent_index[pid][i];
      fprintf (out_ptr, "Ag %d Ord %d Val %d Be_Sent %d T1 %d T2 %d N_Id %d Pid %d \n",
	  i, agent_ptr -> order, agent_ptr -> my_value,
	  agent_ptr -> to_be_sent,
	  agent_ptr -> logical_time,
	  agent_ptr -> logical_time2,
	  agent_ptr -> next_id,
	  agent_ptr -> processor_id);


      fprintf (out_ptr, "Out_Link: ");
      for (j = 0; j < np; j++)
      {
	if (agent_ptr -> out_link[j])
	{
	  fprintf (out_ptr, " %d ", j);
	}
      }
      fprintf (out_ptr, "\n");

      fprintf (out_ptr, "Relation %d : \n", agent_ptr -> rel_length);
      display_rel (agent_ptr -> relation, out_ptr);

      fprintf (out_ptr, "Domain %d : ", agent_ptr -> dom_length);
      display_dom (agent_ptr -> domain, MAX_DOMAIN, out_ptr);
      fprintf (out_ptr, "\n");

      if (FC == 5)
      {
	fprintf (out_ptr, "Conf_Set: ");
	display_dom (agent_ptr -> conf_set, MAX_AGENT, out_ptr);
	fprintf (out_ptr, "\n");
	fprintf (out_ptr, "Past_Fc: ");
	display_dom (agent_ptr -> past_fc, MAX_AGENT, out_ptr);
	fprintf (out_ptr, "\n");
	fprintf (out_ptr, "Future_Fc: ");
	display_dom (agent_ptr -> future_fc, MAX_AGENT, out_ptr);
	fprintf (out_ptr, "\n");

      }
      print_view (agent_ptr, out_ptr);

      print_nogoods (agent_ptr, out_ptr);

      fprintf (out_ptr, "\n");

      fprintf (out_ptr, "Consistency Checks %d ",
	  agent_index[pid][i] -> apply_count);

      fprintf (out_ptr, "   Sent Messages %d \n",
	  agent_index[pid][i] -> message_count);

      fprintf (out_ptr, "   Received Messages %d \n",
	  agent_index[pid][i] -> rece_count);

      fprintf (out_ptr, "   Sent Blocks %d ",
	  agent_index[pid][i] -> block_send);

      fprintf (out_ptr, "   Received Blocks %d \n",
	  agent_index[pid][i] -> block_rece);

      fprintf (out_ptr, "Backtracking %d ",
	  agent_index[pid][i] -> back_count);

      fprintf (out_ptr, "\n\n");

    }				/* end of if agent_index[pid][i] != NULL 
				*/
  }				/* end of for */

  if (SF && detail)
  {

    fprintf (out_ptr, "SOL_LENGTH %d PART_SOL %d NO_MORE %d \n",
	pid_info[pid].sol_length, PART_SOL[pid], NO_MORE[pid]);
    print_solution (out_ptr);
  }

  if (detail && FALSE)
  {
    bad_value_count = 0;
    for (i = 0; i < agent_count; i++)
    {
      if (agent_index[pid][i] != NULL)
      {
	agent_ptr = agent_index[pid][i];
	print_bad_value (agent_ptr, out_ptr, detail);
      }
    }
    fprintf (out_ptr, "\nThe sum of bad values is %d \n", bad_value_count);
  }

  fprintf (out_ptr, "\nMaking Nogoods %d Release Nogoods %d\n",
      nogood_make_count, nogood_del_count);

  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[pid][i] != NULL)
    {

      apply_count = apply_count + agent_index[pid][i] -> apply_count;
      message_count = message_count + agent_index[pid][i] -> message_count;
      rece_count = rece_count + agent_index[pid][i] -> rece_count;
      block_send = block_send + agent_index[pid][i] -> block_send;
      block_rece = block_rece + agent_index[pid][i] -> block_rece;
      back_count = back_count + agent_index[pid][i] -> back_count;
    }
  }


  fprintf (out_ptr, "\nThe total Consistency Checks %d Arc Checks %d \n",
      apply_count, apply_arc_count);
  fprintf (out_ptr, "Sent Me. %d Received Me. %d \n",
      message_count, rece_count);
  fprintf (out_ptr, "Sent Blocks %d    Received Blocks %d \n",
      block_send, block_rece);
  fprintf (out_ptr, "The total Backtracking %d ",
      back_count);

  fprintf (out_ptr, "\nCPUs %d Agents %d \n\n",
      1, agent_count);

}				/* end of display */

/* display domains */

display_dom (domain, limit, out_ptr)
SET domain;
int   limit;
FILE * out_ptr;
{
  int   i;

  for (i = 0; i < limit; i++)
  {
    if (set_Mem (domain, i))
    {
      fprintf (out_ptr, " %d ", i);
    }
  }

}				/* end of display_dom */

/* display relations */

display_rel (relation, out_ptr)
int   relation[MAX_AGENT];
FILE * out_ptr;
{
  int   j,
        k;
  int   printed;
  char *char_ptr;

  for (j = 1; j <= 9 /* 9 relations */ ; j++)
  {
    char_ptr = NULL;
    printed = FALSE;
    switch (j)
    {
      case 1: 			/* During  */
	char_ptr = (char *) "During";
	break;
      case 2: 			/* not.during */
	char_ptr = (char *) "Not_during";
	break;
      case 3: 			/* before */
	char_ptr = (char *) "Before";
	break;
      case 4: 			/* after */
	char_ptr = (char *) "After";
	break;
      case 5: 			/* meet */
	char_ptr = (char *) "Meet";
	break;
      case 6: 			/* starts */
	char_ptr = (char *) "Start";
	break;
      case 7: 			/* end */
	char_ptr = (char *) "End";
	break;
      case 8: 			/* Q_Queen */
	char_ptr = (char *) "Q_Queen";
	break;
      case 9: 			/* Confused Q_Queen */
	char_ptr = (char *) "Confused Q_Queen";
	break;
    }				/* end of switch */

  /* print relation */
    for (k = 0; k < agent_count; k++)
    {
      if (relation[k] == j)
      {
	if (!printed)		/* un printed yet */
	{
	  fprintf (out_ptr, "   %s", char_ptr);
	  printed = TRUE;
	}
	fprintf (out_ptr, " %d ", k);
      }				/* end of if */
    }				/* end of for k */
    if (printed)
    {
      fprintf (out_ptr, "\n");
    }
  }				/* end of for relations */

}				/* end of display_rel */

/* display messages */

print_message (message_ptr, out_ptr)
struct info *message_ptr;
FILE * out_ptr;
{

  struct info *temp1_ptr;
  int   i;



  fprintf (out_ptr, "P%d Messages :\n", pid);
  for (i = 0; i < np; i++)
  {
    fprintf (out_ptr, " Pid %d Mail %d P %d MN %d Val %d Id %d To_Id %d LT1 %d LT2 %d\n",
	i, pid_info[pid].mail_numbers[i],
	pid_info[pid].mail_pid[i],
	pid_info[pid].mail_no[i],
	pid_info[pid].mail_val[i],
	pid_info[pid].mail_id[i],
	pid_info[pid].mail_to_id[i],
	pid_info[pid].mail_lt[i],
	pid_info[pid].mail_lt2[i]);
  }

  temp1_ptr = message_ptr;

  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 39);
      private_check = 0;
    }
    fprintf (out_ptr, "From_Pid %d ID %d TO_ID %d VAL %d ORD %d MNO %d LT %d MN %d\n",
	agent_index[pid][temp1_ptr -> id] -> processor_id,
	temp1_ptr -> id, temp1_ptr -> to_id,
	temp1_ptr -> value, temp1_ptr -> order,
	temp1_ptr -> mail_no, temp1_ptr -> logical_time,
	temp1_ptr -> mail_number);
    temp1_ptr = temp1_ptr -> next;
  }

  if (pid_info[pid].tail_ptr != NULL)
  {
    temp1_ptr = pid_info[pid].tail_ptr;
    fprintf (out_ptr, "TAIL From_Pid %d ID %d TO_ID %d VAL %d ORD %d MNO %d LT %d MN %d\n",
	agent_index[pid][temp1_ptr -> id] -> processor_id,
	temp1_ptr -> id, temp1_ptr -> to_id,
	temp1_ptr -> value, temp1_ptr -> order,
	temp1_ptr -> mail_no, temp1_ptr -> logical_time,
	temp1_ptr -> mail_number);
  }
}				/* end of print_message */


/*
 * Agent in DCSP
 */


/*---------------------------------------------------------------*/
/* agents of search algorithms                          	 */
/* 12/March/92 : the first version				 */
/*---------------------------------------------------------------*/

/* set processors and agents */

set_agent ()
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr;
  int   i;
  int   k;
  int   status;
  int   free_all = 0;
  int   get_all = 0;

  for (pid = 0; pid < np; pid++)
  {

    free_link (pid_info[pid].message_ptr, 4);
    pid_info[pid].message_ptr = NULL;
    pid_info[pid].tail_ptr = NULL;
    free_link (pid_info[pid].part_solution_ptr, 5);
    pid_info[pid].part_solution_ptr = NULL;
    pid_info[pid].solution_tail_ptr = NULL;
    pid_info[pid].sol_length = 0;

    solution_count[pid] = 0;



  /* free memory */
    for (i = 0; i < agent_count; i++)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr != NULL)
      {

      /* the node should be set to be 0 first */

	free_link (agent_ptr -> value_view_ptr, 2);
	free_link (agent_ptr -> message_ptr, 1);
	free_link (agent_ptr -> nogood_ptr, 3);
	agent_ptr -> value_view_ptr = NULL;
	agent_ptr -> view_tail_ptr = NULL;
	agent_ptr -> message_ptr = NULL;
	agent_ptr -> nogood_ptr = NULL;

      }
    }
    for (i = 0; i < MAX_AGENT; i++)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr != NULL)
      {
      /* set in_link */
	get_order[pid][i] = agent_ptr -> order;
	for (k = 0; k < MAX_AGENT; k++)
	{
	  agent_ptr -> position_ptr[k] = NULL;
	  agent_ptr -> going_value[k] = -1;
	  agent_ptr -> in_link[k] = FALSE;
	}

      }
    }



    while (space_buffer_ptr[pid] != NULL)
    {
      private_check++;
      if (private_check == 10000)
      {
	printf ("P%d rests so long Mark %d\n", pid, 1);
	private_check = 0;
      }
      temp1_ptr = space_buffer_ptr[pid];
      space_buffer_ptr[pid] = space_buffer_ptr[pid] -> next;
      free_count[pid]++;
      shfree ((struct info *) temp1_ptr);
    }

    free_all = free_all + free_count[pid];
    get_all = get_all + get_count[pid];
  }
  pid = 0;
  if (get_all != free_all)
  {
    printf ("Get_count %d and Free_count %d \n", get_all, free_all);
    for (i = 0; i < np; i++)
    {
      printf ("P%d Get_count %d and Free_count %d \n",
	  i, get_count[i], free_count[i]);
      printf ("P%d A_M %d A_V %d A_N %d P_M %d P_S %d Other %d\n",
	  i, temp_count1[i], temp_count2[i], temp_count3[i],
	  temp_count4[i], temp_count5[i], temp_count6[i]);
    }
    display (1);
    exit (0);
  }
  for (i = 0; i < np; i++)
  {
    get_count[i] = 0;
    free_count[i] = 0;
    temp_count1[i] = 0;
    temp_count2[i] = 0;
    temp_count3[i] = 0;
    temp_count4[i] = 0;
    temp_count5[i] = 0;
    temp_count6[i] = 0;
    temp_count7[i] = 0;
    temp_count8[i] = 0;
    temp_count9[i] = 0;
  }

}				/* end of set_agent */

/* Common Part on DCSP for Meiko and Sequent 
 * Be careful to DEBUG, POSITION, GET_ORDER, FREE, MALLOC and CSN_EXIT and
 * FREE_INFO etc
 */

/* super_agent is used by the sequential and 
   parallel-agent-based algorithm (PS0,3) */

super_agent ()
{
  struct info *message_ptr;
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  SET tro_maker;
  SET dom_waiter;
  int   i;
  int   j;
  int   agent_id;
  int   this_id,
        from_id,
        next_id;
  int   finish;
  int   from_pid;
  int   to_pid;
  int   done;
  int   some_one_wait;
  int   tmp_order;
  int   tmp_id;
  int   sleep_for_good;
  int   sleep_kill_count[MAX_PROCESSOR];


  DID_SOMETHING[pid] = FALSE;

  for (i = 0; i < agent_count; i++)
  {
    agent_index[pid][i] -> send_place = -1;
  }
  proc_ids[pid] = getpid ();
  for (i = 0; i < np; i++)
  {
    still_pause[pid][i] = FALSE;
  }
  pid_info[pid].wait_signal = FALSE;

  if ((int) signal (SIGUSR2, set_signal) == -1)
  {
    fprintf (stderr, "later: Error during signal\n");
    exit (0);
  }

  for (i = 0; i < np; i++)
  {
    pid_info[pid].mail_numbers[i] = -1;
  }

  finish = FALSE;
  while (!finish && !balance_finish)
  {
    for (i = 0; i < np; i++)
    {
      if (i != pid)
      {
	still_pause[i][pid] = FALSE;
      }
    }
    pid_info[pid].wait_signal = FALSE;

    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	kill (proc_ids[i], SIGUSR2);
      }
    }

    if (BAL && pid_info[pid].status == 1)
    {
      ini_set_agents (TRUE /* keep the record */ );
      pid_info[pid].wait_proc = -1;
    }

    if (D_O)
    {
      current_back_order[pid] = -1;
      current_order[pid] = -1;
      for (i = 0; i < agent_count; i++)
      {
	dynamic_order[pid][i] = -1;
      }
      dynamic_order_up ();
    }

    this_id = agent_order[pid][0];
    from_id = MAX_AGENT;
    while (TRUE && !balance_finish)
    {
      for (i = 0; i < np; i++)
      {
	if (still_pause[pid][i])
	{
	  kill (proc_ids[i], SIGUSR2);
	}
      }
      if (BAL && pid_info[pid].status < 1)
      {
	break;
      }
      next_id = agent (this_id, from_id, next_id, tro_maker, dom_waiter);
      if (next_id == -1)
      {
	pid_info[pid].status = 2;
	break;
      }
      else
      {
	if (next_id == agent_count /* out of agents */ )
	{
	  monitor_finish ();
	/* got one result */
	  solution_count[pid]++;
	  if (!MULTI)		/* super_agent */
	  {
	    s_lock (&lock[np]);
	    balance_finish = TRUE;
	    s_unlock (&lock[np]);

	    break;		/* one result */
	  }
	  else
	  {
	    this_id = agent_order[pid][agent_count - 1];
	    from_id = this_id;
	  }
	}
	else
	{
	  from_id = this_id;
	  this_id = next_id;
	}
      }
      if (BAL && np > 1 && !balance_finish)
      {

	if (pid_info[pid].status == 1)
	{
	  done = FALSE;
	  some_one_wait = -1;
	  s_lock (&lock[np]);
	  for (i = 0; i < np; i++)
	  {
	    if (wait_for_work[i])
	    {
	      some_one_wait = i;
	      wait_for_work[i] = FALSE;
	      break;
	    }
	  }
	  s_unlock (&lock[np]);

	  if (some_one_wait != -1)
	  {
	    from_pid = pid;
	    to_pid = some_one_wait;
	    done = divide_space (from_pid, to_pid);
	    if (!done)
	    {
	      if (!D_O)
	      {
		pid_info[from_pid].status = 2;
	      }
	      else
	      {
		if (current_order[from_pid] >= search_level)
		{
		  pid_info[from_pid].status = 2;
		}
	      }
	      s_lock (&lock[np]);
	      wait_for_work[some_one_wait] = TRUE;
	      s_unlock (&lock[np]);
	    }
	    else
	    {
	      pid_info[to_pid].status = 1;
	      still_pause[pid][to_pid] = TRUE;
	    }
	  }
	}
	if (SHA && !balance_finish)
	{
	  s_lock (&lock[pid]);
	  tmp_order = 999999;
	  tmp_id = -1;
	  temp1_ptr = pid_info[pid].message_ptr;
	  while (temp1_ptr != NULL)
	  {

	    if (del_ng_val (agent_index[pid][temp1_ptr -> id],
		  temp1_ptr -> value))
	    {
	      if (get_order[pid][temp1_ptr -> id] < tmp_order)
	      {
		tmp_order = get_order[pid][temp1_ptr -> id];
		tmp_id = temp1_ptr -> id;
	      }
	    }
	    temp1_ptr = temp1_ptr -> next;
	  }
	  if (tmp_order <= get_order[pid][this_id])
	  {
	    this_id = tmp_id;
	    if (get_order[pid][this_id] == 0)
	    {
	      from_id = MAX_AGENT;
	    }
	    else
	    {
	      from_id = agent_order[pid][get_order[pid][this_id] - 1];
	    }
	  }
	  free_link (pid_info[pid].message_ptr, 4);
	  pid_info[pid].message_ptr = NULL;
	  s_unlock (&lock[pid]);
	}
      }
    }				/* end of while TRUE */
    if (BAL && np > 0)
    {
      finish = TRUE;
      s_lock (&lock[np]);
      if (wait_for_work[pid])
      {
	printf ("In fact, I am not waiting\n");
	exit (0);
      }
      wait_for_work[pid] = TRUE;
      if (!balance_finish)
      {
	for (i = 0; i < np; i++)
	{
	  if (!wait_for_work[i])
	  {
	    finish = FALSE;
	    break;
	  }
	}
	if (finish)
	{
	  balance_finish = TRUE;
	  for (i = 0; i < np; i++)
	  {
	    if (i != pid)
	    {
	      still_pause[pid][i] = TRUE;
	    }
	  }
	}
      }
      else
      {
	finish = TRUE;
	for (i = 0; i < np; i++)
	{
	  if (i != pid && wait_for_work[i])
	  {
	    still_pause[pid][i] = TRUE;
	  }
	  wait_for_work[i] = FALSE;
	}
      }
      s_unlock (&lock[np]);
      if (!finish)
      {
	sleep_for_good = TRUE;
	for (i = 0; i < np; i++)
	{
	  sleep_kill_count[i] = 0;
	}
	while (sleep_for_good)
	{
	  sleep_for_good = FALSE;
	  for (i = 0; i < np; i++)
	  {
	    if (still_pause[pid][i])
	    {
	      sleep_for_good = TRUE;
	      sleep_kill_count[i]++;

	      kill (proc_ids[i], SIGUSR2);
	    }
	  }
	  for (i = 0; i < 1000 && sleep_for_good; i++)
	  {
	    ;
	  }
	  for (i = 0; i < np; i++)
	  {
	    if (sleep_kill_count[i] > 10)
	    {
	      printf ("P%d S %d tries to wake up P%d Pid%d S %d 10 times\n",
		  m_get_myid (), pid_info[pid].status,
		  i, proc_ids[i], pid_info[i].status);
	      sleep_kill_count[i] = 0;
	    }
	  }
	}

	pause ();

	for (i = 0; i < np; i++)
	{
	  if (i != pid)
	  {
	    still_pause[i][pid] = FALSE;
	  }
	}
	if (balance_finish)
	{
	  finish = TRUE;
	}
      }
    }
    else
    {
      finish = TRUE;
    }
  }				/* end of finish */

  for (i = 0; i < np; i++)
  {
    if (i != pid)
    {
      still_pause[i][pid] = FALSE;
    }
  }

  sleep_for_good = TRUE;
  for (i = 0; i < np; i++)
  {
    sleep_kill_count[i] = 0;
  }
  while (sleep_for_good)
  {
    sleep_for_good = FALSE;
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	sleep_for_good = TRUE;
	sleep_kill_count[i]++;

	kill (proc_ids[i], SIGUSR2);
      }
    }
    for (i = 0; i < 1000 && sleep_for_good; i++)
    {
      ;
    }
    for (i = 0; i < np; i++)
    {
      if (sleep_kill_count[i] > 10)
      {
	printf ("P%d S %d tries to wake up P%d Pid%d S %d 10 times\n",
	    m_get_myid (), pid_info[pid].status,
	    i, proc_ids[i], pid_info[i].status);
	sleep_kill_count[i] = 0;
      }
    }


  }
}				/* end of super_agent */

/* super_agent2 is used by distributed-agent-based algorithms (PS4) */

super_agent2 ()
{
  struct info *message_ptr;
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  SET tro_maker;
  SET dom_waiter;
  int   i;
  int   j;
  int   agent_id;
  int   this_id,
        from_id,
        next_id;
  int   finish;
  int   all_stop;
  int   sleep_for_good;
  int   wait_in_barr;
  int   next_order;
  int   this_order;
  int   wake_up;
  int   count;
  int   sleep_kill_count[MAX_PROCESSOR];
  int   kill_err;
  int   got_all_input;
  int   val_record[MAX_AGENT];

  for (i = 0; i < agent_count; i++)
  {
    agent_index[pid][i] -> send_place = -1;
  }

  for (i = 0; i < np; i++)
  {
    pid_info[pid].mail_numbers[i] = -1;
  }

  DID_SOMETHING[pid] = FALSE;

  if (SF || TRUE)
  {
    PART_SOL[pid] = FALSE;
    NO_MORE[pid] = FALSE;
    THIS_ID = -1;
    pid_info[pid].sol_length = 0;
  }

  private_check = 0;
  proc_ids[pid] = getpid ();
  for (i = 0; i < np; i++)
  {
    still_pause[pid][i] = FALSE;
  }

  if ((int) signal (SIGUSR2, set_signal) == -1)
  {
    fprintf (stderr, "later: Error during signal\n");
    exit (0);
  }

  for (i = 0; i < agent_count; i++)
  {
    agent_index[pid][i] -> to_be_sent = FALSE;
    agent_index[pid][i] -> logical_time = -1;
    agent_index[pid][i] -> logical_time2 = -1;
    agent_index[pid][i] -> next_id = -1;
    pid_info[pid].relation_link[i] = FALSE;
  }


  for (i = 0; i < agent_count; i++)
  {
    for (j = 0; j < np; j++)
    {
      agent_index[pid][i] -> out_link[j] = FALSE;
    }
  }

  for (i = 0; i < agent_count; i++)
  {
    for (j = 0; j < agent_count; j++)
    {
      if (agent_index[pid][i] -> processor_id == pid &&
	  agent_index[pid][i] -> relation[j] != -1 &&
	  agent_index[pid][j] -> order > pid_info[pid].high_order)
      {
	agent_index[pid][i] ->
	  out_link[agent_index[pid][j] -> processor_id] = TRUE;
      }
      if (agent_index[pid][i] -> processor_id == pid &&
	  agent_index[pid][i] -> relation[j] != -1 &&
	  agent_index[pid][j] -> order < pid_info[pid].lower_order)
      {
	pid_info[pid].relation_link[j] = TRUE;
      }
    }
    pid_info[pid].values[i] = -1;
    pid_info[pid].orders[i] = -1;
    pid_info[pid].places[i] = 14;
  }


  pid_info[pid].nothing_to_do = FALSE;

  if (D_O)
  {
    current_back_order[pid] = -1;
    current_order[pid] = pid_info[pid].lower_order - 1;
    for (i = 0; i < agent_count; i++)
    {
      dynamic_order[pid][i] = -1;
    }
    dynamic_order_up ();
  }

  finish = FALSE;
  all_stop = FALSE;
  this_id = agent_order[pid][pid_info[pid].lower_order];
  from_id = MAX_AGENT;
  next_id = MAX_AGENT;
  TESTING = FALSE;

  if (np > 1)
  {
    m_sync ();
  }

  while (TRUE)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d \n", pid, 2);
      private_check = 0;
    }
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	kill (proc_ids[i], SIGUSR2);
      }
    }
    this_order = pid_info[pid].high_order + 1;
    pid_info[pid].got_message = FALSE;
    wait_in_barr = FALSE;
    count = 5;
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 3);
      private_check = 0;
    }
    while (TRUE) /* for message */
    {
      private_check++;
      if (private_check == 10000)
      {
	printf ("P%d rests so long Mark %d\n", pid, 4);
	private_check = 0;
      }
      for (i = 0; i < np; i++)
      {
	if (i != pid)
	{
	  still_pause[i][pid] = FALSE;
	}
      }
      for (i = 0; i < np; i++)
      {
	if (still_pause[pid][i])
	{
	  kill (proc_ids[i], SIGUSR2);
	}
      }
      s_lock (&lock[pid]);
      message_ptr = pid_info[pid].message_ptr;
      if (message_ptr != NULL)
      {
	pid_info[pid].message_ptr = pid_info[pid].message_ptr -> next;
	if (pid_info[pid].message_ptr == NULL)
	{
	  pid_info[pid].tail_ptr = NULL;
	}
      }
      else
      {
	if (SF && (NO_MORE[pid] || pid_info[pid].sol_length >= SOL_LEN))
	{
	  pid_info[pid].status = 2;
	  wait_in_barr = TRUE;
	}
	else
	{
	  if (pid_info[pid].got_message == FALSE &&
	      pid_info[pid].nothing_to_do &&
	      ((pid != np - 1 && (!SF || (SF && NO_MORE[pid])))
		|| (pid == np - 1 && count < 0)))
	  {
	    pid_info[pid].status = 2;
	    wait_in_barr = TRUE;
	  }
	}
      }
      s_unlock (&lock[pid]);
      if (message_ptr != NULL)
      {
	message_ptr -> next = NULL;
	next_order = rece_message (message_ptr);
	switch (next_order)
	{
	  case -1: 		/* go from the first */
	    this_order = -1;
	    DID_SOMETHING[pid] = TRUE;
	    count = 5;
	    break;
	  case -2: 		/* do nothing */
	    break;
	  case -3: 		/* stop */
	    finish = TRUE;
	    break;
	  case -4: 		/* all stop */
	    all_stop = TRUE;
	    break;
	  default: 
	    DID_SOMETHING[pid] = TRUE;
	    if (next_order < this_order)
	    {
	      this_order = next_order;/* go from middle */
	    }
	    count = 5;
	    break;
	}
	free_info (message_ptr, 4);
	if (finish || all_stop)
	{
	  break;
	}
      }
      else
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 5);
	  private_check = 0;
	}
	if (wait_in_barr)
	{
	  for (i = 0; i < agent_count && !SF; i++)
	  {
	    if (agent_index[pid][i] != NULL &&
		agent_index[pid][i] -> processor_id == pid &&
		!set_Mem (agent_index[pid][i] -> avail_domain,
		  agent_index[pid][i] -> my_value))
	    {
	      printf ("P%d Why Sleep Now\n", pid);
	      display (1);
	      exit (0);
	    }
	  }
	  wait_in_barr = FALSE;
	  if (pid != np - 1)
	  {
	    wake_up = FALSE;
	    s_lock (&lock[np - 1]);
	    if (pid_info[np - 1].status == 2)
	    {
	      pid_info[np - 1].status = 1;
	      still_pause[pid][np - 1] = TRUE;
	      wake_up = TRUE;
	    }
	    s_unlock (&lock[np - 1]);
	    if (wake_up)
	    {
	      kill (proc_ids[np - 1], SIGUSR2);
	    }
	  }
	/* s_wait_barrier (&barrier[pid]); */
	  sleep_for_good = TRUE;
	  for (i = 0; i < np; i++)
	  {
	    sleep_kill_count[i] = 0;
	  }
	  while (sleep_for_good && pid_info[pid].status == 2)
	  {
	    private_check++;
	    if (private_check == 10000)
	    {
	      printf ("P%d rests so long Mark %d\n", pid, 6);
	      private_check = 0;
	    }
	    sleep_for_good = FALSE;
	    for (i = 0; i < np; i++)
	    {
	      if (still_pause[pid][i])
	      {
		sleep_for_good = TRUE;
		sleep_kill_count[i]++;

		kill (proc_ids[i], SIGUSR2);
	      }
	    }
	    for (i = 0; i < 1000 && sleep_for_good; i++)
	    {
	      ;
	    }
	    for (i = 0; i < np; i++)
	    {
	      if (sleep_kill_count[i] > 10)
	      {
		printf ("P%d S %d tries to wake up P%d Pid%d S %d 10 times\n",
		    m_get_myid (), pid_info[pid].status,
		    i, proc_ids[i], pid_info[i].status);
		sleep_kill_count[i] = 0;
	      }
	    }


	  }
	  if (pid_info[pid].status == 2)
	  {
	    sleep_for_good = TRUE;
	    for (i = 0; i < np; i++)
	    {
	      if (pid_info[i].status == 1)
	      {
		sleep_for_good = FALSE;
		break;
	      }
	    }
	    if (sleep_for_good)
	    {
	      fprintf (stderr, "P%d All Sleep Sol_Length %d\n", pid,
		  pid_info[pid].sol_length);
	      if (pid == np - 1)
	      {
		if (TESTING)
		{
		  printf ("Ohhhh, what can I do else?\n");
		  fprintf (out_ptr, "Ohhhh, what can I do else?\n");
		  exit (0);
		}
		pid_info[pid].terminated = logical_time[pid];
		logical_time[pid]++;
		send_mail (0, agent_order[pid][pid_info[pid].high_order],
		    -1, pid_info[pid].terminated, -1, 20, NULL,
		    empty, empty, 30);

		DID_SOMETHING[pid] = FALSE;
		TESTING = TRUE;
		sleep_for_good = TRUE;
		for (i = 0; i < np; i++)
		{
		  sleep_kill_count[i] = 0;
		}
		while (sleep_for_good && pid_info[pid].status == 2)
		{
		  private_check++;
		  if (private_check == 10000)
		  {
		    printf ("P%d rests so long Mark %d \n", pid, 7);
		    private_check = 0;
		  }
		  sleep_for_good = FALSE;
		  for (i = 0; i < np; i++)
		  {
		    if (still_pause[pid][i])
		    {
		      sleep_for_good = TRUE;
		      sleep_kill_count[i]++;

		      kill (proc_ids[i], SIGUSR2);
		    }
		  }
		  for (i = 0; i < 1000 && sleep_for_good; i++)
		  {
		    ;
		  }
		  for (i = 0; i < np; i++)
		  {
		    if (sleep_kill_count[i] > 10)
		    {
		      printf ("P%d S %d tries to wake up P%d Pid%d S %d 10 times\n",
			  m_get_myid (), pid_info[pid].status,
			  i, proc_ids[i], pid_info[i].status);
		      sleep_kill_count[i] = 0;
		    }
		  }


		}
		if (pid_info[pid].message_ptr == NULL)
		{
		  pause ();
		}
	      }
	    }
	    else
	    {
	      if (pid_info[pid].message_ptr == NULL)
	      {
		pause ();
	      }
	    }

	  /* pause (); */
	  }

	  for (i = 0; i < np; i++)
	  {
	    if (i != pid)
	    {
	      still_pause[i][pid] = FALSE;
	    }
	  }

	}
	else
	{
	  if (np == 1)
	  {
	    if (pid_info[pid].nothing_to_do)
	    {
	      finish = TRUE;
	    }
	    break;
	  }
	  if (pid == np - 1)
	  {
	    if (pid_info[pid].nothing_to_do)
	    {
	      got_all_input = TRUE;
	      for (i = 0; i < agent_count && got_all_input; i++)
	      {
		if (pid_info[pid].relation_link[i] &&
		    agent_index[pid][i] -> my_value <= -1)
		{
		  got_all_input = FALSE;
		}
	      }
	      if (got_all_input)
	      {
		count--;
		if (count < 0)
		{
		  if (!TESTING)
		  {
		    pid_info[pid].terminated = logical_time[pid];
		    logical_time[pid]++;
		    send_mail (0, agent_order[pid][pid_info[pid].high_order],
			-1, pid_info[pid].terminated, -1, 20,
			NULL, empty, empty, 29);
		    TESTING = TRUE;
		    DID_SOMETHING[pid] = FALSE;
		  }
		}
	      }
	      else
	      {
		count = -1;
	      }
	    }
	    else
	    {
	      break;
	    }
	  }
	  else
	  {
	    break;
	  }
	}
      }
    }
    for (i = 0; i < np; i++)
    {
      if (i != pid)
      {
	still_pause[i][pid] = FALSE;
      }
    }
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	kill (proc_ids[i], SIGUSR2);
      }
    }
    if (all_stop)
    {
      break;
    }
    if (finish)
    {
      if (next_id == agent_count /* out of agents */ )
      {
	for (i = 0; i < agent_count && !SF; i++)
	{
	  if (agent_index[pid][i] -> my_value != -1 &&
	      agent_index[pid][i] -> my_value !=
	      agent_index[agent_index[pid][i] -> processor_id][i]
	      -> my_value)
	  {
	    printf ("P%d Two Values Agent %d\n", pid, i);
	    fprintf (out_ptr, "P%d Two Values Agent %d\n", pid, i);
	    for (i = 0; i < np; i++)
	    {
	      pid = i;
	      display (1);
	    }
	    exit (0);
	  }

	  val_record[i] = agent_index[pid][i] -> my_value;
	  agent_index[pid][i] -> my_value =
	    agent_index[agent_index[pid][i] -> processor_id][i]
	    -> my_value;
	}
	for (i = 0; i < agent_count && SF; i++)
	{
	  val_record[i] = agent_index[pid][i] -> my_value;
	  if (agent_index[pid][i] -> order < pid_info[pid].lower_order)
	  {
	    if (pid_info[pid].relation_link[i] &&
		agent_index[pid][i] -> my_value == -1)
	    {
	      printf ("P%d UnFinished Agent %d\n", pid, i);
	      fprintf (out_ptr, "P%d UnFinished Agent %d\n", pid, i);
	      for (i = 0; i < np; i++)
	      {
		pid = i;
		display (1);
	      }
	      exit (0);
	    }
	    if (pid_info[pid].relation_link[i] &&
		agent_index[pid][i] -> my_value !=
		pid_info[agent_index[pid][i] -> processor_id].values[i])
	    {
	      printf ("P%d Two Values Agent %d\n", pid, i);
	      fprintf (out_ptr, "P%d Two Values Agent %d\n", pid, i);
	      for (i = 0; i < np; i++)
	      {
		pid = i;
		display (1);
	      }
	      for (i = 0; i < np; i++)
	      {
		pid = i;
		display (1);
	      }
	      exit (0);
	    }

	    agent_index[pid][i] -> my_value =
	      pid_info[agent_index[pid][i] -> processor_id].values[i];
	  }
	}
	logical_time[pid]++;
	TESTING = FALSE;
	monitor_finish ();
      /* got one result */
	solution_count[pid]++;
	for (i = 0; i < agent_count; i++)
	{
	  agent_index[pid][i] -> my_value = val_record[i];
	}

	if (!MULTI)		/* PS4 */
	{
	  break;		/* one result */
	}
	else
	{
	  for (i = 1; i < np - 1 && SF && FALSE; i++)
	  {
	    send_mail (i, agent_order[pid][pid_info[pid].lower_order],
		-1, -1, -1, 25, NULL, empty, empty, 28);
	  }
	  this_id = agent_order[pid][agent_count - 1];
	  from_id = this_id;
	  finish = FALSE;
	}

      }
      if (pid != np - 1 || !MULTI)
      {
	break;
      }
    }
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long\n", pid);
      private_check = 0;
    }
    if (PRINT)
    {
      printf ("P%d This_Order %d Next_id %d\n", pid, this_order, next_id);
      printf ("P%d Nothing %d Message %d Part_Sol %d\n",
	  pid, pid_info[pid].nothing_to_do,
	  pid_info[pid].message_ptr, PART_SOL[pid]);
    }
    if (this_order >= pid_info[pid].lower_order &&
	this_order <= pid_info[pid].high_order)
    {
      if (next_id >= agent_count ||
	  next_id >= 0 &&
	  this_order < get_order[pid][next_id])
      {
	this_id = agent_order[pid][this_order];
	from_id = MAX_AGENT;
      }
    }
    if (this_order == -1)	/* from the beginning */
    {
      this_id = agent_order[pid][pid_info[pid].lower_order];
      from_id = MAX_AGENT;
    }
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	kill (proc_ids[i], SIGUSR2);
      }
    }
    next_id = agent2 (this_id, from_id, next_id, tro_maker, dom_waiter);
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	kill (proc_ids[i], SIGUSR2);
      }
    }
    if (next_id == -1 || next_id == -2)
    {
      if (next_id == -1)
      {
	if (!SF)
	{
	  if (MULTI)
	  {
	    for (i = 0; i < np; i++)
	    {
	      if (i != pid)
	      {
		send_mail (i, this_id,
		    -1, -1, -1, 23, NULL, empty, empty, 27);
	      }
	    }
	  }
	  else
	  {
	    printf ("P%d ?????\n", pid);
	    fprintf (out_ptr, "P%d ?????\n", pid);
	    display (1);
	    exit (0);
	  }
	  break;
	}
	else
	{
	  if (THIS_ID == -2)
	  {
	    if (MULTI)
	    {
	      printf ("P%d is going to stop\n", pid);
	      for (i = 0; i < np; i++)
	      {
		if (i != pid)
		{
		  send_mail (i, this_id,
		      -1, -1, -1, 23, NULL, empty, empty, 26);
		}
	      }
	    }
	    else
	    {
	      printf ("P%d ?????\n", pid);
	      fprintf (out_ptr, "P%d ?????\n", pid);
	      display (1);
	      exit (0);
	    }
	    break;
	  }
	  else
	  {
	    if (!NO_MORE[pid])
	    {
	      NO_MORE[pid] = TRUE;
	      next_id = agent_count + 1;
	      pid_info[pid].nothing_to_do = TRUE;
	      if (pid > 0 && THIS_ID < 0)
	      {
		printf ("P%d THIS_ID %d\n", pid, THIS_ID);
		display (1);
		exit (0);
	      }
	    }
	    else
	    {
	      printf ("P%d Dead Nothing %d Message %d Part_Sol %d\n",
		  pid, pid_info[pid].nothing_to_do,
		  pid_info[pid].message_ptr, PART_SOL[pid]);
	      display (1);
	      exit (0);
	    }
	  }
	}
      }
      if (next_id == -2)
      {
	from_id = this_id;
	this_id = agent_order[pid][pid_info[pid].lower_order];
	pid_info[pid].nothing_to_do = FALSE;
	printf ("P%d next_id == -2\n", pid);
	display (1);
	exit (0);
      }
    }
    else
    {
      if (next_id >= agent_count)
      {
	if (SF)
	{
	  pid_info[pid].nothing_to_do = TRUE;
	  if (pid != np - 1)
	  {
	    this_id = agent_order[pid][pid_info[pid].high_order];
	    from_id = this_id;
	    if (!PART_SOL[pid])
	    {
	      if (SOL_LEN > 0)
	      {
		PART_SOL[pid] = TRUE;
	      }
	    }
	    else
	    {
	      add_solution ();
	    }
	    make_nogood3 (this_id, from_id);
	  }
	}
	else
	{
	  pid_info[pid].nothing_to_do = TRUE;
	}
	pid_info[pid].got_message = FALSE;
      }
      else
      {
	from_id = this_id;
	this_id = next_id;
	if (!SF || (SF && !PART_SOL[pid]))
	{
	  pid_info[pid].nothing_to_do = FALSE;
	}
      }
    }
  }

  sleep_for_good = TRUE;
  for (i = 0; i < np; i++)
  {
    sleep_kill_count[i] = 0;
  }
  while (sleep_for_good)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 8);
      private_check = 0;
    }
    sleep_for_good = FALSE;
    for (i = 0; i < np; i++)
    {
      if (still_pause[pid][i])
      {
	sleep_for_good = TRUE;
	sleep_kill_count[i]++;

	kill (proc_ids[i], SIGUSR2);
      }
    }
    for (i = 0; i < 1000 && sleep_for_good; i++)
    {
      ;
    }
    for (i = 0; i < np; i++)
    {
      if (sleep_kill_count[i] > 10)
      {
	printf ("P%d S %d tries to wake up P%d Pid%d S %d 10 times\n",
	    m_get_myid (), pid_info[pid].status,
	    i, proc_ids[i], pid_info[i].status);
	sleep_kill_count[i] = 0;
      }
    }


  }

}				/* end of super_agent2 */

/* the super_agent3 is used by function-agent-based algorithms (PS5) */

super_agent3 ()
{
  struct info *message_ptr;
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  SET tro_maker;
  SET dom_waiter;
  int   i;
  int   j;
  int   agent_id;
  int   this_id,
        from_id,
        next_id;
  int   finish;

  for (i = 0; i < agent_count; i++)
  {
    agent_index[pid][i] -> send_place = -1;
  }

  for (i = 0; i < np; i++)
  {
    pid_info[pid].mail_numbers[i] = -1;
  }

  DID_SOMETHING[pid] = FALSE;

  if (D_O)
  {
    current_back_order[pid] = -1;
    current_order[pid] = pid_info[pid].lower_order - 1;
    for (i = 0; i < agent_count; i++)
    {
      dynamic_order[pid][i] = -1;
    }
    dynamic_order_up ();
  }

  this_id = agent_order[pid][pid_info[pid].lower_order];
  from_id = MAX_AGENT;
  next_id = MAX_AGENT;
  while (TRUE)
  {
    next_id = agent2 (this_id, from_id, next_id, tro_maker, dom_waiter);
    if (next_id == -1 || next_id == -2)
    {
      if (next_id == -2)
      {
	printf ("P%d ?????\n", pid);
	fprintf (out_ptr, "P%d ?????\n", pid);
	display (1);
	exit (0);
      }
      break;
    }
    else
    {
      if (next_id >= agent_count)
      {
	monitor_finish ();
      /* got one result */
	solution_count[pid]++;

	if (!MULTI)		/* PS4 */
	{
	  break;		/* one result */
	}
	else
	{
	  this_id = agent_order[pid][agent_count - 1];
	  from_id = this_id;
	}

      }
      else
      {
	from_id = this_id;
	this_id = next_id;
      }
    }
  }
}				/* end of super_agent3 */

/*
 * Agent in DCSP
 */

/* agent is called by super_agent 
   sequential & parallel-agent-based algorithms */

int   agent (my_id, from_id, next_id, tro_maker, dom_waiter)
int   my_id;
int   from_id;
int   next_id;
SET tro_maker;
SET dom_waiter;
{
  SET temp_domain;
  SET temp_domain2;
  SET f_no;
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr,
             *my_nogood_ptr,
             *nogood_ptr;
  int   found;
  int   old_value;
  int   i,
        j,
        k;
  int   agent_id;
  int   tro_id;
  int   this_id;
  int   remove_dom;
  int   visit_node = -1;
  int   changed;



  agent_ptr = agent_index[pid][my_id];
  old_value = agent_ptr -> my_value;

 /* Begin for new answer ? */


  if ((get_order[pid][from_id] == agent_count - 1) && (from_id == my_id))
  {
    if (FC != 5)
    {
    /* set virtual conf_record */
    /* It should contain all agents in the net work */
    /* virtual tro_maker  */

      set_Empty (temp_domain);
      for (i = 0; i < agent_count; i++)
      {
	if (get_order[pid][i] < agent_ptr -> order)
	{
	  set_Add (temp_domain, i);
	  agent_ptr -> in_link[i] = TRUE;
	}
      }

      make_nogood (agent_ptr, temp_domain, empty, from_id);

    }
    else
    {
      set_Del (agent_ptr -> avail_domain, agent_ptr -> my_value);
      for (i = 0; i < agent_count; i++)
      {
	if (get_order[pid][i] < agent_ptr -> order)
	{
	  set_Add (agent_ptr -> conf_set, i);
	}
      }
    }

  }

 /* if there is no value, backtrack */

  while (!set_Ele (agent_ptr -> avail_domain))
  {
    next_id = backtrack (my_id, dom_waiter, tro_maker);

    if ((FC == 2 || FC == 4) && next_id > -1 && next_id != my_id)
    {
      make_nogood (agent_index[pid][next_id], tro_maker,
	  dom_waiter, agent_ptr -> my_id);
    }

    if (FC == 2 && next_id != -1)/* FC2 */
    {
      for (i = agent_ptr -> order; i >= get_order[pid][next_id]; i--)
      {
	this_id = agent_order[pid][i];
	for (j = i + 1; j < agent_count; j++)
	{
	  agent_id = agent_order[pid][j];

	  if (agent_index[pid][agent_id] -> position_ptr[this_id] != NULL)
	  {
	    undo_reduction_ret_still (agent_id, this_id, TRUE);
	  }

	  if (agent_index[pid][agent_id] -> in_link[this_id] != FALSE)
	  {
	    del_ng_sel_return (agent_index[pid][agent_id], this_id, FALSE, 31);
	  }
	}

      }
    }
    if (FC == 4 && next_id != -1 && D_O)/* FC4 */
    {
      for (i = agent_ptr -> order + 1; i < agent_count &&
	  next_id != my_id; i++)
      {
	agent_id = agent_order[pid][i];

      /* undo reductions of my_id */
	if (agent_index[pid][agent_id] -> position_ptr[my_id] != NULL)
	{
	  undo_reduction_ret_still (agent_id, my_id, TRUE);
	}

      /* undo nogoods of my_id */
	if (agent_index[pid][agent_id] -> in_link[my_id] != FALSE)
	{
	  del_ng_sel_return (agent_index[pid][agent_id], my_id, TRUE, 30);
	}

      }
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;

      if (current_back_order[pid] < agent_ptr -> order)
      {
	current_back_order[pid] = agent_ptr -> order;
      }
    }
    if (FC == 5 && next_id != -1)/* FC5 */
    {
      set_Union (agent_index[pid][next_id] -> conf_set, tro_maker,
	  agent_index[pid][next_id] -> conf_set);
      set_Del (agent_index[pid][next_id] -> conf_set, next_id);
      for (i = agent_ptr -> order; i > get_order[pid][next_id]; i--)
      {
	this_id = agent_order[pid][i];
	set_Empty (agent_index[pid][this_id] -> conf_set);
      /* undo reductions */
	for (j = i + 1; j < agent_count; j++)
	{
	  agent_id = agent_order[pid][j];
	  if (agent_index[pid][agent_id] -> position_ptr[this_id] != NULL)
	  {
	    undo_reduction_ret_still (agent_id, this_id, TRUE);
	    set_Del (agent_index[pid][agent_id] -> past_fc, this_id);
	  }
	}
	set_Empty (agent_index[pid][this_id] -> future_fc);
      /* update current domain */
	set_Assign (agent_index[pid][this_id] -> avail_domain,
	    agent_index[pid][this_id] -> domain);
	temp1_ptr = agent_index[pid][this_id] -> value_view_ptr;
	while (temp1_ptr != NULL)
	{
	  set_Minus (agent_index[pid][this_id] -> avail_domain,
	      temp1_ptr -> set1, agent_index[pid][this_id] -> avail_domain);
	  temp1_ptr = temp1_ptr -> next;
	}

      }
    /* undo reductions (next_id) */
      this_id = next_id;
      for (j = get_order[pid][next_id] + 1; j < agent_count; j++)
      {
	agent_id = agent_order[pid][j];
	if (agent_index[pid][agent_id] -> position_ptr[this_id] != NULL)
	{
	  undo_reduction_ret_still (agent_id, this_id, TRUE);
	  set_Del (agent_index[pid][agent_id] -> past_fc, this_id);
	}
      }
      set_Empty (agent_index[pid][this_id] -> future_fc);
    /* remove val(h) */
      set_Del (agent_index[pid][next_id] -> avail_domain,
	  agent_index[pid][next_id] -> my_value);

    }
    if (PRINT)
    {
      printf ("P%d VN %d M_id %d Or %d F_id %d Or %d N_id %d O_Val %d Val %d \n",
	  pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	  get_order[pid][from_id], next_id, old_value, -2);
      if (out_ptr != stdout)
	fprintf (out_ptr, "P%d VN %d Mid %d Or %d Fid %d Or %d Nid %d OV %d V %d\n",
	    pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	    get_order[pid][from_id], next_id, old_value, -2);
    }
    if (D_O && next_id != -1 && FC != 4)
    {
      dynamic_order_down (agent_ptr -> order, get_order[pid][next_id]);
    }
    return next_id;
  }				/* end of while  */

 /* yes, we got a value */

  changed = FALSE;
  if (!set_Mem (agent_ptr -> avail_domain, agent_ptr -> my_value))
  {
    agent_ptr -> my_value = set_First (agent_ptr -> avail_domain);
    changed = TRUE;
    private_check = 0;
  }

  switch (FC)
  {
    case 2: 			/* FC2 fc-cbj-ng */
      tro_id = forward_check2 (my_id, agent_ptr -> my_value,
	  tro_maker, dom_waiter);
      if (tro_id != -1)
      {
	make_nogood (agent_ptr,
	    tro_maker, dom_waiter, agent_ptr -> my_id);
	next_id = agent_ptr -> my_id;
      }
      else
      {
      /* going to search agent */
	if (agent_ptr -> order == (agent_count - 1))
	{
	  next_id = agent_count;
	}
	else
	{
	  if (RCV)
	  {
	  /*  is nothing changes, go further */
	    for (i = agent_ptr -> order + 1; i < agent_count; i++)
	    {
	      agent_id = agent_order[pid][i];
	      if (!set_Mem (agent_index[pid][agent_id] -> avail_domain,
		    agent_index[pid][agent_id] -> my_value))
	      {
		break;
	      }
	      else
	      {
		if (forward_check2 (agent_id,
		      agent_index[pid][agent_id] -> my_value,
		      tro_maker, dom_waiter) != -1)
		{
		  make_nogood (agent_index[pid][agent_id], tro_maker,
		      dom_waiter, agent_id);
		  break;
		}
	      }
	    }
	    if (i == agent_count)
	    {
	      next_id = agent_count;
	    }
	    else
	    {
	      next_id = agent_id;
	    }
	  }
	  else
	  {
	    if (D_O)
	    {
	      dynamic_order_up ();
	    }
	    next_id = agent_order[pid][agent_ptr -> order + 1];
	  }
	}
      }

      break;
    case 4: 			/* FC4 fc-cbj-ng-pr */
      tro_id = forward_check4 (my_id, agent_ptr -> my_value,
	  tro_maker, dom_waiter, changed);
      if (tro_id != -1)
      {
	make_nogood (agent_ptr,
	    tro_maker, dom_waiter, agent_ptr -> my_id);
	next_id = agent_ptr -> my_id;
      }
      else
      {
      /* going to search agent */
	if (agent_ptr -> order == agent_count - 1)
	{
	  next_id = agent_count;
	}
	else
	{
	  if (RCV || D_O)
	  {
	    if (RCV)
	    {
	    /*  is nothing changes, go further */
	      for (i = agent_ptr -> order + 1; i < agent_count; i++)
	      {
		agent_id = agent_order[pid][i];
		if (!set_Mem (agent_index[pid][agent_id] -> avail_domain,
		      agent_index[pid][agent_id] -> my_value))
		{
		  break;
		}
		else
		{
		  if (forward_check4 (agent_id,
			agent_index[pid][agent_id] -> my_value,
			tro_maker, dom_waiter, FALSE) != -1)
		  {
		    make_nogood (agent_index[pid][agent_id], tro_maker,
			dom_waiter, agent_id);
		    break;
		  }
		}
	      }
	      if (i == agent_count)
	      {
		next_id = agent_count;
	      }
	      else
	      {
		next_id = agent_id;
	      }
	    }
	    if (D_O)
	    {
	      next_id = sel_next_id (my_id);
	    }
	  }
	  else
	  {
	    next_id = agent_order[pid][agent_ptr -> order + 1];
	  }
	}
      }

      break;
    case 5: 			/* FC5 fc-cbj */
      tro_id = forward_check5 (my_id, agent_ptr -> my_value,
	  tro_maker, dom_waiter);
      if (tro_id != -1)
      {
	next_id = agent_ptr -> my_id;
      }
      else
      {
      /* going to search agent */
	if (agent_ptr -> order == (agent_count - 1))
	{
	  next_id = agent_count;
	}
	else
	{
	  if (D_O)
	  {
	    dynamic_order_up ();
	  }
	  next_id = agent_order[pid][agent_ptr -> order + 1];
	}
      }
      break;
    default: 
      printf ("No FCs\n");
      exit (0);
  }

  if (PRINT)
  {
    printf ("P%d VN %d M_id %d Or %d F_id %d Or %d N_id %d O_Val %d Val %d\n",
	pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	get_order[pid][from_id], next_id, old_value,
	agent_ptr -> my_value);
    if (out_ptr != stdout)
      fprintf (out_ptr, "P%d VN %d Mid %d Or %d Fid %d Or %d Nid %d OV %d V %d\n",
	  pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	  get_order[pid][from_id], next_id, old_value,
	  agent_ptr -> my_value);
  }

  return next_id;
}				/* end of agent */


/* agent2 is called by super_agent2 and super_agent3 
   distributed and function-agent-based algorithms PS4,5 */

int   agent2 (my_id, from_id, next_id, tro_maker, dom_waiter)
int   my_id;
int   from_id;
int   next_id;
SET tro_maker;
SET dom_waiter;
{
  SET temp_domain;
  struct agent_home *agent_ptr;
  struct info *temp1_ptr;
  int   old_value;
  int   i,
        j,
        k;
  int   agent_id;
  int   tro_id;
  int   this_id;
  int   visit_node = -1;
  int   changed;


  agent_ptr = agent_index[pid][my_id];
  old_value = agent_ptr -> my_value;

 /* Begin for new answer ? */

  agent_ptr -> move_nogood_ptr = NULL;

  if ((from_id == my_id) && (agent_ptr -> my_value > -1) &&
      (!SF || SF && (pid == np - 1 || PART_SOL[pid])))
  {
  /* set virtual conf_record */
  /* virtual tro_maker  */

    if (get_order[pid][my_id] != pid_info[pid].high_order)
    {
      printf ("P%d My_Id %d Is Not OK\n", pid, my_id);
      fprintf (out_ptr, "P%d My_Id %d Is Not OK\n", pid, my_id);
      display (1);
      exit (0);
    }
    set_Empty (temp_domain);
    for (i = 0; i < agent_count && FALSE; i++)
    {
      if (get_order[pid][i] < agent_ptr -> order &&
    /* my_value has a new value before monitor */
	  agent_index[pid][i] -> my_value > -1 /* CHANGE HERE */ )
      {
	if (SF)
	{
	  if (agent_index[pid][i] -> logical_time > 0)
	  {
	    set_Add (temp_domain, i);
	    agent_ptr -> in_link[i] = TRUE;
	  }
	}
	else
	{
	  set_Add (temp_domain, i);
	  agent_ptr -> in_link[i] = TRUE;
	}
      }
    }

    for (i = 0; i < agent_count; i++)
    {
      if (get_order[pid][i] < agent_ptr -> order)
      {
	set_Add (temp_domain, i);
	agent_ptr -> in_link[i] = TRUE;
      }
    }

    make_nogood (agent_ptr, temp_domain, empty, from_id);

  }

 /* find a value */

 /* if there is no value, backtrack */

  while (!set_Ele (agent_ptr -> avail_domain))
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 9);
      private_check = 0;
    }
    if (PS != 5)
    {
      next_id = backtrack (my_id, dom_waiter, tro_maker);
    }
    else
    {
      next_id = backtrack2 (my_id, dom_waiter, tro_maker);
    }
    if (next_id > -1 && next_id != my_id)
    {
      make_nogood (agent_index[pid][next_id], tro_maker,
	  dom_waiter, agent_ptr -> my_id);
    }
    if ((FC == 6 || FC == 7) && next_id != -1 && next_id != -2 && D_O)
    {

      for (i = pid_info[pid].lower_order;
	  i < agent_count	/* <= pid_info[pid].high_order */
	  && next_id != my_id; i++)
      {
	agent_id = agent_order[pid][i];

      /* undo reductions of my_id */
	if (agent_index[pid][agent_id] -> position_ptr[my_id] != NULL)
	{
	  undo_reduction_ret_still (agent_id, my_id, TRUE);
	}

      /* undo nogoods of my_id */
	if (agent_index[pid][agent_id] -> in_link[my_id] != FALSE)
	{
	  del_ng_sel_return (agent_index[pid][agent_id], my_id, TRUE, 29);
	}
      }
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;
      if (current_back_order[pid] < agent_ptr -> order)
      {
	current_back_order[pid] = agent_ptr -> order;
      }
    }
    if (PRINT)
    {
      printf ("P%d VN %d M_id %d Or %d F_id %d Or %d N_id %d O_Val %d Val %d NM %d P_S %d\n",
	  pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	  get_order[pid][from_id], next_id, old_value, -2,
	  NO_MORE[pid], PART_SOL[pid]);
    }

    if (next_id != -2 && next_id != my_id)
    {
      agent_ptr -> next_id = next_id;
      return next_id;
    }
  }				/* end of while  */

 /* yes, we got a value */

  changed = FALSE;
  if (!set_Mem (agent_ptr -> avail_domain, agent_ptr -> my_value))
  {
    agent_ptr -> my_value = set_First (agent_ptr -> avail_domain);
    agent_ptr -> logical_time2 = logical_time[pid];
    logical_time[pid]++;
    changed = TRUE;
    if (!SF || (SF && !PART_SOL[pid]))
    {
      DID_SOMETHING[pid] = TRUE;
    }
    private_check = 0;
  }


  switch (FC)
  {
    case 6: 			/* distributed fc-cbj-ng-pr */
      tro_id = forward_check6 (my_id, agent_ptr -> my_value,
	  tro_maker, dom_waiter, changed);
      if (tro_id != -1)
      {
	make_nogood (agent_ptr, tro_maker, dom_waiter, agent_ptr -> my_id);
	next_id = agent_ptr -> my_id;
      }
      else
      {
	if (!SF)
	{
	  for (i = 0; i < np && changed && agent_ptr -> my_value > -1; i++)
	  {
	    if (agent_ptr -> out_link[i])
	    {
	      pid_info[pid].values[my_id] = agent_ptr -> my_value;
	      pid_info[pid].orders[my_id] = agent_ptr -> order;
	      pid_info[pid].places[my_id] = 13;
	      send_mail (i, my_id, -1, agent_ptr -> my_value,
		  agent_ptr -> order, 2, NULL, empty, empty, 25);
	    }
	  }
	}
	else
	{
	/* some change */
	  agent_ptr -> to_be_sent = TRUE;
	  if (!PART_SOL[pid])
	  {
	    send_ok (agent_ptr -> order, 4);
	  }
	}
      /* going to search agent */
	if (agent_ptr -> order == pid_info[pid].high_order)
	{
	  if (pid == np - 1)
	  {
	    next_id = agent_count;
	  }
	  else
	  {
	    next_id = agent_count + 1;
	  }
	}
	else
	{
	  if (D_O)
	  {
	    next_id = sel_next_id (my_id);
	  }
	  else
	  {
	    next_id = agent_order[pid][agent_ptr -> order + 1];
	  }
	}
      }
      break;
    case 7: 			/* FC7 function fc-cbj-ng-pr */
      FORD_CHECK = TRUE;
      m_fork (multi_check_release, my_id, agent_ptr -> my_value,
	  agent_ptr -> order + 1, agent_count, changed, TRUE);
      if (!FORD_CHECK)
      {
	next_id = agent_ptr -> my_id;
      }
      else
      {
      /* going to search agent */
	if (agent_ptr -> order == pid_info[pid].high_order)
	{
	  next_id = agent_count;
	}
	else
	{
	  if (D_O)
	  {
	    next_id = sel_next_id (my_id);
	  }
	  else
	  {
	    next_id = agent_order[pid][agent_ptr -> order + 1];
	  }
	}
      }
      break;
    default: 
      printf ("No FCs\n");
      exit (0);
  }

  while (agent_ptr -> move_nogood_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 10);
      private_check = 0;
    }
    temp1_ptr = agent_ptr -> move_nogood_ptr;
    agent_ptr -> move_nogood_ptr = temp1_ptr -> next;
    if (agent_ptr -> my_value > -1)
    {
      temp1_ptr -> next = agent_index[pid][temp1_ptr -> to_id] -> nogood_ptr;
      agent_index[pid][temp1_ptr -> to_id] -> nogood_ptr = temp1_ptr;
      for (i = 0; i < agent_count; i++)
      {
	if (set_Mem (temp1_ptr -> set1, i))
	{
	  agent_index[pid][temp1_ptr -> to_id] -> in_link[i] = TRUE;
	}
      }
    }
    else
    {
      set_Add (agent_index[pid][temp1_ptr -> to_id] -> avail_domain,
	  temp1_ptr -> value);
      agent_index[pid][temp1_ptr -> to_id] -> avail_length++;
      free_pointer (temp1_ptr, 3);
    }
  }

  if (PRINT)
  {
    printf ("P%d VN %d M_id %d Or %d F_id %d Or %d N_id %d O_Val %d Val %d NM %d P_S %d\n",
	pid, visit_node, my_id, agent_index[pid][my_id] -> order, from_id,
	get_order[pid][from_id], next_id, old_value,
	agent_ptr -> my_value, NO_MORE[pid], PART_SOL[pid]);
  }

  agent_ptr -> next_id = next_id;
  return next_id;
}				/* end of agent2 */

/* undo reductions */

undo_reduction_ret_still (agent_id, this_id, is_return)
int   agent_id;
int   this_id;
int   is_return;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr;

  agent_ptr = agent_index[pid][agent_id];

  if (agent_ptr == NULL || agent_ptr -> processor_id != pid)
  {
    printf ("P%d UR Caught %d PTR %d ITS_PID %d\n", pid, 0,
	agent_ptr, agent_ptr -> processor_id);
    exit (0);
  }

  if (agent_ptr -> relation[this_id] != -1)
  {
  /* there is a reduction */

  /* collect its reductions */

    temp1_ptr = agent_ptr -> position_ptr[this_id];
    if (temp1_ptr == NULL)
    {
      printf ("Undo_reduction has no such view %d in agent_view %d\n",
	  this_id, agent_id);
      display (1);
      exit (0);
    }

    if (is_return)
    {
      if (temp1_ptr -> length > 0)
      {
	set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1 /* reductions */ ,
	    agent_ptr -> avail_domain);
	agent_ptr -> avail_length =
	  agent_ptr -> avail_length + temp1_ptr -> length;
      }
    }
    else
    {
      if (temp1_ptr -> length > 0)
      {
	agent_ptr -> avail_length = agent_ptr -> avail_length +
	  temp1_ptr -> length;
	still_reduction (agent_ptr, temp1_ptr -> set1, temp1_ptr);
	set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
	    agent_ptr -> avail_domain);
      }
    }

  /* remove ( this_id and its value from agent_info ) */

    if (temp1_ptr == agent_ptr -> value_view_ptr)
    {
      agent_ptr -> value_view_ptr = temp1_ptr -> next;
      if (temp1_ptr -> next != NULL)
      {
	temp1_ptr -> next -> front = NULL;
      }
    }
    else
    {
      temp1_ptr -> front -> next = temp1_ptr -> next;
      if (temp1_ptr -> next != NULL)
      {
	temp1_ptr -> next -> front = temp1_ptr -> front;
      }
    }

    if (temp1_ptr == agent_ptr -> view_tail_ptr)
    {
      agent_ptr -> view_tail_ptr = temp1_ptr -> front;
      if (temp1_ptr -> front != NULL)
      {
	temp1_ptr -> front -> next = NULL;
      }
    }
    else
    {
      temp1_ptr -> next -> front = temp1_ptr -> front;
      if (temp1_ptr -> front != NULL)
      {
	temp1_ptr -> front -> next = temp1_ptr -> next;
      }
    }

    free_pointer ((struct info *) temp1_ptr, 2);
    agent_ptr -> position_ptr[this_id] = NULL;

  }
}				/* undo_reduction_ret_still */

/* fc-cbj-ng */

int
      forward_check2 (my_id, my_value, tro_maker, dom_waiter)
int   my_id,
      my_value;
SET tro_maker;
SET dom_waiter;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr;
  int   found;
  int   i,
        j,
        k;
  int   order;
  int   this_id;
  int   agent_id;

  for (order = agent_index[pid][my_id] -> order + 1;
      order < agent_count; order++)
  {
    i = agent_order[pid][order];
    if (agent_index[pid][i] != NULL &&
	agent_index[pid][i] -> relation[my_id] != -1 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

    /* we need return the old_reduction caused by old_value */

      found = FALSE;
      temp1_ptr = agent_ptr -> position_ptr[my_id];
      if (temp1_ptr != NULL)
      {
	found = TRUE;
	this_ptr = temp1_ptr;
	if (temp1_ptr -> value != my_value)
	{
	/* del no_good which was related to it */
	  if (agent_ptr -> in_link[my_id] != FALSE)
	  {
	    del_ng_sel_return (agent_ptr, my_id, FALSE, 28);
	  }
	  temp1_ptr -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	/* have a record of reduction */
	  if (temp1_ptr -> length > 0)
	  {
	    set_Union (agent_ptr -> avail_domain,
		temp1_ptr -> set1 /* reduction */ ,
		agent_ptr -> avail_domain);
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    set_Empty (temp1_ptr -> set1 /* reductions */ );
	  }
	/* change the its value */
	  temp1_ptr -> value = my_value;
	  temp1_ptr -> length = 0;
	  make_reduction (agent_ptr, agent_ptr -> avail_domain,
	      temp1_ptr);
	/* we need move the view to the head of agent_view */
	/* if it is not a head, remove it first */
	  if (agent_ptr -> value_view_ptr != temp1_ptr)
	  {
	    printf ("Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    fprintf (out_ptr, "Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    display (1);
	    exit (0);
	  }
	}
      }
      if (!found)
      {
      /* del no_good which was related to it */
	if (agent_ptr -> in_link[my_id] != FALSE)
	{
	  del_ng_sel_return (agent_ptr, my_id, FALSE, 27);
	}
	apply_info (&temp1_ptr, 2);
	temp1_ptr -> id = my_id;
	temp1_ptr -> value = my_value;
	temp1_ptr -> next = agent_ptr -> value_view_ptr;
	temp1_ptr -> logical_time = logical_time[pid];
	logical_time[pid]++;
	agent_ptr -> value_view_ptr = temp1_ptr;
	agent_ptr -> value_view_ptr -> front = NULL;
	if (agent_ptr -> value_view_ptr -> next == NULL)
	{
	  agent_ptr -> view_tail_ptr = agent_ptr -> value_view_ptr;
	}
	else
	{
	  agent_ptr -> value_view_ptr -> next -> front =
	    agent_ptr -> value_view_ptr;
	}
	this_ptr = temp1_ptr;
	agent_ptr -> position_ptr[my_id] = temp1_ptr;
      /* set the reduction */
	temp1_ptr -> length = 0;
	make_reduction (agent_ptr,
	    agent_ptr -> avail_domain, temp1_ptr);
      }
      if (!set_Ele (agent_ptr -> avail_domain))
      {
	set_Empty (tro_maker);
	set_Empty (dom_waiter);
	find_trowait (agent_ptr, tro_maker, dom_waiter);
	for (k = 0; k < MAX_DOMAIN && FALSE; k++)
	{
	  if (set_Mem (tro_maker, k) &&
	      get_order[pid][k] > get_order[pid][my_id])
	  {
	    printf ("Pid %d Why Ag %d Or %d Be My_id %d Or %d in Ag %d\n",
		pid, k, get_order[pid][k], my_id, get_order[pid][my_id], i);
	    printf ("Pid %d My_V1 %d My_V2 %d This_Id %d\n",
		pid, my_value, agent_ptr -> position_ptr[my_id] -> value,
		agent_ptr -> my_id);
	    print_view (agent_ptr, stdout);
	    print_nogoods (agent_ptr, stdout);
	    fprintf (out_ptr, "Pid %d Why Ag %d Or %d Be Mid %d Or %d in Ag %d\n",
		pid, k, get_order[pid][k], my_id, get_order[pid][my_id], i);
	    fprintf (out_ptr, "Pid %d My_V1 %d My_V2 %d This_Id %d\n",
		pid, my_value, agent_ptr -> position_ptr[my_id] -> value,
		agent_ptr -> my_id);
	    print_view (agent_ptr, out_ptr);
	    print_nogoods (agent_ptr, out_ptr);
	    display (1);
	    exit (0);
	  }
	}
	return i;
      }
    }

  }				/* end of for i */
  return - 1;
}				/* end of forward_check2 */

/* fc-cbj-ng-pr */

int
      forward_check4 (my_id, my_value, tro_maker, dom_waiter, changed)
int   my_id,
      my_value;
SET tro_maker;
SET dom_waiter;
int   changed;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr;
  int   found;
  int   i,
        j,
        k;
  int   order;
  int   this_id;
  int   agent_id;

  for (order = agent_index[pid][my_id] -> order + 1;
      order < agent_count; order++)
  {
    i = agent_order[pid][order];
    if (agent_index[pid][i] != NULL &&
	agent_index[pid][i] -> relation[my_id] != -1 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

      if (agent_ptr -> position_ptr[my_id] == NULL ||
	  (agent_ptr -> position_ptr[my_id] != NULL &&
	    agent_ptr -> position_ptr[my_id] -> value != my_value) ||
	  !set_Ele (agent_ptr -> avail_domain))
      {
      /* release reductions caused by higher order agents */

	temp1_ptr = agent_ptr -> value_view_ptr;
	while (temp1_ptr != NULL &&
	    get_order[pid][temp1_ptr -> id] > get_order[pid][my_id])
	{
	  temp2_ptr = temp1_ptr -> next;

	  if (agent_ptr -> relation[temp1_ptr -> id] != -1 &&
	      temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
		agent_ptr -> avail_domain);
	  }

	/* remove ( this_id and its value from agent_info ) */

	  if (temp1_ptr == agent_ptr -> value_view_ptr)
	  {
	    agent_ptr -> value_view_ptr = temp1_ptr -> next;
	    if (temp1_ptr -> next != NULL)
	    {
	      temp1_ptr -> next -> front = NULL;
	    }
	  }
	  else
	  {
	    temp1_ptr -> front -> next = temp1_ptr -> next;
	    if (temp1_ptr -> next != NULL)
	    {
	      temp1_ptr -> next -> front = temp1_ptr -> front;
	    }
	  }

	  if (temp1_ptr == agent_ptr -> view_tail_ptr)
	  {
	    agent_ptr -> view_tail_ptr = temp1_ptr -> front;
	    if (temp1_ptr -> front != NULL)
	    {
	      temp1_ptr -> front -> next = NULL;
	    }
	  }
	  else
	  {
	    temp1_ptr -> next -> front = temp1_ptr -> front;
	    if (temp1_ptr -> front != NULL)
	    {
	      temp1_ptr -> front -> next = temp1_ptr -> next;
	    }
	  }

	  agent_ptr -> position_ptr[temp1_ptr -> id] = NULL;
	  free_pointer ((struct info *) temp1_ptr, 2);
	  temp1_ptr = temp2_ptr;
	}

      /* release nogoods */
	for (j = get_order[pid][my_id] + 1; j < agent_ptr -> order; j++)
	{
	  this_id = agent_order[pid][j];

	  if (agent_ptr -> in_link[this_id] != FALSE)
	  {
	    if (agent_ptr -> relation[this_id] == -1)
	    {
	      del_ng_sel_return (agent_ptr, this_id, TRUE, 26);
	    }
	    else
	    {
	      del_ng_sel_return (agent_ptr, this_id, FALSE, 25);
	    }
	  }
	}
      }

    /* we need return the old_reduction caused by old_value */

      found = FALSE;
      temp1_ptr = agent_ptr -> position_ptr[my_id];
      if (temp1_ptr != NULL)
      {
	found = TRUE;
	this_ptr = temp1_ptr;
	if (temp1_ptr -> value != my_value)
	{
	/* del no_good which was related to it */
	  if (agent_ptr -> in_link[my_id] != FALSE)
	  {
	    del_ng_sel_return (agent_ptr, my_id, FALSE, 24);
	  }
	  temp1_ptr -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	/* have a record of reduction */
	  if (temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    set_Union (agent_ptr -> avail_domain,
		temp1_ptr -> set1 /* reduction */ ,
		agent_ptr -> avail_domain);
	    set_Empty (temp1_ptr -> set1 /* reductions */ );
	  }
	/* change the its value */
	  temp1_ptr -> value = my_value;
	  temp1_ptr -> length = 0;
	  make_reduction (agent_ptr, agent_ptr -> avail_domain,
	      temp1_ptr);
	/* we need move the view to the head of agent_view */
	/* if it is not a head, remove it first */
	  if (agent_ptr -> value_view_ptr != temp1_ptr)
	  {
	    printf ("Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    fprintf (out_ptr, "Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    display (1);
	    exit (0);
	  }
	}
      }
      if (!found)
      {
      /* del no_good which was related to it */
	if (agent_ptr -> in_link[my_id] != FALSE)
	{
	  del_ng_sel_return (agent_ptr, my_id, FALSE, 23);
	}
	apply_info (&temp1_ptr, 2);
	temp1_ptr -> id = my_id;
	temp1_ptr -> value = my_value;
	temp1_ptr -> next = agent_ptr -> value_view_ptr;
	temp1_ptr -> logical_time = logical_time[pid];
	logical_time[pid]++;
	agent_ptr -> value_view_ptr = temp1_ptr;
	agent_ptr -> value_view_ptr -> front = NULL;
	if (agent_ptr -> value_view_ptr -> next == NULL)
	{
	  agent_ptr -> view_tail_ptr = agent_ptr -> value_view_ptr;
	}
	else
	{
	  agent_ptr -> value_view_ptr -> next -> front =
	    agent_ptr -> value_view_ptr;
	}
	this_ptr = temp1_ptr;
	agent_ptr -> position_ptr[my_id] = temp1_ptr;
      /* set the reduction */
	temp1_ptr -> length = 0;
	make_reduction (agent_ptr,
	    agent_ptr -> avail_domain, temp1_ptr);
      }
      if (!set_Ele (agent_ptr -> avail_domain))
      {
	set_Empty (tro_maker);
	set_Empty (dom_waiter);
	find_trowait (agent_ptr, tro_maker, dom_waiter);
	for (k = 0; k < MAX_AGENT && FALSE; k++)
	{
	  if (set_Mem (tro_maker, k) &&
	      get_order[pid][k] > get_order[pid][my_id])
	  {
	    printf ("Pid %d Why Ag %d Or %d Be My_id %d Or %d in Ag %d\n",
		pid, k, get_order[pid][k], my_id, get_order[pid][my_id], i);
	    printf ("Pid %d My_V1 %d My_V2 %d This_Id %d\n",
		pid, my_value, agent_ptr -> position_ptr[my_id] -> value,
		agent_ptr -> my_id);
	    print_view (agent_ptr, stdout);
	    print_nogoods (agent_ptr, stdout);
	    fprintf (out_ptr, "Pid %d Why Ag %d Or %d Be Mid %d Or %d in Ag %d\n",
		pid, k, get_order[pid][k], my_id, get_order[pid][my_id], i);
	    fprintf (out_ptr, "Pid %d My_V1 %d My_V2 %d This_Id %d\n",
		pid, my_value, agent_ptr -> position_ptr[my_id] -> value,
		agent_ptr -> my_id);
	    print_view (agent_ptr, out_ptr);
	    print_nogoods (agent_ptr, out_ptr);
	    display (1);
	    exit (0);
	  }
	}
	return i;
      }
    }
    if (agent_index[pid][i] != NULL &&
	changed &&
	agent_index[pid][i] -> in_link[my_id] &&
	agent_index[pid][i] -> relation[my_id] == -1 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      del_ng_sel_return (agent_ptr, my_id, TRUE, 22);
    }

  }				/* end of for i */
  return - 1;
}				/* end of forward_check4 */

/* fc-cbj */

int
      forward_check5 (my_id, my_value, tro_maker, dom_waiter)
int   my_id,
      my_value;
SET tro_maker;
SET dom_waiter;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr;
  int   found;
  int   i,
        j,
        k;
  int   order;
  int   this_id;
  int   agent_id;

  for (order = agent_index[pid][my_id] -> order + 1;
      order < agent_count; order++)
  {
    i = agent_order[pid][order];
    if (agent_index[pid][i] != NULL &&
	agent_index[pid][i] -> relation[my_id] != -1)
    {
      agent_ptr = agent_index[pid][i];

    /* we need return the old_reduction caused by old_value */

      found = FALSE;
      temp1_ptr = agent_ptr -> position_ptr[my_id];
      if (temp1_ptr != NULL)
      {
	found = TRUE;
	this_ptr = temp1_ptr;
	if (temp1_ptr -> value != my_value)
	{
	  temp1_ptr -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	/* have a record of reduction */
	  if (temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    set_Union (agent_ptr -> avail_domain,
		temp1_ptr -> set1 /* reduction */ ,
		agent_ptr -> avail_domain);
	    set_Empty (temp1_ptr -> set1 /* reductions */ );
	  }
	/* change the its value */
	  temp1_ptr -> value = my_value;
	  temp1_ptr -> length = 0;
	  make_reduction (agent_ptr, agent_ptr -> avail_domain,
	      temp1_ptr);
	  if (set_Ele (temp1_ptr -> set1))
	  {
	    set_Add (agent_index[pid][my_id] -> future_fc, agent_ptr -> my_id);
	    set_Add (agent_ptr -> past_fc, my_id);
	  }
	/* we need move the view to the head of agent_view */
	/* if it is not a head, remove it first */
	  if (agent_ptr -> value_view_ptr != temp1_ptr)
	  {
	    printf ("Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    fprintf (out_ptr, "Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    display (1);
	    exit (0);
	  }
	}
      }
      if (!found)
      {
	apply_info (&temp1_ptr, 2);
	temp1_ptr -> id = my_id;
	temp1_ptr -> value = my_value;
	temp1_ptr -> next = agent_ptr -> value_view_ptr;
	temp1_ptr -> logical_time = logical_time[pid];
	logical_time[pid]++;
	agent_ptr -> value_view_ptr = temp1_ptr;
	agent_ptr -> value_view_ptr -> front = NULL;
	if (agent_ptr -> value_view_ptr -> next == NULL)
	{
	  agent_ptr -> view_tail_ptr = agent_ptr -> value_view_ptr;
	}
	else
	{
	  agent_ptr -> value_view_ptr -> next -> front =
	    agent_ptr -> value_view_ptr;
	}
	this_ptr = temp1_ptr;
	agent_ptr -> position_ptr[my_id] = temp1_ptr;
      /* set the reduction */
	temp1_ptr -> length = 0;
	make_reduction (agent_ptr,
	    agent_ptr -> avail_domain, temp1_ptr);
	if (set_Ele (temp1_ptr -> set1))
	{
	  set_Add (agent_index[pid][my_id] -> future_fc, agent_ptr -> my_id);
	  set_Add (agent_ptr -> past_fc, my_id);
	}
      }

      if (!set_Ele (agent_ptr -> avail_domain))
      {
	set_Del (agent_index[pid][my_id] -> avail_domain, my_value);
      /* undo reductions */
	for (k = get_order[pid][my_id] + 1; k < agent_count; k++)
	{
	  agent_id = agent_order[pid][k];
	  if (agent_index[pid][agent_id] -> position_ptr[my_id] != NULL)
	  {
	    undo_reduction_ret_still (agent_id, my_id, TRUE);
	    set_Del (agent_index[pid][agent_id] -> past_fc, my_id);
	  }
	}
	set_Empty (agent_index[pid][my_id] -> future_fc);

	set_Union (agent_index[pid][my_id] -> conf_set,
	    agent_ptr -> past_fc,
	    agent_index[pid][my_id] -> conf_set);

	if (PRINT && FALSE)
	{
	  fprintf (out_ptr, "Tro_Maker for Ag %d :", my_id);
	  for (k = 0; k < MAX_AGENT; k++)
	  {
	    if (set_Mem (tro_maker, k))
	    {
	      fprintf (out_ptr, " %d ", k);
	    }
	  }
	  fprintf (out_ptr, "\n");
	}

	return i;
      }
    }

  }				/* end of for i */
  return - 1;
}				/* end of forward_check5 */

/* distributed fc-cbj-ng-pr */

int
      forward_check6 (my_id, my_value, tro_maker, dom_waiter, changed)
int   my_id,
      my_value;
SET tro_maker;
SET dom_waiter;
int   changed;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr;
  int   found;
  int   i,
        j,
        k;
  int   order;
  int   this_id;
  int   agent_id;
  int   tro_id;
  int   temp_length;
  int   temp_order;

  for (order = agent_index[pid][my_id] -> order + 1;
      order <= pid_info[pid].high_order; order++)
  {
    i = agent_order[pid][order];
    if (agent_index[pid][i] != NULL &&
	agent_index[pid][i] -> relation[my_id] != -1 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

      if ((agent_ptr -> position_ptr[my_id] == NULL) ||
	  (agent_ptr -> position_ptr[my_id] != NULL &&
	    agent_ptr -> position_ptr[my_id] -> value != my_value))
      {
      /* release reductions caused by higher order agents */
	temp1_ptr = agent_ptr -> value_view_ptr;
	while (temp1_ptr != NULL /* && */ )
	{
	  private_check++;
	  if (private_check == 10000)
	  {
	    printf ("P%d rests so long Mark %d\n", pid, 11);
	    private_check = 0;
	  }
	  temp2_ptr = temp1_ptr -> next;
	  if (agent_index[pid][temp1_ptr -> id] -> processor_id == pid)
	  {

	    if (get_order[pid][temp1_ptr -> id] > get_order[pid][my_id])
	    {
	      if (temp1_ptr -> length > 0)
	      {
		agent_ptr -> avail_length = agent_ptr -> avail_length +
		  temp1_ptr -> length;

		temp_length = agent_ptr -> avail_length;
		if (agent_ptr -> value_view_ptr == temp1_ptr)
		{
		  set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
		      agent_ptr -> avail_domain);
		}
		else
		{
		  printf ("P%d No Clear Before?\n", pid);
		  fprintf (out_ptr, "P%d No Clear Before?\n", pid);
		  display (1);
		  exit (0);
		}
	      }


	    /* remove ( this_id and its value from agent_info ) */

	      if (temp1_ptr == agent_ptr -> value_view_ptr)
	      {
		agent_ptr -> value_view_ptr = temp1_ptr -> next;
		if (temp1_ptr -> next != NULL)
		{
		  temp1_ptr -> next -> front = NULL;
		}
	      }
	      else
	      {
		temp1_ptr -> front -> next = temp1_ptr -> next;
		if (temp1_ptr -> next != NULL)
		{
		  temp1_ptr -> next -> front = temp1_ptr -> front;
		}
	      }

	      if (temp1_ptr == agent_ptr -> view_tail_ptr)
	      {
		agent_ptr -> view_tail_ptr = temp1_ptr -> front;
		if (temp1_ptr -> front != NULL)
		{
		  temp1_ptr -> front -> next = NULL;
		}
	      }
	      else
	      {
		temp1_ptr -> next -> front = temp1_ptr -> front;
		if (temp1_ptr -> front != NULL)
		{
		  temp1_ptr -> front -> next = temp1_ptr -> next;
		}
	      }

	      agent_ptr -> position_ptr[temp1_ptr -> id] = NULL;
	      free_pointer ((struct info *) temp1_ptr, 2);
	    }
	  }
	  temp1_ptr = temp2_ptr;
	}
      /* release nogoods */
	if (agent_index[pid][my_id] -> processor_id == pid)
	{
	  temp_order = get_order[pid][my_id] + 1;
	}
	else
	{
	  temp_order = pid_info[pid].lower_order;
	}
	for (j = temp_order; j < agent_ptr -> order; j++)
	{
	  this_id = agent_order[pid][j];
	  if (get_order[pid][this_id] != j)
	  {
	    printf ("P%d This_Id %d Get_Order %d J %d\n", pid, this_id,
		get_order[pid][this_id], j);
	    display (1);
	    exit (0);
	  }
	  if (agent_ptr -> in_link[this_id] != FALSE)
	  {
	    del_ng_sel_return (agent_ptr, this_id, TRUE, 21);
	  }
	}
      }
    /* we need return the old_reduction caused by old_value */

      found = FALSE;
      temp1_ptr = agent_ptr -> position_ptr[my_id];
      if (temp1_ptr != NULL)
      {
	if (temp1_ptr -> value != my_value &&
	    (agent_index[pid][my_id] -> processor_id != pid &&
	      agent_index[pid][agent_ptr -> value_view_ptr -> id] ->
	      processor_id == pid ||
	      agent_index[pid][my_id] -> processor_id == pid &&
	      agent_index[pid][agent_ptr -> value_view_ptr -> id] -> order >
	      agent_index[pid][my_id] -> order))
	{
	  printf ("P%d Further Release needed from my_id %d to this_id %d\n",
	      pid, my_id, agent_ptr -> my_id);
	  fprintf (out_ptr, "P%d Release needed from mid %d to tid %d\n",
	      pid, my_id, agent_ptr -> my_id);
	  display (1);
	  exit (0);
	}
	found = TRUE;
	this_ptr = temp1_ptr;
	if (temp1_ptr -> value != my_value &&
	    agent_index[pid][my_id] -> processor_id == pid)
	{
	/* del no_good which was related to it */
	  if (agent_ptr -> in_link[my_id] != FALSE)
	  {
	    del_ng_sel_return (agent_ptr, my_id, FALSE, 19);
	  }
	  temp1_ptr -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	/* have a record of reduction */
	  if (temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    set_Union (agent_ptr -> avail_domain,
		temp1_ptr -> set1 /* reduction */ ,
		agent_ptr -> avail_domain);
	    set_Empty (temp1_ptr -> set1 /* reductions */ );
	  }
	/* change the its value */
	  temp1_ptr -> value = my_value;
	  temp1_ptr -> length = 0;
	  make_reduction (agent_ptr, agent_ptr -> avail_domain,
	      temp1_ptr);
	/* we need move the view to the head of agent_view */
	/* if it is not a head, remove it first */
	  if (agent_ptr -> value_view_ptr != temp1_ptr)
	  {
	    printf ("Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    fprintf (out_ptr, "Ag %d Is Not Head of Ag %d ?\n", my_id,
		agent_ptr -> my_id);
	    display (1);
	    exit (0);
	  }
	}
	if (temp1_ptr -> value != my_value &&
	    agent_index[pid][my_id] -> processor_id != pid)
	{
	/* del no_good which was related to it */
	  if (agent_ptr -> in_link[my_id] != FALSE)
	  {
	  /* del_ng_sel (agent_ptr, my_id, 1); */
	    del_ng_sel_return (agent_ptr, my_id, TRUE, 18);
	  /* 
	   del_ng_return (agent_ptr, my_id);
	   */
	  }
	  temp1_ptr -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	/* set reduction downstream */
	  if (temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    still_reduction (agent_ptr, temp1_ptr -> set1, temp1_ptr);
	    set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
		agent_ptr -> avail_domain);
	    set_Empty (temp1_ptr -> set1);
	    temp1_ptr -> length = 0;
	  }
	/* change the its value */
	  temp1_ptr -> value = my_value;
	/* make reduction */
	  make_reduction (agent_ptr, agent_ptr -> avail_domain, temp1_ptr);
	/* we need move the view to the head of agent_view */
	/* if it is not a head, remove it first */
	  if (agent_ptr -> value_view_ptr != temp1_ptr)
	  {

	    temp1_ptr -> front -> next = temp1_ptr -> next;
	    if (temp1_ptr -> next != NULL)
	    {
	      temp1_ptr -> next -> front = temp1_ptr -> front;
	    }
	    if (temp1_ptr == agent_ptr -> view_tail_ptr)
	    {
	      agent_ptr -> view_tail_ptr = temp1_ptr -> front;
	      if (temp1_ptr -> front != NULL)
	      {
		temp1_ptr -> front -> next = NULL;
	      }
	    }
	    else
	    {
	      temp1_ptr -> next -> front = temp1_ptr -> front;
	      if (temp1_ptr -> front != NULL)
	      {
		temp1_ptr -> front -> next = temp1_ptr -> next;
	      }
	    }
	  /* add it to the head of the agent_view */
	    temp1_ptr -> next = agent_ptr -> value_view_ptr;
	    agent_ptr -> value_view_ptr = temp1_ptr;
	    agent_ptr -> value_view_ptr -> front = NULL;
	    if (agent_ptr -> value_view_ptr -> next == NULL)
	    {
	      agent_ptr -> view_tail_ptr =
		agent_ptr -> value_view_ptr;
	    }
	    else
	    {
	      agent_ptr -> value_view_ptr -> next -> front =
		agent_ptr -> value_view_ptr;
	    }
	  }
	}


      }
      if (!found)
      {
      /* del no_good which was related to it */
	if (agent_ptr -> in_link[my_id] != FALSE)
	{
	  if (agent_index[pid][my_id] -> processor_id == pid)
	  {
	    del_ng_sel_return (agent_ptr, my_id, FALSE, 17);
	  }
	  else
	  {
	    del_ng_sel_return (agent_ptr, my_id, TRUE, 16);
	  }
	}
	apply_info (&temp1_ptr, 2);
	temp1_ptr -> id = my_id;
	temp1_ptr -> value = my_value;
	temp1_ptr -> next = agent_ptr -> value_view_ptr;
	temp1_ptr -> logical_time = logical_time[pid];
	logical_time[pid]++;
	agent_ptr -> value_view_ptr = temp1_ptr;
	agent_ptr -> value_view_ptr -> front = NULL;
	if (agent_ptr -> value_view_ptr -> next == NULL)
	{
	  agent_ptr -> view_tail_ptr = agent_ptr -> value_view_ptr;
	}
	else
	{
	  agent_ptr -> value_view_ptr -> next -> front =
	    agent_ptr -> value_view_ptr;
	}
	this_ptr = temp1_ptr;
	agent_ptr -> position_ptr[my_id] = temp1_ptr;
      /* set the reduction */
	temp1_ptr -> length = 0;
	make_reduction (agent_ptr,
	    agent_ptr -> avail_domain, temp1_ptr);
      }
      while (!set_Ele (agent_ptr -> avail_domain))
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 12);
	  private_check = 0;
	}
	set_Empty (tro_maker);
	set_Empty (dom_waiter);
	find_trowait (agent_ptr, tro_maker, dom_waiter);

	if (agent_index[pid][my_id] -> processor_id != pid)
	{
	  tro_id = select_high_order (agent_ptr, tro_maker, dom_waiter, my_id);
	  if (tro_id == my_id)
	  {
	  /* check orders */
	    for (k = 0; k < agent_count && FALSE; k++)
	    {
	      if (set_Mem (tro_maker, k) &&
		  (get_order[pid][k] > agent_ptr -> order ||
		    get_order[pid][k] > get_order[pid][my_id]))
	      {
		printf ("P%d ID %d Order %d My_Id %d My_Order %d FId %d FO %d\n",
		    pid, k, get_order[pid][k],
		    agent_ptr -> my_id, agent_ptr -> order,
		    my_id, get_order[pid][my_id]);
		fprintf (out_ptr, "P%d ID %d Order %d MId %d MOrder %d FD %d FO %d\n",
		    pid, k, get_order[pid][k],
		    agent_ptr -> my_id, agent_ptr -> order,
		    my_id, get_order[pid][my_id]);
		display (1);
		exit (0);
	      }
	    }

	    return i;
	  }
	}
	else
	{
	/* check orders */
	  for (k = 0; k < agent_count && FALSE; k++)
	  {
	    if (set_Mem (tro_maker, k) &&
		(get_order[pid][k] > agent_ptr -> order ||
		  get_order[pid][k] > get_order[pid][my_id]))
	    {
	      printf ("P%d Id %d Order %d My_Id %d My_Order %d FId %d FO %d\n",
		  pid, k, get_order[pid][k],
		  agent_ptr -> my_id, agent_ptr -> order,
		  my_id, get_order[pid][my_id]);
	      fprintf (out_ptr, "P%d Id %d Order %d MId %d MOrder %d FD %d FO %d\n",
		  pid, k, get_order[pid][k],
		  agent_ptr -> my_id, agent_ptr -> order,
		  my_id, get_order[pid][my_id]);
	      display (1);
	      exit (0);
	    }
	  }
	  tro_id = -1;
	  temp_order = get_order[pid][my_id];
	  for (k = 0; k < agent_count; k++)
	  {
	    if (set_Mem (tro_maker, k) && get_order[pid][k] > temp_order)
	    {
	      tro_id = k;
	      temp_order = get_order[pid][k];
	    }
	  }
	  if (tro_id != -1)
	  {
	    for (k = get_order[pid][tro_id] + 1; k <= pid_info[pid].high_order;
		k++)
	    {
	      agent_id = agent_order[pid][k];
	      if (agent_index[pid][agent_id] -> position_ptr[tro_id] != NULL)
	      {
		undo_reduction_ret_still (agent_index[pid][agent_id] -> my_id,
		    tro_id, TRUE);
	      }
	      if (agent_index[pid][agent_id] -> in_link[tro_id] != FALSE)
	      {
		del_ng_sel_return (agent_index[pid][agent_id],
		    tro_id, TRUE, 18);
	      }
	    }
	    make_nogood (agent_index[pid][tro_id], tro_maker,
		dom_waiter, agent_ptr -> my_id);
	  }
	  else
	  {
	    return i;
	  }
	}
      }
    }
    if (agent_index[pid][i] != NULL &&
	changed &&
	agent_index[pid][i] -> in_link[my_id] &&
	agent_index[pid][i] -> relation[my_id] == -1 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      del_ng_sel_return (agent_ptr, my_id, TRUE, 15);
    }

  }				/* end of for i */
  return - 1;
}				/* end of forward_check6 */


void multi_check_release (my_id, my_value, step_begin,
  step_end, changed, for_check)
int   my_id;
int   my_value;
int   step_begin;
int   step_end;
int   changed;
int   for_check;
{
  int   i;
  int   base;
  int   top;
  int   agent_id;
  int   finish;

  pid = 0;

  while (FORD_CHECK &&
      (base = STEP * (m_next () - 1) + step_begin) < step_end)
  {
    top = base + STEP;
    if (top > agent_count)
    {
      top = agent_count;
    }

  /* execute all checks in bite of work */

    for (i = base; i < top && FORD_CHECK; i++)
    {
      agent_id = agent_order[pid][i];
      if (for_check)
      {
	if (forward_check7 (my_id, my_value,
	      agent_index[pid][agent_id], changed) != -1)
	{
	  break;
	}
      }
      else
      {

	release_variables (current_back_order[pid],
	    step_begin, agent_id);
      }
    }
  }

}				/* end of multi_check_release */

/* function fc-cbj-ng-pr */

int   forward_check7 (my_id, my_value, agent_ptr, changed)
int   my_id,
      my_value;
struct agent_home *agent_ptr;
int   changed;
{
  SET tro_maker;
  SET dom_waiter;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr;
  int   found;
  int   i,
        j,
        k;
  int   order;
  int   agent_id;
  int   this_id;
  int   tro_id;
  int   do_it;

  if (!FORD_CHECK)
  {
    return MAX_AGENT;
  }

  if (agent_ptr != NULL &&
      agent_ptr -> relation[my_id] != -1)
  {

    if (agent_ptr -> position_ptr[my_id] == NULL ||
	(agent_ptr -> position_ptr[my_id] != NULL &&
	  agent_ptr -> position_ptr[my_id] -> value != my_value) ||
	!set_Ele (agent_ptr -> avail_domain))
    {
    /* release reductions caused by higher order agents */

      temp1_ptr = agent_ptr -> value_view_ptr;
      while (temp1_ptr != NULL &&
	  get_order[pid][temp1_ptr -> id] > get_order[pid][my_id])
      {
	temp2_ptr = temp1_ptr -> next;

	if (get_order[pid][temp1_ptr -> id] > get_order[pid][my_id])
	{
	  if (temp1_ptr -> length > 0)
	  {
	    agent_ptr -> avail_length = agent_ptr -> avail_length +
	      temp1_ptr -> length;
	    if (agent_ptr -> value_view_ptr == temp1_ptr)
	    {
	      set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
		  agent_ptr -> avail_domain);
	    }
	    else
	    {
	      printf ("Enter\n");
	      still_reduction (agent_ptr, temp1_ptr -> set1, temp1_ptr);
	      set_Union (agent_ptr -> avail_domain, temp1_ptr -> set1,
		  agent_ptr -> avail_domain);

	    }
	  }


	/* remove ( this_id and its value from agent_info ) */

	  if (temp1_ptr == agent_ptr -> value_view_ptr)
	  {
	    agent_ptr -> value_view_ptr = temp1_ptr -> next;
	    if (temp1_ptr -> next != NULL)
	    {
	      temp1_ptr -> next -> front = NULL;
	    }
	  }
	  else
	  {
	    temp1_ptr -> front -> next = temp1_ptr -> next;
	    if (temp1_ptr -> next != NULL)
	    {
	      temp1_ptr -> next -> front = temp1_ptr -> front;
	    }
	  }

	  if (temp1_ptr == agent_ptr -> view_tail_ptr)
	  {
	    agent_ptr -> view_tail_ptr = temp1_ptr -> front;
	    if (temp1_ptr -> front != NULL)
	    {
	      temp1_ptr -> front -> next = NULL;
	    }
	  }
	  else
	  {
	    temp1_ptr -> next -> front = temp1_ptr -> front;
	    if (temp1_ptr -> front != NULL)
	    {
	      temp1_ptr -> front -> next = temp1_ptr -> next;
	    }
	  }

	  agent_ptr -> position_ptr[temp1_ptr -> id] = NULL;
	  free_pointer ((struct info *) temp1_ptr, 2);
	}
	temp1_ptr = temp2_ptr;
      }

    /* release nogoods !!! */
      for (j = get_order[pid][my_id] + 1; j < agent_ptr -> order; j++)
      {
	this_id = agent_order[pid][j];

	if (agent_ptr -> in_link[this_id] != FALSE)
	{
	  if (agent_ptr -> relation[this_id] == -1)
	  {
	    del_ng_sel_return (agent_ptr, this_id, TRUE, 14);
	  }
	  else
	  {
	    del_ng_sel_return (agent_ptr, this_id, FALSE, 13);
	  }
	}
      }
    }
    if (!FORD_CHECK)
    {
      return MAX_AGENT;
    }
  /* we need return the old_reduction caused by old_value */

    found = FALSE;
    temp1_ptr = agent_ptr -> position_ptr[my_id];
    if (temp1_ptr != NULL)
    {
      found = TRUE;
      this_ptr = temp1_ptr;
      if (temp1_ptr -> value != my_value)
      {
      /* del no_good which was related to it */
	if (agent_ptr -> in_link[my_id] != FALSE)
	{
	  del_ng_sel_return (agent_ptr, my_id, FALSE, 12);
	}
	if (PS == 5 && np > 1)
	{
	  m_lock ();
	}
	temp1_ptr -> logical_time = logical_time[pid];
	logical_time[pid]++;
	if (PS == 5 && np > 1)
	{
	  m_unlock ();
	}
      /* have a record of reduction */
	if (temp1_ptr -> length > 0)
	{
	  agent_ptr -> avail_length = agent_ptr -> avail_length +
	    temp1_ptr -> length;
	  set_Union (agent_ptr -> avail_domain,
	      temp1_ptr -> set1 /* reduction */ ,
	      agent_ptr -> avail_domain);
	  set_Empty (temp1_ptr -> set1 /* reductions */ );
	}
      /* change the its value */
	temp1_ptr -> value = my_value;
	temp1_ptr -> length = 0;
	make_reduction (agent_ptr, agent_ptr -> avail_domain,
	    temp1_ptr);
      /* we need move the view to the head of agent_view */
      /* if it is not a head, remove it first */
	if (agent_ptr -> value_view_ptr != temp1_ptr)
	{
	  printf ("Ag %d Is Not Head of Ag %d ? Head %d\n", my_id,
	      agent_ptr -> my_id, agent_ptr -> value_view_ptr -> id);
	  fprintf (out_ptr, "Ag %d Is Not Head of Ag %d ? Head %d\n", my_id,
	      agent_ptr -> my_id, agent_ptr -> value_view_ptr -> id);
	  display (1);
	  exit (0);
	}
      }


    }
    if (!FORD_CHECK)
    {
      return MAX_AGENT;
    }
    if (!found)
    {
    /* del no_good which was related to it */
      if (agent_ptr -> in_link[my_id] != FALSE)
      {
	del_ng_sel_return (agent_ptr, my_id, FALSE, 11);
      }
      apply_info (&temp1_ptr, 2);
      if (PS == 5 && np > 1)
      {
	m_lock ();
      }
      temp1_ptr -> logical_time = logical_time[pid];
      logical_time[pid]++;
      if (PS == 5 && np > 1)
      {
	m_unlock ();
      }
      temp1_ptr -> id = my_id;
      temp1_ptr -> value = my_value;
      temp1_ptr -> next = agent_ptr -> value_view_ptr;
      agent_ptr -> value_view_ptr = temp1_ptr;
      agent_ptr -> value_view_ptr -> front = NULL;
      if (agent_ptr -> value_view_ptr -> next == NULL)
      {
	agent_ptr -> view_tail_ptr = agent_ptr -> value_view_ptr;
      }
      else
      {
	agent_ptr -> value_view_ptr -> next -> front =
	  agent_ptr -> value_view_ptr;
      }
      this_ptr = temp1_ptr;
      agent_ptr -> position_ptr[my_id] = temp1_ptr;
    /* set the reduction */
      temp1_ptr -> length = 0;
      make_reduction (agent_ptr,
	  agent_ptr -> avail_domain, temp1_ptr);
    }
    if (!FORD_CHECK)
    {
      return MAX_AGENT;
    }
    while (!set_Ele (agent_ptr -> avail_domain))
    {
      do_it = FALSE;
      if (PS == 5 && np > 1)
      {
	m_lock ();
      }
      if (FORD_CHECK)
      {
	do_it = TRUE;
	FORD_CHECK = FALSE;
      }
      if (PS == 5 && np > 1)
      {
	m_unlock ();
      }
      if (do_it)
      {
	set_Empty (tro_maker);
	set_Empty (dom_waiter);
	find_trowait (agent_ptr, tro_maker, dom_waiter);
	make_nogood (agent_index[pid][my_id],
	    tro_maker, dom_waiter, agent_ptr -> my_id);
      }
      return agent_ptr -> my_id;
    }
  }
  if (agent_ptr != NULL &&
      changed &&
      agent_ptr -> in_link[my_id] &&
      agent_ptr -> relation[my_id] == -1)
  {
    del_ng_sel_return (agent_ptr, my_id, TRUE, 10);
  }

  if (!FORD_CHECK)
  {
    return MAX_AGENT;
  }
  return - 1;
}				/* end of forward_check7 */

/* make reductions */

make_reduction (agent_ptr, avail_domain, this_ptr)
struct agent_home *agent_ptr;
struct info *this_ptr;
SET avail_domain;
{
  int   i;
  int   count = 0;
  int   consistency;


 /* set the no good */

  if (agent_ptr -> relation[this_ptr -> id] != -1)
  {
    for (i = 0; i < MAX_DOMAIN; i++)
    {
      if (set_Mem (avail_domain, i))
      {
	consistency = apply (i, this_ptr -> value,
	    agent_ptr -> relation[this_ptr -> id],
	    agent_ptr -> my_id, this_ptr -> id, -1);
	if (!consistency)
	{
	  count++;
	  set_Del (avail_domain, i);
	  set_Add (this_ptr -> set1, i);
	  if (i == agent_ptr -> my_value)
	  {
	    agent_ptr -> my_value = -1;
	    agent_ptr -> to_be_sent = FALSE;
	  }
	}
      }
    }
    agent_ptr -> avail_length = agent_ptr -> avail_length - count;
    this_ptr -> length = this_ptr -> length + count;
  }
}				/* end of make_reduction */

/* delete nogood */

del_ng (agent_ptr, id, free_domain)
struct agent_home *agent_ptr;
int   id;
SET free_domain;
{
  struct info *nogood_ptr;
  struct info *temp1_ptr;

  if (np == 1)
  {
    nogood_del_count++;
  }

 /* del no_good which was related to it */
  nogood_ptr = agent_ptr -> nogood_ptr;
  while (nogood_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 13);
      private_check = 0;
    }
    if (set_Mem (nogood_ptr -> set1, id))
    {
      set_Add (free_domain,
	  nogood_ptr -> value /* nogood_value */ );
      if (nogood_ptr == agent_ptr -> nogood_ptr)
      {
	agent_ptr -> nogood_ptr = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = agent_ptr -> nogood_ptr;
      }
      else
      {
	temp1_ptr -> next = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = temp1_ptr -> next;
      }
    }
    else
    {
      temp1_ptr = nogood_ptr;
      nogood_ptr = nogood_ptr -> next;
    }

  }				/* end of while */

}				/* end of del_ng */

/* delete nogoods that may be put into reductions */

del_ng_sel_return (agent_ptr, id, is_sel, mark)
struct agent_home *agent_ptr;
int   id;
int   is_sel;
int   mark;
{
  struct info *nogood_ptr;
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  int   i;

  if (agent_ptr == NULL || agent_ptr -> processor_id != pid)
  {
    printf ("P%d Caught %d PTR %d ITS_PID %d ID %d\n", pid, mark,
	agent_ptr, agent_ptr -> processor_id, id);
    fprintf (out_ptr, "P%d Caught %d PTR %d ITS_PID %d ID %d\n", pid, mark,
	agent_ptr, agent_ptr -> processor_id, id);
    display (1);
    exit (0);
  }

  if (np == 1)
  {
    nogood_del_count++;
  }

 /* del no_good which was related to it */
  nogood_ptr = agent_ptr -> nogood_ptr;
  while (nogood_ptr != NULL)
  {
    if (set_Mem (nogood_ptr -> set1, id))
    {
      if (is_sel)
      {
	still_reduction_nogood (agent_ptr, nogood_ptr -> value,
	    nogood_ptr -> logical_time, mark);
      }
      else
      {
	set_Add (agent_ptr -> avail_domain,
	    nogood_ptr -> value /* nogood_value */ );
	agent_ptr -> avail_length++;
	temp2_ptr = agent_ptr -> value_view_ptr;
	while (temp2_ptr != NULL)
	{
	  if (temp2_ptr -> logical_time > nogood_ptr -> logical_time)
	  {
	    printf ("P%d UndoN T_L %d Id %d Mark %d\n",
		pid, temp2_ptr -> logical_time, id, mark);
	    fprintf (out_ptr, "P%d UndoN T_L %d Id %d Mark %d\n",
		pid, temp2_ptr -> logical_time, id, mark);
	    print_nogoods (agent_ptr, out_ptr);
	    display (1);
	    exit (0);
	  }
	  temp2_ptr = temp2_ptr -> next;
	}

      }
      if (nogood_ptr == agent_ptr -> nogood_ptr)
      {
	agent_ptr -> nogood_ptr = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = agent_ptr -> nogood_ptr;
      }
      else
      {
	temp1_ptr -> next = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = temp1_ptr -> next;
      }
    }
    else
    {
      temp1_ptr = nogood_ptr;
      nogood_ptr = nogood_ptr -> next;
    }

  }				/* end of while */

  agent_ptr -> in_link[id] = FALSE;

  if (agent_ptr -> nogood_ptr == NULL)
  {
    for (i = 0; i < agent_count; i++)
    {
      agent_ptr -> in_link[i] = FALSE;
    }
  }

}				/* end of del_ng_sel_return */

/* delete nogood val */

int   del_ng_val (agent_ptr, val)
struct agent_home *agent_ptr;
int   val;
{
  struct info *nogood_ptr;
  struct info *temp1_ptr;
  int   i;
  int   this_id;
  int   agent_id;
  int   is_val;

  if (!set_Mem (agent_ptr -> domain, val))
  {
    return FALSE;
  }


  if (!P_ARC)
  {
    set_Del (agent_ptr -> domain, val);
    agent_ptr -> dom_length--;
  }
  else
  {
    set_Del (agent_ptr -> base_domain, val);
    agent_ptr -> base_length--;
  }

  if (set_Mem (agent_ptr -> avail_domain, val))
  {
    set_Del (agent_ptr -> avail_domain, val);
    agent_ptr -> avail_length--;
    is_val = FALSE;
    if (agent_ptr -> my_value == val)
    {
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;
      is_val = TRUE;
    }
    return is_val;
  }

 /* del no_good which was related to it */
  nogood_ptr = agent_ptr -> nogood_ptr;
  while (nogood_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 16);
      private_check = 0;
    }
    if (nogood_ptr -> value == val)
    {
      if (nogood_ptr == agent_ptr -> nogood_ptr)
      {
	agent_ptr -> nogood_ptr = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = agent_ptr -> nogood_ptr;
      }
      else
      {
	temp1_ptr -> next = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = temp1_ptr -> next;
      }
      return FALSE;
    }
    else
    {
      temp1_ptr = nogood_ptr;
      nogood_ptr = nogood_ptr -> next;
    }

  }				/* end of while */

 /* del reduction */

  temp1_ptr = agent_ptr -> value_view_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 17);
      private_check = 0;
    }
    if (agent_ptr -> relation[temp1_ptr -> id] != -1 &&
	set_Mem (temp1_ptr -> set1, val))
    {
      set_Del (temp1_ptr -> set1, val);
      temp1_ptr -> length--;
      return FALSE;
    }
    temp1_ptr = temp1_ptr -> next;
  }

  return FALSE;
}				/* end of del_ng_val */

/* del nogood relevant waiters */

del_ng_waiter (agent_ptr, id)
struct agent_home *agent_ptr;
int   id;
{
  struct info *nogood_ptr;
  struct info *temp1_ptr;


 /* del no_good which was related to it */
  nogood_ptr = agent_ptr -> nogood_ptr;
  while (nogood_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 18);
      private_check = 0;
    }
    if (set_Mem (nogood_ptr -> set2 /* waiter */ , id))
    {
      set_Add (agent_ptr -> avail_domain,
	  nogood_ptr -> value /* nogood_value */ );
      if (nogood_ptr == agent_ptr -> nogood_ptr)
      {
	agent_ptr -> nogood_ptr = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = agent_ptr -> nogood_ptr;
      }
      else
      {
	temp1_ptr -> next = nogood_ptr -> next;
	free_pointer ((struct info *) nogood_ptr, 3);
	nogood_ptr = temp1_ptr -> next;
      }
    }
    else
    {
      temp1_ptr = nogood_ptr;
      nogood_ptr = nogood_ptr -> next;
    }

  }				/* end of while */

}				/* end of del_ng_waiter */

/* val may still be reduction */

still_reduction (agent_ptr, returned_nogood, id_ptr)
struct agent_home *agent_ptr;
SET returned_nogood;
struct info *id_ptr;
{
  struct info *temp1_ptr;
  struct info *temp2_ptr;

  if (id_ptr == NULL)
  {
    temp1_ptr = agent_ptr -> view_tail_ptr;
  }
  else
  {
    temp1_ptr = id_ptr -> front;
  }
  while (temp1_ptr != NULL && set_Ele (returned_nogood))
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 19);
      private_check = 0;
    }
    make_reduction (agent_ptr, returned_nogood, temp1_ptr);
    temp1_ptr = temp1_ptr -> front;
  }
}				/* end of still_reduction */

/* nogood may still be reduction */

still_reduction_nogood (agent_ptr, val, logical_t, mark)
struct agent_home *agent_ptr;
int   val;
int   logical_t;
int   mark;
{
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  int   consistency;

  temp1_ptr = agent_ptr -> view_tail_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 20);
      private_check = 0;
    }
    if (logical_t < temp1_ptr -> logical_time)
    {
      consistency = apply (val, temp1_ptr -> value,
	  agent_ptr -> relation[temp1_ptr -> id],
	  agent_ptr -> my_id, temp1_ptr -> id, -1);
      if (!consistency)
      {
	temp1_ptr -> length++;
	set_Add (temp1_ptr -> set1, val);
	if (val == agent_ptr -> my_value)
	{
	  agent_ptr -> my_value = -1;
	  agent_ptr -> to_be_sent = FALSE;
	}
	return;
      }
    }
    temp1_ptr = temp1_ptr -> front;
  }
  agent_ptr -> avail_length++;
  set_Add (agent_ptr -> avail_domain, val);
}				/* end of still_reduction_nogood */

/* consistency checks */

int
      apply (my_value, sender_value, relation, my_id, sender_id, this_id)
int   my_value,
      sender_value,
      relation,
      my_id,
      sender_id,
      this_id;

{
  int   consistent = FALSE;
  int   abs;
  int   abs1,
        abs2;
  int   i;
  int   a;
  int   b = 10;
  int   c = 20;

  if (this_id != -1)
  {
    agent_index[pid][this_id] -> apply_count++;
  }
  else
  {
    agent_index[pid][my_id] -> apply_count++;
  }


  switch (relation)
  {
    case 1: 
      if (my_value == sender_value)
      {
	consistent = TRUE;
      }
      break;
    case 2: 
      if (my_value != sender_value)
      {
	consistent = TRUE;
      }
      break;
    case 3: 
      if (my_value < sender_value)
      {
	consistent = TRUE;
      }
      break;
    case 4: 
      if (my_value > sender_value)
      {
	consistent = TRUE;
      }
      break;
    case 5: 
      abs = my_value - sender_value;
      if ((abs == 1) || (abs == -1))
      {
	consistent = TRUE;
      }
      break;
    case 6: 
      abs = my_value - sender_value;
      if (abs == -1)
      {
	consistent = TRUE;
      }
      break;
    case 7: 
      abs = my_value - sender_value;
      if (abs == 1)
      {
	consistent = TRUE;
      }
      break;
    case 8: 			/* q_queen */
      if (my_value == sender_value)
      {
	consistent = FALSE;
	break;
      }
      abs1 = my_id - sender_id;
      if (abs1 < 0)
	abs1 = abs1 * (-1);
      abs2 = my_value - sender_value;
      if (abs2 < 0)
	abs2 = abs2 * (-1);
      abs = abs1 - abs2;
      if (abs == 0)
      {
	consistent = FALSE;
	break;
      }
      consistent = TRUE;
      break;
    case 9: 			/* confused q_queen */
      if (my_value == sender_value)
      {
	consistent = TRUE;
	break;
      }
      abs1 = my_id - sender_id;
      if (abs1 < 0)
	abs1 = abs1 * (-1);
      abs2 = my_value - sender_value;
      if (abs2 < 0)
	abs2 = abs2 * (-1);
      abs = abs1 - abs2;
      if (abs == 0)
      {
	consistent = TRUE;
	break;
      }
      consistent = FALSE;
      break;
    default: 
      consistent = TRUE;
  }

 /* harder consistency checks */
  for (i = 0; i < 1000 && FALSE; i++)
  {
    a = b * c;
  }


  return consistent;
}


/* backtrack */

int
      backtrack (my_id, dom_waiter, tro_maker)
int   my_id;
SET dom_waiter;
SET tro_maker;
{
  SET free_dom;
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr;
  int   this_id;
  int   high_order;
  int   high_order2;
  int   i;
  int   agent_id;
  int   my_value;
  int   zero_length;

  agent_ptr = agent_index[pid][my_id];

  agent_ptr -> back_count++;

  set_Empty (tro_maker);
  set_Empty (dom_waiter);

  if (FC != 5)
  {
    find_trowait (agent_ptr, tro_maker, dom_waiter);
  }
  else
  {
    set_Union (tro_maker, agent_ptr -> conf_set, tro_maker);
    set_Union (tro_maker, agent_ptr -> past_fc, tro_maker);
  }

 /* problems */
  if (!set_Ele (tro_maker))
  {
    if (!PART_SOL[pid])
    {
      THIS_ID = -2;
    }
    return - 1;
  }
 /* select the this_id with higher order for backtracking */


  if (PS != 4)
  {
    high_order = 0;
    this_id = -1;
    for (i = 0; i < agent_count; i++)
    {
      if (set_Mem (tro_maker, i) && get_order[pid][i] >= high_order)
      {
	high_order = get_order[pid][i];
	this_id = i;
      }
    }

    if (get_order[pid][this_id] > agent_ptr -> order)
    {
      printf ("1This_id %d Its Order %d My_id %d My_Order %d\n",
	  this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      fprintf (out_ptr, "1This_id %d Its Order %d My_id %d My_Order %d\n",
	  this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      display (1);
      exit (0);
    }
    if (FC == 2 || FC == 4 || FC == 5 || FC == 6)
    {
      return this_id;
    }
  }
  else
  {
    high_order = -1;
    high_order2 = -1;
    this_id = -1;
    for (i = 0; i < agent_count; i++)
    {
      if (set_Mem (tro_maker, i))
      {
	if (agent_index[pid][i] -> processor_id > high_order)
	{
	  high_order = agent_index[pid][i] -> processor_id;
	  high_order2 = get_order[pid][i];
	  this_id = i;
	}
	else
	{
	  if (agent_index[pid][i] -> processor_id == high_order)
	  {
	    if (get_order[pid][i] > high_order2)
	    {
	      high_order2 = get_order[pid][i];
	      this_id = i;
	    }
	  }
	}
      }
    }

    if (agent_index[pid][this_id] -> processor_id == pid &&
	get_order[pid][this_id] > agent_ptr -> order)
    {
      if (TRUE)
      {
	printf ("2This_id %d Its Order %d My_id %d My_Order %d\n",
	    this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
	fprintf (out_ptr, "2This_id %d Its Order %d My_id %d My_Order %d\n",
	    this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
	display (1);
	exit (0);
      }
      if (!agent_ptr -> in_link[this_id] &&
	  agent_ptr -> position_ptr[this_id] == NULL)
      {
	printf ("P%d 3This_id %d Its Order %d My_id %d My_Order %d\n",
	    pid, this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
	printf ("P%d PTR[this_id] %d in_link[this_id] %d \n", pid,
	    agent_ptr -> position_ptr[this_id],
	    agent_ptr -> in_link[this_id]);
	fprintf (out_ptr, "P%d 3This_id %d Its Order %d My_id %d My_Order %d\n",
	    pid, this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
	fprintf (out_ptr, "P%d PTR[this_id] %d in_link[this_id] %d \n", pid,
	    agent_ptr -> position_ptr[this_id],
	    agent_ptr -> in_link[this_id]);
	display (1);
	exit (0);
      }


      if (agent_ptr -> position_ptr[this_id] != NULL)
      {
	undo_reduction_ret_still (my_id, this_id, FALSE);
      }


      if (agent_ptr -> in_link[this_id])
      {
	zero_length = FALSE;
	if (agent_ptr -> avail_length == 0)
	{
	  zero_length = TRUE;
	}
	del_ng_sel_return (agent_ptr, this_id, TRUE, 9);
	if (agent_ptr -> avail_length > 0 && zero_length)
	{
	  if (set_Mem (agent_index[pid][this_id] -> avail_domain,
		agent_index[pid][this_id] -> my_value))
	  {
	    set_Add (tro_maker, agent_ptr -> my_id);
	    make_nogood (agent_index[pid][this_id], tro_maker,
		dom_waiter, my_id);
	    temp1_ptr = agent_index[pid][this_id] -> nogood_ptr;
	    agent_index[pid][this_id] -> nogood_ptr = temp1_ptr -> next;
	    temp1_ptr -> next = agent_ptr -> move_nogood_ptr;
	    agent_ptr -> move_nogood_ptr = temp1_ptr;
	  }
	}
      }

      return agent_ptr -> my_id;

    }
    else
    {
      if (FC == 2 || FC == 4 || FC == 5 || FC == 6)
      {
	if (high_order == pid)
	{
	  return this_id;
	}
	else
	{
	  if (!SF || SF && !PART_SOL[pid])
	  {
	    make_nogoods_message (agent_ptr -> my_id, this_id,
		tro_maker, dom_waiter, 6);
	    return - 2;
	  }
	  else
	  {
	    if (SF)
	    {
	      FROM_ID = agent_ptr -> my_id;
	      THIS_ID = this_id;
	      set_Assign (TRO_MAKER, tro_maker);
	      set_Assign (DOM_WAITER, dom_waiter);
	    }
	    return - 1;
	  }
	}
      }
    }
  }

 /* del reductions */

  if (agent_ptr -> relation[this_id] != -1)
  {
  /* there is a reduction */

    set_Empty (free_dom);

  /* collect its reductions */

    temp1_ptr = agent_ptr -> position_ptr[this_id];
    if (temp1_ptr == NULL)
    {
      printf ("No such view %d in agent_view %d\n", this_id, my_id);
      exit (0);
    }
    set_Union (free_dom, temp1_ptr -> set1 /* reductions */ , free_dom);


    still_reduction (agent_ptr, free_dom, temp1_ptr);
    set_Union (agent_ptr -> avail_domain, free_dom,
	agent_ptr -> avail_domain);

  /* remove ( this_id and its value from agent_info ) */

    if (temp1_ptr == agent_ptr -> value_view_ptr)
    {
      agent_ptr -> value_view_ptr = temp1_ptr -> next;
      if (temp1_ptr -> next != NULL)
      {
	temp1_ptr -> next -> front = NULL;
      }
    }
    else
    {
      temp1_ptr -> front -> next = temp1_ptr -> next;
      if (temp1_ptr -> next != NULL)
      {
	temp1_ptr -> next -> front = temp1_ptr -> front;
      }
    }

    if (temp1_ptr == agent_ptr -> view_tail_ptr)
    {
      agent_ptr -> view_tail_ptr = temp1_ptr -> front;
      if (temp1_ptr -> front != NULL)
      {
	temp1_ptr -> front -> next = NULL;
      }
    }
    else
    {
      temp1_ptr -> next -> front = temp1_ptr -> front;
      if (temp1_ptr -> front != NULL)
      {
	temp1_ptr -> front -> next = temp1_ptr -> next;
      }
    }

    free_pointer ((struct info *) temp1_ptr, 2);
    agent_ptr -> position_ptr[this_id] = NULL;

  }
 /* 
  * del no_good which was related to it, the tro_maker has gone and the
  * nogood is gone as well
  */

  set_Empty (free_dom);

  del_ng (agent_ptr, this_id, free_dom);

  still_reduction (agent_ptr, free_dom, NULL);
  set_Union (agent_ptr -> avail_domain, free_dom,
      agent_ptr -> avail_domain);

  return this_id;

}				/* end of backtrack */


/* backtrack2 is called by agent2 by super_agent2 */

int
      backtrack2 (my_id, dom_waiter, tro_maker)
int   my_id;
SET dom_waiter;
SET tro_maker;
{
  SET free_dom;
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr;
  int   this_id;
  int   high_order;
  int   high_order2;
  int   i;
  int   agent_id;
  int   my_value;
  int   zero_length;

  agent_ptr = agent_index[pid][my_id];

  agent_ptr -> back_count++;

  set_Empty (tro_maker);
  set_Empty (dom_waiter);

  find_trowait (agent_ptr, tro_maker, dom_waiter);

 /* problems */
  if (!set_Ele (tro_maker))
  {
    return - 1;
  }
 /* select the this_id with higher order for backtracking */


  high_order = -1;
  this_id = -1;
  for (i = 0; i < agent_count; i++)
  {
    if (set_Mem (tro_maker, i))
    {
      if (agent_index[pid][i] -> order > high_order)
      {
	high_order = agent_index[pid][i] -> order;
	this_id = i;
      }
    }
  }

  if (get_order[pid][this_id] > agent_ptr -> order)
  {
    if (TRUE)
    {
      printf ("4This_id %d Its Order %d My_id %d My_Order %d\n",
	  this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      fprintf (out_ptr, "4This_id %d Its Order %d My_id %d My_Order %d\n",
	  this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      display (1);
      exit (0);
    }
    if (!agent_ptr -> in_link[this_id] &&
	agent_ptr -> position_ptr[this_id] == NULL)
    {
      printf ("P%d 5This_id %d Its Order %d My_id %d My_Order %d\n",
	  pid, this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      printf ("P%d PTR[this_id] %d in_link[this_id] %d \n", pid,
	  agent_ptr -> position_ptr[this_id],
	  agent_ptr -> in_link[this_id]);
      fprintf (out_ptr, "P%d 5This_id %d Its Order %d My_id %d My_Order %d\n",
	  pid, this_id, get_order[pid][this_id], my_id, agent_ptr -> order);
      fprintf (out_ptr, "P%d PTR[this_id] %d in_link[this_id] %d \n", pid,
	  agent_ptr -> position_ptr[this_id],
	  agent_ptr -> in_link[this_id]);
      display (1);
      exit (0);
    }


    if (agent_ptr -> position_ptr[this_id] != NULL)
    {
      undo_reduction_ret_still (my_id, this_id, FALSE);
    }


    if (agent_ptr -> in_link[this_id])
    {
      zero_length = FALSE;
      if (agent_ptr -> avail_length == 0)
      {
	zero_length = TRUE;
      }
      del_ng_sel_return (agent_ptr, this_id, TRUE, 8);
      if (agent_ptr -> avail_length > 0 && zero_length)
      {
	if (set_Mem (agent_index[pid][this_id] -> avail_domain,
	      agent_index[pid][this_id] -> my_value))
	{
	  set_Add (tro_maker, agent_ptr -> my_id);
	  make_nogood (agent_index[pid][this_id], tro_maker,
	      dom_waiter, my_id);
	  temp1_ptr = agent_index[pid][this_id] -> nogood_ptr;
	  agent_index[pid][this_id] -> nogood_ptr = temp1_ptr -> next;
	  temp1_ptr -> next = agent_ptr -> move_nogood_ptr;
	  agent_ptr -> move_nogood_ptr = temp1_ptr;
	}
      }
    }

    return agent_ptr -> my_id;

  }
  else
  {
    return this_id;
  }

}				/* end of backtrack2 */

/* select higher order variable */

int   select_high_order (agent_ptr, tro_maker, dom_waiter, from_id)
struct agent_home *agent_ptr;
SET tro_maker;
SET dom_waiter;
int   from_id;
{
  struct info *temp1_ptr;
  int   this_id;
  int   high_order;
  int   high_order2;
  int   i;
  int   agent_id;
  int   my_value;

  agent_ptr -> back_count++;

 /* problems */
  if (!set_Ele (tro_maker))
  {
    printf ("P%d CONFLICT F_I %d F_O %d I_I %d I_O %d\n",
	pid, from_id, get_order[pid][from_id],
	agent_ptr -> my_id, agent_ptr -> order);
    fprintf (out_ptr, "P%d CONFLICT F_I %d F_O %d I_I %d I_O %d\n",
	pid, from_id, get_order[pid][from_id],
	agent_ptr -> my_id, agent_ptr -> order);
    display (1);
    exit (0);
  }

 /* select the this_id with higher order for backtracking */

  high_order = -1;
  high_order2 = -1;
  this_id = -1;
  for (i = 0; i < agent_count; i++)
  {
    if (set_Mem (tro_maker, i))
    {
      if (agent_index[pid][i] -> processor_id > high_order)
      {
	high_order = agent_index[pid][i] -> processor_id;
	high_order2 = get_order[pid][i];
	this_id = i;
      }
      else
      {
	if (agent_index[pid][i] -> processor_id == high_order)
	{
	  if (get_order[pid][i] > high_order2)
	  {
	    high_order2 = get_order[pid][i];
	    this_id = i;
	  }
	}
      }
    }
  }

  if (high_order == pid)
  {
    if (!agent_ptr -> in_link[this_id] &&
	agent_ptr -> position_ptr[this_id] == NULL)
    {
      printf ("P%d T_P %d T_Id %d T_O %d F_Id %d F_O %d I_I %d I_O %d I%d P%d\n",
	  pid, high_order, this_id, high_order2, from_id,
	  get_order[pid][from_id], agent_ptr -> my_id, agent_ptr -> order,
	  agent_ptr -> in_link[this_id], agent_ptr -> position_ptr[this_id]);
      fprintf (out_ptr, "P%d TP %d TId %d TO %d FId %d FO %d II %d IO %d I%d P%d\n",
	  pid, high_order, this_id, high_order2, from_id,
	  get_order[pid][from_id], agent_ptr -> my_id, agent_ptr -> order,
	  agent_ptr -> in_link[this_id], agent_ptr -> position_ptr[this_id]);
      display (1);
      exit (0);
    }
    for (i = pid_info[pid].lower_order; i <= pid_info[pid].high_order; i++)
    {
      agent_id = agent_order[pid][i];
      if (this_id != agent_id)
      {
	if (agent_index[pid][agent_id] -> position_ptr[this_id] != NULL)
	{
	  undo_reduction_ret_still (agent_index[pid][agent_id], this_id, FALSE);
	}
	if (agent_index[pid][agent_id] -> in_link[this_id])
	{
	  del_ng_sel_return (agent_index[pid][agent_id], this_id, TRUE, 7);
	}
      }
    }
    if (agent_index[pid][this_id] -> my_value > -1)
    {
      make_nogood (agent_index[pid][this_id], tro_maker,
	  dom_waiter, agent_ptr -> my_id);
    }
    return agent_ptr -> my_id;

  }
  else
  {
    if (this_id == from_id)
    {
      return this_id;
    }
    else
    {
      make_nogoods_message (agent_ptr -> my_id, this_id,
	  tro_maker, dom_waiter, 5);
      return this_id;
    }
  }

}				/* end of select_high_order */

/* display nogoods */

print_nogoods (agent_ptr, out_ptr)
struct agent_home *agent_ptr;
FILE * out_ptr;
{
  struct info *temp1_ptr;
  int   i;
  int   mark;


  fprintf (out_ptr, "Agent %d nogood_value (due to backtrack) : \n",
      agent_ptr -> my_id);
  mark = FALSE;
  if (agent_ptr -> nogood_ptr != NULL)
  {
    fprintf (out_ptr, "In_link ");
    for (i = 0; i < agent_count; i++)
    {
      if (agent_ptr -> in_link[i])
      {
	fprintf (out_ptr, "%d ", i);
	mark = TRUE;
      }
    }
    fprintf (out_ptr, "\n");
  }
  else
  {
    mark = TRUE;
  }
  temp1_ptr = agent_ptr -> nogood_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 21);
      private_check = 0;
    }
    fprintf (out_ptr, "  NG %d LT %d traced by Ag %d ",
	temp1_ptr -> value, temp1_ptr -> logical_time, temp1_ptr -> id);
    fprintf (out_ptr, "tro_makers Ag ");
    display_dom (temp1_ptr -> set1, MAX_AGENT, out_ptr);
    fprintf (out_ptr, "dom_waiters Ag ");
    display_dom (temp1_ptr -> set2, MAX_AGENT, out_ptr);
    fprintf (out_ptr, "\n");
    temp1_ptr = temp1_ptr -> next;
  }

}				/* end of print_nogoods */
/* print dead ends */

print_bad_value (agent_ptr, out_ptr, detail)
struct agent_home *agent_ptr;
FILE * out_ptr;
int   detail;
{
  struct info *temp1_ptr;


  fprintf (out_ptr, "Agent %d bad_value (due to backtrack): \n",
      agent_ptr -> my_id);
  temp1_ptr = agent_ptr -> nogood_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 22);
      private_check = 0;
    }
    if (!set_Ele (temp1_ptr -> set1))
    {
      bad_value_count++;
      if (detail)
      {
	fprintf (out_ptr, "  NG %d LT %d traced by Ag %d ",
	    temp1_ptr -> value, temp1_ptr -> logical_time, temp1_ptr -> id);
	fprintf (out_ptr, "tro_makers Ag ");
	display_dom (temp1_ptr -> set1, MAX_AGENT, out_ptr);
	fprintf (out_ptr, "dom_waiters Ag ");
	display_dom (temp1_ptr -> set2, MAX_AGENT, out_ptr);
	fprintf (out_ptr, "\n");
      }
    }
    temp1_ptr = temp1_ptr -> next;
  }

}				/* end of print_nogoods */

/* print agent view */

print_view (agent_ptr, out_ptr)
struct agent_home *agent_ptr;
FILE * out_ptr;
{
  struct info *temp1_ptr;

  temp1_ptr = agent_ptr -> value_view_ptr;

  if (set_Ele (agent_ptr -> avail_domain))
  {
    fprintf (out_ptr, "Agent %d Avail_dom %d :", agent_ptr -> my_id,
	agent_ptr -> avail_length);
    display_dom (agent_ptr -> avail_domain, MAX_DOMAIN, out_ptr);
    fprintf (out_ptr, "\n");
  }
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 23);
      private_check = 0;
    }
    fprintf (out_ptr, "In Ag %d View Ag %d Val %d Len %d LT %d its reds: ",
	agent_ptr -> my_id, temp1_ptr -> id, temp1_ptr -> value,
	temp1_ptr -> length, temp1_ptr -> logical_time);
    display_dom (temp1_ptr -> set1, MAX_DOMAIN, out_ptr);
    fprintf (out_ptr, "\n");

    temp1_ptr = temp1_ptr -> next;
  }
}				/* end of print_view */

/* apply space for info */

apply_info (mail_ptr_ptr, place)
struct info **mail_ptr_ptr;
int   place;
{
  struct info *mail_ptr;
  struct info *temp_ptr;
  int   i;
  int   j;
  int   view_count = 0,
        nogood_count = 0,
        sum = 0,
        diff = 0;

  if (PS == 5 && np > 1)
  {
    m_lock ();
  }

  switch (place)
  {
    case 1: 			/* agent message  */
      temp_count1[pid]++;
      break;
    case 2: 			/* agent views  */
      temp_count2[pid]++;
      break;
    case 3: 			/* agent nogoods  */
      temp_count3[pid]++;
      break;
    case 4: 			/* pid messages  */
      temp_count4[pid]++;
      break;
    case 5: 			/* pid solutions  */
      temp_count5[pid]++;
      break;
    case 6: 			/*   */
      temp_count6[pid]++;
      break;
    default: 
      printf ("Place %d ??\n", place);
      exit (0);
  }
  if (space_buffer_ptr[pid] == NULL)
  {
    for (j = 0; j < 10; j++)
    {
      get_count[pid]++;
      if ((temp_ptr =
	    (INFO *) shmalloc (sizeof (INFO))) == NULL)
      {
	get_count[pid]--;
	fprintf (stderr, "Problems in Apply_Info. I will release some for you.\n");
	ini_set_agents (TRUE);	/* release space */
	exit (0);
      }
      temp_ptr -> next = space_buffer_ptr[pid];
      space_buffer_ptr[pid] = temp_ptr;
    }
  }
  mail_ptr = space_buffer_ptr[pid];
  space_buffer_ptr[pid] = space_buffer_ptr[pid] -> next;

  set_Empty (mail_ptr -> set1);
  set_Empty (mail_ptr -> set2);
  mail_ptr -> id = -1;
  mail_ptr -> to_id = -1;
  mail_ptr -> value = -1;
  mail_ptr -> length = -1;
  mail_ptr -> logical_time = -1;
  mail_ptr -> view_ptr = NULL;
  mail_ptr -> next = NULL;
  mail_ptr -> front = NULL;
  *mail_ptr_ptr = mail_ptr;

  if (PS == 5 && np > 1)
  {
    m_unlock ();
  }
}				/* end of apply_info */

/* free space for info */

free_info (message_ptr, place)
struct info *message_ptr;
int   place;
{
  struct info *temp1_ptr,
             *temp2_ptr;

  temp1_ptr = message_ptr -> view_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 24);
      private_check = 0;
    }
    temp2_ptr = temp1_ptr -> next;
    free_pointer ((struct info *) temp1_ptr, place);
    temp1_ptr = temp2_ptr;
  }
  free_pointer ((struct info *) message_ptr, place);

}				/* end of free_info */

/* free a line of info spaces */

free_link (pointer, place)
struct info *pointer;
int   place;
{
  struct info *temp1_ptr,
             *temp2_ptr;

  temp1_ptr = pointer;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 25);
      private_check = 0;
    }
    temp2_ptr = temp1_ptr;
    temp1_ptr = temp1_ptr -> next;
    if (temp2_ptr -> view_ptr != NULL)
    {
      free_info (temp2_ptr, place);
    }
    else
    {
      free_pointer ((struct info *) temp2_ptr, place);
    }

  }

}				/* free_link */

/* free point (space is not returned to the system) */

free_pointer (pointer, place)
struct info *pointer;
int   place;
{
  int   freeok;

  if (PS == 5 && np > 1)
  {
    m_lock ();
  }

  if (pointer == NULL)
  {
    printf ("Call from %d\n", place);
    exit (0);
  }
  switch (place)
  {
    case 1: 			/* agent messages */
      temp_count1[pid]--;
      break;
    case 2: 			/* agent views */
      temp_count2[pid]--;
      break;
    case 3: 			/* agent nogoods */
      temp_count3[pid]--;
      break;
    case 4: 			/* pid messages */
      temp_count4[pid]--;
      break;
    case 5: 			/* pid solutions */
      temp_count5[pid]--;
      break;
    case 6: 			/* others */
      temp_count6[pid]--;
      break;
    default: 
      printf ("Free Place %d ??\n", place);
      exit (0);
  }

  pointer -> next = space_buffer_ptr[pid];
  space_buffer_ptr[pid] = pointer;

  if (PS == 5 && np > 1)
  {
    m_unlock ();
  }
}

/* find conflict and exist variables */

find_trowait (agent_ptr, tro_maker, dom_waiter)
struct agent_home *agent_ptr;
SET tro_maker;
SET dom_waiter;
{
  struct info *temp1_ptr;

  temp1_ptr = agent_ptr -> value_view_ptr;
  while (temp1_ptr != NULL)
  {
    if (set_Ele (temp1_ptr -> set1))
    {
      set_Add (tro_maker, temp1_ptr -> id);
    }
    temp1_ptr = temp1_ptr -> next;
  }

  temp1_ptr = agent_ptr -> nogood_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 27);
      private_check = 0;
    }
    set_Union (tro_maker, temp1_ptr -> set1, tro_maker);
    set_Union (dom_waiter, temp1_ptr -> set2, dom_waiter);
    temp1_ptr = temp1_ptr -> next;
  }

}				/* end of find_trowait */

/* counting spaces */

int
      count_block (count_ptr)
struct info *count_ptr;
{
  struct info *temp1_ptr,
             *temp2_ptr;
  int   count = 0;

  temp1_ptr = count_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 28);
      private_check = 0;
    }
    if (temp1_ptr -> view_ptr != NULL)
    {
      temp2_ptr = temp1_ptr -> view_ptr;
      while (temp2_ptr != NULL)
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 29);
	  private_check = 0;
	}
	count++;
	temp2_ptr = temp2_ptr -> next;
      }
    }
    else
    {
      count++;
    }
    temp1_ptr = temp1_ptr -> next;
  }
  return count;

}				/* end of count_block */

/* separate search space */

sep_search_space (last, this, level, dom1, dom2, dom_length)
int   last;
int   this;
int   level;
SET dom1[MAX_AGENT];
SET dom2[MAX_AGENT];
int   dom_length[MAX_AGENT];
{
  SET bi_data1,
    bi_data2;
  int   i,
        j,
        k;
  int   order;


  if (last <= 0)
  {
    if (this <= 0)
    {
      return;
    }
    bi_data2[0] = this;
    order = 0;
    for (i = 0; i < level; i++)
    {
      while (dom_length[order /* WRONG */ ] <= 1)
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 30);
	  private_check = 0;
	}
	order++;
      }
      if (set_Mem (bi_data2, i))
      {
	set_Assign (agent_index[pid][agent_order[pid][order]] -> domain,
	    dom1[agent_order[pid][order]]);
	set_Assign (agent_index[pid][agent_order[pid][order]] -> avail_domain,
	    dom1[agent_order[pid][order]]);
      }
      else
      {
	set_Assign (agent_index[pid][agent_order[pid][order]] -> domain,
	    dom2[agent_order[pid][order]]);
	set_Assign (agent_index[pid][agent_order[pid][order]] -> avail_domain,
	    dom2[agent_order[pid][order]]);
      }
      order++;
    }
  }
  else
  {
    bi_data1[0] = last;
    bi_data2[0] = this;
    order = 0;
    for (i = 0; i < level; i++)
    {
      while (dom_length[order /* WRONG */ ] <= 1)
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 31);
	  private_check = 0;
	}
	order++;
      }
      if ((set_Mem (bi_data1, i) && !set_Mem (bi_data2, i)) ||
	  (!set_Mem (bi_data1, i) && set_Mem (bi_data2, i)))
      {
	if (set_Mem (bi_data2, i))
	{
	  set_Assign (agent_index[pid][agent_order[pid][order]] -> domain,
	      dom1[agent_order[pid][order]]);
	  set_Assign (agent_index[pid][agent_order[pid][order]] -> avail_domain,
	      dom1[agent_order[pid][order]]);
	}
	else
	{
	  set_Assign (agent_index[pid][agent_order[pid][order]] -> domain,
	      dom2[agent_order[pid][order]]);
	  set_Assign (agent_index[pid][agent_order[pid][order]] -> avail_domain,
	      dom2[agent_order[pid][order]]);
	}
	free_link (agent_index[pid][agent_order[pid][order]] -> nogood_ptr, 3);
	agent_index[pid][agent_order[pid][order]] -> nogood_ptr = NULL;
	free_link (agent_index[pid][agent_order[pid][order]] ->
	    value_view_ptr, 2);
	agent_index[pid][agent_order[pid][order]] -> value_view_ptr = NULL;
	agent_index[pid][agent_order[pid][order]] -> view_tail_ptr = NULL;
	for (j = 0; j < order; j++)
	{
	  agent_index[pid][agent_order[pid][order]] ->
	    position_ptr[agent_order[pid][j]] = NULL;
	  del_ng_waiter (agent_index[pid][agent_order[pid][j]],
	      agent_order[pid][order]);
	}
      }
      order++;
    }
  }
}				/* end of sep_search_space */

/* divide domains */

divide_dom (dom, dom1, dom2, id)
SET dom, dom1, dom2;
int   id;
{
  int   length;
  int   i;
  int   val;

  length = 0;
  for (i = 0; i < MAX_DOMAIN; i++)
  {
    if (set_Mem (dom, i))
    {
      length++;
    }
  }

  if (length <= 1)
  {
    if (length == 0)
    {
      printf ("Length = 0\n");
      exit (0);
    }
    dom_length[id] = 1;
    dom1_length[id] = -1;
    dom2_length[id] = -1;
    return;
  }

  set_Empty (dom1);
  set_Assign (dom2, dom);
  for (i = 0; i < length / 2; i++)
  {
    val = set_First (dom2);
    set_Del (dom2, val);
    set_Add (dom1, val);
  }

  dom1_length[id] = length / 2;
  dom2_length[id] = length - length / 2;
  dom_length[id] = length;
  return;

}				/* end of divide dom */

/* ini separate spaces */

ini_sep_space ()
{
  SET temp_dom1;
  SET temp_dom2;
  int   left_space;
  int   left_proc;
  int   sub_space;
  int   sub_proc;
  int   i;

  left_space = divide_sum;
  left_proc = np;

  sub_space = 0;
  sub_proc = 0;
  while (left_space > left_proc)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 35);
      private_check = 0;
    }
    set_Empty (temp_dom1);
    set_Empty (temp_dom2);
    temp_dom1[0] = sub_space;
    sub_space++;
    temp_dom2[0] = sub_space;
    sub_space++;
    left_space = left_space - 2;
    for (i = 0; i < divide_level; i++)
    {
      if (!set_Mem (temp_dom1, divide_level - i - 1) &&
	  !set_Mem (temp_dom2, divide_level - i - 1))
      {
	proc_space[sub_proc][i] = 0;
      }
      else
      {
	if (set_Mem (temp_dom1, divide_level - i - 1) &&
	    set_Mem (temp_dom2, divide_level - i - 1))
	{
	  proc_space[sub_proc][i] = 1;
	}
	else
	{
	  proc_space[sub_proc][i] = 2;
	}
      }
    }
    sub_proc++;
    left_proc--;
  }

  while (left_proc > 0)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 36);
      private_check = 0;
    }
    set_Empty (temp_dom1);
    temp_dom1[0] = sub_space;
    sub_space++;
    left_space--;
    for (i = 0; i < divide_level; i++)
    {
      if (!set_Mem (temp_dom1, divide_level - i - 1))
      {
	proc_space[sub_proc][i] = 0;
      }
      else
      {
	proc_space[sub_proc][i] = 1;
      }
    }
    sub_proc++;
    left_proc--;
  }


}				/* end of ini_sep_space */

/* set space */

set_space (p_no)
int   p_no;
{
  int   i;
  int   order;
  int   agent_id;


  ini_set_agents (FALSE);

  order = 0;
  for (i = 0; i < divide_level; i++)
  {
    while (dom_length[agent_order[pid][order]] <= 1)
    {
      agent_id = agent_order[pid][order];
      set_Assign (agent_index[pid][agent_id] -> domain, dom[agent_id]);
      set_Assign (agent_index[pid][agent_id] -> avail_domain, dom[agent_id]);
      agent_index[pid][agent_id] -> dom_length = dom_length[agent_id];
      agent_index[pid][agent_id] -> avail_length = dom_length[agent_id];
      order++;
    }
    agent_id = agent_order[pid][order];
    if (proc_space[p_no][i] == 0)
    {
      set_Assign (agent_index[pid][agent_id] -> domain, dom1[agent_id]);
      set_Assign (agent_index[pid][agent_id] -> avail_domain, dom1[agent_id]);
      agent_index[pid][agent_id] -> dom_length = dom1_length[agent_id];
      agent_index[pid][agent_id] -> avail_length = dom1_length[agent_id];
    }
    else
    {
      if (proc_space[p_no][i] == 1)
      {
	set_Assign (agent_index[pid][agent_id] -> domain, dom2[agent_id]);
	set_Assign (agent_index[pid][agent_id] -> avail_domain, dom2[agent_id]);
	agent_index[pid][agent_id] -> dom_length = dom2_length[agent_id];
	agent_index[pid][agent_id] -> avail_length = dom2_length[agent_id];
      }
      else
      {
	set_Assign (agent_index[pid][agent_id] -> domain, dom[agent_id]);
	set_Assign (agent_index[pid][agent_id] -> avail_domain, dom[agent_id]);
	agent_index[pid][agent_id] -> dom_length = dom_length[agent_id];
	agent_index[pid][agent_id] -> avail_length = dom_length[agent_id];
      }
    }
    order_level = order;
    order++;
  }

  for (i = order; i < agent_count; i++)
  {
    agent_id = agent_order[pid][i];
    set_Assign (agent_index[pid][agent_id] -> domain, dom[agent_id]);
    set_Assign (agent_index[pid][agent_id] -> avail_domain, dom[agent_id]);
    agent_index[pid][agent_id] -> dom_length = dom_length[agent_id];
    agent_index[pid][agent_id] -> avail_length = dom_length[agent_id];
  }


}				/* end of set_space */

/* copy agent information */

copy_agent (p_no)
int   p_no;
{
  struct agent_home *agent_ptr1;
  struct agent_home *agent_ptr2;
  int   i;
  int   j;

  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[p_no][i] == NULL)
    {

    /* apply for a op_node */

      if ((agent_ptr1 =
	    (AGENT_HOME *) shmalloc (sizeof (AGENT_HOME))) == '\0')
      {
	if (out_ptr != stdout)
	  fprintf (stderr, "Out of memory \n");
	fprintf (out_ptr, "Out of memory \n");
	(void) fclose (out_ptr);
	exit (1);
      }
      agent_index[p_no][i] = agent_ptr1;
    }
  }



  for (i = 0; i < agent_count; i++)
  {
    agent_ptr1 = agent_index[p_no][i];
    agent_ptr2 = agent_index[0][i];
    if (agent_ptr2 != NULL)
    {

    /* the node should be set to be 0 first */

      set_Assign (agent_ptr1 -> avail_domain, agent_ptr2 -> avail_domain);
      set_Assign (agent_ptr1 -> domain, agent_ptr2 -> domain);
      agent_ptr1 -> order = agent_ptr2 -> order;
      for (j = 0; j < agent_count; j++)
      {
	agent_ptr1 -> relation[j] = agent_ptr2 -> relation[j];
	agent_ptr1 -> going_value[j] = agent_ptr2 -> going_value[j];
	agent_ptr1 -> in_link[j] = agent_ptr2 -> in_link[j];
	agent_ptr1 -> position_ptr[j] = NULL;
      }
      agent_ptr1 -> order = agent_ptr2 -> order;
      agent_ptr1 -> rel_length = agent_ptr2 -> rel_length;
      agent_ptr1 -> dom_length = agent_ptr2 -> dom_length;
      agent_ptr1 -> avail_length = agent_ptr2 -> dom_length;
      set_Empty (agent_ptr1 -> conf_set);
      set_Empty (agent_ptr1 -> past_fc);
      set_Empty (agent_ptr1 -> future_fc);
      if (PS == 4)		/* PS4 */
      {
	agent_ptr1 -> processor_id = agent_ptr2 -> processor_id;
      }
      else
      {
	agent_ptr1 -> processor_id = p_no;
      }
      agent_ptr1 -> my_id = i;
      agent_ptr1 -> my_value = -1;
      agent_ptr1 -> to_be_sent = FALSE;
      agent_ptr1 -> value_view_ptr = NULL;
      agent_ptr1 -> view_tail_ptr = NULL;
      agent_ptr1 -> message_ptr = NULL;
      agent_ptr1 -> nogood_ptr = NULL;

      agent_ptr1 -> apply_count = 0;
      agent_ptr1 -> apply_arc_count = 0;
      agent_ptr1 -> message_count = 0;
      agent_ptr1 -> rece_count = 0;
      agent_ptr1 -> back_count = 0;

      agent_ptr1 -> block_send = 0;
      agent_ptr1 -> block_rece = 0;

      agent_ptr1 -> temp_rece = 0;
      agent_ptr1 -> temp_send = 0;

    }
  }

  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[0][i] != NULL)
    {
      agent_order[p_no][i] = agent_order[0][i];
      get_order[p_no][i] = get_order[0][i];
      dynamic_order[p_no][i] = dynamic_order[0][i];
    }
  }
  current_order[p_no] = current_order[0];

}				/* end of copy_agent */

/* fork multi super_agent */

void work_agent ()
{
  int   process_id;
  int   nprocess;
  int   i;

  int   mark = TRUE;


  pid = m_get_myid ();
  super_agent ();
  m_sync ();

}				/* end of work_agent */

/* mfork multi super_agent2 */

void work_agent2 ()
{
  int   process_id;
  int   nprocess;
  int   i;

  int   mark = TRUE;


  process_id = m_get_myid ();
  nprocess = m_get_numprocs ();

  for (i = m_get_myid (); i < nprocess && mark; i++)
  {
    pid = i;
    super_agent2 ();
    m_sync ();
    mark = FALSE;
  }

}				/* end of work_agent2 */

/* divide space */

int   divide_space (from_pid, to_pid)
int   from_pid;
int   to_pid;
{

  SET temp_dom;
  struct agent_home *agent_ptr;
  int   i;
  int   j;
  int   k;
  int   length;
  int   done;
  int   val;
  int   now_level;
  int   agent_id;
  int   order;

  done = FALSE;
  now_level = 0;

  agent_index[from_pid][0] -> apply_arc_count =
    agent_index[from_pid][0] -> apply_arc_count + sizeof (INFO);

  order = 0;
  for (i = 0; i < search_level; i++)
  {
    if (D_O && FALSE)
    {
      if (i > current_order[pid])
      {
	return FALSE;
      }
    }
    agent_id = agent_order[from_pid][i];
    agent_ptr = agent_index[from_pid][agent_id];
    if (set_Ele (agent_ptr -> avail_domain))
    {
      length = 0;
      for (j = 0; j < MAX_DOMAIN; j++)
      {
	if (set_Mem (agent_ptr -> avail_domain, j))
	{
	  length++;
	}
      }
      if (length > 1)
      {
	set_Empty (agent_index[to_pid][agent_id] -> domain);
	set_Empty (temp_dom);
	for (j = 0; j < length / 2; j++)
	{
	  val = set_First (agent_ptr -> avail_domain);
	  set_Add (temp_dom, val);
	  set_Del (agent_ptr -> avail_domain, val);
	  set_Del (agent_ptr -> domain, val);
	}
	if (!set_Mem (agent_ptr -> avail_domain, agent_ptr -> my_value))
	{
	  agent_index[to_pid][agent_id] -> apply_arc_count =
	    agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
	  set_Assign (agent_index[to_pid][agent_id] -> domain,
	      agent_ptr -> avail_domain);
	  agent_index[to_pid][agent_id] -> dom_length = length / 2;
	  agent_index[to_pid][agent_id] -> apply_arc_count =
	    agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
	  set_Assign (agent_ptr -> avail_domain, temp_dom);
	  agent_index[to_pid][agent_id] -> apply_arc_count =
	    agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
	  set_Assign (agent_ptr -> domain, temp_dom);
	  agent_ptr -> dom_length = agent_ptr -> dom_length - length / 2;
	  agent_ptr -> avail_length = agent_ptr -> avail_length - length / 2;
	}
	else
	{
	  agent_index[to_pid][agent_id] -> apply_arc_count =
	    agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
	  set_Assign (agent_index[to_pid][agent_id] -> domain, temp_dom);
	  agent_index[to_pid][agent_id] -> dom_length =
	    agent_ptr -> avail_length - length / 2;
	  agent_ptr -> dom_length = agent_ptr -> dom_length -
	    agent_index[to_pid][agent_id] -> dom_length;
	  agent_ptr -> avail_length = agent_ptr -> avail_length -
	    agent_index[to_pid][agent_id] -> dom_length;
	}
	now_level = i;
	done = TRUE;
	break;
      }
      else
      {
	agent_index[to_pid][agent_id] -> apply_arc_count =
	  agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
	set_Assign (agent_index[to_pid][agent_id] -> domain,
	    agent_ptr -> avail_domain);
	agent_index[to_pid][agent_id] -> dom_length = 1;
      }
    }
    else
    {
      return FALSE;
    }
  }

  for (i = now_level + 1; i <= change_level && done; i++)
  {
    agent_id = agent_order[pid][i];
    agent_index[to_pid][agent_id] -> apply_arc_count =
      agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
    set_Assign (agent_index[to_pid][agent_id] -> domain,
	agent_index[from_pid][agent_id] -> domain);
    agent_index[to_pid][agent_id] -> dom_length =
      agent_index[from_pid][agent_id] -> dom_length;
  }

  for (i = change_level + 1; i < agent_count && done && D_O; i++)
  {
    agent_id = agent_order[pid][i];
    agent_index[to_pid][agent_id] -> apply_arc_count =
      agent_index[to_pid][agent_id] -> apply_arc_count + sizeof (SET);
    set_Assign (agent_index[to_pid][agent_id] -> domain,
	agent_index[from_pid][agent_id] -> domain);
    agent_index[to_pid][agent_id] -> dom_length =
      agent_index[from_pid][agent_id] -> dom_length;
  }

  return done;

}				/* divide_space */

/* ini agents */

ini_set_agents (keep_record)
int   keep_record;
{
  struct agent_home *agent_ptr;
  int   i;
  int   k;

  for (i = 0; i < agent_count; i++)
  {
    agent_ptr = agent_index[pid][i];
    if (agent_ptr != NULL)
    {

    /* the node should be set to be 0 first */

      set_Empty (agent_ptr -> conf_set);
      set_Empty (agent_ptr -> past_fc);
      set_Empty (agent_ptr -> future_fc);
      set_Empty (agent_ptr -> avail_domain);
      set_Union (agent_ptr -> avail_domain, agent_ptr -> domain,
	  agent_ptr -> avail_domain);
      agent_ptr -> avail_length = agent_ptr -> dom_length;
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;
      free_link (agent_ptr -> value_view_ptr, 2);
      free_link (agent_ptr -> message_ptr, 1);
      free_link (agent_ptr -> nogood_ptr, 3);
      agent_ptr -> value_view_ptr = NULL;
      agent_ptr -> view_tail_ptr = NULL;
      agent_ptr -> message_ptr = NULL;
      agent_ptr -> nogood_ptr = NULL;

      if (!keep_record)
      {
	agent_ptr -> apply_count = 0;
	agent_ptr -> apply_arc_count = 0;
	agent_ptr -> message_count = 0;
	agent_ptr -> rece_count = 0;
	agent_ptr -> back_count = 0;

	agent_ptr -> block_send = 0;
	agent_ptr -> block_rece = 0;

	agent_ptr -> temp_rece = 0;
	agent_ptr -> temp_send = 0;
      }
    }
  }

  for (i = 0; i < MAX_AGENT; i++)
  {
    agent_ptr = agent_index[pid][i];
    if (agent_ptr != NULL)
    {
    /* set in_link */
      get_order[pid][i] = agent_ptr -> order;
      for (k = 0; k < MAX_AGENT; k++)
      {
	agent_ptr -> position_ptr[k] = NULL;
	agent_ptr -> going_value[k] = -1;
	agent_ptr -> in_link[k] = FALSE;
      }

    }
  }

}				/* end of ini_set_agent */

/* dynamic variable ordering */

dynamic_order_up ()
{
  struct agent_home *agent_ptr;
  int   i;
  int   j;
  int   min_dom = 999;
  int   max_rel = -1;
  int   agent_id = -1;
  int   max_dom = -1;
  int   min_rel = 999;
  int   outside_relation;
  int   temp;


 /* 1: min_dom 2: max_rel */
  for (i = 0; i < agent_count && HEURISTIC == 1; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr -> avail_length < min_dom ||
	  (agent_ptr -> avail_length == min_dom &&
	    agent_ptr -> rel_length > max_rel))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = agent_ptr -> rel_length;
      }
    }
  }
 /* 1: max_rel 2: min_dom */
  for (i = 0; i < agent_count && HEURISTIC == 2; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr -> rel_length > max_rel ||
	  (agent_ptr -> rel_length == max_rel &&
	    agent_ptr -> avail_length < min_dom))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = agent_ptr -> rel_length;
      }
    }
  }
 /* 1: min_dom 2: outside relations */
  for (i = 0; i < agent_count && HEURISTIC == 3; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

    /* get outside relation */
      outside_relation = 0;
      for (j = 0; j < agent_count; j++)
      {
	if (agent_index[pid][j] -> processor_id != pid &&
	    agent_ptr -> relation[j] != -1)
	{
	  outside_relation++;
	}
      }

      if (agent_ptr -> avail_length < min_dom ||
	  (agent_ptr -> avail_length == min_dom &&
	    outside_relation > max_rel))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = outside_relation;
      }
    }
  }
 /* 1: max_rel with + outside relations 2: min_dom */
  for (i = 0; i < agent_count && HEURISTIC == 4; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

    /* get outside relation */
      outside_relation = 0;
      for (j = 0; j < agent_count; j++)
      {
	if (agent_index[pid][j] -> processor_id != pid &&
	    agent_ptr -> relation[j] != -1)
	{
	  outside_relation++;
	}
      }

      if (outside_relation > max_rel ||
	  (outside_relation == max_rel &&
	    agent_ptr -> avail_length < min_dom))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = outside_relation;
      }
    }
  }

 /* 1: min_dom 2: max_rel - outside relations */
  for (i = 0; i < agent_count && HEURISTIC == 5; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

    /* get outside relation */
      outside_relation = 0;
      for (j = 0; j < agent_count; j++)
      {
	if (agent_index[pid][j] -> processor_id != pid &&
	    agent_ptr -> relation[j] != -1)
	{
	  outside_relation++;
	}
      }

      if (agent_ptr -> avail_length < min_dom ||
	  (agent_ptr -> avail_length == min_dom &&
	    agent_ptr -> rel_length - outside_relation > max_rel))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = agent_ptr -> rel_length - outside_relation;
      }
    }
  }
 /* 1: max_rel - outside relations 2: min_dom */
  for (i = 0; i < agent_count && HEURISTIC == 6; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];

    /* get outside relation */
      outside_relation = 0;
      for (j = 0; j < agent_count; j++)
      {
	if (agent_index[pid][j] -> processor_id != pid &&
	    agent_ptr -> relation[j] != -1)
	{
	  outside_relation++;
	}
      }

      if (agent_ptr -> rel_length - outside_relation > max_rel ||
	  (agent_ptr -> rel_length - outside_relation == max_rel &&
	    agent_ptr -> avail_length < min_dom))
      {
	agent_id = agent_ptr -> my_id;
	min_dom = agent_ptr -> avail_length;
	max_rel = agent_ptr -> rel_length - outside_relation;
      }
    }
  }

 /* 1: max_dom 2: min_rel */
  for (i = 0; i < agent_count && HEURISTIC == 7; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr -> avail_length > max_dom ||
	  (agent_ptr -> avail_length == max_dom &&
	    agent_ptr -> rel_length < min_rel))
      {
	agent_id = agent_ptr -> my_id;
	max_dom = agent_ptr -> avail_length;
	min_rel = agent_ptr -> rel_length;
      }
    }
  }
 /* 1: min_rel 2: max_dom */
  for (i = 0; i < agent_count && HEURISTIC == 8; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      agent_ptr = agent_index[pid][i];
      if (agent_ptr -> rel_length < min_rel ||
	  (agent_ptr -> rel_length == min_rel &&
	    agent_ptr -> avail_length > max_dom))
      {
	agent_id = agent_ptr -> my_id;
	max_dom = agent_ptr -> avail_length;
	min_rel = agent_ptr -> rel_length;
      }
    }
  }
  if (agent_id < 0)
  {
    fprintf (out_ptr, "Strange Order2 %d\n", current_order[pid]);
    for (i = 0; i < agent_count; i++)
    {
      fprintf (out_ptr, " %d %d ", i, dynamic_order[pid][i]);
    }
    fprintf (out_ptr, "\n");
    display (1);
    exit (0);
  }
  current_order[pid]++;
  agent_order[pid][current_order[pid]] = agent_id;
  get_order[pid][agent_id] = current_order[pid];
  dynamic_order[pid][agent_id] = current_order[pid];
  agent_index[pid][agent_id] -> order = current_order[pid];

  temp = current_order[pid];
  for (i = 0; i < agent_count; i++)
  {
    if (dynamic_order[pid][i] < 0 &&
	agent_index[pid][i] -> processor_id == pid)
    {
      temp++;
      agent_ptr = agent_index[pid][i];
      agent_ptr -> order = temp;
      get_order[pid][agent_ptr -> my_id] = temp;
      agent_order[pid][temp] = agent_ptr -> my_id;
    }
  }
}				/* dynamic_order_up */

/* order down */

dynamic_order_down (from_order, to_order)
int   from_order;
int   to_order;
{
  int   i;
  int   agent_id;

  if (to_order >= from_order)
  {
    printf ("Strange Order2 F_O %d T_O %d\n", from_order, to_order);
    display (1);
    exit (0);
  }
  for (i = to_order + 1; i <= from_order; i++)
  {
    agent_id = agent_order[pid][i];
    dynamic_order[pid][agent_id] = -1;
  }
  current_order[pid] = to_order;

}				/* dynamic_order_down */

/* make nogoods */

make_nogood (agent_ptr, tro_maker, dom_waiter, from_id)
struct agent_home *agent_ptr;
SET tro_maker;
SET dom_waiter;
int   from_id;
{

  struct info *my_nogood_ptr;
  struct info *temp1_ptr;
  int   i;
  int   agent_id;
  int   miss_id;


  if (!set_Mem (agent_ptr -> avail_domain, agent_ptr -> my_value))
  {
    if (agent_ptr -> my_value != -2)
    {
      agent_ptr -> my_value = -1;
      agent_ptr -> to_be_sent = FALSE;
    }
    return;
  }

  if (np == 1)
  {
    nogood_make_count++;
  }

  if (FALSE && from_id == 13 && pid == 1)
  {
    printf ("P%d From_Id %d\n", pid, from_id);
  }

  set_Del (tro_maker, from_id);
  set_Del (tro_maker, agent_ptr -> my_id);
  set_Add (dom_waiter, from_id);
  set_Del (dom_waiter, agent_ptr -> my_id);
  for (agent_id = 0; agent_id <= agent_count; agent_id++)
  {
    if (agent_id != agent_ptr -> my_id && set_Mem (tro_maker, agent_id))
    {
      agent_ptr -> in_link[agent_id] = TRUE;
    }
  }


 /* set conf_record */

 /* take away my_value from avail_domain */

  set_Del (agent_ptr -> avail_domain, agent_ptr -> my_value);
  agent_ptr -> avail_length--;

 /* set the nogood caused by backtrack */

  apply_info (&my_nogood_ptr, 3);
  my_nogood_ptr -> id = from_id;
  my_nogood_ptr -> to_id = agent_ptr -> my_id;
  my_nogood_ptr -> value = agent_ptr -> my_value;
  my_nogood_ptr -> logical_time = logical_time[pid];
  logical_time[pid]++;
  set_Union (tro_maker /* the agents who tro_makers  */ ,
      my_nogood_ptr -> set1,
      my_nogood_ptr -> set1);
  set_Union (dom_waiter /* the agents who wait_dom */ ,
      my_nogood_ptr -> set2,
      my_nogood_ptr -> set2);
  if (SHA)
  {
    if (!set_Ele (my_nogood_ptr -> set1))
    {
      set_Del (agent_ptr -> domain, my_nogood_ptr -> value);
      for (i = 0; i < np && agent_ptr -> order > change_level; i++)
      {
	if (i != pid)
	{
	  apply_info (&temp1_ptr, 4);
	  temp1_ptr -> value = my_nogood_ptr -> value;
	  temp1_ptr -> id = agent_ptr -> my_id;
	  s_lock (&lock[i]);
	  temp1_ptr -> next = pid_info[i].message_ptr;
	  pid_info[i].message_ptr = temp1_ptr;
	  s_unlock (&lock[i]);
	}
      }
    }
  }
  if (agent_ptr -> nogood_ptr == NULL)
  {
    agent_ptr -> nogood_ptr = my_nogood_ptr;
  }
  else
  {
    my_nogood_ptr -> next = agent_ptr -> nogood_ptr;
    agent_ptr -> nogood_ptr = my_nogood_ptr;
  }
  if (FC == 2)			/* FC2 */
  {
    for (i = agent_ptr -> order + 1; i < agent_count; i++)
    {
      agent_id = agent_order[pid][i];

    /* undo reductions of my_id */
      if (agent_index[pid][agent_id] ->
	  position_ptr[agent_ptr -> my_id] != NULL)
      {
      /* undo_reduction_return (agent_id, agent_ptr -> my_id); */
	undo_reduction_ret_still (agent_id, agent_ptr -> my_id, TRUE);
      }

    /* undo nogoods of my_id */
      if (agent_index[pid][agent_id] -> in_link[agent_ptr -> my_id] != FALSE)
      {
	del_ng_sel_return (agent_index[pid][agent_id],
	    agent_ptr -> my_id, TRUE, 6);
      }

    }
  }
  agent_ptr -> my_value = -1;
  agent_ptr -> to_be_sent = FALSE;

}				/* end of make_nogood */

/* send mail */

send_mail (to_pid, from_id, to_id,
  value, order, mail_no, view_ptr, set1, set2, place)
int   to_pid,
      from_id,
      to_id,
      value,
      order,
      mail_no;
struct info *view_ptr;
SET set1;
SET set2;
int   place;
{
  struct info *message_ptr;
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  int   add_ok = TRUE;
  int   sleep_one;
  int   i;
  int   j;
  int   kill_err;

  if (agent_index[pid][from_id] -> processor_id != pid)
  {
    fprintf (stderr, "P%d To P%d FA (%d) TA %d V %d O %d MNO %d LT1 %d LT2 %d NM %d P_S %d W %d\n",
	pid, to_pid, from_id, to_id, value, order, mail_no,
	message_ptr -> logical_time, logical_time[pid],
	NO_MORE[pid], PART_SOL[pid], place);
    display (1);
    exit (0);
  }
  if (pid == to_pid)
  {
    printf ("P%d Sends Itself Message %d\n", pid, mail_no);
    exit (0);
  }

  apply_info (&message_ptr, 4);
  message_ptr -> id = from_id;
  message_ptr -> to_id = to_id;
  message_ptr -> value = value;
  message_ptr -> order = order;
  message_ptr -> mail_no = mail_no;
  message_ptr -> view_ptr = view_ptr;

  message_ptr -> logical_time = logical_time[pid];

  pid_info[pid].mail_numbers[pid]++;
  message_ptr -> mail_number = pid_info[pid].mail_numbers[pid];


  switch (mail_no)
  {
    case 2: 			/* ok */
      DID_SOMETHING[pid] = TRUE;
      if (value < 0 || order < 0 ||
	  agent_index[pid][from_id] -> out_link[to_pid] == FALSE)
      {
	printf ("P%d wrongly SEND To P%d FA %d TA %d V %d O %d MNO %d \n",
	    pid, to_pid, from_id, to_id, value, order, mail_no);
	fprintf (stderr, "P%d SEND To P%d FA %d TA %d V %d O %d MNO %d LT1 %d LT2 %d NM %d P_S %d W %d\n",
	    pid, to_pid, from_id, to_id, value, order, mail_no,
	    message_ptr -> logical_time, logical_time[pid],
	    NO_MORE[pid], PART_SOL[pid], place);
	if (stdout != out_ptr)
	{
	  fprintf (out_ptr, "P%d SEND To P%d FA %d TA %d V %d O %d MNO %d \n",
	      pid, to_pid, from_id, to_id, value, order, mail_no);
	}
	display (1);
	exit (0);
      }
      if (SF)
      {
	if (pid_info[pid].values[from_id] != -1 &&
	    pid_info[pid].values[from_id] != value)
	{
	  printf ("P%d SEND To P%d FA %d TA %d V %d OV %d O %d MNO %d LT %d W %d\n",
	      pid, to_pid, from_id, to_id, value,
	      pid_info[pid].values[from_id], order, mail_no,
	      message_ptr -> logical_time, place);
	  display (1);
	  exit (0);
	}
      }
      agent_index[pid][from_id] -> send_place = place;
      if (SF)
      {
	message_ptr -> logical_time = agent_index[pid][from_id] -> logical_time;
      }
      else
      {
	message_ptr -> logical_time = logical_time[pid];
	agent_index[pid][from_id] -> logical_time = logical_time[pid];
      }
      break;
    case 3: 			/* backtrack */
      DID_SOMETHING[pid] = TRUE;
      set_Assign (message_ptr -> set1, set1);
      set_Assign (message_ptr -> set2, set2);
      message_ptr -> logical_time = agent_index[pid][to_id] -> logical_time;
      break;
    case 4: 			/* adding a link */
      DID_SOMETHING[pid] = TRUE;
      message_ptr -> logical_time = agent_index[pid][to_id] -> logical_time;
      break;
    case 20: 
      break;
    case 21: 
      break;
    case 22: 
      break;
    case 23: 
      break;
    case 24: 
      break;
    case 25: 
      break;
    default: 			/* nothing */
      printf ("No Such Choice2\n");
      exit (0);
      break;
  }

  pid_info[pid].mail_no[pid] = message_ptr -> mail_no;
  pid_info[pid].mail_id[pid] = message_ptr -> id;
  pid_info[pid].mail_to_id[pid] = message_ptr -> to_id;
  pid_info[pid].mail_pid[pid] = to_pid;
  pid_info[pid].mail_val[pid] = message_ptr -> value;
  pid_info[pid].mail_lt[pid] = message_ptr -> logical_time;
  pid_info[pid].mail_lt2[pid] = logical_time[pid];

 /* send mail now */

  if (from_id < 0 || from_id >= agent_count)
  {
    printf ("Such from_id %d\n", from_id);
    exit (0);
  }
  agent_index[pid][from_id] -> temp_send++;

  if ((PRINT || agent_index[pid][from_id] -> temp_send > 2000) &&
      (mail_no <= 4 || mail_no == 23))
  {
    fprintf (stderr, "P%d SEND To P%d FA %d TA %d V %d O %d MNO %d LT1 %d LT2 %d NM %d P_S %d W %d MN %d\n",
	pid, to_pid, from_id, to_id, value, order, mail_no,
	message_ptr -> logical_time, logical_time[pid],
	NO_MORE[pid], PART_SOL[pid], place, message_ptr -> mail_number);
    if (agent_index[pid][from_id] -> temp_send > 2000)
    {
      PRINT = TRUE;
      agent_index[pid][from_id] -> temp_send = 0;
    }
  }

  sleep_one = FALSE;

  s_lock (&lock[to_pid]);

 /* take away the mail from the same agent */
  temp2_ptr = NULL;
  temp1_ptr = pid_info[to_pid].message_ptr;
  while (temp1_ptr != NULL)
  {
    private_check++;
    if (private_check == 10000)
    {
      printf ("P%d rests so long Mark %d\n", pid, 37);
      private_check = 0;
    }
  /* temp2_ptr = temp1_ptr; */
    if ((temp1_ptr -> id == from_id) &&
	(temp1_ptr -> to_id == to_id) &&
	(temp1_ptr -> mail_no == mail_no))
    {
      if (temp1_ptr == pid_info[to_pid].message_ptr)
      {
	pid_info[to_pid].message_ptr = temp1_ptr -> next;
      }
      if (temp1_ptr == pid_info[to_pid].tail_ptr)
      {
	pid_info[to_pid].tail_ptr = temp2_ptr;
      }
      if (temp2_ptr != NULL)
      {
	temp2_ptr -> next = temp1_ptr -> next;
      }
      free_info ((struct info *) temp1_ptr, 4);
      break;

    }
    temp2_ptr = temp1_ptr;
    temp1_ptr = temp1_ptr -> next;
  }

 /* add new mail */
  if (add_ok)
  {
    if (pid_info[to_pid].message_ptr == NULL)
    {
      pid_info[to_pid].message_ptr = message_ptr;
      pid_info[to_pid].tail_ptr = message_ptr;
    }
    else
    {
      pid_info[to_pid].tail_ptr -> next = message_ptr;
      pid_info[to_pid].tail_ptr = message_ptr;
    }
  }

  if (pid_info[to_pid].status == 2)
  {
    pid_info[to_pid].status = 1;
    still_pause[pid][to_pid] = TRUE;
    sleep_one = TRUE;
  }

  s_unlock (&lock[to_pid]);

  if (sleep_one)
  {
    kill (proc_ids[to_pid], SIGUSR2);
  }

}				/* end of send_mail */


/* copy infos */

copy_info (info1_ptr, info2_ptr)
struct info *info1_ptr;
struct info *info2_ptr;
{

  set_Assign (info2_ptr -> set1, info1_ptr -> set1);
  set_Assign (info2_ptr -> set2, info1_ptr -> set2);
  info2_ptr -> id = info1_ptr -> id;
  info2_ptr -> to_id = info1_ptr -> to_id;
  info2_ptr -> value = info1_ptr -> value;
  info2_ptr -> order = info1_ptr -> order;
  info2_ptr -> mail_no = info1_ptr -> mail_no;
  info2_ptr -> logical_time = info1_ptr -> logical_time;
  if (info2_ptr -> view_ptr != NULL)
  {
    free_link (info2_ptr -> view_ptr, 4);
  }
  info2_ptr -> view_ptr = info1_ptr -> view_ptr;
  info1_ptr -> view_ptr = NULL;


}				/* end of copy_info */

/* receive messages */

int   rece_message (message_ptr)
struct info *message_ptr;
{
  struct agent_home *agent_ptr;
  struct info *temp1_ptr,
             *temp2_ptr,
             *this_ptr,
             *nogood_ptr;
  int   from_id;
  int   to_id;
  int   tro_id;
  int   from_pid;
  SET tro_maker;
  SET dom_waiter;
  int   i,
        j,
        k;
  int   this_id;
  int   incompatible;
  int   next_order;
  int   high_order;
  int   high_order1;
  int   two_values;
  int   temp;
  int   temp_id;
  int   temp_order;
  int   no_value;
  int   old_value;
  int   return_flag;


  to_id = message_ptr -> to_id;
  from_id = message_ptr -> id;
  from_pid = agent_index[pid][from_id] -> processor_id;

  if (from_id < 0 || from_id >= agent_count)
  {
    printf ("Such from_id %d\n", from_id);
    exit (0);
  }

  if (message_ptr -> mail_no >= 2 &&
      message_ptr -> mail_no <= 4)
  {
    DID_SOMETHING[pid] = TRUE;
  }

  if (message_ptr -> mail_number < pid_info[pid].mail_numbers[from_pid] ||
      from_pid == pid)
  {
    fprintf (stderr, "P%d RECE From P%d FA %d TA %d V %d O %d MNO %d LT1 %d LT2 %d NM %d P_S %d MN1 %d MN2 %d\n",
	pid, agent_index[pid][from_id] -> processor_id, from_id, to_id,
	message_ptr -> value, message_ptr -> order, message_ptr -> mail_no,
	message_ptr -> logical_time, logical_time[pid],
	NO_MORE[pid], PART_SOL[pid], message_ptr -> mail_number,
	pid_info[pid].mail_numbers[from_pid]);
    display (1);
    exit (0);
  }
  else
  {
    pid_info[pid].mail_numbers[from_pid] = message_ptr -> mail_number;
    pid_info[pid].mail_no[from_pid] = message_ptr -> mail_no;
    pid_info[pid].mail_id[from_pid] = message_ptr -> id;
    pid_info[pid].mail_pid[from_pid] = from_pid;
    pid_info[pid].mail_to_id[from_pid] = message_ptr -> to_id;
    pid_info[pid].mail_val[from_pid] = message_ptr -> value;
    pid_info[pid].mail_lt[from_pid] = message_ptr -> logical_time;
    pid_info[pid].mail_lt2[from_pid] = logical_time[pid];
  }

  agent_index[pid][from_id] -> temp_rece++;
  if (message_ptr -> mail_no <= 4)
  {
    agent_index[pid][agent_order[pid][pid_info[pid].lower_order]]
      -> rece_count++;
    temp1_ptr = message_ptr;
    temp = 0;
    while (temp1_ptr != NULL)
    {
      temp++;
      temp1_ptr = temp1_ptr -> next;
    }
    agent_index[pid][agent_order[pid][pid_info[pid].lower_order]]
      -> apply_arc_count =
      agent_index[pid][agent_order[pid][pid_info[pid].lower_order]]
      -> apply_arc_count + sizeof (INFO) * temp;
  }

  if ((PRINT || agent_index[pid][from_id] -> temp_rece > 2000) &&
      (message_ptr -> mail_no <= 4 || message_ptr -> mail_no == 23))
  {
    fprintf (stderr, "P%d RECE From P%d FA %d TA %d V %d O %d MNO %d LT1 %d LT2 %d NM %d P_S %d\n",
	pid, agent_index[pid][from_id] -> processor_id, from_id, to_id,
	message_ptr -> value, message_ptr -> order, message_ptr -> mail_no,
	message_ptr -> logical_time, logical_time[pid],
	NO_MORE[pid], PART_SOL[pid]);
    if (agent_index[pid][from_id] -> temp_rece > 2000)
    {
      PRINT = TRUE;
      agent_index[pid][from_id] -> temp_rece = 0;
    }
  }

  switch (message_ptr -> mail_no)
  {
    case 2: 			/* OK ? */
      pid_info[pid].relation_link[from_id] = TRUE;
      agent_ptr = agent_index[pid][from_id];
      two_values = FALSE;
      old_value = agent_ptr -> my_value;
      if (agent_ptr -> my_value != message_ptr -> value)
      {
	pid_info[pid].nothing_to_do = FALSE;
	pid_info[pid].got_message = TRUE;
	two_values = TRUE;
      }
      agent_ptr -> logical_time = message_ptr -> logical_time;
      agent_ptr -> logical_time2 = logical_time[pid];
      agent_ptr -> my_value = message_ptr -> value;
      temp_id = agent_order[pid][message_ptr -> order];
      temp_order = get_order[pid][from_id];
      if (temp_id != from_id && temp_order > message_ptr -> order)
      {
      /* changing order pair */
	get_order[pid][temp_id] = temp_order;
	agent_order[pid][temp_order] = temp_id;
	agent_index[pid][temp_id] -> order = temp_order;
      }
    /* set own order */
      agent_ptr -> order = message_ptr -> order;
      get_order[pid][from_id] = message_ptr -> order;
      agent_order[pid][message_ptr -> order] = from_id;

      if (two_values)
      {
	if (SF && FALSE)
	{
	  if (check_consistent (agent_ptr -> my_id,
		agent_ptr -> my_value, pid_info[pid].values))
	  {
	    printf ("P%d No Need to Send New Values\n");
	  }
	  PART_SOL[pid] = FALSE;
	  NO_MORE[pid] = FALSE;
	  THIS_ID = -1;
	  if (pid_info[pid].part_solution_ptr != NULL)
	  {
	    printf ("P%d Kill %d Solutions F_Id %d V1 %d V2 %d in LT %d\n",
		pid, pid_info[pid].sol_length, from_id,
		old_value, agent_ptr -> my_value, logical_time[pid]);
	  }
	  free_link (pid_info[pid].part_solution_ptr, 5);
	  pid_info[pid].part_solution_ptr = NULL;
	  pid_info[pid].solution_tail_ptr = NULL;
	  pid_info[pid].sol_length = 0;
	}
	if (SF)
	{
	  NO_MORE[pid] = FALSE;
	  THIS_ID = -1;
	  if (PART_SOL[pid])
	  {
	    if (pid_info[pid].part_solution_ptr == NULL ||
		!del_send_solution (agent_ptr -> my_id,
		  agent_ptr -> my_value))
	    {
	      PART_SOL[pid] = FALSE;
	    }
	  }
	}
	switch (FC)
	{
	  case 6: 		/* distributed fc-cbj-ng-pr */
	    tro_id = forward_check6 (from_id, agent_ptr -> my_value,
		tro_maker, dom_waiter, two_values);
	    if (tro_id != -1)
	    {
	      make_nogoods_message (tro_id, from_id, tro_maker, dom_waiter, 4);
	    }
	    break;
	  default: 
	    printf ("No FCs\n");
	    exit (0);
	}
	next_order = -1;	/* from beginning */
      }
      else
      {
	next_order = -2;
      }
      break;

    case 3: 			/* receive nogood */

      nogood_ptr = message_ptr -> view_ptr;

      incompatible = FALSE;

      if (SF)
      {
	NEED_BACK = FALSE;
	if (message_ptr -> logical_time >
	    agent_index[pid][to_id] -> logical_time)
	{
	  printf ("P%d To_Id %d T1 %d T2 %d\n", pid, to_id,
	      message_ptr -> logical_time,
	      agent_index[pid][to_id] -> logical_time);
	  fprintf (out_ptr, "P%d To_Id T1 %d T2 %d\n", pid, to_id,
	      message_ptr -> logical_time,
	      agent_index[pid][to_id] -> logical_time);
	  display (1);
	  exit (0);
	}
	return_flag = check_solution (nogood_ptr, to_id,
	    message_ptr -> value, message_ptr -> logical_time, from_pid,
	    message_ptr -> set1, message_ptr -> set2, from_id);
	switch (return_flag)
	{
	  case -1: 
	    PART_SOL[pid] = FALSE;
	    break;
	  case -2: 
	    incompatible = TRUE;
	    break;
	  case -4: 
	    return - 4;
	  default: 
	    if (return_flag < 0)
	    {
	      return - 2;
	    }
	    else
	    {
	      return return_flag;
	    }
	}
      }

      high_order = get_order[pid][to_id];
      high_order1 = -1;

      if ((message_ptr -> value != -1 &&
	    message_ptr -> value != agent_index[pid][to_id] -> my_value) ||
	  !set_Mem (agent_index[pid][to_id] -> avail_domain,
	    agent_index[pid][to_id] -> my_value))
      {
	if (PRINT)
	{
	  printf ("P%d AG %d V1 %d V2 %d \n",
	      pid, to_id, agent_index[pid][to_id] -> my_value,
	      message_ptr -> value);
	}
	incompatible = TRUE;
      }

      temp1_ptr = nogood_ptr;
      while (temp1_ptr != NULL && !incompatible)
      {
	private_check++;
	if (private_check == 10000)
	{
	  printf ("P%d rests so long Mark %d\n", pid, 38);
	  private_check = 0;
	}
	if (temp1_ptr -> value > -1)
	{
	  this_id = temp1_ptr -> to_id;
	  if (agent_index[pid][to_id] -> relation[this_id] == -1 &&
	      agent_index[pid][this_id] -> my_value <= -1)
	  {
	    if (agent_index[pid][this_id] -> processor_id == pid)
	    {
	      incompatible = TRUE;
	    }
	    else
	    {
	      if (pid_info[pid].relation_link[this_id] == FALSE)
	      {
		pid_info[pid].relation_link[this_id] = TRUE;
		agent_index[pid][this_id] -> my_value = temp1_ptr -> value;
		agent_index[pid][this_id] -> order = temp1_ptr -> order;
		agent_index[pid][this_id] -> logical_time =
		  temp1_ptr -> logical_time;
		pid_info[pid].values[this_id] =
		  agent_index[pid][this_id] -> my_value;
		pid_info[pid].orders[this_id] =
		  agent_index[pid][this_id] -> order;
		pid_info[pid].places[this_id] = 43;
		send_mail (agent_index[pid][this_id] -> processor_id,
		    to_id, this_id, temp1_ptr -> value, temp1_ptr -> order,
		    4, NULL, empty, empty, 24);
	      }
	      else
	      {
		incompatible = TRUE;
	      }
	    }
	  }
	  else
	  {
	    if (agent_index[pid][this_id] -> my_value !=
		temp1_ptr -> value)
	    {
	      if (PRINT)
	      {
		printf ("P%d AG %d V1 %d O1 %d V2 %d O2 %d\n",
		    pid, this_id, agent_index[pid][this_id] -> my_value,
		    agent_index[pid][this_id] -> order,
		    temp1_ptr -> value, temp1_ptr -> order);
	      }
	      incompatible = TRUE;
	    }
	  }
	}

	if (get_order[pid][temp1_ptr -> to_id] > high_order1)
	{
	  high_order1 = get_order[pid][temp1_ptr -> to_id];
	}

	temp1_ptr = temp1_ptr -> next;
      }				/* end of while nogood_ptr */

      no_value = FALSE;
      if (incompatible)
      {
      /* There is no need to send value which is not the same as this one.
         Think later */
	if (!SF)
	{
	  if (agent_index[pid][to_id] -> my_value > -1 &&
	      set_Mem (agent_index[pid][to_id] -> avail_domain,
		agent_index[pid][to_id] -> my_value))
	  {
	  /* send ok ? ( my_id, my_value ) to sender_id  */
	    pid_info[pid].values[to_id] = agent_index[pid][to_id] -> my_value;
	    pid_info[pid].orders[to_id] = agent_index[pid][to_id] -> order;
	    pid_info[pid].places[to_id] = 12;
	    send_mail (agent_index[pid][from_id] -> processor_id,
		to_id, -1 /* from_id */ , agent_index[pid][to_id] -> my_value,
		agent_index[pid][to_id] -> order,
		2, NULL, empty, empty, 23);
	  }
	  else
	  {
	    no_value = TRUE;
	    agent_index[pid][to_id] -> my_value = -1;
	    agent_index[pid][to_id] -> to_be_sent = FALSE;
	    if (PRINT && pid == 0)
	    {
	      printf ("P%d Nogood Here\n", pid);
	    }
	  }
	}
	else
	{
	  if (PART_SOL[pid])
	  {
	    if (pid_info[pid].values[to_id] > -1 &&
		agent_index[pid][to_id] -> out_link[from_pid])
	    {
	      send_mail (agent_index[pid][from_id] -> processor_id,
		  to_id, -1, pid_info[pid].values[to_id],
		  pid_info[pid].orders[to_id],
		  2, NULL, empty, empty, 22);
	    }
	  }
	  else
	  {
	    pid_info[pid].values[to_id] = -1;
	    if (agent_index[pid][to_id] -> my_value > -1 &&
		set_Mem (agent_index[pid][to_id] -> avail_domain,
		  agent_index[pid][to_id] -> my_value))
	    {
	      if (pid_info[pid].values[to_id] !=
		  agent_index[pid][to_id] -> my_value)
	      {
		agent_index[pid][to_id] -> to_be_sent = TRUE;
	      }
	      if (agent_index[pid][to_id] -> to_be_sent)
	      {
		send_ok (agent_index[pid][to_id] -> order, 3);
	      }
	      else
	      {
		send_ok (agent_index[pid][to_id] -> order, 6);
		pid_info[pid].values[to_id] =
		  agent_index[pid][to_id] -> my_value;
		pid_info[pid].orders[to_id] =
		  agent_index[pid][to_id] -> order;
		pid_info[pid].places[to_id] = 10;
		send_mail (agent_index[pid][from_id] -> processor_id,
		    to_id, -1, agent_index[pid][to_id] -> my_value,
		    agent_index[pid][to_id] -> order,
		    2, NULL, empty, empty, 21);
	      }
	    }
	    else
	    {
	      pid_info[pid].values[to_id] = -1;

	    }
	  }
	}
	next_order = -2;	/* do nothing */
      }
      else
      {
	if (SF && PART_SOL[pid])
	{
	  printf ("P%d Part_Sol should not TRUE here\n", pid);
	  display (1);
	  exit (0);
	}
	if (high_order1 >= high_order)
	{
	/* send my value out */
	  if (!SF)
	  {
	    if (message_ptr -> value > -1)
	    {
	      pid_info[pid].values[to_id] = agent_index[pid][to_id] -> my_value;
	      pid_info[pid].orders[to_id] = agent_index[pid][to_id] -> order;
	      pid_info[pid].places[to_id] = 9;
	      send_mail (agent_index[pid][from_id] -> processor_id,
		  to_id, -1 /* from_id */ , agent_index[pid][to_id] -> my_value,
		  agent_index[pid][to_id] -> order,
		  2, NULL, empty, empty, 20);
	    }
	  }
	  else
	  {
	    if (pid_info[pid].values[to_id] !=
		agent_index[pid][to_id] -> my_value)
	    {
	      agent_index[pid][to_id] -> to_be_sent = TRUE;
	    }
	    if (agent_index[pid][to_id] -> to_be_sent)
	    {
	      send_ok (agent_index[pid][to_id] -> order, 2);
	    }
	    else
	    {
	      pid_info[pid].values[to_id] = agent_index[pid][to_id] -> my_value;
	      pid_info[pid].orders[to_id] = agent_index[pid][to_id] -> order;
	      pid_info[pid].places[to_id] = 8;
	      send_mail (agent_index[pid][from_id] -> processor_id,
		  to_id, -1 /* from_id */ , agent_index[pid][to_id] -> my_value,
		  agent_index[pid][to_id] -> order,
		  2, NULL, empty, empty, 19);
	    }
	  }
	/* set the nogood caused by backtracking */
	  set_Add (message_ptr -> set1, to_id);
	  make_nogood (agent_index[pid][agent_order[pid][high_order1]],
	      message_ptr -> set1, message_ptr -> set2, from_id);
	  next_order = high_order1;
	}
	else
	{
	/* set the nogood caused by backtracking */
	  make_nogood (agent_index[pid][to_id],
	      message_ptr -> set1, message_ptr -> set2, from_id);
	  next_order = high_order;
	}
      }
      if (!SF)
      {
	if (next_order != -2)	
	{
	  pid_info[pid].nothing_to_do = FALSE;
	  pid_info[pid].got_message = TRUE;
	}
      }
      else
      {
	pid_info[pid].got_message = TRUE;
	if (!incompatible)
	{
	  pid_info[pid].nothing_to_do = FALSE;
	  pid_info[pid].got_message = TRUE;
	  if (NO_MORE[pid] || PART_SOL[pid])
	  {
	    printf ("P%d Why NO_MORE %d PART_SOL %d\n",
		NO_MORE[pid], PART_SOL[pid]);
	    exit (0);
	  }
	}
      }
      break;
    case 4: 			/* a link */
      agent_ptr = agent_index[pid][to_id];
      agent_ptr -> out_link[agent_index[pid][from_id] -> processor_id]
	= TRUE;
    /* send ok ? ( my_id, my_value ) to sender_id  */
      if (!SF)
      {
	if (agent_index[pid][to_id] -> my_value > -1)
	{
	  pid_info[pid].values[to_id] = agent_index[pid][to_id] -> my_value;
	  pid_info[pid].orders[to_id] = agent_index[pid][to_id] -> order;
	  pid_info[pid].places[to_id] = 7;
	  send_mail (agent_index[pid][from_id] -> processor_id,
	      to_id, -1 /* from_id */ , agent_index[pid][to_id] -> my_value,
	      agent_index[pid][to_id] -> order,
	      2, NULL, empty, empty, 18);
	}
      }
      else
      {
	if (PART_SOL[pid])
	{
	  if (pid_info[pid].values[to_id] > -1 &&
	      message_ptr -> logical_time <
	      agent_index[pid][to_id] -> logical_time)
	  {
	    send_mail (agent_index[pid][from_id] -> processor_id,
		to_id, -1, pid_info[pid].values[to_id],
		pid_info[pid].orders[to_id],
		2, NULL, empty, empty, 17);
	  }
	}
	else
	{
	  if (agent_index[pid][to_id] -> my_value > -1)
	  {
	    if (pid_info[pid].values[to_id] !=
		agent_index[pid][to_id] -> my_value)
	    {
	      agent_index[pid][to_id] -> to_be_sent = TRUE;
	    }
	    if (agent_index[pid][to_id] -> to_be_sent)
	    {
	      send_ok (agent_index[pid][to_id] -> order, 1);
	    }
	    else
	    {
	      pid_info[pid].values[to_id] = agent_index[pid][to_id] -> my_value;
	      pid_info[pid].orders[to_id] = agent_index[pid][to_id] -> order;
	      pid_info[pid].places[to_id] = 5;
	      send_mail (agent_index[pid][from_id] -> processor_id,
		  to_id, -1 /* from_id */ , agent_index[pid][to_id] -> my_value,
		  agent_index[pid][to_id] -> order,
		  2, NULL, empty, empty, 16);
	    }
	  }
	}
      }
      next_order = -2;
      break;
    case 20: 			/* test terminate */
      if (pid_info[pid].nothing_to_do &&
	  (!SF || SF && (PART_SOL[pid] && pid != np - 1 || pid == np - 1)))
      {
	if (pid != np - 1)
	{
	  send_mail (pid + 1, agent_order[pid][pid_info[pid].high_order],
	      -1, message_ptr -> value, -1, 20, NULL, empty, empty, 15);
	  DID_SOMETHING[pid] = FALSE;
	}
	else
	{
	  if (message_ptr -> value == pid_info[pid].terminated)
	  {
	    send_mail (0, agent_order[pid][pid_info[pid].high_order],
		-1, message_ptr -> value, -1, 21, NULL, empty, empty, 14);
	  }
	}
      }
      else
      {
	if (pid != np - 1)
	{
	  send_mail (np - 1, agent_order[pid][pid_info[pid].high_order],
	      -1, message_ptr -> value, -1, 24, NULL, empty, empty, 13);
	}
	else
	{
	  TESTING = FALSE;
	}
      }
      next_order = -2;
      break;
    case 21: 			/* test terminate */
      next_order = -2;
      if (pid_info[pid].nothing_to_do && !DID_SOMETHING[pid] &&
	  (!SF || SF && (PART_SOL[pid] && pid != np - 1 || pid == np - 1)))
      {
	if (pid != np - 1)
	{
	  send_mail (pid + 1, agent_order[pid][pid_info[pid].high_order],
	      -1, message_ptr -> value, -1, 21, NULL, empty, empty, 12);
	}
	else
	{
	  if (!MULTI)
	  {
	    if (message_ptr -> value == pid_info[pid].terminated)
	    {
	      send_mail (0, agent_order[pid][pid_info[pid].high_order],
		  -1, -1, -1, 22, NULL, empty, empty, 11);
	    }
	  }
	  else
	  {
	    next_order = -3;
	  }
	}
      }
      else
      {
	if (pid != np - 1)
	{
	  send_mail (np - 1, agent_order[pid][pid_info[pid].high_order],
	      -1, message_ptr -> value, -1, 24, NULL, empty, empty, 10);
	}
	else
	{
	  TESTING = FALSE;
	}
      }
      break;
    case 22: 			/* test terminate */
      if (pid != np - 1)
      {
	if (DID_SOMETHING[pid] || (SF && !PART_SOL[pid]))
	{
	  printf ("P%d Can Not Stop\n");
	  display (1);
	  exit (0);
	}
	send_mail (pid + 1, agent_order[pid][pid_info[pid].high_order],
	    -1, -1, -1, 22, NULL, empty, empty, 9);
      }
      else
      {
	TESTING = FALSE;
      }
      next_order = -3;
      break;
    case 23: 			/* terminate */
      next_order = -4;
      break;
    case 24: 			/* not finish */
      TESTING = FALSE;
      next_order = -2;
      break;
    case 25: 			/* not finish */
      NO_MORE[pid] = FALSE;
      next_order = -2;
      break;
    default: 
      printf ("No Such Choice1 %d\n", message_ptr -> mail_no);
      fprintf (stderr, "P%d RECE From P%d FA %d TA %d V %d O %d MNO %d LT %d\n",
	  pid, agent_index[pid][from_id] -> processor_id, from_id, to_id,
	  message_ptr -> value, message_ptr -> order, message_ptr -> mail_no,
	  message_ptr -> logical_time);
      exit (0);
  }

  return next_order;
}				/* end of rece_message */

/* make nogood messages */

make_nogoods_message (from_id, agent_id, tro_maker, dom_waiter, count)
int   from_id;
int   agent_id;
SET tro_maker;
SET dom_waiter;
int   count;
{
  struct info *nogood_ptr;
  struct info *temp1_ptr;
  int   this_id;
  int   i;

  if (PART_SOL[pid])
  {
    printf ("P%d Should Not Do Backtracking at Point %d\n", pid, count);
    display (1);
    exit (0);
  }

 /* undo reductions */

  for (i = pid_info[pid].lower_order; i <= pid_info[pid].high_order; i++)
  {
    this_id = agent_order[pid][i];

  /* undo reductions of my_id */
    if (agent_index[pid][this_id] ->
	position_ptr[agent_id] != NULL)
    {
      undo_reduction_ret_still (this_id, agent_id, FALSE);
    }

  /* del nogoods which was related to it */
    if (agent_index[pid][this_id] -> in_link[agent_id] != FALSE)
    {
      del_ng_sel_return (agent_index[pid][this_id], agent_id, TRUE, 3);
    }

  }

  if (FALSE && agent_index[pid][agent_id] -> my_value <= -1)
  {
    printf ("P%d Not Send Nogood %d from %d\n", pid, agent_id, from_id);
    display (1);
    exit (0);
  }

  nogood_ptr = NULL;
  set_Del (tro_maker, agent_id);
  if (set_Ele (tro_maker))
  {
    for (i = 0; i < agent_count; i++)
    {
      if (set_Mem (tro_maker, i))
      {
	apply_info (&temp1_ptr, 4);
	temp1_ptr -> id = agent_id;
	temp1_ptr -> to_id = i;
	temp1_ptr -> value = agent_index[pid][i] -> my_value;
	temp1_ptr -> order = agent_index[pid][i] -> order;
	temp1_ptr -> logical_time = agent_index[pid][i] -> logical_time;
	temp1_ptr -> next = nogood_ptr;
	nogood_ptr = temp1_ptr;
      }
    }
  }

  send_mail (agent_index[pid][agent_id] -> processor_id,
      from_id, agent_id, agent_index[pid][agent_id] -> my_value,
      agent_index[pid][agent_id] -> order,
      3, nogood_ptr, tro_maker, dom_waiter, 8);

  agent_index[pid][agent_id] -> my_value = -1;
  agent_index[pid][agent_id] -> to_be_sent = FALSE;

}				/* end of make_nogoods_message */

/* allocate orders to variables */

allocat_order (processor_count, agent_count)
int   processor_count,
      agent_count;
{
  int   i,
        j;
  int   equal;
  int   count;
  int   left_order;
  int   left_processor;
  int   step;
  int   dom_rel[MAX_PROCESSOR][3];
  float   real_dom_rel[MAX_PROCESSOR][2];
  float   min_dom,
          max_rel,
          max_dom,
          min_rel;
  int   sequence[MAX_PROCESSOR];
  int   index;
  int   k;
  int   check_relation[MAX_PROCESSOR];
  int   highest;


  count = agent_count;
  equal = count % processor_count;
  while (equal != 0)
  {
    count++;
    equal = count % processor_count;
  }
  equal = count / processor_count;

  if (((equal * processor_count) - agent_count) >= equal)
  {
    equal--;
  }
  count = 0;
  left_order = agent_count;
  left_processor = processor_count;

  for (i = 0; i < processor_count && count < MAX_AGENT; i++)
  {
    pid_info[i].lower_order = count;/* lower_order */
    if (left_order == 0)
    {
      break;
    }
    if (left_order > left_processor)
    {
      step = equal;
      if (i == 0 && processor_count * equal < agent_count)
      {
	step = agent_count - processor_count * equal + equal;
      }
      for (j = 0; j < step && count < agent_count; j++)
      {
	if (agent_index[pid][agent_order[pid][count]] != NULL)
	{
	  agent_index[pid][agent_order[pid][count]] -> processor_id = i;
	  left_order--;
	}
	count++;
      }
    }
    else
    {
      if (agent_index[pid][agent_order[pid][count]] != NULL)
      {
	agent_index[pid][agent_order[pid][count]] -> processor_id = i;
	left_order--;
      }
      count++;
    }
    pid_info[i].high_order = count - 1;/* high_order */
    left_processor--;
  }

  if (ST_ORDER == 0)
  {
    return;
  }

 /* print the sums of domains and relations on each processor */

 /* sort domains and relations */

  if (ST_ORDER == 1 || ST_ORDER == 2 || ST_ORDER == 4 || ST_ORDER == 5)
  {
    for (i = 0; i < np; i++)
    {
      dom_rel[i][0] = 0;
      dom_rel[i][1] = 0;
      dom_rel[i][2] = 0;
    }
    for (i = 0; i < agent_count; i++)
    {
      dom_rel[agent_index[0][i] -> processor_id][0] =
	dom_rel[agent_index[0][i] -> processor_id][0] +
	agent_index[0][i] -> avail_length;
      dom_rel[agent_index[0][i] -> processor_id][1] =
	dom_rel[agent_index[0][i] -> processor_id][1] +
	agent_index[0][i] -> rel_length;
      dom_rel[agent_index[0][i] -> processor_id][2]++;
    }
    for (i = 0; i < np; i++)
    {
      real_dom_rel[i][0] = 1.0 * dom_rel[i][0] / dom_rel[i][2];
      real_dom_rel[i][1] = 1.0 * dom_rel[i][1] / dom_rel[i][2];
    }

    for (i = 0; i < np; i++)
    {
      sequence[i] = -1;
    }

    for (i = 0; i < np; i++)
    {
      min_dom = 999.0;
      max_rel = -1.0;
      max_dom = -1.0;
      min_rel = 999.0;
      for (j = 0; j < np; j++)
      {
	switch (ST_ORDER)
	{
	  case 1: 
	    if (sequence[j] < 0 && (real_dom_rel[j][0] < min_dom ||
		  real_dom_rel[j][0] == min_dom &&
		  real_dom_rel[j][1] > max_rel))
	    {
	      index = j;
	      min_dom = real_dom_rel[j][0];
	      max_rel = real_dom_rel[j][1];
	    }
	    break;
	  case 2: 
	    if (sequence[j] < 0 && (real_dom_rel[j][1] > max_rel ||
		  real_dom_rel[j][1] == max_rel &&
		  real_dom_rel[j][0] < min_dom))
	    {
	      index = j;
	      min_dom = real_dom_rel[j][0];
	      max_rel = real_dom_rel[j][1];
	    }
	    break;
	  case 4: 
	    if (sequence[j] < 0 && (real_dom_rel[j][0] > max_dom ||
		  real_dom_rel[j][0] == max_dom &&
		  real_dom_rel[j][1] < min_rel))
	    {
	      index = j;
	      max_dom = real_dom_rel[j][0];
	      min_rel = real_dom_rel[j][1];
	    }
	    break;
	  case 5: 
	    if (sequence[j] < 0 && (real_dom_rel[j][1] < min_rel ||
		  real_dom_rel[j][1] == min_rel &&
		  real_dom_rel[j][0] > max_dom))
	    {
	      index = j;
	      max_dom = real_dom_rel[j][0];
	      min_rel = real_dom_rel[j][1];
	    }
	    break;
	  default: 
	    printf ("Wrong ST_ORDER %d \n", ST_ORDER);
	    exit (0);
	}
      }
      sequence[index] = i;
    }
  }



 /* relation before count */
  if (ST_ORDER == 3)
  {
    for (i = 0; i < np; i++)
    {
      check_relation[i] = 0;
      sequence[i] = -1;
    }
    for (i = 0; i < agent_count; i++)
    {
      for (j = 0; j < agent_count; j++)
      {
	if (agent_index[pid][i] -> relation[j] == 3)
	{
	  check_relation[agent_index[pid][i] -> processor_id]++;
	  check_relation[agent_index[pid][j] -> processor_id]--;
	}
      }
    }

    for (i = 0; i < np; i++)
    {
      highest = -999;
      for (j = 0; j < np; j++)
      {
	if (sequence[j] < 0 && check_relation[j] > highest)
	{
	  index = j;
	  highest = check_relation[j];
	}
      }
      sequence[index] = i;
    }
  }

  for (i = 0; i < np; i++)
  {
    printf ("Proc %d Order %d\n", i, sequence[i]);
  }

 /* exchange orders */

  count = 0;
  for (i = 0; i < np; i++)
  {
    for (j = 0; j < np; j++)
    {
      if (sequence[j] == i)
      {
	break;
      }
    }
  /* agent order */
    pid_info[i].lower_order = count;/* lower_order */
    for (k = 0; k < agent_count; k++)
    {
      if (agent_index[pid][k] -> processor_id == j)
      {

	agent_index[pid][k] -> order = count;
	agent_order[pid][count] = k;
	get_order[pid][k] = count;
	count++;
      }
    }
    pid_info[i].high_order = count - 1;/* high_order */
  }
  for (i = 0; i < agent_count; i++)
  {
    agent_index[pid][i] -> processor_id =
      sequence[agent_index[pid][i] -> processor_id];
  }


}				/* end of allocat_order */


/* select next variable to label */

int   sel_next_id (my_id)
{
        SET tro_maker,
        dom_waiter;
  struct agent_home *agent_ptr;
  int   i,
        j;
  int   this_id;
  int   agent_id;
  int   next_id;

  agent_ptr = agent_index[pid][my_id];

  if (current_back_order[pid] > agent_ptr -> order ||
      current_order[pid] > agent_ptr -> order)
  {
    if (current_order[pid] > current_back_order[pid])
    {
      current_back_order[pid] = current_order[pid];
    }
  /*  is nothing changes, go further */
    for (i = agent_ptr -> order + 1; i <= current_back_order[pid];
	i++)
    {
      agent_id = agent_order[pid][i];
      if (!set_Mem (agent_index[pid][agent_id] -> avail_domain,
	    agent_index[pid][agent_id] -> my_value))
      {
	break;
      }
      else
      {
	if (FC != 7)
	{
	  if (FC == 6)		/* distributed fc-cbj-ng-pr */
	  {
	    if (forward_check6 (agent_id,
		  agent_index[pid][agent_id] -> my_value,
		  tro_maker, dom_waiter, FALSE) != -1)
	    {
	      make_nogood (agent_index[pid][agent_id], tro_maker,
		  dom_waiter, agent_id);
	      break;
	    }
	  }
	  if (FC == 4)		/* fc-cbj-ng */
	  {
	    if (forward_check4 (agent_id,
		  agent_index[pid][agent_id] -> my_value,
		  tro_maker, dom_waiter, FALSE) != -1)
	    {
	      make_nogood (agent_index[pid][agent_id], tro_maker,
		  dom_waiter, agent_id);
	      break;
	    }
	  }
	  if (SF)
	  {

	    if (pid_info[pid].values[agent_id] !=
		agent_index[pid][agent_id] -> my_value)
	    {
	      agent_index[pid][agent_id] -> to_be_sent = TRUE;
	    }
	    if (!PART_SOL[pid] && agent_index[pid][agent_id] -> to_be_sent)
	    {
	      send_ok (agent_index[pid][agent_id] -> order, 5);
	    }
	  }
	}
	else
	{
	  FORD_CHECK = TRUE;
	  m_fork (multi_check_release, agent_id,
	      agent_index[pid][agent_id] -> my_value,
	      agent_index[pid][agent_id] -> order + 1,
	      agent_count, FALSE, TRUE);
	  if (!FORD_CHECK)
	  {
	    break;
	  }

	}
      }
    }
    if (FC != 7)
    {
      if (i == pid_info[pid].high_order + 1)
      {
	if (pid == np - 1)
	{
	  next_id = agent_count;
	}
	else
	{
	  next_id = agent_count + 1;
	}
      }
      else
      {
	next_id = agent_id;
      }
    }
    else
    {
      if (i == pid_info[pid].high_order + 1)
      {
	next_id = agent_count;
      }
      else
      {
	next_id = agent_id;
      }
    }
    if (next_id <= pid_info[pid].high_order &&
	current_back_order[pid] > get_order[pid][next_id])
    {
    /* release all reductions and nogoods above get_order[pid][agent_id] 
    */
      if (FC != 7 || FALSE)
      {
	for (i = pid_info[pid].high_order;
	    i >= get_order[pid][next_id]; i--)
	{
	  this_id = agent_order[pid][i];
	  for (j = pid_info[pid].lower_order; j <= pid_info[pid].high_order &&
	      agent_index[pid][this_id] -> my_value != -2; j++)
	  {
	    agent_id = agent_order[pid][j];

	  /* undo reductions */

	    if (agent_index[pid][agent_id] ->
		position_ptr[this_id] != NULL)
	    {
	      undo_reduction_ret_still (agent_id, this_id, TRUE);
	    }

	    if (agent_index[pid][agent_id] ->
		in_link[this_id] != FALSE)
	    {
	      del_ng_sel_return (agent_index[pid][agent_id], this_id, FALSE, 2);
	    }

	  }
	  agent_index[pid][this_id] -> my_value = -2;
	  agent_index[pid][this_id] -> to_be_sent = FALSE;
	}
      }
      else
      {
	FORD_CHECK = TRUE;
	m_fork (multi_check_release, -1, -1,
	    get_order[pid][next_id], agent_count,
	    -1, FALSE);
	for (i = current_back_order[pid]; i >= get_order[pid][next_id]; i--)
	{
	  agent_id = agent_order[pid][i];
	  agent_index[pid][agent_id] -> my_value = -1;
	  agent_index[pid][agent_id] -> to_be_sent = FALSE;
	}

      }
      dynamic_order_down (current_back_order[pid],
	  get_order[pid][next_id]);
    }
    current_back_order[pid] = -1;
  }
  else
  {
    if (current_back_order[pid] > 0 &&
	current_back_order[pid] != agent_ptr -> order)
    {
      printf ("P%d CO %d M_A %d M_O %d T_A %d T_O %d\n",
	  pid, current_back_order[pid], my_id, agent_ptr -> order,
	  next_id, get_order[pid][next_id]);
      fprintf (out_ptr, "P%d CO %d M_A %d M_O %d T_A %d T_O %d\n",
	  pid, current_back_order[pid], my_id, agent_ptr -> order,
	  next_id, get_order[pid][next_id]);
      display (1);
      exit (0);
    }
    else
    {
      current_back_order[pid] = -1;
      if (current_order[pid] != agent_ptr -> order)
      {
	printf ("P%d Two Order c_o %d my_order %d\n", pid,
	    current_order[pid], agent_ptr -> order);
	fprintf (out_ptr, "P%d Two Order c_o %d my_order %d\n", pid,
	    current_order[pid], agent_ptr -> order);
	display (1);
	exit (0);
      }
      dynamic_order_up ();
      next_id = agent_order[pid][agent_ptr -> order + 1];
    }
  }

  return next_id;

}				/* end of sel_next_id */

/* release variables */

release_variables (from_order, to_order, agent_id)
int   from_order;
int   to_order;
int   agent_id;
{
  int   i;
  int   this_id;


  if (get_order[pid][agent_id] <= from_order)
  {
    from_order = get_order[pid][agent_id] - 1;
    if (from_order == current_back_order[pid])
    {
      printf ("STRANGE\n");
      exit (0);
    }
  }

  for (i = from_order; i >= to_order; i--)
  {
    this_id = agent_order[pid][i];
    if (this_id == agent_id)
    {
      printf ("Strange This_Id %d Agent_Id %d\n", this_id, agent_id);
      display (1);
      exit (0);
    }
  /* undo reductions */

    if (PRINT)
    {
      fprintf (out_ptr, "TI %d TO %d ", this_id, i);
    }

    if (agent_index[pid][agent_id] ->
	position_ptr[this_id] != NULL)
    {
      undo_reduction_ret_still (agent_id, this_id, TRUE);
    }

    if (agent_index[pid][agent_id] ->
	in_link[this_id] != FALSE)
    {
      del_ng_sel_return (agent_index[pid][agent_id], this_id, FALSE, 33);
    }

  }
  if (PRINT)
  {
    fprintf (out_ptr, "\n");
  }

}				/* release_variables */

/* check solution */

int   check_solution (nogood_ptr, to_id, value, l_time, from_pid,
        tro_maker, dom_waiter, from_id)
struct info *nogood_ptr;
int   to_id;
int   value;
int   l_time;
SET tro_maker;
SET dom_waiter;
int   from_id;
{
  struct info *temp1_ptr;
  struct info *temp2_ptr;
  struct info *temp3_ptr;
  int   high_order;
  int   last_id;
  int   i;
  int   agent_id;
  int   nogoods[MAX_AGENT];
  int   consistent;
  int   j;
  int   h_order = -1;
  int   h_id = -1;
  int   affected_id = -1;

  for (i = 0; i < agent_count; i++)
  {
    nogoods[i] = -1;
  }
  nogoods[to_id] = value;

  h_order = get_order[pid][to_id];
  h_id = to_id;
  temp1_ptr = nogood_ptr;
  while (temp1_ptr != NULL)
  {
    nogoods[temp1_ptr -> to_id] = temp1_ptr -> value;
    if (get_order[pid][temp1_ptr -> to_id] > h_order)
    {
      h_order = get_order[pid][temp1_ptr -> to_id];
      h_id = temp1_ptr -> to_id;
    }
    temp1_ptr = temp1_ptr -> next;
  }				/* end of while nogood_ptr */

  last_id = check_time (nogood_ptr, to_id, l_time, from_pid, value);

  if (last_id < 0)
  {
    if (PRINT)
    {
      printf ("P%d Check_Solution Found Inconsistent Nogood\n", pid);
    }
    return - 2;			/* incompatible */
  }
  else
  {
  /* make nogood 2 */
    if (agent_index[pid][h_id] -> my_value != nogoods[h_id])
    {
    /* nogood value is nogoods[h_id] */
      if (h_id != to_id)
      {
	set_Add (tro_maker, to_id);
      }
      affected_id = make_nogood2 (agent_index[pid][h_id], tro_maker, dom_waiter,
	  from_id, nogoods[h_id], nogoods);
      if (affected_id != -1)
      {
	printf ("P%d Affected_Id %d Wrong\n", pid, affected_id);
	display (1);
	exit (0);
      }
    }
    high_order = get_order[pid][last_id];
    if (to_id != last_id)
    {
      if (value > -1 && get_order[pid][to_id] >= get_order[pid][last_id])
      {
	printf ("P%d To_Id %d Order %d Last_Id %d Order %d LT %d\n",
	    pid, to_id, get_order[pid][to_id], last_id, get_order[pid][last_id],
	    logical_time[pid]);
	printf ("P%d  LT %d Nogood :", pid, logical_time[pid]);
	for (i = 0; i < agent_count; i++)
	{
	  printf (" Id%dV%d ", i, nogoods[i]);
	}
	display (1);
	exit (0);
      }
      pid_info[pid].values[last_id] = -1;
      pid_info[pid].places[last_id] = 3;
    }
  }
  pid_info[pid].values[to_id] = -1;
  pid_info[pid].places[to_id] = 4;

 /* if the part_solution == NULL, nothing to do here */

  if (pid_info[pid].part_solution_ptr == NULL)
  {
    if (pid_info[pid].solution_tail_ptr != NULL)
    {
      printf ("P%d Tail_Ptr != NULL\n", pid);
      exit (0);
    }
    if (pid_info[pid].sol_length != 0)
    {
      printf ("P%d Sol_Length != 0\n", pid);
      exit (0);
    }
    if (PRINT)
    {
      printf ("P%d Check_Solution NULL LT %d\n", pid, logical_time[pid]);
    }
  /* PART_SOL[pid] = FALSE; */
    if (NO_MORE[pid])
    {
      if (pid == 0)
      {
	printf ("P%d is going to stop\n", pid);
	for (i = 0; i < np; i++)
	{
	  if (i != pid)
	  {
	    send_mail (i, to_id, -1, -1, -1, 23, NULL, empty, empty, 7);
	  }
	}
	return - 4;		/* stop */
      /* next_order = -4; */
      }
      if (THIS_ID > -1)
      {
	if (PRINT)
	{
	  printf ("P%d Check_Solution Backtrack LT %d\n", pid,
	      logical_time[pid]);
	}
	PART_SOL[pid] = FALSE;
	make_nogoods_message (FROM_ID, THIS_ID, TRO_MAKER, DOM_WAITER, 2);
	THIS_ID = -1;
	NO_MORE[pid] = FALSE;
	return - 3;		/* backtrack */
      }
      else
      {
	printf ("P%d Why No_More and This_Id == -1?\n", pid);
	display (1);
	exit (0);
      }
    }
    if (PRINT)
    {
      printf ("P%d Check_Solution Goes to Normal Backtrack LT %d\n",
	  pid, logical_time[pid]);
    }
    return - 1;			/* go to normal backtrack */
  }

 /* check consistent with lower_processor values */

  if (FALSE && check_lower_nogood (nogood_ptr, to_id))
  {
    if (PRINT)
    {
      printf ("P%d Check_Solution Inconsistent within Lower Nogoods\n", pid);
    }
    return - 6;			/* do nothing */
  }


  if (PRINT)
  {
    printf ("P%d  LT %d Nogood :", pid, logical_time[pid]);
    for (i = 0; i < agent_count; i++)
    {
      printf (" Id%dV%d ", i, nogoods[i]);
    }
    printf ("\n");
  }

  if (PRINT)
  {
    print_solution (stdout);
  }
  consistent = TRUE;
  temp2_ptr = NULL;
  while (pid_info[pid].part_solution_ptr != NULL && consistent)
  {
    temp1_ptr = pid_info[pid].part_solution_ptr;
    pid_info[pid].part_solution_ptr = temp1_ptr -> next;;
    for (i = high_order; i >= pid_info[pid].lower_order; i--)
    {
      agent_id = agent_order[pid][i];
      if (nogoods[agent_id] > -1 &&
	  nogoods[agent_id] != temp1_ptr -> part_solution[agent_id])
      {
	if (PRINT)
	{
	  printf ("P%d Id %d In Nogood %d In Part_Sol %d LT %d\n",
	      pid, agent_id, nogoods[agent_id],
	      temp1_ptr -> part_solution[agent_id], logical_time[pid]);
	}
	consistent = FALSE;
	break;
      }
    }
    if (!consistent)
    {
    /* this is a useful partial solution */
      agent_id = agent_order[pid][pid_info[pid].high_order];
      agent_index[pid][agent_id] -> block_send++;
    /* send out the result */
      for (i = pid_info[pid].lower_order; i <= pid_info[pid].high_order; i++)
      {
	agent_id = agent_order[pid][i];
	if (temp1_ptr -> part_solution[agent_id] !=
	    pid_info[pid].values[agent_id])
	{
	  if (temp1_ptr -> part_solution[agent_id] <= -1)
	  {
	    printf ("P%d Value = -1 in part_solution\n", pid);
	    exit (0);
	  }
	  agent_index[pid][agent_id] -> logical_time = logical_time[pid];
	  logical_time[pid]++;
	  pid_info[pid].values[agent_id] = temp1_ptr -> part_solution[agent_id];
	  pid_info[pid].orders[agent_id] = temp1_ptr -> part_order[agent_id];
	  pid_info[pid].places[agent_id] = 2;
	  for (j = 0; j < np; j++)
	  {
	    if (agent_index[pid][agent_id] -> out_link[j])
	    {
	      send_mail (j, agent_id, 1, temp1_ptr -> part_solution[agent_id],
		  temp1_ptr -> part_order[agent_id], 2, NULL, empty, empty, 6);
	    }
	  }
	}
      }
      if (h_id != to_id)
      {
	set_Add (tro_maker, to_id);
      }
      affected_id = make_nogood2 (agent_index[pid][h_id], tro_maker, dom_waiter,
	  from_id, nogoods[h_id], nogoods);
    }
    free_pointer ((struct info *) temp1_ptr, 5);
    pid_info[pid].sol_length--;
  }

  if (pid_info[pid].part_solution_ptr == NULL)
  {
    pid_info[pid].solution_tail_ptr = NULL;
  }
  if (consistent && pid_info[pid].part_solution_ptr != NULL)
  {
    printf ("P%d Part_Solution_Ptr != NULL\n", pid);
    display (1);
    exit (0);
  }

  if (PRINT)
  {
    print_solution (stdout);
  }


  if (consistent)
  {
  /* I cannot find the proper solution */
    if (PRINT)
    {
      printf ("P%d Check_Solution Run Out Solutions LT %d\n", pid,
	  logical_time[pid]);
    }
    if (NO_MORE[pid])
    {
      if (pid == 0)
      {
	printf ("P%d is going to stop\n", pid);
	for (i = 0; i < np; i++)
	{
	  if (i != pid)
	  {
	    send_mail (i, to_id, -1, -1, -1, 23, NULL, empty, empty, 5);
	  }
	}
	return - 4;		/* stop */
      /* next_order = -4; */
      }
      if (THIS_ID > -1)
      {
	if (PRINT)
	{
	  printf ("P%d Check_Solution Backtrack LT %d\n", pid,
	      logical_time[pid]);
	}
	PART_SOL[pid] = FALSE;
	make_nogoods_message (FROM_ID, THIS_ID, TRO_MAKER, DOM_WAITER, 2);
	THIS_ID = -1;
	NO_MORE[pid] = FALSE;
	return - 3;		/* backtrack */
      }
      else
      {
	printf ("P%d Why No_More and This_Id == -1?\n", pid);
	display (1);
	exit (0);
      }
    }
    if (PRINT)
    {
      printf ("P%d Check_Solution Goes to Normal Backtrack LT %d\n", pid,
	  logical_time[pid]);
    }
    return - 1;			/* go to normal backtrack */
  }
  else
  {
  /* Yes, I have got one */
    if (PRINT)
    {
      printf ("P%d Check_Solution Found One Solution LT %d\n",
	  pid, logical_time[pid]);
    }
    if (affected_id != -1)
    {
      return get_order[pid][affected_id];
    }
    else
    {
      return - 5;		/* did something */
    }
  }
}				/* end of check_solution */

/* print solution */

print_solution (out_ptr)
FILE * out_ptr;
{
  struct info *temp1_ptr;
  int   i;
  int   count = 0;
  int   order;
  int   j;

  fprintf (out_ptr, "P%d Part_Sol %d \n", pid, pid_info[pid].sol_length);
  temp1_ptr = pid_info[pid].part_solution_ptr;
  while (temp1_ptr != NULL)
  {
    count++;
    fprintf (out_ptr, "\nP%d Sol %d LT %d : ", pid, count,
	temp1_ptr -> logical_time);
    j = 0;
    for (i = 0; i < agent_count; i++)
    {
      order = get_order[pid][i];
      if (order < pid_info[pid].lower_order)
      {
	fprintf (out_ptr, " I%dV%d ", i, temp1_ptr -> part_solution[i]);
	j++;
	if ((j % 10) == 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
    }
    if (pid > 0)
    {
      fprintf (out_ptr, "\n MY ");
    }
    j = 0;
    for (i = 0; i < agent_count; i++)
    {
      order = get_order[pid][i];
      if (order >= pid_info[pid].lower_order &&
	  order <= pid_info[pid].high_order)
      {
	fprintf (out_ptr, " I%dV%d ", i, temp1_ptr -> part_solution[i]);
	j++;
	if ((j % 10) == 0)
	{
	  fprintf (out_ptr, "\n");
	}
      }
    }
    temp1_ptr = temp1_ptr -> next;
  }
  fprintf (out_ptr, "\n");

}				/* end of print_solution */

/* del send solution */

int   del_send_solution (id, value)
int   id;
int   value;
{
  struct info *temp1_ptr;
  int   consistent = FALSE;
  int   i,
        j;
  int   agent_id;

  while (pid_info[pid].part_solution_ptr != NULL && !consistent)
  {
    temp1_ptr = pid_info[pid].part_solution_ptr;
    pid_info[pid].part_solution_ptr = temp1_ptr -> next;
    if (temp1_ptr -> part_solution[id] == value)
    {
      printf ("P%d Go To Here ID %d VALUE %d\n", pid, id, value);
      fprintf (out_ptr, "P%d Go To Here ID %d VALUE %d\n", pid, id, value);
      if (TRUE)
      {
	temp1_ptr -> next = pid_info[pid].part_solution_ptr;
	pid_info[pid].part_solution_ptr = temp1_ptr;
	display (1);
	exit (0);
      }
      temp1_ptr -> part_solution[id] = value;
      consistent = check_consistent (id, value, temp1_ptr -> part_solution);
      if (consistent)
      {
      /* send out the result */
	for (i = pid_info[pid].lower_order; i <= pid_info[pid].high_order; i++)
	{
	  agent_id = agent_order[pid][i];
	  if (temp1_ptr -> part_solution[agent_id] !=
	      pid_info[pid].values[agent_id])
	  {
	    if (temp1_ptr -> part_solution[agent_id] <= -1)
	    {
	      printf ("P%d Value = -1 in part_solution\n", pid);
	      exit (0);
	    }
	    agent_index[pid][agent_id] -> logical_time = logical_time[pid];
	    logical_time[pid]++;
	    pid_info[pid].values[agent_id] = temp1_ptr -> part_solution[agent_id];
	    pid_info[pid].orders[agent_id] = temp1_ptr -> part_order[agent_id];
	    pid_info[pid].places[agent_id] = 30;
	    for (j = 0; j < np; j++)
	    {
	      if (agent_index[pid][agent_id] -> out_link[j])
	      {
		send_mail (j, agent_id, -1, temp1_ptr -> part_solution[agent_id],
		    temp1_ptr -> part_order[agent_id], 2, NULL, empty, empty, 4);
	      }
	    }
	  }
	}
      }
    }
    free_pointer ((struct info *) temp1_ptr, 5);
    pid_info[pid].sol_length--;
  }

  if (pid_info[pid].part_solution_ptr == NULL)
  {
    pid_info[pid].solution_tail_ptr = NULL;
  }

  return consistent;

}				/* end of del_send_solution */

/* add solution */

add_solution ()
{
  struct info *temp1_ptr;
  int   i;
  int   agent_id;

  for (i = pid_info[pid].lower_order;
      i <= pid_info[pid].high_order; i++)
  {
    agent_id = agent_order[pid][i];
    agent_index[pid][agent_id] -> to_be_sent = FALSE;
  }

  if (check_high_agents () > -1)
  {
    return;
  }

  pid_info[pid].sol_length++;

  agent_id = agent_order[pid][pid_info[pid].high_order];
  if (pid_info[pid].sol_length > agent_index[pid][agent_id] -> message_count)
  {
    agent_index[pid][agent_id] -> message_count = pid_info[pid].sol_length;
  }
  agent_index[pid][agent_id] -> block_rece++;

  apply_info (&temp1_ptr, 5);

  for (i = 0;
      i < pid_info[pid].lower_order && FALSE; i++)
  {
    agent_id = agent_order[pid][i];
    temp1_ptr -> part_solution[agent_id] =
      agent_index[pid][agent_id] -> my_value;
  }
  for (i = 0; i < agent_count; i++)
  {
    if (agent_index[pid][i] -> order < pid_info[pid].lower_order)
    {
      temp1_ptr -> part_solution[i] = agent_index[pid][i] -> my_value;
    }
  }

  temp1_ptr -> logical_time = logical_time[pid];

  for (i = pid_info[pid].lower_order;
      i <= pid_info[pid].high_order; i++)
  {
    agent_id = agent_order[pid][i];
    if (agent_index[pid][agent_id] -> my_value <= -1)
    {
      printf ("P%d Value == -1\n", pid);
      fprintf (out_ptr, "P%d Value == -1\n", pid);
      display (1);
      exit (0);
    }
    temp1_ptr -> part_solution[agent_id] =
      agent_index[pid][agent_id] -> my_value;
    temp1_ptr -> part_order[agent_id] =
      agent_index[pid][agent_id] -> order;
  }
  if (pid_info[pid].part_solution_ptr == NULL)
  {
    pid_info[pid].part_solution_ptr = temp1_ptr;
    pid_info[pid].solution_tail_ptr = temp1_ptr;
  }
  else
  {
    pid_info[pid].solution_tail_ptr -> next = temp1_ptr;
    pid_info[pid].solution_tail_ptr = temp1_ptr;
  }

  if (PRINT)
  {
    printf ("P%d Add_Sol: ", pid);
    for (i = 0; i < agent_count; i++)
    {
      if (agent_index[pid][i] -> order <= pid_info[pid].high_order)
      {
	printf (" Id%dV%dO%d ", i, temp1_ptr -> part_solution[i],
	    temp1_ptr -> part_order[i]);
      }
    }
    printf ("\n");
  }
}				/* end of add_solution */

/* check time */

int   check_time (nogood_ptr, to_id, l_time, from_pid, value)
struct info *nogood_ptr;
int   to_id;
int   l_time;
int   from_pid;
int   value;
{
  struct info *temp1_ptr;
  int   this_id;
  int   incompatible = FALSE;
  int   i;
  int   high_order1;
  int   high_order2;
  int   last_id = -1;

  if (agent_index[pid][to_id] -> out_link[from_pid])
  {
    high_order1 = get_order[pid][to_id];
  }
  else
  {
    high_order1 = -1;
  }
  if (value > -1 && agent_index[pid][to_id] -> logical_time > l_time &&
      agent_index[pid][to_id] -> out_link[from_pid])
  {
    incompatible = TRUE;
  }

  high_order2 = -1;
  temp1_ptr = nogood_ptr;
  while (temp1_ptr != NULL && !incompatible)
  {
    this_id = temp1_ptr -> to_id;
    if (agent_index[pid][this_id] -> processor_id == pid)
    {
      if (agent_index[pid][this_id] -> out_link[from_pid])
      {
	if (get_order[pid][this_id] > high_order2)
	{
	  high_order2 = get_order[pid][this_id];
	  last_id = this_id;
	}
      }
      if (temp1_ptr -> value > -1 &&
	  agent_index[pid][this_id] -> logical_time >
	  temp1_ptr -> logical_time &&
	  agent_index[pid][this_id] -> out_link[from_pid])
      {
	incompatible = TRUE;
      }
    }
    else
    {
      if (temp1_ptr -> value > -1 &&
	  pid_info[pid].relation_link[this_id] == FALSE)
      {
	pid_info[pid].relation_link[this_id] = TRUE;
	agent_index[pid][this_id] -> my_value = temp1_ptr -> value;
	agent_index[pid][this_id] -> order = temp1_ptr -> order;
	agent_index[pid][this_id] -> logical_time = temp1_ptr -> logical_time;
	pid_info[pid].values[this_id] = agent_index[pid][this_id] -> my_value;
	pid_info[pid].orders[this_id] = agent_index[pid][this_id] -> order;
	pid_info[pid].places[this_id] = 42;
	send_mail (agent_index[pid][this_id] -> processor_id,
	    to_id, this_id, temp1_ptr -> value,
	    temp1_ptr -> order, 4, NULL, empty, empty, 3);
      }
      if (temp1_ptr -> value > -1 &&
	  agent_index[pid][this_id] -> my_value != temp1_ptr -> value)
      {
	incompatible = TRUE;
      }
    }
    temp1_ptr = temp1_ptr -> next;
  }				/* end of while nogood_ptr */

  if (incompatible)
  {
    NEED_BACK = TRUE;
    return - 1;
  }
  else
  {
    NEED_BACK = FALSE;
    if (high_order2 == -1 && high_order1 == -1)
    {
      printf ("P%d What Happen\n", pid);
      display (1);
      exit (0);
    }
    if (high_order2 > high_order1)
    {
      if (last_id == -1)
      {
	printf ("P%d What Happen2\n", pid);
	display (1);
	exit (0);
      }
      return last_id;
    }
    else
    {
      return to_id;
    }
  }

}				/* the end of check_time */

/* check lower nogood */

int   check_lower_nogood (nogood_ptr, to_id)
struct info *nogood_ptr;
int   to_id;
{
  struct info *temp1_ptr;
  int   this_id;
  int   incompatible = FALSE;

  temp1_ptr = nogood_ptr;
  while (temp1_ptr != NULL && !incompatible)
  {
    this_id = temp1_ptr -> to_id;
    if (agent_index[pid][this_id] -> processor_id != pid)
    {
      if (pid_info[pid].relation_link[this_id] == FALSE)
      {
	pid_info[pid].relation_link[this_id] = TRUE;
	agent_index[pid][this_id] -> my_value = temp1_ptr -> value;
	agent_index[pid][this_id] -> order = temp1_ptr -> order;
	agent_index[pid][this_id] -> logical_time = temp1_ptr -> logical_time;
	pid_info[pid].values[this_id] = agent_index[pid][this_id] -> my_value;
	pid_info[pid].orders[this_id] = agent_index[pid][this_id] -> order;
	pid_info[pid].places[this_id] = 41;
      /* need to set the agent_order and get_order MORE */
	send_mail (agent_index[pid][this_id] -> processor_id,
	    to_id, this_id, temp1_ptr -> value, temp1_ptr -> order,
	    4, NULL, empty, empty, 2);
      }
      if (agent_index[pid][this_id] -> my_value !=
	  temp1_ptr -> value)
      {
	incompatible = TRUE;
      }
    }
    temp1_ptr = temp1_ptr -> next;
  }				/* end of while nogood_ptr */

  return incompatible;

}				/* the end of check_lower_nogood */

/* send message ok */

send_ok (higher_order, place)
int   higher_order;
int   place;
{
  int   i;
  int   j;
  int   agent_id;

  if (PART_SOL[pid])
  {
    printf ("P%d send_ok higher_order %d place %d\n",
	pid, higher_order, place);
    display (1);
    exit (0);
  }

  for (j = pid_info[pid].lower_order; j <= higher_order; j++)
  {
    agent_id = agent_order[pid][j];
    if (agent_index[pid][agent_id] -> to_be_sent ||
	agent_index[pid][agent_id] -> my_value != -1)
    {
      if (agent_index[pid][agent_id] -> my_value <= -1 ||
	    !set_Mem (agent_index[pid][agent_id] -> avail_domain,
	      agent_index[pid][agent_id] -> my_value))
      {
        printf ("P%d My_Value %d Is Bad\n", pid,
	      agent_index[pid][agent_id] -> my_value);
        display (1);
        exit (0);
      }
      agent_index[pid][agent_id] -> logical_time = logical_time[pid];
      logical_time[pid]++;
      pid_info[pid].values[agent_id] = agent_index[pid][agent_id] -> my_value;
      pid_info[pid].orders[agent_id] = agent_index[pid][agent_id] -> order;
      pid_info[pid].places[agent_id] = 15 + place;
      for (i = 0; i < np	/* && agent_index[pid][agent_id] ->
	        to_be_sent */ ; i++)
      {
        if (agent_index[pid][agent_id] -> out_link[i])
        {
          send_mail (i, agent_id, -1, agent_index[pid][agent_id] -> my_value,
		agent_index[pid][agent_id] -> order, 2, NULL, empty, empty, 1);
        }
      }
      agent_index[pid][agent_id] -> to_be_sent = FALSE;
    }
    else
    {
      if (agent_index[pid][agent_id] -> my_value > -1 &&
	  agent_index[pid][agent_id] -> my_value !=
	  pid_info[pid].values[agent_id])
      {
	printf ("P%d PL %d A %d val1 %d val2 %d LT %d NT %d from %d P %d\n",
	    pid, place, agent_id, agent_index[pid][agent_id] -> my_value,
	    pid_info[pid].values[agent_id],
	    agent_index[pid][agent_id] -> logical_time,
	    logical_time[pid], agent_order[pid][higher_order],
	    pid_info[pid].part_solution_ptr);
	fprintf (out_ptr, "P%d PL %d A %d val1 %d val2 %d LT %d NT %d from %d P %d\n",
	    pid, place, agent_id, agent_index[pid][agent_id] -> my_value,
	    pid_info[pid].values[agent_id],
	    agent_index[pid][agent_id] -> logical_time,
	    logical_time[pid], agent_order[pid][higher_order],
	    pid_info[pid].part_solution_ptr);
	display (1);
	exit (0);
      }
    }
  }
}				/* the end of send_ok */

/* check high agents */

int   check_high_agents ()
{
        SET temp_dom;
  int   i;
  int   j;
  int   k;
  int   consistency;
  int   ag1,
        ag2;
  int   dom_length;

  if (TRUE)
  {
    return - 1;
  }

  if (pid_info[pid].message_ptr != NULL)
  {
    return - 1;
  }

 /* check the result, if it is not correct, print warning */

  for (i = pid_info[pid].high_order + 1; i < agent_count; i++)
  {
    ag2 = agent_order[pid][i];
    dom_length = agent_index[pid][ag2] -> dom_length;
    set_Assign (temp_dom, agent_index[pid][ag2] -> domain);
    for (j = 0; j <= pid_info[pid].high_order; j++)
    {
      ag1 = agent_order[pid][j];
      if (agent_index[pid][ag1] -> relation[ag2] != -1 &&
	  agent_index[pid][ag1] -> my_value > -1)
      {
	for (k = 0; k < MAX_DOMAIN && dom_length > 0; k++)
	{
	  if (pid_info[pid].message_ptr != NULL)
	  {
	    return - 1;
	  }
	  if (set_Mem (temp_dom, k))
	  {
	    consistency = apply (agent_index[pid][ag1] -> my_value, k,
		agent_index[pid][ag1] -> relation[ag2],
		ag1, ag2, -1);
	    if (!consistency)
	    {
	      dom_length--;
	      set_Del (temp_dom, k);
	    }
	  }
	}
	if (dom_length == 0)
	{
	  return j;		/* order */
	}
      }
    }
  }

  return - 1;			/* finish */

}				/* end of the check_high_agents */

/* check consistency */

int   check_consistent (id, value, values)
int   id;
int   value;
int   values[MAX_AGENT];
{
  int   i;
  int   agent_id;
  int   consistent = TRUE;

  for (i = pid_info[pid].lower_order;
      i <= pid_info[pid].high_order && consistent; i++)
  {
    agent_id = agent_order[pid][i];
    if (agent_index[pid][agent_id] -> relation[id] != -1 &&
	values[agent_id] > -1)
    {
      consistent = apply (values[agent_id], value,
	  agent_index[pid][agent_id] -> relation[id],
	  agent_id, id, -1);
    }
  }

  return consistent;

}				/* end of the check_consistent */

/* make nogood2 */

int   make_nogood2 (agent_ptr, tro_maker, dom_waiter, from_id, value, nogoods)
struct agent_home *agent_ptr;
SET tro_maker;
SET dom_waiter;
int   from_id;
int   value;
int   nogoods[MAX_AGENT];
{

  struct info *my_nogood_ptr;
  struct info *temp1_ptr;
  int   i;
  int   agent_id;
  int   miss_id;

  if (value < 0 || !set_Mem (agent_ptr -> avail_domain, value))
  {
    return - 1;
  }

  for (i = pid_info[pid].lower_order;
      i < agent_ptr -> order; i++)
  {
    agent_id = agent_order[pid][i];
    if (set_Mem (tro_maker, agent_id) &&
	(agent_index[pid][agent_id] -> my_value !=
	  pid_info[pid].values[agent_id] ||
	  (nogoods[agent_id] > -1 &&
	    agent_index[pid][agent_id] -> my_value != nogoods[agent_id])))
    {
      return - 1;
    }
  }

  set_Del (tro_maker, from_id);
  set_Del (tro_maker, agent_ptr -> my_id);
  set_Add (dom_waiter, from_id);
  set_Del (dom_waiter, agent_ptr -> my_id);

  for (agent_id = 0; agent_id <= agent_count; agent_id++)
  {
    if (agent_id != agent_ptr -> my_id && set_Mem (tro_maker, agent_id))
    {
      agent_ptr -> in_link[agent_id] = TRUE;
    }
  }


 /* set conf_record */

 /* take away my_value from avail_domain */

  set_Del (agent_ptr -> avail_domain, value);
  agent_ptr -> avail_length--;

 /* set the nogood caused by backtrack */

  apply_info (&my_nogood_ptr, 3);
  my_nogood_ptr -> id = from_id;
  my_nogood_ptr -> to_id = agent_ptr -> my_id;
  my_nogood_ptr -> value = value;
  my_nogood_ptr -> logical_time = logical_time[pid];
  logical_time[pid]++;
  set_Union (tro_maker /* the agents who tro_makers  */ ,
      my_nogood_ptr -> set1,
      my_nogood_ptr -> set1);
  set_Union (dom_waiter /* the agents who wait_dom */ ,
      my_nogood_ptr -> set2,
      my_nogood_ptr -> set2);
  if (agent_ptr -> nogood_ptr == NULL)
  {
    agent_ptr -> nogood_ptr = my_nogood_ptr;
  }
  else
  {
    my_nogood_ptr -> next = agent_ptr -> nogood_ptr;
    agent_ptr -> nogood_ptr = my_nogood_ptr;
  }
  if (agent_ptr -> my_value == value)
  {
    agent_ptr -> my_value = -1;
    agent_ptr -> to_be_sent = FALSE;
    return agent_ptr -> my_id;
  }

  return - 1;

}				/* end of make_nogood2 */

/* make nogood 3 */

make_nogood3 (my_id, from_id)
int   my_id;
int   from_id;
{
  struct agent_home *agent_ptr;
  int   i;
  SET temp_domain;

  agent_ptr = agent_index[pid][my_id];

  if (agent_ptr -> my_value < 0)
  {
    printf ("P%d Wrong in MakeNogood3 for Id %d\n", my_id);
    display (1);
    exit (0);
  }

 /* virtual tro_maker  */

  if (get_order[pid][my_id] != pid_info[pid].high_order)
  {
    printf ("P%d My_Id %d Is Not OK\n", pid, my_id);
    fprintf (out_ptr, "P%d My_Id %d Is Not OK\n", pid, my_id);
    display (1);
    exit (0);
  }
  set_Empty (temp_domain);

  for (i = 0; i < agent_count; i++)
  {
    if (get_order[pid][i] < agent_ptr -> order)
    {
      set_Add (temp_domain, i);
      agent_ptr -> in_link[i] = TRUE;
    }
  }

  make_nogood (agent_ptr, temp_domain, empty, from_id);

}				/* end of make_nogood3 */

/* random data */

int   random (n)

 /* generates a random number between 0 and (n-1) */

int   n;
{
  static int  a = 12747;
  static int  b = 9773;
  a = (a + b) & 0x3fff;
  b = (a + b) & 0x3fff;
  return (a >> 5) % n;
}


/* delete constraints */

del_constraints ()
{
  int   i,
        j;
  int   v1,
        v2;
  int   arcs = 0;
  int   left_arcs = 0;

  arcs = 0;
  for (i = 0; i < agent_count; i++)
  {
    for (j = 0; j < agent_count; j++)
    {
      if (agent_index[pid][i] -> relation[j] != -1)
      {
	arcs++;
      }
    }
  }
  arcs = arcs / 2;

  for (i = 0; i < MAX_AGENT; i++)
  {
    for (j = 0; j < MAX_AGENT; j++)
    {
      if (REDUCE_ARCS < arcs / 2)
      {
	if (agent_index[pid][i] -> relation[j] != -1)
	{
	  constraints[i][j] = TRUE;/* del later */
	}
	else
	{
	  constraints[i][j] = -1;/* no rel */
	}
      }
      else
      {
	if (agent_index[pid][i] -> relation[j] != -1)
	{
	  constraints[i][j] = FALSE;/* add later */
	}
	else
	{
	  constraints[i][j] = -1;/* no rel */
	}
      }
    }
  }
 /* arcs = agent_count*(agent_count-1)/2; */

  printf ("Variables %d Arcs %d \n", agent_count, arcs);

  if (REDUCE_ARCS > arcs)
  {
    printf ("Look REDUCE_ARCS\n");
    exit (0);
  }

  i = 0;

  while (REDUCE_ARCS < arcs / 2 && i < REDUCE_ARCS)
  {
    v1 = random (agent_count);
    v2 = random (agent_count);
    if (v1 != v2 && constraints[v1][v2] == TRUE)
    {
      constraints[v1][v2] = FALSE;/* del constraint */
      constraints[v2][v1] = FALSE;
      i++;
    }
  }

  while (REDUCE_ARCS >= arcs / 2 && i < arcs - REDUCE_ARCS)
  {
    v1 = random (agent_count);
    v2 = random (agent_count);
    if (v1 != v2 && constraints[v1][v2] == FALSE)
    {
      constraints[v1][v2] = TRUE;/* add constraint */
      constraints[v2][v1] = TRUE;
      i++;
    }
  }

  for (i = 0; i < agent_count; i++)
  {
    for (j = 0; j < agent_count; j++)
    {
      if (i != j && constraints[i][j] == FALSE)
      {
	agent_index[pid][i] -> relation[j] = -1;
      }
    }
  }

  left_arcs = 0;

  for (i = 0; i < agent_count; i++)
  {
    for (j = 0; j < agent_count; j++)
    {
      if (agent_index[pid][i] -> relation[j] != -1)
      {
	left_arcs++;
      }
    }
  }

  left_arcs = left_arcs / 2;

  if (REDUCE_ARCS + left_arcs != arcs)
  {
    printf ("left_arcs %d\n", left_arcs);
    exit (0);
  }

  printf ("Out of del_constraints \n");
}
