function Tab4

global UOSBME

%delete(findobj('Style', 'axes'))

axisPos = [0.2 0.3 0.6 0.6];
leftButtonPos = [0.3, 0.05, 0.2, 0.1];
rightButtonPos = [0.5, 0.05, 0.2, 0.1];
leftString = 'Left';
rightString = 'Right';
plotLineWidth = 1;

%UOSBME.TabHandles = guidata(gcf);
UOSBME.leftRemoveList = zeros(1,UOSBME.totalLeftCycles);
UOSBME.rightRemoveList = zeros(1,UOSBME.totalRightCycles);
 

 %% a1  a2  a3
 %% b1  b2  b3
 %% c1  c2  c3
 %% d1  d2  d3
 
 tab4panel = uipanel('Parent', UOSBME.TabHandles{4,1},'Position', UOSBME.panelPos);
 tab4header = uipanel('Parent', UOSBME.TabHandles{4,1},'Position', UOSBME.headerPos);
 
normalOnOffButton4 = uicontrol('Parent', tab4header,...
                               'units', 'normalized',...
                               'Position', [0 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@normalOnOff, 4},...
                               'String', 'Show/Hide Normal Data');
footOffOnOffButton4 = uicontrol('Parent', tab4header,...
                               'units', 'normalized',...
                               'Position', [0.1 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@footOffOnOff, 4},...
                               'String', 'Show/Hide Foot Off');
 
showAverageButton = uicontrol('Parent', tab4header,...
                               'units', 'normalized',...
                               'Position', [0.8 0.1 0.19 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@TabSelectCallback, 5},...
                               'String', 'Show Average Graphs');
                           
showTextHeader = uicontrol('Parent', tab4header,...
                               'units', 'normalized',...
                               'Position', [0.2 0 0.6 0.8],...
                               'Style', 'text',...
                               'String', 'Select buttons under graphs to customise data or select ''Show Average Graphs'' to continue.');
 
 UOSBME.a1 = uipanel;
 set(UOSBME.a1, 'Position', [0 0.75 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.a2 = uipanel;
 set(UOSBME.a2, 'Position', [1/3 0.75 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.a3 = uipanel;
 set(UOSBME.a3, 'Position', [2/3 0.75 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
UOSBME.b1 = uipanel;
 set(UOSBME.b1, 'Position', [0 0.5 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.b2 = uipanel;
 set(UOSBME.b2, 'Position', [1/3 0.5 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.b3 = uipanel;
 set(UOSBME.b3, 'Position', [2/3 0.5 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
UOSBME.c1 = uipanel;
 set(UOSBME.c1, 'Position', [0 0.25 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.c2 = uipanel;
 set(UOSBME.c2, 'Position', [1/3 0.25 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.c3 = uipanel;
 set(UOSBME.c3, 'Position', [2/3 0.25 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none') 
 UOSBME.d1 = uipanel;
 set(UOSBME.d1, 'Position', [0 0 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.d2 = uipanel;
 set(UOSBME.d2, 'Position', [1/3 0 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')
 UOSBME.d3 = uipanel;
 set(UOSBME.d3, 'Position', [2/3 0 1/3 0.25], 'Parent', tab4panel, 'BorderType', 'none')


 aa1 = axes('Parent', UOSBME.a1, 'Position', axisPos);
 ableft1 = uicontrol('Parent', UOSBME.a1,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 1, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
abright1 = uicontrol('Parent', UOSBME.a1,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 1, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);             
 hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,2));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,2));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];



fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
plot(UOSBME.leftPelvicTilt(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightPelvicTilt(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftPelvicTilt, 2)
    line([UOSBME.leftPelvicTilt(1,n,2) UOSBME.leftPelvicTilt(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightPelvicTilt, 2)
    line([UOSBME.rightPelvicTilt(1,n,2) UOSBME.rightPelvicTilt(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end
    

aa2 = axes('Parent', UOSBME.a2, 'Position', axisPos);
 ableft2 = uicontrol('Parent', UOSBME.a2,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 2, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
abright2 = uicontrol('Parent', UOSBME.a2,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 2, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);         
 hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,3));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,3));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftPelvicObliq(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightPelvicObliq(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftPelvicObliq, 2)
    line([UOSBME.leftPelvicObliq(1,n,2) UOSBME.leftPelvicObliq(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
    
end

for n = 1:size(UOSBME.rightPelvicObliq, 2)
    line([UOSBME.rightPelvicObliq(1,n,2) UOSBME.rightPelvicObliq(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
   
end

aa3 = axes('Parent', UOSBME.a3, 'Position', axisPos);
 ableft3 = uicontrol('Parent', UOSBME.a3,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 3, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
abright3 = uicontrol('Parent', UOSBME.a3,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 3, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);         

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,4));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,4));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftPelvicRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightPelvicRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftPelvicRot, 2)
    line([UOSBME.leftPelvicRot(1,n,2) UOSBME.leftPelvicRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightPelvicRot, 2)
    line([UOSBME.rightPelvicRot(1,n,2) UOSBME.rightPelvicRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ba1 = axes('Parent', UOSBME.b1, 'Position', axisPos);
 bbleft1 = uicontrol('Parent', UOSBME.b1,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 4, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
bbright1 = uicontrol('Parent', UOSBME.b1,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 4, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);       
hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,5));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,5));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftHipFlex(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightHipFlex(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftHipFlex, 2)
    line([UOSBME.leftHipFlex(1,n,2) UOSBME.leftHipFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightHipFlex, 2)
    line([UOSBME.rightHipFlex(1,n,2) UOSBME.rightHipFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ba2 = axes('Parent', UOSBME.b2, 'Position', axisPos);
bbleft2 = uicontrol('Parent', UOSBME.b2,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 5, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
bbright2 = uicontrol('Parent', UOSBME.b2,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 5, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,6));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,6));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftHipAbd(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightHipAbd(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftHipAbd, 2)
    line([UOSBME.leftHipAbd(1,n,2) UOSBME.leftHipAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightHipAbd, 2)
    line([UOSBME.rightHipAbd(1,n,2) UOSBME.rightHipAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ba3 = axes('Parent', UOSBME.b3, 'Position', axisPos);
 bbleft3 = uicontrol('Parent', UOSBME.b3,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 6, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
bbright3 = uicontrol('Parent', UOSBME.b3,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 6, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     
hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,7));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,7));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftHipRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightHipRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftHipRot, 2)
    line([UOSBME.leftHipRot(1,n,2) UOSBME.leftHipRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightHipRot, 2)
    line([UOSBME.rightHipRot(1,n,2) UOSBME.rightHipRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ca1 = axes('Parent', UOSBME.c1, 'Position', axisPos);
  cbleft1 = uicontrol('Parent', UOSBME.c1,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 7, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
cbright1 = uicontrol('Parent', UOSBME.c1,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 7, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     
hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,8));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,8));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftKneeFlex(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightKneeFlex(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftKneeFlex, 2)
    line([UOSBME.leftKneeFlex(1,n,2) UOSBME.leftKneeFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightKneeFlex, 2)
    line([UOSBME.rightKneeFlex(1,n,2) UOSBME.rightKneeFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ca2 = axes('Parent', UOSBME.c2, 'Position', axisPos);
  cbleft2 = uicontrol('Parent', UOSBME.c2,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 8, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
cbright2 = uicontrol('Parent', UOSBME.c2,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 8, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     
hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,9));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,9));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftKneeAbd(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightKneeAbd(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftKneeAbd, 2)
    line([UOSBME.leftKneeAbd(1,n,2) UOSBME.leftKneeAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightKneeAbd, 2)
    line([UOSBME.rightKneeAbd(1,n,2) UOSBME.rightKneeAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

ca3 = axes('Parent', UOSBME.c3, 'Position', axisPos);
  cbleft3 = uicontrol('Parent', UOSBME.c3,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 9, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
cbright3 = uicontrol('Parent', UOSBME.c3,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 9, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,10));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,10));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftKneeRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightKneeRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftKneeRot, 2)
    line([UOSBME.leftKneeRot(1,n,2) UOSBME.leftKneeRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightKneeRot, 2)
    line([UOSBME.rightKneeRot(1,n,2) UOSBME.rightKneeRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

da1 = axes('Parent', UOSBME.d1, 'Position', axisPos);
  dbleft1 = uicontrol('Parent', UOSBME.d1,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 10, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
dbright1 = uicontrol('Parent', UOSBME.d1,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 10, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     
hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,11));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,11));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftFootDorsi(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightFootDorsi(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftFootDorsi, 2)
    line([UOSBME.leftFootDorsi(1,n,2) UOSBME.leftFootDorsi(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightFootDorsi, 2)
    line([UOSBME.rightFootDorsi(1,n,2) UOSBME.rightFootDorsi(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

da3 = axes('Parent', UOSBME.d3, 'Position', axisPos);
  dbleft3 = uicontrol('Parent', UOSBME.d3,...
                 'units', 'normalized',...
                 'Position', leftButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 11, 6},...
                 'ForegroundColor', UOSBME.leftColour,...
                 'String', leftString);
                        
             
dbright3 = uicontrol('Parent', UOSBME.d3,...
                 'units', 'normalized',...
                 'Position', rightButtonPos,...
                 'Style', 'pushbutton',...
                 'Callback', {@Tab6, 11, 7},...
                 'ForegroundColor', UOSBME.rightColour,...
                 'String', rightString);     

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,12));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,12));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.leftFootProg(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.rightFootProg(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

for n = 1:size(UOSBME.leftFootProg, 2)
    line([UOSBME.leftFootProg(1,n,2) UOSBME.leftFootProg(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

end

for n = 1:size(UOSBME.rightFootProg, 2)
    line([UOSBME.rightFootProg(1,n,2) UOSBME.rightFootProg(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
  
end

hold off
findAverage
Tab5




    
