function Tab6(~,~,selectedGraph,cBack)

global UOSBME

set(UOSBME.TabHandles{6,2}, 'callback', ...
    {@Tab6, selectedGraph, 6});

set(UOSBME.TabHandles{7,2}, 'callback', ...
    {@Tab6, selectedGraph, 7});

delete(findobj('Style','checkbox'))

plotLineWidth = 1;
subX = 6;
subY =6;


tab6panel = uipanel('Parent', UOSBME.TabHandles{6,1},'Position', UOSBME.panelPos);
tab6header = uipanel('Parent', UOSBME.TabHandles{6,1},'Position', UOSBME.headerPos);

normalOnOffButton6 = uicontrol('Parent', tab6header,...
                               'units', 'normalized',...
                               'Position', [0 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@normalOnOff, 6, selectedGraph},...
                               'String', 'Show/Hide Normal Data');
footOffOnOffButton6 = uicontrol('Parent', tab6header,...
                               'units', 'normalized',...
                               'Position', [0.1 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@footOffOnOff, 6, selectedGraph},...
                               'String', 'Show/Hide Foot Off');

tab7panel = uipanel('Parent', UOSBME.TabHandles{7,1},'Position', UOSBME.panelPos);
tab7header = uipanel('Parent', UOSBME.TabHandles{7,1},'Position', UOSBME.headerPos);

normalOnOffButton7 = uicontrol('Parent', tab7header,...
                               'units', 'normalized',...
                               'Position', [0 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@normalOnOff, 7, selectedGraph},...
                               'String', 'Show/Hide Normal Data');
footOffOnOffButton7 = uicontrol('Parent', tab7header,...
                               'units', 'normalized',...
                               'Position', [0.1 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@footOffOnOff, 7, selectedGraph},...
                               'String', 'Show/Hide Foot Off');




if selectedGraph == 1
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftPelvicTilt, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,2));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,2));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none',...
        'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftPelvicTilt(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftPelvicTilt(1,n,2),...
              UOSBME.leftPelvicTilt(1,n,2)],...
        get(gca,'YLim'),'color',UOSBME.leftColour,...
        'LineWidth', plotLineWidth,...
        'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightPelvicTilt, 2)
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,2));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,2));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightPelvicTilt(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightPelvicTilt(1,n,2) UOSBME.rightPelvicTilt(1,n,2)],...
        get(gca,'YLim'),'color',UOSBME.rightColour,...
        'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 2
    
    
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftPelvicObliq, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,3));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,3));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftPelvicObliq(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftPelvicObliq(1,n,2) UOSBME.leftPelvicObliq(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n, },...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightPelvicObliq, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,3));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,3));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightPelvicObliq(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightPelvicObliq(1,n,2) UOSBME.rightPelvicObliq(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 3
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftPelvicRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,4));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,4));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftPelvicRot(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftPelvicRot(1,n,2) UOSBME.leftPelvicRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n, },...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightPelvicRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,4));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,4));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightPelvicRot(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightPelvicRot(1,n,2) UOSBME.rightPelvicRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 4
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftHipFlex, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,5));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,5));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftHipFlex(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftHipFlex(1,n,2) UOSBME.leftHipFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightHipFlex, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,5));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,5));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightHipFlex(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightHipFlex(1,n,2) UOSBME.rightHipFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 5
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftHipAbd, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,6));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,6));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftHipAbd(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftHipAbd(1,n,2) UOSBME.leftHipAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightHipAbd, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,6));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,6));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightHipAbd(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightHipAbd(1,n,2) UOSBME.rightHipAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 6
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftHipRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,7));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,7));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftHipRot(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftHipRot(1,n,2) UOSBME.leftHipRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightHipRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,7));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,7));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightHipRot(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightHipRot(1,n,2) UOSBME.rightHipRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 7
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftKneeFlex, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,8));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,8));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftKneeFlex(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftKneeFlex(1,n,2) UOSBME.leftKneeFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightKneeFlex, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,8));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,8));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightKneeFlex(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightKneeFlex(1,n,2) UOSBME.rightKneeFlex(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 8
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftKneeAbd, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,9));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,9));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftKneeAbd(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftKneeAbd(1,n,2) UOSBME.leftKneeAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightKneeAbd, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,9));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,9));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightKneeAbd(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightKneeAbd(1,n,2) UOSBME.rightKneeAbd(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 9
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftKneeRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,10));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,10));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftKneeRot(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftKneeRot(1,n,2) UOSBME.leftKneeRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightKneeRot, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,10));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,10));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightKneeRot(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightKneeRot(1,n,2) UOSBME.rightKneeRot(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 10
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftFootDorsi, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,11));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,11));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftFootDorsi(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftFootDorsi(1,n,2) UOSBME.leftFootDorsi(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    %
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightFootDorsi, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,11));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,11));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightFootDorsi(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightFootDorsi(1,n,2) UOSBME.rightFootDorsi(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end

if selectedGraph == 11
    
    tab6graphAxes = axes('Parent',tab6panel);
    
    for n=1:size(UOSBME.leftFootProg, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,12));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,12));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.leftFootProg(:,n,1),UOSBME.leftColour)
        line([UOSBME.leftFootProg(1,n,2) UOSBME.leftFootProg(1,n,2)],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        leftPositionMat(n,:)= sPlotPos;
        
    end
    
    
    for n=1:size(leftPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab6panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [leftPositionMat(n,1)+leftPositionMat(n,3),leftPositionMat(n,2)+leftPositionMat(n,4),15,15],...
            'Callback',{@leftBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
    tab7graphAxes = axes('Parent',tab7panel);
    
    for n=1:size(UOSBME.rightFootProg, 2)
        
        sPlot = subplot(subX,subY,n);
        sPlotPos = getpixelposition(sPlot);
        
        hold all
        
        x = UOSBME.xPoints;
        y1 = (UOSBME.meanPlus2StdALLnormCycles(:,12));
        y2 = (UOSBME.meanMinus2StdALLnormCycles(:,12));
        X = [x; flipud(x)];
        Y = [y1; flipud(y2)];
        fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
        plot(UOSBME.rightFootProg(:,n,1),UOSBME.rightColour)
        line([UOSBME.rightFootProg(1,n,2) UOSBME.rightFootProg(1,n,2)],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
        rightPositionMat(n,:)= sPlotPos;
        
    end
    
    for n=1:size(rightPositionMat, 1)
        
        cBox1 = uicontrol('Parent',tab7panel, ...
            'Units', 'pixels', ...
            'Style', 'checkbox',...
            'Value', 1,...
            'Position', [rightPositionMat(n,1)+rightPositionMat(n,3),rightPositionMat(n,2)+rightPositionMat(n,4),15,15],...
            'Callback',{@rightBoxValue, n},...
            'String', n,...
            'BackgroundColor', 'white',...
            'HorizontalAlignment', 'center');
        
    end
end


leftGoButton = uicontrol('Parent',UOSBME.TabHandles{6,1}, ...
    'Units', 'pixels', ...
    'Position', [round(UOSBME.PanelWidth)-UOSBME.ButtonWidth 0 UOSBME.ButtonWidth UOSBME.ButtonHeight], ...
    'String', 'Go!!!', ...
    'Callback', {@deleteLeftGraphs, selectedGraph}, ...
    'Style', 'pushbutton',...
    'HorizontalAlignment', 'center',...
    'FontName', 'arial',...
    'FontWeight', 'bold',...
    'FontSize', 12);

rightGoButton = uicontrol('Parent',UOSBME.TabHandles{7,1}, ...
    'Units', 'pixels', ...
    'Position', [round(UOSBME.PanelWidth)-UOSBME.ButtonWidth 0 UOSBME.ButtonWidth UOSBME.ButtonHeight], ...
    'String', 'Go!!!', ...
    'Callback', {@deleteRightGraphs, selectedGraph}, ...
    'Style', 'pushbutton',...
    'HorizontalAlignment', 'center',...
    'FontName', 'arial',...
    'FontWeight', 'bold',...
    'FontSize', 12);

Tab4
TabSelectCallback(0,0,cBack);
