function buildGUI

%   This function creates a figure with multiple Tabs.
%   The number of tabs can be changed and they are distributed evenly
%   across the top of the figure.  Content is provided for the first 5 tabs
%   to demo the program.  The demo uses the screen size to adjust the size
%   of the figure.  The program uses the ~ character for unused arguments,
%   so if you are not using 2009b, these should be changed to dummy
%   arguments (lines 209 and 233). guidata is set to the UOSBME.TabHandles cell
%   array and is used to pass all arguments and data to the functions.


global UOSBME

%%   Set up some varables
%   Set Number of tabs and tab labels.  Make sure the number of tab labels
%   match the HumberOfTabs setting.
NumberOfTabs = 7;               % Number of tabs to be generated
TabLabels = {'Start'; 'MAP'; 'EGS'; 'Graphs'; 'Average'; 'Left'; 'Right'};

%   Get user screen size
SC = get(0, 'ScreenSize');
MaxMonitorX = SC(3);
MaxMonitorY = SC(4);

%   Set the figure window size values
MainFigXScale = 0.99;          % Change this value to adjust the figure size
MainFigYScale = 0.9;          % Change this value to adjust the figure size
MaxWindowX = round(MaxMonitorX*MainFigXScale);
MaxWindowY = round(MaxMonitorY*MainFigYScale);
XBorder = (MaxMonitorX-MaxWindowX)/2;
YBorder = (MaxMonitorY-MaxWindowY)/2;
UOSBME.ButtonHeight = 40;
UOSBME.PanelWidth = MaxWindowX+4;
UOSBME.PanelHeight = MaxWindowY-UOSBME.ButtonHeight;
UOSBME.ButtonWidth = round((UOSBME.PanelWidth-NumberOfTabs)/NumberOfTabs);

%   Set the color varables.
UOSBME.White = [1  1  1];            %UOSBME.White - Selected tab color
BGColor = .9*UOSBME.White;           % Light Grey - Background color

%%   Create a figure for the tabs
UOSBME.hTabFig = figure(...
    'Units', 'pixels',...
    'Toolbar', 'none',...
    'Position',[ XBorder, YBorder, MaxWindowX, MaxWindowY ],...
    'NumberTitle', 'off',...
    'Name', 'Gait Reporting Tool',...
    'MenuBar', 'none',...
    'Resize', 'off',...
    'DockControls', 'off',...
    'Color',UOSBME.White);

%%   Define a cell array for panel and pushbutton handles, pushbuttons labels and other data
%   rows are for each tab + two additional rows for other data
%   columns are uipanel handles, selection pushbutton handles, and tab label strings - 3 columns.
UOSBME.TabHandles = cell(NumberOfTabs,3);
UOSBME.TabHandles(:,3) = TabLabels(:,1);
%   Add additional rows for other data
UOSBME.TabHandles{NumberOfTabs+1,1} = UOSBME.hTabFig;         % Main figure handle
UOSBME.TabHandles{NumberOfTabs+1,2} = UOSBME.PanelWidth;      % Width of tab panel
UOSBME.TabHandles{NumberOfTabs+1,3} = UOSBME.PanelHeight;     % Height of tab panel
UOSBME.TabHandles{NumberOfTabs+2,1} = 0;               % Handle to default tab 2 content(set later)
UOSBME.TabHandles{NumberOfTabs+2,2} =UOSBME.White;           % Selected tab Color
UOSBME.TabHandles{NumberOfTabs+2,3} = BGColor;         % Background color

%%   Build the Tabs
for TabNumber = 1:NumberOfTabs
    % create a UIPanel
    UOSBME.TabHandles{TabNumber,1} = uipanel('Units', 'pixels',...
        'Visible', 'off',...
        'Backgroundcolor',UOSBME.White,...
        'BorderWidth',1, ...
        'Position', [0 0 UOSBME.PanelWidth UOSBME.PanelHeight]);
    
    % create a selection pushbutton
    UOSBME.TabHandles{TabNumber,2} = uicontrol('Style', 'pushbutton',...
        'Units', 'pixels', ...
        'BackgroundColor', BGColor, ...
        'Position', [(TabNumber-1)*UOSBME.ButtonWidth UOSBME.PanelHeight UOSBME.ButtonWidth UOSBME.ButtonHeight], ...
        'String', UOSBME.TabHandles{TabNumber,3},...
        'HorizontalAlignment', 'center',...
        'FontName', 'arial',...
        'FontWeight', 'bold',...
        'FontSize', 10);
    
end

%%   Define the callbacks for the Tab Buttons
%   All callbacks go to the same function with the additional argument being the Tab number
for CountTabs = 1:NumberOfTabs
    set(UOSBME.TabHandles{CountTabs,2}, 'callback', ...
        {@TabSelectCallback, CountTabs});
end
%%   Save the UOSBME.TabHandles in guidata
guidata(UOSBME.hTabFig,UOSBME.TabHandles);




