%% Calculate foot strike/off events using marker positions (based on Zeni et al. 2008)
function getEventsByCoOrds

global UOSBME

%% FIND LEFT FOOT STRIKE

LeftHeelMinusSacrum = UOSBME.markers.LHEE(:,1) - UOSBME.markers.LPSI(:,1);

% correct for when walking in negative x direction (50 and 1 arbitrary)
if UOSBME.markers.LHEE(50) < UOSBME.markers.LHEE(1)
    
    LeftHeelMinusSacrum = -LeftHeelMinusSacrum;
end

% find index of peaks which correspond to event frame
[~, ILFS] = findpeaks(LeftHeelMinusSacrum);

% correct for frame not starting at zero
UOSBME.getLFSbyCoOrds = [ILFS]' + UOSBME.firstFrame;

%for display/testing against force plates
%leftstrike = UOSBME.getLFSbyCoOrds

%% FIND LEFT FOOT OFF

LeftSacrumMinusToe = UOSBME.markers.LPSI(:,1) - UOSBME.markers.LTOE(:,1);

% correct for when walking in negative x direction (50 and 1 arbitrary)
if UOSBME.markers.LHEE(50) < UOSBME.markers.LHEE(1)
    
    LeftSacrumMinusToe = -LeftSacrumMinusToe;
end

% find index of peaks which correspond to event frame
[~, ILFO] = findpeaks(LeftSacrumMinusToe);

% correct for frame not starting at zero
UOSBME.getLFObyCoOrds = [ILFO]' + UOSBME.firstFrame;

%for display/testing against force plates
%leftoff = UOSBME.getLFObyCoOrds

%% FIND RIGHT FOOT STRIKE

RightHeelMinusSacrum = UOSBME.markers.RHEE(:,1) - UOSBME.markers.RPSI(:,1);

% correct for when walking in negative x direction (50 and 1 arbitrary)
if UOSBME.markers.LHEE(50) < UOSBME.markers.LHEE(1)
    
    RightHeelMinusSacrum = -RightHeelMinusSacrum;
end

% find index of peaks which correspond to event frame
[~, IRFS] = findpeaks(RightHeelMinusSacrum);

UOSBME.getRFSbyCoOrds = [IRFS]' + UOSBME.firstFrame;

%for display/testing against force plates
%rightstrike = UOSBME.getRFSbyCoOrds

%% FIND RIGHT FOOT OFF

RightSacrumMinusToe = UOSBME.markers.RPSI(:,1) - UOSBME.markers.RTOE(:,1);

% correct for when walking in negative x direction (50 and 1 arbitrary)
if UOSBME.markers.LHEE(50) < UOSBME.markers.LHEE(1)
    
    RightSacrumMinusToe = -RightSacrumMinusToe;
end

% find index of peaks which correspond to event frame
[~, IRFO] = findpeaks(RightSacrumMinusToe);

% correct for frame not starting at zero
UOSBME.getRFObyCoOrds = [IRFO]' + UOSBME.firstFrame;

%for display/testing against force plates
%rightoff = UOSBME.getRFObyCoOrds

%% DISPLAY FORCE PLATE EVENTS (FOR TESTING)
%for display/testing against force plates
%footEvents = btkGetEvents(UOSBME.acq)

% get event frames from force plates
getEvents

end