%% Find event frames from force plate times and use these if available or calculated events if not

function getEvents

global UOSBME

%% GET LEFT FOOT STRIKE
if isfield(UOSBME.footEvents, 'Left_Foot_Strike') && UOSBME.forceEvents == 0;
    LFS = getfield(UOSBME.footEvents, 'Left_Foot_Strike');
    UOSBME.LFSFrames = round(LFS*100);
else
    UOSBME.LFSFrames = UOSBME.getLFSbyCoOrds;
end

%If foot strike/off is reported by vicon before first frame?? MAY CHANGE

if UOSBME.LFSFrames(1,1) < UOSBME.firstFrame;
    UOSBME.LFSFrames = UOSBME.getLFSbyCoOrds;
end


%% GET LEFT FOOT OFF
if isfield(UOSBME.footEvents, 'Left_Foot_Off') && UOSBME.forceEvents == 0;
    LFO = getfield(UOSBME.footEvents, 'Left_Foot_Off');
    UOSBME.LFOFrames = round(LFO*100);
else
    UOSBME.LFOFrames = UOSBME.getLFObyCoOrds;
end

%If foot strike/off is reported by vicon before first frame?? MAY CHANGE
if UOSBME.LFOFrames(1,1) < UOSBME.firstFrame;
    UOSBME.LFOFrames = UOSBME.getLFObyCoOrds;
end


%% GET RIGHT FOOT STRIKE
if isfield(UOSBME.footEvents, 'Right_Foot_Strike') && UOSBME.forceEvents == 0;
    RFS = getfield(UOSBME.footEvents, 'Right_Foot_Strike');
    UOSBME.RFSFrames = round(RFS*100);
else
    UOSBME.RFSFrames = UOSBME.getRFSbyCoOrds;
end

% If foot strike/off is reported by vicon before first frame?? MAY CHANGE
if UOSBME.RFSFrames(1,1) < UOSBME.firstFrame;
    UOSBME.RFSFrames = UOSBME.getRFSbyCoOrds;
end


%% GET RIGHT FOOT OFF
if isfield(UOSBME.footEvents, 'Right_Foot_Off') && UOSBME.forceEvents == 0;
    RFO = getfield(UOSBME.footEvents, 'Right_Foot_Off');
    UOSBME.RFOFrames = round(RFO*100);
else
    UOSBME.RFOFrames = UOSBME.getRFObyCoOrds;
end
% If foot strike/off is reported by vicon before first frame?? MAY CHANGE
if UOSBME.RFOFrames(1,1) < UOSBME.firstFrame;
    UOSBME.RFOFrames = UOSBME.getRFObyCoOrds;
end

getAngles
