function exportGraphs(~,~)

global UOSBME

exportFig = figure();

set(UOSBME.allAvgGraphs, 'Parent', exportFig, 'Position', [0 0 1 1])

[saveFileName,savePathName] = uiputfile({'.jpg';'.png';'.pdf'})
saveFileAs = fullfile(savePathName,saveFileName)

count = 0;
err_count = 0;

while count == err_count
    try
        saveas(UOSBME.allAvgGraphs, saveFileAs)
    catch ME
        if saveFileAs ~=0
            invalidFileWarning = warndlg('Please choose a valid filename!', 'Unable to save file!', 'modal');
            uiwait
            [saveFileName,savePathName] = uiputfile({'.jpg';'.png';'.pdf'});
            saveFileAs = fullfile(savePathName,saveFileName);
            err_count = err_count + 1;
        end
    end
    count = count + 1;
end

figure(UOSBME.hTabFig)

if UOSBME.runMode == 0
    Tab5
end

if UOSBME.runMode == 2
    beforeAfterGraphs
end

uistack(exportFig)



