function Tab5

% declaration

global UOSBME

grey = [0.8 0.8 0.8];
dataString = 'Customise Data';
axisPos = [0.2 0.3 0.6 0.6];
buttonPos = [0.3, 0.05, 0.4, 0.1];
plotLineWidth = 1;

tab5panel = uipanel('Parent', UOSBME.TabHandles{5,1},'Position', UOSBME.panelPos);
tab5header = uipanel('Parent', UOSBME.TabHandles{5,1},'Position', UOSBME.headerPos);
 
normalOnOffButton5 = uicontrol('Parent', tab5header,...
                               'units', 'normalized',...
                               'Position', [0 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@normalOnOff, 5},...
                               'String', 'Show/Hide Normal Data');
footOffOnOffButton5 = uicontrol('Parent', tab5header,...
                               'units', 'normalized',...
                               'Position', [0.1 0.1 0.1 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@footOffOnOff, 5},...
                               'String', 'Show/Hide Foot Off');
                           
if UOSBME.runMode == 0
    loadAfterButton1 = uicontrol('Parent', tab5header,...
                               'units', 'normalized',...
                               'Position', [0.8 0.1 0.19 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@exportGraphs},...
                               'String', 'Export Graphs');
end                           
if UOSBME.runMode == 1
    loadAfterButton2 = uicontrol('Parent', tab5header,...
                               'units', 'normalized',...
                               'Position', [0.8 0.1 0.19 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@beforeAfter},...
                               'String', 'Load "After" Data');
end

if UOSBME.runMode == 2
    loadAfterButton3 = uicontrol('Parent', tab5header,...
                               'units', 'normalized',...
                               'Position', [0.8 0.1 0.19 0.8],...
                               'Style', 'pushbutton',...
                               'Callback', {@beforeAfterGraphs},...
                               'String', 'Plot Before/After Graphs');
end
 

 %% a1  a2  a3
 %% b1  b2  b3
 %% c1  c2  c3
 %% d1  d2  d3
 
 UOSBME.a1 = uipanel;
 set(UOSBME.a1, 'Position', [0 0.75 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.a2 = uipanel;
 set(UOSBME.a2, 'Position', [1/3 0.75 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.a3 = uipanel;
 set(UOSBME.a3, 'Position', [2/3 0.75 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
UOSBME.b1 = uipanel;
 set(UOSBME.b1, 'Position', [0 0.5 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.b2 = uipanel;
 set(UOSBME.b2, 'Position', [1/3 0.5 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.b3 = uipanel;
 set(UOSBME.b3, 'Position', [2/3 0.5 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
UOSBME.c1 = uipanel;
 set(UOSBME.c1, 'Position', [0 0.25 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.c2 = uipanel;
 set(UOSBME.c2, 'Position', [1/3 0.25 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.c3 = uipanel;
 set(UOSBME.c3, 'Position', [2/3 0.25 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none') 
 UOSBME.d1 = uipanel;
 set(UOSBME.d1, 'Position', [0 0 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.d2 = uipanel;
 set(UOSBME.d2, 'Position', [1/3 0 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')
 UOSBME.d3 = uipanel;
 set(UOSBME.d3, 'Position', [2/3 0 1/3 0.25], 'Parent', tab5panel, 'BorderType', 'none')

 
 aa1 = axes('Parent', UOSBME.a1, 'Position', axisPos);
%  ab1 = uicontrol('Parent', UOSBME.a1,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 1},...
%                  'String', dataString);
 hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,2));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,2));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftPelvicTilt(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightPelvicTilt(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftPelvicTiltFO UOSBME.meanLeftPelvicTiltFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightPelvicTiltFO UOSBME.meanRightPelvicTiltFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

aa2 = axes('Parent', UOSBME.a2, 'Position', axisPos);
%  ab2 = uicontrol('Parent', UOSBME.a2,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 2},...
%                  'String', dataString);
 hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,3));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,3));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];


fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);
plot(UOSBME.meanLeftPelvicObliq(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightPelvicObliq(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftPelvicObliqFO UOSBME.meanLeftPelvicObliqFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightPelvicObliqFO UOSBME.meanRightPelvicObliqFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

aa3 = axes('Parent', UOSBME.a3, 'Position', axisPos);
%  ab3 = uicontrol('Parent', UOSBME.a3,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 3},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,4));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,4));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftPelvicRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightPelvicRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftPelvicRotFO UOSBME.meanLeftPelvicRotFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightPelvicRotFO UOSBME.meanRightPelvicRotFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

ba1 = axes('Parent', UOSBME.b1, 'Position', axisPos);
%  bb1 = uicontrol('Parent', UOSBME.b1,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 4},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,5));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,5));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftHipFlex(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightHipFlex(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftHipFlexFO UOSBME.meanLeftHipFlexFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightHipFlexFO UOSBME.meanRightHipFlexFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

ba2 = axes('Parent', UOSBME.b2, 'Position', axisPos);
%  bb2 = uicontrol('Parent', UOSBME.b2,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 5},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,6));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,6));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftHipAbd(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightHipAbd(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftHipAbdFO UOSBME.meanLeftHipAbdFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightHipAbdFO UOSBME.meanRightHipAbdFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

ba3 = axes('Parent', UOSBME.b3, 'Position', axisPos);
%  bb3 = uicontrol('Parent', UOSBME.b3,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 6},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,7));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,7));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftHipRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightHipRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftHipRotFO UOSBME.meanLeftHipRotFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightHipRotFO UOSBME.meanRightHipRotFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)


ca1 = axes('Parent', UOSBME.c1, 'Position', axisPos);
%  cb1 = uicontrol('Parent', UOSBME.c1,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 7},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,8));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,8));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftKneeFlex(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightKneeFlex(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftKneeFlexFO UOSBME.meanLeftKneeFlexFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightKneeFlexFO UOSBME.meanRightKneeFlexFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

ca2 = axes('Parent', UOSBME.c2, 'Position', axisPos);
%  cb2 = uicontrol('Parent', UOSBME.c2,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 8},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,9));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,9));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftKneeAbd(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightKneeAbd(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftKneeAbdFO UOSBME.meanLeftKneeAbdFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightKneeAbdFO UOSBME.meanRightKneeAbdFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)


ca3 = axes('Parent', UOSBME.c3, 'Position', axisPos);
%  cb3 = uicontrol('Parent', UOSBME.c3,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 9},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,10));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,10));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftKneeRot(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightKneeRot(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftKneeRotFO UOSBME.meanLeftKneeRotFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightKneeRotFO UOSBME.meanRightKneeRotFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

da1 = axes('Parent', UOSBME.d1, 'Position', axisPos);
%  db1 = uicontrol('Parent', UOSBME.d1,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 10},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,11));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,11));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftFootDorsi(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightFootDorsi(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftFootDorsiFO UOSBME.meanLeftFootDorsiFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightFootDorsiFO UOSBME.meanRightFootDorsiFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)

da3 = axes('Parent', UOSBME.d3, 'Position', axisPos);
%  db3 = uicontrol('Parent', UOSBME.d3,...
%                  'units', 'normalized',...
%                  'Position', buttonPos,...
%                  'Style', 'pushbutton',...
%                  'Callback', {@Tab6, 11},...
%                  'String', dataString);

hold all

x = UOSBME.xPoints;
y1 = (UOSBME.meanPlus2StdALLnormCycles(:,12));
y2 = (UOSBME.meanMinus2StdALLnormCycles(:,12));
X = [x; flipud(x)];
Y = [y1; flipud(y2)];

fill(X,Y,UOSBME.fillColour,'EdgeColor','none', 'FaceAlpha', UOSBME.fillAlpha);

plot(UOSBME.meanLeftFootProg(:,:,1),UOSBME.leftColour, 'LineWidth', plotLineWidth)
plot(UOSBME.meanRightFootProg(:,:,1),UOSBME.rightColour, 'LineWidth', plotLineWidth)

line([UOSBME.meanLeftFootProgFO UOSBME.meanLeftFootProgFO],get(gca,'YLim'),'color',UOSBME.leftColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)
line([UOSBME.meanRightFootProgFO UOSBME.meanRightFootProgFO],get(gca,'YLim'),'color',UOSBME.rightColour, 'LineWidth', plotLineWidth, 'LineStyle', UOSBME.footOffLine)


UOSBME.allAvgGraphs = tab5panel;

             
             
TabSelectCallback(0,0,4);



    
