function calcEGS

global UOSBME

%Find left foot midstance

leftHeelMinusRightHeel = UOSBME.markerLeftNormalised(:,1,:)-UOSBME.markerLeftNormalised(:,2,:);

for n = 1:size(leftHeelMinusRightHeel, 3)
if leftHeelMinusRightHeel(1,1,n) < 0
    leftHeelMinusRightHeel(:,:,n) = -leftHeelMinusRightHeel(:,:,n);
end
meanLeftHeelMinusRightHeel =  mean(leftHeelMinusRightHeel, 3);
end

leftNormMidStance = find(meanLeftHeelMinusRightHeel < 0, 1);
leftStancePhase = 1:round(mean(UOSBME.normLFO));
leftSwingPhase = round(mean(UOSBME.normLFO)):100;

%EGS 3 Max Ankle Dorsiflexion in Stance

EGS3leftValue = max(UOSBME.meanLeftFootDorsi(leftStancePhase));

if EGS3leftValue > 40
    UOSBME.EGS3leftBox = 1;
    UOSBME.EGSleftScore(3) = 2;
end
if EGS3leftValue > 25 && EGS3leftValue <= 40 
    UOSBME.EGS3leftBox = 2;
    UOSBME.EGSleftScore(3) = 1;
end
if EGS3leftValue > 5 && EGS3leftValue <= 25 
    UOSBME.EGS3leftBox = 3;
    UOSBME.EGSleftScore(3) = 0;
end
if EGS3leftValue > -10 && EGS3leftValue <= 5 
    UOSBME.EGS3leftBox = 4;
    UOSBME.EGSleftScore(3) = 1;
end
if EGS3leftValue <= -10 
    UOSBME.EGS3leftBox = 5;
    UOSBME.EGSleftScore(3) = 2;
end

%EGS 7 Max Ankle Dorsiflexion in Swing

EGS7leftValue = max(UOSBME.meanLeftFootDorsi(leftSwingPhase));

%% display
displayEGS(UOSBME.EGS3leftBox)




