function normalise

%%Create normalised graph with 100 points

global UOSBME

%Calculate normalised points

for n = 1:UOSBME.totalLeftCycles
    
    nonZeroLeftAngleCycle = UOSBME.oneCycleLeftAngles(:,:,n);
    nonZeroLeftAngleCycle(all(~nonZeroLeftAngleCycle,2), :) = [];
    colLength = size(nonZeroLeftAngleCycle,1);
    x=linspace(1,100,colLength)';
    xi=(1:1:100)';
    UOSBME.oneLeftNormalised(:,:,n) = interp1(x, nonZeroLeftAngleCycle, xi, 'linear', 'extrap');
    
    nonZeroLeftMarkerCycle = UOSBME.oneCycleLeftMarkers(:,:,n);
    nonZeroLeftMarkerCycle(all(~nonZeroLeftMarkerCycle,2), :) = [];
    colLength = size(nonZeroLeftMarkerCycle,1);
    x=linspace(1,100,colLength)';
    xi=(1:1:100)';
    UOSBME.markerLeftNormalised(:,:,n) = interp1(x, nonZeroLeftMarkerCycle, xi, 'linear', 'extrap');
end

for n = 1:UOSBME.totalRightCycles
    
    nonZeroRightCycle = UOSBME.oneCycleRightAngles(:,:,n);
    nonZeroRightCycle(all(~nonZeroRightCycle,2), :) = [];
    colLength = size(nonZeroRightCycle,1);
    x=linspace(1,100,colLength)';
    xi=(1:1:100)';
    UOSBME.oneRightNormalised(:,:,n) = interp1(x, nonZeroRightCycle, xi,'linear', 'extrap');
    
    nonZeroRightMarkerCycle = UOSBME.oneCycleRightMarkers(:,:,n);
    nonZeroRightMarkerCycle(all(~nonZeroRightMarkerCycle,2), :) = [];
    colLength = size(nonZeroRightMarkerCycle,1);
    x=linspace(1,100,colLength)';
    xi=(1:1:100)';
    UOSBME.markerRightNormalised(:,:,n) = interp1(x, nonZeroRightMarkerCycle, xi, 'linear', 'extrap');
    
end

clearvars x xi colLength

createAngleMatrices

Tab4