(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 14, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 12, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L0, bold, b29555;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L0, nowordwrap;
	fontset = print, "Courier New", 12, L0, nowordwrap;
	fontset = info, "Courier New", 12, L0, nowordwrap;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Times New Roman", 10, L0, nohscroll, italic, B65535;
	fontset = header, "Times New Roman", 12, L0, nohscroll, italic;
	fontset = footer, "Times New Roman", 12, L0, center, nohscroll, italic;
	fontset = help, "Times New Roman", 12, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Courier New", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Arial", 10, L0, nohscroll;
	fontset = special2, "Times New Roman", 12, L0, nohscroll;
	fontset = special3, "Times New Roman", 12, L0, nohscroll;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 12, L0, nohscroll;
	fontset = leftheader, "Times New Roman", 12, L0;
	fontset = leftfooter, "Times New Roman", 12, L0;
	fontset = reserved1, "Helv", 12, L0, nowordwrap, nohscroll;]
:[font = title; inactive; preserveAspect; startGroup; nohscroll; center; ]
Haemoperfusion Column Equation Solver
:[font = subtitle; inactive; preserveAspect; nohscroll; center; ]
Stuart Kelly	May 1997
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; ]




To run this program, Select Evaluate Notebook from the Action menu.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Initialisation section.
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppress annoying warning messages
:[font = input; preserveAspect; ]
Off[General::spell1];
Off[FindRoot::precw];
:[font = text; inactive; preserveAspect; nohscroll; ]

Ensure that no initial values are attached to these variables
:[font = input; preserveAspect; endGroup; ]
x=.;
y=.;
xs=.;
xstar=.;
xstarr=.;
ydot=.;
xgone=.;
ygone=.;
xout=.;
clear=.;
xlist=.;
clearlist=.;
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Data input dialogues.
:[font = input; preserveAspect; ]
Input["Enter an identifying name for the current simulation:"];
title=%;	
Input["Enter the column volume in ml:"];
volume=%;						
Input["Enter the column void fraction:"];
epsilon=%;				
Input["Enter the flow rate in ml/min:"];
flow=%;				
Input["Enter the carbon granule diameter in mm:"];
dpp=%;					
Input["Enter the carbon bulk density in kg/m^3:"];
rob=%;				
Input["Enter the Langmuir concentration qm in mmol/g:"];
qm=%;
Input["Enter the Langmuir affinity constant K1 in l/mmol:"];
k1=%;												
Input["Enter the external mass transfer coeff, ke, in m/s:"];
ke=%;						
Input["Enter the intraparticle diffusion coeff, Ds, in m^2/s:"];
ds=%;						
Input["Enter the sorbate inlet concentration in mg/ml:"];
c0=%;
Input["Enter the sorbate molecular weight in g/mol:"];
mw=%;						
Input["Enter the number of cells to be used in the model:"];
ncells=%;					

Input["Enter the time step size in terms of dimensionless time T:"];
deltime=%;
Input["Enter the total simulation time in terms of T:"];
endtime=%;
:[font = input; preserveAspect; endGroup; ]
Input["Is the sorbate protein bound?  Enter 1 if yes, 0 if no:"];
proteinbound=%;
If[proteinbound==1, Input["Enter the protein binding coefficient K, such that ct = K cf:"]; kk=%];
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Calculate dimensionless parameters.
:[font = input; preserveAspect; endGroup; ]
jump=10;
counter=jump-1;

choosecell=ncells;

vol=volume/1000000;
dp=dpp/1000;
flowunits=flow/60000000;
ap = 6/dp;				(* for spherical granules *)
c0units=c0*1000/mw;
q0=qm*k1*c0units/(1+k1*c0units);

lambda=rob*q0/c0units;
ne=ke*ap*(1-epsilon)*vol/flowunits;
ns=60*ds*lambda*vol/(flowunits*(dp^2));
ratio=lambda/epsilon;
r=1/(1+k1*c0units);
psiq=1/(r^1.5 + 1.688*(1-r));

tequiv=lambda*vol/(60*flowunits);

ntime=Round[endtime/deltime];
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Modify parameters if protein binding.
:[font = input; preserveAspect; startGroup; ]
If[proteinbound==1, rold=r; nsold=ns; ratioold=ratio; r=1/(1+(1/kk)*((1/r)-1)); ns=nsold*r/rold; ratio=ratioold*r/(kk*rold); Print["Calculation allows for Protein Binding"], Print["No Protein Binding in this Calculation"] ];
:[font = print; inactive; formatted; output; endGroup; endGroup; nowordwrap; ]
No Protein Binding in this Calculation


;[o]
No Protein Binding in this Calculation
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Set initial conditions.
:[font = input; preserveAspect; endGroup; ]
x[0]=1.;
xgone[0]=1.;
For[i=1, i<(ncells+1), i++, x[i]=0.; y[i]=0. ];
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Definition of xstarr(x,y) function - subroutine which calculates xstar by iteration.
:[font = input; preserveAspect; endGroup; ]
xstarr[a_, b_] := (

	ans=-2; start=0.01;
	
	While[ans<0,
	
		ans=FindRoot[ns*psiq*((xstr/(r+(1-r)*xstr))^2 - b^2) == 2*ne*(a-xstr)*b, {xstr, start}, MaxIterations->200];
		
		start=start+0.01
		
		  ];
		 
	xss=xstr/.ans
	
	               )
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Main program:  open this section to see how many time steps have been completed.
:[font = input; preserveAspect; endGroup; ]
For[j=1, j<(ntime+1), j++,

	For[k=1, k<(ncells+1), k++,
	
		xgone[k] = x[k];
		ygone[k] = y[k];
		If[ygone[k]==0, xstar=0, xstar=xstarr[xgone[k], ygone[k]] ];
		
		ydot=ne*(xgone[k]-xstar);
		x[k]= xgone[k]+ deltime*ratio*(ncells*(xgone[k-1]-xgone[k])-ydot);
		y[k]= ygone[k] + ydot*deltime;
		
	    ];
	    
	counter++;
	If[counter==jump, xout[j]=x[choosecell];
					  clear[j]=1.-xout[j];
					  counter=0;
					  Print[j];
	  ];
	  
	   ];
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Output section:  open this section to see the final result of the calculation.  
:[font = input; preserveAspect; endGroup; endGroup; ]
clearlist= Table[clear[p], {p,1,ntime,jump}];



ListPlot[clearlist, DefaultFont->{"Times", 11}, PlotJoined->True, AxesLabel->{"10s of timesteps", "Fractional Clearance"}, AxesOrigin->{0,1}, PlotRange->All, PlotLabel->FontForm[title, {"Times-Bold", 14}]];

Print["Ne = ", ne];
Print["Ns = ", ns];
Print["R = ", r];
Print["lambda = ", lambda];
If[proteinbound==1, Print["Protein Binding with K = ", kk], Print["No Protein Binding"]];

Print[""];
Print["time step size was ",deltime, " T"];
Print["total simulation time was ", endtime, " T"];
Print["T is equivalent to ",tequiv," minutes"];
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Manual:  this section contains full documentation for the program.
:[font = special1; inactive; nohscroll; ]





Documentation for Mathematica solver of Haemoperfusion Column Model, perfuse.ma
**************************************************************************************************
**************************************************************************************************

(This documentation is also available as the Word 6.0 file, solv_doc.doc)


Contents
***********

1.	Introduction
2.	How to use perfuse.ma to predict the performance of a haemoperfusion column
3.	The mathematical model
4.	The program explained
5.	References


1.  Introduction
******************

The Mathematica notebook perfuse.ma contains a program which can be used to predict the performance of a packed-bed, activated carbon filled, haemoperfusion column.  The program implements a model which is capable of dealing with the removal of solutes which are either in simple aqueous solution, or bound to plasma proteins. 

As input, the program requires information about the activated carbon, the column and the flow rate of the perfusing fluid.  Output is given as a plot of fractional clearance (clearance/flow rate) against perfusion time.

The model implemented by the program was developed by Radcliffe (1978).  Brief details of the model are presented later in this document.  Full details can be found in the original reference, or in Radcliffe & Gaylor (1981)


2.  How to use perfuse.ma to predict the performance of a haemoperfusion column
***********************************************************************************************

It would be useful for the user to become familiar with the Mathematica software before trying to use perfuse.ma.  Wolfram (1991) provides a good introduction to using Mathematica.  Mathematica sessions are conducted in a "notebook" environment, in which program input and output are all represented simultaneously on the computer screen.

The program, as it stands, is set up to solve for a perfusion with constant inlet concentration of the toxin (i.e. a single pass perfusion).  The carbon in the column is assumed to have no toxin adsorbed to it, prior to the start of perfusion.

For these conditions, the steps to obtain a prediction of the columns performance are:

1.  Start Mathematica.
2.  Open the Mathematica notebook, perfuse.ma.
3.  Execute the command: Evaluate Notebook.  The program will now begin to run.
4.  Dialogue boxes will appear, asking the user to enter values for the various input parameters required by the program.  The parameters required are listed in Table 1.  Values must be entered for all parameters; any value not provided is likely to be assumed zero.
:[font = special1; inactive; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Arial"; fontSize = 10; ]


Parameter						units
---------------						-------

Simulation name					-
Column volume, V					ml
Column void fraction, e				-
Flow rate, Q						ml/min
Carbon granule diameter, dp			mm
Carbon bulk density, rb				kg/m3
qm								mmol/g
K1								l/mmol
ke								m/s
Ds								m2/s
Sorbate inlet concentration, co		mg/ml
Sorbate molecular weight			g/mol
Number of cells to use in model, n	-
Protein binding coefficient, K			-

----------------------------
Table 1.  Input data
----------------------------


5.  After all data has been entered, open the Main Program section.  The numbers being printed on the screen represent the number of completed time steps.
6.  Once solution has proceeded for all time steps, open the Output section to see the graphical results.  The program plots Fractional Clearance against dimensionless time.  The plot is in a format which can be exported to other software, such as Microsoft Word or Excel.
:[font = special1; inactive; nohscroll; ]


3.  The mathematical model
********************************

perfuse.ma represents a haemoperfusion column according to the lumped parameter model of Radcliffe (1978):

The model considers a column of volume V, with a blood flow rate Q.  The carbon granules have diameter dp, specific surface area ap and pack in the column with a void fraction e.  For the carbon/sorbate combination under consideration, the external mass transfer coefficient is ke, the intraparticle diffusivity is Ds and the Langmuir isotherm parameters are qm and K1.  To account for axial mixing, the column is modelled as n well mixed tanks in series.  The sorbate concentration at inlet is co.  Asterisks denote concentration values at the sorbent/fluid interface.

The details of the model can be found in Radcliffe(1978).  Modifications to deal with protein bound sorbates are more fully explained in Kelly (1997)
:[font = special1; inactive; nohscroll; ]
 

The model is solved in time-marching fashion, proceeding in time steps DT.  To allow this the model must be discretised, as follows:


DXj/DT = lambda/epsilon * (n(Xj-1-Xj) - DYj/DT)			{1}

DYj/DT = Ne (Xj-Xj*)								{2}

Xj* = Xj - (Ns*psiq/Ne) * (Yj*2-Yj2) / 2Yj				{3}

Yj* = Xj* / ( R + (1-R)Xj* )							{4}



Solution proceeds by the following sequence:

1.  Define initial conditions for Xj and Yj in each cell (j = 1 to n) at dimensionless time T=0

2.  Calculate X1* iteratively from equations {3} and {4}, using the initial values of X1 and Y1.

3.  Calculate DY1/DT from equation {2}, using X1* and the initial values of X1 and Y1.

4.  Calculate the new value of X1 from equation {1}

5.  Calculate the new value of Y1 = (initial value of Y1) + (DY1/DT). DT

6.  Repeat steps 2 to 5 for the remaining cells (j = 2 to n).

7.  Calculate the second time step by repeating steps 2 to 6, using the newly calculated values of Xj and Yj in place of the initial values.

8.  Continue the process for as many time steps as required.
:[font = special1; inactive; endGroup; nohscroll; ]




4.  The program explained
*******************************

This section explains each individual section of the notebook perfuse.ma.  It is not necessary to read this section before using the model, but it may be of interest to anyone who wishes to modify the program.

Initialisation section:  This section ensures that the program runs smoothly.  The code tells Mathematica not to print low-priority warning messages, and also ensures that the variables to be used in the program are not still assigned a value from any previous calculation.

Data input dialogues:  This section contains the coding for the interactive data input dialogue boxes.

Calculate dimensionless parameters:  Calculates the dimensionless parameters required by the model, from the data entered in the previous section.  Parameter names are all chosen to begin with lower case letters, to avoid possible confusion with built-in Mathematica functions, which all begin with upper case letters.

Modify parameters if protein binding:  Allows the model to be used to predict the ability of the haemoperfusion column to remove protein bound solutes. The dimensionless parameters are modified by a factor related to the bound fraction of solute in the solution.

Set initial conditions:  At T=0, both X and Y are zero in all cells of the model.  A step input of X=1 is applied at the inlet to the first cell.

Definition of xstarr(x,y) function:  This section is a subroutine which uses the user defined function, xstarr(x,y) to calculate X* by iteration.  

Main loops:  These loops carry out the time marching calculation steps detailed in section 3.

Plot Output:  Provides plot of Fractional Clearance against T

Manual:  Contains this document.





5.  References
*****************

KELLY, S. (1997):  Design and Evaluation of Perfusion Columns containing Activated Carbons.  MSc Thesis, Strathclyde University, 1997.

RADCLIFFE, D. F. (1978):  Mass Transfer in Haemoperfusion Columns and other Sorbent Based Devices for Blood Detoxification.  PhD Thesis, Strathclyde University, 1978

RADCLIFFE, D. F., GAYLOR, J. D. S. (1981a):  Sorption kinetics in haemoperfusion columns. Part 1: estimation of mass transfer parameters.  Med. & Biol. Eng. & Comput., 19, 617-626, 1981.

RADCLIFFE, D. F., GAYLOR, J. D. S. (1981b):  Sorption kinetics in haemoperfusion columns. Part 2: modelling column performance.  Med. & Biol. Eng. & Comput., 19, 627-637, 1981.

WOLFRAM, S.  (1991):  Mathematica.  Addison Wesley, 1991.
:[font = smalltext; inactive; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 10; ]






written by:  Stuart Kelly, May 1997
^*)